/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.lcm.ILCMLcmCat;
import com.kingdee.eas.fi.lcm.LCMBaseDataSouceEnum;
import com.kingdee.eas.fi.lcm.LCMLcmCatCollection;
import com.kingdee.eas.fi.lcm.LCMLcmCatFactory;
import com.kingdee.eas.fi.lcm.LCMLcmCatInfo;
import com.kingdee.eas.fi.lcm.LCMLcmPropertiesEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class LCMCatDataImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger(LCMCatDataImport.class);
    private static final String BASE_RES = "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource";
    private static final String FA_RES = "com.kingdee.eas.fi.fa.basedata.FaResource";
    private static final String IMP_RES = "com.kingdee.eas.fi.lcm.LCMImportResource";
    private static final int NUMBER_LENGTH = 80;
    private static final int NAME_LENGTH = 80;
    private static final int REMARK_LENGTH = 200;
    private String[] EXP_FIELD_IN_FILE = new String[]{"number", "parent", "groupLevel", "name", "availTime", "lcmProperty", "measureUnit", "description", "creator", "createTime", "numberRule"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"number", "parent.number", "groupLevel", "name", "availTime", "lcmProperty", "measureUnit.number", "description", "creator.number", "createTime", "numberRule"};

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            this.getController(ctx).addnew(coreBaseInfo);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LCMLcmCatFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        String strTemp;
        String message;
        LCMLcmCatInfo info;
        String str;
        block53: {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            str = null;
            info = new LCMLcmCatInfo();
            info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            info.setCompany(ContextUtil.getCurrentFIUnit((Context)ctx));
            boolean isDefCu = "00000000-0000-0000-0000-000000000000CCE7AED4".equals(info.getCU().getId().toString());
            str = this.getDataString(hsData, "number");
            message = null;
            strTemp = "";
            ILCMLcmCat iFactory = (ILCMLcmCat)this.getController(ctx);
            if (str == null || str.trim().length() == 0) {
                message = ResourceBase.getString((String)BASE_RES, (String)"strNumberIsNull", (Locale)ctx.getOriginLocale());
            } else if (str.trim().length() > 80) {
                message = ResourceBase.getString((String)IMP_RES, (String)"numberLenger", (Locale)ctx.getOriginLocale());
            } else {
                info.setNumber(str.trim());
                try {
                    iFactory.checkNumberDup((DataBaseInfo)info);
                }
                catch (Exception e) {
                    message = ResourceBase.getString((String)IMP_RES, (String)"lcmCatNumberDup", (Locale)ctx.getOriginLocale());
                }
            }
            str = this.getDataString(hsData, "name");
            if (str == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)BASE_RES, (String)"strNameIsNull", (Locale)ctx.getOriginLocale());
                message = message == null ? strTemp : message + ";" + strTemp;
            } else if (str.trim().length() > 80) {
                strTemp = ResourceBase.getString((String)IMP_RES, (String)"nameLenger", (Locale)ctx.getOriginLocale());
                message = message == null ? strTemp : message + ";" + strTemp;
            } else if (!StringUtils.isFileName((String)str)) {
                strTemp = ResourceBase.getString((String)BASE_RES, (String)"strIllegalName", (Locale)ctx.getOriginLocale());
                message = message == null ? strTemp : message + ";" + strTemp;
            } else {
                info.setName(str);
                try {
                    iFactory.checkNameDup((DataBaseInfo)info);
                }
                catch (Exception e) {
                    strTemp = ResourceBase.getString((String)IMP_RES, (String)"lcmCatNameDup", (Locale)ctx.getOriginLocale());
                    message = message == null ? strTemp : message + ";" + strTemp;
                }
            }
            str = this.getDataString(hsData, "measureUnit");
            if (str != null && str.trim().length() != 0) {
                MeasureUnitCollection measureUnitColl = null;
                try {
                    measureUnitColl = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(this.getGroupFilter(str));
                }
                catch (BOSException ex) {
                    throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
                }
                if (measureUnitColl == null || measureUnitColl.size() == 0) {
                    strTemp = ResourceBase.getString((String)FA_RES, (String)"noMeasureUnitNumber", (Locale)ctx.getOriginLocale());
                    message = message == null ? strTemp : message + ";" + strTemp;
                } else {
                    info.setMeasureUnit(measureUnitColl.get(0));
                }
            }
            if ((str = this.getDataString(hsData, "lcmProperty")) == null || str.trim().length() == 0) {
                strTemp = ResourceBase.getString((String)IMP_RES, (String)"lcmPropertyIsNull", (Locale)ctx.getOriginLocale());
                message = message == null ? strTemp : message + ";" + strTemp;
            }
            if ((str = this.getDataString(hsData, "parent")) != null && str.trim().length() != 0) {
                LCMLcmCatCollection catColl = null;
                try {
                    catColl = iFactory.getLCMLcmCatCollection(this.getOUFilter(str, aCompanyOrgUnitInfo.getId().toString()));
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                if (catColl == null || catColl.size() == 0) {
                    strTemp = " " + MessageFormat.format(ResourceBase.getString((String)FA_RES, (String)"noParentCat", (Locale)ctx.getOriginLocale()), str);
                    message = this.appendErrMsg(message, strTemp);
                } else {
                    info.setParent(catColl.get(0));
                    int groupLevel = catColl.get(0).getGroupLevel();
                    if (!isDefCu) {
                        try {
                            iFactory.isReferenced((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
                            if (catColl.get(0).getLevel() >= groupLevel) {
                                info.setGroupLevel(groupLevel);
                                break block53;
                            }
                            strTemp = " " + ResourceBase.getString((String)BASE_RES, (String)"LittleLevel", (Locale)ctx.getOriginLocale());
                            message = this.appendErrMsg(message, strTemp);
                        }
                        catch (Exception e) {
                            strTemp = " " + ResourceBase.getString((String)FA_RES, (String)"parentIsRef", (Locale)ctx.getOriginLocale());
                            message = this.appendErrMsg(message, strTemp);
                        }
                    } else if (catColl.get(0).getLevel() < groupLevel) {
                        info.setGroupLevel(groupLevel);
                    } else {
                        strTemp = " " + ResourceBase.getString((String)FA_RES, (String)"inputCatOverGroupLevel", (Locale)ctx.getOriginLocale());
                        message = this.appendErrMsg(message, strTemp);
                    }
                }
            } else if (isDefCu) {
                try {
                    int level = this.getDataInt(hsData, "groupLevel");
                    if (level <= 0) {
                        throw new Exception();
                    }
                    info.setGroupLevel(level);
                }
                catch (Exception e1) {
                    strTemp = ResourceBase.getString((String)FA_RES, (String)"oneControlLevelGreater0", (Locale)ctx.getOriginLocale());
                    message = this.appendErrMsg(message, strTemp);
                }
            } else {
                strTemp = ResourceBase.getString((String)FA_RES, (String)"mustInputParentId", (Locale)ctx.getOriginLocale());
                message = this.appendErrMsg(message, strTemp);
            }
        }
        if (LCMLcmPropertiesEnum.PRIVATELCM.getAlias().equalsIgnoreCase(this.getDataString(hsData, "lcmProperty"))) {
            info.setLcmProperty(LCMLcmPropertiesEnum.PRIVATELCM);
        } else if (LCMLcmPropertiesEnum.PUBLICLCM.getAlias().equalsIgnoreCase(this.getDataString(hsData, "lcmProperty"))) {
            info.setLcmProperty(LCMLcmPropertiesEnum.PUBLICLCM);
        } else if (LCMLcmPropertiesEnum.UN_DAILY_MATERIAL.getAlias().equalsIgnoreCase(this.getDataString(hsData, "lcmProperty"))) {
            info.setLcmProperty(LCMLcmPropertiesEnum.UN_DAILY_MATERIAL);
        } else if (LCMLcmPropertiesEnum.OTHERS.getAlias().equalsIgnoreCase(this.getDataString(hsData, "lcmProperty"))) {
            info.setLcmProperty(LCMLcmPropertiesEnum.OTHERS);
        }
        try {
            BigDecimal limit = this.getDataBigDecimal(hsData, "availTime");
            if (limit != null && limit.doubleValue() < 0.0) {
                throw new Exception();
            }
            info.setAvailTime(limit);
        }
        catch (Exception e1) {
            strTemp = ResourceBase.getString((String)FA_RES, (String)"yearMustGreater0", (Locale)ctx.getOriginLocale());
            message = message == null ? strTemp : message + ";" + strTemp;
        }
        String numberRule = this.getDataString(hsData, "numberRule");
        if (StringUtils.isEmpty((String)numberRule)) {
            strTemp = ResourceBase.getString((String)IMP_RES, (String)"preNumberNotNull", (Locale)ctx.getOriginLocale());
            message = message == null ? strTemp : message + ";" + strTemp;
        } else {
            info.setNumberRule(numberRule);
        }
        str = this.getDataString(hsData, "description");
        if (str.trim().length() > 200) {
            strTemp = ResourceBase.getString((String)IMP_RES, (String)"remarkLenger", (Locale)ctx.getOriginLocale());
            message = message == null ? strTemp : message + ";" + strTemp;
        } else {
            info.setDescription(str);
        }
        if (message != null) {
            throw new TaskExternalException(message);
        }
        Locale currentLocale = ctx.getLocale();
        this.setMutiLang(info, currentLocale, "name", info.getName());
        this.setMutiLang(info, currentLocale, "description", info.getDescription());
        this.setMutiLang(info, currentLocale, "displayName", info.getDisplayName());
        info.setSourceMode(LCMBaseDataSouceEnum.NEW);
        return info;
    }

    private void setMutiLang(LCMLcmCatInfo info, Locale currentLocale, String property, Object value) {
        if (value == null) {
            return;
        }
        if (LocaleUtils.locale_L1.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", value);
            info.put(property + "_l3", value);
        } else if (LocaleUtils.locale_L2.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", value);
            info.put(property + "_l3", STConverter.sc2tc((String)((String)value)));
        } else if (LocaleUtils.locale_L3.equals(currentLocale)) {
            info.put(property + "_l1", value);
            info.put(property + "_l2", STConverter.tc2sc((String)((String)value)));
            info.put(property + "_l3", value);
        }
    }

    private EntityViewInfo getGroupFilter(String str) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo getCUFilter(String str, String cuId) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("CU", (Object)cuId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private EntityViewInfo getOUFilter(String str, String companyId) {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)str, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filterItem = new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        filter.setMaskString("#0 and #1");
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        return view;
    }

    private String getDataString(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataString((Hashtable)hsData, (String)fieldName);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataBigDecimal((Hashtable)hsData, (String)fieldName);
    }

    private int getDataInt(Hashtable hsData, String fieldName) {
        return DataImportTools.getDataint((Hashtable)hsData, (String)fieldName);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            Hashtable result = this.setDataForExport(this.EXP_FIELD_IN_FILE, this.EXP_FIELD_IN_QUERY, rs);
            if (result.get("lcmProperty") != null) {
                int amortizeMode = Integer.parseInt(result.get("lcmProperty").toString());
                result.put("lcmProperty", LCMLcmPropertiesEnum.getEnum(amortizeMode).getAlias());
            }
            return result;
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.lcm.LCMLcmCatQuery";
    }

    private Hashtable setDataForExport(String[] fields, String[] keys, IRowSet rs) throws SQLException {
        int i;
        if (fields.length != keys.length) {
            throw new IllegalArgumentException("field length not match key length :" + fields.length + " " + keys.length);
        }
        Hashtable<String, String> result = new Hashtable<String, String>();
        HashMap<String, Integer> typeMap = new HashMap<String, Integer>();
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            int columnType = rs.getMetaData().getColumnType(i);
            String columnName = rs.getMetaData().getColumnName(i);
            typeMap.put(columnName, new Integer(columnType));
        }
        for (i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String key = keys[i];
            Object obj = rs.getObject(key);
            if (obj == null) continue;
            int type = (Integer)typeMap.get(key);
            if (type == 91 || type == 92 || type == 93) {
                Date date = rs.getDate(key);
                result.put(field, LCMCatDataImport.dateToString(date));
                continue;
            }
            if (type == 3 || type == 2) {
                result.put(field, rs.getBigDecimal(key).toString());
                continue;
            }
            result.put(field, rs.getString(key));
        }
        return result;
    }

    private static String dateToString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    private String appendErrMsg(String message, String strTemp) {
        message = message == null ? strTemp : message + ";" + strTemp;
        return message;
    }
}

