/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.lcm.LCMAmortizeModeEnum;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailFactory;
import com.kingdee.eas.fi.lcm.LCMConsumeDetailInfo;
import com.kingdee.eas.fi.lcm.LCMMonCardFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class LCMConsumeDetailImport
extends AbstractDataTransmission {
    private final BigDecimal ZERO = new BigDecimal("0");
    private static final int STR_LENGTH = 80;
    private String cardNumber;
    private PeriodInfo currenctPeriod;
    protected CompanyOrgUnitInfo company;
    private int baseScale = 2;
    private Integer quantityScale;
    private CurrencyInfo baseCurrency;
    private HashMap depInfoBufMap = new HashMap();
    private HashMap perInfoBufMap = new HashMap();
    private Boolean isInitEnd;
    private String[] EXP_FIELD_IN_FILE = new String[]{"lcmCard", "useDate", "useDepartment", "usePerson", "useAmt", "remark", "address", "number"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"number", "consumeDetail.useDate", "useDepartment.number", "usePerson.number", "consumeDetail.useAmt", "consumeDetail.remark", "consumeDetail.address", "consumeDetail.number"};

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LCMConsumeDetailFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
        LCMConsumeDetailInfo detailInfo = (LCMConsumeDetailInfo)coreBaseInfo;
        BigDecimal useamt = detailInfo.getUseAmt();
        StringBuffer sql = new StringBuffer();
        sql.append(" update t_lcm_lcmmoncard set fusableamt = fusableamt - ?, fuseStatus = ?");
        sql.append(" where fnumber = ? and fcompanyid = ? and fperiodid is null");
        SqlParams sqlPara = new SqlParams();
        sqlPara.addBigDecimal(useamt);
        sqlPara.addInt(1);
        sqlPara.addString(detailInfo.getMonCard().getNumber());
        sqlPara.addString(this.company.getId().toString());
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            DBUtil.execute((String)sql.toString(), (SqlParams)sqlPara, (Connection)conn);
        }
        catch (SQLException e) {
            throw new TaskExternalException("SQLException: " + e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        if (this.company == null) {
            this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (!this.company.isIsBizUnit()) {
            throw new TaskExternalException(this.getResource(ctx, "IsNotOnlyUnion"));
        }
        try {
            if (this.isInitEnd == null) {
                this.isInitEnd = new Boolean(SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company));
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        if (this.isInitEnd.booleanValue()) {
            throw new TaskExternalException(this.getResource(ctx, "assetInitialization"));
        }
        String[] STRING_FIELDS = new String[]{"remark", "number"};
        this.checkStrLength(ctx, data, STRING_FIELDS);
        this.initScale(ctx);
        this.cardNumber = this.getValue(ctx, data, "lcmCard", this.getResource(ctx, "monCard"), false);
        LCMMonCardInfo card = this.getLCMMonCardInfo(ctx, this.cardNumber);
        LCMConsumeDetailInfo info = new LCMConsumeDetailInfo();
        info.setMonCard(card);
        FaDataImportUtils.setDateTimeData((Context)ctx, (Map)data, (String[])new String[]{"useDate"}, (String[])new String[]{"useDate"}, (String[])new String[]{this.getResource(ctx, "useDate")}, (CoreBaseInfo)info);
        FaDataImportUtils.setStringData((Context)ctx, (Map)data, (String[])STRING_FIELDS, (String[])new String[]{"remark", "number"}, (String[])new String[]{this.getResource(ctx, "remark"), this.getResource(ctx, "consumeNumber")}, (CoreBaseInfo)info);
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])new String[]{"useAmt"}, (String[])new String[]{"useAmt"}, (String[])new String[]{this.getResource(ctx, "useAmt")}, (CoreBaseInfo)info, (boolean)false, (int)this.quantityScale);
        String depNumber = this.getValue(data, "useDepartment");
        String depInfoKey = "DEP_" + depNumber;
        if (!this.depInfoBufMap.containsKey(depInfoKey)) {
            this.depInfoBufMap.put(depInfoKey, FaDataImportUtils.getAdminOrgUnitInfo((Context)ctx, (String)depNumber, (String)this.getResource(ctx, "cuInfo")));
        }
        info.setUseDepartment((AdminOrgUnitInfo)this.depInfoBufMap.get(depInfoKey));
        String perNumber = this.getValue(data, "usePerson");
        String perInfoKey = "PER_" + perNumber;
        if (!this.perInfoBufMap.containsKey(perInfoKey)) {
            this.perInfoBufMap.put(perInfoKey, FaDataImportUtils.getPersonInfo((Context)ctx, (String)perNumber));
        }
        info.setUsePerson((PersonInfo)this.perInfoBufMap.get(perInfoKey));
        String addressNumber = this.getValue(data, "address");
        if (addressNumber != null && addressNumber.trim().length() > 0) {
            AddressInfo addressInfo = FaDataImportUtils.getAddressInfo((Context)ctx, (String)this.company.getCU().getId().toString(), (String)addressNumber);
            info.setStoreAdress(addressInfo);
        }
        this.verfyIsNull(ctx, info);
        this.verify(ctx, card, info);
        BigDecimal useAmount = info.getUseAmt().multiply(card.getUnitPrice()).multiply(card.getExRate());
        if (card.getUsableAmt().doubleValue() == info.getUseAmt().doubleValue()) {
            useAmount = card.getLocalAmount().subtract(card.getAssetAmt().subtract(info.getUseAmt()).multiply(card.getUnitPrice()).multiply(card.getExRate()));
        }
        BigDecimal amortizedAmount = useAmount = useAmount.setScale(this.baseScale, 4);
        if (card.getAmortizeMode().equals((Object)LCMAmortizeModeEnum.EQUAL_SPILT)) {
            amortizedAmount = useAmount.multiply(new BigDecimal(0.5));
        }
        info.setUseAmount(useAmount);
        info.setAmortizedAmount(amortizedAmount);
        info.setAmortizeAmount(useAmount.subtract(amortizedAmount));
        return info;
    }

    protected Integer getEffectedStatus() {
        return new Integer(2);
    }

    private void verfyIsNull(Context ctx, LCMConsumeDetailInfo info) throws TaskExternalException {
        if (info.getUseDate() == null) {
            this.abort(ctx, MessageFormat.format(this.getResource(ctx, "columnCanNotNull"), this.getResource(ctx, "useDate")));
        }
        if (info.getUseDepartment() == null) {
            this.abort(ctx, this.getResource(ctx, "useDepartmentIsNull"));
        }
        if (info.getUseAmt() == null) {
            this.abort(ctx, MessageFormat.format(this.getResource(ctx, "columnCanNotNull"), this.getResource(ctx, "useAmt")));
        }
    }

    protected void checkStrLength(Context ctx, Hashtable data, String[] fields) throws TaskExternalException {
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            String value = this.getValue(data, fields[i]);
            if (value == null || value.length() <= 80) continue;
            this.abort(ctx, this.getResource(ctx, fields[i]) + this.getResource(ctx, "strLenger"));
        }
    }

    private void verify(Context ctx, LCMMonCardInfo card, LCMConsumeDetailInfo info) throws TaskExternalException {
        if (card.getAccountDate() != null && info.getUseDate().before(card.getAccountDate())) {
            this.abort(ctx, this.getResource(ctx, "useDateBeforeAccountDate"));
        }
        if (this.currenctPeriod == null) {
            try {
                this.currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if (this.currenctPeriod != null && !DateTimeUtils.dayBefore((Date)info.getUseDate(), (Date)this.currenctPeriod.getBeginDate())) {
            this.abort(ctx, this.getResource(ctx, "useDateBFStartPeriod"));
        }
        if (info.getUseAmt().compareTo(this.ZERO) <= 0) {
            this.abort(ctx, this.getResource(ctx, "useAmtMoreThanZero"));
        }
        if (info.getUseAmt().compareTo(card.getUsableAmt()) > 0) {
            this.abort(ctx, this.getResource(ctx, "useAmtMoreThanUsableAmt"));
        }
    }

    private String getValue(Map data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = ((DataToken)data.get((Object)fieldName)).data;
        return obj == null ? null : obj.toString();
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result;
        Object obj = null;
        obj = data.get(fieldName) == null ? null : ((DataToken)data.get((Object)fieldName)).data;
        String string = result = obj == null ? null : obj.toString();
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            this.abort(ctx, MessageFormat.format(this.getResource(ctx, "columnCanNotNull"), fieldCHN));
        }
        return result;
    }

    private void abort(Context ctx, String message) throws TaskExternalException {
        throw new TaskExternalException(message + "\t" + this.getResource(ctx, "number") + this.cardNumber);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            if (this.company == null) {
                this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            this.initScale(ctx);
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(this.baseScale));
            precisions.put("quantityScale", this.quantityScale);
            return FaDataImportUtils.setDataForExport((String[])this.EXP_FIELD_IN_FILE, (String[])this.EXP_FIELD_IN_QUERY, (IRowSet)rs, precisions);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void initScale(Context ctx) throws TaskExternalException {
        try {
            if (this.baseCurrency == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("precision"));
                this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId()), sic);
                this.assertNotNull(ctx, this.baseCurrency, this.getResource(ctx, "standardMondeyIsNull"));
                this.baseScale = this.baseCurrency.getPrecision();
            }
            if (this.quantityScale == null) {
                HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
                ObjectUuidPK pk = new ObjectUuidPK(this.company.getId());
                paramKeyMap.put("LCM_001", pk);
                String tmpValue = (String)ParamManager.getParamHashMap((Context)ctx, paramKeyMap).get("LCM_001");
                this.quantityScale = tmpValue != null ? Integer.valueOf(tmpValue) : new Integer(0);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private LCMMonCardInfo getLCMMonCardInfo(Context ctx, String cardNumber) throws TaskExternalException {
        String oql = "SELECT id,number,unitPrice,usableAmt,assetAmt,localAmount,exRate,accountDate,amortizeMode WHERE NUMBER = '" + cardNumber + "' AND company.id ='" + this.company.getId() + "' and period.id is null ";
        try {
            return LCMMonCardFactory.getLocalInstance(ctx).getLCMMonCardInfo(oql);
        }
        catch (ObjectNotFoundException obje) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getResource(ctx, "pass"));
            buffer.append(" [").append(this.getResource(ctx, "companyDis")).append("] ");
            buffer.append(this.getResource(ctx, "noMatch")).append(this.getResource(ctx, "cardInfo"));
            throw new TaskExternalException(buffer.toString() + " " + this.getResource(ctx, "number") + cardNumber);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("period.id", null));
        return filter;
    }

    private void assertNotNull(Context ctx, Object property, String msg) throws TaskExternalException {
        if (property == null) {
            this.abort(ctx, msg);
        }
        if (property instanceof String && property.toString().length() == 0) {
            this.abort(ctx, msg);
        }
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.lcm.LCMConsumeDetailExpQuery";
    }

    private String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMImportResource", (String)resName, (Locale)ctx.getOriginLocale());
    }
}

