/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.fi.lcm.app.dataimp.LCMMonCardDataImport;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;

public class LCMCurCardDataImport
extends LCMMonCardDataImport {
    @Override
    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LCMCurCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IObjectPK iobjectPK;
            boolean isFirstSubmit = false;
            if (coreBaseInfo.getId() != null) {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
                iobjectPK = new ObjectUuidPK(coreBaseInfo.getId());
            } else {
                iobjectPK = this.getController(ctx).addnew(coreBaseInfo);
                isFirstSubmit = true;
            }
            LCMCurCardInfo cardInfo = (LCMCurCardInfo)coreBaseInfo;
            String cardId = "'" + iobjectPK + "'";
            HashSet<IObjectPK> cardSet = new HashSet<IObjectPK>();
            cardSet.add(iobjectPK);
            this.insertIntoMoncardFromCurcard(ctx, cardInfo, cardId, isFirstSubmit, cardSet);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        LCMMonCardInfo _moncard = (LCMMonCardInfo)super.transmit(data, ctx);
        LCMCurCardInfo _curcard = LCMUtils.MonCard2CurCard(_moncard);
        _curcard.setId(_moncard.getId());
        return _curcard;
    }

    @Override
    public FilterInfo getExportFilterForQuery(Context ctx) {
        return FaDataImportUtils.getFilterForExp((Context)ctx, (FilterInfo)super.getExportFilterForQuery(ctx), (boolean)false);
    }

    @Override
    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.lcm.LCMCurCardExpQuery";
    }

    @Override
    protected boolean isInitCard() {
        return false;
    }

    @Override
    protected void checkAccountDate(Context ctx, LCMMonCardInfo card) throws TaskExternalException {
        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        try {
            Map lcmParam = this.getLCMParameter(ctx);
            PeriodInfo curPeriod = super.getCurrentPeriod(ctx);
            String canAddCard = (String)lcmParam.get("LCM_014");
            if (canAddCard == null || canAddCard.trim().length() == 0 || canAddCard.trim().equalsIgnoreCase("false")) {
                if (card.getAccountDate() == null) {
                    this.abort(ctx, super.getResource(ctx, "dateCanNotNull"));
                } else {
                    Date buyDate;
                    Date accountDate = card.getAccountDate();
                    this.verifyAcctDateWhenInit(ctx, accountDate);
                    if (accountDate.before(curPeriod.getBeginDate()) || accountDate.after(curPeriod.getEndDate())) {
                        this.abort(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"accDateNotInCurrPeriod", (Locale)ctx.getLocale()));
                    }
                    if (card.getBuyDate() != null && DateTimeUtils.dayAfter((Date)(buyDate = card.getBuyDate()), (Date)accountDate)) {
                        this.abort(ctx, this.getResource(ctx, "buyDateLessPassEntriesData"));
                    }
                }
            } else if (card.getAccountDate() == null) {
                this.abort(ctx, super.getResource(ctx, "dateCanNotNull"));
            } else {
                Date buyDate;
                PeriodInfo newPeriod;
                Date accountDate = card.getAccountDate();
                if (accountDate.before(curPeriod.getBeginDate())) {
                    this.abort(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"accDateNotBeforeCurrPeriod", (Locale)ctx.getLocale()));
                }
                if (accountDate != null && (newPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)accountDate, (CompanyOrgUnitInfo)currentCompany)) == null) {
                    this.abort(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"accDateNotInSystemPeriod", (Locale)ctx.getLocale()));
                }
                if (card.getBuyDate() != null && DateTimeUtils.dayAfter((Date)(buyDate = card.getBuyDate()), (Date)accountDate)) {
                    this.abort(ctx, this.getResource(ctx, "buyDateLessPassEntriesData"));
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void insertIntoMoncardFromCurcard(Context ctx, LCMCurCardInfo cardInfo, String cardId, boolean isFirstOpt, HashSet cardSet) throws BOSException, EASBizException {
        PeriodInfo cardPeriod = cardInfo.getLcmPeriod();
        cardPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(cardPeriod.getId()));
        String lastestPeriodNumber = LCMUtils.getLCMLastestPeriod(ctx, cardInfo.getCompany());
        int lastestNumber = 0;
        try {
            lastestNumber = lastestPeriodNumber == null || "".equals(lastestPeriodNumber) ? 0 : Integer.parseInt(lastestPeriodNumber);
        }
        catch (Exception e) {
            lastestNumber = 0;
        }
        if (lastestPeriodNumber == null || "".equals(lastestPeriodNumber)) {
            return;
        }
        if (lastestNumber >= cardPeriod.getNumber()) {
            if (!isFirstOpt) {
                LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, cardInfo.getCompany(), cardSet);
            }
            Object[] param = null;
            for (int i = cardPeriod.getNumber(); i <= lastestNumber; ++i) {
                StringBuffer sql = new StringBuffer();
                sql.append("select FID from t_bd_period where fnumber = ? and ftypeid = ?");
                param = new Object[]{new Integer(i), cardPeriod.getPeriodType().getId().toString()};
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                String strPeriodId = null;
                try {
                    if (rs.next()) {
                        strPeriodId = rs.getString("FID");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                if (strPeriodId == null || "".equals(strPeriodId)) continue;
                strPeriodId = "'" + strPeriodId + "'";
                sql = new StringBuffer();
                sql.append("Insert into T_LCM_LCMMonCard                                        \r\n");
                sql.append("(                                                                   \r\n");
                sql.append("  FID,                                                              \r\n");
                sql.append("  FPeriodID,                                                        \r\n");
                sql.append("  FCurCardID,                                                       \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(")                                                                   \r\n");
                sql.append("Select                                                              \r\n");
                sql.append(FaLocalUtils.newBosID((Context)ctx, (String)new LCMMonCardInfo().getBOSType().toString()) + " as FID, \r\n");
                sql.append(strPeriodId).append(" as FPeriodID,                                  \r\n");
                sql.append("  FID as FCurCardID,                                         \r\n");
                sql.append(FaLocalUtils.getQueryColumn((Context)ctx, (CoreBaseInfo)new LCMCurCardInfo(), (boolean)false, (String)"") + "\r\n");
                sql.append(" From T_LCM_LCMCurCard                                              \r\n");
                sql.append("Where FID = ").append(cardId).append("                              \r\n");
                DbUtil.execute((Context)ctx, (String)sql.toString());
            }
        } else {
            LCMUtils.deleteCurPeriodandLaterPeriodMoncard(ctx, cardInfo.getCompany(), cardSet);
        }
    }
}

