/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.lcm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxFactory;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeAux;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.manage.app.dataimp.FaDataImportUtils;
import com.kingdee.eas.fi.lcm.LCMAlterModeFactory;
import com.kingdee.eas.fi.lcm.LCMAlterModeInfo;
import com.kingdee.eas.fi.lcm.LCMAmortizeModeEnum;
import com.kingdee.eas.fi.lcm.LCMCardInfo;
import com.kingdee.eas.fi.lcm.LCMCurCardCollection;
import com.kingdee.eas.fi.lcm.LCMCurCardFactory;
import com.kingdee.eas.fi.lcm.LCMCurCardInfo;
import com.kingdee.eas.fi.lcm.LCMLcmCatFactory;
import com.kingdee.eas.fi.lcm.LCMLcmCatInfo;
import com.kingdee.eas.fi.lcm.LCMMonCardCollection;
import com.kingdee.eas.fi.lcm.LCMMonCardFactory;
import com.kingdee.eas.fi.lcm.LCMMonCardInfo;
import com.kingdee.eas.fi.lcm.LCMSourceTypeEnum;
import com.kingdee.eas.fi.lcm.LCMUseStatusEnum;
import com.kingdee.eas.fi.lcm.LCMUtils;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.EffectedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class LCMMonCardDataImport
extends AbstractDataTransmission {
    private static final Logger logger = Logger.getLogger(LCMMonCardDataImport.class);
    private static final int STR_LENGTH = 80;
    private static final BigDecimal ZERO = new BigDecimal("0");
    private String[] EXP_FIELD_IN_FILE = new String[]{"assetCat", "number", "name", "assetAmt", "measureUnit", "buyDate", "accountDate", "sourceMode", "useStatus", "address", "specs", "pArea", "mfr", "supplier", "dept", "keeper", "currency", "exRate", "unitPrice", "originAmount", "localAmount", "life", "amortizeMode", "accountAsset", "description", "creator", "creatTime"};
    private String[] EXP_FIELD_IN_QUERY = new String[]{"assetCat.number", "number", "name", "assetAmt", "measureUnit.number", "buyDate", "accountDate", "sourceMode.number", "useStatus", "address", "specs", "pArea", "mfr", "supplier.number", "dept.number", "keeper.number", "currency.number", "exRate", "unitPrice", "originAmount", "localAmount", "life", "amortizeMode", "accountAsset.number", "description", "creator.number", "createTime"};
    private String cardNumber;
    private CurrencyInfo baseCurrency;
    private CurrencyInfo currency;
    protected CompanyOrgUnitInfo company;
    private Boolean isRelAccount;
    private Boolean isInitEnd;
    private PeriodInfo currenctPeriod;
    private Date periodDate;
    private int rateScale = 2;
    private int originScale = 2;
    private int baseScale = 2;
    private Integer quantityScale;
    private String cu;
    private String fi;
    Map parameter;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return LCMMonCardFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable data, Context ctx) throws TaskExternalException {
        String addressNumber;
        if (this.company == null) {
            this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        }
        if (!this.company.isIsBizUnit()) {
            throw new TaskExternalException(this.getResource(ctx, "IsNotOnlyUnion"));
        }
        if (this.isInitCard()) {
            try {
                if (this.isInitEnd == null) {
                    this.isInitEnd = new Boolean(SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company));
                }
            }
            catch (Exception ex) {
                throw new TaskExternalException(ex.getMessage());
            }
            if (this.isInitEnd.booleanValue()) {
                throw new TaskExternalException(this.getResource(ctx, "assetInitialization"));
            }
        }
        String[] STRING_FIELDS = new String[]{"number", "name", "specs", "pArea", "mfr", "life", "address", "description"};
        this.checkStrLength(ctx, data, STRING_FIELDS);
        String[] FIELDS_BIGDECIMAL_LOCAL = new String[]{"localAmount", "assetAmt", "exRate"};
        String[] FIELDS_BIGDECIMAL_ORIG = new String[]{"originAmount", "unitPrice"};
        String[] DECIMAL_LOCAL_CHN = new String[]{this.getResource(ctx, "localAmount"), this.getResource(ctx, "assetAmt"), this.getResource(ctx, "exRate")};
        String[] DECIMAL_ORIG_CHN = new String[]{this.getResource(ctx, "originAmount"), this.getResource(ctx, "unitPrice")};
        if (this.cu == null) {
            this.cu = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        }
        this.fi = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        try {
            if (this.isRelAccount == null) {
                this.isRelAccount = new Boolean(SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        this.cardNumber = this.getValue(ctx, data, "number", this.getResource(ctx, "number"), false);
        this.verifyNum(ctx, this.cardNumber);
        this.currency = FaDataImportUtils.getCurrencyInfo((Context)ctx, (String)this.getBaseDataOql(this.getValue(data, "currency"), true, false));
        this.assertNotNull(ctx, this.currency, this.getResource(ctx, "currencyIsNull"));
        this.initScale(ctx);
        LCMMonCardInfo card = new LCMMonCardInfo();
        String[] DATE_FIELDS = new String[]{"buyDate", "accountDate", "creatTime"};
        String[] DATE_OBJS = new String[]{"buyDate", "accountDate", "creatTime"};
        String[] DATE_CHNS = new String[]{this.getResource(ctx, "buyDate"), this.getResource(ctx, "accountDate")};
        String[] STRING_OBJS = new String[]{"number", "name", "specs", "pArea", "mfr", "life", "address", "description"};
        String[] STRING_CHN = new String[]{this.getResource(ctx, "number"), this.getResource(ctx, "name"), this.getResource(ctx, "specs"), this.getResource(ctx, "pArea"), this.getResource(ctx, "mfr"), this.getResource(ctx, "description")};
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])FIELDS_BIGDECIMAL_LOCAL, (String[])FIELDS_BIGDECIMAL_LOCAL, (String[])DECIMAL_LOCAL_CHN, (CoreBaseInfo)card, (boolean)false, (int)this.baseScale);
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])FIELDS_BIGDECIMAL_ORIG, (String[])FIELDS_BIGDECIMAL_ORIG, (String[])DECIMAL_ORIG_CHN, (CoreBaseInfo)card, (boolean)false, (int)this.originScale);
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])new String[]{"assetAmt"}, (String[])new String[]{"assetAmt"}, (String[])new String[]{this.getResource(ctx, "assetAmt")}, (CoreBaseInfo)card, (boolean)false, (int)this.quantityScale);
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])new String[]{"exRate"}, (String[])new String[]{"exRate"}, (String[])new String[]{this.getResource(ctx, "rate")}, (CoreBaseInfo)card, (boolean)false, (int)this.rateScale);
        FaDataImportUtils.setBigDecimalData((Context)ctx, (Map)data, (String[])new String[]{"originAmount"}, (String[])new String[]{"originAmount"}, (String[])new String[]{this.getResource(ctx, "originAmount")}, (CoreBaseInfo)card, (boolean)false, (int)this.originScale);
        FaDataImportUtils.setDateTimeData((Context)ctx, (Map)data, (String[])DATE_FIELDS, (String[])DATE_OBJS, (String[])DATE_CHNS, (CoreBaseInfo)card);
        FaDataImportUtils.setStringData((Context)ctx, (Map)data, (String[])STRING_FIELDS, (String[])STRING_OBJS, (String[])STRING_CHN, (CoreBaseInfo)card);
        FaDataImportUtils.setStringData((Context)ctx, (Map)data, (String[])new String[]{"name"}, (String[])new String[]{"name"}, (String[])new String[]{this.getResource(ctx, "name")}, (CoreBaseInfo)card, (boolean)false, null);
        this.setCardInfoOverrided(ctx, card);
        try {
            LCMLcmCatInfo lcmCat = (LCMLcmCatInfo)LCMLcmCatFactory.getLocalInstance(ctx).getValue(this.getCatOql(this.getValue(ctx, data, "assetCat", this.getResource(ctx, "assetCat"), false)));
            card.setAssetCat(lcmCat);
        }
        catch (Exception e) {
            if (e instanceof ObjectNotFoundException) {
                this.abort(ctx, MessageFormat.format(this.getResource(ctx, "notFind"), this.getValue(data, "assetCat"), this.getResource(ctx, "assetCat")));
            }
            throw new TaskExternalException(e.getMessage());
        }
        try {
            if (this.getValue(data, "sourceMode") == null || this.getValue(data, "sourceMode").trim().equals("")) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"12_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()) + "\t");
            }
            LCMAlterModeInfo lcmAlterMode = (LCMAlterModeInfo)LCMAlterModeFactory.getLocalInstance(ctx).getValue(this.getOuIsolateOql(this.getValue(data, "sourceMode"), true, true));
            card.setSourceMode(lcmAlterMode);
        }
        catch (Exception e) {
            if (e instanceof ObjectNotFoundException) {
                this.abort(ctx, MessageFormat.format(this.getResource(ctx, "notFind"), this.getValue(data, "sourceMode"), this.getResource(ctx, "sourceMode")));
            }
            this.abort(ctx, e.getMessage());
        }
        card.setMeasureUnit(FaDataImportUtils.getMeasureUnitInfo((Context)ctx, (String)this.getBaseDataOql(this.getValue(data, "measureUnit"), false, false)));
        card.setDept(FaDataImportUtils.getAdminOrgUnitInfo((Context)ctx, (String)this.getValue(data, "dept"), (String)this.getResource(ctx, "cuInfo")));
        card.setKeeper(FaDataImportUtils.getPersonInfo((Context)ctx, (String)this.getValue(data, "keeper")));
        UserInfo creator = this.getUserInfo(ctx, this.getValue(data, "creator"));
        card.setCreator(creator == null ? ContextUtil.getCurrentUserInfo((Context)ctx) : creator);
        card.setCurrency(this.currency);
        card.setAccountAsset(FaDataImportUtils.getAcctViewInfo((Context)ctx, (String)this.getValue(data, "accountAsset")));
        card.setVoucher(null);
        card.setLcmPeriod(null);
        card.setCurCard(null);
        card.setPeriod(null);
        card.setCompany(this.company);
        CtrlUnitInfo cuInfo = new CtrlUnitInfo();
        cuInfo.setId(BOSUuid.read((String)this.cu));
        card.setCU(cuInfo);
        UserInfo currentUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        card.setHandler(currentUser);
        card.setAuditor(null);
        card.setUseStatus(LCMUseStatusEnum.NOT_USE);
        if (LCMAmortizeModeEnum.ONCE.getAlias().equalsIgnoreCase(this.getValue(data, "amortizeMode"))) {
            card.setAmortizeMode(LCMAmortizeModeEnum.ONCE);
        } else if (LCMAmortizeModeEnum.EQUAL_SPILT.getAlias().equalsIgnoreCase(this.getValue(data, "amortizeMode"))) {
            card.setAmortizeMode(LCMAmortizeModeEnum.EQUAL_SPILT);
        }
        if (card.getAmortizeMode() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"13_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()) + "\t" + this.getResource(ctx, "number") + "[" + (this.cardNumber == null ? "" : this.cardNumber) + "]");
        }
        String supplierNumber = this.getValue(data, "supplier");
        if (supplierNumber != null && supplierNumber.trim().length() > 0) {
            SupplierInfo supplierInfo = FaDataImportUtils.getSupplierInfo((Context)ctx, (String)this.getBaseDataOql(supplierNumber, true, false));
            card.setSupplier(supplierInfo);
        }
        if ((addressNumber = this.getValue(data, "address")) != null && addressNumber.trim().length() > 0) {
            AddressInfo addressInfo = FaDataImportUtils.getAddressInfo((Context)ctx, (String)this.company.getCU().getId().toString(), (String)addressNumber);
            card.setStoreAdress(addressInfo);
        }
        this.assertNotNull(ctx, card.getAssetCat(), this.getResource(ctx, "assetCatCanNotNull"));
        this.assertNotNull(ctx, card.getMeasureUnit(), this.getResource(ctx, "measureUnitCanNotNull"));
        this.assertNotNull(ctx, card.getSourceMode(), this.getResource(ctx, "originMeasureCanNotNull"));
        this.assertNotNull(ctx, (Object)card.getUseStatus(), this.getResource(ctx, "useStatusCanNotNull"));
        if (!StringUtils.isFileName((String)card.getName())) {
            this.abort(ctx, this.getResource(ctx, "cardNameillegel"));
        }
        this.verfyAmt(ctx, card);
        card.setUsableAmt(card.getAssetAmt());
        card.setFiVouchered(false);
        if (this.isInitCard()) {
            card.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            card.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
        } else {
            card.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
            card.setEffectedStatus(EffectedStatusEnum.TEMPSTORE);
            this.setLCMPeriod(ctx, card);
            card.setSourceType(LCMSourceTypeEnum.newCard);
        }
        card.setDeletedStatus(DeletedStatusEnum.NORMAL);
        card.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        return card;
    }

    private void setLCMPeriod(Context ctx, LCMMonCardInfo card) throws TaskExternalException {
        try {
            Map lcmParam = this.getLCMParameter(ctx);
            String canAddCard = (String)lcmParam.get("LCM_014");
            if (canAddCard == null || canAddCard.trim().length() == 0 || canAddCard.trim().equalsIgnoreCase("false")) {
                card.setLcmPeriod(this.currenctPeriod);
            } else {
                Date accountDate = card.getAccountDate();
                if (accountDate != null) {
                    PeriodInfo newPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (Date)accountDate, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
                    if (newPeriod == null) {
                        this.abort(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMCardResource", (String)"accDateNotInSystemPeriod", (Locale)ctx.getOriginLocale()));
                    }
                    card.setLcmPeriod(newPeriod);
                } else {
                    this.abort(ctx, this.getResource(ctx, "dateCanNotNull"));
                }
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void assertNotNull(Context ctx, Object property, String msg) throws TaskExternalException {
        if (property == null) {
            this.abort(ctx, msg);
        }
        if (property instanceof String && property.toString().length() == 0) {
            this.abort(ctx, msg);
        }
    }

    protected void abort(Context ctx, String msg) throws TaskExternalException {
        if (this.cardNumber == null) {
            throw new TaskExternalException(msg + "\t");
        }
        throw new TaskExternalException(this.getResource(ctx, "number") + "[" + (this.cardNumber == null ? "" : this.cardNumber) + "]\uff1a" + msg);
    }

    private void verfyAmt(Context ctx, LCMMonCardInfo card) throws TaskExternalException {
        BigDecimal tmpValue1;
        BigDecimal rate;
        BigDecimal originAmount;
        BigDecimal unitPrice;
        if (!StringUtils.isFileName((String)card.getName())) {
            throw new TaskExternalException(this.getResource(ctx, "nameIllegal") + ": " + card.getName());
        }
        if (!card.getSourceMode().isIsLeaf()) {
            this.abort(ctx, this.getResource(ctx, "originMeasureCanOnlyLeaf"));
        }
        if (card.getBuyDate() == null) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"14_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()) + "\t" + this.getResource(ctx, "number") + "[" + (this.cardNumber == null ? "" : this.cardNumber) + "]");
        }
        if (!card.getAssetCat().isIsLeaf()) {
            this.abort(ctx, this.getResource(ctx, "assetCatIsNotDetailAccount"));
        }
        if (card.getAccountAsset() == null) {
            if (this.isRelAccount.booleanValue()) {
                this.abort(ctx, this.getResource(ctx, "unionLedgerCanNotNull"));
            }
        } else if (!card.getAccountAsset().isIsLeaf()) {
            this.abort(ctx, this.getResource(ctx, "assetAccountIsNotDetailAccount"));
        }
        this.checkAccountDate(ctx, card);
        BigDecimal quantity = card.getAssetAmt();
        if (quantity.compareTo(ZERO) <= 0) {
            this.abort(ctx, this.getResource(ctx, "assetAmountGreater0"));
        }
        if ((unitPrice = card.getUnitPrice()).compareTo(ZERO) < 0) {
            this.abort(ctx, this.getResource(ctx, "unitPriceGreater"));
        }
        if ((originAmount = card.getOriginAmount()) == null || originAmount.compareTo(ZERO) < 0) {
            this.abort(ctx, this.getResource(ctx, "originAmtGreater0"));
        }
        if ((rate = card.getExRate()).compareTo(ZERO) <= 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"15_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()) + "\t" + this.getResource(ctx, "number") + "[" + (this.cardNumber == null ? "" : this.cardNumber) + "]");
        }
        BigDecimal localAmount = card.getLocalAmount();
        if (localAmount == null || localAmount.compareTo(ZERO) < 0) {
            this.abort(ctx, this.getResource(ctx, "originAmtGreater1"));
        }
        if ((tmpValue1 = quantity.multiply(unitPrice).setScale(this.originScale, 4)).compareTo(originAmount) != 0 && unitPrice.compareTo(originAmount.divide(quantity, this.originScale, 4)) != 0) {
            this.abort(ctx, this.getResource(ctx, "originPriceNotEquel1"));
        }
        if (card.getCompany().getBaseExchangeTable() == null) {
            this.abort(ctx, this.getResource(ctx, "noExchangeTableInCompany"));
        }
        BigDecimal tmpValue2 = ZERO;
        if (card.getCurrency().getId().equals((Object)card.getCompany().getBaseCurrency().getId())) {
            tmpValue2 = originAmount.multiply(new BigDecimal("1")).setScale(this.baseCurrency.getPrecision(), 4);
            if (tmpValue2.compareTo(localAmount) != 0) {
                this.abort(ctx, this.getResource(ctx, "originPriceNotEquel2"));
            }
        } else {
            ExchangeAuxInfo exChangeAuxinfo = null;
            try {
                IExchangeAux iExchangeAux = ExchangeAuxFactory.getLocalInstance((Context)ctx);
                exChangeAuxinfo = (ExchangeAuxInfo)iExchangeAux.getValue("where sourceCurrency.id = '" + card.getCurrency().getId() + "' and targetCurrency.id = '" + card.getCompany().getBaseCurrency().getId() + "' and exchangeTable.id = '" + card.getCompany().getBaseExchangeTable().getId() + "'");
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            if (exChangeAuxinfo.getConvertMode().getValue() == 0) {
                tmpValue2 = originAmount.multiply(rate).setScale(this.baseCurrency.getPrecision(), 4);
                if (tmpValue2.compareTo(localAmount) != 0) {
                    this.abort(ctx, this.getResource(ctx, "originPriceNotEquel2"));
                }
            } else {
                tmpValue2 = originAmount.divide(rate, RoundingMode.HALF_UP).setScale(this.baseCurrency.getPrecision(), 4);
                if (tmpValue2.compareTo(localAmount) != 0) {
                    this.abort(ctx, this.getResource(ctx, "originPriceNotEquel3"));
                }
            }
        }
    }

    protected void checkAccountDate(Context ctx, LCMMonCardInfo card) throws TaskExternalException {
        if (card.getAccountDate() == null) {
            this.abort(ctx, this.getResource(ctx, "dateCanNotNull"));
        } else {
            Date buyDate;
            Date accountDate = card.getAccountDate();
            this.verifyAcctDateWhenInit(ctx, accountDate);
            if (card.getBuyDate() != null && DateTimeUtils.dayAfter((Date)(buyDate = card.getBuyDate()), (Date)accountDate)) {
                this.abort(ctx, this.getResource(ctx, "buyDateLessPassEntriesData"));
            }
        }
    }

    protected void verifyAcctDateWhenInit(Context ctx, Date accountDate) throws TaskExternalException {
        if (this.currenctPeriod == null) {
            try {
                this.currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)this.company);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if (this.currenctPeriod != null) {
            if (this.isInitCard()) {
                if (!DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currenctPeriod.getBeginDate())) {
                    this.abort(ctx, this.getResource(ctx, "passEntriesDataLessOriginDate"));
                }
            } else if (DateTimeUtils.dayBefore((Date)accountDate, (Date)this.currenctPeriod.getBeginDate()) || DateTimeUtils.dayAfter((Date)accountDate, (Date)this.currenctPeriod.getEndDate())) {
                this.abort(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"16_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()));
            }
        }
    }

    protected void verifyNum(Context ctx, String number) throws TaskExternalException {
        boolean isOverride = this.isSltImportUpdate();
        if (isOverride) {
            return;
        }
        if (number == null || number.trim().length() == 0) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        try {
            if (this.isInitCard()) {
                if (LCMMonCardFactory.getLocalInstance(ctx).exists(filter)) {
                    this.abort(ctx, this.getResource(ctx, "hasDpuNumber"));
                }
            } else if (LCMCurCardFactory.getLocalInstance(ctx).exists(filter)) {
                this.abort(ctx, this.getResource(ctx, "hasDpuNumber"));
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void checkStrLength(Context ctx, Hashtable data, String[] fields) throws TaskExternalException {
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            String value = this.getValue(data, fields[i]);
            if (value == null || value.length() <= 80) continue;
            this.abort(ctx, this.getResource(ctx, fields[i]) + this.getResource(ctx, "strLenger"));
        }
    }

    private String getBaseDataOql(String number, boolean getAll, boolean isCuIsoluate) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        if (getAll) {
            if (isCuIsoluate) {
                return "WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
            }
            return "WHERE NUMBER = '" + number + "'";
        }
        if (isCuIsoluate) {
            return "SELECT ID WHERE NUMBER = '" + number + "' AND CU.id = '" + this.cu + "'";
        }
        return "SELECT ID WHERE NUMBER = '" + number + "'";
    }

    private String getOuIsolateOql(String number, boolean getAll, boolean isOuIsoluate) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        if (getAll) {
            if (isOuIsoluate) {
                return "WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
            }
            return "WHERE NUMBER = '" + number + "'";
        }
        if (isOuIsoluate) {
            return "SELECT ID WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
        }
        return "SELECT ID WHERE NUMBER = '" + number + "'";
    }

    private String getCatOql(String number) {
        if (StringUtils.isEmpty((String)number)) {
            return null;
        }
        return "SELECT * WHERE NUMBER = '" + number + "' AND company.id = '" + this.fi + "'";
    }

    private String getValue(Map data, String fieldName) {
        if (data.get(fieldName) == null) {
            return null;
        }
        Object obj = ((DataToken)data.get((Object)fieldName)).data;
        return obj == null ? null : obj.toString();
    }

    private String getValue(Context ctx, Map data, String fieldName, String fieldCHN, boolean supportNull) throws TaskExternalException {
        String result = this.getValue(data, fieldName);
        if (StringUtils.isEmpty((String)result) && !supportNull) {
            this.abort(ctx, MessageFormat.format(this.getResource(ctx, "columnCanNotNull"), fieldCHN));
        }
        return result;
    }

    private void initScale(Context ctx) throws TaskExternalException {
        try {
            IExchangeRate iExchangeRate;
            ExchangeRateInfo exchangeRateInfo;
            if (this.baseCurrency == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("precision"));
                this.baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId()), sic);
                this.assertNotNull(ctx, this.baseCurrency, this.getResource(ctx, "standardMondeyIsNull"));
                this.baseScale = this.baseCurrency.getPrecision();
            }
            if (this.currency != null) {
                this.originScale = this.currency.getPrecision();
            }
            if (this.quantityScale == null) {
                HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
                ObjectUuidPK pk = new ObjectUuidPK(this.company.getId());
                paramKeyMap.put("LCM_001", pk);
                String tmpValue = (String)ParamManager.getParamHashMap((Context)ctx, paramKeyMap).get("LCM_001");
                this.quantityScale = tmpValue != null ? Integer.valueOf(tmpValue) : new Integer(0);
            }
            if (this.periodDate == null) {
                PeriodInfo currenctPeriod = this.getCurrentPeriod(ctx);
                this.periodDate = new Date(System.currentTimeMillis());
                this.periodDate = DateTimeUtils.truncateDate((Date)this.periodDate);
                if (DateTimeUtils.dayBefore((Date)this.periodDate, (Date)currenctPeriod.getBeginDate())) {
                    this.periodDate = currenctPeriod.getBeginDate();
                }
                if (DateTimeUtils.dayAfter((Date)this.periodDate, (Date)currenctPeriod.getEndDate())) {
                    this.periodDate = currenctPeriod.getEndDate();
                }
                this.periodDate = new Date(this.periodDate.getTime());
            }
            if (this.company.getBaseExchangeTable() != null && this.currency != null && this.baseCurrency != null && (exchangeRateInfo = (iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx)).getExchangeRate((IObjectPK)new ObjectUuidPK(this.company.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(this.currency.getId()), (IObjectPK)new ObjectUuidPK(this.baseCurrency.getId()), this.periodDate)) != null) {
                this.rateScale = exchangeRateInfo.getPrecision();
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        try {
            int amortizeMode;
            if (this.company == null) {
                this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
            if (rs.getString("currency.number") != null) {
                this.currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue("where number = '" + rs.getString("currency.number") + "'");
            }
            this.initScale(ctx);
            HashMap<String, Integer> precisions = new HashMap<String, Integer>();
            precisions.put("baseScale", new Integer(this.baseScale));
            precisions.put("originScale", new Integer(this.originScale));
            precisions.put("quantityScale", this.quantityScale);
            precisions.put("rateScale", new Integer(this.rateScale));
            Hashtable result = FaDataImportUtils.setDataForExport((String[])this.EXP_FIELD_IN_FILE, (String[])this.EXP_FIELD_IN_QUERY, (IRowSet)rs, precisions);
            if (result.get("amortizeMode") != null && ((amortizeMode = Integer.parseInt(result.get("amortizeMode").toString())) == 1 || amortizeMode == 2)) {
                result.put("amortizeMode", LCMAmortizeModeEnum.getEnum(amortizeMode).getAlias());
            }
            return result;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        if (ContextUtil.getCurrentFIUnit((Context)ctx) == null) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("period.id", null));
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.lcm.LCMMonCardExpQuery";
    }

    protected String getResource(Context ctx, String resName) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMImportResource", (String)resName, (Locale)ctx.getOriginLocale());
    }

    private UserInfo getUserInfo(Context ctx, String number) throws TaskExternalException {
        if (number == null || number.trim().length() == 0) {
            return null;
        }
        try {
            String sql = "SELECT FID FROM T_PM_User WHERE FNUMBER = '" + number + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                UserInfo userInfo = new UserInfo();
                userInfo.setId(BOSUuid.read((String)rs.getString(1)));
                return userInfo;
            }
            throw new TaskExternalException(MessageFormat.format(this.getResource(ctx, "noPerson"), number));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected PeriodInfo getCurrentPeriod(Context ctx) throws TaskExternalException {
        if (this.currenctPeriod != null) {
            return this.currenctPeriod;
        }
        try {
            this.currenctPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.LOWCOSTMATERIAL, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        if (this.currenctPeriod == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)ctx.getOriginLocale());
            throw new TaskExternalException(strMsg);
        }
        return this.currenctPeriod;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            if (coreBaseInfo == null) {
                return;
            }
            if (coreBaseInfo.getId() == null || !this.getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    protected boolean isInitCard() {
        return true;
    }

    private void setCardInfoOverrided(Context ctx, LCMCardInfo card) throws TaskExternalException {
        block7: {
            boolean isOverride = this.isSltImportUpdate();
            String number = card.getNumber();
            if (number == null || number.length() == 0) {
                return;
            }
            boolean isInitCard = this.isInitCard();
            try {
                if (isInitCard) {
                    LCMMonCardCollection cards = LCMMonCardFactory.getLocalInstance(ctx).getLCMMonCardCollection("select id,faCurCard.id,faMonFacility.*,faMonCostCenter.*,faMonInitData.*,faMonDepartment.* where number='" + number + "' and company.id='" + this.company.getId().toString() + "'");
                    if (cards.size() <= 0) break block7;
                    if (isOverride) {
                        card.setId(cards.get(0).getId());
                        break block7;
                    }
                    throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
                }
                LCMCurCardCollection cards = LCMCurCardFactory.getLocalInstance(ctx).getLCMCurCardCollection("select id,effectedStatus,checkedstatus where number='" + number + "' and company.id='" + this.company.getId().toString() + "'");
                if (cards.size() <= 0) break block7;
                if (isOverride) {
                    LCMCurCardInfo savedCard = cards.get(0);
                    if (savedCard.getCheckedStatus().getValue() == 2) {
                        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.lcm.LCMAutoGenerateResource", (String)"17_LCMMonCardDataImport", (Locale)ctx.getOriginLocale()));
                    }
                    card.setId(cards.get(0).getId());
                    break block7;
                }
                throw new TaskExternalException(FaResUtil.getRes((String)"evalInfo23", (Locale)ctx.getOriginLocale()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
    }

    protected Map getLCMParameter(Context ctx) throws EASBizException, BOSException {
        if (this.parameter == null) {
            this.parameter = LCMUtils.getLCMParameter(ContextUtil.getCurrentFIUnit((Context)ctx).getId(), ctx);
        }
        return this.parameter;
    }
}

