/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.rpt.CompanyDisplayModeEnum;
import com.kingdee.eas.fi.gl.rpt.GLRptSubLedgerCondition;
import com.kingdee.eas.fi.gr.cslrpt.ArchivedStatusEnum;
import com.kingdee.eas.fi.gr.cslrpt.CheckFormulaException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.DynaItemElimEntryCondition;
import com.kingdee.eas.fi.gr.cslrpt.ElimDataSourceEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimDynaItemEntryFactory;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.EliminationEntryInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationFactory;
import com.kingdee.eas.fi.gr.cslrpt.EliminationInfo;
import com.kingdee.eas.fi.gr.cslrpt.EliminationModeInfo;
import com.kingdee.eas.fi.gr.cslrpt.IElimination;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemInfo;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ColumnInfo;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.ParamTempTblService;
import com.kingdee.eas.fi.gr.cslrpt.app.paramhandle.TableInfo;
import com.kingdee.eas.fi.gr.cslrpt.autoitem.util.DateUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.CslRptUIUtil;
import com.kingdee.eas.fi.gr.cslrpt.client.MnsUnionF7;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AsstActTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitEntryCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillHeadInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillRelatElimInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageDiffInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageAccount;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.client.CheckageStatusListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.GroupCheckageListUI;
import com.kingdee.eas.fi.newrpt.accountcheck.client.GroupCreateElimListUI;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.cslworktable.client.CslWorkTableUIUtil;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.UnionF7Helper;
import com.kingdee.eas.fi.rpt.batch.OneToManyMap;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtilForClient;
import com.kingdee.eas.framework.CheckedStatusEnum;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.LineResult;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class AccountCheckUtil {
    private static final Logger logger = Logger.getLogger(AccountCheckUtil.class);
    public static final String resource = "com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckResource";
    public static final String ITEMTYPE_ACCOUNT = "001";
    public static final String ITEMTYPE_RPTITEM = "002";
    public static final String GR_CSL_DZPT_CANNOTCONFIRMWHENDATADIFFERENCE = "GR_CSL_DZPT_CannotConfirmWhenDataDifference";
    public static final String GR_CSL_DZPT_DATACONFIRMISREVIEW = "GR_CSL_DZPT_DataConfirmIsReview";
    public static final String GR_CSL_DZPT_CANCONFIRMUNCHECKOUTDATA = "GR_CSL_DZPT_CanConfirmUnCheckOutData";
    public static final Book book = Book.Manager.getNewBook(null, (int)0);

    public static String getResourceString(Context ctx, String strKey, Object[] params) {
        Locale locale = null;
        locale = ctx == null ? SysContext.getSysContext().getOriginLocale() : ctx.getOriginLocale();
        if (params == null || params.length <= 0) {
            return ResourceBase.getString((String)resource, (String)strKey, (Locale)locale);
        }
        return ResourceBase.getString((String)resource, (String)strKey, (Locale)locale, (Object[])params);
    }

    public static ItemTypeEnum getItemType(String itemType) {
        if (ITEMTYPE_ACCOUNT.equals(itemType)) {
            return ItemTypeEnum.account;
        }
        if (ITEMTYPE_RPTITEM.equals(itemType)) {
            return ItemTypeEnum.rptItem;
        }
        return null;
    }

    public static String replace(String formulaString) {
        StringBuffer formula = new StringBuffer();
        if (formulaString.contains("{year}") || formulaString.contains("{period}")) {
            String[] params = formulaString.split(",");
            for (int i = 0; i < params.length; ++i) {
                String param = params[i];
                if (param.equals("{year}") || param.equals("{period}")) {
                    formula.append(0).append(",");
                    continue;
                }
                formula.append(param).append(",");
            }
            formulaString = formula.substring(0, formula.length() - 1);
        }
        return formulaString;
    }

    public static void checkFormulaParams(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            String funName = ((FunctionExpr)expression).funcionName;
            if (funName.equals("ACCT")) {
                AccountCheckUtil.checkAcct(expression);
            } else if (funName.equals("ACCTAC")) {
                AccountCheckUtil.checkAcctAc(expression);
            } else if (funName.equals("ACCTCASH")) {
                AccountCheckUtil.checkAcctCash(expression);
            } else if (funName.equals("AGE")) {
                AccountCheckUtil.checkAge(expression);
            }
        } else if (expression instanceof BinaryOperationExpr) {
            Expression expr = ((BinaryOperationExpr)expression).left;
            AccountCheckUtil.checkFormulaParams(expr);
            expr = ((BinaryOperationExpr)expression).right;
            AccountCheckUtil.checkFormulaParams(expr);
        } else if (expression instanceof UnaryOperationExpr) {
            Expression expr = ((UnaryOperationExpr)expression).operand;
            AccountCheckUtil.checkFormulaParams(expr);
        }
    }

    private static void checkAge(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            List params = ((FunctionExpr)expression).parameters;
            int size = params.size();
            if (size != 10) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR);
            }
            if (params.get(1) == null || params.get(1) != null && "\"\"".equals(params.get(1).toString())) {
                throw new CheckFormulaException(CheckFormulaException.AGEITEMISNULL);
            }
            if (params.get(6) == null || params.get(6) != null && "\"\"".equals(params.get(6).toString())) {
                throw new CheckFormulaException(CheckFormulaException.AGEDATETYPEISNULL);
            }
            if (params.get(8) == null || params.get(8) != null && "\"\"".equals(params.get(8).toString())) {
                throw new CheckFormulaException(CheckFormulaException.AGECALTYPEISNULL);
            }
            if (params.get(9) == null || params.get(9) != null && "\"\"".equals(params.get(9).toString())) {
                throw new CheckFormulaException(CheckFormulaException.AGETYPEISNULL);
            }
        }
    }

    private static void checkAcct(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            List params = ((FunctionExpr)expression).parameters;
            int size = params.size();
            if (size != 9) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR);
            }
            if (params.get(1) == null || params.get(1) != null && "\"\"".equals(params.get(1).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTITEMISNULL);
            }
            if (params.get(2) == null || params.get(2) != null && "\"\"".equals(params.get(2).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTDATAELEMENTISNULL);
            }
            if (params.get(8) == null || params.get(8) != null && "\"\"".equals(params.get(8).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTORGTYPEISNULL);
            }
        }
    }

    private static void checkAcctAc(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            List params = ((FunctionExpr)expression).parameters;
            int size = params.size();
            if (size != 9) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR);
            }
            if (params.get(2) == null || params.get(2) != null && StringUtils.isEmpty((String)params.get(2).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTACITEMISNULL);
            }
            if (params.get(3) == null || params.get(3) != null && StringUtils.isEmpty((String)params.get(3).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTACDATAELEMENTISNULL);
            }
        }
    }

    private static void checkAcctCash(Expression expression) throws CheckFormulaException {
        if (expression instanceof FunctionExpr) {
            List params = ((FunctionExpr)expression).parameters;
            int size = params.size();
            if (size != 8) {
                throw new CheckFormulaException(CheckFormulaException.CHECK_SHEET_FORMULA_ERROR);
            }
            if (params.get(1) == null || params.get(1) != null && StringUtils.isEmpty((String)params.get(1).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTCASHDATAELEMENTISNULL);
            }
            if (params.get(6) == null || params.get(6) != null && StringUtils.isEmpty((String)params.get(6).toString())) {
                throw new CheckFormulaException(CheckFormulaException.ACCTCASHITEMISNULL);
            }
        }
    }

    public static void checkFormula(String formulaString) throws CheckFormulaException {
        if (formulaString.indexOf("@") == -1) {
            throw new CheckFormulaException(CheckFormulaException.SPECIFICCHARACTOR);
        }
    }

    public static void changeCheckPeriod(RptPeriodTypeEnum periodType, KDComboBox kdCheckPeriod, int period, String selectAll) throws Exception {
        if (kdCheckPeriod == null) {
            return;
        }
        if (periodType != null) {
            kdCheckPeriod.removeAllItems();
            kdCheckPeriod.addItem((Object)selectAll);
            int start = -1;
            switch (periodType.getValue()) {
                case 3: {
                    kdCheckPeriod.addItem((Object)period);
                    break;
                }
                case 4: {
                    start = (period - 1) * 3;
                    for (int i = 1; i <= 3; ++i) {
                        kdCheckPeriod.addItem((Object)(start + i));
                    }
                    if (period != 4) break;
                    kdCheckPeriod.addItem((Object)13);
                    break;
                }
                case 5: {
                    start = (period - 1) * 6;
                    for (int i = 1; i <= 6; ++i) {
                        kdCheckPeriod.addItem((Object)(start + i));
                    }
                    if (period != 2) break;
                    kdCheckPeriod.addItem((Object)13);
                    break;
                }
                case 6: {
                    for (int i = 1; i <= 13; ++i) {
                        kdCheckPeriod.addItem((Object)i);
                    }
                    break;
                }
            }
        }
    }

    public static String getSameParentOrgUnitTmpTable(Context ctx, String treeId, String orgUnitId) throws BOSException, EASBizException {
        try {
            OrgStructureInfo info = AccountCheckUtil.getOrgStructureInfo(ctx, treeId, orgUnitId);
            if (info == null) {
                return null;
            }
            return AccountCheckUtil.getSameParentOrgUnitTmpTable(ctx, treeId, info.getLongNumber(), info.getLevel());
        }
        catch (Exception e) {
            logger.error((Object)"getSameParentOrgUnitTmpTable error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String getLongNumber(Context ctx, String treeId, String orgUnitId) throws BOSException, EASBizException {
        try {
            IRowSet rsTemp;
            if (!StringUtils.isEmpty((String)treeId) && !StringUtils.isEmpty((String)orgUnitId) && (rsTemp = DbUtil.executeQuery(ctx, " select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", new Object[]{treeId, orgUnitId})).next()) {
                return rsTemp.getString("FLongNumber");
            }
        }
        catch (Exception e) {
            logger.error((Object)"getLongNumber error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    public static SQLBuilder getAllChildSql(Context ctx, CheckageFilterInfo param, boolean isIncludeOwn) throws BOSException, EASBizException {
        SQLBuilder sql = new SQLBuilder();
        if (!StringUtils.isEmpty((String)param.treeId) && !StringUtils.isEmpty((String)param.orgUnitId)) {
            String longNumber = param.longNumber;
            if (StringUtils.isEmpty((String)longNumber)) {
                longNumber = AccountCheckUtil.getLongNumber(ctx, param.treeId, param.orgUnitId);
            }
            sql.append(" select funitid from t_org_structure where ftreeid=?", param.treeId);
            sql.append(" and (flongnumber like ? ", longNumber + "!%");
            if (isIncludeOwn) {
                sql.append(" or flongnumber = ? ", longNumber);
            }
            sql.append(") ");
        }
        return sql;
    }

    public static String getSameParentCompanyOrgUnit(Context ctx, CheckageFilterInfo filter) throws Exception {
        if (!StringUtils.isEmpty((String)filter.orgUnitId) && !StringUtils.isEmpty((String)filter.treeId) && filter.year > 0 && filter.period > 0) {
            OrgStructureInfo info = AccountCheckUtil.getOrgStructureInfo(ctx, filter.treeId, filter.orgUnitId);
            if (info == null) {
                throw new Exception("orgUnit is error.");
            }
            filter.longNumber = info.getLongNumber();
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select distinct case when bill.fcompanyId>bill.FTargetCompanyId then bill.fcompanyId else bill.FTargetCompanyId end ownCompany,");
            sql.append("case when bill.fcompanyId>bill.FTargetCompanyId then bill.FTargetCompanyId else bill.fcompanyId end targCompany,");
            sql.append("case when bill.fcompanyId>bill.FTargetCompanyId then ownStru.flongNumber else targStru.flongNumber end ownLongNum,");
            sql.append("case when bill.fcompanyId>bill.FTargetCompanyId then targStru.flongNumber else ownStru.flongNumber end targLongNum ");
            sql.append(" from T_Csl_CheckageBill bill ");
            sql.append(" inner join t_org_structure ownStru on ownStru.funitid=bill.fcompanyId ");
            sql.append(" inner join t_org_structure targStru on targStru.funitid=bill.FTargetCompanyId ");
            if (!filter.isIncludeChild) {
                SQLBuilder companySql = AccountCheckUtil.getSamParentCompanySql(ctx, filter.treeId, info.getLongNumber(), info.getLevel());
                sql.append(" inner join (").append(companySql).append(") org on org.fcompanyid=bill.fcompanyId and org.FTargetCompanyId=bill.FTargetCompanyId ");
            }
            sql.append(" where bill.fyear=?", filter.year);
            if (filter.itemType >= 0) {
                sql.append(" and bill.FItemType=? ", filter.itemType);
            }
            sql.append(" and ownStru.ftreeid=? ", filter.treeId);
            sql.append(" and targStru.ftreeid=? ", filter.treeId);
            if (filter.checkPeriod > 0) {
                sql.append("  and bill.fperiod=? ", filter.checkPeriod);
            } else {
                RptPeriodTypeEnum periotType = RptPeriodTypeEnum.getEnum((int)filter.periodType);
                if (!RptPeriodTypeEnum.MONTHLY.equals((Object)periotType)) {
                    int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)filter.year, (int)filter.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                    int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)filter.year, (int)filter.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                    int lastPeriod = lastYearPeriod[1];
                    if (lastPeriod == 12) {
                        ++lastPeriod;
                    }
                    sql.append("  and bill.fperiod>=? ", yearPeriod[1]);
                    sql.append("  and bill.fperiod<=? ", lastPeriod);
                } else {
                    sql.append("  and bill.fperiod=? ", filter.period);
                }
            }
            sql.append(" and bill.FCurrencyId=? ", filter.currencyId);
            if (filter.isIncludeChild) {
                sql.append(" and ownStru.flongnumber like ? ", info.getLongNumber() + "!%");
                sql.append(" and targStru.flongnumber like ? ", info.getLongNumber() + "!%");
            }
            logger.error((Object)("sql.getSQL()---------" + Arrays.toString(sql.getParams())));
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            if (rowSet != null && rowSet.size() > 0) {
                Map<String, String> longNum_Ids = AccountCheckUtil.getAllChildOrgUnitLongNumberMap(ctx, filter);
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                while (rowSet.next()) {
                    String parentId;
                    String targLongNum;
                    String ownCompany = rowSet.getString("ownCompany");
                    String targCompany = rowSet.getString("targCompany");
                    String ownLongNum = rowSet.getString("ownLongNum");
                    String parentOrgUnitLongNum = AccountCheckUtil.getSameParentLongNumber(ownLongNum, targLongNum = rowSet.getString("targLongNum"));
                    if (parentOrgUnitLongNum == null || (parentId = longNum_Ids.get(parentOrgUnitLongNum)) == null || filter.isIncludeChild && !filter.hasPermOrgIds.contains(parentId) || !filter.isIncludeChild && !filter.orgUnitId.equals(parentId)) continue;
                    paramList.add(new Object[]{ownCompany, targCompany, parentId});
                }
                if (!paramList.isEmpty()) {
                    String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_company(FCompanyId varchar(44),FTargetCompanyId varchar(44),forgUnitId varchar(44))");
                    sql.reset();
                    sql.append(" insert into ").append(tempTable).append("(FCompanyId,FTargetCompanyId,forgUnitId) values(?,?,?) \n");
                    DbUtil.executeBatch(ctx, sql.getSQL(), paramList);
                    return tempTable;
                }
            }
        }
        return null;
    }

    public static Map<String, String> getAllChildOrgUnitLongNumberMap(Context ctx, CheckageFilterInfo param) throws Exception {
        HashMap<String, String> unitMap = new HashMap<String, String>();
        String longNumber = param.longNumber;
        if (StringUtils.isEmpty((String)longNumber)) {
            longNumber = AccountCheckUtil.getLongNumber(ctx, param.treeId, param.orgUnitId);
        }
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select struct.flongNumber,struct.funitid from t_org_structure struct ");
        sql.append(" inner join t_org_baseunit unit on unit.fid=struct.funitid ");
        sql.append(" where struct.ftreeid=? ", param.treeId).append(" and unit.fisunion=1 ");
        sql.append(" and (struct.flongnumber=? ", longNumber).append(" or struct.flongnumber like ?", longNumber + "!%").append(") ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet != null && rowSet.next()) {
            unitMap.put(rowSet.getString("flongNumber"), rowSet.getString("funitid"));
        }
        return unitMap;
    }

    public static OrgStructureInfo getOrgStructureInfo(Context ctx, String treeId, String orgUnitId) throws Exception {
        IRowSet rsTemp = DbUtil.executeQuery(ctx, " select struct.FLongNumber,struct.FLevel,tree.fnumber treeNumber,unit.fnumber unitNumber From t_org_structure struct inner join t_org_baseunit unit on unit.fid=struct.funitid inner join t_org_tree tree on tree.fid=struct.ftreeid where struct.ftreeid = ? and struct.funitid = ?", new Object[]{treeId, orgUnitId});
        String longNumber = null;
        int level = -1;
        if (rsTemp.next()) {
            longNumber = rsTemp.getString("FLongNumber");
            level = rsTemp.getInt("FLevel");
            OrgStructureInfo struct = new OrgStructureInfo();
            struct.setLongNumber(longNumber);
            struct.setLevel(level);
            return struct;
        }
        return null;
    }

    public static String getSameParentLongNumber(String longNumber, String targetLongNumber) throws Exception {
        StringBuffer curLongNumber = new StringBuffer();
        int shortLen = targetLongNumber.length() > longNumber.length() ? longNumber.length() : targetLongNumber.length();
        int lastIndex = -1;
        for (int i = 0; i < shortLen; ++i) {
            if (longNumber.charAt(i) == targetLongNumber.charAt(i)) {
                curLongNumber.append(longNumber.charAt(i));
                if (longNumber.charAt(i) != '!') continue;
                lastIndex = i;
                continue;
            }
            if (lastIndex <= 0) continue;
            return curLongNumber.substring(0, lastIndex);
        }
        if (lastIndex > 0) {
            return curLongNumber.substring(0, lastIndex);
        }
        return null;
    }

    public static SQLBuilder getSamParentCompanySql(Context ctx, String treeId, String longNumber, int level) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" select distinct t1.FLongNumber \r\n");
        sql.append(" from t_org_structure t1 join t_org_baseunit t2 on t1.FUnitId=t2.FId \r\n");
        sql.append(" where t1.FTreeId = '").append(treeId).append("'");
        sql.append(" And t1.FLongNumber like '").append(longNumber).append("%'");
        sql.append(" And t1.FLevel = ").append(level + 1);
        sql.append(" And t2.FIsCompanyOrgUnit = 0");
        IRowSet rsTemp = DbUtil.executeQuery(ctx, sql.toString());
        sql.reset();
        sql.append(" select x.FCompanyId,x.FTargetCompanyId from (");
        sql.append(" Select x1.FCompanyId,x1.FLongNumber as FLongNumber,x2.FTargetCompanyId,x2.FlongNumber As FTargetLongNumber \r\n");
        sql.append(" From \r\n");
        sql.append(" (Select t1.FUnitId As FCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid=?", treeId).append(") x1, \r\n");
        sql.append(" (Select t1.FUnitId As FTargetCompanyId,t1.FLongNumber From t_org_structure t1 join t_org_baseunit t2 on t1.funitid=t2.fid ");
        sql.append("  where t2.fisgrouping=0 and t1.fisleaf=1 and t1.flongnumber like '").append(longNumber).append("!%' and t1.ftreeid=?", treeId).append(") x2 \r\n");
        sql.append(" ) x ");
        if (rsTemp.size() > 0) {
            sql.append(" where 1=1 ");
        }
        while (rsTemp.next()) {
            sql.append(" and (Left(Replace(x.FLongNumber,'").append(rsTemp.getString("FLongNumber")).append("!','@#$'),3)<>'@#$' \r\n");
            sql.append(" or Left(Replace(x.FTargetLongNumber,'").append(rsTemp.getString("FLongNumber")).append("!','@#$'),3)<>'@#$') \r\n");
        }
        return sql;
    }

    public static String getSameParentOrgUnitTmpTable(Context ctx, String treeId, String longNumber, int level) throws BOSException, EASBizException {
        try {
            SQLBuilder sql = new SQLBuilder();
            String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable("create table t_csl_company(FCompanyId varchar(44),FTargetCompanyId varchar(44))");
            sql.append(" insert into ").append(tempTable).append("(FCompanyId,FTargetCompanyId) \n");
            sql.append(AccountCheckUtil.getSamParentCompanySql(ctx, treeId, longNumber, level));
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            return tempTable;
        }
        catch (Exception ex) {
            logger.error((Object)"getSameParentOrgUnitTmpTable error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
    }

    public static Map<String, List<CheckageBillInfo>> getCheckageBills(Context ctx, List<String> billHeadIds, String companyId, boolean isGroup) throws Exception {
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            String lang = ctx.getLocale().getLanguage();
            sql.append(" select head.fid headId,bill.fid fid,bill.FConfirmStatus,account.fItemNumber itemNumber,account.fItemName itemName,account.faccountDc accountDc,\n");
            sql.append(" bill.tarCompanyName,bill.ftargetCompanyId tarCompanyId ,account.FBalType, account.fdataElement,account.fitemType,account.fid mapAccountId,bill.fconfirmDebit, \n");
            sql.append(" bill.fconfirmCredit,bill.fauditDebit,bill.fauditCredit,bill.fDebit,bill.fCredit,bill.companyNumber,bill.fcompanyId,bill.companyName, \n");
            sql.append(" chAccount.FIsMapAccount isMapAccount,bill.tarCompanyNumber,bill.FIsIncludingUnPosted,bill.FConfirmTime,bill.FBillCompanyId,bill.FRemark \n");
            sql.append(" from t_csl_accountmap map \n");
            sql.append(" inner join T_Csl_AccountAndMapAccount chAccount on map.fid=chAccount.FAccountMapId \n");
            sql.append(" inner join T_Csl_CheckageAccount account on account.fid=chAccount.FCheckAccountId \n");
            sql.append(" inner join t_csl_checkagebillhead head on head.FAccountMapId=map.fid \n");
            sql.append(" left join (select ckbill.fconfirmDebit,ckbill.fconfirmCredit,ckbill.fauditDebit,ckbill.fauditCredit,ckbill.fDebit,ckbill.fCredit,ckbill.fid,ckbill.fcompanyId,ckbill.FBalType \n");
            sql.append("            ,tarUnit.fnumber tarCompanyNumber,ckbill.fItemNumber itemNumber,ckbill.FBillHeadId,unit.fnumber companyNumber, unit.fname_").append(lang).append(" companyName \n");
            sql.append("            ,ckbill.fcheckAccountId,ckbill.ftargetCompanyId,tarUnit.fname_").append(lang).append(" tarCompanyName,ckbill.fitemNumber,ckbill.FIsIncludingUnPosted,billCompany.FConfirmTime \n");
            sql.append("            ,ckbill.FBillCompanyId,billCompany.FConfirmStatus,ckbill.FRemark \n");
            sql.append("            from t_csl_checkagebill ckbill \n");
            sql.append(" \t\t\tinner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=ckbill.FBillCompanyId \n");
            sql.append("            inner join t_org_baseunit unit  on unit.fid=ckbill.fcompanyid \n");
            sql.append("            inner join t_org_baseunit tarUnit  on tarUnit.fid=ckbill.ftargetCompanyId \n");
            sql.append("            where ckbill.FBillHeadId in", billHeadIds).append(") bill on bill.FBillHeadId=head.fid and bill.fcheckAccountId=account.fid \n");
            sql.append(" where head.fid in", billHeadIds);
            sql.append(" order by head.fid,chAccount.FIsMapAccount,chAccount.fseq,account.fItemNumber ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            HashMap<String, List<CheckageBillInfo>> bills = new HashMap<String, List<CheckageBillInfo>>();
            HashMap<String, CompanyOrgUnitInfo[]> headId_CompanyMap = new HashMap<String, CompanyOrgUnitInfo[]>();
            HashMap<String, HashMap<String, ConfirmStatusEnum>> headId_CompanyConfirmStatus = new HashMap<String, HashMap<String, ConfirmStatusEnum>>();
            String bosType = new CheckageBillInfo().getBOSType().toString();
            HashMap<String, Boolean> isIncludingUnPostMap = new HashMap<String, Boolean>();
            ItemTypeEnum itemType = null;
            while (rowSet.next()) {
                String headId = rowSet.getString("headId");
                ArrayList<CheckageBillInfo> bill = (ArrayList<CheckageBillInfo>)bills.get(headId);
                if (bill == null) {
                    bill = new ArrayList<CheckageBillInfo>();
                    bills.put(headId, bill);
                }
                if (rowSet.getInt("FIsIncludingUnPosted") > 0) {
                    isIncludingUnPostMap.put(headId, rowSet.getInt("FIsIncludingUnPosted") == 1);
                }
                CheckageBillInfo info = new CheckageBillInfo();
                int isMapAccount = rowSet.getInt("isMapAccount");
                info.put("isMapAccount", isMapAccount);
                String id = rowSet.getString("fid");
                if (!StringUtils.isEmpty((String)id)) {
                    info.setId(BOSUuid.read((String)id));
                } else {
                    info.setId(BOSUuid.read((String)new ObjectUuidPK(BOSObjectType.create((String)bosType)).toString()));
                    info.setAddNew(true);
                }
                info.setOwn(isMapAccount == 1);
                String companyNumber = rowSet.getString("companyNumber");
                if (!StringUtils.isEmpty((String)companyNumber)) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setNumber(companyNumber);
                    company.setId(BOSUuid.read((String)rowSet.getString("fcompanyId")));
                    company.setName(rowSet.getString("companyName"));
                    info.setCompany(company);
                    CompanyOrgUnitInfo tarCompany = new CompanyOrgUnitInfo();
                    tarCompany.setNumber(rowSet.getString("tarCompanyNumber"));
                    tarCompany.setName(rowSet.getString("tarCompanyName"));
                    tarCompany.setId(BOSUuid.read((String)rowSet.getString("tarCompanyId")));
                    info.setTargetCompany(tarCompany);
                    CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])headId_CompanyMap.get(headId);
                    if (companys == null) {
                        companys = isMapAccount == 1 ? new CompanyOrgUnitInfo[]{company, tarCompany} : new CompanyOrgUnitInfo[]{tarCompany, company};
                        headId_CompanyMap.put(headId, companys);
                    }
                }
                if (!isGroup) {
                    if (companyId != null && info.getCompany() != null && !companyId.equals(info.getCompany().getId().toString())) {
                        info.put("isTarCompany", true);
                    }
                    info.setDebit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fDebit")));
                    info.setCredit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fCredit")));
                } else {
                    info.setAuditDebit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fauditDebit")));
                    info.setAuditCredit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fauditCredit")));
                }
                info.setConfirmDebit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fconfirmDebit")));
                info.setConfirmCredit(AccountCheckUtil.getValue(rowSet.getBigDecimal("fconfirmCredit")));
                info.setItemName(rowSet.getString("itemName"));
                info.setItemNumber(rowSet.getString("itemNumber"));
                info.setBalType(BalTypeEnum.getEnum(rowSet.getInt("FBalType")));
                info.setDataElement(rowSet.getInt("fdataElement"));
                itemType = ItemTypeEnum.getEnum(rowSet.getInt("fitemType"));
                info.setItemType(itemType);
                CheckageAccountInfo item = new CheckageAccountInfo();
                item.setId(BOSUuid.read((String)rowSet.getString("mapAccountId")));
                item.setItemDC(BalanceDirectionEnum.getEnum((int)rowSet.getInt("accountDc")));
                info.setCheckAccount(item);
                CheckageBillHeadInfo headInfo = new CheckageBillHeadInfo();
                headInfo.setId(BOSUuid.read((String)headId));
                info.setBillHead(headInfo);
                if (!StringUtils.isEmpty((String)rowSet.getString("FBillCompanyId"))) {
                    CheckageBillCompanyInfo billCompanyInfo = new CheckageBillCompanyInfo();
                    ConfirmStatusEnum confrimStatus = ConfirmStatusEnum.getEnum(rowSet.getInt("FConfirmStatus"));
                    billCompanyInfo.setConfirmStatus(confrimStatus);
                    billCompanyInfo.setConfirmTime(rowSet.getTimestamp("FConfirmTime"));
                    billCompanyInfo.setId(BOSUuid.read((String)rowSet.getString("FBillCompanyId")));
                    info.setBillCompany(billCompanyInfo);
                    HashMap<String, ConfirmStatusEnum> companyConfirmStatus = (HashMap<String, ConfirmStatusEnum>)headId_CompanyConfirmStatus.get(headId);
                    if (companyConfirmStatus == null) {
                        companyConfirmStatus = new HashMap<String, ConfirmStatusEnum>();
                        headId_CompanyConfirmStatus.put(headId, companyConfirmStatus);
                    }
                    companyConfirmStatus.put(companyNumber, confrimStatus);
                }
                info.setRemark(rowSet.getString("FRemark"));
                bill.add(info);
            }
            HashMap<String, CheckageBillInfo> accountIdNullBills = new HashMap<String, CheckageBillInfo>();
            ArrayList<Object[]> accountParams = new ArrayList<Object[]>();
            for (String headId : bills.keySet()) {
                CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])headId_CompanyMap.get(headId);
                if (companys == null) continue;
                List detailBills = (List)bills.get(headId);
                boolean isIncludingUnPost = isIncludingUnPostMap.containsKey(headId) ? (Boolean)isIncludingUnPostMap.get(headId) : false;
                for (CheckageBillInfo detailBill : detailBills) {
                    ConfirmStatusEnum confirmStatus;
                    if (detailBill.getCompany() == null) {
                        if ((Integer)detailBill.get("isMapAccount") == 1) {
                            detailBill.setCompany(companys[0]);
                            detailBill.setTargetCompany(companys[1]);
                        } else {
                            detailBill.setCompany(companys[1]);
                            detailBill.setTargetCompany(companys[0]);
                        }
                        if (!isGroup && companyId != null && !companyId.equals(detailBill.getCompany().getId().toString())) {
                            detailBill.put("isTarCompany", true);
                        }
                    }
                    detailBill.setIsIncludingUnPosted(isIncludingUnPost);
                    if (!ItemTypeEnum.rptItem.equals((Object)detailBill.getItemType()) && detailBill.isAddNew()) {
                        Object[] params = new Object[]{detailBill.getId().toString(), detailBill.getCompany().getId().toString(), detailBill.getItemNumber()};
                        accountParams.add(params);
                        accountIdNullBills.put(detailBill.getId().toString(), detailBill);
                    }
                    if (detailBill.getBillCompany() != null) continue;
                    detailBill.setBillCompany(new CheckageBillCompanyInfo());
                    if (!headId_CompanyConfirmStatus.containsKey(headId) || (confirmStatus = (ConfirmStatusEnum)((Object)((Map)headId_CompanyConfirmStatus.get(headId)).get(detailBill.getCompany().getNumber()))) == null) continue;
                    detailBill.getBillCompany().setConfirmStatus(confirmStatus);
                }
            }
            AccountCheckUtil.checkCheckItemExist(ctx, accountParams, accountIdNullBills, itemType);
            headId_CompanyMap.clear();
            accountParams.clear();
            isIncludingUnPostMap.clear();
            return bills;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkCheckItemExist(Context ctx, List<Object[]> accountParams, Map<String, CheckageBillInfo> accountIdNullBills, ItemTypeEnum itemType) throws Exception {
        String tempTable = null;
        TempTablePool tablePool = null;
        try {
            if (!accountParams.isEmpty()) {
                tablePool = TempTablePool.getInstance((Context)ctx);
                tempTable = tablePool.createTempTable("create table t_csl_checkItem(FId varchar(44),FCompanyId varchar(44),fitemNumber nvarchar(80))");
                SQLBuilder sql = new SQLBuilder();
                sql.append(" insert into ").append(tempTable).append("(FId,FCompanyId,fitemNumber)");
                sql.append(" values(?,?,?)");
                DbUtil.executeBatch(ctx, sql.getSQL(), accountParams);
                IRowSet rowSet = null;
                if (ItemTypeEnum.account.equals((Object)itemType)) {
                    sql.reset();
                    sql.append(" select distinct account.fid accountid,temp.fid billId from ").append(tempTable).append(" temp ");
                    sql.append(" left join t_bd_accountview account on temp.FCompanyId=account.FCompanyId and temp.fitemNumber=account.fnumber ");
                    sql.append(" where account.fid is null ");
                    rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
                }
                while (rowSet != null && rowSet.next()) {
                    String billId = rowSet.getString("billId");
                    String accountId = rowSet.getString("accountid");
                    CheckageBillInfo billInfo = accountIdNullBills.get(billId);
                    if (billInfo == null) continue;
                    billInfo.setExistCheckItem(false);
                }
            }
        }
        finally {
            if (!DebugLogger.isDebug && !StringUtils.isEmpty(tempTable) && tablePool != null) {
                tablePool.releaseTable(tempTable);
            }
        }
    }

    public static Map<String, Object> diffHandle(Context ctx, List<String> billHeadIds, DiffModeEnum diffMode) throws Exception {
        return AccountCheckUtil.diffHandle(ctx, billHeadIds, diffMode, null);
    }

    public static Map<String, Object> diffHandle(Context ctx, List<String> billHeadIds, DiffModeEnum diffMode, String autoCheckSchmId) throws Exception {
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            AccountCheckUtil.updateAuditMoney(ctx, billHeadIds, AuditedStatusEnum.UNAUDITED);
            Map<String, List<CheckageBillInfo>> bills = AccountCheckUtil.getCheckageBills(ctx, billHeadIds, null, true);
            if (!bills.isEmpty()) {
                ArrayList<CheckageBillInfo> resultBills = new ArrayList<CheckageBillInfo>();
                for (String billHeadId : bills.keySet()) {
                    resultBills.addAll(AccountCheckUtil.singleBillDiffHandle(billHeadId, bills.get(billHeadId), diffMode));
                }
                AccountCheckUtil.addNewDetailBillsForDiff(ctx, resultBills, true);
                AccountCheckUtil.updataBillAuditMoney(ctx, resultBills);
                AccountCheckUtil.updateBillHeadStatus(ctx, bills.keySet(), diffMode, false, autoCheckSchmId);
                AccountCheckUtil.updateDiff(ctx, billHeadIds, null);
            }
        }
        return null;
    }

    public static void addNewDetailBillsForDiff(Context ctx, List<CheckageBillInfo> billDetails, boolean isGroup) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        HashSet<String> headIds = new HashSet<String>();
        HashSet<String> noBillCompanyCompanySet = new HashSet<String>();
        for (CheckageBillInfo billDetail : billDetails) {
            if (!billDetail.isAddNew()) continue;
            if ("true".equals(billDetail.get("billCompanyIsNull"))) {
                noBillCompanyCompanySet.add(billDetail.getCompany().getId().toString());
            }
            headIds.add(billDetail.getBillHead().getId().toString());
        }
        if (headIds.isEmpty()) {
            return;
        }
        sql.append("select distinct fyear,fperiod,FCurrencyId,FBillHeadId,FCompanyId,FTargetCompanyId,FBillCompanyId ");
        sql.append(" from t_csl_checkagebill where FBillHeadId in ", headIds);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        int year = -1;
        int period = -1;
        String currencyId = null;
        HashMap<String, String> billCompanyIds = new HashMap<String, String>();
        while (rowSet.next()) {
            year = rowSet.getInt("fyear");
            period = rowSet.getInt("fperiod");
            currencyId = rowSet.getString("FCurrencyId");
            billCompanyIds.put(rowSet.getString("FBillHeadId") + rowSet.getString("FCompanyId"), rowSet.getString("FBillCompanyId"));
        }
        sql.reset();
        if (isGroup) {
            sql.append(" insert into T_Csl_CheckageBill(fid,fyear,fperiod,FCurrencyId,FCompanyId,FTargetCompanyId,FAccountId,FBalType,FAuditDebit,FAuditCredit,");
            sql.append(" fconfirmDebit,fconfirmCredit,FBillCompanyId,FBillHeadId,FCreatorID,FCreateTime,FIsIncludingUnPosted,FLastUpdateUserId,FLastUpdateTime,");
            sql.append(" FItemType,FDataElement,FItemNumber,FItemName,FDataSource,FCheckAccountId,fremark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
        } else {
            sql.append(" insert into T_Csl_CheckageBill(fid,fyear,fperiod,FCurrencyId,FCompanyId,FTargetCompanyId,FAccountId,FBalType,FDebit,FCredit,FAuditDebit,");
            sql.append(" FAuditCredit,fconfirmDebit,fconfirmCredit,FBillCompanyId,FBillHeadId,FCreatorID,FCreateTime,FIsIncludingUnPosted,FLastUpdateUserId,FLastUpdateTime,");
            sql.append(" FItemType,FDataElement,FItemNumber,FItemName,FDataSource,FCheckAccountId,fremark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ");
        }
        HashMap<String, String> accountMap = new HashMap<String, String>();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Timestamp time = new Timestamp(new Date().getTime());
        boolean isAllZero = true;
        Object[] firstParams = null;
        for (CheckageBillInfo billDetail : billDetails) {
            if (!billDetail.isAddNew() || !billDetail.isExistCheckItem() || isGroup && AccountCheckUtil.isZero(billDetail.getConfirmDebit()) && AccountCheckUtil.isZero(billDetail.getConfirmCredit()) && AccountCheckUtil.isZero(billDetail.getAuditCredit()) && AccountCheckUtil.isZero(billDetail.getAuditDebit()) && AccountCheckUtil.isZero(billDetail.getCredit()) && AccountCheckUtil.isZero(billDetail.getDebit()) && StringUtils.isEmpty((String)billDetail.getRemark())) continue;
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(billDetail.getId().toString());
            params.add(year);
            params.add(period);
            params.add(currencyId);
            params.add(billDetail.getCompany().getId().toString());
            params.add(billDetail.getTargetCompany().getId().toString());
            if (ItemTypeEnum.account.equals((Object)billDetail.getItemType())) {
                String accountId = null;
                if (billDetail.getCheckAccount() != null && billDetail.getCheckAccount().getId() != null) {
                    String checkAccountId = billDetail.getCheckAccount().getId().toString();
                    if (accountMap.containsKey(checkAccountId)) {
                        accountId = (String)accountMap.get(checkAccountId);
                    } else {
                        SQLBuilder accountSql = new SQLBuilder();
                        accountSql.append("select accountView.fid accountId from T_BD_AccountView accountView  \n");
                        accountSql.append("inner join T_Csl_CheckageAccount checkAccount on checkAccount.FACCOUNTTABLEID=accountView.FAccountTableID and checkAccount.fitemnumber=accountView.fnumber \n");
                        accountSql.append("where checkAccount.fid=?   \n", checkAccountId);
                        accountSql.append("and checkAccount.fitemnumber=?  \n", billDetail.getItemNumber());
                        accountSql.append("and accountView.FCompanyId=? ", billDetail.getCompany().getId().toString());
                        IRowSet rs = DbUtil.executeQuery(ctx, accountSql.getSQL(), accountSql.getParams());
                        if (rs.next()) {
                            accountId = rs.getString("accountId");
                        }
                        accountMap.put(checkAccountId, accountId);
                    }
                }
                params.add(accountId);
                params.add(billDetail.getBalType().getValue());
            } else {
                params.add(null);
                params.add(null);
            }
            if (!isGroup) {
                if (billDetail.getConfirmDebit() != null && BigDecimal.ZERO.compareTo(billDetail.getConfirmDebit()) != 0) {
                    params.add(billDetail.getDebit());
                    params.add(null);
                    params.add(AccountCheckUtil.getValue(billDetail.getConfirmDebit()));
                    params.add(null);
                    params.add(billDetail.getConfirmDebit());
                    params.add(null);
                } else {
                    params.add(null);
                    params.add(billDetail.getCredit());
                    params.add(null);
                    params.add(AccountCheckUtil.getValue(billDetail.getConfirmCredit()));
                    params.add(null);
                    params.add(billDetail.getConfirmCredit());
                }
                params.add(billDetail.getBillCompany().getId().toString());
            } else {
                boolean isDebitZero = BigDecimal.ZERO.equals(billDetail.getAuditDebit()) && BigDecimal.ZERO.equals(AccountCheckUtil.getValue(billDetail.getConfirmDebit()));
                params.add(isDebitZero ? null : billDetail.getAuditDebit());
                params.add(isDebitZero ? billDetail.getAuditCredit() : null);
                params.add(isDebitZero ? null : AccountCheckUtil.getValue(billDetail.getConfirmDebit()));
                params.add(isDebitZero ? AccountCheckUtil.getValue(billDetail.getConfirmCredit()) : null);
                params.add(billCompanyIds.get(billDetail.getBillHead().getId().toString() + billDetail.getCompany().getId().toString()));
            }
            params.add(billDetail.getBillHead().getId().toString());
            params.add(ctx.getCaller().toString());
            params.add(time);
            params.add(billDetail.isIsIncludingUnPosted() ? 1 : 0);
            params.add(ctx.getCaller().toString());
            params.add(time);
            params.add(billDetail.getItemType().getValue());
            params.add(billDetail.getDataElement());
            params.add(billDetail.getItemNumber());
            params.add(billDetail.getItemName());
            params.add(2);
            params.add(billDetail.getCheckAccount().getId().toString());
            if (!isGroup) {
                if (AccountCheckUtil.isZero(billDetail.getConfirmDebit()) && AccountCheckUtil.isZero(billDetail.getConfirmCredit()) && StringUtils.isEmpty((String)billDetail.getRemark())) {
                    if (firstParams != null || !noBillCompanyCompanySet.contains(billDetail.getCompany().getId().toString())) continue;
                    params.add(billDetail.getRemark());
                    firstParams = params.toArray();
                    continue;
                }
                isAllZero = false;
            }
            params.add(billDetail.getRemark());
            paramsList.add(params.toArray());
        }
        if (paramsList.size() > 0) {
            DbUtil.executeBatch(ctx, sql.getSQL(), paramsList);
        } else if (!isGroup && isAllZero && firstParams != null) {
            paramsList.add(firstParams);
            SQLBuilder querySql = new SQLBuilder();
            querySql.append("select top 1 fid from T_Csl_CheckageBill \n");
            querySql.append("where FBillHeadId=? ", firstParams[15]);
            querySql.append("and FCompanyId=? \n", firstParams[4]);
            IRowSet executeQuery = DbUtil.executeQuery(ctx, querySql.getSQL(), querySql.getParams());
            if (executeQuery == null || executeQuery.size() < 1) {
                DbUtil.executeBatch(ctx, sql.getSQL(), paramsList);
            }
        }
        billCompanyIds.clear();
    }

    public static boolean isZero(BigDecimal value) {
        return value == null || BigDecimal.ZERO.compareTo(value) == 0;
    }

    public static void updateAuditMoney(Context ctx, List<String> billHeadIds, AuditedStatusEnum aduitStatus) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("update T_Csl_CheckageBill set FAuditDebit=FConfirmDebit,FAuditCredit=FConfirmCredit ");
        sql.append(" where (FAuditDebit<>FConfirmDebit or FAuditCredit<>FConfirmCredit) ");
        sql.append(" and FBillHeadId in (select fid from T_Csl_CheckageBillHead where fid in ", billHeadIds);
        sql.append(" and FAuditedStatus=?)", aduitStatus.getValue());
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public static void updataBillConfirmMoney(Context ctx, List<CheckageBillInfo> resultBills) throws Exception {
        if (resultBills != null && !resultBills.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            SQLBuilder sql = new SQLBuilder();
            sql.append("update T_Csl_CheckageBill set FConfirmDebit=?,FConfirmCredit=?,FAuditDebit=?,FAuditCredit=?,FRemark=? where fid=? ");
            for (CheckageBillInfo info : resultBills) {
                if (info.getConfirmDebit() != null && BigDecimal.ZERO.compareTo(info.getConfirmDebit()) != 0) {
                    params.add(new Object[]{info.getConfirmDebit(), null, info.getConfirmDebit(), null, info.getRemark(), info.getId().toString()});
                    continue;
                }
                params.add(new Object[]{null, info.getConfirmCredit(), null, info.getConfirmCredit(), info.getRemark(), info.getId().toString()});
            }
            DbUtil.executeBatch(ctx, sql.getSQL(), params);
        }
    }

    public static void updateDiff(Context ctx, Collection<String> billHeadIds, String tempTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" update T_Csl_CheckageBillHead a set FCompanyDiff");
        sql.append("      =(select fcompanyDiff from (select isnull(sum(fAuditDebit),0)-isnull(sum(fAuditCredit),0) fcompanyDiff,FBillHeadId from T_Csl_CheckageBill bill ");
        if (!StringUtils.isEmpty((String)tempTable)) {
            sql.append("  where bill.fbillHeadId in(select fid from ").append(tempTable).append(") group by FBillHeadId) diff where a.fid=diff.FBillHeadId) ");
            sql.append(" where fid in(select fid from ").append(tempTable).append(")");
        } else {
            sql.append("  where bill.fbillHeadId in ", billHeadIds).append(" group by FBillHeadId) diff where a.fid=diff.FBillHeadId) ");
            sql.append(" where fid in ", billHeadIds);
        }
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    public static void updataBillAuditMoney(Context ctx, List<CheckageBillInfo> resultBills) throws Exception {
        if (resultBills != null && !resultBills.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            SQLBuilder sql = new SQLBuilder();
            sql.append("update T_Csl_CheckageBill set FAuditDebit=?,FAuditCredit=?,fremark=? where fid=? ");
            for (CheckageBillInfo info : resultBills) {
                boolean isDebitZero = BigDecimal.ZERO.equals(info.getAuditDebit());
                params.add(new Object[]{isDebitZero ? null : info.getAuditDebit(), isDebitZero ? info.getAuditCredit() : null, info.getRemark(), info.getId().toString()});
            }
            DbUtil.executeBatch(ctx, sql.getSQL(), params);
        }
    }

    public static void updateBillHeadStatus(Context ctx, Set billHeadIds, DiffModeEnum diffMode, boolean isAudit, String autoCheckSchmId) throws Exception {
        if (billHeadIds != null && !billHeadIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?", isAudit ? AuditedStatusEnum.AUDITED : AuditedStatusEnum.UNAUDITED);
            sql.append(",FAuditorId=?", isAudit ? ctx.getCaller().toString() : null);
            sql.append(",FAuditedTime=?", isAudit ? new Timestamp(new Date().getTime()) : null);
            if (diffMode != null) {
                sql.append(",FDiffMode=? ", diffMode.getValue());
                sql.append(",FDiffSchmId=? ", autoCheckSchmId);
            }
            sql.append(",FAuditSchmId=? ", isAudit ? autoCheckSchmId : null);
            sql.append(" where fid in", billHeadIds);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    public static void updateBillHeadStatus(Context ctx, CheckageBillHeadInfo billHeadInfo) throws Exception {
        if (billHeadInfo != null && billHeadInfo.getId() != null && billHeadInfo.getAuditedStatus() != null) {
            boolean isAudit;
            SQLBuilder sql = new SQLBuilder();
            sql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?", billHeadInfo.getAuditedStatus().getValue());
            if (billHeadInfo.getCompanyDiff() != null) {
                sql.append(",FcompanyDiff=?", billHeadInfo.getCompanyDiff());
            }
            sql.append(",FAuditorId=?", (isAudit = billHeadInfo.getAuditedStatus().equals((Object)AuditedStatusEnum.AUDITED)) ? ctx.getCaller().toString() : null);
            sql.append(",FAuditedTime=?", isAudit ? new Timestamp(new Date().getTime()) : null);
            if (billHeadInfo.getDiffMode() != null) {
                sql.append(",FDiffMode=? ", billHeadInfo.getDiffMode().getValue());
            }
            sql.append(",FREMARK=? ", billHeadInfo.getRemark());
            sql.append(" where fid =?", billHeadInfo.getId().toString());
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
        }
    }

    public static List<CheckageBillInfo> singleBillDiffHandle(String billHeadId, List<CheckageBillInfo> billInfos, DiffModeEnum diffMode) throws Exception {
        List<CheckageBillInfo> resultBill = null;
        if (DiffModeEnum.FetchBig.equals((Object)diffMode) || DiffModeEnum.FetchSmall.equals((Object)diffMode)) {
            resultBill = AccountCheckUtil.diffFechBigSmall(billHeadId, billInfos, diffMode);
        } else if (DiffModeEnum.FetchCredit.equals((Object)diffMode) || DiffModeEnum.FetchDebit.equals((Object)diffMode)) {
            resultBill = AccountCheckUtil.diffFechDebitCredit(billHeadId, billInfos, diffMode);
        } else if (DiffModeEnum.FetchAverage.equals((Object)diffMode)) {
            resultBill = AccountCheckUtil.diffFechAvg(billHeadId, billInfos);
        } else if (DiffModeEnum.FetchZero.equals((Object)diffMode)) {
            resultBill = AccountCheckUtil.diffFechZero(billHeadId, billInfos);
        }
        return resultBill;
    }

    public static boolean isBillDc(CheckageBillInfo info, BalanceDirectionEnum dc) {
        if (info.getConfirmDebit() != null && info.getConfirmDebit().compareTo(BigDecimal.ZERO) == 0 && info.getConfirmCredit() != null && info.getConfirmCredit().compareTo(BigDecimal.ZERO) == 0 && info.getCheckAccount().getItemDC() != null) {
            return dc.equals((Object)info.getCheckAccount().getItemDC());
        }
        return BalanceDirectionEnum.DEBIT.equals((Object)dc) ? info.getConfirmDebit() != null && (info.getConfirmCredit() == null || info.getConfirmCredit().compareTo(BigDecimal.ZERO) == 0) : info.getConfirmCredit() != null && (info.getConfirmDebit() == null || info.getConfirmDebit().compareTo(BigDecimal.ZERO) == 0);
    }

    public static BigDecimal getValue(Object value) throws Exception {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        try {
            if (value.toString().startsWith("=")) {
                String curValue = value.toString().substring(1);
                if (StringUtils.isEmpty((String)curValue)) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal(value.toString().substring(1));
            }
            return new BigDecimal(value.toString());
        }
        catch (Exception e) {
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"82_AccountCheckUtil") + value.toString() + EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"83_AccountCheckUtil")));
            throw e;
        }
    }

    public static CheckageDiffInfo getCheckageDiffInfo(List<CheckageBillInfo> billInfos) throws Exception {
        BigDecimal ownTotal = BigDecimal.ZERO;
        BigDecimal targetTotal = BigDecimal.ZERO;
        boolean isOwnAllZero = true;
        boolean isTargetAllZero = true;
        String ownCompanyNumber = null;
        String minCompanyNumber = null;
        String targetCompanyNumber = null;
        BigDecimal curValue = null;
        BigDecimal debit = null;
        BigDecimal credit = null;
        String minOwnAccountNumber = null;
        String minTargetAccountNumber = null;
        BigDecimal ownDebitTotal = BigDecimal.ZERO;
        BigDecimal ownCreditTotal = BigDecimal.ZERO;
        BigDecimal targetDebitTotal = BigDecimal.ZERO;
        BigDecimal targetCreditTotal = BigDecimal.ZERO;
        String minOwnDebitAccountNumber = null;
        String minOwnCreditAccountNumber = null;
        String minTargetDebitAccountNumber = null;
        String minTargetCreditAccountNumber = null;
        String minOwnDebitCheckItem = null;
        String minOwnCreditCheckItem = null;
        String minTargetDebitCheckItem = null;
        String minTargetCreditCheckItem = null;
        String minOwnCheckItem = null;
        String minTargetCheckItem = null;
        boolean isZero = false;
        boolean isAccount = true;
        for (int i = 0; i < billInfos.size(); ++i) {
            CheckageBillInfo info = billInfos.get(i);
            isAccount = ItemTypeEnum.account.equals((Object)info.getItemType());
            debit = info.getConfirmDebit();
            credit = info.getConfirmCredit();
            if (debit == null) {
                debit = BigDecimal.ZERO;
            }
            if (credit == null) {
                credit = BigDecimal.ZERO;
            }
            info.setAuditDebit(debit);
            info.setAuditCredit(credit);
            curValue = debit.subtract(credit);
            isZero = curValue.equals(BigDecimal.ZERO);
            if (info.isOwn()) {
                if (ownCompanyNumber == null) {
                    ownCompanyNumber = info.getCompany().getNumber();
                }
                ownTotal = ownTotal.add(curValue);
                if (!isZero) {
                    isOwnAllZero = false;
                }
                if (minOwnAccountNumber == null || minOwnAccountNumber.compareTo(info.getItemNumber()) > 0) {
                    minOwnAccountNumber = info.getItemNumber();
                    minOwnCheckItem = info.getCheckAccount().getId().toString();
                }
                if (AccountCheckUtil.isBillDc(info, BalanceDirectionEnum.DEBIT)) {
                    ownDebitTotal = ownDebitTotal.add(curValue);
                    if (minOwnDebitAccountNumber != null && minOwnDebitAccountNumber.compareTo(info.getItemNumber()) <= 0) continue;
                    minOwnDebitAccountNumber = info.getItemNumber();
                    minOwnDebitCheckItem = info.getCheckAccount().getId().toString();
                    continue;
                }
                ownCreditTotal = ownCreditTotal.add(curValue);
                if (minOwnCreditAccountNumber != null && minOwnCreditAccountNumber.compareTo(info.getItemNumber()) <= 0) continue;
                minOwnCreditAccountNumber = info.getItemNumber();
                minOwnCreditCheckItem = info.getCheckAccount().getId().toString();
                continue;
            }
            if (info.isOwn()) continue;
            if (targetCompanyNumber == null) {
                targetCompanyNumber = info.getCompany().getNumber();
            }
            targetTotal = targetTotal.add(curValue);
            if (!isZero) {
                isTargetAllZero = false;
            }
            if (minTargetAccountNumber == null || minTargetAccountNumber.compareTo(info.getItemNumber()) > 0) {
                minTargetAccountNumber = info.getItemNumber();
                minTargetCheckItem = info.getCheckAccount().getId().toString();
            }
            if (AccountCheckUtil.isBillDc(info, BalanceDirectionEnum.DEBIT)) {
                targetDebitTotal = targetDebitTotal.add(curValue);
                if (minTargetDebitAccountNumber != null && minTargetDebitAccountNumber.compareTo(info.getItemNumber()) <= 0) continue;
                minTargetDebitAccountNumber = info.getItemNumber();
                minTargetDebitCheckItem = info.getCheckAccount().getId().toString();
                continue;
            }
            targetCreditTotal = targetCreditTotal.add(curValue);
            if (minTargetCreditAccountNumber != null && minTargetCreditAccountNumber.compareTo(info.getItemNumber()) <= 0) continue;
            minTargetCreditAccountNumber = info.getItemNumber();
            minTargetCreditCheckItem = info.getCheckAccount().getId().toString();
        }
        minCompanyNumber = ownCompanyNumber != null && targetCompanyNumber != null ? (ownCompanyNumber.compareTo(targetCompanyNumber) > 0 ? targetCompanyNumber : ownCompanyNumber) : (ownCompanyNumber != null ? ownCompanyNumber : targetCompanyNumber);
        BigDecimal reverse = new BigDecimal(-1);
        CheckageDiffInfo diffInfo = new CheckageDiffInfo();
        diffInfo.isOwnAllZero = isOwnAllZero;
        diffInfo.isTargetAllZero = isTargetAllZero;
        diffInfo.minCompanyNumber = minCompanyNumber;
        diffInfo.minOwnAccountNumber = minOwnAccountNumber;
        diffInfo.minTargetAccountNumber = minTargetAccountNumber;
        diffInfo.ownCompanyNumber = ownCompanyNumber;
        diffInfo.ownTotal = ownTotal;
        diffInfo.targetTotal = targetTotal;
        diffInfo.ownCreditTotal = ownCreditTotal.multiply(reverse);
        diffInfo.ownDebitTotal = ownDebitTotal;
        diffInfo.targetCreditTotal = targetCreditTotal.multiply(reverse);
        diffInfo.targetDebitTotal = targetDebitTotal;
        diffInfo.minOwnCreditAccountNumber = minOwnCreditAccountNumber;
        diffInfo.minOwnDebitAccountNumber = minOwnDebitAccountNumber;
        diffInfo.minTargetCreditAccountNumber = minTargetCreditAccountNumber;
        diffInfo.minTargetDebitAccountNumber = minTargetDebitAccountNumber;
        diffInfo.targetCompanyNumber = targetCompanyNumber;
        diffInfo.minOwnDebitCheckItem = minOwnDebitCheckItem;
        diffInfo.minOwnCreditCheckItem = minOwnCreditCheckItem;
        diffInfo.minTargetDebitCheckItem = minTargetDebitCheckItem;
        diffInfo.minTargetCreditCheckItem = minTargetCreditCheckItem;
        diffInfo.minOwnCheckItem = minOwnCheckItem;
        diffInfo.minTargetCheckItem = minTargetCheckItem;
        return diffInfo;
    }

    public static boolean diffFechAvg(List<CheckageBillInfo> checkInfos, BigDecimal avg, CheckageDiffInfo diffInfo, CheckageBillInfo billInfo, boolean isOwnAdjustP) throws Exception {
        BigDecimal reverse = new BigDecimal(-1);
        BigDecimal diff = null;
        if (isOwnAdjustP) {
            if (billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber)) {
                diff = avg.subtract(diffInfo.ownTotal);
            } else if (!billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber)) {
                diff = avg.multiply(reverse).subtract(diffInfo.targetTotal);
            }
        } else if (billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber)) {
            diff = avg.multiply(reverse).subtract(diffInfo.ownTotal);
        } else if (!billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber)) {
            diff = avg.subtract(diffInfo.targetTotal);
        }
        if (diff != null) {
            if (AccountCheckUtil.isBillDc(billInfo, BalanceDirectionEnum.DEBIT)) {
                billInfo.setAuditDebit(diff.add(billInfo.getConfirmDebit()));
            } else {
                billInfo.setAuditCredit(diff.subtract(billInfo.getConfirmCredit()).multiply(reverse));
            }
            checkInfos.add(billInfo);
            if (checkInfos.size() >= 2) {
                return true;
            }
        }
        return false;
    }

    public static List<CheckageBillInfo> diffFechAvg(String billHeadId, List<CheckageBillInfo> billInfos) throws Exception {
        CheckageDiffInfo diffInfo = AccountCheckUtil.getCheckageDiffInfo(billInfos);
        ArrayList<CheckageBillInfo> checkInfos = new ArrayList<CheckageBillInfo>();
        if (diffInfo.isOwnAllZero && diffInfo.isTargetAllZero) {
            return checkInfos;
        }
        BigDecimal avg = diffInfo.ownTotal.abs().add(diffInfo.targetTotal.abs()).divide(new BigDecimal(2), 4, 4);
        boolean isOwnAdjustP = false;
        if (diffInfo.ownTotal.compareTo(BigDecimal.ZERO) != 0 && diffInfo.targetTotal.compareTo(BigDecimal.ZERO) == 0) {
            isOwnAdjustP = diffInfo.ownTotal.compareTo(BigDecimal.ZERO) > 0;
        } else if (diffInfo.targetTotal.compareTo(BigDecimal.ZERO) != 0 && diffInfo.ownTotal.compareTo(BigDecimal.ZERO) == 0) {
            isOwnAdjustP = diffInfo.targetTotal.compareTo(BigDecimal.ZERO) < 0;
        } else {
            boolean isSameDc;
            boolean bl = isSameDc = diffInfo.ownTotal.multiply(diffInfo.targetTotal).compareTo(BigDecimal.ZERO) >= 0;
            isOwnAdjustP = isSameDc ? !diffInfo.minCompanyNumber.equals(diffInfo.ownCompanyNumber) : diffInfo.ownTotal.compareTo(BigDecimal.ZERO) > 0 || diffInfo.targetTotal.compareTo(BigDecimal.ZERO) < 0;
        }
        for (CheckageBillInfo billInfo : billInfos) {
            if (!AccountCheckUtil.diffFechAvg(checkInfos, avg, diffInfo, billInfo, isOwnAdjustP)) continue;
            return checkInfos;
        }
        return checkInfos;
    }

    public static List<CheckageBillInfo> diffFechZero(String billHeadId, List<CheckageBillInfo> billInfos) throws Exception {
        CheckageDiffInfo diffInfo = AccountCheckUtil.getCheckageDiffInfo(billInfos);
        ArrayList<CheckageBillInfo> checkInfos = new ArrayList<CheckageBillInfo>();
        if (diffInfo.isOwnAllZero && diffInfo.isTargetAllZero) {
            return checkInfos;
        }
        for (CheckageBillInfo billInfo : billInfos) {
            AccountCheckUtil.setBillZero(checkInfos, billInfo);
        }
        return checkInfos;
    }

    public static boolean setBillZero(List<CheckageBillInfo> checkInfos, CheckageBillInfo billInfo) throws Exception {
        if (billInfo.getConfirmCredit() != null && billInfo.getConfirmCredit().compareTo(BigDecimal.ZERO) != 0) {
            billInfo.setAuditCredit(BigDecimal.ZERO);
            checkInfos.add(billInfo);
            return true;
        }
        if (billInfo.getConfirmDebit() != null && billInfo.getConfirmDebit().compareTo(BigDecimal.ZERO) != 0) {
            billInfo.setAuditDebit(BigDecimal.ZERO);
            checkInfos.add(billInfo);
            return true;
        }
        return false;
    }

    public static List<CheckageBillInfo> diffFechDebitCredit(String billHeadId, List<CheckageBillInfo> billInfos, DiffModeEnum diffMode) throws Exception {
        CheckageDiffInfo diffInfo = AccountCheckUtil.getCheckageDiffInfo(billInfos);
        ArrayList<CheckageBillInfo> checkInfos = new ArrayList<CheckageBillInfo>();
        if (diffInfo.isOwnAllZero && diffInfo.isTargetAllZero) {
            return checkInfos;
        }
        if (StringUtils.isEmpty((String)diffInfo.targetCompanyNumber)) {
            for (CheckageBillInfo billInfo : billInfos) {
                if ((!diffInfo.isOwnAllZero || billInfo.isOwn()) && (!diffInfo.isTargetAllZero || !billInfo.isOwn())) continue;
                if (DiffModeEnum.FetchDebit.equals((Object)diffMode) && AccountCheckUtil.isBillDc(billInfo, BalanceDirectionEnum.CREDIT)) {
                    billInfo.setAuditCredit(BigDecimal.ZERO);
                } else if (DiffModeEnum.FetchCredit.equals((Object)diffMode) && AccountCheckUtil.isBillDc(billInfo, BalanceDirectionEnum.DEBIT)) {
                    billInfo.setAuditDebit(BigDecimal.ZERO);
                }
                checkInfos.add(billInfo);
            }
            return checkInfos;
        }
        BigDecimal diff = null;
        for (CheckageBillInfo billInfo : billInfos) {
            if (DiffModeEnum.FetchDebit.equals((Object)diffMode)) {
                if (billInfo.isOwn()) {
                    if (diffInfo.minOwnCreditAccountNumber != null && diffInfo.minOwnCreditAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCreditCheckItem)) {
                        diff = diffInfo.targetDebitTotal.subtract(diffInfo.ownCreditTotal);
                        billInfo.setAuditCredit(diff.add(billInfo.getConfirmCredit()));
                        checkInfos.add(billInfo);
                    } else if (StringUtils.isEmpty((String)diffInfo.minOwnCreditAccountNumber) && diffInfo.minOwnAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                        diff = diffInfo.targetDebitTotal.subtract(diffInfo.ownCreditTotal);
                        billInfo.setAuditDebit(billInfo.getConfirmDebit().subtract(diff));
                        checkInfos.add(billInfo);
                    }
                } else if (diffInfo.minTargetCreditAccountNumber != null && diffInfo.minTargetCreditAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCreditCheckItem)) {
                    diff = diffInfo.ownDebitTotal.subtract(diffInfo.targetCreditTotal);
                    billInfo.setAuditCredit(diff.add(billInfo.getConfirmCredit()));
                    checkInfos.add(billInfo);
                } else if (StringUtils.isEmpty((String)diffInfo.minTargetCreditAccountNumber) && diffInfo.minTargetAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                    diff = diffInfo.ownDebitTotal.subtract(diffInfo.targetCreditTotal);
                    billInfo.setAuditDebit(billInfo.getConfirmDebit().subtract(diff));
                    checkInfos.add(billInfo);
                }
            } else if (DiffModeEnum.FetchCredit.equals((Object)diffMode)) {
                if (billInfo.isOwn()) {
                    if (diffInfo.minOwnDebitAccountNumber != null && diffInfo.minOwnDebitAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnDebitCheckItem)) {
                        diff = diffInfo.targetCreditTotal.subtract(diffInfo.ownDebitTotal);
                        billInfo.setAuditDebit(diff.add(billInfo.getConfirmDebit()));
                        checkInfos.add(billInfo);
                    } else if (StringUtils.isEmpty((String)diffInfo.minOwnDebitAccountNumber) && diffInfo.minOwnAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                        diff = diffInfo.targetCreditTotal.subtract(diffInfo.ownDebitTotal);
                        billInfo.setAuditCredit(billInfo.getConfirmCredit().subtract(diff));
                        checkInfos.add(billInfo);
                    }
                } else if (diffInfo.minTargetDebitAccountNumber != null && diffInfo.minTargetDebitAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetDebitCheckItem)) {
                    diff = diffInfo.ownCreditTotal.subtract(diffInfo.targetDebitTotal);
                    billInfo.setAuditDebit(diff.add(billInfo.getConfirmDebit()));
                    checkInfos.add(billInfo);
                } else if (StringUtils.isEmpty((String)diffInfo.minTargetDebitAccountNumber) && diffInfo.minTargetAccountNumber.equals(billInfo.getItemNumber()) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                    diff = diffInfo.ownCreditTotal.subtract(diffInfo.targetDebitTotal);
                    billInfo.setAuditCredit(billInfo.getConfirmCredit().subtract(diff));
                    checkInfos.add(billInfo);
                }
            }
            if (checkInfos.size() < 2) continue;
            return checkInfos;
        }
        return checkInfos;
    }

    public static List<CheckageBillInfo> diffFechBigSmall(String billHeadId, List<CheckageBillInfo> billInfos, DiffModeEnum diffMode) throws Exception {
        CheckageDiffInfo diffInfo = AccountCheckUtil.getCheckageDiffInfo(billInfos);
        ArrayList<CheckageBillInfo> checkInfos = new ArrayList<CheckageBillInfo>();
        if (DiffModeEnum.FetchSmall.equals((Object)diffMode) && diffInfo.isOwnAllZero && diffInfo.isTargetAllZero || DiffModeEnum.FetchBig.equals((Object)diffMode) && (StringUtils.isEmpty((String)diffInfo.targetCompanyNumber) || StringUtils.isEmpty((String)diffInfo.ownCompanyNumber))) {
            return checkInfos;
        }
        if (DiffModeEnum.FetchSmall.equals((Object)diffMode) && (StringUtils.isEmpty((String)diffInfo.targetCompanyNumber) || StringUtils.isEmpty((String)diffInfo.ownCompanyNumber))) {
            for (CheckageBillInfo billInfo : billInfos) {
                if ((!diffInfo.isOwnAllZero || billInfo.isOwn()) && (!diffInfo.isTargetAllZero || !billInfo.isOwn())) continue;
                billInfo.setAuditCredit(BigDecimal.ZERO);
                billInfo.setAuditDebit(BigDecimal.ZERO);
                checkInfos.add(billInfo);
            }
            return checkInfos;
        }
        boolean isOwnBig = false;
        boolean isTargetBig = false;
        boolean isEqual = false;
        boolean bl = isOwnBig = diffInfo.ownTotal.abs().compareTo(diffInfo.targetTotal.abs()) > 0;
        if (!isOwnBig) {
            boolean bl2 = isTargetBig = diffInfo.ownTotal.abs().compareTo(diffInfo.targetTotal.abs()) < 0;
        }
        if (!isTargetBig) {
            isEqual = diffInfo.ownTotal.abs().compareTo(diffInfo.targetTotal.abs()) == 0 && diffInfo.ownTotal.compareTo(diffInfo.targetTotal) != 0;
        }
        BigDecimal reverse = new BigDecimal(-1);
        BigDecimal diff = null;
        boolean isHandle = false;
        for (CheckageBillInfo billInfo : billInfos) {
            if (DiffModeEnum.FetchBig.equals((Object)diffMode)) {
                if (isOwnBig && !billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                    diff = diffInfo.ownTotal.multiply(reverse).subtract(diffInfo.targetTotal);
                    isHandle = true;
                } else if (isTargetBig && billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                    diff = diffInfo.targetTotal.multiply(reverse).subtract(diffInfo.ownTotal);
                    isHandle = true;
                } else if (isEqual && billInfo.getCompany().getNumber().equals(diffInfo.minCompanyNumber)) {
                    if (diffInfo.minCompanyNumber.equals(diffInfo.ownCompanyNumber) && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                        diff = diffInfo.targetTotal.multiply(reverse).subtract(diffInfo.ownTotal);
                        isHandle = true;
                    } else if (!diffInfo.minCompanyNumber.equals(diffInfo.ownCompanyNumber) && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                        diff = diffInfo.ownTotal.multiply(reverse).subtract(diffInfo.targetTotal);
                        isHandle = true;
                    }
                }
            } else if (DiffModeEnum.FetchSmall.equals((Object)diffMode)) {
                if (isTargetBig && !billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                    diff = diffInfo.ownTotal.multiply(reverse).subtract(diffInfo.targetTotal);
                    isHandle = true;
                } else if (isOwnBig && billInfo.isOwn() && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                    diff = diffInfo.targetTotal.multiply(reverse).subtract(diffInfo.ownTotal);
                    isHandle = true;
                } else if (isEqual && billInfo.getCompany().getNumber().equals(diffInfo.minCompanyNumber)) {
                    if (diffInfo.minCompanyNumber.equals(diffInfo.ownCompanyNumber) && billInfo.getItemNumber().equals(diffInfo.minOwnAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minOwnCheckItem)) {
                        diff = diffInfo.targetTotal.multiply(reverse).subtract(diffInfo.ownTotal);
                        isHandle = true;
                    } else if (!diffInfo.minCompanyNumber.equals(diffInfo.ownCompanyNumber) && billInfo.getItemNumber().equals(diffInfo.minTargetAccountNumber) && billInfo.getCheckAccount().getId().toString().equals(diffInfo.minTargetCheckItem)) {
                        diff = diffInfo.ownTotal.multiply(reverse).subtract(diffInfo.targetTotal);
                        isHandle = true;
                    }
                }
            }
            if (!isHandle) continue;
            if (AccountCheckUtil.isBillDc(billInfo, BalanceDirectionEnum.DEBIT)) {
                billInfo.setAuditDebit(billInfo.getConfirmDebit().add(diff));
            } else {
                billInfo.setAuditCredit(billInfo.getConfirmCredit().subtract(diff));
            }
            checkInfos.add(billInfo);
            return checkInfos;
        }
        return checkInfos;
    }

    public static Set<String> getSelectBlocks(KDTable tblMain, String colKey) {
        int selectSize = tblMain.getSelectManager().size();
        if (selectSize < 1) {
            return null;
        }
        HashSet<String> keySet = new HashSet<String>();
        KDTSelectBlock[] selectBlocks = new KDTSelectBlock[selectSize];
        for (int i = 0; i < selectSize; ++i) {
            selectBlocks[i] = tblMain.getSelectManager().get(i);
            for (int start = selectBlocks[i].getBeginRow(); start <= selectBlocks[i].getEndRow(); ++start) {
                if (tblMain.getCell(start, colKey).getValue() == null) continue;
                keySet.add(tblMain.getCell(start, colKey).getValue().toString());
            }
        }
        return keySet;
    }

    public static void setSelectBlocks(KDTable tblMain, Set<String> selectBlocks, KDTSelectListener selectListener, String colKey) {
        if (selectBlocks == null || selectBlocks.isEmpty()) {
            return;
        }
        if (selectListener != null) {
            tblMain.removeKDTSelectListener(selectListener);
        }
        int rowCount = tblMain.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            Object value = tblMain.getCell(i, colKey).getValue();
            if (value == null || !selectBlocks.contains(value.toString())) continue;
            KDTSelectBlock sbTemp = new KDTSelectBlock();
            sbTemp.setTable(tblMain);
            sbTemp.setTop(i);
            sbTemp.setBottom(i);
            sbTemp.setLeft(0);
            sbTemp.setRight(tblMain.getColumnCount() - 1);
            sbTemp.setMode(2);
            tblMain.getSelectManager().add(sbTemp);
            break;
        }
        if (selectListener != null) {
            tblMain.addKDTSelectListener(selectListener);
        }
    }

    public static Date getDate(KDSpinner kdYear, KDSpinner kdPeriod, KDComboBox kdPeriodType) throws Exception {
        return RPTDateUtil.getPeriodLastDate((int)kdYear.getIntegerVlaue(), (int)kdPeriod.getIntegerVlaue(), (RptPeriodTypeEnum)(kdPeriodType == null ? RptPeriodTypeEnum.MONTHLY : (RptPeriodTypeEnum)kdPeriodType.getSelectedItem()));
    }

    public static void initYearPeriodAndPeriodType(KDSpinner kdYear, KDSpinner kdPeriod, KDComboBox kdPeriodType, KDComboBox kdCheckPeriod, Date[] date, String selectAll, OrgTreeCollection orgTreeColl, KDBizPromptBox kdOrgTree, KDBizPromptBox kdOrgUnit, KDBizPromptBox kdCompany, ListUI listui) throws Exception {
        AccountCheckUtil.initYearPeriodAndPeriodType(kdYear, kdPeriod, kdPeriodType, kdCheckPeriod, date, selectAll, orgTreeColl, kdOrgTree, null, kdOrgUnit, kdCompany, listui);
    }

    public static void initYearPeriodAndPeriodType(KDSpinner kdYear, KDSpinner kdPeriod, KDComboBox kdPeriodType, KDComboBox kdCheckPeriod, Date[] date, String selectAll, OrgTreeCollection orgTreeColl, KDComboBox kdOrgTreeCB, KDBizPromptBox kdOrgUnit, KDBizPromptBox kdCompany, ListUI listui) throws Exception {
        AccountCheckUtil.initYearPeriodAndPeriodType(kdYear, kdPeriod, kdPeriodType, kdCheckPeriod, date, selectAll, orgTreeColl, null, kdOrgTreeCB, kdOrgUnit, kdCompany, listui);
    }

    public static void initYearPeriodAndPeriodType(final KDSpinner kdYear, final KDSpinner kdPeriod, final KDComboBox kdPeriodType, final KDComboBox kdCheckPeriod, final Date[] date, final String selectAll, final OrgTreeCollection orgTreeColl, final KDBizPromptBox kdOrgTree, final KDComboBox kdOrgTreeCB, final KDBizPromptBox kdOrgUnit, final KDBizPromptBox kdCompany, final ListUI listui) throws Exception {
        CslRptUIUtil.setSpineRange((KDSpinner)kdYear, (int)1900, (int)2999, (boolean)true, (boolean)true);
        final RptPeriodTypeEnum curPeriodType = kdPeriodType == null ? RptPeriodTypeEnum.MONTHLY : (RptPeriodTypeEnum)kdPeriodType.getSelectedItem();
        CslWorkTableUIUtil.setSpineRangeByPeriodType((KDSpinner)kdPeriod, (RptPeriodTypeEnum)curPeriodType, (int)kdYear.getIntegerVlaue(), (boolean)true, (boolean)true);
        if (kdPeriodType != null) {
            kdPeriodType.removeItem((Object)RptPeriodTypeEnum.DAILY);
            kdPeriodType.removeItem((Object)RptPeriodTypeEnum.WEEKLY);
            kdPeriodType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    try {
                        CslWorkTableUIUtil.setSpineRangeByPeriodType((KDSpinner)kdPeriod, (RptPeriodTypeEnum)((RptPeriodTypeEnum)kdPeriodType.getSelectedItem()), (int)kdYear.getIntegerVlaue(), (boolean)true, (boolean)true);
                        int[] yearPeriod = RPTDateUtil.getPeriod((Date)date[0], (RptPeriodTypeEnum)((RptPeriodTypeEnum)kdPeriodType.getSelectedItem()));
                        kdYear.setValue((Object)yearPeriod[0], false);
                        kdPeriod.setValue((Object)yearPeriod[1], false);
                        AccountCheckUtil.changeCheckPeriod((RptPeriodTypeEnum)kdPeriodType.getSelectedItem(), kdCheckPeriod, kdPeriod.getIntegerVlaue(), selectAll);
                        date[0] = AccountCheckUtil.getDate(kdYear, kdPeriod, kdPeriodType);
                        AccountCheckUtil.refreshTree(date[0], orgTreeColl, kdOrgTree, kdOrgTreeCB, kdOrgUnit, kdCompany, listui);
                    }
                    catch (Exception e1) {
                        logger.error((Object)"periodType.addItemListener", (Throwable)e1);
                        ExceptionHandler.handle((Throwable)e1);
                    }
                }
            });
        }
        kdYear.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    CslWorkTableUIUtil.setSpineRangeByPeriodType((KDSpinner)kdPeriod, (RptPeriodTypeEnum)curPeriodType, (int)kdYear.getIntegerVlaue(), (boolean)true, (boolean)true);
                    date[0] = AccountCheckUtil.getDate(kdYear, kdPeriod, kdPeriodType);
                    AccountCheckUtil.changeCheckPeriod(curPeriodType, kdCheckPeriod, kdPeriod.getIntegerVlaue(), selectAll);
                    AccountCheckUtil.refreshTree(date[0], orgTreeColl, kdOrgTree, kdOrgTreeCB, kdOrgUnit, kdCompany, listui);
                }
                catch (Exception e1) {
                    logger.error((Object)"year.addChangeListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        kdPeriod.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    AccountCheckUtil.changeCheckPeriod(curPeriodType, kdCheckPeriod, kdPeriod.getIntegerVlaue(), selectAll);
                    date[0] = AccountCheckUtil.getDate(kdYear, kdPeriod, kdPeriodType);
                    AccountCheckUtil.refreshTree(date[0], orgTreeColl, kdOrgTree, kdOrgTreeCB, kdOrgUnit, kdCompany, listui);
                }
                catch (Exception e1) {
                    logger.error((Object)"period.addChangeListener", (Throwable)e1);
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        if (kdPeriodType != null) {
            kdPeriodType.setSelectedIndex(0);
        }
        int[] yearPeriod = RPTDateUtil.getPeriod((Date)date[0], (RptPeriodTypeEnum)curPeriodType);
        kdYear.setValue((Object)yearPeriod[0], false);
        kdPeriod.setValue((Object)yearPeriod[1], false);
        AccountCheckUtil.changeCheckPeriod(curPeriodType, kdCheckPeriod, kdPeriod.getIntegerVlaue(), selectAll);
    }

    public static void refreshTree(Date date, OrgTreeCollection orgTreeColl, KDComboBox kdOrgTreeCB, ListUI listui) throws Exception {
        if (kdOrgTreeCB != null) {
            AccountCheckUtil.refreshOrgTree(date, kdOrgTreeCB, orgTreeColl, listui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshOrgTree(Date date, KDComboBox kdOrgTreeCB, OrgTreeCollection orgTreeColl, ListUI listui) throws Exception {
        boolean isVersionChange = false;
        int selectIndex = -1;
        try {
            if (listui instanceof CheckageStatusListUI) {
                ((CheckageStatusListUI)listui).setFireOrgTreeChange(false);
            }
            OrgTreeInfo selectOrgTree = (OrgTreeInfo)kdOrgTreeCB.getSelectedItem();
            kdOrgTreeCB.removeAllItems();
            String number = selectOrgTree == null ? null : selectOrgTree.getNumber();
            OrgTreeInfo curOrgTree = null;
            OrgTreeCollection curOrgTreeColl = CslWorkTableUIUtil.getOrgTreeColl((OrgTreeCollection)orgTreeColl, (Date)date);
            for (int i = 0; i < curOrgTreeColl.size(); ++i) {
                curOrgTree = curOrgTreeColl.get(i);
                kdOrgTreeCB.addItem((Object)curOrgTree);
                if (selectIndex >= 0 || number == null || !number.equals(curOrgTree.getNumber())) continue;
                selectIndex = i;
                if (selectOrgTree.getId().toString().equals(curOrgTree.getId().toString())) continue;
                isVersionChange = true;
            }
            if (selectIndex >= 0 && !isVersionChange) {
                kdOrgTreeCB.setSelectedIndex(selectIndex);
            }
        }
        finally {
            if (listui instanceof CheckageStatusListUI) {
                ((CheckageStatusListUI)listui).setFireOrgTreeChange(true);
            }
        }
        if (selectIndex >= 0 && isVersionChange) {
            AccountCheckUtil.setSelectedFireChanged(kdOrgTreeCB, selectIndex);
        }
        if (selectIndex < 0 && kdOrgTreeCB.getItemCount() > 0) {
            AccountCheckUtil.setSelectedFireChanged(kdOrgTreeCB, 0);
        }
    }

    public static void setSelectedFireChanged(KDComboBox kdOrgTreeCB, int selectIndex) {
        kdOrgTreeCB.setSelectedIndex(selectIndex);
        if (selectIndex == 0) {
            try {
                Method method = KDComboBox.class.getDeclaredMethod("selectedItemChanged", new Class[0]);
                NewRptUtil.makeAccessible(method);
                method.invoke((Object)kdOrgTreeCB, new Object[0]);
            }
            catch (Exception ex) {
                logger.error((Object)"setSelectedFireChanged error.", (Throwable)ex);
            }
        }
    }

    public static void refreshTree(Date date, OrgTreeCollection orgTreeColl, KDBizPromptBox kdOrgTree, KDComboBox kdOrgTreeCB, KDBizPromptBox kdOrgUnit, KDBizPromptBox kdCompany, ListUI listui) throws Exception {
        if (kdOrgTree == null && kdOrgTreeCB != null) {
            AccountCheckUtil.refreshOrgTree(date, kdOrgTreeCB, orgTreeColl, listui);
            return;
        }
        ((MnsUnionF7)kdOrgTree.getSelector()).setOrgTreeColl(CslWorkTableUIUtil.getOrgTreeColl((OrgTreeCollection)orgTreeColl, (Date)date));
        ((MnsUnionF7)kdOrgTree.getSelector()).reRoadOrgTree();
        if (kdOrgTree.getData() != null) {
            OrgTreeInfo orgTreeInfo = CslWorkTableUIUtil.getOrgTreeInfo((OrgTreeCollection)orgTreeColl, (Date)date, (String)((OrgTreeInfo)kdOrgTree.getData()).getNumber());
            if (orgTreeInfo == null) {
                kdOrgTree.setData(null);
                if (kdOrgUnit != null) {
                    kdOrgUnit.setValue(null);
                }
                if (kdCompany != null) {
                    kdCompany.setValue(null);
                }
                if (listui != null) {
                    listui.actionRefresh_actionPerformed(null);
                }
            } else if (!((OrgTreeInfo)kdOrgTree.getData()).getId().toString().equals(orgTreeInfo.getId().toString())) {
                kdOrgTree.setData((Object)orgTreeInfo);
                if (kdCompany != null) {
                    ((UnionF7Helper.UnionF7)kdCompany.getSelector()).setTreeID(orgTreeInfo.getId().toString());
                }
                if (kdOrgUnit != null) {
                    ((UnionF7Helper.UnionF7)kdOrgUnit.getSelector()).setTreeID(orgTreeInfo.getId().toString());
                    if (kdOrgUnit.getValue() != null) {
                        OrgStructureCollection coll;
                        String number = ((FullOrgUnitInfo)kdOrgUnit.getValue()).getNumber();
                        EntityViewInfo viewInfo = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        viewInfo.setFilter(filter);
                        viewInfo.getSelector().add("unit.id");
                        viewInfo.getSelector().add("unit.number");
                        viewInfo.getSelector().add("unit.name");
                        filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeInfo.getId().toString(), CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("unit.number", (Object)number, CompareType.EQUALS));
                        String permissionItem = ((MnsUnionF7)kdOrgTree.getSelector()).getPermissionItem();
                        if (!StringUtils.isEmpty((String)permissionItem)) {
                            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                            filter.mergeFilter(AccountCheckUtil.getOrgIdsByDataPermFilter(orgTreeInfo, permissionItem, userId), "and");
                        }
                        if ((coll = OrgStructureFactory.getRemoteInstance().getOrgStructureCollection(viewInfo)) != null && !coll.isEmpty()) {
                            kdOrgUnit.setValue((Object)coll.get(0).getUnit());
                        } else {
                            kdOrgUnit.setValue(null);
                        }
                    }
                }
                if (listui != null && !(listui instanceof GroupCheckageListUI) && !(listui instanceof GroupCreateElimListUI)) {
                    listui.actionRefresh_actionPerformed(null);
                }
            } else if (listui != null) {
                listui.actionRefresh_actionPerformed(null);
            }
        }
    }

    public static FilterInfo getOrgIdsByDataPermFilter(OrgTreeInfo treeInfo, String permissionItem, String userId) {
        StringBuffer sql = new StringBuffer();
        try {
            if (treeInfo != null) {
                sql.append(" select distinct FOrgID from (");
                sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID FROM T_PM_UserOrgPerm UserOrgPerm ").append(" inner join T_PM_PERMITEM item on item.fid=UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner ='").append(userId).append("'").append(" AND item.FNumber='").append(permissionItem).append("'").append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" inner join T_PM_PERMITEM item on item.fid=RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID ='").append(userId).append("'").append(" AND item.FNumber ='").append(permissionItem).append("'");
                sql.append(") orgTable ");
            }
        }
        catch (Exception e) {
            sql.setLength(0);
            logger.error((Object)"getQueryPermissionSQL error.", (Throwable)e);
        }
        if (sql.length() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("unit.id", (Object)sql.toString(), CompareType.INNER));
            return filter;
        }
        return null;
    }

    public static void initCurrency(KDComboBox kdCurrency) throws Exception {
        kdCurrency.removeAllItems();
        CurrencyCollection currencyCol = InitDataFacadaFactory.getRemoteInstance().getCurrencyNoGLC();
        for (int i = 0; i < currencyCol.size(); ++i) {
            kdCurrency.addItem((Object)currencyCol.get(i));
        }
        CurrencyInfo naturalCurrency = RptUtilForClient.getBasicCurrency();
        if (naturalCurrency != null) {
            kdCurrency.setSelectedItem((Object)naturalCurrency);
        }
    }

    public static List preCreateElim(Context ctx, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        TempTablePool tmpTablePool = null;
        ArrayList<String> clearTmpTables = new ArrayList<String>();
        try {
            tmpTablePool = TempTablePool.getInstance((Context)ctx);
            if (!StringUtils.isEmpty((String)filterInfo.tmpTable)) {
                clearTmpTables.add(filterInfo.tmpTable);
                filterInfo.tmpTable = null;
            }
            if (!StringUtils.isEmpty((String)filterInfo.billLinkElimTable)) {
                clearTmpTables.add(filterInfo.billLinkElimTable);
                filterInfo.billLinkElimTable = null;
            }
            AccountCheckUtil.releaseTables(ctx, tmpTablePool, clearTmpTables);
            clearTmpTables.clear();
            if (!StringUtils.isEmpty((String)filterInfo.orgUnitId) && !StringUtils.isEmpty((String)filterInfo.treeId)) {
                String billLinkElimTmp;
                boolean isAutoCheck;
                String tmpCompanyTable = null;
                boolean bl = isAutoCheck = !StringUtils.isEmpty((String)filterInfo.autoCheckSchmId);
                if (isAutoCheck && !StringUtils.isEmpty((String)filterInfo.sameParentCompanyTbl)) {
                    tmpCompanyTable = filterInfo.sameParentCompanyTbl;
                } else {
                    tmpCompanyTable = AccountCheckUtil.getSameParentCompanyOrgUnit(ctx, filterInfo);
                    if (isAutoCheck) {
                        filterInfo.sameParentCompanyTbl = tmpCompanyTable;
                    }
                }
                if (!isAutoCheck) {
                    clearTmpTables.add(tmpCompanyTable);
                }
                if (!StringUtils.isEmpty((String)tmpCompanyTable) && !StringUtils.isEmpty((String)(billLinkElimTmp = AccountCheckUtil.getBillLinkElimTmpTable(ctx, filterInfo, tmpCompanyTable)))) {
                    filterInfo.billLinkElimTable = billLinkElimTmp;
                    AccountCheckUtil.getPreElimTmpTable(ctx, filterInfo);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"preCreateElim error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            AccountCheckUtil.releaseTables(ctx, tmpTablePool, clearTmpTables);
        }
        return null;
    }

    public static Map<String, Map<String, Object>> getDiffValueRows(Context ctx, CheckageFilterInfo filterInfo) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select Fitemid,FDataElement,FDC,FTempletId,FSummary ");
        sql.append(" from t_csl_elimTempletEntry ");
        sql.append(" where FTempletId in(select distinct felimTmpId from ").append(filterInfo.billLinkElimTable).append(") ");
        sql.append(" and FDataSrcType=?", 2);
        sql.append(" order by FTempletId,fseq asc ");
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        HashMap<String, Map<String, Object>> diffValueRows = new HashMap<String, Map<String, Object>>();
        while (rowSet.next()) {
            String templateId = rowSet.getString("FTempletId");
            HashMap<String, Object> row = (HashMap<String, Object>)diffValueRows.get(templateId);
            if (row != null) continue;
            row = new HashMap<String, Object>();
            diffValueRows.put(templateId, row);
            row.put("Fitemid", rowSet.getString("Fitemid"));
            row.put("FDataElement", rowSet.getInt("FDataElement"));
            row.put("FDC", rowSet.getInt("FDC"));
            row.put("FSummary", rowSet.getString("FSummary"));
        }
        return diffValueRows;
    }

    public static String getPreElimTmpTable(Context ctx, CheckageFilterInfo filterInfo) throws Exception {
        TempTablePool tmpTablePool = null;
        try {
            Map<String, Object> diffRow;
            boolean isDelete;
            Map<String, Map<String, Object>> diffValueRows = AccountCheckUtil.getDiffValueRows(ctx, filterInfo);
            String lang = ctx.getLocale().getLanguage();
            tmpTablePool = TempTablePool.getInstance((Context)ctx);
            SQLBuilder sql = new SQLBuilder();
            sql.append("create table t_csl_preElim(fnumber varchar(92),summary Nvarchar(1000),elimTemplateId varchar(44),companyId varchar(44),companyNumber nvarchar(80),targetCompanyId varchar(44),");
            sql.append(" eliminationModeId varchar(44),itemId varchar(44),dataElement int,debit NUMERIC(21,6),credit NUMERIC(21,6),diff NUMERIC(21,6),");
            sql.append(" elimType int,isSupportImport int,dc int,seq int,fcompanySort varchar(88),isDiff int,forgUnitId varchar(44))");
            String preElimTmpTable = tmpTablePool.createTempTable(sql.getSQL());
            sql.reset();
            sql.append(" select elimtable.fcompanySort,elimtable.felimTmpId elimTemplateId,bill.fcompanyId companyId,unit.fnumber companyNumber,bill.ftargetCompanyId targetCompanyId,");
            sql.append(" elimtable.FSummary summary,item.fid itemId,elimtable.FDataElement dataElement,");
            sql.append(" isnull(sum(case when elimtable.fdc=1 then bill.FAuditDebit else bill.FAuditCredit end),0) dcValue,elimtable.FElimType elimType,elimtable.FIsCitedByLater isSupportImport");
            sql.append(" ,item.fdc dc,elimtable.fseq seq,elimtable.feliminationModeId eliminationModeId,elimtable.fcompanySort,elimD.fnumber elimNumber,elimtable.forgUnitId ");
            sql.append(" from T_Csl_CheckageBill bill ");
            sql.append(" inner join ").append(filterInfo.billLinkElimTable).append(" elimtable on elimtable.fbillId = bill.fid ");
            sql.append(" inner join t_csl_rptitem item on item.fid=elimtable.FItemID ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=bill.fcompanyId ");
            sql.append(" left join (select distinct elim.ftempletid,case when elimEntry.fcompanyid>elimEntry.ftargetCompanyid then concat(elimEntry.fcompanyid,elimEntry.ftargetCompanyid)  ");
            sql.append("      \t\t else concat(elimEntry.ftargetCompanyid,elimEntry.fcompanyid) end fcompanySort,elim.fnumber  from t_csl_elimination elim");
            sql.append("             inner join t_csl_eliminationentry elimEntry on elim.fid=elimEntry.feliminationid ");
            sql.append("             where elim.FORGBOUNDID=?", filterInfo.treeId).append(" and elim.forgunit=?", filterInfo.orgUnitId);
            sql.append("             and elim.fyear=?", filterInfo.year).append(" and elim.fperiod=?", filterInfo.period).append(" and elim.fcurrencyId=?", filterInfo.currencyId);
            sql.append("             and elim.fperiodType=? ", filterInfo.periodType).append(" and (elim.fnumber like 'WLDZ_%' OR elim.fnumber like 'JYDZ_%' ) ");
            sql.append("              ) elimD on elimD.ftempletid=elimtable.felimTmpId and elimD.fcompanySort=elimtable.fcompanySort ");
            sql.append(" group by elimtable.fcompanySort,elimtable.felimTmpId,bill.fcompanyId,unit.fnumber,bill.ftargetCompanyId,elimtable.FSummary,item.fid,");
            sql.append(" elimtable.FDataElement,elimtable.FElimType,elimtable.FIsCitedByLater,item.fdc,elimtable.fseq,elimtable.feliminationModeId,elimD.fnumber,elimtable.forgUnitId ");
            sql.append(" order by elimtable.forgUnitId,elimtable.fcompanySort,elimtable.felimTmpId,bill.fcompanyId,elimtable.fseq");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            int[] maxNumbers = null;
            ArrayList<Object[]> datas = new ArrayList<Object[]>();
            int elimStartIndex = 0;
            BigDecimal diffValue = BigDecimal.ZERO;
            String curNumber = null;
            String preRowKey = null;
            String rowKey = null;
            Object[] rowData = null;
            String prElimTemplateId = null;
            String prEliminationModeId = null;
            int prElimType = -1;
            int prIsSupportImport = -1;
            String elimNumber = null;
            String ownCompanyId = null;
            String targetCompanyId = null;
            BigDecimal ownValue = BigDecimal.ZERO;
            BigDecimal targetValue = BigDecimal.ZERO;
            String ownCompanyNumber = null;
            String targetCompanyNumber = null;
            String orgUnitId = null;
            HashSet<String> elimNumbers = new HashSet<String>();
            while (rowSet.next()) {
                if (maxNumbers == null) {
                    maxNumbers = new int[]{0, 0};
                }
                if (!StringUtils.isEmpty((String)(elimNumber = rowSet.getString("elimNumber")))) {
                    elimNumbers.add(elimNumber);
                }
                rowKey = rowSet.getString("fcompanySort") + rowSet.getString("elimTemplateId");
                if (preRowKey == null || !rowKey.equals(preRowKey)) {
                    isDelete = false;
                    diffRow = diffValueRows.get(prElimTemplateId);
                    if (diffRow != null && !diffRow.isEmpty()) {
                        boolean isOwnDebit = false;
                        if (ownValue.compareTo(BigDecimal.ZERO) > 0 && targetValue.compareTo(BigDecimal.ZERO) < 0) {
                            isOwnDebit = true;
                        } else if (targetValue.compareTo(BigDecimal.ZERO) > 0 && ownValue.compareTo(BigDecimal.ZERO) < 0) {
                            isOwnDebit = false;
                        } else if (targetValue.compareTo(BigDecimal.ZERO) >= 0 && ownValue.compareTo(BigDecimal.ZERO) >= 0 && ownValue.compareTo(targetValue) > 0) {
                            isOwnDebit = true;
                        }
                        int dc = (Integer)diffRow.get("FDC");
                        rowData = new Object[19];
                        rowData[0] = curNumber;
                        rowData[1] = diffRow.get("FSummary");
                        rowData[2] = prElimTemplateId;
                        if (isOwnDebit && dc == 1 || !isOwnDebit && dc == 0) {
                            rowData[3] = ownCompanyId;
                            rowData[4] = targetCompanyId;
                            rowData[15] = ownCompanyNumber;
                        } else {
                            rowData[3] = targetCompanyId;
                            rowData[4] = ownCompanyId;
                            rowData[15] = targetCompanyNumber != null ? targetCompanyNumber : ownCompanyNumber;
                        }
                        rowData[5] = prEliminationModeId;
                        rowData[6] = diffRow.get("Fitemid");
                        rowData[7] = diffRow.get("FDataElement");
                        rowData[8] = dc == 1 ? diffValue : null;
                        rowData[9] = dc == 1 ? null : diffValue.multiply(new BigDecimal(-1));
                        rowData[11] = prElimType;
                        rowData[12] = prIsSupportImport;
                        rowData[13] = dc;
                        rowData[14] = 999;
                        rowData[17] = 1;
                        rowData[18] = orgUnitId;
                        if (!AccountCheckUtil.isZero((BigDecimal)rowData[8]) || !AccountCheckUtil.isZero((BigDecimal)rowData[9])) {
                            datas.add(rowData);
                        }
                        diffValue = BigDecimal.ZERO;
                    }
                    if (preRowKey != null) {
                        boolean isEqual;
                        boolean bl = isEqual = BigDecimal.ZERO.compareTo(diffValue) == 0;
                        if (1 == filterInfo.isDCEquals) {
                            isDelete = !isEqual;
                        } else if (0 == filterInfo.isDCEquals) {
                            isDelete = isEqual;
                        }
                    }
                    for (int i = datas.size() - 1; i >= elimStartIndex; --i) {
                        if (isDelete) {
                            datas.remove(i);
                            continue;
                        }
                        ((Object[])datas.get((int)i))[10] = diffValue;
                    }
                    if (!isDelete) {
                        curNumber = AccountCheckUtil.getElimNumber(maxNumbers, filterInfo.currencyNumber, rowSet.getInt("elimType"), false);
                    }
                    preRowKey = rowKey;
                    diffValue = BigDecimal.ZERO;
                    elimStartIndex = datas.size();
                    ownCompanyId = null;
                    targetCompanyId = null;
                    ownValue = BigDecimal.ZERO;
                    targetValue = BigDecimal.ZERO;
                    ownCompanyNumber = null;
                    targetCompanyNumber = null;
                    orgUnitId = null;
                }
                int i = 0;
                rowData = new Object[19];
                rowData[i++] = curNumber;
                rowData[i++] = rowSet.getString("summary");
                rowData[i++] = rowSet.getString("elimTemplateId");
                String companyId = rowSet.getString("companyId");
                String targCompanyId = rowSet.getString("targetCompanyId");
                String companyNumber = rowSet.getString("companyNumber");
                rowData[i++] = companyId;
                rowData[i++] = targCompanyId;
                rowData[i++] = rowSet.getString("eliminationModeId");
                rowData[i++] = rowSet.getString("itemId");
                rowData[i++] = rowSet.getInt("dataElement");
                int dc = rowSet.getInt("dc");
                BigDecimal dcValue = rowSet.getBigDecimal("dcValue");
                orgUnitId = rowSet.getString("forgUnitId");
                dc = dc == 0 ? -1 : 1;
                diffValue = diffValue.add(dcValue.multiply(new BigDecimal(dc)));
                rowData[i++] = dc == 1 ? null : dcValue;
                rowData[i++] = dc == 1 ? dcValue : null;
                rowData[i++] = BigDecimal.ZERO;
                rowData[i++] = rowSet.getInt("elimType");
                rowData[i++] = rowSet.getInt("isSupportImport");
                rowData[i++] = rowSet.getInt("dc");
                rowData[i++] = rowSet.getInt("seq");
                rowData[i++] = companyNumber;
                rowData[i++] = rowSet.getString("fcompanySort");
                rowData[i++] = 0;
                rowData[i++] = orgUnitId;
                if (!AccountCheckUtil.isZero((BigDecimal)rowData[8]) || !AccountCheckUtil.isZero((BigDecimal)rowData[9])) {
                    datas.add(rowData);
                }
                prElimTemplateId = rowSet.getString("elimTemplateId");
                prEliminationModeId = rowSet.getString("eliminationModeId");
                prElimType = rowSet.getInt("elimType");
                prIsSupportImport = rowSet.getInt("isSupportImport");
                if (ownCompanyId == null && targetCompanyId == null) {
                    ownCompanyId = companyId;
                    targetCompanyId = targCompanyId;
                    ownCompanyNumber = companyNumber;
                    ownValue = ownValue.add(dcValue.multiply(new BigDecimal(dc * -1)));
                    continue;
                }
                if (ownCompanyId == null || targetCompanyId == null) continue;
                if (ownCompanyId.equals(companyId) && targetCompanyId.equals(targCompanyId)) {
                    ownValue = ownValue.add(dcValue.multiply(new BigDecimal(dc * -1)));
                    continue;
                }
                if (!ownCompanyId.equals(targCompanyId) || !targetCompanyId.equals(companyId)) continue;
                targetValue = targetValue.add(dcValue.multiply(new BigDecimal(dc * -1)));
                targetCompanyNumber = companyNumber;
            }
            isDelete = false;
            diffRow = diffValueRows.get(prElimTemplateId);
            if (diffRow != null && !diffRow.isEmpty()) {
                boolean isOwnDebit = false;
                if (ownValue.compareTo(BigDecimal.ZERO) >= 0 && targetValue.compareTo(BigDecimal.ZERO) < 0) {
                    isOwnDebit = true;
                }
                int dc = (Integer)diffRow.get("FDC");
                rowData = new Object[19];
                rowData[0] = curNumber;
                rowData[1] = diffRow.get("FSummary");
                rowData[2] = prElimTemplateId;
                if (isOwnDebit && dc == 1 || !isOwnDebit && dc == 0) {
                    rowData[3] = ownCompanyId;
                    rowData[4] = targetCompanyId;
                    rowData[15] = ownCompanyNumber;
                } else {
                    rowData[3] = targetCompanyId;
                    rowData[4] = ownCompanyId;
                    rowData[15] = targetCompanyNumber != null ? targetCompanyNumber : ownCompanyNumber;
                }
                rowData[5] = prEliminationModeId;
                rowData[6] = diffRow.get("Fitemid");
                rowData[7] = diffRow.get("FDataElement");
                rowData[8] = dc == 1 ? diffValue : null;
                rowData[9] = dc == 1 ? null : diffValue.multiply(new BigDecimal(-1));
                rowData[11] = prElimType;
                rowData[12] = prIsSupportImport;
                rowData[13] = dc;
                rowData[14] = 999;
                rowData[17] = 1;
                rowData[18] = orgUnitId;
                if (!AccountCheckUtil.isZero((BigDecimal)rowData[8]) || !AccountCheckUtil.isZero((BigDecimal)rowData[9])) {
                    datas.add(rowData);
                }
                diffValue = BigDecimal.ZERO;
            }
            boolean isEqual = BigDecimal.ZERO.compareTo(diffValue) == 0;
            isDelete = false;
            if (filterInfo.autoCheckTaskEnum <= 0) {
                if (1 == filterInfo.isDCEquals) {
                    isDelete = !isEqual;
                } else if (0 == filterInfo.isDCEquals) {
                    isDelete = isEqual;
                }
            } else if (0 == filterInfo.isDCEquals && !isEqual) {
                isDelete = true;
            }
            for (int i = datas.size() - 1; i >= elimStartIndex; --i) {
                if (isDelete) {
                    datas.remove(i);
                    continue;
                }
                ((Object[])datas.get((int)i))[10] = diffValue;
            }
            if (!datas.isEmpty()) {
                sql.reset();
                sql.append(" insert into ").append(preElimTmpTable).append("(fnumber,summary,elimTemplateId,companyId,targetCompanyId,eliminationModeId,itemId,dataElement,");
                sql.append("debit,credit,diff,elimType,isSupportImport,dc,seq,companyNumber,fcompanySort,isDiff,forgUnitId) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                DbUtil.executeBatch(ctx, sql.getSQL(), datas);
                datas.clear();
            }
            filterInfo.tmpTable = preElimTmpTable;
        }
        catch (Exception e) {
            logger.error((Object)"getPreElimTmpTable error", (Throwable)e);
            throw e;
        }
        return null;
    }

    public static String getElimNumber(int[] maxNumbers, String currencyNumber, int elimType, boolean isDz) throws Exception {
        int startNumber = -1;
        StringBuffer number = new StringBuffer();
        if (1 == elimType) {
            startNumber = maxNumbers[0];
            maxNumbers[0] = ++startNumber;
            number.append("WL");
        } else if (3 == elimType) {
            startNumber = maxNumbers[1];
            maxNumbers[1] = ++startNumber;
            number.append("JY");
        }
        if (isDz) {
            number.append("DZ");
        }
        number.append("_");
        number.append(currencyNumber).append("_");
        int len = 8 - String.valueOf(startNumber).length();
        for (int i = 0; i < len; ++i) {
            number.append("0");
        }
        number.append(startNumber);
        return number.toString();
    }

    public static void initCheckMaxNumber(Context ctx, CheckageFilterInfo filterInfo, Map<String, int[]> mzxDzNumberMap) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select max(fnumber) maxNumber,substring(fnumber,0,4) preNumber,forgunit from t_csl_elimination ");
        sql.append(" where forgboundid=?", filterInfo.treeId);
        sql.append(" and fperiodType=?", filterInfo.periodType);
        sql.append(" and fyear=?", filterInfo.year);
        sql.append(" and fperiod=?", filterInfo.period);
        sql.append(" and fcurrencyid=?", filterInfo.currencyId);
        sql.append(" and (fnumber like 'JYDZ_%' or fnumber like 'WLDZ_%') ");
        sql.append(" and forgunit in(select distinct forgUnitId from ").append(filterInfo.tmpTable).append(") ");
        sql.append(" group by forgunit,substring(fnumber,0,4) ");
        int wl = 0;
        int jy = 0;
        String orgUnit = null;
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet.next()) {
            String maxNumber;
            orgUnit = rowSet.getString("forgunit");
            int[] values = mzxDzNumberMap.get(orgUnit);
            if (values == null) {
                values = new int[]{0, 0};
                mzxDzNumberMap.put(orgUnit, values);
            }
            if ("WLDZ".equals(rowSet.getString("preNumber"))) {
                maxNumber = rowSet.getString("maxNumber");
                values[0] = wl = Integer.valueOf(maxNumber.substring(maxNumber.lastIndexOf("_") + 1)).intValue();
                continue;
            }
            if (!"JYDZ".equals(rowSet.getString("preNumber"))) continue;
            maxNumber = rowSet.getString("maxNumber");
            values[1] = jy = Integer.valueOf(maxNumber.substring(maxNumber.lastIndexOf("_") + 1)).intValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getBillLinkElimTmpTable(Context ctx, CheckageFilterInfo filterInfo, String tmpCompanyTable) throws Exception {
        String string;
        TempTablePool tmpTablePool = null;
        String elimTemplateTmp = null;
        try {
            String billLinkElimTmp;
            tmpTablePool = TempTablePool.getInstance((Context)ctx);
            SQLBuilder sql = new SQLBuilder();
            sql.append(" create table t_csl_elimTemplateTmp(fid varchar(44),FEliminationModeId varchar(44),FElimType int,FItemID varchar(44),FDataElement int,");
            sql.append(" FDC int,FDataSrcType int,FIsCitedByLater int,FSeq int, FSummary Nvarchar(1000),forgUnitId varchar(44))");
            elimTemplateTmp = tmpTablePool.createTempTable(sql.getSQL());
            sql.reset();
            sql.append(" insert into ").append(elimTemplateTmp).append("(fid,FEliminationModeId,FElimType,FItemID,FDataElement,FDC,FDataSrcType,FSeq,FIsCitedByLater,FSummary,forgUnitId)");
            sql.append(" select distinct elimTmp.fid,elimTmp.Feliminationmodeid,elimTmp.Felimtype,elimEntry.Fitemid,elimEntry.FDataElement,elimEntry.FDC,elimEntry.FDataSrcType,elimEntry.FSeq ");
            sql.append(",elimTmp.FIsCitedByLater,elimEntry.FSummary,dis.fcompanyid forgUnitId");
            sql.append("  from t_csl_templetdispense dis");
            sql.append(" inner join T_CSL_ElimTempletGroup elimGroup on elimGroup.fid=dis.fdispensesrcid ");
            sql.append(" inner join t_csl_elimtemplet elimTmp on elimTmp.Felimgroupid = elimGroup.fid ");
            sql.append(" inner join t_csl_elimTempletEntry elimEntry on elimEntry.FTempletId=elimTmp.fid ");
            sql.append(" where dis.forgboundid=? ", filterInfo.treeId);
            if (filterInfo.isIncludeChild) {
                sql.append(" and dis.fcompanyid in ", filterInfo.hasPermOrgIds);
            } else {
                sql.append(" and dis.fcompanyid=? ", filterInfo.orgUnitId);
            }
            sql.append(" and elimTmp.fcheckedstatus=? ", 2);
            if (filterInfo.checkType > 0) {
                sql.append(" and elimTmp.Felimtype=?", filterInfo.checkType);
            } else {
                sql.append(" and elimTmp.Felimtype in ", (Object[])new Integer[]{1, 3});
            }
            if (!StringUtils.isEmpty((String)filterInfo.elimModeId)) {
                sql.append(" and elimTmp.Feliminationmodeid=?", filterInfo.elimModeId);
            }
            sql.append(" and elimEntry.FDataSrcType<>?", 2);
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            sql.reset();
            sql.append(" create table t_csl_elimTemplateTmp(fbillId varchar(44),FEliminationModeId varchar(44),FElimType int,FItemID varchar(44),FDataElement int,FDC int,FDataSrcType int,");
            sql.append(" FIsCitedByLater int,FSeq int,FSummary Nvarchar(1000),felimTmpId varchar(44),fcompanySort varchar(88),FAuditedTime DateTime,forgUnitId varchar(44))");
            filterInfo.billLinkElimTable = billLinkElimTmp = tmpTablePool.createTempTable(sql.getSQL());
            AccountCheckUtil.insertBillLinkElimTable(ctx, filterInfo, elimTemplateTmp, tmpCompanyTable, true);
            if (filterInfo.autoCheckTaskEnum < 0) {
                AccountCheckUtil.insertBillLinkElimTable(ctx, filterInfo, elimTemplateTmp, tmpCompanyTable, false);
            }
            string = billLinkElimTmp;
        }
        catch (Throwable throwable) {
            if (!DebugLogger.isDebug && !StringUtils.isEmpty(elimTemplateTmp)) {
                tmpTablePool.releaseTable(elimTemplateTmp);
            }
            throw throwable;
        }
        if (!DebugLogger.isDebug && !StringUtils.isEmpty((String)elimTemplateTmp)) {
            tmpTablePool.releaseTable(elimTemplateTmp);
        }
        return string;
    }

    public static void insertBillLinkElimTable(Context ctx, CheckageFilterInfo filterInfo, String elimTemplateTmp, String tmpCompanyTable, boolean isItemMapped) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(" insert into ").append(filterInfo.billLinkElimTable).append("(fbillId,FEliminationModeId,FElimType,FItemID,FDataElement,FDC,FDataSrcType,FIsCitedByLater");
        sql.append("  ,FSeq,FSummary,felimTmpId,fcompanySort,FAuditedTime,forgUnitId)");
        sql.append(" select distinct bill.fid,elimTmp.FEliminationModeId,elimTmp.FElimType,elimTmp.FItemID,elimTmp.FDataElement,").append(isItemMapped ? "itemAcc.FDC" : "rptItem.FDC");
        sql.append(" ,elimTmp.FDataSrcType,elimTmp.FIsCitedByLater,elimTmp.FSeq,elimTmp.FSummary,elimTmp.fid felimTmpId,case when bill.fcompanyid>bill.ftargetCompanyid ");
        sql.append(" then concat(bill.fcompanyid,bill.ftargetCompanyid) else concat(bill.ftargetCompanyid,bill.fcompanyid) end fcompanySort,head.FAuditedTime,tmp.forgUnitId ");
        sql.append(" from T_Csl_CheckageBill bill ");
        sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=bill.FBillHeadId ");
        sql.append(" inner join T_Csl_AccountMap accMap on accMap.fid=head.FAccountMapId ");
        sql.append(" inner join T_Csl_CheckageAccount ckaccount on ckaccount.fid = bill.FCheckAccountId ");
        if (isItemMapped) {
            sql.append(" inner join T_Csl_RPTItemAccount itemAcc on itemAcc.FCheckAccountId=ckaccount.fid ");
            sql.append(" inner join T_Csl_RPTItemMap itemMap on itemMap.fid = itemAcc.FRptItemMapId ");
            sql.append(" inner join ").append(elimTemplateTmp).append(" elimTmp on elimTmp.Fitemid=itemMap.FRptItemID and elimTmp.FDataElement=itemMap.FDataElement and accMap.FElimType=elimTmp.FElimType ");
        } else {
            sql.append(" inner join t_csl_rptitem rptItem on rptItem.fnumber=bill.fitemNumber ");
            sql.append(" inner join ").append(elimTemplateTmp).append(" elimTmp on elimTmp.Fitemid=rptItem.fid and elimTmp.FDataElement=bill.FDataElement and accMap.FElimType=elimTmp.FElimType ");
            sql.append(" left join (select distinct itemAcc.FCheckAccountId,itemAcc.fid from T_Csl_RPTItemAccount itemAcc  ");
            sql.append("            inner join T_Csl_RPTItemMap itemMap on itemMap.fid = itemAcc.FRptItemMapId ");
            sql.append("            where itemMap.FIsFree=0 ) itemAcc2 on itemAcc2.FCheckAccountId=ckaccount.fid ");
        }
        sql.append(" inner join ").append(tmpCompanyTable).append(" tmp on (tmp.fcompanyid=bill.fcompanyid and tmp.ftargetcompanyId=bill.FTargetCompanyId ");
        sql.append("           \t\t\t\t\t\t\t\t\t\t\t\tor tmp.fcompanyid=bill.FTargetCompanyId and tmp.ftargetcompanyId=bill.fcompanyid) ");
        sql.append(" left join (select distinct relaElim.FCheckageBillId  ");
        if (filterInfo.isIncludeChild) {
            sql.append(",elim.forgunit ");
        }
        sql.append(" from T_Csl_CheckageBillRelatElim relaElim ");
        sql.append("             inner join t_csl_eliminationentry elimEntry on elimEntry.fid=relaElim.FElimEntryId ");
        sql.append("             inner join t_csl_elimination elim on elim.fid=elimEntry.feliminationid ");
        sql.append("             where elim.FORGBOUNDID=?", filterInfo.treeId);
        if (!filterInfo.isIncludeChild) {
            sql.append(" and elim.forgunit=?", filterInfo.orgUnitId);
        }
        sql.append("             and elim.fyear=?", filterInfo.year).append(" and elim.fperiod=?", filterInfo.period);
        sql.append("             and elim.fperiodtype=? ", filterInfo.periodType);
        sql.append("              ) elim on elim.FCheckageBillId=bill.fid ");
        if (filterInfo.isIncludeChild) {
            sql.append(" and elim.forgunit=tmp.forgUnitId ");
        }
        sql.append(" where elim.FCheckageBillId is null and bill.fyear=?", filterInfo.year);
        sql.append(" and head.FAuditedStatus=?", 2);
        sql.append(" and bill.FCurrencyId=? ", filterInfo.currencyId);
        if (isItemMapped) {
            sql.append(" and itemMap.FIsFree=0 ");
            if (filterInfo.autoCheckTaskEnum >= 0) {
                sql.append(" and bill.fitemType=? ", filterInfo.itemType);
            }
        } else {
            sql.append(" and bill.fitemType=? ", 1);
            sql.append(" and itemAcc2.fid is null ");
        }
        if (filterInfo.checkPeriod > 0) {
            sql.append("  and bill.fperiod=? ", filterInfo.checkPeriod);
        } else {
            RptPeriodTypeEnum periotType = RptPeriodTypeEnum.getEnum((int)filterInfo.periodType);
            if (!RptPeriodTypeEnum.MONTHLY.equals((Object)periotType)) {
                int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)filterInfo.year, (int)filterInfo.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)filterInfo.year, (int)filterInfo.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                int lastPeriod = lastYearPeriod[1];
                if (lastPeriod == 12 && !filterInfo.isLastPeriod12) {
                    ++lastPeriod;
                }
                sql.append(" and (elimTmp.FDataElement=?", 2);
                sql.append("  and bill.fperiod>=? ", yearPeriod[1]);
                sql.append("  and bill.fperiod<=? ", lastPeriod);
                sql.append(" or elimTmp.FDataElement<>?", 2);
                sql.append("  and bill.fperiod=? ", lastPeriod);
                sql.append(")");
            } else {
                sql.append("  and bill.fperiod=? ", filterInfo.period);
            }
        }
        if (filterInfo.checkType >= 0) {
            sql.append(" and accMap.FElimType=? ", filterInfo.checkType);
        }
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkLinkBillUnAudit(Context ctx, CheckageFilterInfo filterInfo, Set numbers, StringBuffer msg) throws Exception {
        String inStr = null;
        ParamTempTblService service = null;
        try {
            IRowSet rowSet;
            if (filterInfo.autoCheckTaskEnum <= 0) {
                if (numbers.size() < 100) {
                    inStr = CslRptUtil.changeIdSet2String((Set)numbers);
                } else {
                    TableInfo table = new TableInfo("T_CSL_ElimNumber");
                    table.addColumn(new ColumnInfo("fnumber", "NVARCHAR(120)"));
                    service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)numbers, null);
                    inStr = "select fnumber from " + service.getTmpTableName();
                }
            }
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select distinct tmp.fnumber,head.FAuditedStatus ");
            sql.append(" from ").append(filterInfo.tmpTable).append(" tmp ");
            sql.append(" inner join ").append(filterInfo.billLinkElimTable).append(" billLink on (billLink.felimTmpId=tmp.elimTemplateId");
            sql.append(" and billLink.fcompanySort=tmp.fcompanySort and billLink.FItemID=tmp.itemId and billLink.FDataElement=tmp.dataElement ");
            sql.append(" and billLink.FElimType=tmp.elimType ) ");
            sql.append(" inner join T_Csl_CheckageBill bill on bill.fid=billLink.fbillId ");
            sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=bill.FBillHeadId ");
            sql.append(" where (head.FAuditedStatus<>? ", 2);
            sql.append(" or head.FAuditedTime<>billLink.FAuditedTime) ");
            if (filterInfo.autoCheckTaskEnum <= 0) {
                sql.append(" and tmp.fnumber in (").append(inStr).append(") ");
            }
            if ((rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams())).size() > 0) {
                StringBuffer unAuditedMsg = new StringBuffer();
                StringBuffer auditedTimeChangeMsg = new StringBuffer();
                while (rowSet.next()) {
                    String number = rowSet.getString("fnumber");
                    numbers.remove(number);
                    if (1 == rowSet.getInt("FAuditedStatus")) {
                        if (unAuditedMsg.length() > 0) {
                            unAuditedMsg.append(",");
                        }
                        unAuditedMsg.append(number);
                        continue;
                    }
                    if (auditedTimeChangeMsg.length() > 0) {
                        auditedTimeChangeMsg.append(",");
                    }
                    auditedTimeChangeMsg.append(number);
                }
                if (unAuditedMsg.length() > 0) {
                    msg.append(AccountCheckUtil.getResourceString(ctx, "129partUnAuditCantCreate", new Object[]{unAuditedMsg}));
                }
                if (auditedTimeChangeMsg.length() > 0) {
                    msg.append(AccountCheckUtil.getResourceString(ctx, "130dataChangeCantCreate", new Object[]{auditedTimeChangeMsg}));
                }
            }
        }
        finally {
            if (service != null) {
                service.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> createElims(Context ctx, CheckageFilterInfo filterInfo, Set numbers, StringBuffer detailMsg) throws Exception {
        String inStr = null;
        ParamTempTblService service = null;
        TempTablePool tmpTablePool = null;
        String numberMapTable = null;
        try {
            if (filterInfo.autoCheckTaskEnum <= 0) {
                if (numbers.size() < 50) {
                    inStr = CslRptUtil.changeIdSet2String((Set)numbers);
                } else {
                    TableInfo table = new TableInfo("T_CSL_ElimNumber");
                    table.addColumn(new ColumnInfo("fnumber", "varchar(100)"));
                    service = ParamTempTblService.getInstance((Context)ctx, (TableInfo)table, (Collection)numbers, null);
                    inStr = "select fnumber from " + service.getTmpTableName();
                }
            }
            String name = "fname_" + ctx.getLocale().getLanguage();
            SQLBuilder sql = new SQLBuilder();
            sql.append(" select tmp.fnumber,tmp.summary,tmp.elimTemplateId,tmp.companyId,tmp.targetCompanyId,tmp.eliminationModeId,tmp.itemId,tmp.dataElement,");
            sql.append(" tmp.debit,tmp.credit,tmp.elimType,tmp.isSupportImport,item.fnumber itemNumber,unit.fnumber companyNumber,tmp.forgUnitId ");
            sql.append(" from ").append(filterInfo.tmpTable).append(" tmp ");
            sql.append(" inner join t_csl_rptitem item on tmp.itemId=item.fid ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=tmp.companyId ");
            if (filterInfo.autoCheckTaskEnum <= 0) {
                sql.append(" where tmp.fnumber in (").append(inStr).append(") ");
            }
            sql.append(" order by tmp.fnumber,tmp.companyNumber,tmp.seq ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL());
            HashMap<String, EliminationInfo> elims = new HashMap<String, EliminationInfo>();
            int seq = 0;
            HashMap<String, int[]> mzxDzNumberMap = null;
            ArrayList<String[]> numberMaps = new ArrayList<String[]>();
            HashMap<String, String> newNumber_oldNumbers = new HashMap<String, String>();
            while (rowSet.next()) {
                String number = rowSet.getString("fnumber");
                String orgUnitId = rowSet.getString("forgUnitId");
                EliminationInfo elimInfo = (EliminationInfo)elims.get(number);
                if (elimInfo == null) {
                    int isSupportImport;
                    String eliminationModeId;
                    if (mzxDzNumberMap == null) {
                        mzxDzNumberMap = new HashMap<String, int[]>();
                        AccountCheckUtil.initCheckMaxNumber(ctx, filterInfo, mzxDzNumberMap);
                    }
                    elimInfo = new EliminationInfo();
                    elimInfo.setElimDataSource(ElimDataSourceEnum.checkagePlatform);
                    int elimType = rowSet.getInt("elimType");
                    int[] maxNumbers = (int[])mzxDzNumberMap.get(orgUnitId);
                    if (maxNumbers == null) {
                        maxNumbers = new int[]{0, 0};
                        mzxDzNumberMap.put(orgUnitId, maxNumbers);
                    }
                    String dzNumber = AccountCheckUtil.getElimNumber(maxNumbers, filterInfo.currencyNumber, elimType, true);
                    numberMaps.add(new String[]{number, dzNumber});
                    newNumber_oldNumbers.put(dzNumber, number);
                    elimInfo.setNumber(dzNumber);
                    elimInfo.setTempletID(rowSet.getString("elimTemplateId"));
                    if (elimType > 0) {
                        elimInfo.setElimType(ElimTypeEnum.getEnum((int)elimType));
                    }
                    if (!StringUtils.isEmpty((String)(eliminationModeId = rowSet.getString("eliminationModeId")))) {
                        EliminationModeInfo modeInfo = new EliminationModeInfo();
                        modeInfo.setId(BOSUuid.read((String)eliminationModeId));
                        elimInfo.setEliminationMode(modeInfo);
                    }
                    if ((isSupportImport = rowSet.getInt("isSupportImport")) >= 0) {
                        elimInfo.setIsCitedByLater(IsCitedByLaterEnum.getEnum((int)isSupportImport));
                    }
                    OrgUnitInfo orgUnitInfo = new OrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)orgUnitId));
                    elimInfo.setOrgUnit(orgUnitInfo);
                    elims.put(number, elimInfo);
                    seq = 0;
                }
                EliminationEntryInfo entryInfo = new EliminationEntryInfo();
                entryInfo.setSeq(seq++);
                RPTItemInfo item = new RPTItemInfo();
                item.setId(BOSUuid.read((String)rowSet.getString("itemId")));
                item.setNumber(rowSet.getString("itemNumber"));
                entryInfo.setItem(item);
                entryInfo.setDataElement(rowSet.getInt("dataElement"));
                entryInfo.setDebit(rowSet.getBigDecimal("debit"));
                entryInfo.setCredit(rowSet.getBigDecimal("credit"));
                entryInfo.setSummary(rowSet.getString("summary"));
                entryInfo.setIsVisible(true);
                if (rowSet.getString("companyId") != null) {
                    FullOrgUnitInfo orgUnitInfo = new FullOrgUnitInfo();
                    orgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("companyId")));
                    orgUnitInfo.setNumber(rowSet.getString("companyNumber"));
                    entryInfo.setCompany(orgUnitInfo);
                }
                if (rowSet.getString("targetCompanyId") != null) {
                    FullOrgUnitInfo targeteOrgUnitInfo = new FullOrgUnitInfo();
                    targeteOrgUnitInfo.setId(BOSUuid.read((String)rowSet.getString("targetCompanyId")));
                    entryInfo.setTargetCompany(targeteOrgUnitInfo);
                }
                elimInfo.getEntries().add(entryInfo);
            }
            RptPeriodTypeEnum periotType = RptPeriodTypeEnum.getEnum((int)filterInfo.periodType);
            Date elimData = RPTDateUtil.getPeriodLastDate((int)filterInfo.year, (int)filterInfo.period, (RptPeriodTypeEnum)periotType);
            OrgTreeInfo orgTreeInfo = new OrgTreeInfo();
            orgTreeInfo.setId(BOSUuid.read((String)filterInfo.treeId));
            CurrencyInfo currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)filterInfo.currencyId));
            currency.setNumber(filterInfo.currencyNumber);
            currency.setPrecision(filterInfo.precision);
            CoreBaseCollection coll = new CoreBaseCollection();
            for (EliminationInfo elimInfo : elims.values()) {
                elimInfo.setOrgBound(orgTreeInfo);
                elimInfo.setYear(filterInfo.year);
                elimInfo.setPeriod(filterInfo.period);
                elimInfo.setPeriodType(periotType);
                elimInfo.setDate(elimData);
                elimInfo.setCurrency(currency);
                elimInfo.setSourceCurrency(currency);
                elimInfo.setArchivedStatus(ArchivedStatusEnum.UNARCHIVED);
                elimInfo.setCheckedStatus(CheckedStatusEnum.UNAUDITED);
                elimInfo.setValueType(ValueTypeEnum.MONEY);
                elimInfo.setDataSource(RptSrcTypeEnum.NORMAL);
                coll.add((CoreBaseInfo)elimInfo);
            }
            Set<String> successNumber = new HashSet<String>();
            if (!coll.isEmpty()) {
                OneToManyMap org_elimIds = new OneToManyMap(2);
                HashMap<String, String> elimId_Numbers = new HashMap<String, String>();
                IElimination iElimination = EliminationFactory.getLocalInstance((Context)ctx);
                Result result = iElimination.submit(coll);
                for (int i = 0; i < result.size(); ++i) {
                    LineResult lineResult = result.getLineResult(i);
                    if (lineResult.isSucess()) {
                        successNumber.add((String)newNumber_oldNumbers.get(((EliminationInfo)coll.get(i)).getNumber()));
                        org_elimIds.put(((EliminationInfo)coll.get(i)).getOrgUnit().getId().toString(), ((EliminationInfo)coll.get(i)).getId().toString());
                        elimId_Numbers.put(((EliminationInfo)coll.get(i)).getId().toString(), (String)newNumber_oldNumbers.get(((EliminationInfo)coll.get(i)).getNumber()));
                        continue;
                    }
                    if (lineResult.getException() == null) continue;
                    throw lineResult.getException();
                }
                newNumber_oldNumbers.clear();
                if (!numberMaps.isEmpty()) {
                    tmpTablePool = TempTablePool.getInstance((Context)ctx);
                    numberMapTable = tmpTablePool.createTempTable("create table t_csl_numbermap(fnumber varchar(92),fdznumber varchar(92))");
                    sql.reset();
                    sql.append("insert into ").append(numberMapTable).append("(fnumber,fdznumber) values(?,?)");
                    DbUtil.executeBatch(ctx, sql.getSQL(), numberMaps);
                }
                numberMaps.clear();
                sql.reset();
                sql.append(" insert into T_Csl_CheckageBillRelatElim(fid,FCheckageBillId,FElimEntryId");
                if (!StringUtils.isEmpty((String)filterInfo.autoCheckSchmId)) {
                    sql.append(",FCreateElimSchmId");
                }
                sql.append(")");
                sql.append(" select newbosid('").append(new CheckageBillRelatElimInfo().getBOSType().toString()).append("') fid,FCheckageBillId,FElimEntryId ");
                if (!StringUtils.isEmpty((String)filterInfo.autoCheckSchmId)) {
                    sql.append(",'").append(filterInfo.autoCheckSchmId).append("' FCreateElimSchmId");
                }
                sql.append(" from ( select distinct billLink.fbillId FCheckageBillId,elimentry.fid FElimEntryId");
                sql.append(" from ").append(filterInfo.tmpTable).append(" tmp ");
                sql.append(" inner join ").append(filterInfo.billLinkElimTable).append(" billLink on (billLink.felimTmpId=tmp.elimTemplateId");
                sql.append(" and billLink.fcompanySort=tmp.fcompanySort and billLink.FItemID=tmp.itemId and billLink.FDataElement=tmp.dataElement ");
                sql.append(" and billLink.FElimType=tmp.elimType ) ");
                sql.append(" inner join ").append(numberMapTable).append(" numberMap on numberMap.fnumber=tmp.fnumber ");
                sql.append(" inner join t_csl_elimination elim on elim.fnumber=numberMap.fdznumber and elim.FORGUNIT=tmp.forgUnitId ");
                sql.append(" inner join t_csl_eliminationentry elimentry on elimentry.FELIMINATIONID=elim.fid and elimentry.FITEMID=tmp.itemId  ");
                sql.append(" and elimentry.FDATAELEMENT=tmp.dataElement and (elimentry.FCOMPANYID=tmp.companyId or elimentry.FCOMPANYID is null) ");
                sql.append(" where elim.fyear=? ", filterInfo.year).append(" and elim.fperiod=? ", filterInfo.period);
                sql.append(" and elim.fperiodType=? ", filterInfo.periodType).append(" and elim.forgboundid=? ", filterInfo.treeId);
                sql.append(" and elim.FCURRENCYID=?", filterInfo.currencyId);
                if (filterInfo.autoCheckTaskEnum < 0) {
                    sql.append(" and tmp.fnumber in (").append(inStr).append(") ");
                }
                sql.append(") linkTable ");
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                AccountCheckUtil.createDyElimination(ctx, (Map)org_elimIds, filterInfo);
                successNumber = AccountCheckUtil.eliminationAudit(ctx, elimId_Numbers, detailMsg);
            }
            HashSet<String> hashSet = successNumber;
            return hashSet;
        }
        finally {
            if (!DebugLogger.isDebug) {
                if (service != null) {
                    service.release();
                }
                if (numberMapTable != null) {
                    tmpTablePool.releaseTable(numberMapTable);
                }
            }
        }
    }

    public static Set<String> eliminationAudit(Context ctx, Map<String, String> elimId_Numbers, StringBuffer detailMsg) throws Exception {
        if (CSLParamUtil.getParamBooleanValue((Context)ctx, (String)"GR_CSL_DZPT_GenerateEliminationAudited")) {
            if (elimId_Numbers != null && !elimId_Numbers.isEmpty()) {
                HashSet<String> numbers = new HashSet<String>();
                ArrayList<String> ids = new ArrayList<String>();
                ids.addAll(elimId_Numbers.keySet());
                Map resultMap = EliminationFactory.getLocalInstance((Context)ctx).batchAuditOrUnAudit(ids, CheckedStatusEnum.AUDITED);
                List NoBalanceEntryIDList = (List)resultMap.get("NoBalanceEntryIDList");
                Set successIDs = (Set)resultMap.get("successIDs");
                if (NoBalanceEntryIDList != null && !NoBalanceEntryIDList.isEmpty()) {
                    for (String noBalanceEntryIDList : NoBalanceEntryIDList) {
                        detailMsg.append(noBalanceEntryIDList).append("\r\n");
                    }
                }
                for (String successId : successIDs) {
                    numbers.add(elimId_Numbers.get(successId));
                }
                return numbers;
            }
        } else {
            HashSet<String> numbers = new HashSet<String>();
            for (String odlNumber : elimId_Numbers.values()) {
                numbers.add(odlNumber);
            }
            return numbers;
        }
        return new HashSet<String>();
    }

    public static Set<String> createDyElimination(Context ctx, Map org_elimIds, CheckageFilterInfo filterInfo) throws Exception {
        if (filterInfo.isGenerateDynaElim && org_elimIds != null && !org_elimIds.isEmpty()) {
            DynaItemElimEntryCondition condition = new DynaItemElimEntryCondition();
            HashMap<String, DynaItemElimEntryCondition> paramsMap = new HashMap<String, DynaItemElimEntryCondition>();
            paramsMap.put("queryCondition", condition);
            condition.setTreeid(filterInfo.treeId);
            condition.setYear(filterInfo.year);
            condition.setPeriod(filterInfo.period);
            condition.setPeriodType(filterInfo.periodType >= 0 ? filterInfo.periodType : 3);
            condition.setElimTypes(new ElimTypeEnum[]{ElimTypeEnum.ComeAndGo, ElimTypeEnum.exchange});
            for (Object orgUnitId : org_elimIds.keySet()) {
                condition.setOrgUnitId((String)orgUnitId);
                condition.setElimIds((Set)org_elimIds.get(orgUnitId));
                condition.setCheckPlatform(true);
                ElimDynaItemEntryFactory.getLocalInstance((Context)ctx).generateDynaItemElimByGivenElimType(paramsMap);
            }
        }
        return null;
    }

    public static void releaseTables(Context ctx, TempTablePool tmpTablePool, List<String> tmpTables) {
        if (!DebugLogger.isDebug && !tmpTables.isEmpty()) {
            if (tmpTablePool == null) {
                tmpTablePool = TempTablePool.getInstance((Context)ctx);
            }
            for (String tmpTable : tmpTables) {
                tmpTablePool.releaseTable(tmpTable);
            }
        }
    }

    public static boolean isBigDecimal(Component ui, Object value) {
        boolean isBigDecimal = true;
        try {
            String strValue;
            if (value != null && !StringUtils.isEmpty((String)(strValue = value.toString()))) {
                BigDecimal curValue = new BigDecimal(strValue);
                int index = strValue.indexOf(".");
                if (index > 0) {
                    int intLen = index;
                    int len = strValue.length() - index - 1;
                    if (intLen > 15) {
                        MsgBox.showInfo((Component)ui, (String)AccountCheckUtil.getResourceString(null, "131IntegerMax15", null));
                        isBigDecimal = false;
                    } else if (len > 6) {
                        MsgBox.showInfo((Component)ui, (String)AccountCheckUtil.getResourceString(null, "132digitMax6", null));
                        isBigDecimal = false;
                    }
                } else {
                    int intLen = strValue.length();
                    if (intLen > 15) {
                        MsgBox.showInfo((Component)ui, (String)AccountCheckUtil.getResourceString(null, "131IntegerMax15", null));
                        isBigDecimal = false;
                    }
                }
            }
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)ui, (String)AccountCheckUtil.getResourceString(null, "100isNotDigit", new Object[]{value}));
            isBigDecimal = false;
        }
        return isBigDecimal;
    }

    public static String checkAuditStatus(Context ctx, Set<String> billHeadIds, boolean isAudit) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("select distinct fid,fnumber from T_Csl_CheckageBillHead ");
        sql.append(" where fid in", billHeadIds);
        sql.append(" and FAuditedStatus=?", isAudit ? AuditedStatusEnum.AUDITED : AuditedStatusEnum.UNAUDITED);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        StringBuffer errorMsg = new StringBuffer();
        while (rowSet.next()) {
            billHeadIds.remove(rowSet.getString("fid"));
            if (errorMsg.length() > 0) {
                errorMsg.append(",");
            }
            errorMsg.append(rowSet.getString("fnumber"));
        }
        if (errorMsg.length() > 0) {
            return AccountCheckUtil.getResourceString(ctx, isAudit ? "118auditNoneedAudit" : "120unAuditNoNeedUnAudit", new Object[]{errorMsg.toString()});
        }
        return null;
    }

    public static String checkConfirmTime(Context ctx, Set<String> billHeadIds, boolean isAudit, CheckageFilterInfo filterInfo) throws Exception {
        if (isAudit && filterInfo != null && !StringUtils.isEmpty((String)filterInfo.tmpTable) && !billHeadIds.isEmpty()) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct tmp.billHeadId,tmp.fnumber ");
            sql.append(" from ").append(filterInfo.tmpTable).append(" tmp ");
            sql.append(" left join (select bill.fid,billCompany.fconfirmTime from T_Csl_CheckageBill bill  ");
            sql.append("            inner join T_Csl_CheckageBillCompany billCompany on bill.FBillCompanyId=billCompany.fid ");
            sql.append("             where bill.fbillHeadid in ", billHeadIds).append(") curBill on curBill.fid=tmp.id and (curBill.fconfirmTime=tmp.confirmTime ");
            sql.append("              or (curBill.fconfirmTime is null and tmp.confirmTime is null))");
            sql.append(" where tmp.billHeadId in", billHeadIds);
            sql.append(" and curBill.fid is null ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            StringBuffer errorMsg = new StringBuffer();
            while (rowSet.next()) {
                billHeadIds.remove(rowSet.getString("billHeadId"));
                if (errorMsg.length() > 0) {
                    errorMsg.append(",");
                }
                errorMsg.append(rowSet.getString("fnumber"));
            }
            if (errorMsg.length() > 0) {
                return AccountCheckUtil.getResourceString(ctx, "133checkDataChange", new Object[]{errorMsg.toString()});
            }
        }
        return null;
    }

    public static MutexParameter requestCheckControlLock(Context ctx, Uuid requestId, String actionName, String mutexName, String description) throws BOSException {
        IMutexServiceControl imc = null;
        imc = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        MutexParameter param = new MutexParameter();
        param.setRequestId(requestId);
        param.setActionName(actionName);
        param.setMutexName(mutexName);
        param.setDescription(description);
        if (ctx != null) {
            param.setDcName(ctx.getAIS());
            param.setUserID(BOSUuid.read((String)ctx.getCaller().toString()));
        } else {
            param.setDcName(SysContext.getSysContext().getDcName());
            UserInfo userinfo = SysContext.getSysContext().getCurrentUserInfo();
            param.setUserID(userinfo.getId());
        }
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        if (ctx != null) {
            String companyId = (String)ctx.get((Object)"CurCompanyId");
            if (companyId != null) {
                param.setOrgUnitID(BOSUuid.read((String)companyId));
            }
        } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
            param.setOrgUnitID(SysContext.getSysContext().getCurrentOrgUnit().getId());
        }
        return imc.requestMutex3(param);
    }

    public static void deleteElimCheckageBillLink(Context ctx, String inIds) throws BOSException {
        if (!StringUtils.isEmpty((String)inIds)) {
            SQLBuilder sql = new SQLBuilder();
            sql.append("delete T_Csl_CheckageBillRelatElim where FElimEntryId in(");
            sql.append("select elimEntry.fid from t_csl_eliminationentry elimEntry ");
            sql.append(" inner join t_csl_elimination elim on elimEntry.FELIMINATIONID = elim.fid ");
            sql.append(" where elim.fid in (").append(inIds).append("))");
            DbUtil.execute(ctx, sql.getSQL());
        }
    }

    public static String getExceptionDetail(Exception ex) {
        if (ex != null) {
            StringWriter sw = new StringWriter();
            PrintWriter wr = new PrintWriter(sw);
            ex.printStackTrace(wr);
            return ex.getMessage() + "\n" + sw.getBuffer().toString();
        }
        return null;
    }

    public static void initOrgTree(Context ctx, AutoCheckParams params) throws Exception {
        if (params != null) {
            AutoCheckSchmInfo schmInfo = params.getSchmInfo();
            if (!params.isInitedOrgTree() && schmInfo.getOrgTree() != null && schmInfo.getOrgUnitEntries() != null && schmInfo.getOrgUnitEntries().size() > 0 && schmInfo.getPeriodType() != null && params.getYear() > 0 && params.getPeriod() > 0) {
                boolean isError = true;
                String orgTreeNumber = schmInfo.getOrgTree().getNumber();
                if (StringUtils.isEmpty((String)orgTreeNumber) && schmInfo.getOrgTree().getId() != null) {
                    orgTreeNumber = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo("select number where id='" + schmInfo.getOrgTree().getId() + "'").getNumber();
                }
                Map<String, String> oldOrgUnitId_Nums = AccountCheckUtil.getOrgUnitNums(schmInfo);
                if (orgTreeNumber != null && !oldOrgUnitId_Nums.isEmpty() && orgTreeNumber != null && !oldOrgUnitId_Nums.isEmpty()) {
                    SQLBuilder sql = new SQLBuilder();
                    Timestamp date = new Timestamp(DateUtil.getEndDate((RptPeriodTypeEnum)schmInfo.getPeriodType(), (int)params.getYear(), (int)params.getPeriod()).getTime());
                    sql.append(" select tree.fid,unit.fid,unit.fnumber from t_org_structure struct ");
                    sql.append(" inner join t_org_tree tree on tree.fid=struct.ftreeid ");
                    sql.append(" inner join t_org_baseunit unit on unit.fid=struct.funitid ");
                    sql.append(" where tree.fnumber=? ", orgTreeNumber);
                    sql.append(" and unit.fnumber in ", oldOrgUnitId_Nums.values());
                    sql.append(" and tree.ftype=8 and (tree.fstartDate<=? ", date).append(" and tree.fendDate>=? ", date);
                    sql.append(" or tree.fstartDate<=? ", date).append(" and tree.fendDate is null) ");
                    IRowSet rsTemp = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    String orgTreeId = null;
                    HashMap<String, String> newOrgUnitNum_Ids = new HashMap<String, String>();
                    while (rsTemp.next()) {
                        if (orgTreeId == null) {
                            orgTreeId = rsTemp.getString(1);
                        }
                        newOrgUnitNum_Ids.put(rsTemp.getString(3), rsTemp.getString(2));
                    }
                    if (!newOrgUnitNum_Ids.isEmpty()) {
                        schmInfo.getOrgTree().setId(BOSUuid.read((String)orgTreeId));
                        for (int i = 0; i < schmInfo.getOrgUnitEntries().size(); ++i) {
                            FullOrgUnitInfo orgUnit = schmInfo.getOrgUnitEntries().get(i).getOrgUnit();
                            String orgUnitId = orgUnit.getId().toString();
                            String oldUnitNum = oldOrgUnitId_Nums.get(orgUnitId);
                            String id = (String)newOrgUnitNum_Ids.get(oldUnitNum);
                            if (id == null) continue;
                            orgUnit.setId(BOSUuid.read((String)id));
                        }
                        params.setInitedOrgTree(true);
                        isError = false;
                    }
                }
                if (isError) {
                    throw new Exception("initOrgTree error.");
                }
            }
        }
    }

    public static Map<String, String> getOrgUnitNums(AutoCheckSchmInfo autoCheckSchmInfo) throws Exception {
        AutoCheckSchmUnitEntryCollection coll = autoCheckSchmInfo.getOrgUnitEntries();
        HashMap<String, String> oldOrgUnitId_Nums = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            oldOrgUnitId_Nums.put(coll.get(i).getOrgUnit().getId().toString(), coll.get(i).getOrgUnit().getNumber());
        }
        return oldOrgUnitId_Nums;
    }

    public static AccountTableCollection getAccountTable(Context ctx) throws Exception {
        CompanyOrgUnitCollection coll = (ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx)).getCompanyOrgUnitCollection("select accountTable.id,accountTable.name,accountTable.number where accountTable.id is not null order by accountTable.number asc");
        AccountTableCollection accountTableCollection = new AccountTableCollection();
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                if (coll.get(i).getAccountTable() == null) continue;
                accountTableCollection.add(coll.get(i).getAccountTable());
            }
        }
        return accountTableCollection;
    }

    public static GLRptSubLedgerCondition getGLRptSubLedgerCondition(CompanyOrgUnitInfo company, int year, int period, CurrencyInfo currency, boolean isIncludeUnPosted, AccountViewInfo accountViewInfo) {
        return AccountCheckUtil.getGLRptSubLedgerCondition(company, year, period, year, period, currency, isIncludeUnPosted, accountViewInfo);
    }

    public static GLRptSubLedgerCondition getGLRptSubLedgerCondition(CompanyOrgUnitInfo company, int startYear, int stratPeriod, int endYear, int endPeriod, CurrencyInfo currency, boolean isIncludeUnPosted, AccountViewInfo accountViewInfo) {
        GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition();
        cond.setPeriodYearStart(startYear);
        cond.setPeriodYearEnd(endYear);
        cond.setPeriodNumberStart(stratPeriod);
        cond.setPeriodNumberEnd(endPeriod);
        cond.setCurrencyID(currency.getId().toString());
        cond.setCurrencyName(currency.getName());
        cond.setCompany(company);
        cond.setCompanyId(company.getId().toString());
        cond.setOptionPosting(isIncludeUnPosted);
        cond.setShowDisplayAsstDetail(true);
        cond.setOptionAmountAndBalZero(true);
        HashSet<String> accountIds = new HashSet<String>();
        accountIds.add(accountViewInfo.getId().toString());
        cond.setAccountIdSet(accountIds);
        cond.setAccountCodeStart(accountViewInfo.getNumber());
        cond.setAccountCodeEnd(accountViewInfo.getNumber());
        cond.setAccountLevelStart(accountViewInfo.getLevel());
        cond.setAccountLevelEnd(accountViewInfo.getLevel());
        cond.setAccountTableId(accountViewInfo.getAccountTableID().getId().toString());
        return cond;
    }

    public static GLRptSubLedgerCondition getGLRptSubLedgerCondition(CompanyOrgUnitInfo company, int startYear, int stratPeriod, int endYear, int endPeriod, CurrencyInfo currency, boolean isIncludeUnPosted, Set<String> accountIds, int startLevel, int endLevel, String accountTableId, String accountNubmer) {
        GLRptSubLedgerCondition cond = new GLRptSubLedgerCondition();
        cond.setPeriodYearStart(startYear);
        cond.setPeriodYearEnd(endYear);
        cond.setPeriodNumberStart(stratPeriod);
        cond.setPeriodNumberEnd(endPeriod);
        cond.setCurrencyID(currency.getId().toString());
        cond.setCurrencyName(currency.getName());
        cond.setCompany(company);
        cond.setCompanyId(company.getId().toString());
        cond.setCompanyDisplayMode(CompanyDisplayModeEnum.enumerate);
        cond.setOptionPosting(isIncludeUnPosted);
        cond.setShowDisplayAsstDetail(true);
        cond.setOptionAmountAndBalZero(true);
        cond.setAccountIdSet(accountIds);
        cond.setAccountLevelStart(startLevel);
        cond.setAccountLevelEnd(endLevel);
        cond.setAccountTableId(accountTableId);
        if (accountIds != null && accountIds.size() == 1 && !StringUtils.isEmpty((String)accountNubmer)) {
            cond.setAccountCodeStart(accountNubmer);
            cond.setAccountCodeEnd(accountNubmer);
            cond.setAccountIdSet(null);
        }
        return cond;
    }

    public static AccountViewInfo getAccountViewInfo(String companyId, String accountNumber, String accountTableId) throws EASBizException, BOSException {
        return AccountViewFactory.getRemoteInstance().getAccountViewInfo("select id,number,level,accountTableID.id,accountTableID.number where number='" + accountNumber + "' and companyID='" + companyId + "' and accountTableID.id='" + accountTableId + "'");
    }

    public static String getAcctAsstItems(String accountNumber, String targetCompanyId, BalTypeEnum balTypeEnum, String accountTableNumber) throws EASBizException, BOSException {
        AsstActTypeEnum actTypeEnum = AccountCheckUtil.getAsstActType(accountNumber, balTypeEnum, accountTableNumber);
        AsstActTypeSysEnum asstActTypeSysEnum = AsstActTypeSysEnum.getEnum((String)actTypeEnum.getValue());
        AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getRemoteInstance().getAsstActType(asstActTypeSysEnum);
        String actTypeNumber = asstActTypeInfo.getNumber();
        String asstItemNumber = AccountCheckUtil.getAsstItemNumber(actTypeEnum, targetCompanyId);
        String acctAsstItemString = AccountCheckUtil.getAcctAsstItemString(accountNumber, actTypeNumber, asstItemNumber);
        return acctAsstItemString;
    }

    public static String getAcctAsstItemString(String accountNumber, String actTypeNumber, String asstItemNumber) {
        StringBuffer acctAsstItemString = new StringBuffer();
        acctAsstItemString.append(accountNumber);
        acctAsstItemString.append("|");
        acctAsstItemString.append(actTypeNumber);
        acctAsstItemString.append("|");
        acctAsstItemString.append(asstItemNumber);
        return acctAsstItemString.toString();
    }

    public static AsstActTypeEnum getAsstActType(String accountNumber, BalTypeEnum balTypeEnum, String accountTableNumber) throws EASBizException, BOSException {
        ICheckageAccount iCheckageAccount = CheckageAccountFactory.getRemoteInstance();
        CheckageAccountCollection coll = null;
        if (accountTableNumber != null && (coll = iCheckageAccount.getCheckageAccountCollection("select asstActTypes where itemNumber = '" + accountNumber + "' and accountTableNumber='" + accountTableNumber + "' and balType = " + balTypeEnum.getValue())) != null && coll.size() > 0) {
            return coll.get(0).getAsstActTypes();
        }
        coll = iCheckageAccount.getCheckageAccountCollection("select asstActTypes where itemNumber = '" + accountNumber + "' and balType = " + balTypeEnum.getValue());
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getAsstActTypes();
        }
        throw new BOSException("asstActType is null.");
    }

    public static String getAsstItemNumber(AsstActTypeEnum actTypeEnum, String tarCompanyId) throws EASBizException, BOSException {
        if ("customer".equals(actTypeEnum.getValue())) {
            CustomerInfo customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo("Select number Where internalCompany = '" + tarCompanyId + "' ");
            return customerInfo.getNumber();
        }
        if ("provider".equals(actTypeEnum.getValue())) {
            SupplierInfo supplierInfo = SupplierFactory.getRemoteInstance().getSupplierInfo("Select number Where internalCompany = '" + tarCompanyId + "'");
            return supplierInfo.getNumber();
        }
        if ("companyOrg".equals(actTypeEnum.getValue())) {
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo("Select number Where id = '" + tarCompanyId + "'");
            return companyOrgUnitInfo.getNumber();
        }
        return null;
    }

    public static List calcExcelFormula(List formulas) throws Exception {
        if (formulas != null && !formulas.isEmpty()) {
            int row = 0;
            int col = 0;
            if (book.getSheetCount() <= 0) {
                book.addSheet(new Sheet(book, "sheet1"));
            }
            Sheet sheet = book.getSheet(0);
            Cell cell = null;
            String curFormula = null;
            for (Object formula : formulas) {
                if (formula != null && formula.toString().length() > 0) {
                    curFormula = formula.toString();
                    if (!curFormula.startsWith("=")) {
                        curFormula = "=" + curFormula;
                    }
                    cell = sheet.getCell(row, col, true);
                    cell.setFormula(curFormula);
                } else {
                    cell = sheet.getCell(row, col, true);
                    cell.setFormula(null);
                }
                if (++col < 9) continue;
                col = 0;
                ++row;
            }
            book.calc();
            ArrayList<String> resultList = new ArrayList<String>(formulas.size());
            String value = null;
            row = 0;
            col = 0;
            for (int i = 0; i < formulas.size(); ++i) {
                cell = sheet.getCell(row, col, true);
                value = cell.getValue().toString();
                resultList.add(value);
                if (++col < 9) continue;
                col = 0;
                ++row;
            }
            return resultList;
        }
        return null;
    }

    public static void initItemTypeDefaultValue(KDComboBox comb) {
        int defaultValue = CSLParamUtil.getAccountCheckItemTypeDefaultValue(null);
        if (defaultValue != 0 && defaultValue != 1) {
            defaultValue = 1;
        }
        ItemTypeEnum itemType = ItemTypeEnum.getEnum(defaultValue);
        comb.setSelectedItem((Object)itemType);
    }
}

