/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DataSrcTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.IAccountMap;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageAccount;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.util.NewRptUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.DataSubmitModeEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.TaskLog;
import com.kingdee.eas.tools.datatask.log.TaskLogUtil;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.AbstractExternalDataReader;
import com.kingdee.eas.tools.datatask.runtime.BlockDataReader;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.runtime.ExcelXErrorDataWriter;
import com.kingdee.eas.tools.datatask.runtime.ExternalExcelXDataReader;
import com.kingdee.eas.tools.datatask.task.TaskBlockDataRunner;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.tools.datatask.util.EASServerResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AccountMapImport
extends BlockDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.AccountMapImport");
    private Map<String, CheckageAccountInfo> CheckageAccountMap = new HashMap<String, CheckageAccountInfo>();
    private Map<String, List<AccountMapInfo>> accountDataMap = null;
    private Map<String, List<Integer>> accountDataRowNumMap = null;
    private Map<String, List<AccountMapInfo>> rptDataMap = null;
    private Map<String, List<Integer>> rptDataRowNumMap = null;
    private Map<String, String> exsitNumberMap = new HashMap<String, String>();
    private Map<String, Integer> rowExsitNumberIndexMap = new HashMap<String, Integer>();
    private int dataRowNum = -1;
    TaskBlockDataRunner runner = null;
    BlockDataReader reader = null;
    ArrayList errorDetail = null;
    ArrayList errorRowNum = null;
    AbstractExternalDataReader dataReader = null;
    Boolean hasErrorFile = null;
    ExcelXErrorDataWriter errDataWriter = null;
    ArrayList deleteErrorDetail = new ArrayList();
    TaskExternalException lastDataEx = null;
    SimpleRecord lastRecord = null;
    ICheckageAccount ICheckageAccount = null;
    private Map<String, TaskExternalException> failDataMap = new HashMap<String, TaskExternalException>();
    private Set<String> dupRowDataSet = new HashSet<String>();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return AccountMapFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        super.submit(coreBaseInfo, ctx);
    }

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        super.importFile(ctx, task);
    }

    private void importDataFromMap(Context ctx, String number, List<AccountMapInfo> accountMapList) throws TaskExternalException {
        try {
            if (accountMapList != null && !accountMapList.isEmpty()) {
                String failDataKey = number + accountMapList.get(0).getItemType().getValue();
                if (this.failDataMap.containsKey(failDataKey) && this.dupRowDataSet.contains(failDataKey)) {
                    this.dupRowDataSet.remove(failDataKey);
                } else if (this.failDataMap.containsKey(failDataKey) && !this.dupRowDataSet.contains(failDataKey)) {
                    return;
                }
                this.insertAccountMap(ctx, accountMapList);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void insertAccountMap(Context ctx, List<AccountMapInfo> accountMapList) throws BOSException, TaskExternalException, EASBizException {
        AccountMapInfo mapInfo = this.getNewAccountMapInfo(ctx, accountMapList);
        if (mapInfo == null) {
            return;
        }
        AccountMapFactory.getLocalInstance(ctx).submit((CoreBaseInfo)mapInfo);
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        block41: {
            if (coll == null && coll.isEmpty()) {
                return null;
            }
            if (this.runner == null) {
                try {
                    Field field = BlockDataTransmission.class.getDeclaredField("runner");
                    NewRptUtil.makeAccessible(field);
                    this.runner = (TaskBlockDataRunner)field.get((Object)this);
                    Field field_Reader = TaskBlockDataRunner.class.getDeclaredField("reader");
                    NewRptUtil.makeAccessible(field_Reader);
                    this.reader = (BlockDataReader)field_Reader.get(this.runner);
                    Field field_DataReader = this.runner.getClass().getDeclaredField("dataReader");
                    NewRptUtil.makeAccessible(field_DataReader);
                    this.dataReader = (AbstractExternalDataReader)field_DataReader.get(this.runner);
                    Field field_HasErrorFile = this.runner.getClass().getDeclaredField("hasErrorFile");
                    NewRptUtil.makeAccessible(field_HasErrorFile);
                    this.hasErrorFile = (Boolean)field_HasErrorFile.get(this.runner);
                    Field field_ErrDataWriter = this.runner.getClass().getDeclaredField("errDataWriter");
                    NewRptUtil.makeAccessible(field_ErrDataWriter);
                    this.errDataWriter = (ExcelXErrorDataWriter)field_ErrDataWriter.get(this.runner);
                    TaskLog taskLog = this.runner.getTaskLog();
                    if (taskLog == null) break block41;
                    try {
                        Field fieldErrorDetail = taskLog.getClass().getDeclaredField("errorDetail");
                        NewRptUtil.makeAccessible(fieldErrorDetail);
                        this.errorDetail = (ArrayList)fieldErrorDetail.get(taskLog);
                        Field fieldErrorRowNum = taskLog.getClass().getDeclaredField("errorRowNum");
                        NewRptUtil.makeAccessible(fieldErrorRowNum);
                        this.errorRowNum = (ArrayList)fieldErrorRowNum.get(taskLog);
                    }
                    catch (Exception e) {
                        throw new TaskExternalException(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
        }
        SimpleRecord record = (SimpleRecord)coll.get(0);
        this.dataRowNum = record.getRowNum();
        String failDataKey = null;
        try {
            String checkageAccountNumber;
            String number = this.fecthData(record, "FNumber");
            if (StringUtils.isEmpty((String)number)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_number", null)}));
            }
            if ((number = number.trim()).length() > 80) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_numberTooLong", null));
            }
            Boolean isSelfItem = null;
            String isMapAccount = this.fecthData(record, "FIsMapAccount");
            if (StringUtils.isEmpty((String)isMapAccount)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_item", null)}));
            }
            if (AccountCheckUtil.getResourceString(ctx, "accountMap_import_ownItem", null).equals(isMapAccount)) {
                isSelfItem = true;
            } else if (AccountCheckUtil.getResourceString(ctx, "accountMap_import_tarItem", null).equals(isMapAccount)) {
                isSelfItem = false;
            }
            if (isSelfItem == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_item", null)}));
            }
            String itemTypeNumber = this.fecthData(record, "FItemTypeNumber");
            if (StringUtils.isEmpty((String)itemTypeNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_itemType", null)}));
            }
            if (!"001".equals(itemTypeNumber) && !"002".equals(itemTypeNumber)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_itemType", null)}));
            }
            boolean isAccount = "001".equals(itemTypeNumber);
            int itemType = isAccount ? 0 : 1;
            String key = number + itemType;
            failDataKey = key;
            if (this.failDataMap.containsKey(failDataKey)) {
                throw this.failDataMap.get(failDataKey);
            }
            String updateId = null;
            if (!this.isSltImportUpdate()) {
                if (this.exsitNumberMap.containsKey(key) ? this.exsitNumberMap.get(key) != null : this.exists(ctx, itemTypeNumber, number)) {
                    throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_existSameRecord", null));
                }
            } else if (!this.exsitNumberMap.containsKey(key)) {
                if (this.exists(ctx, itemTypeNumber, number)) {
                    updateId = this.exsitNumberMap.get(key);
                }
            } else {
                updateId = this.exsitNumberMap.get(key);
            }
            if (StringUtils.isEmpty((String)(checkageAccountNumber = this.fecthData(record, "FCheckageAccountNumber")))) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_checkageAccountNumber", null)}));
            }
            CheckageAccountInfo checkageAccountInfo = this.getCheckageAccount(ctx, itemType, checkageAccountNumber);
            if (checkageAccountInfo == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_checkageAccountNumberNull", null));
            }
            if (checkageAccountInfo.isIsFree()) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_checkageAccountIsFreezed", new Object[]{checkageAccountInfo.getNumber()}));
            }
            String elimType = this.fecthData(record, "FElimType");
            ElimTypeEnum elimTypeEnum = null;
            if (StringUtils.isEmpty((String)elimType)) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_null", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_elimType", null)}));
            }
            if (ElimTypeEnum.ComeAndGo.getAlias().equals(elimType)) {
                elimTypeEnum = ElimTypeEnum.ComeAndGo;
            } else if (ElimTypeEnum.exchange.getAlias().equals(elimType)) {
                elimTypeEnum = ElimTypeEnum.exchange;
            }
            if (elimTypeEnum == null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_isNotExist", new Object[]{AccountCheckUtil.getResourceString(ctx, "accountMap_import_elimType", null)}));
            }
            String remark = this.fecthData(record, "FRemark");
            if (!StringUtils.isEmpty((String)remark) && (remark = remark.trim()).length() > 2000) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_remarkTooLong", null));
            }
            String isFreeStr = this.fecthData(record, "FIsFree");
            boolean isFree = "Y".equalsIgnoreCase(isFreeStr);
            AccountMapInfo accountMapInfo = new AccountMapInfo();
            if (updateId != null) {
                accountMapInfo.setId(BOSUuid.read((String)updateId));
            }
            accountMapInfo.setNumber(number);
            accountMapInfo.setItemType(ItemTypeEnum.getEnum(itemType));
            accountMapInfo.setElimType(elimTypeEnum);
            accountMapInfo.setRemark(remark);
            accountMapInfo.setIsFree(isFree);
            AccountAndMapAccountInfo aMapAccountInfo = new AccountAndMapAccountInfo();
            aMapAccountInfo.setIsMapAccount(isSelfItem);
            aMapAccountInfo.setCheckAccount(checkageAccountInfo);
            aMapAccountInfo.setDataSource(DataSrcTypeEnum.AUTO);
            AccountAndMapAccountCollection accountCollection = accountMapInfo.getAccount();
            accountCollection.add(aMapAccountInfo);
            accountMapInfo.put("record", record);
            String rowExsitKey = number + itemType + accountMapInfo.getAccount().get(0).getCheckAccount().getNumber();
            Integer rowIndex = this.rowExsitNumberIndexMap.get(rowExsitKey);
            if (rowIndex != null) {
                TaskExternalException exception = new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_rowDup", new Object[]{rowIndex}));
                this.failDataMap.put(failDataKey, exception);
                this.dupRowDataSet.add(failDataKey);
                throw exception;
            }
            return accountMapInfo;
        }
        catch (TaskExternalException ee) {
            if (this.errorDetail != null && !this.errorDetail.isEmpty()) {
                this.deleteErrorDetail.add(this.errorDetail.remove(0));
            }
            if (this.errorRowNum != null) {
                this.errorRowNum.clear();
                this.errorRowNum.add(5);
            }
            TaskExternalException exception = new TaskExternalException(ee.getMessage(), (Throwable)ee);
            try {
                if (!this.reader.hasNextBlock()) {
                    this.lastDataEx = exception;
                    this.lastRecord = record;
                    return null;
                }
                if (failDataKey != null) {
                    this.failDataMap.put(failDataKey, exception);
                }
                throw exception;
            }
            catch (TaskRunnerException e) {
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void verifyBlockData(Context ctx, Object o) throws TaskExternalException {
    }

    protected DataSubmitModeEnum getDataSubmitMode() {
        return super.getDataSubmitMode();
    }

    public void beforeSubmitBlockData(Context ctx, Object o) throws TaskExternalException {
    }

    public void submitBlock(Context ctx, Object coreBaseInfo) throws TaskExternalException {
        if (coreBaseInfo != null) {
            AccountMapInfo accountMapInfo = (AccountMapInfo)coreBaseInfo;
            String accountNumber = accountMapInfo.getAccount().get(0).getCheckAccount().getNumber();
            String number = accountMapInfo.getNumber();
            ItemTypeEnum itemType = accountMapInfo.getItemType();
            String key = number + itemType.getValue() + accountNumber;
            boolean isAccount = 0 == itemType.getValue();
            this.rowExsitNumberIndexMap.put(key, this.dataRowNum);
            if (isAccount) {
                if (this.accountDataMap == null) {
                    this.accountDataMap = new LinkedHashMap<String, List<AccountMapInfo>>();
                }
                if (this.accountDataRowNumMap == null) {
                    this.accountDataRowNumMap = new HashMap<String, List<Integer>>();
                }
            }
            if (!isAccount) {
                if (this.rptDataMap == null) {
                    this.rptDataMap = new LinkedHashMap<String, List<AccountMapInfo>>();
                }
                if (this.rptDataRowNumMap == null) {
                    this.rptDataRowNumMap = new HashMap<String, List<Integer>>();
                }
            }
            Map<String, List<AccountMapInfo>> currentMap = null;
            Map<String, List<Integer>> currentRowNumMap = null;
            if (isAccount) {
                currentMap = this.accountDataMap;
                currentRowNumMap = this.accountDataRowNumMap;
            } else {
                currentMap = this.rptDataMap;
                currentRowNumMap = this.rptDataRowNumMap;
            }
            List<AccountMapInfo> accountMapList = currentMap.get(number);
            if (accountMapList == null) {
                accountMapList = new LinkedList<AccountMapInfo>();
                currentMap.put(number, accountMapList);
            }
            accountMapList.add(accountMapInfo);
            List<Integer> rowNumList = currentRowNumMap.get(number);
            if (rowNumList == null) {
                rowNumList = new LinkedList<Integer>();
                currentRowNumMap.put(number, rowNumList);
            }
            rowNumList.add(this.dataRowNum);
        }
        try {
            if (!this.reader.hasNextBlock()) {
                this.addAllAccountMap(ctx);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private void addAllAccountMap(Context ctx) throws TaskExternalException {
        Iterator<Map.Entry<String, List<AccountMapInfo>>> iterator;
        boolean hasData = false;
        if (this.accountDataMap != null && !this.accountDataMap.isEmpty()) {
            hasData = true;
            iterator = this.accountDataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                this.addDataMap(ctx, iterator, this.accountDataRowNumMap);
            }
        }
        if (this.rptDataMap != null && !this.rptDataMap.isEmpty()) {
            hasData = true;
            iterator = this.rptDataMap.entrySet().iterator();
            while (iterator.hasNext()) {
                this.addDataMap(ctx, iterator, this.rptDataRowNumMap);
            }
        }
        if (!hasData) {
            this.addLastDataErrorInfo(ctx);
        }
        this.deleteErrorDetail.addAll(this.errorDetail);
        this.errorDetail.clear();
        this.errorDetail.addAll(this.deleteErrorDetail);
    }

    private void addDataMap(Context ctx, Iterator<Map.Entry<String, List<AccountMapInfo>>> iterator, Map<String, List<Integer>> dataRowNumMap) throws TaskExternalException {
        block12: {
            this.addLastDataErrorInfo(ctx);
            if (this.errorDetail != null && !this.errorDetail.isEmpty()) {
                for (int i = 0; i < this.errorDetail.size(); ++i) {
                    this.deleteErrorDetail.add(this.errorDetail.get(i));
                }
                this.errorDetail.clear();
            }
            if (this.errorRowNum != null) {
                this.errorRowNum.clear();
                this.errorRowNum.add(5);
            }
            Map.Entry<String, List<AccountMapInfo>> next = iterator.next();
            try {
                this.verifyAccountMap(ctx, next.getValue());
                this.importDataFromMap(ctx, next.getKey(), next.getValue());
            }
            catch (TaskExternalException e) {
                String failDataKey = next.getKey() + next.getValue().get(0).getItemType().getValue();
                if (failDataKey != null) {
                    this.failDataMap.put(failDataKey, e);
                }
                try {
                    if (!(this.dataReader instanceof ExternalExcelXDataReader)) break block12;
                    if (this.hasErrorFile.booleanValue()) {
                        List<Integer> rowNumList = dataRowNumMap.get(next.getKey());
                        TaskLog tl = this.runner.getTaskLog();
                        List<AccountMapInfo> accountMapInfoList = next.getValue();
                        int x = 0;
                        for (Integer rowNum : rowNumList) {
                            String errFieldDesc;
                            AccountMapInfo accountMapInfo = accountMapInfoList.get(x);
                            String errMsg = this.getMsgOnDataErr(ctx, rowNum);
                            tl.addExceptionForBlock(errMsg, (Throwable)e, rowNum, rowNum);
                            tl.setFailRecordCount(tl.getFailRecordCount() + 1);
                            tl.setSuccessRecordCount(tl.getSuccessRecordCount() - 1);
                            TaskLogUtil.putLog((TaskLog)tl);
                            DataToken value = new DataToken();
                            value.name = "ErrorReason";
                            value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason", (Locale)ctx.getLocale());
                            try {
                                HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
                                String cellValue = null;
                                cellValue = (String)this.errorDetail.get(x);
                                value.data = cellValue == null ? "" : cellValue.trim();
                                hsData.putAll(((SimpleRecord)accountMapInfo.get("record")).getMap());
                                hsData.put("ErrorReason", value);
                                this.errDataWriter.writeLine(hsData);
                            }
                            catch (TaskRunnerException ee) {
                                logger.error((Object)ee);
                            }
                            ++x;
                        }
                    }
                    throw e;
                }
                catch (Exception ee) {
                    throw new TaskExternalException(ee.getMessage(), (Throwable)ee);
                }
            }
        }
    }

    private void addLastDataErrorInfo(Context ctx) throws TaskExternalException {
        if (this.lastDataEx != null) {
            if (this.dataReader instanceof ExternalExcelXDataReader) {
                if (this.hasErrorFile.booleanValue()) {
                    String errFieldDesc;
                    TaskLog tl = this.runner.getTaskLog();
                    String errMsg = this.getMsgOnDataErr(ctx, this.dataRowNum);
                    tl.addExceptionForBlock(errMsg, (Throwable)this.lastDataEx, Integer.valueOf(this.dataRowNum), Integer.valueOf(this.dataRowNum));
                    tl.setFailRecordCount(tl.getFailRecordCount() + 1);
                    tl.setSuccessRecordCount(tl.getSuccessRecordCount() - 1);
                    TaskLogUtil.putLog((TaskLog)tl);
                    DataToken value = new DataToken();
                    value.name = "ErrorReason";
                    value.desc = errFieldDesc = EASResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"errorReason", (Locale)ctx.getLocale());
                    try {
                        HashMap<String, DataToken> hsData = new HashMap<String, DataToken>();
                        String cellValue = this.lastDataEx.getMessage();
                        value.data = cellValue == null ? "" : cellValue.trim();
                        hsData.putAll(this.lastRecord.getMap());
                        hsData.put("ErrorReason", value);
                        this.errDataWriter.writeLine(hsData);
                    }
                    catch (TaskRunnerException ee) {
                        logger.error((Object)ee);
                    }
                } else {
                    throw this.lastDataEx;
                }
            }
            this.lastDataEx = null;
        }
    }

    private String getMsgOnDataErr(Context ctx, Integer rowNum) {
        Locale locale = ctx.getLocale();
        return EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"importNo", (Locale)locale) + rowNum + EASServerResource.getString((String)"com.kingdee.eas.tools.datatask.DatataskResource", (String)"lineData", (Locale)locale);
    }

    private void verifyAccountMap(Context ctx, List<AccountMapInfo> accountMapList) throws TaskExternalException {
        AccountMapInfo mapInfo = this.getNewAccountMapInfo(ctx, accountMapList);
        if (mapInfo == null) {
            return;
        }
        try {
            String accountMapNumber = null;
            IAccountMap iAccountMap = AccountMapFactory.getLocalInstance(ctx);
            accountMapNumber = mapInfo.getId() != null ? iAccountMap.getExistNumber(mapInfo.getAccount(), mapInfo.getId().toString(), mapInfo.isIsUnilateralReconciliation(), mapInfo.getItemType()) : iAccountMap.getExistNumber(mapInfo.getAccount(), null, mapInfo.isIsUnilateralReconciliation(), mapInfo.getItemType());
            if (accountMapNumber != null) {
                throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_accountMapDup", new Object[]{accountMapNumber}));
            }
            if (mapInfo.getId() != null) {
                HashMap<String, Boolean> checkAgeAccountMap = new HashMap<String, Boolean>();
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)mapInfo.getId().toString()));
                view.setFilter(filter);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("isFree"));
                sic.add(new SelectorItemInfo("isUnilateralReconciliation"));
                sic.add(new SelectorItemInfo("account.*"));
                sic.add(new SelectorItemInfo("account.checkAccount.*"));
                view.setSelector(sic);
                AccountMapCollection accountMapCol = iAccountMap.getAccountMapCollection(view);
                AccountMapInfo oldAccountMapInfo = null;
                if (accountMapCol != null && !accountMapCol.isEmpty()) {
                    Map resultMap;
                    oldAccountMapInfo = accountMapCol.get(0);
                    AccountAndMapAccountCollection coll = oldAccountMapInfo.getAccount();
                    for (int i = 0; i < coll.size(); ++i) {
                        AccountAndMapAccountInfo info = coll.get(i);
                        checkAgeAccountMap.put(info.getCheckAccount().getId().toString(), info.isIsMapAccount());
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(mapInfo.getId().toString());
                    AccountAndMapAccountCollection accountColl = mapInfo.getAccount();
                    int count = 0;
                    for (int i = 0; i < accountColl.size(); ++i) {
                        AccountAndMapAccountInfo info = accountColl.get(i);
                        if (checkAgeAccountMap.get(info.getCheckAccount().getId().toString()) == null || ((Boolean)checkAgeAccountMap.get(info.getCheckAccount().getId().toString())).booleanValue() != info.isIsMapAccount()) continue;
                        ++count;
                    }
                    if (count < checkAgeAccountMap.size() && ((ArrayList)(resultMap = iAccountMap.removeOfNoQuote(list)).get("noRemoveIDList")).size() > 0) {
                        throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "accountMap_import_refrenced", new Object[]{mapInfo.getNumber()}));
                    }
                }
                if (oldAccountMapInfo != null && !mapInfo.isIsFree() && mapInfo.isIsFree() != oldAccountMapInfo.isIsFree()) {
                    SelectorItemCollection sc = new SelectorItemCollection();
                    sc.add(new SelectorItemInfo("number"));
                    sc.add(new SelectorItemInfo("account.*"));
                    sc.add(new SelectorItemInfo("isUnilateralReconciliation"));
                    sc.add(new SelectorItemInfo("account.checkAccount.*"));
                    String existNumber = iAccountMap.getExistNumber(oldAccountMapInfo.getAccount(), oldAccountMapInfo.getId().toString(), oldAccountMapInfo.isIsUnilateralReconciliation(), oldAccountMapInfo.getItemType());
                    if (existNumber != null) {
                        throw new TaskExternalException(AccountCheckUtil.getResourceString(ctx, "ExistNumber", new Object[]{oldAccountMapInfo.getNumber(), existNumber}));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private AccountMapInfo getNewAccountMapInfo(Context ctx, List<AccountMapInfo> accountMapList) {
        CheckageAccountInfo checkAccount;
        if (accountMapList == null || accountMapList.isEmpty()) {
            return null;
        }
        AccountMapInfo firstAccountMapInfo = accountMapList.get(0);
        AccountMapInfo mapInfo = new AccountMapInfo();
        mapInfo.setId(firstAccountMapInfo.getId());
        mapInfo.setNumber(firstAccountMapInfo.getNumber());
        mapInfo.setRemark(firstAccountMapInfo.getRemark());
        mapInfo.setIsFree(firstAccountMapInfo.isIsFree());
        mapInfo.setElimType(firstAccountMapInfo.getElimType());
        mapInfo.setItemType(firstAccountMapInfo.getItemType());
        AccountAndMapAccountCollection accountMapAc = mapInfo.getAccount();
        Iterator<AccountMapInfo> iterator = accountMapList.iterator();
        AccountAndMapAccountCollection selfAccountAndMapAcCol = new AccountAndMapAccountCollection();
        int selfIndex = 0;
        AccountAndMapAccountCollection tarAccountAndMapAcCol = new AccountAndMapAccountCollection();
        int tarIndex = 0;
        while (iterator.hasNext()) {
            AccountMapInfo accountMapInfo = iterator.next();
            AccountAndMapAccountInfo accountAndMapAccountInfo = accountMapInfo.getAccount().get(0);
            accountAndMapAccountInfo.setAccountMap(mapInfo);
            if (accountAndMapAccountInfo.isIsMapAccount()) {
                accountAndMapAccountInfo.setSeq(selfIndex++);
                selfAccountAndMapAcCol.add(accountAndMapAccountInfo);
                continue;
            }
            accountAndMapAccountInfo.setSeq(tarIndex++);
            tarAccountAndMapAcCol.add(accountAndMapAccountInfo);
        }
        AccountAndMapAccountInfo aMapAccountInfo = null;
        if (!selfAccountAndMapAcCol.isEmpty()) {
            aMapAccountInfo = selfAccountAndMapAcCol.get(0);
            if (aMapAccountInfo != null && (checkAccount = aMapAccountInfo.getCheckAccount()) != null) {
                mapInfo.setOurAccountTableid(checkAccount.getAccountTableid());
            }
            accountMapAc.addCollection(selfAccountAndMapAcCol);
        } else {
            mapInfo.setOurAccountTableid(null);
        }
        if (!tarAccountAndMapAcCol.isEmpty()) {
            aMapAccountInfo = tarAccountAndMapAcCol.get(0);
            if (aMapAccountInfo != null && (checkAccount = aMapAccountInfo.getCheckAccount()) != null) {
                mapInfo.setOppositeAccountTableid(checkAccount.getAccountTableid());
            }
            accountMapAc.addCollection(tarAccountAndMapAcCol);
        } else {
            mapInfo.setOppositeAccountTableid(null);
        }
        mapInfo.setIsUnilateralReconciliation(selfAccountAndMapAcCol.isEmpty() || tarAccountAndMapAcCol.isEmpty());
        return mapInfo;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        return super.isSameBlock(firstData, currentData);
    }

    public boolean isSameBlock(Map firstData, Map currentData) {
        return false;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return super.transmit(hsData, ctx);
    }

    private CheckageAccountInfo getCheckageAccount(Context ctx, int itemType, String checkageAccountNumber) throws TaskExternalException {
        String key = itemType + checkageAccountNumber;
        if (!this.CheckageAccountMap.containsKey(key)) {
            try {
                if (this.ICheckageAccount == null) {
                    this.ICheckageAccount = CheckageAccountFactory.getLocalInstance(ctx);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)checkageAccountNumber));
                CheckageAccountCollection checkageAccountCollection = this.ICheckageAccount.getCheckageAccountCollection(view);
                CheckageAccountInfo accountInfo = null;
                if (checkageAccountCollection != null && !checkageAccountCollection.isEmpty()) {
                    accountInfo = checkageAccountCollection.get(0);
                }
                this.CheckageAccountMap.put(key, accountInfo);
                return accountInfo;
            }
            catch (Exception e) {
                logger.error((Object)"getCheckageAccount_error:", (Throwable)e);
                this.CheckageAccountMap.put(key, null);
                return null;
            }
        }
        return this.CheckageAccountMap.get(key);
    }

    private boolean exists(Context ctx, String itemTypeNumber, String number) throws TaskExternalException {
        int itemType = "001".equals(itemTypeNumber) ? 0 : 1;
        SQLBuilder sql = new SQLBuilder();
        sql.append("select FItemType,FNumber,Fid from T_Csl_AccountMap \n");
        sql.append("where FItemType=? \n", itemType);
        sql.append("and FNumber=?", number);
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), sql.getParams());
            if (rowSet.next()) {
                this.exsitNumberMap.put(rowSet.getString("FNumber") + rowSet.getInt("FItemType"), rowSet.getString("Fid"));
                return true;
            }
            this.exsitNumberMap.put(number + itemType, null);
        }
        catch (Exception e) {
            logger.error((Object)"exists_error:", (Throwable)e);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String fecthData(SimpleRecord record, String key) {
        DataToken dataToken = record.get(key);
        if (dataToken != null) {
            return dataToken.toString();
        }
        return null;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            this.setData(result, "FNumber", rs.getObject("number"));
            this.setData(result, "FIsMapAccount", rs.getBoolean("account.isMapAccount") ? AccountCheckUtil.getResourceString(ctx, "accountMap_import_ownItem", null) : AccountCheckUtil.getResourceString(ctx, "accountMap_import_tarItem", null));
            int itemType = rs.getInt("itemType");
            if (0 == itemType) {
                this.setData(result, "FItemTypeNumber", "001");
                this.setData(result, "FItemTypeName", ItemTypeEnum.account.getAlias());
            } else {
                this.setData(result, "FItemTypeNumber", "002");
                this.setData(result, "FItemTypeName", ItemTypeEnum.rptItem.getAlias());
            }
            this.setData(result, "FCheckageAccountNumber", rs.getString("checkAccount.number"));
            this.setData(result, "FElimType", ElimTypeEnum.getEnum((int)rs.getInt("elimType")).getAlias());
            this.setData(result, "FRemark", rs.getString("remark"));
            if (rs.getBoolean("isFree")) {
                result.put("FIsFree", "Y");
            } else {
                result.put("FIsFree", "N");
            }
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void setData(Hashtable result, String key, Object value) {
        if (value != null) {
            if (value instanceof BigDecimal) {
                result.put(key, CslRptUtil.ReduceBigDecimalZeros((BigDecimal)((BigDecimal)value)));
            } else {
                result.put(key, value.toString());
            }
        }
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.newrpt.accountcheck.AccountMapForExportQuery";
    }

    public String getMainField() {
        return "FNumber";
    }

    public int getSubmitType() {
        return super.getSubmitType();
    }

    public void setContextParameter(Hashtable param) {
        param.put("mainQueryPK", MetaDataPKFactory.getMetaDataPK((String)"com.kingdee.eas.fi.newrpt.accountcheck.AccountMapForExportQuery"));
        super.setContextParameter((Map)param);
    }
}

