/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.DiffModeEnum;
import com.kingdee.eas.fi.gr.cslrpt.ElimTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillHeadInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ConfirmStatusEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.app.AbstractCheckageBillControllerBean;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.app.openApi.CslRptOpenApiFacadeFactory;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class CheckageBillControllerBean
extends AbstractCheckageBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.accountcheck.app.CheckageBillControllerBean");

    @Override
    protected ArrayList _getGroupCheckageBill(Context ctx, CheckageFilterInfo param) throws BOSException, EASBizException {
        Connection con;
        boolean isRefreshData;
        block13: {
            ArrayList arrayList;
            block14: {
                isRefreshData = param.billHeadIds != null && !param.billHeadIds.isEmpty();
                con = null;
                try {
                    if (isRefreshData) {
                        this._prepareFetchGroupCheckageBill(ctx, param);
                    }
                    if (StringUtils.isEmpty((CharSequence)param.tmpTable)) break block13;
                    String name = "fname_" + ctx.getLocale().getLanguage();
                    SQLBuilder sql = new SQLBuilder();
                    sql.append("select fnumber number,ownCompanyId,ownCompantName,itemNumber,itemName,balTypeName,currencyName,debit,credit,confirmDebit,targetCompanyName,confirmCredit,diffRemark,diffMode,confirmstatus,");
                    sql.append("confirmor,confirmTime,auditStatus,auditor,auditTime,checkType,id,targetCompanyId,companyNumber,seq,diff,billHeadId,checkPeriod,dataSource,remark,orgUnitId,orgUnitName");
                    sql.append(" from ( ");
                    sql.append("select tmp.fnumber,ownCompanyId,ownCompantName,itemNumber,itemName,balTypeName,currencyName,debit,credit,confirmDebit,confirmCredit,diffRemark,");
                    sql.append("diffMode,confirmstatus,confirmor,confirmTime,auditStatus,auditor,auditTime,checkType,id,targetCompanyId,companyNumber,seq,diff,billHeadId,checkPeriod,");
                    sql.append(" targetUnit.").append(name).append(" targetCompanyName, ");
                    sql.append(" dataSource,tmp.remark,tmp.forgUnitid orgUnitId,unit.").append(name).append(" orgUnitName ");
                    sql.append(" from ").append(param.tmpTable).append(" tmp ");
                    sql.append(" left join t_org_baseunit targetUnit on targetUnit.fid=tmp.targetCompanyId ");
                    sql.append(" left join t_org_baseunit unit on unit.fid=tmp.forgUnitid ");
                    sql.append(" union  ");
                    sql.append(" select case when fnumber is null then N'z999999999' else fnumber end fnumber,null ownCompanyId,null ownCompantName,null itemNumber,null itemName");
                    sql.append(" ,null balTypeName,null currencyName,isnull(sum(debit),0) debit,isnull(sum(credit),0) credit, isnull(sum(confirmDebit),0) confirmDebit,isnull(sum(confirmCredit),0) confirmCredit");
                    sql.append(" ,null diffRemark,null diffMode,null confirmstatus,null confirmor,null confirmTime,null auditStatus,null auditor,null auditTime");
                    sql.append(",null checkType,null id,null targetCompanyId,N'zzzzzzzzzzzz' companyNumber, null seq, null diff,null billHeadId,null checkPeriod, null targetCompanyName ");
                    sql.append(", null dataSource,null remark,").append(isRefreshData ? "null" : "forgUnitId").append(" orgUnitId, null orgUnitName");
                    sql.append(" from ").append(param.tmpTable);
                    sql.append(" group by ").append(isRefreshData ? "" : "forgUnitId,").append("fnumber with rollup ");
                    sql.append(" ) tmp ");
                    if (!isRefreshData) {
                        sql.append(" left join t_org_structure struct on struct.funitid=tmp.orgUnitId ");
                        sql.append(" where (tmp.fnumber=N'z999999999' and tmp.orgUnitId is null) or tmp.fnumber<>N'z999999999'");
                    }
                    sql.append(" order by ").append(isRefreshData ? "" : "struct.flongNumber,").append("tmp.fnumber,tmp.companyNumber,tmp.seq,tmp.itemNumber ");
                    ArrayList rows = new ArrayList();
                    SqlParams sp = new SqlParams();
                    con = this.getConnection(ctx);
                    RptRowSet rst = null;
                    rst = isRefreshData ? DbUtil.executeQuery(ctx, sql.getSQL(), sp, 0, -1, con) : DbUtil.executeQuery(ctx, sql.getSQL(), sp, param.from, param.lenth, con);
                    String[] columns = rst.getColumnNames();
                    while (rst.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        rows.add(row);
                        for (String column : columns) {
                            row.put(column.toUpperCase(Locale.ENGLISH), rst.getObject(column));
                        }
                    }
                    arrayList = rows;
                    if (con == null) break block14;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"_getGroupCheckageBill error.", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (con != null) {
                            SQLUtils.cleanup(con);
                        }
                        if (isRefreshData && !StringUtils.isEmpty((CharSequence)param.tmpTable)) {
                            TempTablePool.getInstance((Context)ctx).releaseTable(param.tmpTable);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Connection)con);
            }
            if (isRefreshData && !StringUtils.isEmpty((CharSequence)param.tmpTable)) {
                TempTablePool.getInstance((Context)ctx).releaseTable(param.tmpTable);
            }
            return arrayList;
        }
        if (con != null) {
            SQLUtils.cleanup(con);
        }
        if (isRefreshData && !StringUtils.isEmpty((CharSequence)param.tmpTable)) {
            TempTablePool.getInstance((Context)ctx).releaseTable(param.tmpTable);
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected CheckageFilterInfo _prepareFetchGroupCheckageBill(Context ctx, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        block29: {
            block30: {
                block31: {
                    block32: {
                        tmpCompanyTable = null;
                        headIdsTable = null;
                        billTmpTable = null;
                        tmpTablePool = null;
                        isRefreshData = filterInfo.billHeadIds != null && filterInfo.billHeadIds.isEmpty() == false;
                        isAutoCheckSchm = StringUtils.isEmpty((CharSequence)filterInfo.autoCheckSchmId) == false;
                        tmpTablePool = TempTablePool.getInstance((Context)ctx);
                        if (!isRefreshData) {
                            if (!StringUtils.isEmpty((CharSequence)filterInfo.tmpTable)) {
                                tmpTablePool.releaseTable(filterInfo.tmpTable);
                                filterInfo.tmpTable = null;
                            }
                            if (isAutoCheckSchm && !StringUtils.isEmpty((CharSequence)filterInfo.sameParentCompanyTbl)) {
                                tmpCompanyTable = filterInfo.sameParentCompanyTbl;
                            } else {
                                tmpCompanyTable = AccountCheckUtil.getSameParentCompanyOrgUnit(ctx, filterInfo);
                                if (isAutoCheckSchm) {
                                    filterInfo.sameParentCompanyTbl = tmpCompanyTable;
                                }
                            }
                        }
                        if (StringUtils.isEmpty(tmpCompanyTable) && !isRefreshData) break block29;
                        if (isRefreshData) ** GOTO lbl37
                        headIdsTable = this.getBillHeadIdsTmpTable(ctx, filterInfo, tmpCompanyTable);
                        v0 = isAutoDiffHandle = filterInfo.autoCheckTaskEnum > 0;
                        if (!isAutoDiffHandle) break block30;
                        filterInfo.tmpTable = headIdsTable;
                        var10_12 = filterInfo;
                        if (DebugLogger.isDebug || tmpTablePool == null) break block31;
                        if (isAutoCheckSchm || tmpCompanyTable == null) break block32;
                        tmpTablePool.releaseTable(tmpCompanyTable);
                    }
                    if (headIdsTable != null && filterInfo.autoCheckTaskEnum <= 0) {
                        tmpTablePool.releaseTable(headIdsTable);
                    }
                }
                return var10_12;
            }
            try {
                block33: {
                    break block33;
lbl37:
                    // 1 sources

                    AccountCheckUtil.updateDiff(ctx, filterInfo.billHeadIds, null);
                }
                if (StringUtils.isEmpty((CharSequence)headIdsTable) && !isRefreshData) break block29;
                sql = new SQLBuilder();
                sql.append("create table t_csl_checkBill(fnumber nvarchar(120),ownCompanyId varchar(44),ownCompantName nvarchar(255),itemNumber nvarchar(120),itemName nvarchar(255),");
                if (filterInfo.itemType == 1) {
                    sql.append("balTypeName nvarchar(120),");
                } else {
                    sql.append("balTypeName int,");
                }
                sql.append("currencyName nvarchar(120),debit NUMERIC(21,6),credit NUMERIC(21,6),confirmDebit NUMERIC(21,6),confirmCredit NUMERIC(21,6),diffRemark nvarchar(2000),");
                sql.append("diffMode int,confirmstatus int,confirmor nvarchar(120),confirmTime DateTime,auditStatus int,auditor nvarchar(120),auditTime DateTime,checkType int,");
                sql.append("id varchar(44),targetCompanyId varchar(44),companyNumber nvarchar(120),seq int,diff NUMERIC(21,6),billHeadId varchar(44),checkPeriod int,");
                sql.append("dataSource int,remark nvarchar(2000),forgUnitId varchar(44))");
                billTmpTable = tmpTablePool.createTempTable(sql.getSQL());
                sql.reset();
                lang = ctx.getLocale().getLanguage();
                sql.append(" insert into ").append(billTmpTable).append("(fnumber,ownCompanyId ,ownCompantName,itemNumber,itemName,balTypeName,currencyName,debit,credit,confirmDebit,confirmCredit,diffRemark");
                sql.append(",diffMode,confirmstatus,confirmor,confirmTime,auditStatus,auditor,auditTime,checkType,id,targetCompanyId,companyNumber,seq,diff,billHeadId,checkPeriod,dataSource,remark,forgUnitId)");
                sql.append(" select head.fnumber fnumber,company.fid ownCompanyId,company.fname_").append(lang).append(" ownCompantName,entry.fitemNumber itemNumber,entry.fitemName itemName,");
                if (filterInfo.itemType == 1) {
                    sql.append("dataElement.fname_").append(lang).append(" balTypeName,");
                } else {
                    sql.append("entry.FBalType balTypeName,");
                }
                sql.append(" currency.fname_").append(lang).append(" currencyName,");
                sql.append(" entry.FconfirmDebit debit,entry.FconfirmCredit credit,entry.FAuditDebit confirmDebit,entry.FAuditCredit confirmCredit,");
                sql.append(" billCompany.FDiffRemark diffRemark,head.FDiffMode diffMode,billCompany.FConfirmStatus confirmstatus,confirmor.fname_").append(lang).append(" confirmor,");
                sql.append(" billCompany.FConfirmTime confirmTime,head.FAuditedStatus auditStatus,auditor.fname_").append(lang).append(" auditor,head.FAuditedTime auditTime,");
                sql.append(" accountMap.FElimType checkType,entry.fid id,entry.FTargetCompanyId targetCompanyId,company.fnumber companyNumber,entry.fseq seq,abs(head.fcompanyDiff) diff,head.fid billHeadId,");
                sql.append(" entry.fperiod checkPeriod,entry.fDataSource,entry.fremark,").append(isRefreshData != false ? "null orgUnitid" : "headTab.forgUnitid orgUnitid");
                sql.append(" from T_Csl_CheckageBillCompany billCompany ");
                sql.append(" inner join T_Csl_CheckageBill entry on entry.FBillCompanyId=billCompany.fid ");
                if (filterInfo.itemType == 1) {
                    sql.append(" inner join t_csl_dataelement dataElement on dataElement.finterseq=entry.fdataelement ");
                }
                sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=entry.FBillHeadId ");
                sql.append(" inner join t_org_baseunit company on company.fid=entry.fcompanyid ");
                sql.append(" inner join t_bd_currency currency on currency.fid=entry.fcurrencyId ");
                sql.append(" inner join T_Csl_AccountMap accountMap on accountMap.fid=head.FAccountMapId ");
                if (!isRefreshData) {
                    sql.append(" inner join ").append(headIdsTable).append(" headTab on headTab.fid=entry.FBillHeadId");
                }
                sql.append(" left join t_pm_user confirmor on confirmor.fid=billCompany.FConfirmorId ");
                sql.append(" left join t_pm_user auditor on auditor.fid=head.FAuditorId ");
                if (isRefreshData) {
                    sql.append(" where entry.FBillHeadId in(" + CslRptUtil.collection2String(filterInfo.billHeadIds, (String)",", (boolean)true) + ")");
                } else {
                    sql.append(" where entry.FBillHeadId in(select fid from ").append(headIdsTable).append(")");
                    if (!StringUtils.isEmpty((CharSequence)filterInfo.diffChar)) {
                        sql.append(" and abs(head.FCompanyDiff)").append(filterInfo.diffChar).append("?", filterInfo.diffValue);
                    }
                }
                sql.append(" and (entry.fdebit<>0 or entry.fcredit<>0 or entry.fconfirmDebit<>0 or entry.fconfirmCredit<>0 or entry.fauditDebit<>0 or entry.fauditCredit<>0)");
                if (filterInfo.dataSource >= 0) {
                    sql.append(" and entry.fdataSource=? ", filterInfo.dataSource);
                }
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
                if (!isRefreshData) {
                    sql.reset();
                    sql.append(" select count(*) from ").append(billTmpTable);
                    sql.append(" union all select count(distinct fnumber) from ").append(billTmpTable);
                    rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    maxRow = 0;
                    while (rowSet.next()) {
                        maxRow += rowSet.getInt(1);
                    }
                    filterInfo.maxRow = maxRow + 1;
                }
                filterInfo.tmpTable = billTmpTable;
            }
            catch (Exception e) {
                try {
                    CheckageBillControllerBean.logger.error((Object)"_getGroupCheckageBill error", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable var13_16) {
                    if (!DebugLogger.isDebug && tmpTablePool != null) {
                        if (!isAutoCheckSchm && tmpCompanyTable != null) {
                            tmpTablePool.releaseTable(tmpCompanyTable);
                        }
                        if (headIdsTable != null && filterInfo.autoCheckTaskEnum <= 0) {
                            tmpTablePool.releaseTable(headIdsTable);
                        }
                    }
                    throw var13_16;
                }
            }
        }
        if (!DebugLogger.isDebug && tmpTablePool != null) {
            if (!isAutoCheckSchm && tmpCompanyTable != null) {
                tmpTablePool.releaseTable(tmpCompanyTable);
            }
            if (headIdsTable != null && filterInfo.autoCheckTaskEnum <= 0) {
                tmpTablePool.releaseTable(headIdsTable);
            }
        }
        return filterInfo;
    }

    protected String createBillHeadTempTable(Context ctx, CheckageFilterInfo param) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("create table t_csl_BillHead(fid varchar(44),forgUnitId varchar(44))");
        return TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
    }

    protected String getBillHeadIdsTmpTable(Context ctx, CheckageFilterInfo param, String tmpCompanyTable) throws BOSException, EASBizException {
        String tempTable = null;
        try {
            boolean isAutoDiffHandle;
            tempTable = this.createBillHeadTempTable(ctx, param);
            SQLBuilder sql = new SQLBuilder();
            sql.append(" insert into ").append(tempTable).append("(fid,forgUnitId) ");
            sql.append(" select distinct entry.FBillHeadId,tmp.forgUnitId ");
            sql.append(" from T_Csl_CheckageBillCompany billCompany ");
            sql.append(" inner join T_Csl_CheckageBill entry on entry.FBillCompanyId=billCompany.fid ");
            sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=entry.FBillHeadId ");
            sql.append(" inner join T_Csl_AccountMap accMap on accMap.fid=head.FAccountMapId ");
            sql.append(" inner join ").append(tmpCompanyTable).append(" tmp on (tmp.fcompanyid=entry.fcompanyid and tmp.ftargetcompanyId=entry.FTargetCompanyId ");
            sql.append("           \t\t\t\t\t\t\t\t\t\t\t\tor tmp.fcompanyid=entry.FTargetCompanyId and tmp.ftargetcompanyId=entry.fcompanyid) ");
            sql.append("  where entry.fyear=? ", param.year);
            sql.append(" and billCompany.FConfirmStatus=? ", 1);
            sql.append(" and entry.FItemType=? ", param.itemType);
            if (param.dataSource >= 0) {
                sql.append(" and entry.FDataSource=? ", param.dataSource);
            }
            if (param.checkPeriod > 0) {
                sql.append("  and entry.fperiod=? ", param.checkPeriod);
            } else {
                RptPeriodTypeEnum periotType = RptPeriodTypeEnum.getEnum((int)param.periodType);
                if (!RptPeriodTypeEnum.MONTHLY.equals((Object)periotType)) {
                    int[] yearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodFirstDate((int)param.year, (int)param.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                    int[] lastYearPeriod = RPTDateUtil.getPeriod((Date)RPTDateUtil.getPeriodLastDate((int)param.year, (int)param.period, (RptPeriodTypeEnum)periotType), (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                    int lastPeriod = lastYearPeriod[1];
                    if (lastPeriod == 12) {
                        ++lastPeriod;
                    }
                    sql.append("  and entry.fperiod>=? ", yearPeriod[1]);
                    sql.append("  and entry.fperiod<=? ", lastPeriod);
                } else {
                    sql.append("  and entry.fperiod=? ", param.period);
                }
            }
            sql.append(" and entry.FCurrencyId=? ", param.currencyId);
            if (param.checkType >= 0) {
                sql.append(" and accMap.FElimType=? ", param.checkType);
            }
            if (!StringUtils.isEmpty((CharSequence)param.companyId)) {
                sql.append(" and (entry.fcompanyid=? ", param.companyId);
                sql.append(" or entry.FTargetCompanyId=? ", param.companyId).append(") ");
            }
            if (param.auditStatus >= 0) {
                sql.append(" and head.FAuditedStatus=? ", param.auditStatus);
            }
            sql.append(" and (entry.fdebit<>0 or entry.fcredit<>0 or entry.fconfirmDebit<>0 or entry.fconfirmCredit<>0 or entry.fauditDebit<>0 or entry.fauditCredit<>0)");
            DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            if (param.confirmStatus != -1) {
                sql.reset();
                SQLBuilder unConfirmSql = new SQLBuilder();
                unConfirmSql.append("select distinct bill1.FBillHeadId from T_Csl_CheckageBill bill1 ");
                unConfirmSql.append(" inner join T_Csl_CheckageBillCompany billConfirm on bill1.FBillCompanyId=billConfirm.fid ");
                unConfirmSql.append(" where billConfirm.FConfirmStatus=? ", 0);
                unConfirmSql.append(" and bill1.FBillHeadId in (select fid from ").append(tempTable).append(") ");
                unConfirmSql.append(" union ");
                unConfirmSql.append(" select  bill1.FBillHeadId from T_Csl_CheckageBill bill1 ");
                unConfirmSql.append("  inner join T_Csl_CheckageBillCompany billConfirm on bill1.FBillCompanyId=billConfirm.fid ");
                unConfirmSql.append("  inner join T_Csl_CheckageBillhead head on head.fid=bill1.FBillHeadId ");
                unConfirmSql.append("  inner join t_csl_accountmap map on head.FAccountMapId=map.fid ");
                unConfirmSql.append("  where  FIsUnilateralReconciliation=0 and bill1.fcompanyid<>bill1.ftargetCompanyId ");
                unConfirmSql.append("  and bill1.FBillHeadId in (select fid from ").append(tempTable).append(") ");
                unConfirmSql.append("  group by  bill1.FBillHeadId having count(distinct bill1.FBillCompanyId)<2  ");
                sql.append("delete from ").append(tempTable).append(" where fid in( ");
                if (param.confirmStatus == 1) {
                    sql.append(unConfirmSql).append(") ");
                } else if (param.confirmStatus == 0) {
                    sql.append("select fid from ").append(tempTable).append(" tmp ");
                    sql.append(" left join (").append(unConfirmSql).append(") unConfirm on unConfirm.FBillHeadId=tmp.fid ");
                    sql.append(" where unConfirm.FBillHeadId is null) ");
                }
                DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
            }
            boolean bl = isAutoDiffHandle = param.autoCheckTaskEnum > 0 && param.autoCheckTaskEnum == 3;
            if (isAutoDiffHandle) {
                AccountCheckUtil.updateDiff(ctx, null, tempTable);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTable;
    }

    @Override
    protected Map _diffHandle(Context ctx, List billHeadIds, DiffModeEnum diffMode) throws BOSException, EASBizException {
        try {
            return AccountCheckUtil.diffHandle(ctx, billHeadIds, diffMode);
        }
        catch (Exception e) {
            logger.error((Object)"_diffHandle error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getCheckageBills(Context ctx, List billHeads) throws BOSException, EASBizException {
        try {
            return AccountCheckUtil.getCheckageBills(ctx, billHeads, null, true);
        }
        catch (Exception e) {
            logger.error((Object)"_diffHandle error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _getBillCompanys(Context ctx, Set billHeadIds) throws BOSException, EASBizException {
        try {
            SQLBuilder sql = new SQLBuilder();
            String name = "fname_" + ctx.getLocale().getLanguage();
            sql.append(" select headId,fnumber,fauditedStatus,max(fdiffRemark) fdiffRemark,fitemType,FElimType,FDiffMode,fremark,fperiod, ");
            sql.append("companyName,targetCompanyName,count(isMapAccount) isMapAccount,min(fconfirmStatus) fconfirmStatus,count(distinct unitNumber) unitCount ");
            sql.append(" from (");
            sql.append(" select distinct head.fid headId,head.fnumber,head.fauditedStatus,billCompany.fconfirmStatus fconfirmStatus,billCompany.fdiffRemark,");
            sql.append(" bill.fitemType,map.FElimType,head.FDiffMode,head.fremark,bill.fperiod,unit.fnumber unitNumber,tarUnit.fnumber tarNumber,");
            sql.append("case when unit.fnumber<tarUnit.fnumber then unit.").append(name).append(" else tarUnit.").append(name).append(" end companyName,");
            sql.append("case when unit.fnumber<tarUnit.fnumber then tarUnit.").append(name).append(" else unit.").append(name).append(" end targetCompanyName,");
            sql.append("account.FisMapAccount isMapAccount ");
            sql.append(" from t_csl_checkagebill bill ");
            sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=bill.FBillHeadId ");
            sql.append(" inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId ");
            sql.append(" inner join t_org_baseunit unit on unit.fid=bill.fcompanyid");
            sql.append(" inner join t_org_baseunit tarUnit on tarUnit.fid=bill.ftargetcompanyid");
            sql.append(" inner join t_csl_accountmap map on head.FAccountMapId=map.fid ");
            sql.append(" inner join T_Csl_AccountAndMapAccount account on account.FAccountMapId=map.fid ");
            sql.append(" where head.fid in", billHeadIds);
            sql.append(") tmp ");
            sql.append(" group by headId,fnumber,fauditedStatus,fitemType,FElimType,FDiffMode,fremark,fperiod,companyName,targetCompanyName");
            sql.append(" order by fnumber ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            ArrayList<CheckageBillInfo> bills = new ArrayList<CheckageBillInfo>();
            while (rowSet.next()) {
                CheckageBillInfo bill = new CheckageBillInfo();
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setName(rowSet.getString("companyName"));
                bill.setCompany(company);
                CompanyOrgUnitInfo targetCompany = new CompanyOrgUnitInfo();
                targetCompany.setName(rowSet.getString("targetCompanyName"));
                bill.setTargetCompany(targetCompany);
                CheckageBillHeadInfo headInfo = new CheckageBillHeadInfo();
                headInfo.setId(BOSUuid.read((String)rowSet.getString("headId")));
                headInfo.setNumber(rowSet.getString("fnumber"));
                headInfo.setAuditedStatus(AuditedStatusEnum.getEnum((int)rowSet.getInt("fauditedStatus")));
                AccountMapInfo accountMap = new AccountMapInfo();
                accountMap.setElimType(ElimTypeEnum.getEnum((int)rowSet.getInt("FElimType")));
                headInfo.setAccountMap(accountMap);
                headInfo.setDiffMode(DiffModeEnum.getEnum((int)rowSet.getInt("FDiffMode")));
                headInfo.setRemark(rowSet.getString("fremark"));
                headInfo.setSingleBill(rowSet.getInt("isMapAccount") < 2);
                bill.setBillHead(headInfo);
                CheckageBillCompanyInfo billCompanyInfo = new CheckageBillCompanyInfo();
                if (!headInfo.isSingleBill() && rowSet.getInt("unitCount") < 2) {
                    billCompanyInfo.setConfirmStatus(ConfirmStatusEnum.unconfirm);
                } else {
                    billCompanyInfo.setConfirmStatus(ConfirmStatusEnum.getEnum(rowSet.getInt("fconfirmStatus")));
                }
                billCompanyInfo.setDiffRemark(rowSet.getString("fdiffRemark"));
                bill.setBillCompany(billCompanyInfo);
                bill.setPeriod(rowSet.getInt("fperiod"));
                bill.setItemType(ItemTypeEnum.getEnum(rowSet.getInt("fitemType")));
                bills.add(bill);
            }
            return bills;
        }
        catch (Exception e) {
            logger.error((Object)"_diffHandle error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _auditAndUnAudit(Context ctx, List billHeadIds, AuditedStatusEnum auditStatus, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            boolean isAudit = AuditedStatusEnum.AUDITED.equals((Object)auditStatus);
            HashSet<String> ids = new HashSet<String>(billHeadIds);
            String AuditStatueMsg = AccountCheckUtil.checkAuditStatus(ctx, ids, isAudit);
            String confirmTimeMsg = AccountCheckUtil.checkConfirmTime(ctx, ids, isAudit, filterInfo);
            AccountCheckUtil.updateBillHeadStatus(ctx, ids, null, isAudit, null);
            HashMap<String, StringBuffer> result = new HashMap<String, StringBuffer>();
            StringBuffer msg = new StringBuffer();
            if (!StringUtils.isEmpty((CharSequence)AuditStatueMsg)) {
                msg.append(AuditStatueMsg);
            }
            if (!StringUtils.isEmpty((CharSequence)confirmTimeMsg)) {
                msg.append(confirmTimeMsg);
            }
            if (msg.length() > 0) {
                result.put("msg", msg);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"_auditAndUnAudit error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _saveDiff(Context ctx, List detailBills, IObjectValue billHeadInfo) throws BOSException, EASBizException {
        try {
            String billCompanyId;
            HashMap<String, Timestamp> confirmTimes = new HashMap<String, Timestamp>();
            for (Object obj : detailBills) {
                CheckageBillInfo billInfo = (CheckageBillInfo)obj;
                if (billInfo.getBillCompany() == null || billInfo.getBillCompany().getId() == null || billInfo.getBillCompany().getConfirmTime() == null) continue;
                billCompanyId = billInfo.getBillCompany().getId().toString();
                Timestamp confirmTime = billInfo.getBillCompany().getConfirmTime();
                if (confirmTimes.size() >= 2) break;
                if (confirmTimes.containsKey(billCompanyId)) continue;
                confirmTimes.put(billCompanyId, confirmTime);
            }
            SQLBuilder sql = new SQLBuilder();
            sql.append("select distinct billCompany.fid,billCompany.FConfirmTime from T_Csl_CheckageBill bill ");
            sql.append(" inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId ");
            sql.append(" where bill.FBillHeadId=? ", ((CheckageBillHeadInfo)billHeadInfo).getId().toString());
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            boolean isChange = false;
            while (rowSet.next()) {
                billCompanyId = rowSet.getString("fid");
                if (!confirmTimes.containsKey(billCompanyId)) {
                    isChange = true;
                    break;
                }
                Timestamp srcTime = (Timestamp)confirmTimes.get(billCompanyId);
                Timestamp curTime = rowSet.getTimestamp("FConfirmTime");
                if (srcTime != null && srcTime.equals(curTime)) {
                    confirmTimes.remove(billCompanyId);
                    continue;
                }
                isChange = true;
                break;
            }
            if (isChange || confirmTimes.size() > 0) {
                HashMap<String, String> result = new HashMap<String, String>();
                result.put("msg", AccountCheckUtil.getResourceString(ctx, "134checkdatachange", null));
                return result;
            }
            AccountCheckUtil.addNewDetailBillsForDiff(ctx, detailBills, true);
            AccountCheckUtil.updataBillAuditMoney(ctx, detailBills);
            AccountCheckUtil.updateBillHeadStatus(ctx, (CheckageBillHeadInfo)billHeadInfo);
        }
        catch (Exception e) {
            logger.error((Object)"_saveDiff error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected CheckageFilterInfo _preCreateElim(Context ctx, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            IRowSet rowSet;
            AccountCheckUtil.preCreateElim(ctx, filterInfo);
            if (!StringUtils.isEmpty((CharSequence)filterInfo.tmpTable) && (rowSet = DbUtil.executeQuery(ctx, "select count(*) counts,sum(debit) debit,sum(credit) credit from " + filterInfo.tmpTable)).next()) {
                filterInfo.maxRow = rowSet.getInt("counts");
                filterInfo.debitTotal = rowSet.getBigDecimal("debit");
                filterInfo.creditTotal = rowSet.getBigDecimal("credit");
            }
            return filterInfo;
        }
        catch (Exception e) {
            logger.error((Object)"_preCreateElim error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _createElim(Context ctx, Set elimNumbers, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        try {
            if (!((filterInfo == null || elimNumbers == null || elimNumbers.isEmpty()) && filterInfo.autoCheckTaskEnum <= 0 || StringUtils.isEmpty((CharSequence)filterInfo.billLinkElimTable) || StringUtils.isEmpty((CharSequence)filterInfo.tmpTable))) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                StringBuffer detailMsg = new StringBuffer();
                AccountCheckUtil.checkLinkBillUnAudit(ctx, filterInfo, elimNumbers, detailMsg);
                if (elimNumbers != null && !elimNumbers.isEmpty() || filterInfo.autoCheckTaskEnum > 0) {
                    result.put("successNumbers", AccountCheckUtil.createElims(ctx, filterInfo, elimNumbers, detailMsg));
                }
                if (detailMsg.length() > 0) {
                    result.put("detailMsg", detailMsg.toString());
                }
                return result;
            }
        }
        catch (Exception e) {
            logger.error((Object)"_checkPreElimDatas error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    @Override
    protected List _getPreElimDatas(Context ctx, CheckageFilterInfo filterInfo) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((CharSequence)filterInfo.tmpTable)) {
            ArrayList arrayList;
            block8: {
                Connection con = null;
                try {
                    String name = "fname_" + ctx.getLocale().getLanguage();
                    SQLBuilder sql = new SQLBuilder();
                    sql.append("select tmpTable.fnumber number,summary,companyId,company.").append(name).append(" companyName,item.fnumber itemNumber,item.").append(name).append(" itemName,");
                    sql.append(" dataElement.").append(name).append(" dataElementName, debit,credit,elimMode.").append(name).append(" elimType,case when diff=0 then 1 else 0 end isEqual,");
                    sql.append(" isSupportImport,tmpTable.elimType checkType,targetCompanyId,elimTemplateId,tmpTable.dataElement,elimTemp.fname elimTemplateName,tmpTable.isDiff, ");
                    sql.append("unit.fid orgUnitId,unit.").append(name).append(" orgUnitName ");
                    sql.append(" from ").append(filterInfo.tmpTable).append(" tmpTable ");
                    sql.append(" left join t_org_baseunit company on company.fid=tmpTable.companyId ");
                    sql.append(" inner join t_csl_rptitem item on item.fid=tmpTable.itemId ");
                    sql.append(" inner join t_csl_dataelement dataElement on dataElement.finterseq=tmpTable.dataElement ");
                    sql.append(" inner join t_csl_elimtemplet elimTemp on elimTemp.fid=tmpTable.elimTemplateId ");
                    sql.append(" inner join t_org_baseunit unit on unit.fid=tmpTable.forgUnitId ");
                    sql.append(" inner join t_org_structure struct on struct.funitid=unit.fid ");
                    sql.append(" left join t_csl_EliminationMode elimMode on elimMode.fid=tmpTable.eliminationModeId ");
                    sql.append(" order by struct.flongnumber,number,companyNumber,seq");
                    ArrayList rows = new ArrayList();
                    SqlParams sp = new SqlParams();
                    con = this.getConnection(ctx);
                    RptRowSet rst = DBUtil.executeQuery((String)sql.getSQL(), (SqlParams)sp, (int)filterInfo.from, (int)filterInfo.lenth, (Connection)con);
                    String[] columns = rst.getColumnNames();
                    while (rst.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        rows.add(row);
                        for (String column : columns) {
                            row.put(column.toUpperCase(Locale.ENGLISH), rst.getObject(column));
                        }
                    }
                    arrayList = rows;
                    if (con == null) break block8;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)"_getGroupCheckageBill error.", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (con != null) {
                            SQLUtils.cleanup(con);
                        }
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Connection)con);
            }
            return arrayList;
        }
        return null;
    }

    @Override
    protected List _linkQueryCheckageDatas(Context ctx, CheckageFilterInfo filterInfo, Map params) throws BOSException, EASBizException {
        try {
            if (!StringUtils.isEmpty((CharSequence)filterInfo.billLinkElimTable)) {
                String companyId = (String)params.get("companyId");
                String itemNumber = (String)params.get("itemNumber");
                int dataElement = Integer.valueOf(params.get("dataElement").toString());
                String number = (String)params.get("number");
                if (!(StringUtils.isEmpty((CharSequence)number) || StringUtils.isEmpty((CharSequence)companyId) || StringUtils.isEmpty((CharSequence)itemNumber) || dataElement < 0)) {
                    String name = "fname_" + ctx.getLocale().getLanguage();
                    SQLBuilder sql = new SQLBuilder();
                    sql.append(" select distinct item.fnumber itemNumber,item.").append(name).append(" itemName,head.fnumber number,bill.fcompanyid companyId,unit.").append(name).append(" companyName,");
                    sql.append(" bill.fitemNumber checkItemNumber,bill.FItemName checkItemName,bill.FbalType balType,bill.FDataElement dataElement,currency.").append(name).append(" currency,");
                    sql.append(" bill.FCONFIRMDEBIT debit,bill.FCONFIRMCREDIT credit,FAUDITDEBIT confirmDebit,FAUDITCREDIT confirmCredit,case when billLink.fdc=1 then FAUDITDEBIT else FAUDITCREDIT end momeny,");
                    sql.append(" confirmor.").append(name).append(" confirmor,billCompany.FConfirmTime confirmTime,auditor.").append(name).append(" auditor,head.FAuditedTime auditTime,");
                    sql.append(" tmp.elimType checkType,bill.fperiod checkPeriod,bill.fid id,bill.ftargetCompanyId targetCompanyId,bill.fitemType checkItemType,bill.fdataSource dataSource");
                    sql.append(" from ").append(filterInfo.tmpTable).append(" tmp ");
                    sql.append(" inner join T_Csl_rptitem item on item.fid=tmp.itemId ");
                    sql.append(" inner join ").append(filterInfo.billLinkElimTable).append(" billLink on (billLink.felimTmpId=tmp.elimTemplateId");
                    sql.append(" and billLink.fcompanySort=tmp.fcompanySort and billLink.FItemID=tmp.itemId and billLink.FDataElement=tmp.dataElement ");
                    sql.append(" and billLink.FElimType=tmp.elimType ) ");
                    sql.append(" inner join T_Csl_CheckageBill bill on bill.fid=billLink.fbillId ");
                    sql.append(" inner join T_Csl_CheckageBillHead head on head.fid=bill.FBillHeadId ");
                    sql.append(" inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill.FBillCompanyId ");
                    sql.append(" inner join t_org_baseunit unit on unit.fid=bill.fcompanyid ");
                    sql.append(" inner join t_bd_currency currency on currency.fid=bill.fcurrencyid ");
                    sql.append(" left join t_pm_user confirmor on confirmor.fid=billCompany.FConfirmorId ");
                    sql.append(" left join t_pm_user auditor on auditor.fid=head.FAuditorId ");
                    sql.append(" where tmp.fnumber=? ", number);
                    sql.append(" and item.fnumber=? ", itemNumber);
                    sql.append(" and tmp.dataElement=? ", dataElement);
                    sql.append(" and bill.fcompanyId=? ", companyId);
                    sql.append(" order by item.fnumber,bill.fitemnumber,bill.FbalType,bill.FDataElement ");
                    IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                    ArrayList rows = new ArrayList();
                    int columnCount = rowSet.getMetaData().getColumnCount();
                    while (rowSet.next()) {
                        HashMap<String, Object> row = new HashMap<String, Object>();
                        rows.add(row);
                        for (int i = 1; i <= columnCount; ++i) {
                            String column = rowSet.getMetaData().getColumnName(i);
                            row.put(column.toUpperCase(Locale.ENGLISH), rowSet.getObject(column));
                        }
                    }
                    return rows;
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"_linkQueryCheckageDatas error.", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    @Override
    protected List _linkQueryItemMapCheckageDatas(Context ctx, IObjectValue checkBillInfo) throws BOSException, EASBizException {
        try {
            CheckageBillInfo info = (CheckageBillInfo)checkBillInfo;
            SQLBuilder sql = new SQLBuilder();
            String name = "fname_" + ctx.getLocale().getLanguage();
            sql.append("select record.faccountid accountId,acctview.fnumber accountNumber,acctview.").append(name).append(" accountName,record.fbalType balType,");
            sql.append(" currency.").append(name).append(" currencyName, case when record.faccountdc=1 then record.fvalue else null end debit, ");
            sql.append(" case when record.faccountdc<>1 then record.fvalue else null end credit,case when record.faccountdc=itemAccount.fdc then record.fvalue else 0 end fvalue ");
            sql.append(" from T_CSL_MappingRecord record ");
            sql.append(" inner join (select faccountid,fbalType,fdataelement,faccountdc,max(fid) fid ");
            sql.append("             from T_CSL_MappingRecord ");
            sql.append(" \t\t\twhere fcompanyid=? ", info.getCompany().getId().toString());
            sql.append(" \t\t\t\tand ftarcompanyid=? ", info.getTargetCompany().getId().toString());
            sql.append(" \t\t\t\tand fcurrencyid=? ", info.getCurrency().getId().toString());
            sql.append(" \t\t\t\tand fyear=? ", info.getYear());
            sql.append(" \t\t\t\tand fperiod=? ", info.getPeriod());
            sql.append(" \t\t\t\tand fitemnumber=? ", info.getItemNumber());
            sql.append(" \t\t\t\tand fdataElement=? ", info.getDataElement());
            sql.append(" \t\t\t\tgroup by faccountid,fbalType,fdataelement,faccountdc ");
            sql.append("             ) rec on record.fid=rec.fid ");
            sql.append(" inner join t_bd_accountview acctview on acctview.fid=record.faccountid ");
            sql.append(" inner join t_bd_currency currency on currency.fid=record.fcurrencyid ");
            sql.append(" inner join t_csl_rptitem item on item.fnumber=record.fitemnumber ");
            sql.append(" inner join T_Csl_RPTItemMap itemMap on itemMap.FRptItemID=item.fid and itemMap.FDataElement=record.fdataelement ");
            sql.append(" inner join T_Csl_RPTItemAccount itemAccount on itemAccount.FRptItemMapId=itemMap.fid  ");
            sql.append(" inner join T_Csl_CheckageAccount account on account.fid=itemAccount.FCheckAccountId and account.FItemNumber=acctview.fnumber and account.FBalType=record.FBalType ");
            sql.append(" where itemMap.FIsAccess=1 and itemMap.FItemType=?", 0);
            sql.append(" order by acctview.fnumber,record.fbalType");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            ArrayList rows = new ArrayList();
            if (rowSet != null) {
                ResultSetMetaData metaData = rowSet.getMetaData();
                int colCount = metaData.getColumnCount();
                while (rowSet.next()) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    rows.add(row);
                    for (int i = 1; i <= colCount; ++i) {
                        row.put(metaData.getColumnName(i).toUpperCase(Locale.ENGLISH), rowSet.getObject(metaData.getColumnName(i)));
                    }
                }
            }
            return rows;
        }
        catch (Exception e) {
            logger.error((Object)"_linkQueryItemMapCheckageDatas error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected List _calcFormulas(Context ctx, Map commParams, Map sheetVariables, List formulas) throws BOSException, EASBizException {
        return CslRptOpenApiFacadeFactory.getLocalInstance(ctx).getBatchFormulaValues(commParams, sheetVariables, formulas);
    }
}

