/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckUtil;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.ICheckageBill;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckOrgUnitTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckTaskCatchImpl;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.IAutoCheckTaskCatch;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class AutoAuditHandleTask
extends AbstractAutoCheckOrgUnitTask {
    private static Logger logger = Logger.getLogger(AutoAuditHandleTask.class);

    @Override
    public void processSingleOrgUnit(Context ctx, AutoCheckParams params, FullOrgUnitInfo orgUnit) throws Exception {
        IAutoCheckTaskCatch AutoCheckTaskCatch = AutoCheckTaskCatchImpl.getAutoCheckTaskCatchIntf(ctx);
        Map tmpTableCatch = AutoCheckTaskCatch.getCatch();
        this.sameParentCompanysTbl = (String)tmpTableCatch.get(this.catchKey + orgUnit.getId().toString());
        AutoCheckSchmInfo schmInfo = params.getSchmInfo();
        CheckageFilterInfo filterInfo = null;
        AccountCheckUtil.initOrgTree(ctx, params);
        ICheckageBill checkageBillInf = CheckageBillFactory.getLocalInstance(ctx);
        filterInfo = checkageBillInf.prepareFetchGroupCheckageBill(this.initFilterInfo(params, orgUnit));
        this.sameParentCompanysTbl = filterInfo.sameParentCompanyTbl;
        if (!StringUtils.isEmpty((CharSequence)filterInfo.tmpTable)) {
            this.auditCheckData(ctx, schmInfo, orgUnit, filterInfo.tmpTable);
        }
    }

    public void auditCheckData(Context ctx, AutoCheckSchmInfo schmInfo, FullOrgUnitInfo orgUnit, String tmpTable) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append("update T_Csl_CheckageBillHead set FAuditedStatus=?", 2);
        sql.append(",FAuditorId=?", ctx.getCaller().toString());
        sql.append(",FAuditedTime=?", new Timestamp(new Date().getTime()));
        sql.append(",FAuditSchmId=?", schmInfo.getId().toString());
        sql.append(" where fid in (");
        sql.append(" \tselect distinct billHead.fid from T_Csl_CheckageBillHead billHead ");
        sql.append(" \tinner join T_Csl_AccountMap acctMap on acctMap.fid=billHead.FAccountMapId ");
        sql.append(" \tinner join ").append(tmpTable).append(" tmp on tmp.fid=billHead.fid ");
        sql.append(" \twhere FAuditedStatus=? ", 1);
        String singleFilter = null;
        if (schmInfo.getAuditSDiffCmpChar() != null && schmInfo.getAuditSDiffCmpValue() != null) {
            singleFilter = " acctMap.FIsUnilateralReconciliation=1 and abs(billHead.FCompanyDiff) " + schmInfo.getAuditSDiffCmpChar().getValue() + schmInfo.getAuditSDiffCmpValue();
        }
        StringBuffer doubleFilter = new StringBuffer();
        if (schmInfo.getAuditDDiffCmpChar() != null && schmInfo.getAuditDDiffCmpValue() != null) {
            doubleFilter.append(" (acctMap.FIsUnilateralReconciliation<>1 and abs(billHead.FCompanyDiff) " + schmInfo.getAuditDDiffCmpChar().getValue() + schmInfo.getAuditDDiffCmpValue());
            doubleFilter.append(" and billHead.fid in (");
            doubleFilter.append("       select headId from (");
            doubleFilter.append("            select distinct a.fid headId,b.fcompanyid companyId,c.FCONFIRMSTATUS from T_Csl_CheckageBillHead a");
            doubleFilter.append("            inner join t_csl_checkagebill b on a.fid=b.FBILLHEADID");
            doubleFilter.append("            inner join t_csl_checkagebillcompany c on c.fid=b.FBILLCOMPANYID");
            doubleFilter.append("            inner join ").append(tmpTable).append(" tmp on tmp.fid=a.fid ");
            doubleFilter.append("            where c.FCONFIRMSTATUS=1 ) tt group by headId having count(*)>=2 ");
            doubleFilter.append("      ) )  ");
        }
        if (singleFilter != null && doubleFilter != null) {
            sql.append(" and (").append(singleFilter).append(" or ").append(doubleFilter).append(")");
        } else if (singleFilter == null && doubleFilter == null) {
            sql.append(" and billHead.FCompanyDiff=0 ");
        } else {
            sql.append(" and ").append(singleFilter == null ? doubleFilter : singleFilter);
        }
        sql.append(")");
        DbUtil.execute(ctx, sql.getSQL(), sql.getParams());
    }

    protected CheckageFilterInfo initFilterInfo(AutoCheckParams params, FullOrgUnitInfo orgUnit) {
        CheckageFilterInfo filterInfo = super.initCommonFilterInfo(params, orgUnit);
        filterInfo.confirmStatus = 1;
        filterInfo.auditStatus = 1;
        return filterInfo;
    }
}

