/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckWorkeFilterInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AutoCheckSchmUnitLogInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageCompanyInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.QueryCheckageDataFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AbstractAutoCheckTask;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckException;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoCheckParams;
import com.kingdee.eas.fi.newrpt.accountcheck.app.autocheck.AutoConfirmCheckDataHandleTask;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AutoGetCheckDataHandleTask
extends AbstractAutoCheckTask {
    @Override
    protected void processSingleOrgUnit(Context ctx, AutoCheckParams autoCheckParams, FullOrgUnitInfo orgUnit) throws Exception {
        int[] periods = autoCheckParams.getPeriods();
        Map params = this.getQueryParams(ctx, autoCheckParams, orgUnit);
        AccountCheckWorkeFilterInfo filterInfo = AutoConfirmCheckDataHandleTask.getAccountCheckWorkeFilter(ctx, autoCheckParams, orgUnit);
        HashMap<String, Serializable> paramMap = new HashMap<String, Serializable>();
        paramMap.put("autoCheckParams", autoCheckParams);
        for (int i = 0; i < periods.length; ++i) {
            int period = periods[i];
            params.put("period", period);
            QueryCheckageDataFacadeFactory.getLocalInstance(ctx).queryCheckageData(params);
            filterInfo.setPeriod(period);
            paramMap.put("filterInfo", filterInfo);
            AccountCheckFacadeFactory.getLocalInstance(ctx).fetchDataBySchm(paramMap);
        }
    }

    private Map getQueryParams(Context ctx, AutoCheckParams autoCheckParams, FullOrgUnitInfo orgUnit) throws AutoCheckException {
        String checkageCompanyId = orgUnit.getId().toString();
        boolean isIncludingUnPosted = this.isIncludingUnPosted(ctx, checkageCompanyId);
        AutoCheckSchmInfo schmInfo = autoCheckParams.getSchmInfo();
        CurrencyInfo currency = schmInfo.getCurrency();
        int year = autoCheckParams.getYear();
        String userId = autoCheckParams.getUserId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("companyId", checkageCompanyId);
        params.put("isIncludeUnPosted", isIncludingUnPosted);
        params.put("currencyId", currency.getId().toString());
        params.put("year", year);
        params.put("userId", userId);
        return params;
    }

    private boolean isIncludingUnPosted(Context ctx, String checkageCompanyId) throws AutoCheckException {
        boolean isIncludingUnPosted = false;
        if (checkageCompanyId != null) {
            try {
                CheckageCompanyInfo info = CheckageCompanyFactory.getLocalInstance(ctx).getCheckageCompanyInfo("Select isIncludingUnPosted where company = '" + checkageCompanyId + "'");
                isIncludingUnPosted = info.isIsIncludingUnPosted();
                return isIncludingUnPosted;
            }
            catch (Exception e) {
                throw new AutoCheckException("");
            }
        }
        return isIncludingUnPosted;
    }

    @Override
    protected void insertOrgUnitExecLog(Context ctx, FullOrgUnitInfo orgUnit, boolean isSuccess) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        String bosType = new AutoCheckSchmUnitLogInfo().getBOSType().toString();
        String schmLogId = this.params.getSchmLogId();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String curTime = "{ts'" + formatter.format(new Date()) + "'}";
        AutoCheckSchmInfo schmInfo = this.params.getSchmInfo();
        int year = this.params.getYear();
        int[] periods = this.params.getPeriods();
        HashSet<Integer> periodSet = new HashSet<Integer>();
        for (int i : periods) {
            periodSet.add(i);
        }
        CurrencyInfo currency = schmInfo.getCurrency();
        String schmId = schmInfo.getId().toString();
        String creatorId = ctx.getCaller().toString();
        String orgUnitId = orgUnit.getId().toString();
        int getDataExecStatus = isSuccess ? 3 : 4;
        int confirmExecStatus = this.params.getSchmInfo().isIsConfirm() ? 1 : 0;
        sql.append(" select newbosid('").append(bosType).append("') fid,'").append(schmLogId).append("' FSchmLogId, \n");
        sql.append("ownCompanyId2 FOwnCompanyId, targetCompanyId2 FTargetCompanyId, \n");
        sql.append(getDataExecStatus).append(" FGetDataExecStatus, ").append(confirmExecStatus).append(" FConfirmExecStatus, \n");
        sql.append("isnull(sum(rs.confirmDebit2),0)-isnull(sum(rs.confirmCredit2),0) diffAmount,").append(curTime).append(" FcreateTime,'").append(creatorId).append("' fcreatorId, \n");
        sql.append("'").append(creatorId).append("' flastUpdateUserId,").append(curTime).append(" flastUpdateTime ");
        sql.append("from (  \n");
        sql.append("select case when bill2.FCompanyId=? then bill2.FCompanyId else bill2.FTargetCompanyId end ownCompanyId2, \n", orgUnitId);
        sql.append("case when bill2.FCompanyId=? then bill2.FTargetCompanyId else bill2.FCompanyId end targetCompanyId2, \n", orgUnitId);
        sql.append("bill2.FConfirmDebit confirmDebit2, bill2.FConfirmCredit confirmCredit2  \n");
        sql.append("from T_Csl_CheckageBill bill2  \n");
        sql.append("where bill2.FbillHeadId in   \n");
        sql.append("(  \n");
        sql.append("select distinct bill1.FbillHeadId  \n");
        sql.append("from T_Csl_CheckageBill bill1  \n");
        sql.append("inner join T_Csl_CheckageBillCompany billCompany on billCompany.fid=bill1.FBillCompanyId  \n");
        sql.append("where billCompany.FPackSchmId=?  \n", schmId);
        sql.append("and bill1.FYear=?  \n", year);
        sql.append("and bill1.FPeriod in  \n", periodSet);
        sql.append("and bill1.FCurrencyId=?  \n", currency.getId().toString());
        sql.append("and (bill1.FCompanyId=?  \n", orgUnitId);
        sql.append("or bill1.FTARGETCOMPANYID=?)  \n", orgUnitId);
        sql.append(")  \n");
        sql.append(") rs  \n");
        sql.append("group by rs.ownCompanyId2,rs.targetCompanyId2");
        IRowSet row = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        HashSet<String> unitLogIdSet = new HashSet<String>();
        if (row != null && row.size() > 0) {
            while (row.next()) {
                Object[] parmas = new Object[11];
                unitLogIdSet.add(row.getString("fid"));
                parmas[0] = row.getString("fid");
                parmas[1] = row.getString("FSchmLogId");
                parmas[2] = row.getString("FOwnCompanyId");
                parmas[3] = row.getString("FTargetCompanyId");
                parmas[4] = row.getInt("FGetDataExecStatus");
                parmas[5] = row.getInt("FConfirmExecStatus");
                parmas[6] = row.getBigDecimal("diffAmount");
                parmas[7] = row.getTimestamp("FcreateTime");
                parmas[8] = row.getString("fcreatorId");
                parmas[9] = row.getString("flastUpdateUserId");
                parmas[10] = row.getTimestamp("flastUpdateTime");
                paramsList.add(parmas);
            }
        }
        if (paramsList.size() > 0) {
            SQLBuilder insertSql = new SQLBuilder();
            insertSql.append("insert into T_Csl_AutoCheckSchmUnitLog(fid,FSchmLogId,FOwnCompanyId,FTargetCompanyId,FGetDataExecStatus,FConfirmExecStatus,");
            insertSql.append("FDiffAmount,FcreateTime,fcreatorId,flastUpdateUserId,flastUpdateTime) \n");
            insertSql.append("values(?,?,?,?,?,?,?,?,?,?,?) \n");
            DbUtil.executeBatch(ctx, insertSql.toString(), paramsList);
            sql.reset();
            sql.append("select Fid,FOwnCompanyId,FTargetCompanyId,FDiffAmount from T_Csl_AutoCheckSchmUnitLog where fid in ", unitLogIdSet);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            HashSet<String> unitIdSet = new HashSet<String>();
            HashSet<String> ownCompanyIdSet = new HashSet<String>();
            HashSet<String> targetCompanyIdSet = new HashSet<String>();
            HashMap<String, BigDecimal> diffAmountMap = new HashMap<String, BigDecimal>();
            while (rowSet.next()) {
                unitIdSet.add(rowSet.getString("Fid"));
                diffAmountMap.put(rowSet.getString("FTargetCompanyId") + rowSet.getString("FOwnCompanyId"), rowSet.getBigDecimal("FDiffAmount"));
                ownCompanyIdSet.add(rowSet.getString("FOwnCompanyId"));
                targetCompanyIdSet.add(rowSet.getString("FTargetCompanyId"));
            }
            if (!unitIdSet.isEmpty()) {
                sql.reset();
                sql.append("select Fid,FOwnCompanyId,FTargetCompanyId,FDiffAmount from T_Csl_AutoCheckSchmUnitLog \n");
                sql.append("where fid not in \n", unitIdSet);
                sql.append("and FSchmLogId=? \n", schmLogId);
                sql.append("and FOwnCompanyId in \n", targetCompanyIdSet);
                sql.append("and FTargetCompanyId in", ownCompanyIdSet);
                sql.append("and FOrgUnitId is null");
                rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
                HashMap<String, BigDecimal> idDiffMap = new HashMap<String, BigDecimal>();
                while (rowSet.next()) {
                    String key = rowSet.getString("FOwnCompanyId") + rowSet.getString("FTargetCompanyId");
                    BigDecimal diff = (BigDecimal)diffAmountMap.get(key);
                    if (diff == null) continue;
                    idDiffMap.put(rowSet.getString("Fid"), diff);
                }
                if (idDiffMap.size() > 0) {
                    String updateSql = "update T_Csl_AutoCheckSchmUnitLog set FDiffAmount=? where fid=?";
                    Set schmUnitLogIDSet = idDiffMap.keySet();
                    ArrayList<Object[]> updateParamsList = new ArrayList<Object[]>();
                    Object[] parmas = null;
                    for (String schmUnitLogId : schmUnitLogIDSet) {
                        parmas = new Object[]{idDiffMap.get(schmUnitLogId), schmUnitLogId};
                        updateParamsList.add(parmas);
                    }
                    if (updateParamsList.size() > 0) {
                        DbUtil.executeBatch(ctx, updateSql, updateParamsList);
                    }
                }
            }
        }
    }
}

