/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.accountcheck.app.querycheckagedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountAndMapAccountInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountCheckFacadeFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapDispenseInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.AccountMapInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.BalTypeEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageAccountFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataCollection;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataFactory;
import com.kingdee.eas.fi.newrpt.accountcheck.CheckageBillDataInfo;
import com.kingdee.eas.fi.newrpt.accountcheck.DataSourceEnum;
import com.kingdee.eas.fi.newrpt.accountcheck.ItemTypeEnum;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class QueryBalanceUtil {
    public static final String SPLITSTR = "###";

    public static CheckageBillDataCollection getCheckageBillDataCollection(Context ctx, boolean isOwner, IRowSet rowSet, boolean isIncludePosted, String balTypeString, int year, int period, String currencyId, Map<Integer, List<AccountViewInfo>> balTypeAccountViews) throws Exception {
        CheckageBillDataCollection checkBillDataCollection = new CheckageBillDataCollection();
        for (Integer balType : balTypeAccountViews.keySet()) {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if ("C".equals(balTypeString)) {
                    if (balType != 1) continue;
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 1, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if ("Y".equals(balTypeString)) {
                    if (balType != 8) continue;
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 8, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if ("SY".equals(balTypeString)) {
                    if (balType != 6) continue;
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 6, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if ("SL".equals(balTypeString)) {
                    if (balType != 7) continue;
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 7, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if ("JF_DF".equals(balTypeString)) {
                    if (balType == 2) {
                        QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 2, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                        continue;
                    }
                    if (balType != 3) continue;
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 3, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if (!"JL_DL".equals(balTypeString)) continue;
                if (balType == 4) {
                    QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 4, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
                    continue;
                }
                if (balType != 5) continue;
                QueryBalanceUtil.getCheckageBillCollectionByBalType(ctx, 5, isOwner, rowSet, isIncludePosted, year, period, currencyId, balTypeAccountViews, checkBillDataCollection);
            }
        }
        return checkBillDataCollection;
    }

    public static Map<String, BigDecimal> getTotalValue(Context ctx, boolean isOwner, IRowSet rowSet, String balTypeString, int year, int period, String currencyId, boolean posted, Map<Integer, List<AccountViewInfo>> balTypeAccountViews, Map<String, BigDecimal> values, Map<String, Boolean> includeUnPosteds, Map<String, BigDecimal> mappingReports) throws SQLException, EASBizException, BOSException {
        for (Integer balType : balTypeAccountViews.keySet()) {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if ("C".equals(balTypeString)) {
                    if (balType != 1) continue;
                    QueryBalanceUtil.getValue(ctx, 1, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if ("Y".equals(balTypeString)) {
                    if (balType != 8) continue;
                    QueryBalanceUtil.getValue(ctx, 8, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if ("SY".equals(balTypeString)) {
                    if (balType != 6) continue;
                    QueryBalanceUtil.getValue(ctx, 6, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if ("SL".equals(balTypeString)) {
                    if (balType != 7) continue;
                    QueryBalanceUtil.getValue(ctx, 7, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if ("JF_DF".equals(balTypeString)) {
                    if (balType == 2) {
                        QueryBalanceUtil.getValue(ctx, 2, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                        continue;
                    }
                    if (balType != 3) continue;
                    QueryBalanceUtil.getValue(ctx, 3, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if (!"JL_DL".equals(balTypeString)) continue;
                if (balType == 4) {
                    QueryBalanceUtil.getValue(ctx, 4, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
                    continue;
                }
                if (balType != 5) continue;
                QueryBalanceUtil.getValue(ctx, 5, isOwner, rowSet, posted, balTypeAccountViews, includeUnPosteds, values, mappingReports);
            }
        }
        return values;
    }

    private static void getValue(Context ctx, int balType, boolean isOwner, IRowSet rowSet, boolean posted, Map<Integer, List<AccountViewInfo>> balTypeAccountViews, Map<String, Boolean> includeUnPosteds, Map<String, BigDecimal> values, Map<String, BigDecimal> mappingReports) throws SQLException, EASBizException, BOSException {
        if (isOwner) {
            List<AccountViewInfo> accounts = balTypeAccountViews.get(balType);
            String accountId = rowSet.getString("accountID");
            for (AccountViewInfo account : accounts) {
                String tarCompany;
                String acctId = account.getId().toString();
                if (!acctId.equals(accountId)) continue;
                String ownCompany = rowSet.getString("ownCompany");
                boolean isSamePosted = true;
                if (includeUnPosteds.containsKey(ownCompany)) {
                    boolean isPosted = includeUnPosteds.get(ownCompany);
                    if (isPosted != posted) {
                        isSamePosted = false;
                    }
                } else {
                    isSamePosted = false;
                }
                if (!isSamePosted || (tarCompany = rowSet.getString("tarCompany")) == null) continue;
                BigDecimal money = rowSet.getBigDecimal(QueryBalanceUtil.getValueColumnKey(balType));
                BalanceDirectionEnum balanceDirectionEnum = account.getDC();
                money = QueryBalanceUtil.getBalanceMoney(balType, balanceDirectionEnum, money);
                if (money.compareTo(BigDecimal.ZERO) == 0) continue;
                money = QueryBalanceUtil.getMoney(balType, balanceDirectionEnum, money);
                String key = ownCompany + SPLITSTR + tarCompany;
                if (values.containsKey(key)) {
                    BigDecimal value = values.get(key);
                    value = value.add(money);
                    values.put(key, value);
                } else {
                    values.put(key, money);
                }
                String mpKey = key + SPLITSTR + accountId + SPLITSTR + balanceDirectionEnum.getValue() + SPLITSTR + balType;
                mappingReports.put(mpKey, money);
            }
        } else {
            String ownCompany = rowSet.getString("ownCompany");
            boolean isSamePosted = true;
            if (includeUnPosteds.containsKey(ownCompany)) {
                boolean isPosted = includeUnPosteds.get(ownCompany);
                if (isPosted != posted) {
                    isSamePosted = false;
                }
            } else {
                isSamePosted = false;
            }
            if (isSamePosted) {
                String tarCompany = rowSet.getString("tarCompany");
                if (tarCompany == null) {
                    return;
                }
                String accountId = rowSet.getString("accountID");
                AccountViewInfo accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
                String accountNumber = accountView.getNumber();
                int dc = rowSet.getInt("dc");
                List<AccountViewInfo> accounts = balTypeAccountViews.get(balType);
                for (AccountViewInfo account : accounts) {
                    String number = account.getNumber();
                    if (!number.equals(accountNumber)) continue;
                    dc = account.getDC().getValue();
                }
                Object money = rowSet.getBigDecimal(QueryBalanceUtil.getValueColumnKey(balType));
                BalanceDirectionEnum balanceDirectionEnum = BalanceDirectionEnum.getEnum((int)dc);
                money = QueryBalanceUtil.getBalanceMoney(balType, balanceDirectionEnum, (BigDecimal)money);
                if (((BigDecimal)money).compareTo(BigDecimal.ZERO) == 0) {
                    return;
                }
                money = QueryBalanceUtil.getMoney(balType, balanceDirectionEnum, (BigDecimal)money);
                String key = ownCompany + SPLITSTR + tarCompany;
                if (values.containsKey(key)) {
                    BigDecimal value = values.get(key);
                    value = value.add((BigDecimal)money);
                    values.put(key, value);
                } else {
                    values.put(key, (BigDecimal)money);
                }
                String mpKey = key + SPLITSTR + accountId + SPLITSTR + dc + SPLITSTR + balType;
                mappingReports.put(mpKey, (BigDecimal)money);
            }
        }
    }

    private static BigDecimal getMoney(int balType, BalanceDirectionEnum balanceDirectionEnum, BigDecimal money) {
        BigDecimal zero = new BigDecimal(0);
        if (balType == 1 || balType == 8) {
            if (money.compareTo(zero) < 0) {
                money = money.multiply(new BigDecimal(-1));
            }
            return money;
        }
        return money;
    }

    private static void getCheckageBillCollectionByBalType(Context ctx, int balType, boolean isOwner, IRowSet rowSet, boolean isIncludePosted, int year, int period, String currencyId, Map<Integer, List<AccountViewInfo>> balTypeAccountViews, CheckageBillDataCollection checkBillDataCollection) throws Exception {
        CheckageBillDataInfo checkageBillInfo = null;
        if (isOwner) {
            List<AccountViewInfo> accounts = balTypeAccountViews.get(balType);
            checkageBillInfo = QueryBalanceUtil.getCheckageBillInfo(rowSet, accounts, balType, isIncludePosted, year, period, currencyId);
        } else {
            checkageBillInfo = QueryBalanceUtil.getTarCheckageBillInfo(ctx, rowSet, balType, isIncludePosted, year, period, currencyId);
        }
        if (checkageBillInfo != null && !checkageBillInfo.isEmpty()) {
            checkBillDataCollection.add(checkageBillInfo);
        }
    }

    private static CheckageBillDataInfo getCheckageBillInfo(IRowSet rowSet, List<AccountViewInfo> accounts, int balType, boolean isIncludePosted, int year, int period, String currencyId) throws Exception {
        CheckageBillDataInfo checkageBillDataInfo = new CheckageBillDataInfo();
        String accountId = rowSet.getString("accountID");
        for (AccountViewInfo account : accounts) {
            String acctId = account.getId().toString();
            if (!acctId.equals(accountId)) continue;
            String ownCompany = rowSet.getString("ownCompany");
            String tarCompany = rowSet.getString("tarCompany");
            if (tarCompany == null) {
                return null;
            }
            BigDecimal money = rowSet.getBigDecimal(QueryBalanceUtil.getValueColumnKey(balType));
            BalanceDirectionEnum balanceDirectionEnum = account.getDC();
            money = QueryBalanceUtil.getBalanceMoney(balType, balanceDirectionEnum, money);
            if (money.compareTo(BigDecimal.ZERO) == 0) {
                return null;
            }
            QueryBalanceUtil.setMoneyToCheckageBillInfo(checkageBillDataInfo, balType, balanceDirectionEnum, money);
            checkageBillDataInfo.setYear(year);
            checkageBillDataInfo.setPeriod(period);
            checkageBillDataInfo.setAccount(account);
            checkageBillDataInfo.setItemNumber(account.getNumber());
            checkageBillDataInfo.setBalType(BalTypeEnum.getEnum(balType));
            checkageBillDataInfo.setDataElement(balType);
            checkageBillDataInfo.setIsIncludeUnPosted(isIncludePosted);
            QueryBalanceUtil.setCurrencyToCheckageBillInfo(currencyId, checkageBillDataInfo);
            QueryBalanceUtil.setCompanyToCheckageBillInfo(checkageBillDataInfo, ownCompany);
            QueryBalanceUtil.setTarCompanyToCheckageBillInfo(checkageBillDataInfo, tarCompany);
        }
        return checkageBillDataInfo;
    }

    private static CheckageBillDataInfo getTarCheckageBillInfo(Context ctx, IRowSet rowSet, int balType, boolean isIncludePosted, int year, int period, String currencyId) throws Exception {
        CheckageBillDataInfo checkageBillDataInfo = new CheckageBillDataInfo();
        String ownCompany = rowSet.getString("ownCompany");
        String tarCompany = rowSet.getString("tarCompany");
        if (tarCompany == null) {
            return null;
        }
        String accountId = rowSet.getString("accountID");
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
        int dc = rowSet.getInt("dc");
        BigDecimal money = rowSet.getBigDecimal(QueryBalanceUtil.getValueColumnKey(balType));
        BalanceDirectionEnum balanceDirectionEnum = BalanceDirectionEnum.getEnum((int)dc);
        money = QueryBalanceUtil.getBalanceMoney(balType, balanceDirectionEnum, money);
        if (money.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        QueryBalanceUtil.setMoneyToCheckageBillInfo(checkageBillDataInfo, balType, balanceDirectionEnum, money);
        checkageBillDataInfo.setYear(year);
        checkageBillDataInfo.setPeriod(period);
        checkageBillDataInfo.setAccount(account);
        checkageBillDataInfo.setItemNumber(account.getNumber());
        checkageBillDataInfo.setBalType(BalTypeEnum.getEnum(balType));
        checkageBillDataInfo.setDataElement(balType);
        checkageBillDataInfo.setIsIncludeUnPosted(isIncludePosted);
        QueryBalanceUtil.setCurrencyToCheckageBillInfo(currencyId, checkageBillDataInfo);
        QueryBalanceUtil.setCompanyToCheckageBillInfo(checkageBillDataInfo, ownCompany);
        QueryBalanceUtil.setTarCompanyToCheckageBillInfo(checkageBillDataInfo, tarCompany);
        return checkageBillDataInfo;
    }

    private static void setTarCompanyToCheckageBillInfo(CheckageBillDataInfo checkageBillDataInfo, String tarCompany) {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)tarCompany));
        checkageBillDataInfo.setTargetCompany(company);
    }

    private static void setCurrencyToCheckageBillInfo(String currencyId, CheckageBillDataInfo checkageBillDataInfo) {
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)currencyId));
        checkageBillDataInfo.setCurrency(currency);
    }

    private static void setCompanyToCheckageBillInfo(CheckageBillDataInfo checkageBillDataInfo, String ownCompany) {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)ownCompany));
        checkageBillDataInfo.setCompany(company);
    }

    private static void setMoneyToCheckageBillInfo(CheckageBillDataInfo checkageBillDataInfo, int balType, BalanceDirectionEnum balanceDirectionEnum, BigDecimal money) {
        BigDecimal zero = new BigDecimal(0);
        if (balType == 2 || balType == 4) {
            QueryBalanceUtil.setDebit(checkageBillDataInfo, money);
        } else if (balType == 3 || balType == 5) {
            QueryBalanceUtil.setCredit(checkageBillDataInfo, money);
        } else if (balType == 1 || balType == 8) {
            if (balanceDirectionEnum.getValue() == 1) {
                if (money.compareTo(zero) < 0) {
                    money = money.multiply(new BigDecimal(-1));
                    QueryBalanceUtil.setCredit(checkageBillDataInfo, money);
                } else {
                    QueryBalanceUtil.setDebit(checkageBillDataInfo, money);
                }
            } else if (balanceDirectionEnum.getValue() == -1) {
                if (money.compareTo(zero) < 0) {
                    money = money.multiply(new BigDecimal(-1));
                    QueryBalanceUtil.setDebit(checkageBillDataInfo, money);
                } else {
                    QueryBalanceUtil.setCredit(checkageBillDataInfo, money);
                }
            }
        } else if (balType == 6 || balType == 7) {
            if (balanceDirectionEnum.getValue() == 1) {
                QueryBalanceUtil.setDebit(checkageBillDataInfo, money);
            } else if (balanceDirectionEnum.getValue() == -1) {
                QueryBalanceUtil.setCredit(checkageBillDataInfo, money);
            }
        }
    }

    private static void setCredit(CheckageBillDataInfo checkageBillDataInfo, BigDecimal money) {
        checkageBillDataInfo.setCredit(money);
        checkageBillDataInfo.setConfirmCredit(money);
        checkageBillDataInfo.setAuditCredit(money);
    }

    private static void setDebit(CheckageBillDataInfo checkageBillDataInfo, BigDecimal money) {
        checkageBillDataInfo.setDebit(money);
        checkageBillDataInfo.setConfirmDebit(money);
        checkageBillDataInfo.setAuditDebit(money);
    }

    private static BigDecimal getBalanceMoney(int balType, BalanceDirectionEnum balanceDirectionEnum, BigDecimal money) {
        if (balType == 1 || balType == 8 || balType == 6 || balType == 7) {
            BigDecimal dc = new BigDecimal(balanceDirectionEnum.getValue());
            money = money.multiply(dc);
        }
        return money;
    }

    private static String getValueColumnKey(int balType) {
        switch (balType) {
            case 1: {
                return BalTypeEnum.C.getName();
            }
            case 8: {
                return BalTypeEnum.Y.getName();
            }
            case 2: {
                return BalTypeEnum.JF.getName();
            }
            case 3: {
                return BalTypeEnum.DF.getName();
            }
            case 4: {
                return BalTypeEnum.JL.getName();
            }
            case 5: {
                return BalTypeEnum.DL.getName();
            }
            case 6: {
                return BalTypeEnum.SY.getName();
            }
            case 7: {
                return BalTypeEnum.SL.getName();
            }
        }
        return null;
    }

    public static void removeExistsCheckageBillData(Context ctx, int itemType, String companyId, String currencyId, int year, int period, CheckageBillDataCollection checkageBillDataCollection) throws BOSException {
        CheckageBillDataCollection existCollection = QueryBalanceUtil.getExistRecord(ctx, itemType, companyId, currencyId, year, period);
        if (existCollection.isEmpty() || checkageBillDataCollection.isEmpty()) {
            return;
        }
        Iterator it = checkageBillDataCollection.iterator();
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        while (it.hasNext()) {
            CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
            String key = QueryBalanceUtil.getCompareKey(checkageBillDataInfo);
            for (int i = 0; i < existCollection.size(); ++i) {
                CheckageBillDataInfo existInfo = existCollection.get(i);
                String existKey = QueryBalanceUtil.getCompareKey(existInfo);
                if (!key.equals(existKey) || removeds.contains(checkageBillDataInfo)) continue;
                removeds.add(checkageBillDataInfo);
            }
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    private static String getCompareKey(CheckageBillDataInfo checkageBillDataInfo) {
        String companyId = checkageBillDataInfo.getCompany().getId().toString();
        String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
        String currencyId = checkageBillDataInfo.getCurrency().getId().toString();
        int year = checkageBillDataInfo.getYear();
        int period = checkageBillDataInfo.getPeriod();
        String key = companyId + tarCompanyId + currencyId + year + period;
        return key;
    }

    private static CheckageBillDataCollection getExistRecord(Context ctx, int itemType, String companyId, String currencyId, int year, int period) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("targetCompany", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("createCompany", (Object)companyId, CompareType.NOTEQUALS));
        view.setFilter(filter);
        return CheckageBillDataFactory.getLocalInstance(ctx).getCheckageBillDataCollection(view);
    }

    public static void removeDisabledCompanyCheckageData(List<String> enableCompanyIds, CheckageBillDataCollection checkageBillDataCollection) {
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        Iterator it = checkageBillDataCollection.iterator();
        while (it.hasNext()) {
            CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
            String companyId = checkageBillDataInfo.getCompany().getId().toString();
            String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
            if (enableCompanyIds.contains(companyId) && enableCompanyIds.contains(tarCompanyId)) continue;
            removeds.add(checkageBillDataInfo);
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCheckageBillData(Context ctx, ItemTypeEnum itemType, DataSourceEnum dataSource, String createCompanyId, CheckageBillDataCollection checkageBillDataCollection) throws Exception {
        if (checkageBillDataCollection.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            Iterator it = checkageBillDataCollection.iterator();
            conn = EJBFactory.getQueryConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" Insert into T_Csl_CheckageBillData (FID, FYear, FPeriod, FCurrencyId, FCompanyId, FTargetCompanyId, FAccountId, FBalType, FisIncludeUnPosted, FDebit, FCredit, FConfirmDebit, FConfirmCredit, FAuditDebit, FAuditCredit, FCreatorId, FCreateTime, FLastUpdateUserId, FLastUpdateTime, FControlUnitId, FCreateCompanyId, FItemType, FDataElement,FItemNumber,FItemName, FDataSource)");
            sql.append("Values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps = conn.prepareStatement(sql.toString());
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            String cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
            Timestamp createtime = QueryBalanceUtil.getTime();
            boolean isInsert = false;
            while (it.hasNext()) {
                CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
                String id = BOSUuid.create((BOSObjectType)checkageBillDataInfo.getBOSType()).toString();
                int year = checkageBillDataInfo.getYear();
                int period = checkageBillDataInfo.getPeriod();
                String currencyId = checkageBillDataInfo.getCurrency().getId().toString();
                String companyId = checkageBillDataInfo.getCompany().getId().toString();
                String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
                String accountId = null;
                int balType = 0;
                if (checkageBillDataInfo.getAccount() != null) {
                    accountId = checkageBillDataInfo.getAccount().getId().toString();
                    balType = checkageBillDataInfo.getBalType().getValue();
                }
                int dataElement = checkageBillDataInfo.getDataElement();
                boolean isIncludeUnPosted = checkageBillDataInfo.isIsIncludeUnPosted();
                BigDecimal debit = checkageBillDataInfo.getDebit();
                BigDecimal credit = checkageBillDataInfo.getCredit();
                BigDecimal confirmDebit = checkageBillDataInfo.getConfirmDebit();
                BigDecimal confirmCredit = checkageBillDataInfo.getConfirmCredit();
                BigDecimal auditDebit = checkageBillDataInfo.getAuditDebit();
                BigDecimal auditCredit = checkageBillDataInfo.getAuditCredit();
                ps.setObject(1, id);
                ps.setObject(2, year);
                ps.setObject(3, period);
                ps.setObject(4, currencyId);
                ps.setObject(5, companyId);
                ps.setObject(6, tarCompanyId);
                ps.setObject(7, accountId);
                ps.setObject(8, balType);
                ps.setObject(9, isIncludeUnPosted);
                ps.setObject(10, debit);
                ps.setObject(11, credit);
                ps.setObject(12, confirmDebit);
                ps.setObject(13, confirmCredit);
                ps.setObject(14, auditDebit);
                ps.setObject(15, auditCredit);
                ps.setObject(16, userId);
                ps.setObject(17, createtime);
                ps.setObject(18, userId);
                ps.setObject(19, createtime);
                ps.setObject(20, cuId);
                ps.setObject(21, createCompanyId);
                ps.setObject(22, itemType.getValue());
                if (!StringUtils.isEmpty((String)accountId)) {
                    ps.setObject(23, balType);
                } else {
                    ps.setObject(8, dataElement);
                    ps.setObject(23, dataElement);
                }
                if (!StringUtils.isEmpty((String)accountId)) {
                    ps.setObject(24, checkageBillDataInfo.getAccount().getNumber());
                    ps.setObject(25, checkageBillDataInfo.getAccount().getName());
                } else {
                    ps.setObject(24, checkageBillDataInfo.getItemNumber());
                    ps.setObject(25, checkageBillDataInfo.getItemName());
                }
                ps.setObject(26, dataSource.getValue());
                ps.addBatch();
                isInsert = true;
            }
            if (isInsert) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(null, ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
    }

    public static Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public static void removeCheckageBillData(Context ctx, boolean isFromImport, int itemType, int dataSource, String companyTempTable, int year, int period, String currencyId) throws Exception {
        if (!isFromImport) {
            HashMap<String, Object> infoMap = new HashMap<String, Object>();
            HashSet<Integer> dataSourceSet = new HashSet<Integer>();
            dataSourceSet.add(1);
            dataSourceSet.add(3);
            infoMap.put("dataSourceSet", dataSourceSet);
            infoMap.put("year", year);
            infoMap.put("period", period);
            infoMap.put("currencyId", currencyId);
            infoMap.put("companyTempTable", companyTempTable);
            infoMap.put("itemTypeEnum", itemType);
            AccountCheckFacadeFactory.getLocalInstance(ctx).removeBillData(infoMap);
        }
        StringBuffer sql = new StringBuffer();
        sql.append("Delete From ").append(" T_Csl_CheckageBillData \n");
        sql.append(" Where FYear = ? And FPeriod = ? And FCurrencyId = ? And FItemType = ? \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(year);
        params.add(period);
        params.add(currencyId);
        params.add(itemType);
        sql.append(" And (FCreateCompanyId in (select FCompanyId From ").append(companyTempTable).append(" ) \n");
        sql.append(" OR (FCompanyId in (select FCompanyId From ").append(companyTempTable).append(" )");
        sql.append(" And FCreateCompanyId not in (select FCompanyId From ").append(companyTempTable).append(" )))");
        if (isFromImport) {
            sql.append(" And FDataSource = ? ");
            params.add(dataSource);
        } else if (dataSource == 4 || dataSource == 5) {
            sql.append(" And FDataSource in (?,?,?) ");
            params.add(dataSource);
            params.add(1);
            params.add(3);
        }
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    public static void removeDeletedCheckageBillRecord(Context ctx, int itemType, int dataSource, String companyTempTable, int year, int period, String currencyId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("Delete From ").append(" T_CSL_BillDeleteRecord ").append(" Where FYear = ? And FPeriod = ? And FCurrencyId = ? And FItemType = ? And FDataSource = ? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(year);
        params.add(period);
        params.add(currencyId);
        params.add(itemType);
        params.add(dataSource);
        sql.append(" And FCompanyId in ( Select FCompanyId From ").append(companyTempTable).append(" )");
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean batchRemoveData(Context ctx, String tableName, List<String> params) throws Exception {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        try {
            conn = EJBFactory.getQueryConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Delete From ").append(tableName).append(" Where Fid = ?");
            ps = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                ps.setObject(1, params.get(i));
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
                ps.clearBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(null, ps, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        return flag;
    }

    public static void removeWrongStatusChekageData(Map<String, Boolean> includeUnPosteds, CheckageBillDataCollection checkageBillDataCollection) {
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        Iterator it = checkageBillDataCollection.iterator();
        while (it.hasNext()) {
            boolean status;
            CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
            String companyId = checkageBillDataInfo.getCompany().getId().toString();
            boolean isIncludePosted = checkageBillDataInfo.isIsIncludeUnPosted();
            if (isIncludePosted == (status = includeUnPosteds.get(companyId).booleanValue())) continue;
            removeds.add(checkageBillDataInfo);
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    public static void removeDeletedChekageData(Context ctx, List<String> keys, CheckageBillDataCollection checkageBillDataCollection) throws BOSException, SQLException {
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        if (keys.isEmpty()) {
            return;
        }
        Iterator it = checkageBillDataCollection.iterator();
        while (it.hasNext()) {
            CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
            String companyId = checkageBillDataInfo.getCompany().getId().toString();
            String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
            int year = checkageBillDataInfo.getYear();
            int period = checkageBillDataInfo.getPeriod();
            String currencyId = checkageBillDataInfo.getCurrency().getId().toString();
            String itemNumber = checkageBillDataInfo.getItemNumber();
            int dataElement = checkageBillDataInfo.getDataElement();
            String key = companyId + tarCompanyId + year + period + currencyId + itemNumber + dataElement;
            if (!keys.contains(key)) continue;
            removeds.add(checkageBillDataInfo);
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    public static List<String> getDeletedChekageRecord(Context ctx, int itemType, int year, int period, String currencyId, int FDataSource) throws BOSException, SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        SQLBuilder sql = new SQLBuilder();
        sql.append(" Select FCompanyId companyId, FTargetCompanyId tarCompanyId, FItemNumber itemNumber, FDataElement dataElement \n");
        sql.append(" From T_CSL_BillDeleteRecord \n");
        sql.append(" Where FYear = ? ", year).append(" And FPeriod = ? ", period).append(" And FCurrencyId = ? ", currencyId).append(" And FItemType = ? ", itemType).append("And FDataSource = ?", FDataSource);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet.next()) {
            String companyId = rowSet.getString("companyId");
            String tarCompanyId = rowSet.getString("tarCompanyId");
            String itemNumber = rowSet.getString("itemNumber");
            String dataElement = rowSet.getString("dataElement");
            String key = companyId + tarCompanyId + year + period + currencyId + itemNumber + dataElement;
            keys.add(key);
        }
        return keys;
    }

    public static void removeSameChekageData(Context ctx, int itemType, int year, int period, String currencyId, int FDataSource, CheckageBillDataCollection checkageBillDataCollection) throws BOSException, SQLException {
        List<String> keys = QueryBalanceUtil.getAccessSettingRecord(ctx, itemType, year, period, currencyId, FDataSource);
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        if (keys.isEmpty()) {
            return;
        }
        Iterator it = checkageBillDataCollection.iterator();
        while (it.hasNext()) {
            CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
            String companyId = checkageBillDataInfo.getCompany().getId().toString();
            String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
            int myear = checkageBillDataInfo.getYear();
            int mperiod = checkageBillDataInfo.getPeriod();
            String mcurrencyId = checkageBillDataInfo.getCurrency().getId().toString();
            String itemNumber = checkageBillDataInfo.getItemNumber();
            int dataElement = checkageBillDataInfo.getDataElement();
            String key = companyId + tarCompanyId + myear + mperiod + mcurrencyId + itemNumber + dataElement;
            if (!keys.contains(key)) continue;
            removeds.add(checkageBillDataInfo);
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    public static List<String> getAccessSettingRecord(Context ctx, int itemType, int year, int period, String currencyId, int FDataSource) throws BOSException, SQLException {
        ArrayList<String> keys = new ArrayList<String>();
        SQLBuilder sql = new SQLBuilder();
        sql.append(" Select FCompanyId companyId, FTargetCompanyId tarCompanyId, FItemNumber itemNumber, FDataElement dataElement \n");
        sql.append(" From T_CSL_CheckageBillData \n");
        sql.append(" Where FYear = ? ", year).append(" And FPeriod = ? ", period).append(" And FCurrencyId = ? ", currencyId).append(" And FItemType = ? ", itemType).append("And FDataSource = ?", FDataSource);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
        while (rowSet.next()) {
            String companyId = rowSet.getString("companyId");
            String tarCompanyId = rowSet.getString("tarCompanyId");
            String itemNumber = rowSet.getString("itemNumber");
            String dataElement = rowSet.getString("dataElement");
            String key = companyId + tarCompanyId + year + period + currencyId + itemNumber + dataElement;
            keys.add(key);
        }
        return keys;
    }

    public static void removeCheckageBillDataByImportRecord(Context ctx, int itemType, boolean isFromImport, String companyId, String currencyId, int year, int period, CheckageBillDataCollection checkageBillDataCollection) throws BOSException {
        if (!isFromImport) {
            return;
        }
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        CheckageBillDataCollection existImportRecords = QueryBalanceUtil.getExistImportRecord(ctx, itemType, companyId, currencyId, year, period);
        if (existImportRecords != null && !existImportRecords.isEmpty()) {
            Iterator it = checkageBillDataCollection.iterator();
            while (it.hasNext()) {
                CheckageBillDataInfo chkBillData = (CheckageBillDataInfo)it.next();
                String key = QueryBalanceUtil.getExistImportRecordKey(chkBillData);
                for (int i = 0; i < existImportRecords.size(); ++i) {
                    CheckageBillDataInfo importChkBillData = existImportRecords.get(i);
                    String importKey = QueryBalanceUtil.getExistImportRecordKey(importChkBillData);
                    if (!key.equals(importKey) || removeds.contains(chkBillData)) continue;
                    removeds.add(chkBillData);
                }
            }
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
    }

    private static String getExistImportRecordKey(CheckageBillDataInfo chkBillData) {
        String companyId = chkBillData.getCompany().getId().toString();
        String tarCompanyId = chkBillData.getTargetCompany().getId().toString();
        int year = chkBillData.getYear();
        int period = chkBillData.getPeriod();
        String currencyId = chkBillData.getCurrency().getId().toString();
        String itemType = chkBillData.getItemType().getName();
        String itemNumber = chkBillData.getItemNumber();
        int dataElement = chkBillData.getDataElement();
        String key = companyId + tarCompanyId + year + period + currencyId + itemType + itemNumber + dataElement;
        return key;
    }

    private static CheckageBillDataCollection getExistImportRecord(Context ctx, int itemType, String companyId, String currencyId, int year, int period) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)itemType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("currency", (Object)currencyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("year", (Object)year, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)period, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        HashSet<Integer> ds = new HashSet<Integer>();
        ds.add(1);
        ds.add(3);
        filter.getFilterItems().add(new FilterItemInfo("dataSource", ds, CompareType.INCLUDE));
        view.setFilter(filter);
        return CheckageBillDataFactory.getLocalInstance(ctx).getCheckageBillDataCollection(view);
    }

    public static List<String> removeCheckageBillDataByConfirmedData(Context ctx, int itemType, int dataSource, String companyId, String currencyId, int year, int period, CheckageBillDataCollection checkageBillDataCollection) throws Exception {
        String number;
        HashMap<String, String[]> valueMap = new HashMap<String, String[]>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        ArrayList<String> handleWriteKeys = new ArrayList<String>();
        ArrayList<String> otherDataSourceKeys = new ArrayList<String>();
        QueryBalanceUtil.getConfirmedDataMap(ctx, false, itemType, dataSource, companyId, currencyId, year, period, valueMap, idMap, numberMap, handleWriteKeys, otherDataSourceKeys);
        QueryBalanceUtil.getConfirmedDataMap(ctx, true, itemType, dataSource, companyId, currencyId, year, period, valueMap, idMap, numberMap, handleWriteKeys, otherDataSourceKeys);
        ArrayList<CheckageBillDataInfo> removeds = new ArrayList<CheckageBillDataInfo>();
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> numList = new ArrayList<String>();
        ArrayList<String> removeKeys = new ArrayList<String>();
        ArrayList<String> msgList = new ArrayList<String>();
        if (!valueMap.isEmpty()) {
            Iterator it = checkageBillDataCollection.iterator();
            while (it.hasNext()) {
                CheckageBillDataInfo checkageBillDataInfo = (CheckageBillDataInfo)it.next();
                String key = QueryBalanceUtil.getCheckageAccountKey(ctx, itemType, checkageBillDataInfo);
                if (valueMap.containsKey(key)) {
                    String number2;
                    if (!removeds.contains(checkageBillDataInfo)) {
                        removeds.add(checkageBillDataInfo);
                        removeKeys.add(key);
                    }
                    BigDecimal debit = checkageBillDataInfo.getDebit();
                    BigDecimal credit = checkageBillDataInfo.getCredit();
                    String[] values = (String[])valueMap.get(key);
                    String debitC = values[0];
                    String creditC = values[1];
                    if ((debit == null || debit.toString().equals(debitC)) && (credit == null || credit.toString().equals(creditC)) || otherDataSourceKeys.contains(key)) continue;
                    String cbcId = (String)idMap.get(key);
                    if (!idList.contains(cbcId)) {
                        idList.add(cbcId);
                    }
                    if (numList.contains(number2 = (String)numberMap.get(key))) continue;
                    numList.add(number2);
                    continue;
                }
                if (otherDataSourceKeys.contains(key) || !numberMap.containsKey(key)) continue;
                if (!removeds.contains(checkageBillDataInfo)) {
                    removeds.add(checkageBillDataInfo);
                    removeKeys.add(key);
                }
                if (numList.contains(number = (String)numberMap.get(key))) continue;
                numList.add(number);
                String cbcId = QueryBalanceUtil.getCheckageBillIdByHeadNumber(ctx, number, itemType, companyId, currencyId, year, period);
                if (cbcId == null || idList.contains(cbcId)) continue;
                idList.add(cbcId);
            }
        }
        if (!removeKeys.isEmpty() && valueMap.size() > removeKeys.size()) {
            for (String key : valueMap.keySet()) {
                if (removeKeys.contains(key) || handleWriteKeys.contains(key)) continue;
                String cbcId = (String)idMap.get(key);
                if (!idList.contains(cbcId)) {
                    idList.add(cbcId);
                }
                if (numList.contains(number = (String)numberMap.get(key))) continue;
                numList.add(number);
            }
        }
        if (!removeds.isEmpty()) {
            for (CheckageBillDataInfo checkageBillDataInfo : removeds) {
                checkageBillDataCollection.remove(checkageBillDataInfo);
            }
        }
        if (!idList.isEmpty()) {
            QueryBalanceUtil.updateCheckBillCompanyTag(ctx, idList);
        }
        if (!numList.isEmpty()) {
            for (String number3 : numList) {
                msgList.add(number3);
            }
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateCheckBillCompanyTag(Context ctx, List<String> idList) throws SQLException {
        Connection cn = null;
        PreparedStatement ps = null;
        boolean flag = false;
        String sql = "update T_Csl_CheckageBillCompany set FTag = 1 where fid = ?";
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            ps = cn.prepareStatement(sql);
            for (String id : idList) {
                ps.setString(1, id);
                ps.addBatch();
                flag = true;
            }
            if (flag) {
                ps.executeBatch();
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(ps, (Connection)cn);
            throw throwable;
        }
        SQLUtils.cleanup((Statement)ps, (Connection)cn);
    }

    private static String getCheckageBillIdByHeadNumber(Context ctx, String number, int itemType, String companyId, String currencyId, int year, int period) throws BOSException, SQLException {
        String cbcId = null;
        StringBuilder sql = new StringBuilder();
        sql.append("Select cbc.FId cbcId \n");
        sql.append(" From T_Csl_CheckageBillCompany cbc \n");
        sql.append(" Inner join T_Csl_CheckageBill cb On cb.FBillCompanyId = cbc.Fid \n");
        sql.append(" Inner Join T_Csl_CheckageBillHead cbh On cb.FBillHeadId = cbh.Fid \n");
        sql.append(" Where cbh.FNumber = ? and cb.FItemType = ? And cb.FCompanyId = ? And cb.FYear = ? And cb.FPeriod = ? And cb.FCurrencyId = ? \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(number);
        params.add(itemType);
        params.add(companyId);
        params.add(year);
        params.add(period);
        params.add(currencyId);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        if (rowSet.next()) {
            cbcId = rowSet.getString("cbcId");
        }
        return cbcId;
    }

    private static String getCheckageAccountKey(Context ctx, int itemType, CheckageBillDataInfo checkageBillDataInfo) throws EASBizException, BOSException {
        String companyId = checkageBillDataInfo.getCompany().getId().toString();
        String tarCompanyId = checkageBillDataInfo.getTargetCompany().getId().toString();
        String itemNumber = checkageBillDataInfo.getItemNumber();
        int dataElement = checkageBillDataInfo.getDataElement();
        String key = String.valueOf(itemType) + itemNumber + String.valueOf(dataElement) + companyId + tarCompanyId;
        if (checkageBillDataInfo.getAccount() != null) {
            String accountId = checkageBillDataInfo.getAccount().getId().toString();
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            String accountTableId = account.getAccountTableID().getId().toString();
            key = key + accountTableId;
        }
        return key;
    }

    private static void getConfirmedDataMap(Context ctx, boolean isMappingQuery, int itemType, int dataSourceForHandle, String companyId, String currencyId, int year, int period, Map<String, String[]> valueMap, Map<String, String> idMap, Map<String, String> numberMap, List<String> handleWriteKeys, List<String> otherDataSourceKeys) throws Exception {
        StringBuilder sql = new StringBuilder();
        if (isMappingQuery) {
            sql.append(" Select distinct cb.FCompanyId companyId, cb.FTargetCompanyId tarComapnyId, ca.FItemNumber itemNumber, ca.FAccountTableid accountTable, ca.FItemType itemType, ca.FDataElement dataElement, cbh.FNumber number, cb.FDataSource dataSource  \n");
        } else {
            sql.append(" Select distinct cb.FCompanyId companyId, cb.FTargetCompanyId tarComapnyId, ca.FItemNumber itemNumber, ca.FAccountTableid accountTable, ca.FItemType itemType, ca.FDataElement dataElement, cbh.FNumber number, cb.FDebit debit, cb.FCredit credit, cb.FDataSource dataSource, cbc.FId cbcId  \n");
        }
        sql.append(" From T_Csl_CheckageBill cb \n");
        sql.append(" Inner Join T_Csl_CheckageBillCompany cbc On cb.FBillCompanyId = cbc.Fid \n");
        sql.append(" Inner Join T_Csl_CheckageBillHead cbh On cb.FBillHeadId = cbh.Fid \n");
        sql.append(" Inner Join T_Csl_AccountMap accm On cbh.FAccountMapId = accm.FId \n");
        sql.append(" Inner Join T_Csl_AccountAndMapAccount accma On accma.FAccountMapId = accm.FId \n");
        if (isMappingQuery) {
            sql.append(" Inner Join T_Csl_CheckageAccount ca On ca.fid = accma.FCheckAccountId \n");
        } else if (itemType == 0) {
            sql.append(" Inner Join T_Csl_CheckageAccount ca On ca.fid = accma.FCheckAccountId and ca.FItemNumber = cb.FItemNumber and ca.FBalType  = cb.FBalType \n");
        } else if (itemType == 1) {
            sql.append(" Inner Join T_Csl_CheckageAccount ca On ca.fid = accma.FCheckAccountId and ca.FItemNumber = cb.FItemNumber and ca.FDataElement = cb.FDataElement \n");
        }
        sql.append(" Where cbc.FConfirmStatus = ? and cb.FItemType = ? And cb.FCompanyId = ? And cb.FYear = ? And cb.FPeriod = ? And cb.FCurrencyId = ? and accm.FIsFree = ?  \n");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(1);
        params.add(itemType);
        params.add(companyId);
        params.add(year);
        params.add(period);
        params.add(currencyId);
        params.add(0);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        String[] values = null;
        while (rowSet.next()) {
            String credit;
            String debit;
            values = new String[2];
            String mCompanyId = rowSet.getString("companyId");
            String tarCompanyId = rowSet.getString("tarComapnyId");
            String itemNumber = rowSet.getString("itemNumber");
            String accountTable = rowSet.getString("accountTable");
            int mitemType = rowSet.getInt("itemType");
            String dataElement = rowSet.getString("dataElement");
            String number = rowSet.getString("number");
            int dataSource = rowSet.getInt("dataSource");
            String key = mitemType + itemNumber + dataElement + mCompanyId + tarCompanyId;
            if (accountTable != null) {
                key = key + accountTable;
            }
            if (dataSource != dataSourceForHandle && dataSource != 2 && !otherDataSourceKeys.contains(key)) {
                otherDataSourceKeys.add(key);
            }
            if (number != null && !numberMap.containsKey(key)) {
                numberMap.put(key, number);
            }
            if (isMappingQuery || dataSource != dataSourceForHandle && dataSource != 2) continue;
            values[0] = debit = rowSet.getString("debit");
            values[1] = credit = rowSet.getString("credit");
            valueMap.put(key, values);
            String cbcId = rowSet.getString("cbcId");
            if (cbcId != null && !idMap.containsKey(key)) {
                idMap.put(key, cbcId);
            }
            if (dataSource != 2 || (debit == null || !debit.equals("0")) && (credit == null || !credit.equals("0"))) continue;
            handleWriteKeys.add(key);
        }
    }

    public static CheckageAccountCollection getCheckageAccountWithFormula(Context ctx, List<String> companyIds) throws BOSException {
        CheckageAccountCollection checkageAccounts = null;
        Set<String> accountIds = QueryBalanceUtil.getCheckageAccountFromMapping(ctx, companyIds);
        if (accountIds != null && !accountIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", accountIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)1));
            filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0));
            filter.getFilterItems().add(new FilterItemInfo("formula", null, CompareType.NOTEQUALS));
            checkageAccounts = CheckageAccountFactory.getLocalInstance(ctx).getCheckageAccountCollection(view);
        }
        return checkageAccounts;
    }

    private static Set<String> getCheckageAccountFromMapping(Context ctx, List<String> companyIds) throws BOSException {
        HashSet<String> accountIds = new HashSet<String>();
        Set<String> ids = QueryBalanceUtil.getAccountMapId(ctx);
        Set<String> mapIds = QueryBalanceUtil.getAccountMapIds(ctx, companyIds, ids);
        if (mapIds != null && !mapIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("accountMap", mapIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("dataSource", (Object)1));
            view.getSelector().add(new SelectorItemInfo("checkAccount.id"));
            AccountAndMapAccountCollection coll = AccountAndMapAccountFactory.getLocalInstance(ctx).getAccountAndMapAccountCollection(view);
            if (coll != null && !coll.isEmpty()) {
                Iterator it = coll.iterator();
                while (it.hasNext()) {
                    AccountAndMapAccountInfo info = (AccountAndMapAccountInfo)it.next();
                    String accountId = info.getCheckAccount().getId().toString();
                    accountIds.add(accountId);
                }
            }
        }
        return accountIds;
    }

    private static Set<String> getAccountMapIds(Context ctx, List<String> companyIds, Set<String> ids) throws BOSException {
        HashSet<String> mapIds = new HashSet<String>();
        HashSet<String> comIds = new HashSet<String>(companyIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("accountMap", ids, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("checkageCompany.company", comIds, CompareType.INCLUDE));
        view.getSelector().add(new SelectorItemInfo("accountMap.id"));
        AccountMapDispenseCollection coll = AccountMapDispenseFactory.getLocalInstance(ctx).getAccountMapDispenseCollection(view);
        if (coll != null && !coll.isEmpty()) {
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                AccountMapDispenseInfo amDisp = (AccountMapDispenseInfo)it.next();
                String mapId = amDisp.getAccountMap().getId().toString();
                mapIds.add(mapId);
            }
        }
        return mapIds;
    }

    private static Set<String> getAccountMapId(Context ctx) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("itemType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("isFree", (Object)0));
        view.getSelector().add(new SelectorItemInfo("id"));
        AccountMapCollection accountMaps = AccountMapFactory.getLocalInstance(ctx).getAccountMapCollection(view);
        if (accountMaps != null && !accountMaps.isEmpty()) {
            Iterator it = accountMaps.iterator();
            while (it.hasNext()) {
                AccountMapInfo accountMapInfo = (AccountMapInfo)it.next();
                String id = accountMapInfo.getId().toString();
                ids.add(id);
            }
        }
        return ids;
    }

    public static Book initBook(Context ctx, ReportInfo report, boolean includePosted) throws Exception {
        Book book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = book.getSheet(0);
        String sheetName = sheet.getSheetName();
        FunctionManager fm = book.getDeps().getFunctionManager();
        ReportCalculateErrorProvider errorhandler = new ReportCalculateErrorProvider();
        if (errorhandler != null) {
            fm.setErrorProvider(Exception.class, (IErrorProvider)errorhandler);
            ReportCalculateErrorProvider.addErrorProvider(EASBizException.class, (IErrorProvider)errorhandler);
        }
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        if (report.getPeriodType() == null) {
            report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        }
        calcContext.setReportAdapter((IReportPropertyAdapter)new RptReportPropertyAdapter(report));
        calcContext.setErrorProvider((IErrorProvider)errorhandler);
        ReportVariables iv = new ReportVariables();
        VariableEntry includePostedEntry = new VariableEntry("IncludePosted", sheetName, 2, String.valueOf(includePosted), true);
        iv.addOrReplace(includePostedEntry);
        iv.add(new VariableEntry("Check_Permissioin", null, 1, "false", false));
        calcContext.setReportVariables(iv);
        QueryBalanceUtil.registerFormulaToBook(calcContext, fm);
        book.setCalculate(false);
        return book;
    }

    public static void registerFormulaToBook(ICalculateContextProvider context, FunctionManager fm) throws Exception {
        List implClass = FormulaDefinition.getInstance().getImplClass();
        for (int i = 0; i < implClass.size(); ++i) {
            String cname = (String)implClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
        List batchImplClass = FormulaDefinition.getInstance().getBatchImplClass();
        for (int i = 0; i < batchImplClass.size(); ++i) {
            String cname = (String)batchImplClass.get(i);
            Class<?> clazz = Class.forName(cname);
            Object obj = clazz.newInstance();
            if (obj instanceof ICalculator) {
                ((ICalculator)obj).initCalculateContext(context);
            }
            fm.addFunctionProvider(obj, true);
        }
    }
}

