/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.cslworktable.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.DbType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.IItemFieldMapped;
import com.kingdee.eas.fi.gr.cslrpt.ItemFieldMappedFactory;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemCollection;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemFactory;
import com.kingdee.eas.fi.gr.cslrpt.ValueTypeEnum;
import com.kingdee.eas.fi.gr.cslrpt.util.DataElementProvider;
import com.kingdee.eas.fi.newrpt.CslMergeOrgUnitsCollection;
import com.kingdee.eas.fi.newrpt.CslMergeOrgUnitsFactory;
import com.kingdee.eas.fi.newrpt.CslMergeSoluFactory;
import com.kingdee.eas.fi.newrpt.CslMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.CslMergeSoluTemplateCollection;
import com.kingdee.eas.fi.newrpt.CslMergeSoluTemplateFactory;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.app.SQLBuilder;
import com.kingdee.eas.fi.newrpt.cslworktable.CslRptObject;
import com.kingdee.eas.fi.newrpt.cslworktable.app.AbstractCslWorkTableFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.cslworktable.util.CslWorkTableUtil;
import com.kingdee.eas.fi.newrpt.util.TemplateDispenseNewUtil;
import com.kingdee.eas.fi.rpt.ColorSchemeFactory;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.PsSql;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CslWorkTableFacadeControllerBean
extends AbstractCslWorkTableFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.cslworktable.app.CslWorkTableFacadeControllerBean");

    @Override
    protected IObjectCollection _getOrgUnitTree(Context ctx, Map conditions) throws BOSException, EASBizException {
        try {
            if (conditions != null && conditions.containsKey("orgTreeId")) {
                String orgUnitId = (String)conditions.get("orgUnitId");
                String orgUnitNumber = (String)conditions.get("orgUnitNumber");
                String orgTreeId = (String)conditions.get("orgTreeId");
                String longNumber = null;
                if (orgTreeId != null && (orgUnitNumber != null || orgUnitId != null)) {
                    StringBuffer sql = new StringBuffer();
                    sql.append("select longnumber where tree.id='").append(orgTreeId).append("'");
                    if (orgUnitNumber != null) {
                        sql.append(" and unit.number='").append(orgUnitNumber).append("'");
                    } else if (orgUnitId != null) {
                        sql.append(" and unit.id='").append(orgUnitId).append("'");
                    }
                    OrgStructureCollection orgStructureColl = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(sql.toString());
                    if (orgStructureColl != null && orgStructureColl.size() > 0) {
                        longNumber = orgStructureColl.get(0).getLongNumber();
                    } else {
                        return null;
                    }
                }
                if (conditions.containsKey("isForOrgTreeF7")) {
                    if (conditions.containsKey("isUnion") && !Boolean.valueOf((String)conditions.get("isUnion")).booleanValue()) {
                        return this.getOrgTreeForF7(ctx, orgTreeId, longNumber, null, false);
                    }
                    return this.getOrgTreeForF7(ctx, orgTreeId, longNumber, (String)conditions.get("permissionItem"), true);
                }
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("longNumber");
                selector.add("unit.id");
                selector.add("unit.name");
                selector.add("unit.number");
                selector.add("unit.longNumber");
                selector.add("parent.id");
                selector.add("id");
                view.setSelector(selector);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("tree.id", (Object)orgTreeId));
                filter.getFilterItems().add(new FilterItemInfo("unit.isunion", (Object)1));
                if (!StringUtils.isEmpty((String)longNumber)) {
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber));
                    filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                    filter.setMaskString("#0 and #1 and (#2 or #3)");
                } else {
                    filter.setMaskString("#0 and #1 ");
                }
                StringBuffer sql = new StringBuffer();
                sql.append("unit.id in(select forgid FROM t_pm_orgrange");
                sql.append(" where ftype = 10 and fuserid='");
                sql.append(ctx.getCaller().toString());
                sql.append("')");
                FilterInfo orgRangeFilter = new FilterInfo(sql.toString());
                filter.mergeFilter(orgRangeFilter, "and");
                view.setFilter(filter);
                SorterItemCollection sorter = new SorterItemCollection();
                sorter.add(new SorterItemInfo("longNumber"));
                view.setSorter(sorter);
                return OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(view);
            }
        }
        catch (ParserException e) {
            logger.error((Object)"_getOrgUnitTree error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private OrgStructureCollection getOrgTreeForF7(Context ctx, String orgTreeId, String orgUnionLongNumber) throws BOSException, EASBizException {
        return this.getOrgTreeForF7(ctx, orgTreeId, orgUnionLongNumber, null, true);
    }

    private OrgStructureCollection getOrgTreeForF7(Context ctx, String orgTreeId, String orgUnionLongNumber, String permissionItem, boolean isUnion) throws BOSException, EASBizException {
        try {
            boolean isHasPermItem = !StringUtils.isEmpty((String)permissionItem);
            SQLBuilder sql = new SQLBuilder();
            sql.append("select Structure.fid fid,Structure.fparentid fparentid,Structure.flevel flevel,").append(isHasPermItem ? "OrgRange.PermType" : "OrgRange.FType").append(" PermType ");
            sql.append(" from T_ORG_Structure Structure ");
            sql.append(" inner join T_ORG_BaseUnit BaseUnit on BaseUnit.fid=Structure.FUnitId ");
            if (isHasPermItem) {
                sql.append(" left join (select FOrgID,max(FPermType) PermType from (");
                sql.append(" SELECT UserOrgPerm.FOrgID AS FOrgID,UserOrgPerm.FPermType FPermType FROM T_PM_UserOrgPerm UserOrgPerm ").append(" inner join T_PM_PERMITEM item on item.fid=UserOrgPerm.FPermItemID ").append(" WHERE UserOrgPerm.FOwner =?", ctx.getCaller().toString()).append(" AND item.FNumber=? ", permissionItem).append(" AND UserOrgPerm.FPermType <> ").append(30).append(" ").append(" UNION ").append(" SELECT UserRoleOrg.FOrgID AS FOrgID,RolePerm.FPermType FPermType FROM T_PM_RolePerm RolePerm ").append(" INNER JOIN  T_PM_UserRoleOrg UserRoleOrg ON UserRoleOrg.FRoleID = RolePerm.FRoleID ").append(" inner join T_PM_PERMITEM item on item.fid=RolePerm.FPermItemID ").append(" WHERE UserRoleOrg.FUserID =?", ctx.getCaller().toString()).append(" AND item.FNumber =?", permissionItem).append(" AND RolePerm.FPermType <> ").append(30);
                sql.append(") perm group by FOrgID ) OrgRange on OrgRange.FOrgID = BaseUnit.fid ");
            } else {
                sql.append(" left join T_PM_OrgRange OrgRange on OrgRange.FOrgID = BaseUnit.fid  ");
                sql.append(" and OrgRange.FType = 10 and OrgRange.FUserID=? ", ctx.getCaller().toString());
            }
            sql.append(" where Structure.FTreeId = ? ", orgTreeId);
            if (isUnion) {
                sql.append(" and BaseUnit.fisunion=1 ");
            }
            if (!StringUtils.isEmpty((String)orgUnionLongNumber)) {
                sql.append(" and (Structure.flongnumber = '").append(orgUnionLongNumber).append("' ");
                sql.append(" or Structure.flongnumber like '").append(orgUnionLongNumber).append("%' )");
            }
            sql.append(" order by Structure.flongnumber asc ");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.getSQL(), sql.getParams());
            HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
            HashMap<String, String[]> noPermissionMap = new HashMap<String, String[]>();
            HashMap<String, String[]> noRemoveMap = new HashMap<String, String[]>();
            while (rowSet.next()) {
                int permType = rowSet.getInt("PermType");
                if (isHasPermItem && permType > 0 && permType != 20 || !isHasPermItem && permType > 0) {
                    permissionMap.put(rowSet.getString("FID"), new String[]{rowSet.getString("FparentId"), rowSet.getString("flevel")});
                    continue;
                }
                noPermissionMap.put(rowSet.getString("FID"), new String[]{rowSet.getString("FparentId"), rowSet.getString("flevel")});
            }
            for (String[] info : permissionMap.values()) {
                this.handlePermissionOrgUnit(info, permissionMap, noPermissionMap, noRemoveMap);
            }
            StringBuffer idInStr = new StringBuffer();
            this.getInStr(idInStr, permissionMap);
            this.getInStr(idInStr, noRemoveMap);
            if (idInStr.length() > 0) {
                sql.reset();
                sql.append("select id,longNumber,sortCode,level,isLeaf,isValid,parent.id,unit.id,unit.name,unit.number,");
                sql.append("unit.isGrouping,unit.isFreeze,unit.invalidDate,unit.effectDate,unit.longNumber,unit.isAssistantOrg,");
                sql.append("unit.isAdminOrgUnit,unit.isCompanyOrgUnit,unit.isCU,unit.isCostOrgUnit,unit.isHROrgUnit,unit.isProfitOrgUnit,unit.isPurchaseOrgUnit,");
                sql.append("unit.isQualityOrgUnit,unit.isSaleOrgUnit,unit.isStorageOrgUnit,unit.isTransportOrgUnit,unit.isUnion,tree.id,tree.number");
                sql.append(" where id in(").append(idInStr).append(") order by longNumber asc ");
                OrgStructureCollection coll = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(sql.getSQL());
                OrgStructureInfo orgInfo = null;
                if (!noRemoveMap.isEmpty()) {
                    for (int i = 0; i < coll.size(); ++i) {
                        orgInfo = coll.get(i);
                        if (!noRemoveMap.containsKey(orgInfo.getId().toString())) continue;
                        orgInfo.put("isEnable", (Object)false);
                    }
                }
                noPermissionMap.clear();
                permissionMap.clear();
                noRemoveMap.clear();
                return coll;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getOrgTreeForF7 error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    private void getSelector(SelectorItemCollection selector) {
        selector.add("id");
        selector.add("longNumber");
        selector.add("sortCode");
        selector.add("level");
        selector.add("isLeaf");
        selector.add("isValid");
        selector.add("parent.id");
        selector.add("unit.id");
        selector.add("unit.name");
        selector.add("unit.number");
        selector.add("unit.isGrouping");
        selector.add("unit.isFreeze");
        selector.add("unit.invalidDate");
        selector.add("unit.effectDate");
        selector.add("unit.longNumber");
        selector.add("unit.isAssistantOrg");
        selector.add("unit.isAdminOrgUnit");
        selector.add("unit.isCompanyOrgUnit");
        selector.add("unit.isCU");
        selector.add("unit.isCostOrgUnit");
        selector.add("unit.isHROrgUnit");
        selector.add("unit.isProfitOrgUnit");
        selector.add("unit.isPurchaseOrgUnit");
        selector.add("unit.isQualityOrgUnit");
        selector.add("unit.isSaleOrgUnit");
        selector.add("unit.isStorageOrgUnit");
        selector.add("unit.isTransportOrgUnit");
        selector.add("unit.isUnion");
        selector.add("tree.id");
    }

    private void getInStr(StringBuffer idInStr, Map<String, String[]> map) {
        for (String id : map.keySet()) {
            if (idInStr.length() > 0) {
                idInStr.append(",");
            }
            idInStr.append("'").append(id).append("'");
        }
    }

    private void handlePermissionOrgUnit(String[] info, Map<String, String[]> permissionMap, Map<String, String[]> noPermissionMap, Map<String, String[]> noRemoveMap) throws Exception {
        if (!StringUtils.isEmpty((String)info[0]) && !"1".equals(info[1].trim()) && !permissionMap.containsKey(info[0]) && noPermissionMap.containsKey(info[0])) {
            String[] curInfo = noPermissionMap.get(info[0]);
            noRemoveMap.put(info[0], curInfo);
            noPermissionMap.remove(info[0]);
            if (!StringUtils.isEmpty((String)curInfo[0])) {
                this.handlePermissionOrgUnit(curInfo, permissionMap, noPermissionMap, noRemoveMap);
            }
        }
    }

    @Override
    protected List _getReports(Context ctx, Map condition) throws BOSException, EASBizException {
        Boolean[] rptStatus = (Boolean[])condition.get("rptStatus");
        String sortStr = (String)condition.get("sortStr");
        try {
            String orgUnitId = (String)condition.get("orgUnitId");
            Map<Integer, Boolean> permissionValue = CslWorkTableUtil.getPermissionValue(ctx, orgUnitId, (Integer)condition.get("rptType"));
            permissionValue.put(1, true);
            permissionValue.put(2, true);
            permissionValue.put(3, true);
            permissionValue.put(4, true);
            boolean isAllFalse = true;
            for (Integer rptType : permissionValue.keySet()) {
                if (!permissionValue.get(rptType).booleanValue()) continue;
                isAllFalse = false;
                break;
            }
            if (isAllFalse) {
                return null;
            }
            ArrayList params = new ArrayList();
            StringBuffer sql = new StringBuffer();
            if (rptStatus[0].booleanValue() && (Integer)condition.get("rptType") != 4) {
                sql.append(this.getTemplateSql(ctx, condition, params, permissionValue));
            }
            if (rptStatus[1].booleanValue() || rptStatus[2].booleanValue() || rptStatus[3].booleanValue()) {
                if (rptStatus[0].booleanValue() && sql.length() > 0) {
                    sql.append(" union all ");
                }
                sql.append(this.getRptSql(ctx, condition, params, rptStatus, permissionValue));
            }
            if (sql.length() > 0) {
                sql.insert(0, "select * from (").append(") rptsTable order by  ");
                if (!StringUtils.isEmpty((String)sortStr)) {
                    sql.append(sortStr);
                } else {
                    sql.append("isTemplate").append(" ,rptType, templateNumber ,rptVersion asc");
                }
                ArrayList resultList = new ArrayList();
                if (DebugLogger.isDebug) {
                    String dbType = ContextUtil.getDbType((Context)ctx);
                    String tranSql = PsSql.getSqlWithParams((Object)sql, (Object[])params.toArray(), (int)DbType.getValue((String)dbType), (boolean)false);
                    logger.error((Object)("_getReports sql:" + tranSql));
                }
                IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
                IRowSetMetaData rowSetMeta = rs.getRowSetMetaData();
                int columnCount = rowSetMeta.getColumnCount();
                String columnName = null;
                HashMap<String, Object> mapInfo = null;
                while (rs.next()) {
                    mapInfo = new HashMap<String, Object>();
                    for (int i = 1; i <= columnCount; ++i) {
                        columnName = rowSetMeta.getColumnName(i);
                        mapInfo.put(columnName.toLowerCase(), rs.getObject(columnName));
                    }
                    mapInfo.put("select", false);
                    resultList.add(mapInfo);
                }
                return resultList;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"_getReports error", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return null;
    }

    public String getTemplateSql(Context ctx, Map condition, List params, Map<Integer, Boolean> permissionValue) throws Exception {
        String orgTreeId = (String)condition.get("orgTreeId");
        String orgUnitId = (String)condition.get("orgUnitId");
        Integer periodType = (Integer)condition.get("periodType");
        Integer year = (Integer)condition.get("year");
        Integer period = (Integer)condition.get("period");
        Integer rptType = (Integer)condition.get("rptType");
        Set templateGroups = (Set)condition.get("templateGroups");
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append("N'").append((String)condition.get("orgUnitNumber")).append("' as orgUnitNumber,").append("N'").append((String)condition.get("orgUnitName")).append("' as orgUnitName,").append("mainTmp.fnumber as templateNumber, ").append("mainTmp.fname as name,").append("NULL as reportVersion, ").append("N'").append((String)condition.get("currencyName")).append("' as currency, ").append("NULL as convertStatus,").append("mainTmp.fVersionNumber as templateVersion,").append("mainTmp.ftemplateType as rptType, ").append("mainTmp.FPERIODTYPE as periodType,").append("NULL as year, ").append("NULL as period, ").append("NULL as auditStatus,").append("NULL as auditUser,").append("NULL as commitedStatus,").append("NULL as isSupportGroup,").append("updateUser.fname_").append(lang).append(" as updateUser,").append("mainTmp.fLastUpdateTime as updateTime,").append("mainTmp.fdescription as description,").append("createUser.fname_").append(lang).append(" as createUser,").append("mainTmp.FAuditedTime as auditTime,").append("mainTmp.fcreateTime as createTime,").append("mainTmp.fid as id,").append("0 as rptVersion,").append("1 as ").append("isTemplate");
        sql.append(" from t_rpt_template mainTmp ");
        sql.append(" inner join (");
        sql.append("select tmp.fgroup fgroup,max(tmp.fauditedtime) fauditedtime from ").append(TemplateDispenseNewUtil.getDisTable(ctx, orgTreeId)).append(" dispense");
        sql.append(" inner join t_rpt_template tmp on tmp.fid=dispense.fdispensesrcid");
        sql.append(" left join (select rptTmp.fgroup fgroup from t_rpt_template rptTmp ");
        sql.append(" inner join t_csl_cslreport rpt on rpt.ftemplateid=rptTmp.fid");
        sql.append(" left join t_csl_sumrptaddedperporty rptPer on rptPer.freport=rpt.fid");
        sql.append(" where ");
        this.setCslRptWhere(sql, params, condition, "rpt");
        sql.append(" and (rptPer.fissupportgroup=1 or rptPer.fid is null)");
        sql.append(" ) rptTmpGroup on  rptTmpGroup.fgroup = tmp.fgroup ");
        sql.append(" where dispense.forgboundid=? and dispense.fcompanyid=?");
        params.add(orgTreeId);
        params.add(orgUnitId);
        sql.append(" and tmp.ftemplatetype in(").append(CslWorkTableUtil.getRptTypeInStr(rptType, permissionValue, true)).append(")");
        sql.append(" and tmp.fperiodtype=? ");
        params.add(periodType);
        sql.append(" and rptTmpGroup.fgroup is null ");
        sql.append(" group by tmp.fgroup ");
        sql.append(" ) subTmp on subTmp.fgroup=mainTmp.fgroup and subTmp.fauditedtime=mainTmp.fauditedtime");
        sql.append(" left join t_pm_user updateUser on updateUser.fid=mainTmp.fLastUpdateUserID ");
        sql.append(" left join t_pm_user createUser on createUser.fid=mainTmp.fCreatorId ");
        sql.append(" where mainTmp.fisfreezed=0 ");
        if (templateGroups != null && !templateGroups.isEmpty()) {
            sql.append(" and mainTmp.fgroup in (").append(CslRptUtil.collection2String((Collection)templateGroups, (String)",", (boolean)true)).append(")");
        }
        return sql.toString();
    }

    public String getRptSql(Context ctx, Map condition, List params, Boolean[] rptStatus, Map<Integer, Boolean> permissionValue) throws Exception {
        String orgTreeId = (String)condition.get("orgTreeId");
        String orgUnitId = (String)condition.get("orgUnitId");
        Integer periodType = (Integer)condition.get("periodType");
        Integer year = (Integer)condition.get("year");
        Integer period = (Integer)condition.get("period");
        Integer rptType = (Integer)condition.get("rptType");
        String currencyId = (String)condition.get("currencyId");
        Set templateGroups = (Set)condition.get("templateGroups");
        String lang = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append("select unit.fnumber as orgUnitNumber,").append("unit.fname_").append(lang).append(" as orgUnitName,").append("template.fnumber as templateNumber, ").append("rpt.fname as name,").append("concat(isnull(rtrim(to_char(rptVersion.fversionNumber)),'1'), '.0') as reportVersion,").append("currency.fname_").append(lang).append(" as currency, ").append("rpt.fconvertStatus as convertStatus,").append("template.fVersionNumber as templateVersion,").append("rpt.fsourceType as rptType, ").append("rpt.fperiodType as periodType,").append("rpt.fyear as year, ").append("rpt.fperiod as period, ").append("rpt.fauditedstatus as auditStatus,").append("auditUser.fname_").append(lang).append(" as auditUser,").append("rpt.FCommittedStatus as commitedStatus,").append("rptVersion.fisSupportGroup as isSupportGroup,").append("updateUser.fname_").append(lang).append(" as updateUser,").append("rpt.fLastUpdateTime as updateTime,").append("rpt.fdescription as description,").append("createUser.fname_").append(lang).append(" as createUser,").append("rpt.FAuditedTime as auditTime,").append("rpt.fcreateTime as createTime,").append("rpt.fid as id,").append("rptVersion.fversionNumber as rptVersion,").append("0 as ").append("isTemplate");
        sql.append(" from t_csl_cslreport rpt ");
        sql.append(" inner join t_bd_currency currency on currency.fid=rpt.fcurrencyid ");
        sql.append(" inner join t_rpt_template template on rpt.ftemplateid=template.fid ");
        sql.append(" inner join t_org_baseunit unit on unit.fid=rpt.forgunitid ");
        sql.append(" left join t_pm_user auditUser on auditUser.fid=rpt.FAuditorID ");
        sql.append(" left join t_pm_user updateUser on updateUser.fid=rpt.fLastUpdateUserID ");
        sql.append(" left join t_pm_user createUser on createUser.fid=rpt.fCreatorId ");
        sql.append(" left join t_csl_sumrptaddedperporty rptVersion on rpt.fid=rptVersion.freport ");
        sql.append(" where  ");
        this.setCslRptWhere(sql, params, condition, "rpt");
        sql.append(" and rpt.fsourceType in(").append(CslWorkTableUtil.getRptTypeInStr(rptType, permissionValue, false)).append(")");
        String auditedStatusFilter = CslWorkTableUtil.getRptAuditedStatusInStr(rptStatus);
        if (!StringUtils.isEmpty((String)auditedStatusFilter)) {
            sql.append(" and (rpt.fauditedstatus in(").append(auditedStatusFilter).append(")");
        }
        if (rptStatus[3].booleanValue()) {
            if (!StringUtils.isEmpty((String)auditedStatusFilter)) {
                sql.append(" or ");
            } else {
                sql.append(" and ");
            }
            sql.append(" rpt.fCommittedStatus in(2,3)");
        } else {
            sql.append(" and rpt.fCommittedStatus=1");
        }
        if (!StringUtils.isEmpty((String)auditedStatusFilter)) {
            sql.append(") ");
        }
        if (templateGroups != null && !templateGroups.isEmpty()) {
            sql.append(" and template.fgroup in (").append(CslRptUtil.collection2String((Collection)templateGroups, (String)",", (boolean)true)).append(")");
        }
        return sql.toString();
    }

    @Override
    protected IObjectValue _getCslSoluInfo(Context ctx, String soluId) throws BOSException, EASBizException {
        try {
            CslMergeSoluInfo info = CslMergeSoluFactory.getLocalInstance(ctx).getCslMergeSoluInfo("select number,name,periodType,orgTree.id,orgTree.number,currency.id,currency.name where id='" + soluId + "'");
            CslMergeSoluTemplateCollection tmpColl = CslMergeSoluTemplateFactory.getLocalInstance(ctx).getCslMergeSoluTemplateCollection("select template.group where cslMergeSolu.id='" + soluId + "'");
            for (int i = 0; i < tmpColl.size(); ++i) {
                info.addTemplateGroupId(tmpColl.get(i).getTemplate().getGroup());
            }
            CslMergeOrgUnitsCollection coll = CslMergeOrgUnitsFactory.getLocalInstance(ctx).getCslMergeOrgUnitsCollection("select orgUnitNumber where cslMergeSolu.id='" + soluId + "'");
            for (int i = 0; i < coll.size(); ++i) {
                info.addOrgUnitNumber(coll.get(i).getOrgUnitNumber());
            }
            return info;
        }
        catch (Exception e) {
            logger.error((Object)"_getCslSoluInfo error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Map _getCslRptTemplate(Context ctx, List mnsIds, Map condition) throws BOSException, EASBizException {
        try {
            if (mnsIds == null || mnsIds.isEmpty()) {
                return null;
            }
            StringBuffer sql = new StringBuffer();
            ArrayList<Object> params = new ArrayList<Object>();
            String orgTreeId = (String)condition.get("orgTreeId");
            String orgUnitId = (String)condition.get("orgUnitId");
            sql.append("select distinct mnsrpt.fid mnsId,mnsrpt.fname fname,csltmp.fid cslTmpId,cslperp.fid hasCslRpt,mnsperp.fversionnumber versionNumber,mnsperp.fgroup mnsGroup ");
            sql.append(",cslperp.fversionnumber rptVersionNumber,cslperp.fgroup fgroup ");
            sql.append(" from t_csl_cslreport mnsrpt ");
            sql.append(" left join t_csl_sumrptaddedperporty mnsperp on mnsperp.freport=mnsrpt.fid  ");
            sql.append(" inner join t_csl_templetitemlist mnstmpitem on mnstmpitem.ftemplateid=mnsrpt.ftemplateid ");
            sql.append(" inner join t_csl_templetitemlist csltmpitem on csltmpitem.fitemformula=mnstmpitem.fitemformula ");
            sql.append(" inner join t_rpt_template csltmp on csltmp.fid = csltmpitem.ftemplateid  ");
            sql.append(" inner join ( ");
            sql.append(" select tmp.fgroup fgroup,max(tmp.flastupdatetime) flastupdatetime  ");
            sql.append(" from t_rpt_template tmp  ");
            sql.append(" inner join t_csl_templetdispense disp on disp.fdispensesrcid=tmp.fid ");
            sql.append(" where disp.forgboundid=?  and disp.fcompanyid=? ");
            params.add(orgTreeId);
            params.add(orgUnitId);
            sql.append(" and tmp.FTemplateType=? ");
            params.add(5);
            sql.append(" group by tmp.fgroup) csltmp2 on csltmp.fgroup=csltmp2.fgroup and csltmp.flastupdatetime=csltmp2.flastupdatetime  ");
            sql.append(" left join (select * from t_csl_cslreport subRpt where ");
            this.setCslRptWhere(sql, params, condition, "subRpt");
            sql.append(" )cslrpt on cslrpt.ftemplateid=csltmp.fid");
            sql.append(" left join t_csl_sumrptaddedperporty cslperp on cslperp.freport=cslrpt.fid ");
            sql.append(" where  mnsrpt.fid in(").append(CslRptUtil.list2String((List)mnsIds, (String)",", (boolean)true)).append(")");
            sql.append(" and mnsrpt.fperiodtype=csltmp.fperiodtype ");
            if (DebugLogger.isDebug) {
                String dbType = ContextUtil.getDbType((Context)ctx);
                String tranSql = PsSql.getSqlWithParams((Object)sql, (Object[])params.toArray(), (int)DbType.getValue((String)dbType), (boolean)false);
                logger.error((Object)("_getReports sql:" + tranSql));
            }
            IRowSet rs = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            HashMap<String, CslRptObject> result = new HashMap<String, CslRptObject>();
            CslRptObject cslRptObject = null;
            while (rs.next()) {
                cslRptObject = (CslRptObject)result.get(rs.getString("mnsId"));
                if (cslRptObject == null) {
                    cslRptObject = new CslRptObject();
                    cslRptObject.setTemplateId(rs.getString("cslTmpId"));
                    cslRptObject.setRptVersionNumber(rs.getInt("versionNumber"));
                    if (cslRptObject.getRptVersionNumber() == rs.getInt("rptVersionNumber")) {
                        cslRptObject.setHasCurVersionRpt(true);
                    }
                    if (!StringUtils.isEmpty((String)rs.getString("fgroup"))) {
                        cslRptObject.setGroupId(rs.getString("fgroup"));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString("mnsGroup"))) {
                        cslRptObject.setMnsGroupId(rs.getString("mnsGroup"));
                    }
                    cslRptObject.setTemplateName(rs.getString("fname"));
                    result.put(rs.getString("mnsId"), cslRptObject);
                    continue;
                }
                if (!rs.getString("cslTmpId").equals(cslRptObject.getTemplateId()) || cslRptObject.getRptVersionNumber() != rs.getInt("rptVersionNumber")) continue;
                cslRptObject.setHasCurVersionRpt(true);
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"_getCslRptTemplate error.", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void setCslRptWhere(StringBuffer sql, List<Object> params, Map condition, String cslRptTable) throws Exception {
        String orgTreeId = (String)condition.get("orgTreeId");
        String orgUnitId = (String)condition.get("orgUnitId");
        Integer periodType = (Integer)condition.get("periodType");
        Integer year = (Integer)condition.get("year");
        Integer period = (Integer)condition.get("period");
        String currencyId = (String)condition.get("currencyId");
        sql.append(cslRptTable).append(".forgTreeid=? and ").append(cslRptTable).append(".forgunitid=? and ");
        params.add(orgTreeId);
        params.add(orgUnitId);
        sql.append(cslRptTable).append(".fyear=? and ").append(cslRptTable).append(".fperiod=? ");
        params.add(year);
        params.add(period);
        sql.append(" and ").append(cslRptTable).append(".fcurrencyid=? ");
        params.add(currencyId);
        sql.append(" and ").append(cslRptTable).append(".fperiodType=? ");
        params.add(periodType);
        sql.append(" and ").append(cslRptTable).append(".fsourcetype in(2,3,4,11,12,42) ");
    }

    @Override
    public List _getVersionCompareValues(Context ctx, Map condition, IObjectValue cslRptInfo) throws BOSException, EASBizException {
        try {
            CslReportInfo rptInfo = (CslReportInfo)cslRptInfo;
            Map rptId_version = (Map)condition.get("versionRpts");
            List selectItemFormula = (List)condition.get("selectItemFormulas");
            IItemFieldMapped itemFieldMapped = ItemFieldMappedFactory.getLocalInstance((Context)ctx);
            HashMap<String, Set<String>> key_items = new HashMap<String, Set<String>>();
            HashMap<String, ItemFormula> key_itemFormulas = new HashMap<String, ItemFormula>();
            this.initItems(selectItemFormula, key_items, key_itemFormulas);
            Map<String, String> itemNumber_names = this.getItems(ctx, key_items);
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            Set itemNumbers = null;
            Map tables_items = null;
            for (String key : key_items.keySet()) {
                itemNumbers = (Set)key_items.get(key);
                if (itemNumbers.isEmpty()) continue;
                tables_items = itemFieldMapped.getHiberMapInfoByItemNumbers(new ArrayList(itemNumbers));
                result.addAll(this.getItemCompareValue(ctx, tables_items, (ItemFormula)key_itemFormulas.get(key), rptId_version, itemNumber_names, rptInfo));
            }
            key_items.clear();
            key_itemFormulas.clear();
            itemNumber_names.clear();
            if (!result.isEmpty()) {
                Collections.sort(result, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        Object info1 = ((Map)arg0).get("itemNumber");
                        Object info2 = ((Map)arg1).get("itemNumber");
                        return info1.toString().compareTo(info2.toString());
                    }
                });
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)"_getVersionCompareValues error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, String> getItems(Context ctx, Map<String, Set<String>> key_items) throws Exception {
        HashSet<String> itemNumbers = new HashSet<String>();
        for (Set<String> numbers : key_items.values()) {
            for (String number : numbers) {
                itemNumbers.add(number);
            }
        }
        RPTItemCollection coll = RPTItemFactory.getLocalInstance((Context)ctx).getRPTItemCollection("select name,number where number in (" + CslRptUtil.collection2String(itemNumbers, (String)",", (boolean)true) + ")");
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < coll.size(); ++i) {
            result.put(coll.get(i).getNumber(), coll.get(i).getName());
        }
        return result;
    }

    private List<Map<String, Object>> getItemCompareValue(Context ctx, Map tables_items, ItemFormula itemFormula, Map<String, String> rptId_version, Map<String, String> itemNumber_names, CslReportInfo rptInfo) throws Exception {
        StringBuffer sb = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> row = null;
        for (Object tableName : tables_items.keySet()) {
            params.clear();
            sb.setLength(0);
            sb.append(" select ");
            Map item_Field = (Map)tables_items.get(tableName);
            for (Object item : item_Field.keySet()) {
                sb.append("sum(").append(tableName).append(".").append(item_Field.get(item).toString().trim()).append(") as \"").append(item.toString().trim()).append("\",");
            }
            sb.append(" ItemDataBd.freportid reportid ");
            sb.append(" from t_csl_itemdataentry ItemDataBd");
            sb.append(" inner join ").append(tableName).append(" ").append(tableName);
            sb.append(" on ItemDataBd.fid=").append(tableName).append(".fid");
            sb.append(" where FCOMPANYID=?");
            params.add(rptInfo.getOrgUnit().getId().toString());
            sb.append(" and FTARGETCURRENCYID=?");
            params.add(rptInfo.getCurrency().getId().toString());
            sb.append(" and FDATASOURCE=?");
            params.add(rptInfo.getSourceType().getValue());
            sb.append(" and FYEAR=? and FPERIOD=?");
            params.add(rptInfo.getYear());
            params.add(rptInfo.getPeriod());
            sb.append(" and FDATAELEMENT=? ");
            params.add(DataElementProvider.getDataElementInnerValue((Context)ctx, (String)itemFormula.getDataElementNumber()));
            sb.append(" and FVALUETYPE=? ");
            params.add(itemFormula.getValueType());
            sb.append(" and freportid in(").append(CslRptUtil.collection2String(rptId_version.keySet(), (String)",", (boolean)true)).append(")");
            sb.append(" group by ItemDataBd.freportid ");
            if (DebugLogger.isDebug) {
                String dbType = ContextUtil.getDbType((Context)ctx);
                String tranSql = PsSql.getSqlWithParams((Object)sb, (Object[])params.toArray(), (int)DbType.getValue((String)dbType), (boolean)false);
                logger.error((Object)("_getReports sql:" + tranSql));
            }
            IRowSet rs = DbUtil.executeQuery(ctx, sb.toString(), params.toArray());
            HashMap<String, HashMap<String, BigDecimal>> item_version_values = new HashMap<String, HashMap<String, BigDecimal>>();
            Map version_values = null;
            while (rs.next()) {
                for (Object itemNumber : item_Field.keySet()) {
                    version_values = (HashMap<String, BigDecimal>)item_version_values.get(itemNumber.toString());
                    if (version_values == null) {
                        version_values = new HashMap<String, BigDecimal>();
                        item_version_values.put(itemNumber.toString(), (HashMap<String, BigDecimal>)version_values);
                    }
                    version_values.put(rptId_version.get(rs.getString("reportid")), rs.getBigDecimal(itemNumber.toString().trim()));
                }
            }
            for (Object itemNumber : item_Field.keySet()) {
                row = new HashMap<String, Object>();
                row.put("itemNumber", itemNumber);
                row.put("itemName", itemNumber_names.get(itemNumber));
                row.put("dataElement", DataElementProvider.getDataElementName((Context)ctx, (String)itemFormula.getDataElementNumber()));
                row.put("valueType", ValueTypeEnum.getEnum((int)itemFormula.getValueType()).getAlias());
                version_values = (Map)item_version_values.get(itemNumber.toString());
                if (version_values != null) {
                    for (String version : version_values.keySet()) {
                        row.put(version, version_values.get(version));
                    }
                }
                result.add(row);
            }
            item_version_values.clear();
        }
        return result;
    }

    private void initItems(List<ItemFormula> selectItemFormula, Map<String, Set<String>> key_items, Map<String, ItemFormula> key_itemFormulas) throws Exception {
        Set<String> itemNumbers = null;
        String key = null;
        for (ItemFormula itemFormula : selectItemFormula) {
            key = itemFormula.getDataElementNumber() + "_" + itemFormula.getValueType();
            itemNumbers = key_items.get(key);
            if (itemNumbers == null) {
                itemNumbers = new HashSet<String>();
                key_items.put(key, itemNumbers);
                key_itemFormulas.put(key, itemFormula);
            }
            itemNumbers.add(itemFormula.getItemNumber());
        }
    }

    @Override
    protected Map _getCslWorkTabelInitData(Context ctx, Map condition) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        String uiClassPatch = (String)condition.get("uiClassPath");
        if (!StringUtils.isEmpty((String)uiClassPatch)) {
            condition.put("defaultColors", ColorSchemeFactory.getLocalInstance((Context)ctx).getColorSchemesMap(uiClassPatch));
        }
        condition.put("currencyColl", InitDataFacadaFactory.getLocalInstance((Context)ctx).getCurrencyNoGLC());
        return null;
    }
}

