/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.dbcenter.pool;

import com.kingdee.eas.fi.newrpt.dbcenter.DBCenterInfo;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.DBPoolFactory;
import com.kingdee.eas.fi.newrpt.dbcenter.pool.IDBPool;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class DBPoolManager {
    private static final Logger log = Logger.getLogger(DBPoolManager.class);
    private static final Map poolsRegister = new Hashtable();

    public static synchronized Connection getConnection(DBCenterInfo info) throws Exception {
        IDBPool pool = DBPoolManager.getPool(info);
        return pool.getConnection();
    }

    private static synchronized IDBPool getPool(DBCenterInfo info) throws Exception {
        String dbCenterId = info.getId().toString();
        if (poolsRegister.get(dbCenterId) == null) {
            IDBPool pool = DBPoolFactory.createPoolInstance(info);
            poolsRegister.put(dbCenterId, pool);
        }
        return (IDBPool)poolsRegister.get(dbCenterId);
    }
}

