/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeTable;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gr.cslrpt.CSLPropertyAdapter;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.IRPTItemDataService;
import com.kingdee.eas.fi.gr.cslrpt.RPTDate13Util;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTItemDataServiceFactory;
import com.kingdee.eas.fi.gr.cslrpt.UserDefinedRateFactory;
import com.kingdee.eas.fi.gr.cslrpt.elimreport.ElimReportUtils;
import com.kingdee.eas.fi.gr.cslrpt.util.CSLParamUtil;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.IRptIndexFacade;
import com.kingdee.eas.fi.rpt.IndexItemInfo;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptIndexFacadeFactory;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.budget.BgRptReportPropertyAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class ReportCalculatorProvider
implements INeedSheetInfo,
ICalculator {
    public static final String PERMISSION_ACCOUNTVIEW = "bd_account_accountView_view";
    private static final String STR_SEPRATOR = "|";
    public static final String REFM_GROUPREPORT_CODE = "99";
    private IReportCacl reportCacl = null;
    private IRptIndexFacade iRptIndex = null;
    private Context ServerCtx = null;
    private ICompanyOrgUnit comp;
    private IPermission permission;
    ChecFmlParamPermissionUtil pmc = null;
    private String userID;
    Map permissionOrgs = null;
    private IPeriod period = null;
    public static final int DT_CURRENT = 1;
    public static final int DT_START = 2;
    public static final int DT_END = 3;
    private IRPTItemDataService cslRptDataService = null;
    private ICalculateContextProvider context;
    public static final String BASE_CURRENCY = "baseCurrency";
    public static final String REPORT_CURRENCY = "reportCurrency";
    private String sheetName;

    public ReportCalculatorProvider() {
    }

    public ReportCalculatorProvider(Context ctx) {
        this.ServerCtx = ctx;
        this.userID = ctx.get((Object)"rptSchemeUserID") != null ? ctx.get((Object)"rptSchemeUserID").toString() : ctx.getCaller().toString();
    }

    public void initCalculateContext(ICalculateContextProvider context) {
        this.context = context;
        this.ServerCtx = context.getServerContext();
        this.pmc = ChecFmlParamPermissionUtil.getInstance((ICalculateContextProvider)context);
    }

    public void clearContext() {
        this.context = null;
        this.ServerCtx = null;
    }

    public String getCompany() throws BOSException {
        try {
            return this.getOrgName(OrgType.Company.getName());
        }
        catch (EASBizException e) {
            return null;
        }
    }

    public String keyWord(String name) {
        if (name == null || name.length() == 0) {
            return null;
        }
        if (this.context.getReportVariables() != null) {
            return this.context.getReportVariables().getStringValue(name, this.getCalculateSheetName());
        }
        return null;
    }

    public String rptName(Object[] args) {
        return (String)this.context.getReportAdapter().getReportProperty("Report.Name");
    }

    public String getOrgNum(Object[] args) {
        if (this.getReport_SourceType() == 2 || this.getReport_SourceType() == 3 || this.getReport_SourceType() == 4 || this.getReport_SourceType() == 8 || this.getReport_SourceType() == 11 || this.getReport_SourceType() == 12 || ElimReportUtils.isFastMergeReport((RptSrcTypeEnum)RptSrcTypeEnum.getEnum((int)this.getReport_SourceType()))) {
            return this.getOrgUnit_Number();
        }
        if (this.context.getReportAdapter() instanceof CSLPropertyAdapter) {
            return this.getOrgUnit_Number();
        }
        return this.getCompany_Number();
    }

    private String makeValidOrgcode(String orgCode) throws EASBizException, BOSException {
        if (orgCode == null || orgCode.length() < 1) {
            int type = this.getReport_SourceType();
            if (type == 2 || type == 3 || type == 11 || type == 12) {
                orgCode = this.getOrgUnit_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.getCompany_Number();
                }
            } else {
                orgCode = this.getCompany_Number();
                if (StringUtils.isEmpty((String)orgCode)) {
                    orgCode = this.getOrgUnit_Number();
                }
            }
        }
        return orgCode;
    }

    private int getReport_PeriodType() {
        Integer period = (Integer)this.context.getReportAdapter().getReportProperty("PeriodType");
        if (period == null) {
            return -1;
        }
        return period;
    }

    public String AcctName(String orgNumber, String accountNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgNumber)) {
            orgNumber = (String)this.context.getReportAdapter().getReportProperty("Company.Number");
        }
        if (StringUtils.isEmpty((String)orgNumber)) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        this.checkPermision(orgNumber);
        CompanyOrgUnitInfo orgInf = null;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add(new SelectorItemInfo("accountTable.id"));
        ev.getSelector().add(new SelectorItemInfo("id"));
        ev.getSelector().add(new SelectorItemInfo("CU.id"));
        ev.setFilter(new FilterInfo());
        ev.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgNumber));
        CompanyOrgUnitCollection c = null;
        c = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(ev) : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx).getCompanyOrgUnitCollection(ev);
        if (c != null && c.size() > 0) {
            orgInf = c.get(0);
        }
        if (orgInf == null) {
            throw new ReportException(ReportException.ORGNULL);
        }
        AccountTableInfo act = orgInf.getAccountTable();
        if (act == null) {
            throw new ReportException(ReportException.ORGNULLACT);
        }
        EntityViewInfo ev1 = new EntityViewInfo();
        ev1.getSelector().add(new SelectorItemInfo("name"));
        ev1.setFilter(new FilterInfo());
        ev1.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)accountNumber));
        ev1.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)act.getId().toString()));
        ev1.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)orgInf.getId().toString()));
        AccountViewCollection c1 = null;
        c1 = this.ServerCtx == null ? AccountViewFactory.getRemoteInstance().getAccountViewCollection(ev1) : AccountViewFactory.getLocalInstance((Context)this.ServerCtx).getAccountViewCollection(ev1);
        if (c1 == null || c1.size() == 0) {
            throw new ReportException(ReportException.ACCNULL);
        }
        return c1.get(0).getName();
    }

    private String getCompany_Name() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Name");
    }

    private String getCompany_ID() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.ID");
    }

    private String getOrgUnit_Name() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Name");
    }

    private String getCU_Name() {
        return (String)this.context.getReportAdapter().getReportProperty("CU.Name");
    }

    private String getCompany_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("Company.Number");
    }

    private String getOrgUnit_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Number");
    }

    private String getOrgUnit_ID() {
        return (String)this.context.getReportAdapter().getReportProperty("OrgUnit.Id");
    }

    private int getReport_Year() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Year");
    }

    private int getReport_Period() {
        return (Integer)this.context.getReportAdapter().getReportProperty("Report.Period");
    }

    private int getSheet_StartYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("StartYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndYear() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndYear", this.getCalculateSheetName(), 0);
    }

    private int getSheet_StartPeriod() {
        return this.context.getReportVariables().getIntValue("StartPeriod", this.getCalculateSheetName(), 0);
    }

    private int getSheet_EndPeriod() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return 0;
        }
        return vs.getIntValue("EndPeriod", this.getCalculateSheetName(), 0);
    }

    private Date getReport_StartDate() {
        return (Date)this.context.getReportAdapter().getReportProperty("Report_StartDate");
    }

    private Date getReport_EndDate() {
        return (Date)this.context.getReportAdapter().getReportProperty("Report_EndDate");
    }

    private int getReport_SourceType() {
        Integer i = (Integer)this.context.getReportAdapter().getReportProperty("Report.SourceType");
        return i != null ? i : -1;
    }

    private Date getSheet_StartDate() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return null;
        }
        String start = vs.getStringValue("StartDate", this.getCalculateSheetName());
        try {
            Date da = new Date(start);
            return da;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Date getSheet_EndDate() {
        ReportVariables vs = this.context.getReportVariables();
        if (vs == null) {
            return null;
        }
        String start = vs.getStringValue("EndDate", this.getCalculateSheetName());
        try {
            Date da = new Date(start);
            return da;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isSheet_IncludePosted() {
        return this.context.getReportVariables().getBoolValue("IncludePosted", this.getCalculateSheetName(), false);
    }

    private String getOrgTreeNumber() {
        OrgTreeInfo info;
        String orgTreeNumber = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Number");
        if (orgTreeNumber == null && (info = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeNumber = info.getNumber();
        }
        return orgTreeNumber;
    }

    private String getOrgTreeName() {
        OrgTreeInfo info;
        String orgTreeName = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Name");
        if (orgTreeName == null && (info = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTreeName = info.getName();
        }
        return orgTreeName;
    }

    private String getCalculateSheetName() {
        return this.getSheetName();
    }

    private String getCorrect_Currency_Number() {
        String currency = this.context.getReportVariables().getStringValue("Currency", this.getCalculateSheetName());
        if (StringUtils.isEmpty((String)currency)) {
            currency = (String)this.context.getReportAdapter().getReportProperty("Currency.Number");
        }
        return currency;
    }

    private String getSource_Currency_Number() {
        return (String)this.context.getReportAdapter().getReportProperty("SourceCurrency.Number");
    }

    public String getOrgName(String orgType) throws BOSException, EASBizException {
        if (OrgType.getEnum((String)orgType) == OrgType.Admin) {
            if (this.ServerCtx == null) {
                return SysContext.getSysContext().getCurrentAdminUnit().getName();
            }
            return ContextUtil.getCurrentAdminUnit((Context)this.ServerCtx).getName();
        }
        if (this.context.getReportAdapter() instanceof BgRptReportPropertyAdapter) {
            if (StringUtils.isEmpty((String)orgType) || OrgType.getEnum((String)orgType) == OrgType.CostCenter) {
                String costCenter = (String)this.context.getReportAdapter().getReportProperty("BG_ORG_NAME");
                return costCenter;
            }
            if (OrgType.Company.getName().equalsIgnoreCase(orgType)) {
                return this.getCompany_Name();
            }
            return Variant.nullVariant.toString();
        }
        String orgName = null;
        if (StringUtils.isEmpty((String)orgType)) {
            if (!this.isSingRpt(this.getReport_SourceType())) {
                orgName = this.getOrgUnit_Name();
            }
            if (StringUtils.isEmpty(orgName)) {
                orgName = this.getCompany_Name();
            }
            return orgName;
        }
        if (OrgType.getEnum((String)orgType) == OrgType.CostCenter) {
            return Variant.nullVariant.toString();
        }
        if (OrgType.getEnum((String)orgType) == OrgType.UnionDebt) {
            orgName = this.getOrgUnit_Name();
        } else if (OrgType.getEnum((String)orgType) == OrgType.Company) {
            orgName = !this.isSingRpt(this.getReport_SourceType()) ? this.getOrgUnit_Name() : this.getCompany_Name();
        } else {
            if (OrgType.getEnum((String)orgType) == OrgType.ControlUnit) {
                return this.getCU_Name();
            }
            return this.getOrgUnit_Name();
        }
        if (StringUtils.isEmpty((String)orgName)) {
            orgName = this.getCompany_Name();
        }
        return orgName;
    }

    private boolean isSingRpt(int sourceType) {
        return sourceType != 2 && sourceType != 3 && sourceType != 4 && sourceType != 8 && sourceType != 11 && sourceType != 12 && sourceType != 14 && sourceType != 15 && !ElimReportUtils.isFastMergeReport((RptSrcTypeEnum)RptSrcTypeEnum.getEnum((int)sourceType));
    }

    public String getOrgName(String OrgNumber, String orgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)OrgNumber)) {
            return this.getOrgName(orgType);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)OrgNumber));
        view.setFilter(filter);
        FullOrgUnitCollection col = null;
        col = this.ServerCtx == null ? FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitCollection(view) : FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx).getFullOrgUnitCollection(view);
        if (col == null || col.size() < 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51((String)"NoExistsCompany") + OrgNumber});
        }
        FullOrgUnitInfo info = col.get(0);
        String orgName = info.getName();
        if (orgName == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51((String)"Company") + "\"" + OrgNumber + "\"" + RptUtil.getResourceSince51((String)"notSettingLocalName")});
        }
        return orgName;
    }

    public String getOrgEName(String number) throws BOSException, EASBizException {
        Object result = null;
        if (StringUtils.isEmpty((String)number)) {
            number = this.getCompany_Number();
        } else if (StringUtils.isEmpty((String)number)) {
            number = this.ServerCtx == null ? SysContext.getSysContext().getCurrentFIUnit().getNumber() : ContextUtil.getCurrentFIUnit((Context)this.ServerCtx).getNumber();
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("Name"));
        view.getSelector().add(new SelectorItemInfo("englishName"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        view.setFilter(filter);
        IFullOrgUnit ou = null;
        ou = this.ServerCtx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        CoreBaseCollection coll = ou.getCollection(view);
        if (coll == null || coll.size() < 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51((String)"NoExistsCompany") + number});
        }
        FullOrgUnitInfo info = (FullOrgUnitInfo)coll.get(0);
        result = info.getEnglishName() != null ? info.getEnglishName() : info.get("name", LocaleUtils.getLocale((String)"L1"));
        if (result == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{RptUtil.getResourceSince51((String)"Company") + "\"" + number + "\" " + RptUtil.getResourceSince51((String)"SettingEnglishName")});
        }
        return result.toString();
    }

    public String basicCurrency(Object[] args) throws BOSException, EASBizException {
        if (args.length == 2) {
            return this.getBaseOrReportCurrency((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), BASE_CURRENCY);
        }
        if (args.length == 1) {
            return this.getBaseOrReportCurrency((String)((Variant)args[0]).getValue(), null, BASE_CURRENCY);
        }
        return null;
    }

    public String reportCurrency(Object[] args) throws BOSException, EASBizException {
        return this.getBaseOrReportCurrency((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), REPORT_CURRENCY);
    }

    public String getBaseOrReportCurrency(String orgNumber, String getType, String currencyType) throws EASBizException, BOSException {
        CurrencyInfo currency = this.getReportCacl().getBaseOrReportCurrency(orgNumber, this.getReport_SourceType(), this.getOrgUnit_ID(), this.getCompany_Number(), currencyType, this.getRptOrgType());
        if (currency != null) {
            if ("number".equals(getType)) {
                return currency.getNumber();
            }
            return currency.getName();
        }
        return null;
    }

    public BigDecimal exchangeRate(String sourceCurrency, String targetCurrency, String date) throws BOSException, EASBizException {
        String exTableId = this.getBaseExchangeTableid();
        return this.getexchangeRate(sourceCurrency, targetCurrency, date, exTableId);
    }

    public BigDecimal exchangeRate(String sourceCurrency, String targetCurrency, String date, String exchangeRateTableNumber) throws BOSException, EASBizException {
        String exTableId = null;
        if (StringUtils.isEmpty((String)exchangeRateTableNumber)) {
            exTableId = this.getBaseExchangeTableid();
        } else {
            String exTableOql = "select id,number where number='" + exchangeRateTableNumber + "'";
            IExchangeTable exchnageTable = null;
            exchnageTable = this.ServerCtx == null ? ExchangeTableFactory.getRemoteInstance() : ExchangeTableFactory.getLocalInstance((Context)this.ServerCtx);
            DataBaseInfo exchnageTableInfo = null;
            try {
                exchnageTableInfo = exchnageTable.getDataBaseInfo(exTableOql);
            }
            catch (Exception e) {
                String tip = "Exchange rate table with number " + exchangeRateTableNumber + " does not exist in the system";
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{tip});
            }
            if (exchnageTableInfo == null) {
                String tip = "Exchange rate table with number " + exchangeRateTableNumber + " does not exist in the system";
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{tip});
            }
            exTableId = exchnageTableInfo.getId().toString();
        }
        return this.getexchangeRate(sourceCurrency, targetCurrency, date, exTableId);
    }

    private BigDecimal getexchangeRate(String sourceCurrency, String targetCurrency, String date, String exchangeRateTableId) throws BOSException, EASBizException {
        this.checkCurrency(sourceCurrency, targetCurrency);
        Date exchangeDate = this.getExchangeDate(date);
        return this.getReportCacl().exchangeRate(sourceCurrency, targetCurrency, exchangeDate, exchangeRateTableId);
    }

    private Date getExchangeDate(String date) throws ReportException {
        Date exchangeDate = null;
        if (StringUtils.isEmpty((String)date)) {
            exchangeDate = this.getReport_EndDate();
        } else {
            try {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.ServerCtx);
                exchangeDate = format != null ? df.parse(df.format(format.parse(date))) : df.parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
            }
        }
        return exchangeDate;
    }

    private String getBaseExchangeTableid() throws EASBizException, BOSException {
        String companyid = this.getCompany_ID();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyid));
        ExchangeTableInfo xtbl = company.getBaseExchangeTable();
        if (xtbl == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExchangeTableInThisCompany", (Locale)this.ServerCtx.getOriginLocale())});
        }
        String exTableId = xtbl.getId().toString();
        return exTableId;
    }

    private void checkCurrency(String sourceCurrency, String targetCurrency) throws ReportException {
        if (StringUtils.isEmpty((String)sourceCurrency)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedSrcCurrency")});
        }
        if (StringUtils.isEmpty((String)targetCurrency)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedDisCurrency")});
        }
    }

    private void checkDataElement(String dataElement) throws ReportException {
        if (StringUtils.isEmpty((String)dataElement)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedFetchType")});
        }
    }

    public BigDecimal cusExchangeRate(String sourceCurrency, String targetCurrency, String periodType, String dataElement, Integer year, Integer period, String cusExRtTb) throws BOSException, EASBizException {
        this.checkCurrency(sourceCurrency, targetCurrency);
        if (sourceCurrency.equals(targetCurrency)) {
            return null;
        }
        this.checkDataElement(dataElement);
        List times = RPTDate13Util.getRptYearAndPeriodAndDate((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)year, (int)period, (boolean)CslRptUtil.isSupport13Period((Context)this.ServerCtx));
        Date periodLastDate = (Date)times.get(2);
        return UserDefinedRateFactory.getLocalInstance((Context)this.ServerCtx).cusExchangeRate(sourceCurrency, targetCurrency, RptPeriodTypeEnum.getEnum((String)periodType).getValue(), dataElement, periodLastDate, cusExRtTb);
    }

    private Date getperiodLastDate(String periodType, Integer year, Integer period) throws EASBizException, BOSException {
        boolean isSupport13Period = RptUtil.isTrue((Object)CSLParamUtil.getParamValue((Context)this.ServerCtx, null, (String)"GR_CSL_Support13Period"));
        List times = RPTDate13Util.getRptYearAndPeriodAndDate((int)this.getReport_Year(), (int)this.getReport_Period(), (int)RptPeriodTypeEnum.getEnum((String)periodType).getValue(), (int)year, (int)period, (boolean)isSupport13Period);
        Date periodLastDate = (Date)times.get(2);
        return periodLastDate;
    }

    public String stdCurNative(String orgNumber, String getType) throws BOSException, EASBizException {
        if (orgNumber == null || orgNumber.length() <= 0) {
            orgNumber = this.getCompany_Number();
        }
        CurrencyInfo currency = this.getReportCacl().getStdCurrency(orgNumber);
        if ("number".equals(getType)) {
            return currency.getNumber();
        }
        return currency.getName();
    }

    public String rptDate(String dateFormat) throws BOSException, EASBizException {
        return this.getDateImp(dateFormat, 1, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String rptSheetDate(String dateType, String dateFormat, String sheetName) throws BOSException, EASBizException {
        String currentSheetName = this.getSheetName();
        if (StringUtils.isEmpty((String)dateType)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedDateType")});
        }
        if (StringUtils.isEmpty((String)dateFormat)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedDateFormat")});
        }
        if (!StringUtils.isEmpty((String)sheetName)) {
            VariableEntry v = this.context.getReportVariables().get("StartYear", sheetName);
            if (v == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"thisSheetNameNotExist")});
            }
            this.setSheetName(sheetName);
        }
        Date date = null;
        boolean isStartDate = "startDate".equals(dateType);
        if (this.getReport_PeriodType() == 1) {
            if (isStartDate) {
                String startDate = this.context.getReportVariables().getStringValue("StartDate", this.getSheetName());
                if (!StringUtils.isEmpty((String)startDate)) return startDate;
                int[] start = RPTDateUtil.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_StartYear(), (int)0);
                date = RPTDateUtil.getPeriodFirstDate((int)start[0], (int)start[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
            } else {
                String endDate = this.context.getReportVariables().getStringValue("EndDate", this.getSheetName());
                if (!StringUtils.isEmpty((String)endDate)) return endDate;
                int[] end = RPTDateUtil.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_EndYear(), (int)0);
                date = RPTDateUtil.getPeriodLastDate((int)end[0], (int)end[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
            }
        } else if (this.getReport_PeriodType() == 2) {
            if (isStartDate) {
                int[] start = RPTDateUtil.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_StartYear(), (int)this.getSheet_StartPeriod());
                date = RPTDateUtil.getPeriodFirstDate((int)start[0], (int)start[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
            } else {
                int[] end = RPTDateUtil.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_EndYear(), (int)this.getSheet_EndPeriod());
                date = RPTDateUtil.getPeriodLastDate((int)end[0], (int)end[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
            }
        } else {
            boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)this.ServerCtx);
            date = FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)isMergeByFiscalPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType())) ? this.getSheetDate(isStartDate, isMergeByFiscalPeriod) : this.getSheetDate(isStartDate);
            if (date == null) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"thisYearAndPeriodNotExist")});
            }
        }
        this.setSheetName(currentSheetName);
        dateFormat = dateFormat.toLowerCase().replace('m', 'M');
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(date);
    }

    private Date getSheetDate(boolean isStartDate, boolean isMergeByFiscalPeriod) throws BOSException, EASBizException, UuidException {
        int[] result;
        PeriodCollection periods = null;
        if (CslRptUtil.isCslRpt((int)this.getReport_SourceType())) {
            OrgTreeInfo orgTreeInfo = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO");
            periods = FiscalPeriodHelper.getPeriodCollection((Context)this.ServerCtx, (OrgTreeInfo)orgTreeInfo);
        } else if (!StringUtils.isEmpty((String)this.getCompany_ID())) {
            periods = FiscalPeriodHelper.getPeriodCollection((Context)this.ServerCtx, (String)this.getCompany_ID());
        }
        if (periods == null) {
            return this.getSheetDate(isStartDate);
        }
        if (isStartDate) {
            result = FiscalPeriodHelper.getRptYearAndPeriod((PeriodCollection)periods, (int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_StartYear(), (int)this.getSheet_StartPeriod(), (boolean)isMergeByFiscalPeriod);
            return FiscalPeriodHelper.getPeriodFirstDate((int)result[0], (int)result[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()), (PeriodCollection)periods, (boolean)isMergeByFiscalPeriod);
        }
        result = FiscalPeriodHelper.getRptYearAndPeriod((PeriodCollection)periods, (int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_EndYear(), (int)this.getSheet_EndPeriod(), (boolean)isMergeByFiscalPeriod);
        return FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periods, (int)result[0], (int)result[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()), (boolean)isMergeByFiscalPeriod);
    }

    private Date getSheetDate(boolean isStartDate) throws BOSException, EASBizException, UuidException {
        boolean isSupport13Period = CslRptUtil.isSupport13Period((Context)this.ServerCtx);
        int[] start = RPTDate13Util.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_StartYear(), (int)this.getSheet_StartPeriod(), (boolean)isSupport13Period);
        if (!(isStartDate || this.getSheet_EndYear() <= 0 && this.getSheet_EndPeriod() <= 0)) {
            int[] end = RPTDateUtil.getRptYearAndPeriod((int)this.getReport_Year(), (int)this.getReport_Period(), (int)this.getReport_PeriodType(), (int)this.getSheet_EndYear(), (int)this.getSheet_EndPeriod());
            return RPTDateUtil.getPeriodLastDate((int)end[0], (int)end[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
        }
        ICompanyOrgUnit c = CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        PeriodTypeInfo periodTypeInfo = c.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getCompany_ID()))).getAccountPeriodType();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this.ServerCtx);
        PeriodInfo periodInfo = null;
        switch (this.getReport_PeriodType()) {
            case 3: {
                periodInfo = iPeriod.getPeriodInfo(start[0], start[1], periodTypeInfo);
                if (periodInfo != null) {
                    if (isSupport13Period && this.getReport_Period() == 13) {
                        return RPTDate13Util.getPeriodLastDate((int)start[0], (int)start[1], (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
                    }
                    return isStartDate ? periodInfo.getBeginDate() : periodInfo.getEndDate();
                }
                return null;
            }
            case 4: {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)periodTypeInfo.getId().toString(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("periodYear", (Object)new Integer(start[0]), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("periodQuarter", (Object)new Integer(start[1]), CompareType.EQUALS));
                evi.setFilter(filter);
                PeriodCollection periods = iPeriod.getPeriodCollection(evi);
                if (periods.size() > 0) {
                    int period = 0;
                    int max = periods.get(0).getPeriodNumber();
                    int min = periods.get(0).getPeriodNumber();
                    for (int i = 1; i < periods.size(); ++i) {
                        period = periods.get(i).getPeriodNumber();
                        if (max < period) {
                            max = period;
                            continue;
                        }
                        if (min <= period) continue;
                        min = period;
                    }
                    if (isStartDate) {
                        return iPeriod.getPeriodInfo(start[0], min, periodTypeInfo).getBeginDate();
                    }
                    return iPeriod.getPeriodInfo(start[0], max, periodTypeInfo).getEndDate();
                }
                return null;
            }
            case 5: {
                int n = start[1] = isStartDate ? start[1] * 6 - 5 : start[1] * 6;
                if (start[1] == 12) {
                    periodInfo = iPeriod.getPeriodInfo(start[0], 13, periodTypeInfo);
                }
                if (periodInfo == null && (periodInfo = iPeriod.getPeriodInfo(start[0], start[1], periodTypeInfo)) != null) {
                    return isStartDate ? periodInfo.getBeginDate() : periodInfo.getEndDate();
                }
                return null;
            }
            case 6: {
                Calendar calendar = Calendar.getInstance();
                if (isStartDate) {
                    calendar.set(start[0], 0, 1);
                    return calendar.getTime();
                }
                calendar.set(start[0], 11, 31);
                return calendar.getTime();
            }
        }
        return null;
    }

    public String getCurrency(Object[] args) throws BOSException, EASBizException {
        if (args.length == 0) {
            return this.getCurrencyNavite(null);
        }
        if (args.length == 1) {
            return this.getCurrencyNavite((String)((Variant)args[0]).getValue());
        }
        return null;
    }

    public String getCurrencyNavite(String getType) throws BOSException, EASBizException {
        String currency_Number = this.getCorrect_Currency_Number();
        if ("number".equals(getType)) {
            return currency_Number;
        }
        ICurrency iCurrency = null;
        iCurrency = this.ServerCtx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)this.ServerCtx);
        String oSql = "select name where number='" + currency_Number + "'";
        CurrencyCollection col = iCurrency.getCurrencyCollection(oSql);
        String currencyName = null;
        if (col != null && col.size() > 0) {
            currencyName = col.get(0).getName();
        }
        return currencyName;
    }

    public String getOrgTree(Object[] args) throws BOSException, EASBizException {
        OrgTreeInfo info;
        String orgTree = (String)this.context.getReportAdapter().getReportProperty("CSLReport_OrgTree_Name");
        if (orgTree == null && (info = (OrgTreeInfo)this.context.getServerContext().get((Object)"KEY_ORGTREE_INFO")) != null) {
            orgTree = info.getName();
        }
        return orgTree;
    }

    public BigDecimal Dholding(String shareHolderNumber, String investeeCompanyNumber, String date) throws BOSException, EASBizException {
        Date changeDate = null;
        if (StringUtils.isEmpty((String)shareHolderNumber)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedInvestCompany")});
        }
        if (StringUtils.isEmpty((String)investeeCompanyNumber)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51((String)"NeedBeInvestedCompany")});
        }
        if (StringUtils.isEmpty((String)date)) {
            changeDate = this.getReport_EndDate();
        } else {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                DateFormat format = CslRptUtil.getNationalDateFormat((Context)this.ServerCtx);
                changeDate = format != null ? dateFormat.parse(dateFormat.format(format.parse(date))) : dateFormat.parse(date);
            }
            catch (ParseException e) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
            }
        }
        return this.getReportCacl().Dholding(shareHolderNumber, investeeCompanyNumber, changeDate);
    }

    public void checkPermision(String org) throws EASBizException, BOSException {
        if (this.pmc == null) {
            return;
        }
        this.pmc.checkCompanyPermision(org);
    }

    private Map getUserPermissionOrgs() throws BOSException {
        if (this.permissionOrgs != null) {
            return this.permissionOrgs;
        }
        Map fullOrgs = new HashMap();
        try {
            fullOrgs = this.getPermission().getAuthorizedOrgs((IObjectPK)new ObjectUuidPK(this.userID), OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("number"));
        evi.setFilter(new FilterInfo());
        Iterator iterator = ((HashMap)fullOrgs).keySet().iterator();
        StringBuffer mask = new StringBuffer();
        int index = 0;
        while (iterator.hasNext()) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)iterator.next().toString(), CompareType.EQUALS));
            if (index == 0) {
                mask.append("#" + index++);
                continue;
            }
            mask.append(" or #" + index++);
        }
        evi.getFilter().setMaskString(mask.toString());
        ICompanyOrgUnit company = null;
        company = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        CompanyOrgUnitCollection coms = company.getCompanyOrgUnitCollection(evi);
        this.permissionOrgs = new HashMap();
        this.permissionOrgs.put("", null);
        int n = coms.size();
        for (int i = 0; i < n; ++i) {
            this.permissionOrgs.put(coms.get(i).getNumber().toUpperCase(), new FunctionPermission(coms.get(i).getId()));
        }
        return this.permissionOrgs;
    }

    public String getCurrentUser() {
        String res = null;
        res = (String)this.context.getReportAdapter().getReportProperty("Creater.Name");
        return res;
    }

    public String getStartDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 2, true);
    }

    public String getCurrentDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 1, false);
    }

    public String getEndDate(String pattern) throws BOSException, EASBizException {
        return this.getDateImp(pattern, 3, true);
    }

    private String getDateImp(String dateFormat, int type, boolean byPeriodType) throws BOSException, EASBizException {
        Date rptDate = null;
        if ("PERIOD".equalsIgnoreCase(dateFormat)) {
            return "" + this.getReport_Period();
        }
        switch (type) {
            case 2: {
                rptDate = this.getReport_StartDate();
                if (rptDate != null) break;
                rptDate = RPTDateUtil.getPeriodFirstDate((int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
                break;
            }
            case 1: {
                rptDate = this.getReport_EndDate();
                if (rptDate == null) {
                    rptDate = RPTDateUtil.getPeriodLastDate((int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
                }
                dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                String result = sdf.format(rptDate);
                return result;
            }
            default: {
                rptDate = RPTDateUtil.getPeriodLastDate((int)this.getReport_Year(), (int)this.getReport_Period(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)this.getReport_PeriodType()));
                dateFormat = dateFormat.toLowerCase().replace('m', 'M');
                SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
                String result = sdf.format(rptDate);
                return result;
            }
        }
        if (byPeriodType) {
            dateFormat = dateFormat.toLowerCase().replace('m', 'M');
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
            String result = sdf.format(rptDate);
            return result;
        }
        if (rptDate == null) {
            return "";
        }
        int year = 0;
        int month = 0;
        year = this.getSheet_EndYear();
        month = this.getSheet_EndPeriod();
        if (year == 0) {
            year = this.getReport_Year();
        }
        if (month == 0) {
            month = this.getReport_Period();
        }
        if (dateFormat.equalsIgnoreCase("YYYY")) {
            return String.valueOf(year);
        }
        if (dateFormat.equalsIgnoreCase("MM")) {
            return String.valueOf(month);
        }
        if (dateFormat.equalsIgnoreCase("YYYY-MM")) {
            return String.valueOf(year) + "-" + String.valueOf(month);
        }
        if (this.getReport_Period() > 0 && this.getReport_Period() != 1 && this.getReport_Period() != 2) {
            if (this.getReport_SourceType() == 2 || this.getReport_SourceType() == 3 || this.getReport_SourceType() == 4 || ElimReportUtils.isFastMergeReport((RptSrcTypeEnum)RptSrcTypeEnum.getEnum((int)this.getReport_SourceType()))) {
                rptDate = this.getReport_EndDate();
            } else {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("AccountPeriodType"));
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getComp().getValue((IObjectPK)new ObjectUuidPK(this.getCompany_ID()), selector);
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("PeriodYear", (Object)new Integer(year)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodNumber", (Object)new Integer(month)));
                filter.getFilterItems().add(new FilterItemInfo("PeriodType", (Object)company.getAccountPeriodType().getId().toString()));
                evi.setFilter(filter);
                PeriodCollection periods = this.getPeriod().getPeriodCollection(evi);
                if (periods.size() > 0) {
                    rptDate = periods.get(0).getEndDate();
                }
            }
        }
        Timestamp time = new Timestamp(rptDate.getTime());
        String strdate = time.toString();
        return strdate.substring(0, 10);
    }

    public String rptIndex(String fiOrgUnit, String indexNumber, int startYear, int startPeriod, int endYear, int endPeriod, String currency, int rptSrcType) throws BOSException, EASBizException {
        if (indexNumber == null || indexNumber.trim().length() == 0) {
            return "";
        }
        if (fiOrgUnit == null || fiOrgUnit.length() <= 0) {
            fiOrgUnit = this.getCompany_Number();
        }
        if (startYear <= 0) {
            startYear = (this.getSheet_StartYear() == 0 ? this.getReport_Year() : this.getSheet_StartYear()) + startYear;
        }
        if (startPeriod <= 0 && (startPeriod = (this.getSheet_StartPeriod() == 0 ? this.getReport_Period() : this.getSheet_StartPeriod()) + startPeriod) <= 0) {
            startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)this.getCompany_ID());
        }
        if (endYear <= 0) {
            endYear = (this.getSheet_EndYear() == 0 ? this.getReport_Year() : this.getSheet_EndYear()) + endYear;
        }
        if (endPeriod <= 0 && (endPeriod = (this.getSheet_EndPeriod() == 0 ? this.getReport_Period() : this.getSheet_EndPeriod()) + endPeriod) <= 0) {
            --endYear;
            endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)this.getCompany_ID());
        }
        if (currency == null || currency.length() <= 0) {
            currency = this.getCorrect_Currency_Number();
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filters = filterInfo.getFilterItems();
        filters.add(new FilterItemInfo("startYear", (Object)new Integer(startYear), CompareType.GREATER_EQUALS));
        filters.add(new FilterItemInfo("endYear", (Object)new Integer(endYear), CompareType.LESS_EQUALS));
        filters.add(new FilterItemInfo("startPeriod", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
        filters.add(new FilterItemInfo("endPeriod", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
        filters.add(new FilterItemInfo("currency.number", (Object)currency));
        filters.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
        filters.add(new FilterItemInfo("sourceType", (Object)new Integer(rptSrcType)));
        filters.add(new FilterItemInfo("indexItem.number", (Object)indexNumber));
        String indexValue = this.getIRptIndex().getLatestIndexData(filterInfo);
        if (indexValue != null) {
            return indexValue;
        }
        return "";
    }

    public IObjectCollection rptIndexExt(String fiOrgUnit, String indexNumber, int startYear, int startPeriod, int endYear, int endPeriod, String currency, int rptSrcType) throws BOSException, EASBizException {
        IndexItemInfo indexItemInfo;
        if (indexNumber == null || indexNumber.trim().length() == 0) {
            return null;
        }
        if (fiOrgUnit == null || fiOrgUnit.length() <= 0) {
            fiOrgUnit = this.getCompany_Number();
        }
        if (startYear <= 0) {
            startYear = (this.getSheet_StartYear() == 0 ? this.getReport_Year() : this.getSheet_StartYear()) + startYear;
        }
        if (startPeriod <= 0 && (startPeriod = (this.getSheet_StartPeriod() == 0 ? this.getReport_Period() : this.getSheet_StartPeriod()) + startPeriod) <= 0) {
            startPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)(--startYear), (String)this.getCompany_ID());
        }
        if (endYear <= 0) {
            endYear = (this.getSheet_EndYear() == 0 ? this.getReport_Year() : this.getSheet_EndYear()) + endYear;
        }
        if (endPeriod <= 0 && (endPeriod = (this.getSheet_EndPeriod() == 0 ? this.getReport_Period() : this.getSheet_EndPeriod()) + endPeriod) <= 0) {
            --endYear;
            endPeriod += PeriodUtils.getMaxPeriodNumber(null, (int)startYear, (String)this.getCompany_ID());
        }
        if (currency == null || currency.length() <= 0) {
            currency = this.getCorrect_Currency_Number();
        }
        if ((indexItemInfo = this.getIRptIndex().getLatestIndexItem(fiOrgUnit, indexNumber, rptSrcType)) != null) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filters = filterInfo.getFilterItems();
            filters.add(new FilterItemInfo("startYear", (Object)new Integer(startYear), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endYear", (Object)new Integer(endYear), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("startPeriod", (Object)new Integer(startPeriod), CompareType.GREATER_EQUALS));
            filters.add(new FilterItemInfo("endPeriod", (Object)new Integer(endPeriod), CompareType.LESS_EQUALS));
            filters.add(new FilterItemInfo("currency.number", (Object)currency));
            filters.add(new FilterItemInfo("company.number", (Object)fiOrgUnit));
            filters.add(new FilterItemInfo("sourceType", (Object)new Integer(rptSrcType)));
            filters.add(new FilterItemInfo("indexItem.id", (Object)indexItemInfo.getId().toString()));
            IObjectCollection indexValue = this.getIRptIndex().getLatestIndexDataExt(filterInfo);
            if (indexValue != null) {
                return indexValue;
            }
        }
        return null;
    }

    private static String parseAcctFormula(String formula, String company, int startYear, int startPeriod, int endYear, int endPeriod, String currency) {
        try {
            ArrayList<String> formulas = new ArrayList<String>();
            String _formula = formula.trim().substring(1);
            StringTokenizer st = new StringTokenizer(_formula, "+");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (!s.startsWith("Acct(")) {
                    return formula;
                }
                FormulaHint formulaHint = TableToolkit.parseFormula((String)s);
                String[] params = formulaHint.getParams();
                String result = "Acct(\"" + company + "\",\"" + params[1] + "\",\"" + params[2] + "\",\"" + startYear + "\",\"" + startPeriod + "\",\"" + endYear + "\",\"" + endPeriod + "\",\"" + currency + "\")";
                formulas.add(result);
            }
            if (formulas.size() > 0) {
                StringBuffer ret = new StringBuffer();
                int size = formulas.size();
                for (int i = 0; i < size - 1; ++i) {
                    ret.append(formulas.get(i) + "+");
                }
                return "=" + ret.toString() + formulas.get(formulas.size() - 1);
            }
        }
        catch (Exception e) {
            return formula;
        }
        return formula;
    }

    public int DAY360(Object[] args) {
        if (args.length == 2) {
            return this.DAY360Native((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), false);
        }
        if (args.length == 3) {
            return this.DAY360Native((String)((Variant)args[0]).getValue(), (String)((Variant)args[1]).getValue(), (Boolean)((Variant)args[2]).getValue());
        }
        return 0;
    }

    private int DAY360Native(String starts, String ends, boolean method) {
        Date start = (Date)this.getDate(starts).clone();
        Date end = (Date)this.getDate(ends).clone();
        if (method) {
            if (start.getDate() == 31) {
                start.setDate(30);
            }
            if (end.getDate() == 31) {
                end.setDate(30);
            }
        } else {
            if (start.getDate() == 31) {
                start.setDate(30);
            }
            if (end.getDate() == 31) {
                if (start.getDate() < 30) {
                    GregorianCalendar c = new GregorianCalendar();
                    c.setTime(end);
                    c.add(5, 1);
                    end = c.getTime();
                } else {
                    end.setDate(30);
                }
            }
        }
        boolean flag = false;
        GregorianCalendar larger = new GregorianCalendar();
        GregorianCalendar small = new GregorianCalendar();
        if (start.getTime() > end.getTime()) {
            flag = false;
            larger.setTime(start);
            small.setTime(end);
        } else {
            flag = true;
            larger.setTime(end);
            small.setTime(start);
        }
        int days = 0;
        if (larger.get(5) >= small.get(5)) {
            days += larger.get(5) - small.get(5);
        } else {
            days += 30 + larger.get(5) - small.get(5);
            larger.add(2, -1);
        }
        if (larger.get(2) >= small.get(2)) {
            days += (larger.get(2) - small.get(2)) * 30;
        } else {
            days += (12 + larger.get(2) - small.get(2)) * 30;
            larger.add(1, -1);
        }
        return flag ? days : (days += (larger.get(1) - small.get(1)) * 12 * 30) * -1;
    }

    private Date getDate(String endData) {
        if (endData == null || endData.trim().length() <= 0) {
            Date date = null;
            date = this.getReport_EndDate();
            if (date == null) {
                Calendar cal = Calendar.getInstance();
                cal.set(10, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                date = cal.getTime();
            }
            return date;
        }
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int year = 0;
        int mouth = 0;
        int day = 0;
        int i = 0;
        StringTokenizer tok = new StringTokenizer(endData, "-");
        while (tok.hasMoreElements()) {
            String intv = (String)tok.nextElement();
            switch (++i) {
                case 1: {
                    year = Integer.parseInt(intv);
                    cal.set(1, year);
                    break;
                }
                case 2: {
                    mouth = Integer.parseInt(intv);
                    cal.set(2, mouth - 1);
                    break;
                }
                case 3: {
                    day = Integer.parseInt(intv);
                    cal.set(5, day);
                }
            }
        }
        return cal.getTime();
    }

    private void hasAccountPermission(String companyNumber) throws BOSException, EASBizException {
        if (!this.checkFunctionPermission(companyNumber, PERMISSION_ACCOUNTVIEW)) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"ACCOUNT_CALCULATE_PERMISSION_ERROR"));
        }
    }

    private boolean checkFunctionPermission(String companyNumber, String permissionItem) throws BOSException, EASBizException {
        FunctionPermission p = (FunctionPermission)this.getUserPermissionOrgs().get(companyNumber.toUpperCase());
        if (p != null) {
            Boolean perm = (Boolean)p.permissionItems.get(permissionItem);
            if (perm != null) {
                return perm;
            }
            try {
                this.getPermission().checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.userID), p.companyId, permissionItem);
                p.permissionItems.put(permissionItem, Boolean.TRUE);
                return true;
            }
            catch (EASBizException e) {
                p.permissionItems.put(permissionItem, Boolean.FALSE);
                return false;
            }
        }
        return false;
    }

    private ICompanyOrgUnit getComp() throws BOSException {
        if (this.comp == null) {
            this.comp = this.ServerCtx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.comp;
    }

    private IRPTItemDataService getCslRptDataService() throws BOSException {
        if (this.cslRptDataService == null) {
            this.cslRptDataService = this.ServerCtx == null ? RPTItemDataServiceFactory.getRemoteInstance() : RPTItemDataServiceFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.cslRptDataService;
    }

    private IRptIndexFacade getIRptIndex() throws BOSException {
        if (this.iRptIndex == null) {
            this.iRptIndex = this.ServerCtx == null ? RptIndexFacadeFactory.getRemoteInstance() : RptIndexFacadeFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.iRptIndex;
    }

    private IPeriod getPeriod() throws BOSException {
        if (this.period == null) {
            this.period = this.ServerCtx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.period;
    }

    private IPermission getPermission() throws BOSException {
        if (this.permission == null) {
            this.permission = this.ServerCtx == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.permission;
    }

    private IReportCacl getReportCacl() throws BOSException {
        if (this.reportCacl == null) {
            this.reportCacl = this.ServerCtx == null ? ReportCaclFactory.getRemoteInstance() : ReportCaclFactory.getLocalInstance((Context)this.ServerCtx);
        }
        return this.reportCacl;
    }

    public String GetCreator(Object[] args) throws BOSException, EASBizException {
        String creator = (String)this.context.getReportAdapter().getReportProperty("Creater.Name");
        if (creator == null && this.context.getServerContext() != null) {
            creator = ContextUtil.getCurrentUserInfo((Context)this.context.getServerContext()).getName();
        }
        return creator;
    }

    public String getCurrentOrg(String returnType) throws EASBizException, BOSException {
        IFullOrgUnit ibf = this.ServerCtx == null ? FullOrgUnitFactory.getRemoteInstance() : FullOrgUnitFactory.getLocalInstance((Context)this.ServerCtx);
        String returnVal = "";
        if (this.context.getReportAdapter().getReportProperty("BG_ORG_ID") != null) {
            String orgid = (String)this.context.getReportAdapter().getReportProperty("BG_ORG_ID");
            String oql = "select name ,number where id = '" + orgid + "'";
            FullOrgUnitCollection col = ibf.getFullOrgUnitCollection(oql);
            FullOrgUnitInfo info = col.get(0);
            if (returnType.equals("Name")) {
                returnVal = info.getName();
            } else if (returnType.equals("Number")) {
                returnVal = info.getNumber();
            }
        }
        return returnVal;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Object RV(String v_name) {
        return this.context.getReportVariables().getStringValue(v_name, null);
    }

    public Object SV(String v_name) {
        return this.SV(v_name, null);
    }

    public Object SV(String v_name, String sheet) {
        if (StringUtils.isEmpty((String)sheet)) {
            sheet = this.getSheetName();
        }
        return this.context.getReportVariables().getStringValue(v_name, sheet);
    }

    public OrgType getRptOrgType() {
        if (this.context == null || this.context.getReportAdapter() == null) {
            return OrgType.Company;
        }
        OrgType rptOrgType = (OrgType)this.context.getReportAdapter().getReportProperty("orgType");
        if (rptOrgType == null) {
            rptOrgType = OrgType.Company;
        }
        return rptOrgType;
    }

    private class FunctionPermission {
        IObjectPK companyId = null;
        Map permissionItems = new HashMap(2);

        FunctionPermission(BOSUuid id) {
            this.companyId = new ObjectUuidPK(id);
        }
    }
}

