/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.formulasolu.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.app.CSLServerHelper;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluCalcHelp;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseCollection;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluDispenseInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluInfo;
import com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluItemListFactory;
import com.kingdee.eas.fi.newrpt.formulasolu.app.AbstractFormulaSoluControllerBean;
import com.kingdee.eas.fi.rpt.AuditedStatusEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.TemplateFactory;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VersionStatusEnum;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaSoluControllerBean
extends AbstractFormulaSoluControllerBean {
    private static final long serialVersionUID = -4522554913340554561L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.formulasolu.app.FormulaSoluControllerBean");

    @Override
    protected void _saveFormulaSoluInfo(Context ctx, List obj) throws BOSException {
        if (obj == null || obj.size() == 0) {
            return;
        }
        FormulaSoluInfo soluInfo = (FormulaSoluInfo)obj.get(0);
        try {
            this.addnew(ctx, soluInfo);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void _deleteFormulaSoluInfo(Context ctx, List obj) throws BOSException {
        if (obj == null || obj.size() == 0) {
            return;
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FormulaSoluInfo info = this.getFormulaSoluInfo(ctx, pk);
        this.delete_log(ctx, (IObjectValue)info);
        FormulaSoluItemListFactory.getLocalInstance(ctx).delete("where FormulaSolu = '" + pk.toString() + "'");
        super._delete(ctx, pk);
    }

    @Override
    protected Map _getFormulaMapByOrg(Context ctx, String orgId, String templateGroupId) throws BOSException, EASBizException {
        StringBuffer selectSql = new StringBuffer("select solu.fid soluId,solu.fdata soluData,itemList.FSheetId sheetId, itemList.FItemFormula itemF,itemList.Fformula formula \n");
        selectSql.append("from T_CSL_FormulaSoluItemList itemList \n");
        selectSql.append("join T_CSL_FormulaSolu solu on solu.fid=itemList.FformulaSoluID \n");
        selectSql.append("join T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid \n");
        selectSql.append("join t_org_baseunit org on org.fid=dispense.FCompanyId \n");
        selectSql.append("where org.fid=? \n");
        selectSql.append("and solu.FTemplateGroupId=?");
        IRowSet rows = DbUtil.executeQuery(ctx, selectSql.toString(), new Object[]{orgId, templateGroupId});
        HashMap<String, Object> formulaMap = new HashMap<String, Object>();
        HashMap<String, String> sheetFormulaMap = null;
        try {
            while (rows.next()) {
                String sheetId = rows.getString("sheetId");
                sheetFormulaMap = (HashMap<String, String>)formulaMap.get(sheetId);
                if (sheetFormulaMap == null) {
                    sheetFormulaMap = new HashMap<String, String>();
                    formulaMap.put(sheetId, sheetFormulaMap);
                }
                sheetFormulaMap.put(rows.getString("itemF"), rows.getString("formula"));
                if (formulaMap.get("soluId") != null) continue;
                formulaMap.put("soluId", rows.getString("soluId"));
                formulaMap.put("soluBook", rows.getBlob("soluData"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"formula solution get Formula Map By Org error:", (Throwable)e);
        }
        return formulaMap;
    }

    @Override
    protected boolean _templateExists(Context ctx, String templateId) throws BOSException, EASBizException {
        String sql = "select fid from t_rpt_template where fid =?";
        IRowSet row = DbUtil.executeQuery(ctx, sql, new Object[]{templateId});
        try {
            if (row.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"formula solution get template error:", (Throwable)e);
        }
        return false;
    }

    @Override
    protected String _version(Context ctx, String soluId, boolean isAutoUpdate) throws BOSException, EASBizException {
        FormulaSoluInfo formulaSolu = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluInfo((IObjectPK)new ObjectUuidPK(soluId));
        formulaSolu.setCreateTime(null);
        formulaSolu.setCreator(null);
        formulaSolu.setLastUpdateTime(null);
        formulaSolu.setLastUpdateUser(null);
        formulaSolu.setIsAutoUpdate(isAutoUpdate);
        String versionNumber = formulaSolu.getVersionNumber();
        formulaSolu.setVersionStatus(VersionStatusEnum.CREATED);
        formulaSolu.setVersionNumber(this.getNewVersionNumber(versionNumber));
        formulaSolu.setAuditor(null);
        formulaSolu.setAuditedStatus(AuditedStatusEnum.UNAUDITED);
        TemplateInfo newTpl = this.getNewestTemplate(ctx, formulaSolu);
        String newTplId = newTpl.getId().toString();
        if (!newTplId.equals(formulaSolu.getTemplateId())) {
            formulaSolu.setTemplateId(newTplId);
            try {
                Book newBook = newTpl.getBook();
                Book currBook = formulaSolu.getBook();
                FormulaSoluCalcHelp.getInstance().replaceCellContentBySolu(newBook, currBook);
                FormulaSoluCalcHelp.getInstance().synCheckSolution(newBook, currBook);
                formulaSolu.setData(IOHelper.packBook((Book)newBook));
            }
            catch (Exception e) {
                logger.error((Object)"_version: ", (Throwable)e);
            }
        }
        formulaSolu.setId(null);
        IObjectPK newPK = this.submit(ctx, (CoreBaseInfo)formulaSolu);
        return newPK.toString();
    }

    private TemplateInfo getNewestTemplate(Context ctx, FormulaSoluInfo formulaSolu) throws EASBizException, BOSException {
        String tplGroupId = formulaSolu.getTemplateGroupId();
        TemplateInfo template = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo("select id,data where group = '" + tplGroupId + "' and versionStatus = " + 1 + " and isFreezed = 0 and isK3Tpl = 0 and groupTemplate is null");
        return template;
    }

    private String getNewVersionNumber(String versionNumber) {
        String[] numbers = versionNumber.split("\\.");
        String left = numbers[0];
        String right = numbers[1];
        int r = Integer.valueOf(right);
        String newVersion = left + "." + ++r;
        return newVersion;
    }

    @Override
    protected void _audit(Context ctx, String soluId) throws BOSException, EASBizException {
        FormulaSoluInfo formulaSolu = this.getFormulaSoluInfo(ctx, "select id,name,isAutoUpdate,number,versionNumber,templateGroupId where id = '" + soluId + "'");
        StringBuffer sql = new StringBuffer();
        ArrayList<Object> params = new ArrayList<Object>();
        String versionNumber = formulaSolu.getVersionNumber();
        this.audit_log(ctx, (IObjectValue)formulaSolu);
        if (!versionNumber.equals("1.1")) {
            String preVerId = this.getPreVersionFormulaSolu(ctx, formulaSolu);
            if (preVerId == null) {
                return;
            }
            sql = new StringBuffer();
            params = new ArrayList();
            sql.append("Update T_CSL_FormulaSolu \n");
            sql.append(" SET FVersionStatus = ?     \n");
            params.add(new Integer(2));
            sql.append(" WHERE FID = ?              \n");
            params.add(preVerId);
            DbUtil.execute(ctx, sql.toString(), params.toArray());
            this.addNewDispenseRecord(ctx, soluId, preVerId);
            boolean isAutoUpdate = formulaSolu.isIsAutoUpdate();
            if (isAutoUpdate) {
                ArrayList<String> soluIds = new ArrayList<String>();
                soluIds.add(soluId);
                FormulaSoluDispenseFactory.getLocalInstance(ctx).updateSubCompanyTemplate(soluIds, null);
            }
        }
        sql.append("Update T_CSL_FormulaSolu \n");
        sql.append(" SET FAuditedStatus = ?     \n");
        params.add(new Integer(2));
        sql.append(" ,FAuditorId = ?            \n");
        params.add(ctx.getCaller().toString());
        sql.append(" ,FVersionStatus = ?        \n");
        params.add(new Integer(1));
        sql.append(" WHERE FID = ?              \n");
        params.add(soluId);
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    private void addNewDispenseRecord(Context ctx, String soluId, String preVerId) throws BOSException, EASBizException {
        FormulaSoluDispenseCollection formulaSoluDispenses = FormulaSoluDispenseFactory.getLocalInstance(ctx).getFormulaSoluDispenseCollection("where formulaSoluId = '" + preVerId + "'");
        if (formulaSoluDispenses != null && !formulaSoluDispenses.isEmpty()) {
            Iterator it = formulaSoluDispenses.iterator();
            CoreBaseCollection newDispenses = new CoreBaseCollection();
            while (it.hasNext()) {
                FormulaSoluDispenseInfo formulaSoluDispenseInfo = (FormulaSoluDispenseInfo)it.next();
                FormulaSoluDispenseInfo newFormulaSoluDispenseInfo = (FormulaSoluDispenseInfo)formulaSoluDispenseInfo.clone();
                newFormulaSoluDispenseInfo.setFormulaSoluId(soluId);
                newFormulaSoluDispenseInfo.setId(null);
                newFormulaSoluDispenseInfo.setCreator(null);
                newFormulaSoluDispenseInfo.setCreateTime(null);
                newFormulaSoluDispenseInfo.setLastUpdateUser(null);
                newFormulaSoluDispenseInfo.setLastUpdateTime(null);
                newDispenses.add((CoreBaseInfo)newFormulaSoluDispenseInfo);
            }
            FormulaSoluDispenseFactory.getLocalInstance(ctx).submit(newDispenses);
        }
    }

    private String getPreVersionFormulaSolu(Context ctx, FormulaSoluInfo formulaSolu) throws BOSException, EASBizException {
        FormulaSoluInfo formulaSoluInfo = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluInfo("select id where number = '" + formulaSolu.getNumber() + "' and versionStatus = " + 1 + "");
        if (formulaSoluInfo != null && !formulaSoluInfo.isEmpty()) {
            return formulaSoluInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _unAudit(Context ctx, String soluId) throws BOSException, EASBizException {
        FormulaSoluInfo formulaSolu = this.getFormulaSoluInfo(ctx, (IObjectPK)new ObjectUuidPK(soluId));
        String versionNumber = formulaSolu.getVersionNumber();
        if (this.isDispensed(ctx, soluId)) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.formulasolu.FormulaSoluResource", (String)"39_soluHasDisoensed", (Locale)ctx.getLocale())});
        }
        StringBuffer sql = null;
        ArrayList<Object> params = new ArrayList<Object>();
        String oldSoluId = null;
        this.unaudit_log(ctx, (IObjectValue)formulaSolu);
        if (!"1.1".equals(versionNumber) && (oldSoluId = this.getPreVerByVerNum(ctx, formulaSolu)) != null) {
            sql = new StringBuffer();
            params.clear();
            sql.append(" UPDATE T_CSL_FormulaSolu SET      \n");
            sql.append("     FVersionStatus = ?         \n");
            params.add(new Integer(1));
            sql.append(" WHERE FID = ?                  \n");
            params.add(oldSoluId);
            DbUtil.execute(ctx, sql.toString(), params.toArray());
        }
        sql = new StringBuffer();
        params = new ArrayList();
        sql.append(" UPDATE T_CSL_FormulaSolu      \n");
        sql.append(" SET FAuditedStatus = ?     \n");
        params.add(new Integer(1));
        sql.append(" ,FAuditorID = ?            \n");
        params.add(ctx.getCaller().toString());
        sql.append(" ,FVersionStatus = ?        \n");
        params.add(oldSoluId != null ? new Integer(0) : new Integer(1));
        sql.append(" WHERE FID = ?              \n");
        params.add(soluId);
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    private String getPreVerByVerNum(Context ctx, FormulaSoluInfo formulaSolu) throws EASBizException, BOSException {
        int rv;
        String number = formulaSolu.getNumber();
        String verNum = formulaSolu.getVersionNumber();
        String[] nums = verNum.split("\\.");
        String l = nums[0];
        String r = nums[1];
        int lv = Integer.valueOf(l) - 1;
        if (lv > 0) {
            String ver = lv + "." + r;
            boolean isExist = FormulaSoluFactory.getLocalInstance(ctx).exists("select id where number = '" + number + "' and versionNumber = '" + ver + "'");
            if (isExist) {
                FormulaSoluInfo fomulaSoLu = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluInfo("select id where number = '" + number + "' and versionNumber = '" + ver + "'");
                return fomulaSoLu.getId().toString();
            }
        }
        if ((rv = Integer.valueOf(r) - 1) > 0) {
            String ver = l + "." + rv;
            boolean isExist = FormulaSoluFactory.getLocalInstance(ctx).exists("select id where number = '" + number + "' and versionNumber = '" + ver + "'");
            if (isExist) {
                FormulaSoluInfo fomulaSoLu = FormulaSoluFactory.getLocalInstance(ctx).getFormulaSoluInfo("select id where number = '" + number + "' and versionNumber = '" + ver + "'");
                return fomulaSoLu.getId().toString();
            }
        }
        return null;
    }

    private boolean isDispensed(Context ctx, String soluId) throws EASBizException, BOSException {
        return FormulaSoluDispenseFactory.getLocalInstance(ctx).exists("where formulaSoluId = '" + soluId + "'");
    }

    @Override
    protected Map _getSoluByTplGroupIdAndComId(Context ctx, String tplGroupId, String companyId) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select solu.fid soluId \n");
        sql.append(" From T_CSL_FormulaSolu solu \n");
        sql.append(" Inner Join T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid \n");
        sql.append(" Where solu.FTemplateGroupId = ? And dispense.FCompanyId = ? And solu.FVersionStatus = ? ");
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(tplGroupId);
        params.add(companyId);
        params.add(1);
        IRowSet rows = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            while (rows.next()) {
                String soluId = rows.getString("soluId");
                map.put("soluId", soluId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getSoluByTplGroupIdAndComId: ", (Throwable)e);
        }
        return map;
    }

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FormulaSoluInfo info = (FormulaSoluInfo)model;
        this.add_log(ctx, (IObjectValue)info);
        super._addnew(ctx, pk, model);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FormulaSoluInfo info = (FormulaSoluInfo)model;
        this.add_log(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FormulaSoluInfo info = (FormulaSoluInfo)model;
        this.update_log(ctx, (IObjectValue)info);
        super._update(ctx, pk, model);
    }

    @Override
    protected void _updatePartial(Context ctx, IObjectValue model, SelectorItemCollection selector) throws BOSException, EASBizException {
        FormulaSoluInfo info = (FormulaSoluInfo)model;
        super._updatePartial(ctx, model, selector);
    }

    @Override
    protected void _add_log(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _update_log(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _delete_log(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _audit_log(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _unaudit_log(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected Map _getHisGradeTmpl(Context ctx, String gradeTmplId) throws BOSException, EASBizException {
        HashMap<String, IRowSet> returnMap = new HashMap<String, IRowSet>();
        CSLServerHelper helper = new CSLServerHelper(ctx);
        String ext = helper.getFieldNameExtend().toString();
        TemplateInfo tmpl = TemplateFactory.getLocalInstance((Context)ctx).getTemplateInfo((IObjectPK)new ObjectUuidPK(gradeTmplId));
        String companyId = tmpl.getCompany().getId().toString();
        String tmplGroupId = tmpl.getGroup();
        Map fomulaSoluMap = this._getSoluByTplGroupIdAndComId(ctx, tmplGroupId, companyId);
        if (fomulaSoluMap != null && !fomulaSoluMap.isEmpty()) {
            String soluId = (String)fomulaSoluMap.get("soluId");
            StringBuffer sql = new StringBuffer();
            sql.append(" select * from (");
            sql.append(" Select solu.FID as \"Template.id\",solu.FTEMPLATENUMBER AS \"Template.number\",solu.FTEMPLATENAME as \"Template.name\",solu.FPERIODTYPE as \"Template.periodType\", \n");
            sql.append(" solu.FTEMPLATETYPE as \"Template.templateType\",cre.FNAME" + ext + " as \"creator.name\",solu.FLASTUPDATETIME as \"lastUpdateTime\",auditor.FNAME" + ext + " as \"auditor.name\", \n");
            sql.append(" solu.FVERSIONNUMBER as \"versionNumber\" \n");
            sql.append(" From T_Csl_FormulaSolu solu \n");
            sql.append(" Inner Join T_Csl_FormulaSoluDispense dispense on dispense.FFormulaSoluId=solu.fid \n");
            sql.append(" Inner join T_PM_User cre On solu.FCREATORID = cre.FId \n");
            sql.append(" Inner join T_PM_User auditor On solu.FAUDITORID = auditor.fid \n");
            sql.append(" Where solu.fNumber = (select FNumber From T_Csl_FormulaSolu where fId = ?) AND solu.FVersionStatus != ? And dispense.FCompanyId = ? \n");
            sql.append(" union all \n");
            sql.append(" Select tmpl.FID as \"Template.id\",tmpl.fnumber as \"Template.number\",tmpl.FNAME as \"Template.name\",tmpl.FPERIODTYPE as \"Template.periodType\", \n");
            sql.append(" tmpl.FTEMPLATETYPE as \"Template.templateType\",cre.FNAME" + ext + " as \"creator.name\",tmpl.FLASTUPDATETIME as \"lastUpdateTime\",auditor.FNAME" + ext + " as \"auditor.name\", \n");
            sql.append(" tmpl.FVERSIONNUMBER as \"versionNumber\" \n");
            sql.append(" From T_RPT_Template tmpl \n");
            sql.append(" Inner join T_PM_User cre On tmpl.FCREATORID = cre.FId \n");
            sql.append(" Inner join T_PM_User auditor On tmpl.FAUDITORID = auditor.fid \n");
            sql.append(" Where tmpl.FGROUP = ? And tmpl.FTEMPLATESOURCE = ? And tmpl.fid != ? AND tmpl.FVersionStatus != ? And tmpl.FCompanyId = ? ");
            sql.append(") t \n");
            sql.append(" Order by t.\"versionNumber\" ");
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(soluId);
            params.add(0);
            params.add(companyId);
            params.add(tmplGroupId);
            params.add(1);
            params.add(gradeTmplId);
            params.add(0);
            params.add(companyId);
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
            returnMap.put("rowSet", rowSet);
        }
        return returnMap;
    }
}

