/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.image;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.excel.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.streamwork.cuba.util.ByteArrayOutputStream;
import com.kingdee.eas.fi.newrpt.image.EmbedImage;
import com.kingdee.eas.fi.newrpt.image.ImageFilter;
import com.kingdee.eas.fi.newrpt.image.ImagePreview;
import com.kingdee.eas.fi.newrpt.image.ImageUtil;
import com.kingdee.eas.fi.newrpt.image.StaticURLImageModel;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class InsertPicWizzard
implements ISpreadWizzard {
    private static String resource = "com.kingdee.eas.fi.newrpt.client.designer.DesignerResource";
    private SpreadContext _ext;
    private KDFileChooser fileChooser;

    public InsertPicWizzard(SpreadContext ext) {
        this._ext = ext;
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser = new KDFileChooser();
        this.fileChooser.setApproveButtonText(EASResource.getString((String)resource, (String)"Insert"));
        ImageFilter picFilter = new ImageFilter();
        this.fileChooser.addChoosableFileFilter((FileFilter)picFilter);
        this.fileChooser.setFileFilter((FileFilter)picFilter);
        this.fileChooser.setAccessory((JComponent)new ImagePreview((JFileChooser)this.fileChooser));
    }

    public void commit() {
    }

    public boolean isModal() {
        return true;
    }

    public boolean prepare() {
        return true;
    }

    public void show() {
        URL url;
        int mark = this.fileChooser.showOpenDialog((Component)this._ext);
        if (mark != 0) {
            return;
        }
        try {
            url = this.selectedURL();
        }
        catch (MalformedURLException e) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"71_InsertPicWizzard");
            MessageDialog.show((Component)this.fileChooser, (Object)MessageFormat.format(msg, e), (String)EASResource.getString((String)resource, (String)"InfoTips"), (int)2);
            return;
        }
        if (!ImageUtil.checkURL(url)) {
            String msg = EASResource.getString((String)"com.kingdee.eas.fi.gr.cslrpt.cslcommon.CSLCOMMONAutoGenerateResource", (String)"72_InsertPicWizzard");
            MessageDialog.show((Component)this.fileChooser, (Object)MessageFormat.format(msg, url.toString()), (String)EASResource.getString((String)resource, (String)"InfoTips"), (int)2);
            return;
        }
        Sheet sheet = this._ext.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        CellBlock block = range.getBounds();
        int x = SheetBaseMath.getColX((Sheet)sheet, (int)block.getCol());
        int y = SheetBaseMath.getRowY((Sheet)sheet, (int)block.getRow());
        EmbedImage embedImage = new EmbedImage(sheet, new StaticURLImageModel(url));
        embedImage.setBounds(x, y, Integer.MAX_VALUE, Integer.MAX_VALUE);
        EmbedhLayer layer = sheet.getEmbedments(true);
        layer.addEmbed((EmbedObject)embedImage);
        layer.selectEmbed((EmbedObject)embedImage, 2);
    }

    private URL selectedURL() throws MalformedURLException {
        File selectedFile = this.fileChooser.getSelectedFile();
        String path = selectedFile.getAbsolutePath();
        try {
            selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            int schemaBegin = path.indexOf("http:");
            String protocal = "http";
            if (schemaBegin < 0) {
                return null;
            }
            path = path.substring(schemaBegin + 6);
            path = path.replace('\\', '/');
            path = protocal + "://" + path;
            return new URL(path);
        }
        return new URL("file:" + File.separator + File.separator + File.separator + path);
    }

    public void setContext(SpreadContext context) {
        this._ext = context;
    }

    private byte[] convertImage2Byte() throws IOException {
        File image = this.fileChooser.getSelectedFile();
        if (!image.exists()) {
            return null;
        }
        BufferedImage bi = ImageIO.read(image);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)baos);
        return baos.toByteArray();
    }
}

