/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.investworkpaper.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.investworkpaper.ITriggerConditionInterface;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.log4j.Logger;

public class TarCompanyCuYearAcqInTree
implements ITriggerConditionInterface {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.investworkpaper.util.TarCompanyCuYearAcqInTree");

    @Override
    public boolean execute(Context ctx, Map params) throws BOSException, EASBizException {
        String orgTreeNumber = (String)params.get("orgTreeNumber");
        String tarCompanyNumreg = (String)params.get("tarCompanyNum");
        int year = (Integer)params.get("year");
        short period = (Short)params.get("period");
        Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)year, (int)period, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        Timestamp lastTime = new Timestamp(periodLastDate.getTime());
        Object[] param = new Object[]{orgTreeNumber, lastTime, lastTime, tarCompanyNumreg};
        try {
            IRowSet rs = DbUtil.executeQuery(ctx, this.getSql(), param);
            if (!rs.next()) {
                return false;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("TarCompanyCuYearAcqInTree_execute_error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        int preYear = year - 1;
        periodLastDate = RPTDateUtil.getPeriodLastDate((int)preYear, (int)12, (RptPeriodTypeEnum)RptPeriodTypeEnum.MONTHLY);
        lastTime = new Timestamp(periodLastDate.getTime());
        param = new Object[]{orgTreeNumber, lastTime, lastTime, tarCompanyNumreg};
        try {
            IRowSet rs = DbUtil.executeQuery(ctx, this.getSql(), param);
            if (!rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("TarCompanyCuYearAcqInTree_execute_error:" + e.getMessage()));
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private String getSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("select top 1 struct.Fid from T_ORG_Structure struct \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("inner join T_ORG_BaseUnit unit on unit.Fid=struct.FUnitId \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\n");
        sql.append("inner join T_ORG_Tree tree on  tree.FId=struct.FTreeId\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t \t\t\t\t\n");
        sql.append("where tree.ftype = 8 and tree.Fnumber = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\n");
        sql.append("and (tree.FSTARTDATE <= ? and (tree.FENDDATE >= ? or tree.FENDDATE is null))\t\t\t\t\t\t\t\t\t\t\t\t\t\t\n");
        sql.append("and unit.Fnumber = ?\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t\t\t  \t  \t         \t\t\t\t\n");
        return sql.toString();
    }
}

