/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.jiuqiInterface.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslReportFactory;
import com.kingdee.eas.fi.gr.cslrpt.CslReportInfo;
import com.kingdee.eas.fi.gr.cslrpt.DynaEnumRptTypeEnum;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.CRResultFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.CRResultInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.ICRResult;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptLogFactory;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptLogInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.RptTypeEnum;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.TransmitStatusEnum;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.app.AbstractRptUplFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.app.CslReportSheetInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.app.ReportItemInfo;
import com.kingdee.eas.fi.newrpt.jiuqiInterface.webservice.SaveMdbInfoServiceLocator;
import com.kingdee.eas.fi.rpt.CommittedStatusEnum;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Logger;

public class RptUplFacadeControllerBean
extends AbstractRptUplFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.app.RptUplFacadeControllerBean");
    private String sourceName;
    private String taskPrefix;
    private String wsAddress;

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _createXmlStr(Context ctx, String cslReportId, String sheetId) throws BOSException, EASBizException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        File directory = new File("..");
        try {
            String filePath = directory.getCanonicalPath() + File.separator + "logs" + File.separator + df.format(new Date()) + "-cslreportLog.txt";
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            StringBuffer xmlStr = new StringBuffer();
            xmlStr.append("<?xml version='1.0' encoding='UTF-8'?>\r\n<data>");
            try (OutputStreamWriter writer = null;){
                Object rptSheetIdList;
                this.setWebService(ctx);
                this.setWSAddress(ctx);
                CslReportSheetInfo cslReportSheet = this.getCslReportSheet(ctx, cslReportId, sheetId);
                boolean isYear = this.isYearReport(ctx, cslReportSheet);
                if (isYear && !cslReportSheet.getPeriod().equals("13")) {
                    throw new EASBizException(new NumericExceptionSubItem("Exception", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.only13Period", (Locale)ctx.getOriginLocale()), cslReportSheet.getRptName())));
                }
                if ("1".equals(cslReportSheet.getDynarptType())) {
                    ArrayList<ReportItemInfo> reportItemList = this.getReportItemList(ctx, cslReportSheet);
                    if (reportItemList == null) {
                        String string = "ignore";
                        return string;
                    }
                    for (ReportItemInfo reportItemInfo : reportItemList) {
                        xmlStr.append("<item><zbcode>" + reportItemInfo.getJqItemNumber() + "</zbcode><zbvalue>" + reportItemInfo.getItemData() + "</zbvalue></item>\r\n");
                    }
                } else {
                    HashMap<String, HashMap<String, ArrayList<ReportItemInfo>>> sheetMap = new HashMap<String, HashMap<String, ArrayList<ReportItemInfo>>>();
                    rptSheetIdList = this.getDynaMergerRptSheet(ctx, cslReportSheet);
                    Iterator<HashMap<String, String>> iterator = ((ArrayList)rptSheetIdList).iterator();
                    while (iterator.hasNext()) {
                        String rptSheetId;
                        HashMap<String, String> rptSheetItem = iterator.next();
                        String rptId = rptSheetItem.get("rptId");
                        HashMap<String, ArrayList<ReportItemInfo>> rptSheetRow = this.getDynaMergerItemList(ctx, rptId, rptSheetId = rptSheetItem.get("sheetId"));
                        if (rptSheetRow == null) {
                            this.writeUplLog(ctx, cslReportSheet, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRepeat", (Locale)ctx.getOriginLocale()), cslReportSheet.getYear(), cslReportSheet.getPeriod(), cslReportSheet.getRptName()));
                            throw new EASBizException(new NumericExceptionSubItem("Exception", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRepeat", (Locale)ctx.getOriginLocale()), cslReportSheet.getYear(), cslReportSheet.getPeriod(), cslReportSheet.getRptName())));
                        }
                        sheetMap.put(rptId + rptSheetId, rptSheetRow);
                    }
                    Iterator sheetIter = sheetMap.entrySet().iterator();
                    int loca = 0;
                    while (sheetIter.hasNext()) {
                        Map.Entry entry = sheetIter.next();
                        String rptSheetId = entry.getKey().toString();
                        HashMap rowMap = (HashMap)entry.getValue();
                        Iterator rowMapIter = rowMap.entrySet().iterator();
                        while (rowMapIter.hasNext()) {
                            String dataRow = "";
                            String beforeDataRow = "";
                            String afterDataRow = "";
                            Map.Entry rowMapIterEntry = rowMapIter.next();
                            String rowNumber = rowMapIterEntry.getKey().toString();
                            ArrayList itemList = (ArrayList)rowMapIterEntry.getValue();
                            logger.info((Object)(rowNumber + "----" + itemList.size()));
                            Iterator itemInfoIter = itemList.iterator();
                            boolean isNullTxt = true;
                            while (itemInfoIter.hasNext()) {
                                ReportItemInfo itemInfo = (ReportItemInfo)itemInfoIter.next();
                                if (itemInfo.getTxtItemData() != null && !"".equals(itemInfo.getTxtItemData())) {
                                    isNullTxt = false;
                                }
                                dataRow = dataRow + "<" + itemInfo.getJqItemNumber() + ">" + itemInfo.getItemData() + "</" + itemInfo.getJqItemNumber() + "><" + itemInfo.getJqTxtItemNumber() + ">" + itemInfo.getTxtItemData() + "</" + itemInfo.getJqTxtItemNumber() + ">";
                                if (isNullTxt) {
                                    logger.info((Object)MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.rowTxtNumberIsNull", (Locale)ctx.getOriginLocale()), rowNumber));
                                    continue;
                                }
                                int locaNew = 0;
                                for (Map.Entry sheetEntry : sheetMap.entrySet()) {
                                    String rptSheetIdNew = sheetEntry.getKey().toString();
                                    if (rptSheetId.equals(rptSheetIdNew)) {
                                        ++locaNew;
                                        continue;
                                    }
                                    HashMap rowMapNew = (HashMap)sheetEntry.getValue();
                                    for (Map.Entry rowMapIterEntryNew : rowMapNew.entrySet()) {
                                        String rowNumberNew = rowMapIterEntryNew.getKey().toString();
                                        if (!rowNumber.equals(rowNumberNew)) continue;
                                        for (ReportItemInfo rItemInfo : itemList) {
                                            if (locaNew < loca) {
                                                beforeDataRow = beforeDataRow + "<" + rItemInfo.getJqItemNumber() + "></" + rItemInfo.getJqItemNumber() + "><" + rItemInfo.getJqTxtItemNumber() + "></" + rItemInfo.getJqTxtItemNumber() + ">";
                                                continue;
                                            }
                                            if (locaNew <= loca) continue;
                                            afterDataRow = afterDataRow + "<" + rItemInfo.getJqItemNumber() + "></" + rItemInfo.getJqItemNumber() + "><" + rItemInfo.getJqTxtItemNumber() + "></" + rItemInfo.getJqTxtItemNumber() + ">";
                                        }
                                    }
                                    ++locaNew;
                                }
                            }
                            if ("".equals(beforeDataRow) && "".equals(dataRow) && "".equals(afterDataRow)) continue;
                            xmlStr.append("<dataRow>" + beforeDataRow + dataRow + afterDataRow + "</dataRow>\r\n");
                        }
                        ++loca;
                    }
                }
                xmlStr.append("</data>\r\n");
                String tempXmlStr = "<?xml version='1.0' encoding='UTF-8'?>\r\n<data></data>\r\n";
                if (xmlStr.toString().equals(tempXmlStr)) {
                    rptSheetIdList = "ignore";
                    return rptSheetIdList;
                }
                SaveMdbInfoServiceLocator service = new SaveMdbInfoServiceLocator();
                service.setSaveMdbInfoEndpointAddress(this.wsAddress);
                logger.info((Object)("xml\n" + xmlStr.toString()));
                try {
                    service.getSaveMdbInfo().saveZbInfo(cslReportSheet.getJqOrgUnitNumber(), cslReportSheet.getJqPeriod(), xmlStr.toString(), this.sourceName, cslReportSheet.getFixFlag(), this.taskPrefix);
                }
                catch (Exception e) {
                    logger.info((Object)MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upFailure", (Locale)ctx.getOriginLocale()), e.toString()));
                    this.writeUplLog(ctx, cslReportSheet, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.webServiceException", (Locale)ctx.getOriginLocale()), cslReportSheet.getYear(), cslReportSheet.getPeriod(), cslReportSheet.getRptNumber(), cslReportSheet.getRptName()));
                    e.printStackTrace();
                    throw new EASBizException(new NumericExceptionSubItem("Exception", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.webServiceException", (Locale)ctx.getOriginLocale()), cslReportSheet.getYear(), cslReportSheet.getPeriod(), cslReportSheet.getRptNumber(), cslReportSheet.getRptName())));
                }
                writer = new FileWriter(filePath, true);
                writer.write(xmlStr.toString());
                writer.flush();
                writer.close();
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return "success";
    }

    private void writeUplLog(Context ctx, CslReportSheetInfo reportSheet, String description) throws EASBizException, BOSException, SQLException {
        RptLogInfo rptLogInfo = new RptLogInfo();
        rptLogInfo.setSerialNo(this.getNewNumber(ctx));
        CslReportInfo reportInfo = CslReportFactory.getLocalInstance((Context)ctx).getCslReportInfo((IObjectPK)new ObjectUuidPK(reportSheet.getRptId()));
        rptLogInfo.setCslReport(reportInfo);
        rptLogInfo.setRptType(DynaEnumRptTypeEnum.getEnum((int)Integer.parseInt(reportSheet.getDynarptType())));
        rptLogInfo.setName(reportSheet.getRptName());
        rptLogInfo.setOperator(ContextUtil.getCurrentUserInfo((Context)ctx));
        rptLogInfo.setEndDate(new Date());
        if (reportSheet.getOrgTreeId() != null) {
            OrgTreeInfo orgTreeInfo = OrgTreeFactory.getLocalInstance((Context)ctx).getOrgTreeInfo((IObjectPK)new ObjectUuidPK(reportSheet.getOrgTreeId()));
            rptLogInfo.setOrgTree(orgTreeInfo);
        }
        FullOrgUnitInfo orgUnitInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(reportSheet.getOrgUnitId()));
        rptLogInfo.setOrgUnit(orgUnitInfo);
        rptLogInfo.setDescription(description);
        RptLogFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)rptLogInfo);
    }

    private BigDecimal getNewNumber(Context ctx) throws SQLException, BOSException {
        String sql = "select isnull(max(FSerialNo+1),1) as newNumber from T_CSL_RptLog";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            return rs.getBigDecimal("newNumber");
        }
        return null;
    }

    private CslReportSheetInfo getCslReportSheet(Context ctx, String cslReportId, String sheetId) throws SQLException, EASBizException, BOSException {
        CslReportSheetInfo reportSheet = new CslReportSheetInfo();
        String sql = "select t2.fnumber,t2.fname_l2,t0.forgtreeid,t0.forgunitid,t1.fnumber as rptNumber,t0.fname as rptName,t0.fyear,t0.fperiod,t0.ftemplateid,t0.fsourceType,t1.fdynarpttype,t1.fperiodtype,t1.ftemplateType,t3.fsheetname from T_CSL_CslReport t0 inner join  T_RPT_Template t1 on t0.ftemplateid=t1.fid inner join  T_ORG_BaseUnit t2 on t0.forgunitid= t2.fid inner join  T_RPT_RPTSHEETPARA t3 on t3.freportid=t1.fid where  t0.fid = '" + cslReportId + "' and t3.fsheetid='" + sheetId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            reportSheet.setOrgUnitNumber(rs.getString("fnumber"));
            String sourceType = rs.getString("fsourceType");
            if (sourceType.equals("3") || sourceType.equals("2") || sourceType.equals("12")) {
                reportSheet.setRptType("20");
            } else if (sourceType.equals("1") || sourceType.equals("4") || sourceType.equals("10") || sourceType.equals("11")) {
                reportSheet.setRptType("10");
            }
            reportSheet.setYear(rs.getString("fyear"));
            reportSheet.setPeriod(rs.getString("fperiod"));
            reportSheet.setRptId(cslReportId);
            reportSheet.setRptNumber(rs.getString("rptNumber"));
            reportSheet.setRptName(rs.getString("rptName"));
            reportSheet.setSheetId(sheetId);
            reportSheet.setSheetName(rs.getString("fsheetName"));
            reportSheet.setOrgUnitId(rs.getString("forgunitid"));
            reportSheet.setOrgTreeId(rs.getString("forgtreeid"));
            reportSheet.setTemplateId(rs.getString("ftemplateid"));
            reportSheet.setDynarptType(rs.getString("fdynarpttype"));
            reportSheet.setFixFlag(rs.getString("fdynarpttype").equals("1") ? "P" : "F");
            reportSheet.setPeriodType(rs.getString("fperiodtype"));
            String jqPeriod = "";
            if (rs.getString("fperiodtype").equals("3")) {
                jqPeriod = rs.getString("fyear") + "Y" + rs.getString("fperiod");
            } else if (rs.getString("fperiodtype").equals("6")) {
                jqPeriod = rs.getString("fyear") + "N1";
            }
            if (rs.getString("fperiod").equals("13")) {
                jqPeriod = rs.getString("fyear") + "N1";
                reportSheet.setPeriodType("6");
            }
            reportSheet.setJqPeriod(jqPeriod);
            String jqOrgNumber = this.getJqOrgUnitNumber(ctx, reportSheet);
            if (jqOrgNumber == null) {
                this.writeUplLog(ctx, reportSheet, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.orgMappingNull", (Locale)ctx.getOriginLocale()), reportSheet.getYear(), reportSheet.getPeriod(), reportSheet.getRptNumber(), reportSheet.getRptName()));
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.orgMappingNull", (Locale)ctx.getOriginLocale()), reportSheet.getYear(), reportSheet.getPeriod(), reportSheet.getRptNumber(), reportSheet.getRptName())));
            }
            reportSheet.setJqOrgUnitNumber(jqOrgNumber);
        }
        return reportSheet;
    }

    private Boolean isYearReport(Context ctx, CslReportSheetInfo reportSheet) throws BOSException, SQLException {
        Boolean isYear = false;
        String sql = "select Frpttype from T_CSL_RptSel where Frptnumber ='" + reportSheet.getRptNumber() + "' and FSheetName ='" + reportSheet.getSheetName() + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next() && "6".equals(rs.getString("Frpttype"))) {
            isYear = true;
        }
        return isYear;
    }

    private ArrayList<HashMap<String, String>> getDynaMergerRptSheet(Context ctx, CslReportSheetInfo reportSheet) throws SQLException, EASBizException, BOSException {
        ArrayList<HashMap<String, String>> reportSheetList = new ArrayList<HashMap<String, String>>();
        String sql = "select FRptNumber,FRptName,FSheetName from T_CSL_RptMap where FJQNumber = (select FJQNumber from T_CSL_RptMap where FRptNumber='" + reportSheet.getRptNumber() + "' and FSheetName='" + reportSheet.getSheetName() + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean isNull = true;
        while (rs.next()) {
            isNull = false;
            HashMap<String, String> map = this.getDynaMergerRptSheetId(ctx, reportSheet, rs.getString("FRptNumber"), rs.getString("FSheetName"));
            if (map.size() == 0) {
                this.writeUplLog(ctx, reportSheet, MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.notRow", (Locale)ctx.getOriginLocale()), rs.getString("FRptNumber"), rs.getString("FRptName"), rs.getString("FSheetName")));
                throw new EASBizException(new NumericExceptionSubItem("SQLException", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.notRow", (Locale)ctx.getOriginLocale()), rs.getString("FRptNumber"), rs.getString("FRptName"), rs.getString("FSheetName"))));
            }
            logger.info((Object)(map.get("rptId") + "=====" + map.get("sheetId")));
            reportSheetList.add(map);
        }
        if (isNull) {
            HashMap<String, String> reportSheetMap = new HashMap<String, String>();
            reportSheetMap.put("rptId", reportSheet.getRptId());
            reportSheetMap.put("sheetId", reportSheet.getSheetId());
            reportSheetList.add(reportSheetMap);
            return reportSheetList;
        }
        return reportSheetList;
    }

    private HashMap<String, String> getDynaMergerRptSheetId(Context ctx, CslReportSheetInfo cslReportSheet, String FRptNumber, String FSheetName) throws SQLException, EASBizException, BOSException {
        HashMap<String, String> reportSheetMap = new HashMap<String, String>();
        String sql = " select t0.fid,t0.fname as rptName,t1.fsheetid,t0.FCommittedStatus ,fsourceType  from T_CSL_CslReport t0 inner join  T_RPT_RPTSHEETPARA t1 on t1.freportid= t0.fid inner join T_RPT_Template t2 on t0.ftemplateid=t2.fid where t2.fnumber='" + FRptNumber + "' and t1.fsheetName='" + FSheetName + "' and t0.forgunitid='" + cslReportSheet.getOrgUnitId() + "' and t0.forgtreeid='" + cslReportSheet.getOrgTreeId() + "' and fyear=" + cslReportSheet.getYear() + " and fperiod=" + cslReportSheet.getPeriod();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            if (3 != rs.getInt("FCommittedStatus")) {
                String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.reportNotcomfire", (Locale)ctx.getOriginLocale()), FRptNumber, rs.getString("rptName"), FSheetName);
                this.writeUplLog(ctx, cslReportSheet, str);
                throw new EASBizException(new NumericExceptionSubItem("SQLException", str));
            }
            reportSheetMap.put("rptId", rs.getString("fid"));
            reportSheetMap.put("sheetId", rs.getString("fsheetid"));
        }
        return reportSheetMap;
    }

    private String getJqOrgUnitNumber(Context ctx, CslReportSheetInfo reportSheet) throws SQLException, EASBizException, BOSException {
        String jqOrgNumber = null;
        String sql = "select FJQNumber from T_CSL_OrgMap where FOrgNumber='" + reportSheet.getOrgUnitNumber() + "' and FRptType=" + reportSheet.getRptType() + " and FRptScheme=" + reportSheet.getPeriodType();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            jqOrgNumber = rs.getString("FJQNumber");
        }
        return jqOrgNumber;
    }

    private ArrayList<ReportItemInfo> getReportItemList(Context ctx, CslReportSheetInfo rptSheet) throws SQLException, EASBizException, BOSException, RemoteException, ServiceException {
        ArrayList<ReportItemInfo> TempletitemList = new ArrayList<ReportItemInfo>();
        String sql = "select t0.fitemnumber,t0.fdataelement,t0.fvaluetype,t2.ftablename,t2.ffieldname,t3.fid ,t6.fname_l2 as dataelementName from t_csl_templetitemList t0 inner join  T_CSL_RptItem t1 on t0.fitemnumber = t1.fnumber inner join T_CSL_ITEMFIELDMAPPED t2 on t2.fitemid=t1.fid inner join T_CSL_ITEMDATAENTRY t3 on t3.fvaluetype = t0.fvaluetype inner join T_CSL_ITEMDATA t4 on t3.fitemdataid=t4.fid inner join T_CSL_CslReport t5 on t5.fid=t4.freportid inner join T_CSL_dataelement t6 on t6.finterseq =  t0.fdataelement where t3.fdataelement = t0.fdataelement and t0.ftemplateid = '" + rptSheet.getTemplateId() + "' and t0.fsheetid = '" + rptSheet.getSheetId() + "' and t5.fid='" + rptSheet.getRptId() + "'";
        SaveMdbInfoServiceLocator service = new SaveMdbInfoServiceLocator();
        service.setSaveMdbInfoEndpointAddress(this.wsAddress);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String itemNumber = rs.getString("fitemnumber");
            HashMap<String, String> jqItem = this.getJqItemMap(ctx, rptSheet.getRptNumber(), itemNumber, rs.getString("dataelementName"));
            logger.info((Object)(itemNumber + " " + jqItem.size()));
            if (jqItem.size() == 0) continue;
            ReportItemInfo reportItemInfo = new ReportItemInfo();
            reportItemInfo.setJqItemNumber(jqItem.get("jqItemNumber"));
            reportItemInfo.setItemNumber(rs.getString("fitemnumber"));
            reportItemInfo.setDataElement(rs.getString("fdataelement"));
            String itemData = this.getItemData(ctx, rs.getString("ffieldname"), rs.getString("ftablename"), rs.getString("fid"));
            int valueType = rs.getInt("fvalueType");
            if (valueType != 1 && valueType != 2 || itemData == null) continue;
            try {
                BigDecimal b = new BigDecimal(itemData);
                if (b.compareTo(BigDecimal.ZERO) == 0) continue;
                int SynFlag = service.getSaveMdbInfo().isSynFlag(rptSheet.getJqOrgUnitNumber(), rptSheet.getJqPeriod(), jqItem.get("jqItemNumber"), this.sourceName, rptSheet.getFixFlag(), this.taskPrefix);
                if (SynFlag == 1) {
                    String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.reportNotcomfire", (Locale)ctx.getOriginLocale()), rptSheet.getYear(), rptSheet.getPeriod(), rptSheet.getRptNumber(), rptSheet.getRptName(), itemNumber, rs.getString("dataelementName"));
                    logger.info((Object)str);
                    return null;
                }
                reportItemInfo.setItemData(itemData);
                TempletitemList.add(reportItemInfo);
            }
            catch (NumberFormatException e) {
                String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.mustNum", (Locale)ctx.getOriginLocale()), rptSheet.getYear(), rptSheet.getPeriod(), rptSheet.getRptNumber(), rptSheet.getRptName(), rs.getString("fitemid"), itemData);
                this.writeUplLog(ctx, rptSheet, str);
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
            }
        }
        return TempletitemList;
    }

    private HashMap<String, String> getJqItemMap(Context ctx, String cslReportNumber, String itemNumber, String dataElement) throws SQLException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "select FJQNumber,FJQTxtNumber from T_CSL_ItemMap where FRptNumber='" + cslReportNumber + "' and FNumber = '" + itemNumber + "' and FDataTypeName='" + dataElement + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            map.put("jqItemNumber", rs.getString("FJQNumber"));
            map.put("jqTxtItemNumber", rs.getString("FJQTxtNumber"));
        }
        return map;
    }

    private String getItemData(Context ctx, String fieldName, String tableName, String itemDataEntryId) throws SQLException, BOSException {
        String itemData = null;
        String sql = "select " + fieldName + " from " + tableName + " where fid = '" + itemDataEntryId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            itemData = rs.getString(1);
        }
        return itemData;
    }

    public HashMap<String, ArrayList<ReportItemInfo>> getDynaMergerItemList(Context ctx, String rptID, String sheetID) throws SQLException, EASBizException, BOSException, RemoteException, ServiceException {
        String sourceType;
        String dynatype = "1";
        IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)("select fsourceType from t_csl_cslreport where fid='" + rptID + "'"));
        if (rs0.next() && ((sourceType = rs0.getString("fsourceType")).equals("3") || sourceType.equals("2") || sourceType.equals("12"))) {
            dynatype = "6";
        }
        String sql = " select  t1.fdynatype,t0.fkeynumber,t0.fitemid,t0.fvaluetype,t0.fvalue,t0.ftextvalue,t0.fdataelement,t0.frow,t3.fname_l2 as dataType from T_CSL_DynaItemDataEntry t0 inner join T_CSL_DynaItemData t1 on t1.fid=t0.fitemdataid inner join t_csl_cslreport t2 on t1.freportid= t2.fid inner join T_CSL_dataelement t3 on t3.finterseq =  t0.fdataelement where t2.fid='" + rptID + "' and t0.fsheetid='" + sheetID + "' and t1.fdynatype = " + dynatype + " order by t0.frow";
        SaveMdbInfoServiceLocator service = new SaveMdbInfoServiceLocator();
        service.setSaveMdbInfoEndpointAddress(this.wsAddress);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowNumber = 0;
        LinkedHashMap<String, ArrayList<ReportItemInfo>> itemMap = new LinkedHashMap<String, ArrayList<ReportItemInfo>>();
        ArrayList<ReportItemInfo> list = new ArrayList<ReportItemInfo>();
        CslReportSheetInfo rptSheet = this.getCslReportSheet(ctx, rptID, sheetID);
        while (rs.next()) {
            String keyNumber;
            ReportItemInfo itemInfo = new ReportItemInfo();
            itemInfo.setItemNumber(rs.getString("fitemid"));
            HashMap<String, String> jqItem = this.getJqItemMap(ctx, rptSheet.getRptNumber(), rs.getString("fitemid"), rs.getString("dataType"));
            if (jqItem.size() == 0 && !rs.isLast()) continue;
            int valueType = rs.getInt("fvaluetype");
            String value = rs.getString("fvalue");
            if (valueType == 1 || valueType == 2) {
                String str;
                if (value != null && !"".equals(value)) {
                    try {
                        int SynFlag = service.getSaveMdbInfo().isSynFlag(rptSheet.getJqOrgUnitNumber(), rptSheet.getJqPeriod(), jqItem.get("jqItemNumber"), this.sourceName, rptSheet.getFixFlag(), this.taskPrefix);
                        if (SynFlag == 1) {
                            str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRepeat", (Locale)ctx.getOriginLocale()), rptSheet.getRptNumber(), rptSheet.getRptName(), rs.getString("fitemid"));
                            logger.info((Object)str);
                            return null;
                        }
                        itemInfo.setJqItemNumber(jqItem.get("jqItemNumber"));
                        itemInfo.setItemData(value);
                    }
                    catch (Exception e) {
                        str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRerpeat2", (Locale)ctx.getOriginLocale()), rptSheet.getYear(), rptSheet.getPeriod(), rptSheet.getRptNumber(), rptSheet.getRptName());
                        String str2 = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.mustNum", (Locale)ctx.getOriginLocale()), rptSheet.getYear(), rptSheet.getPeriod(), rptSheet.getRptNumber(), rptSheet.getRptName(), rs.getString("fitemid"), value);
                        this.writeUplLog(ctx, rptSheet, str);
                        throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str2));
                    }
                } else {
                    int SynFlag = service.getSaveMdbInfo().isSynFlag(rptSheet.getJqOrgUnitNumber(), rptSheet.getJqPeriod(), jqItem.get("jqItemNumber"), this.sourceName, rptSheet.getFixFlag(), this.taskPrefix);
                    if (SynFlag == 1) {
                        str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRepeat", (Locale)ctx.getOriginLocale()), rptSheet.getRptNumber(), rptSheet.getRptName(), rs.getString("fitemid"));
                        logger.info((Object)str);
                        return null;
                    }
                    itemInfo.setJqItemNumber(jqItem.get("jqItemNumber"));
                    itemInfo.setItemData("dataIsNull");
                }
            }
            String textValue = rs.getString("ftextvalue");
            if (valueType == 3) {
                int SynFlag = service.getSaveMdbInfo().isSynFlag(rptSheet.getJqOrgUnitNumber(), rptSheet.getJqPeriod(), jqItem.get("jqItemNumber"), this.sourceName, rptSheet.getFixFlag(), this.taskPrefix);
                if (SynFlag == 1) {
                    String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upRepeat", (Locale)ctx.getOriginLocale()), rptSheet.getRptNumber(), rptSheet.getRptName(), rs.getString("fitemid"));
                    logger.info((Object)str);
                    return null;
                }
                if (textValue != null && !"".equals(textValue)) {
                    itemInfo.setJqItemNumber(jqItem.get("jqItemNumber"));
                    itemInfo.setItemData(textValue);
                } else {
                    itemInfo.setJqItemNumber(jqItem.get("jqItemNumber"));
                    itemInfo.setItemData("dataIsNull");
                }
            }
            if ((keyNumber = rs.getString("fkeynumber")) != null && !"".equals(keyNumber)) {
                if (keyNumber.contains("[[")) {
                    keyNumber = keyNumber.substring(0, keyNumber.length() - 1);
                    keyNumber = keyNumber.substring(keyNumber.lastIndexOf("]") + 1, keyNumber.length());
                } else if (keyNumber.contains("[")) {
                    keyNumber = keyNumber.substring(keyNumber.lastIndexOf("]") + 1, keyNumber.length());
                }
                if (keyNumber == null || "".equals(keyNumber)) {
                    keyNumber = rs.getString("fkeynumber");
                }
                if (keyNumber.length() > 45) {
                    keyNumber = keyNumber.substring(0, 44);
                }
                itemInfo.setJqTxtItemNumber(jqItem.get("jqTxtItemNumber"));
                itemInfo.setTxtItemData(keyNumber);
            }
            boolean isFirstRow = false;
            if (rowNumber == 0) {
                rowNumber = rs.getInt("frow");
                if (itemInfo.getJqItemNumber() != null) {
                    list.add(itemInfo);
                }
                isFirstRow = true;
            }
            if (!isFirstRow && rowNumber == rs.getInt("frow")) {
                if (itemInfo.getJqItemNumber() != null) {
                    list.add(itemInfo);
                }
            } else if (rowNumber != rs.getInt("frow")) {
                itemMap.put(String.valueOf(rowNumber), list);
                rowNumber = rs.getInt("frow");
                list = new ArrayList();
                if (itemInfo.getJqItemNumber() != null) {
                    list.add(itemInfo);
                }
            }
            if (!rs.isLast()) continue;
            itemMap.put(String.valueOf(rowNumber), list);
        }
        Object[] key = itemMap.keySet().toArray();
        Arrays.sort(key);
        return itemMap;
    }

    @Override
    protected String _writeUpLoadLog(Context ctx, String cslReportId, String sheetId) throws BOSException, EASBizException {
        try {
            CslReportSheetInfo cslReportSheet = this.getCslReportSheet(ctx, cslReportId, sheetId);
            if ("1".equals(cslReportSheet.getDynarptType())) {
                String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upSucess", (Locale)ctx.getOriginLocale()), cslReportSheet.getRptNumber(), cslReportSheet.getRptName(), cslReportSheet.getSheetName());
                logger.info((Object)str);
                this.writeUplLog(ctx, cslReportSheet, str);
                CRResultInfo resultInfo = new CRResultInfo();
                this.reMoveResult(ctx, cslReportId, sheetId);
                resultInfo.setRptId(cslReportId);
                resultInfo.setSheetId(sheetId);
                resultInfo.setBizDate(new Date());
                resultInfo.setTraStatus(TransmitStatusEnum.transmited);
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                resultInfo.setUpLoadUser(userInfo.getName());
                ICRResult iCRResult = CRResultFactory.getLocalInstance(ctx);
                iCRResult.addnew((CoreBaseInfo)resultInfo);
            } else {
                this.logBindingReportSheetList(ctx, cslReportSheet);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "success";
    }

    private void logBindingReportSheetList(Context ctx, CslReportSheetInfo cslReportSheet) throws SQLException, EASBizException, BOSException {
        String sql = "select FRptNumber,FRptName,FSheetName from T_CSL_RptMap where FJQNumber = (select FJQNumber from T_CSL_RptMap where FRptNumber ='" + cslReportSheet.getRptNumber() + "' and FSheetName='" + cslReportSheet.getSheetName() + "')";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean isNull = true;
        while (rs.next()) {
            isNull = false;
            this.logBindingReportSheetMap(ctx, cslReportSheet, rs.getString("FRptNumber"), rs.getString("FSheetName"));
        }
        if (!isNull) {
            return;
        }
        String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upSucess", (Locale)ctx.getOriginLocale()), cslReportSheet.getRptNumber(), cslReportSheet.getRptName(), cslReportSheet.getSheetName());
        this.writeUplLog(ctx, cslReportSheet, str);
        CRResultInfo resultInfo = new CRResultInfo();
        this.reMoveResult(ctx, cslReportSheet.getRptId(), cslReportSheet.getSheetId());
        resultInfo.setRptId(cslReportSheet.getRptId());
        resultInfo.setSheetId(cslReportSheet.getSheetId());
        resultInfo.setBizDate(new Date());
        resultInfo.setTraStatus(TransmitStatusEnum.transmited);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        resultInfo.setUpLoadUser(userInfo.getName());
        ICRResult iCRResult = CRResultFactory.getLocalInstance(ctx);
        iCRResult.addnew((CoreBaseInfo)resultInfo);
    }

    private void logBindingReportSheetMap(Context ctx, CslReportSheetInfo cslReportSheet, String rptNumber, String sheetName) throws SQLException, EASBizException, BOSException {
        CslReportSheetInfo reportSheet = new CslReportSheetInfo();
        String sql = " select t0.fid,t1.fsheetid,t0.fReceiveStatus from T_CSL_CslReport t0 inner join  T_RPT_RPTSHEETPARA t1 on t1.freportid= t0.fid inner join T_RPT_Template t2 on t0.ftemplateid=t2.fid where t2.fnumber='" + rptNumber + "' and t1.fsheetName='" + sheetName + "' and t0.forgunitid='" + cslReportSheet.getOrgUnitId() + "' and t0.forgtreeid='" + cslReportSheet.getOrgTreeId() + "' and fyear=" + cslReportSheet.getYear() + " and fperiod=" + cslReportSheet.getPeriod();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rs.next()) {
            reportSheet = this.getCslReportSheet(ctx, rs.getString("fid"), rs.getString("fsheetid"));
            String str = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.upSucess", (Locale)ctx.getOriginLocale()), cslReportSheet.getRptNumber(), cslReportSheet.getRptName(), cslReportSheet.getSheetName());
            this.writeUplLog(ctx, reportSheet, str);
            CRResultInfo resultInfo = new CRResultInfo();
            this.reMoveResult(ctx, rs.getString("fid"), rs.getString("fsheetid"));
            resultInfo.setRptId(rs.getString("fid"));
            resultInfo.setSheetId(rs.getString("fsheetid"));
            resultInfo.setBizDate(new Date());
            resultInfo.setTraStatus(TransmitStatusEnum.transmited);
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            resultInfo.setUpLoadUser(userInfo.getName());
            ICRResult iCRResult = CRResultFactory.getLocalInstance(ctx);
            iCRResult.addnew((CoreBaseInfo)resultInfo);
        }
    }

    private void reMoveResult(Context ctx, String reportId, String sheetId) throws BOSException {
        String sql = "delete from  T_CSL_CRResult where FRptId ='" + reportId + "' and FSheetid='" + sheetId + "'";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    @Override
    protected IRowSet _getData(Context ctx, RptParams param) throws BOSException, EASBizException {
        CurrencyCollection currencyColl;
        FullOrgUnitInfo company;
        OrgUnitInfo[] results;
        UserInfo user;
        FullOrgUnitInfo orgUnit;
        String ids;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct \n");
        sql.append("t4.fid orgTreeId,t3.fid companyId, \n");
        sql.append("t0.fid rptId,t6.fsheetid sheetId, \n");
        sql.append("t3.fnumber companyNo,t3.fname_l2 company, \n");
        sql.append("t5.fnumber rptNumber, \n");
        sql.append("t0.fname rptName,t6.fsheetname sheetName, \n");
        sql.append("case when t0.FPeriodType = 3 then '" + RptPeriodTypeEnum.getEnum((int)3).getAlias() + "'\n");
        sql.append("when t0.FPeriodType = 6 then '" + RptPeriodTypeEnum.getEnum((int)6).getAlias() + "' \n");
        sql.append("else null end periodType, \n");
        sql.append("t0.fyear||'-'||t0.fperiod yearPeriod, \n");
        sql.append("t1.fname_l2 currency,t8.FUpLoadUser upLoadUser,t8.fbizDate bizDate, \n");
        sql.append("case when t8.FTraStatus = 1 then '" + TransmitStatusEnum.getEnum("1").getAlias() + "' \n");
        sql.append("when t8.FTraStatus = 2 then '" + TransmitStatusEnum.getEnum("2").getAlias() + "' \n");
        sql.append("else null end traStatus, \n");
        sql.append("case when t0.FCommittedStatus = 1 then '" + CommittedStatusEnum.getEnum((int)1).getAlias() + "' \n");
        sql.append("when t0.FCommittedStatus = 2 then '" + CommittedStatusEnum.getEnum((int)2).getAlias() + "' \n");
        sql.append("when t0.FCommittedStatus = 3 then '" + CommittedStatusEnum.getEnum((int)3).getAlias() + "' \n");
        sql.append("else null end recStatus, \n");
        sql.append("case when t0.fsourcetype in(2,3,12) then '" + RptSrcTypeEnum.getEnum((int)3).getAlias() + "/" + RptSrcTypeEnum.getEnum((int)2).getAlias() + "'\n");
        sql.append("when t0.fsourcetype in(4,1,10,11) then '" + ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.Report", (Locale)ctx.getOriginLocale()) + "' \n");
        sql.append("else t0.fsourcetype||'' end rptType, \n");
        sql.append("t5.ftemplatetype templatetype, \n");
        sql.append("t4.fname_l2 orgTree, \n");
        sql.append("case when t5.fdynarpttype = 1 then '" + DynaEnumRptTypeEnum.getEnum((int)1).getAlias() + "' \n");
        sql.append("when t5.fdynarpttype = 2 then '" + DynaEnumRptTypeEnum.getEnum((int)2).getAlias() + "'  \n");
        sql.append("else null end dynarpttype \n");
        sql.append("from T_CSL_CslReport t0 \n");
        sql.append("inner join T_BD_Currency t1 on t1.fid = t0.fcurrencyid \n");
        sql.append("inner join T_ORG_BaseUnit t3 on t3.fid = t0.forgunitid \n");
        sql.append("left join T_ORG_Tree t4 on t4.fid = t0.forgtreeid \n");
        sql.append("inner join T_RPT_Template t5 on t5.fid = t0.ftemplateid \n");
        sql.append("inner join T_RPT_RPTSHEETPARA t6 on t6.freportid = t0.fid \n");
        sql.append("inner join T_CSL_RptSel t7 on (t7.Frptnumber = t5.fnumber \n");
        sql.append("and t7.Frptname = t0.fname \n");
        sql.append("and t7.Fsheetname = t6.fsheetname) \n");
        sql.append("left join T_CSL_CRResult t8 on (t8.FRptId = t0.fid \n");
        sql.append("and t8.FSheetId = t6.fsheetid) \n");
        sql.append("inner join T_CSL_OrgMap t9 on (t3.fnumber = t9.FOrgNumber) \n");
        sql.append("where t7.Fvalue = 1 \n");
        sql.append("and t9.FJQNumber is not null \n");
        sql.append("and t0.FCommittedStatus = 3 \n");
        sql.append("and (t0.FPeriodType = t9.FRptScheme or t0.fperiod = 13 and t9.FRptScheme=6) \n");
        if (param.getObjectElement("beginDate") != null && param.getObjectElement("endDate") != null) {
            Date beginDate = (Date)param.getObjectElement("beginDate");
            Date endDate = (Date)param.getObjectElement("endDate");
            Calendar cal = Calendar.getInstance();
            cal.setTime(beginDate);
            int beginYear = cal.get(1);
            int beginMonth = cal.get(2) + 1;
            int beginDay = cal.get(5);
            if (beginMonth == 12 && beginDay == 31) {
                beginMonth = 13;
            }
            cal.setTime(endDate);
            int endYear = cal.get(1);
            int endMonth = cal.get(2) + 1;
            int endDay = cal.get(5);
            boolean crossYear = false;
            if (endYear > beginYear) {
                crossYear = true;
            }
            if (endMonth == 12 && endDay == 31) {
                endMonth = 13;
            }
            if (crossYear && endMonth == 13) {
                sql.append("and (( t0.fyear >= " + beginYear + " \n");
                sql.append("and t0.fyear <= " + (beginYear + 1) + " \n");
                sql.append("and t0.fperiod >= " + beginMonth + " \n");
                sql.append("and t0.fperiod <= 13) \n");
                sql.append("or ( t0.fyear >= " + (beginYear + 1) + " \n");
                sql.append("and t0.fyear <= " + endYear + " \n");
                sql.append("and t0.fperiod >= 1 \n");
                sql.append("and t0.fperiod <= 13)) \n");
            } else if (crossYear) {
                sql.append("and (( t0.fyear >= " + beginYear + " \n");
                sql.append("and t0.fyear <= " + (beginYear + 1) + " \n");
                sql.append("and t0.fperiod >= " + beginMonth + " \n");
                sql.append("and t0.fperiod <= 13) \n");
                sql.append("or (t0.fyear >= " + (beginYear + 1) + " \n");
                sql.append("and t0.fyear <= " + (endYear - 1) + " \n");
                sql.append("and t0.fperiod >= 1 \n");
                sql.append("and t0.fperiod <= 13) \n");
                sql.append("or (t0.fyear >= " + (endYear - 1) + " \n");
                sql.append("and t0.fyear <= " + endYear + " \n");
                sql.append("and t0.fperiod >= 1 \n");
                sql.append("and t0.fperiod <= " + endMonth + ")) \n");
            } else {
                sql.append("and t0.fyear >= " + beginYear + " \n");
                sql.append("and t0.fyear <= " + endYear + " \n");
                sql.append("and t0.fperiod >= " + beginMonth + " \n");
                sql.append("and t0.fperiod <= " + endMonth + " \n");
            }
        }
        if (param.getObjectElement("traStatus") instanceof TransmitStatusEnum) {
            TransmitStatusEnum traStatus = (TransmitStatusEnum)((Object)param.getObjectElement("traStatus"));
            if (traStatus.equals((Object)TransmitStatusEnum.transmited)) {
                sql.append("and t8.FTraStatus = " + traStatus.getValue() + " \n");
            } else if (traStatus.equals((Object)TransmitStatusEnum.noTransmit)) {
                sql.append("and t8.FTraStatus is null \n");
            }
        }
        if (param.getObjectElement("rptType") instanceof RptTypeEnum) {
            RptTypeEnum rptType = (RptTypeEnum)((Object)param.getObjectElement("rptType"));
            if (RptTypeEnum.Individual.equals((Object)rptType)) {
                sql.append("and t0.fsourcetype in (1,4,10,11) \n");
            } else if (RptTypeEnum.Group.equals((Object)rptType)) {
                sql.append("and t0.fsourcetype in (2,3,12) \n");
            }
        }
        param.getObjectElement("orgTree");
        if (param.getObjectElement("orgUnit") instanceof FullOrgUnitInfo && (ids = this.getOrgStructure(ctx, (orgUnit = (FullOrgUnitInfo)param.getObjectElement("orgUnit")).getId().toString())) != null && !ids.equals("")) {
            sql.append("and t3.fid in (" + ids + ") \n");
        }
        if ((user = ContextUtil.getCurrentUserInfo((Context)ctx)) != null && user.getId() != null && (results = RptLogFactory.getLocalInstance(ctx).getOrgUnits("csl_rptupl_view", user.getId().toString())) != null && results.length > 0) {
            sql.append("and t3.fid in (" + this.arrayToString(results) + ") \n");
        }
        if (param.getObjectElement("company") instanceof FullOrgUnitInfo && (company = (FullOrgUnitInfo)param.getObjectElement("company")) != null) {
            sql.append("and t3.fid = '" + company.getId().toString() + "' \n");
        }
        if ((currencyColl = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection("where number='RMB'")) != null && currencyColl.size() > 0) {
            CurrencyInfo currency = currencyColl.get(0);
            sql.append("and t1.fid = '" + currency.getId().toString() + "' \n");
        }
        sql.append("order by companyNo,rptName,sheetName, \n");
        sql.append("periodType,yearPeriod, \n");
        sql.append("currency,bizDate,traStatus, \n");
        sql.append("recStatus,rptType,orgTree, \n");
        sql.append("templateType \n");
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    private String arrayToString(OrgUnitInfo[] results) {
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < results.length; ++i) {
            OrgUnitInfo org = results[i];
            str.append("'").append(org.getId().toString()).append("',");
        }
        String tempStr = "";
        if (str.length() > 0) {
            tempStr = str.substring(0, str.length() - 1);
        }
        return tempStr;
    }

    private String getOrgStructure(Context ctx, String companyID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select flongnumber from T_ORG_Structure where funitid = '" + companyID + "' \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                String longNumber = rs.getString("flongnumber");
                sql = new StringBuffer();
                sql.append("select funitid from T_ORG_Structure where flongnumber like '" + longNumber + "%'");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                StringBuffer ids = new StringBuffer();
                while (rowSet.next()) {
                    ids.append("'");
                    ids.append(rowSet.getString("funitid"));
                    ids.append("',");
                }
                if (ids.length() > 0) {
                    String tempStr = ids.substring(0, ids.length() - 1);
                    return tempStr;
                }
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return null;
    }

    @Override
    protected String _getWSAddress(Context ctx) throws BOSException, EASBizException {
        String wsAddress;
        block4: {
            wsAddress = null;
            String sql = " select FWsAddress,FPort from T_CSL_ReportPara ";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    wsAddress = rs.getString("FWsAddress");
                    if (rs.getString("FPort") != null && !"".equals(rs.getString("FPort"))) {
                        wsAddress = wsAddress + ":" + rs.getString("FPort");
                    }
                    break block4;
                }
                String str = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.webServiceParaException", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
            }
            catch (SQLException e) {
                e.printStackTrace();
                String str = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.ReportParaException", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
            }
        }
        this.wsAddress = "http://" + wsAddress + "/netrep/services/SaveMdbInfo";
        return wsAddress;
    }

    private void setWebService(Context ctx) throws BOSException, SQLException, EASBizException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FSourceName,FTaskPrefix from T_CSL_ReportPara ");
        if (!rs.next()) {
            String str = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.webServiceParaException", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
        }
        this.sourceName = rs.getString("FSourceName");
        this.taskPrefix = rs.getString("FTaskPrefix");
    }

    private void setWSAddress(Context ctx) throws BOSException, EASBizException {
        String wsAddress;
        block4: {
            wsAddress = null;
            String sql = " select FWsAddress,FPort from T_CSL_ReportPara ";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
                if (rs.next()) {
                    wsAddress = rs.getString("FWsAddress");
                    if (rs.getString("FPort") != null && !"".equals(rs.getString("FPort"))) {
                        wsAddress = wsAddress + ":" + rs.getString("FPort");
                    }
                    break block4;
                }
                String str = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.webServiceParaException", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
            }
            catch (SQLException e) {
                e.printStackTrace();
                String str = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.jiuqiInterface.JiuqiResource.ReportParaException", (Locale)ctx.getOriginLocale());
                throw new EASBizException(new NumericExceptionSubItem("orgNumberMapException", str));
            }
        }
        this.wsAddress = wsAddress + "/netrep/services/SaveMdbInfo";
    }

    @Override
    protected boolean _addUpdateOrgMap(Context ctx) throws BOSException, EASBizException {
        boolean flag = false;
        String sql = "delete from T_CSL_OrgMap where Forgid not in(select t1.fid from T_ORG_Structure t0 inner join T_ORG_BaseUnit t1 on t1.fid = t0.funitid inner join T_ORG_Tree t2 on t2.fid = t0.ftreeid where (t2.fnumber = '002' or t2.fnumber = '001') and  t2.fstatus = '1' )";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "select t1.Forgid,t2.fnumber,t2.fname_l2 from T_CSL_OrgMap t1 inner join T_ORG_BaseUnit t2 on t1.Forgid=t2.fid and (t1.FOrgNumber!=t2.fnumber or t1.FOrgName!=t2.fname_l2)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                DbUtil.execute((Context)ctx, (String)("update T_CSL_OrgMap set FOrgNumber='" + rs.getString("fnumber") + "',FOrgName='" + rs.getString("fname_l2") + "' where FOrgID='" + rs.getString("Forgid") + "'"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        sql = "insert into T_CSL_OrgMap(FID,FOrgID,FOrgNumber,FOrgName,FRptType,FRptScheme,FIsUnion) select newbosid('400411F4') as fid, t1.fid as FOrgID,t1.fnumber orgNumber,t1.fname_l2 orgName,10,3, t1.fisUnion from T_ORG_Structure t0 inner join T_ORG_BaseUnit t1 on t1.fid = t0.funitid inner join T_ORG_Tree t2 on t2.fid = t0.ftreeid where (t2.fnumber = '002' or t2.fnumber = '001') and t2.fstatus = '1' and t1.FIsUnion = 0 and t1.fnumber not in (select FOrgNumber from T_CSL_OrgMap where FRptType = 10 and FRptScheme = 3 and FIsUnion = 0) ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "insert into T_CSL_OrgMap(FID,FOrgID,FOrgNumber,FOrgName,FRptType,FRptScheme,FIsUnion) select newbosid('400411F4') as fid, t1.fid as FOrgID,t1.fnumber orgNumber,t1.fname_l2 orgName,10,6, t1.fisUnion from T_ORG_Structure t0 inner join T_ORG_BaseUnit t1 on t1.fid = t0.funitid inner join T_ORG_Tree t2 on t2.fid = t0.ftreeid where (t2.fnumber = '002' or t2.fnumber = '001') and t2.fstatus = '1' and t1.FIsUnion = 0 and t1.fnumber not in (select FOrgNumber from T_CSL_OrgMap where FRptType = 10 and FRptScheme = 6 and FIsUnion = 0)";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "insert into T_CSL_OrgMap(FID,FOrgID,FOrgNumber,FOrgName,FRptType,FRptScheme,FIsUnion) select newbosid('400411F4') as fid, t1.fid as FOrgID,t1.fnumber orgNumber,t1.fname_l2 orgName,20,3, t1.fisUnion from T_ORG_Structure t0 inner join T_ORG_BaseUnit t1 on t1.fid = t0.funitid inner join T_ORG_Tree t2 on t2.fid = t0.ftreeid where (t2.fnumber = '002' or t2.fnumber = '001') and t2.fstatus = '1' and t1.FIsUnion = 1 and t1.fnumber not in (select FOrgNumber from T_CSL_OrgMap where FRptType = 20 and FRptScheme = 3 and FIsUnion = 1) ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "insert into T_CSL_OrgMap(FID,FOrgID,FOrgNumber,FOrgName,FRptType,FRptScheme,FIsUnion) select newbosid('400411F4') as fid, t1.fid as FOrgID,t1.fnumber orgNumber,t1.fname_l2 orgName,20,6, t1.fisUnion from T_ORG_Structure t0 inner join T_ORG_BaseUnit t1 on t1.fid = t0.funitid inner join T_ORG_Tree t2 on t2.fid = t0.ftreeid where (t2.fnumber = '002' or t2.fnumber = '001') and t2.fstatus = '1' and t1.FIsUnion = 1 and t1.fnumber not in (select FOrgNumber from T_CSL_OrgMap where FRptType = 20 and FRptScheme = 6 and FIsUnion = 1)";
        DbUtil.execute((Context)ctx, (String)sql);
        flag = true;
        return flag;
    }
}

