/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.mapping;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.ItemFormula;
import com.kingdee.eas.fi.newrpt.mapping.InteRptItemMappingInfo;
import com.kingdee.eas.fi.newrpt.mapping.MathSymbols;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingFactory;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TemplateMapHelp {
    private Set<String> itemNumber = new HashSet<String>();
    private Map<String, String> accItemMap = new HashMap<String, String>();

    public static TemplateMapHelp getInstance() {
        return new TemplateMapHelp();
    }

    public void getTempMapSourcePaper(Map<String, Object> params) throws EASBizException, BOSException {
        Book book = (Book)params.get("book");
        HashMap<String, Object> reParams = new HashMap<String, Object>();
        reParams.put("reportInfo", params.get("reportInfo"));
        Map rptDataMap = TemplateMappingFactory.getRemoteInstance().getTemplateMapData(reParams);
        if (rptDataMap != null) {
            Map srcUnitInfo = (Map)rptDataMap.get("srcUnitInfo");
            List itemMaps = (List)rptDataMap.get("itemMaps");
            if (itemMaps != null && !itemMaps.isEmpty()) {
                for (int i = 0; i < itemMaps.size(); ++i) {
                    this.itemNumber.add(((InteRptItemMappingInfo)itemMaps.get(i)).getTargetRptItemNum() + ((InteRptItemMappingInfo)itemMaps.get(i)).getTargetDataElementNum());
                }
            }
            this.buildAccItemFormula(srcUnitInfo, (ReportBaseInfo)params.get("reportInfo"), itemMaps);
        }
        this.setBookFormula(book);
    }

    private void buildAccItemFormula(Map<String, Object> srcUnitInfo, ReportBaseInfo reportInfo, List<InteRptItemMappingInfo> itemMaps) {
        StringBuffer formulastr = new StringBuffer();
        InteRptItemMappingInfo mapInfo = null;
        InteRptItemMappingInfo tempInfo = null;
        HashSet<String> targetItemnum = new HashSet<String>();
        if (itemMaps != null && itemMaps.size() > 0) {
            for (int i = 0; i < itemMaps.size(); ++i) {
                mapInfo = itemMaps.get(i);
                if (targetItemnum.contains(mapInfo.getTargetRptItemNum() + mapInfo.getTargetDataElementNum())) continue;
                targetItemnum.add(mapInfo.getTargetRptItemNum() + mapInfo.getTargetDataElementNum());
                formulastr.append("=AcctItem(\"");
                formulastr.append(srcUnitInfo.get("treenumber").toString() + "\",\"");
                formulastr.append(srcUnitInfo.get("unitnumber") + "\",\"");
                formulastr.append(reportInfo.getCurrency().getNumber() + "\",\"");
                formulastr.append(reportInfo.getCurrency().getNumber() + "\",\"");
                formulastr.append(mapInfo.getSourceRptItemNum() + "\",\"");
                formulastr.append(mapInfo.getSourceRptItemNum() + "\",\"");
                formulastr.append(reportInfo.getPeriodType().getName() + "\",");
                formulastr.append(reportInfo.getYear() + ",");
                formulastr.append(reportInfo.getPeriod() + ",");
                formulastr.append(reportInfo.getPeriod() + ",\"");
                if (srcUnitInfo.get("isUnion").toString().equals("no")) {
                    formulastr.append(reportInfo.getSourceType().getName() + "\",\"");
                } else if (srcUnitInfo.get("FIsSupportGroupReport").toString().equals("0")) {
                    formulastr.append("CONSOLIDATION_FASTMERGE\",\"");
                } else {
                    formulastr.append("CONSOLIDATION\",\"");
                }
                formulastr.append(mapInfo.getSourceDataElementNum() + "\",\"");
                formulastr.append("MONEY\",");
                formulastr.append("False,");
                formulastr.append("True,\"");
                formulastr.append("\",");
                formulastr.append("False,\"");
                if (srcUnitInfo.get("solunumber") == null) {
                    formulastr.append("\")");
                } else {
                    formulastr.append(srcUnitInfo.get("solunumber").toString() + "\")");
                }
                if (mapInfo.getPlusMinus().equals((Object)MathSymbols.minus)) {
                    formulastr.append("*(-1)");
                }
                for (int j = i; j < itemMaps.size(); ++j) {
                    tempInfo = itemMaps.get(j);
                    if (i == j || !mapInfo.getTargetRptItemNum().equals(tempInfo.getTargetRptItemNum()) || !mapInfo.getTargetDataElementNum().equals(tempInfo.getTargetDataElementNum())) continue;
                    if (tempInfo.getPlusMinus().equals((Object)MathSymbols.minus)) {
                        formulastr.append("-AcctItem(\"");
                    } else if (tempInfo.getPlusMinus().equals((Object)MathSymbols.plus)) {
                        formulastr.append("+AcctItem(\"");
                    }
                    formulastr.append(srcUnitInfo.get("treenumber") + "\",\"");
                    formulastr.append(srcUnitInfo.get("unitnumber") + "\",\"");
                    formulastr.append(reportInfo.getCurrency().getNumber() + "\",\"");
                    formulastr.append(reportInfo.getCurrency().getNumber() + "\",\"");
                    formulastr.append(tempInfo.getSourceRptItemNum() + "\",\"");
                    formulastr.append(tempInfo.getSourceRptItemNum() + "\",\"");
                    formulastr.append(reportInfo.getPeriodType().getName() + "\",");
                    formulastr.append(reportInfo.getYear() + ",");
                    formulastr.append(reportInfo.getPeriod() + ",");
                    formulastr.append(reportInfo.getPeriod() + ",\"");
                    if (srcUnitInfo.get("isUnion").toString().equals("no")) {
                        formulastr.append(reportInfo.getSourceType().getName() + "\",\"");
                    } else if (srcUnitInfo.get("FIsSupportGroupReport").toString().equals("0")) {
                        formulastr.append("CONSOLIDATION_FASTMERGE\",\"");
                    } else {
                        formulastr.append("CONSOLIDATION\",\"");
                    }
                    formulastr.append(mapInfo.getSourceDataElementNum() + "\",\"");
                    formulastr.append("MONEY\",");
                    formulastr.append("False,");
                    formulastr.append("True,\"");
                    formulastr.append("\",");
                    formulastr.append("False,\"");
                    if (srcUnitInfo.get("solunumber") == null) {
                        formulastr.append("\")");
                        continue;
                    }
                    formulastr.append(srcUnitInfo.get("solunumber") + "\")");
                }
                this.accItemMap.put(mapInfo.getTargetRptItemNum() + mapInfo.getTargetDataElementNum(), formulastr.toString());
                formulastr.setLength(0);
            }
        }
    }

    private void setBookFormula(Book book) {
        int sheetCount = book.getSheetCount();
        Sheet sheet = null;
        for (int i = 0; i < sheetCount; ++i) {
            sheet = book.getSheet(i);
            if (sheet.getUserObject("setFormula") != null) continue;
            this.setBookFormula(sheet);
        }
    }

    private void setBookFormula(Sheet sheet) {
        int col = sheet.getMaxColIndex();
        int row = sheet.getMaxRowIndex();
        Cell cell = null;
        for (int i = 0; i < row + 1; ++i) {
            for (int j = 0; j < col + 1; ++j) {
                ItemFormula itemFormula;
                cell = sheet.getCell(i, j, false);
                if (cell == null || (itemFormula = (ItemFormula)cell.getUserObjectValue("ITEM")) == null || this.itemNumber.size() <= 0) continue;
                for (String itemnum : this.itemNumber) {
                    if (!itemnum.equals(itemFormula.getItemNumber() + itemFormula.getDataElementNumber())) continue;
                    cell.setFormula(null);
                    cell.setFormula(this.accItemMap.get(itemnum));
                }
            }
        }
    }
}

