/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.mapping.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.IsCitedByLaterEnum;
import com.kingdee.eas.fi.gr.fast.FastMergeSoluInfo;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingEntryCollection;
import com.kingdee.eas.fi.newrpt.mapping.TemplateMappingEntryInfo;
import com.kingdee.eas.fi.newrpt.mapping.app.AbstractTemplateMappingEntryControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class TemplateMappingEntryControllerBean
extends AbstractTemplateMappingEntryControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.mapping.app.TemplateMappingEntryControllerBean");

    @Override
    protected List _checkExist(Context ctx, IObjectCollection colls) throws BOSException {
        ArrayList<String> existData = new ArrayList<String>();
        if (colls.size() > 0) {
            CoreBaseCollection mapEntryColls = (CoreBaseCollection)colls;
            CoreBaseInfo entryInfo = null;
            StringBuffer checksql = new StringBuffer();
            checksql.append(" select distinct tree.fnumber treeNumber,unit.fnumber unitNumber from T_CSL_TemplateMappingEntry mapentry  ");
            checksql.append(" INNER JOIN T_ORG_Tree tree on tree.fid = mapentry.FTargetOrgBoundId ");
            checksql.append(" INNER JOIN T_ORG_BaseUnit unit on unit.fid = mapentry.FTargetOrgId  where ");
            checksql.append(" mapentry.FTemplateMappingId<>'" + ((CoreBaseInfo)mapEntryColls.get(0).get("templateMapping")).getId().toString() + "' and ");
            for (int i = 0; i < mapEntryColls.size(); ++i) {
                entryInfo = mapEntryColls.get(i);
                if (i == 0) {
                    checksql.append("(");
                } else {
                    checksql.append(" OR ");
                }
                checksql.append(" (tree.fnumber='").append(((OrgTreeInfo)entryInfo.get("targetorgbound")).getNumber()).append("'");
                checksql.append(" and unit.fnumber='").append(((FullOrgUnitInfo)entryInfo.get("targetorg")).getNumber()).append("' )");
            }
            checksql.append(")");
            IRowSet rowsets = DbUtil.executeQuery(ctx, checksql.toString());
            try {
                while (rowsets.next()) {
                    existData.add(rowsets.getString("unitNumber"));
                }
            }
            catch (SQLException e) {
                logger.error((Object)"_checkExist error", (Throwable)e);
            }
        }
        return existData;
    }

    @Override
    protected IObjectCollection _getOrgMappingData(Context ctx, String mappingSoluInfoId) throws BOSException, EASBizException {
        TemplateMappingEntryCollection collection = new TemplateMappingEntryCollection();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select mappingEntry.fid entryId,mappingEntry.FIsSupportGroupReport isSupportGroupReport,\n");
        selectSql.append("targetTree.FID targetTreeId,targetTree.FNAME_").append(ctx.getLocale()).append(" targetTreeName, targetTree.FNUMBER targetTreeNum, \n");
        selectSql.append("targetUnit.FID targetUnitId,targetUnit.FNAME_").append(ctx.getLocale()).append("  targetUnitName, targetUnit.FNUMBER targetUnitNum,targetUnit.FIsunion targetUnitIsunion, \n");
        selectSql.append("mergeSolution.FID mergeSolutionId,mergeSolution.FNAME_").append(ctx.getLocale()).append("  mergeSolutionName, mergeSolution.FNUMBER mergeSolutionNum, \n");
        selectSql.append("srcTree.FID srcTreeId,srcTree.FNAME_").append(ctx.getLocale()).append("  srcTreeName, srcTree.FNUMBER srcTreeNum, \n");
        selectSql.append("srcUnit.FID srcUnitId,srcUnit.FNAME_").append(ctx.getLocale()).append("  srcUnitName, srcUnit.FNUMBER srcUnitNum, srcUnit.FIsUnion IsUnion,\n");
        selectSql.append("structure.FParentID parentID,structure.FId structureId,structure.FLevel structureLevel,structure.FIsLeaf structureIsLeaf \n");
        selectSql.append("from t_csl_templatemappingentry mappingEntry join t_csl_templatemapping mapping on mappingEntry.FTemplateMappingId=mapping.fid \n");
        selectSql.append("join t_org_tree targetTree on targetTree.fid=mappingEntry.FTargetOrgBoundId \n");
        selectSql.append("join t_org_baseunit targetUnit on targetUnit.FID =mappingEntry.FTargetOrgId \n");
        selectSql.append("join T_ORG_Structure structure on Structure.FTREEID =targetTree.fid and structure.FUNITID  =targetUnit.fid \n");
        selectSql.append("left join T_CSL_FastMergeSolu mergeSolution on mergeSolution.FID =mappingEntry.FMergeSolutionId \n");
        selectSql.append("left join t_org_tree srcTree on srcTree.FID =mappingEntry.FSrcOrgBoundId \n");
        selectSql.append("left join t_org_baseunit srcUnit on srcUnit.FID =mappingEntry.FSrcOrgId \n");
        selectSql.append("where mapping.fid=? \n");
        selectSql.append("order by structure.FLONGNUMBER asc ");
        IRowSet rows = DbUtil.executeQuery(ctx, selectSql.toString(), new Object[]{mappingSoluInfoId});
        try {
            while (rows.next()) {
                TemplateMappingEntryInfo entryInfo = new TemplateMappingEntryInfo();
                entryInfo.setId(BOSUuid.read((String)rows.getString("entryId")));
                entryInfo.setIsSupportGroupReport(IsCitedByLaterEnum.getEnum((int)rows.getInt("isSupportGroupReport")));
                OrgTreeInfo targetTree = new OrgTreeInfo();
                targetTree.setId(BOSUuid.read((String)rows.getString("targetTreeId")));
                targetTree.setName(rows.getString("targetTreeName"));
                targetTree.setNumber(rows.getString("targetTreeNum"));
                entryInfo.setTargetOrgBound(targetTree);
                FullOrgUnitInfo targetUnit = new FullOrgUnitInfo();
                targetUnit.setId(BOSUuid.read((String)rows.getString("targetUnitId")));
                targetUnit.setName(rows.getString("targetUnitName"));
                targetUnit.setNumber(rows.getString("targetUnitNum"));
                targetUnit.setIsUnion(rows.getInt("targetUnitIsunion") == 1);
                entryInfo.setTargetOrg(targetUnit);
                OrgStructureInfo strInfo = new OrgStructureInfo();
                if (rows.getString("parentID") != null) {
                    OrgStructureInfo parentStrInfo = new OrgStructureInfo();
                    parentStrInfo.setId(BOSUuid.read((String)rows.getString("parentID")));
                    strInfo.setParent(parentStrInfo);
                }
                strInfo.setId(BOSUuid.read((String)rows.getString("structureId")));
                strInfo.setLevel(rows.getInt("structureLevel"));
                strInfo.setIsLeaf(rows.getInt("structureIsLeaf") == 1);
                strInfo.put("isExpand", (Object)Boolean.TRUE);
                entryInfo.put("orgStructureInfo", strInfo);
                if (rows.getString("srcTreeId") != null) {
                    OrgTreeInfo srcTree = new OrgTreeInfo();
                    srcTree.setId(BOSUuid.read((String)rows.getString("srcTreeId")));
                    srcTree.setName(rows.getString("srcTreeName"));
                    srcTree.setNumber(rows.getString("srcTreeNum"));
                    entryInfo.setSrcOrgBound(srcTree);
                }
                if (rows.getString("srcUnitId") != null) {
                    FullOrgUnitInfo srcUnit = new FullOrgUnitInfo();
                    srcUnit.setId(BOSUuid.read((String)rows.getString("srcUnitId")));
                    srcUnit.setName(rows.getString("srcUnitName"));
                    srcUnit.setNumber(rows.getString("srcUnitNum"));
                    srcUnit.setIsUnion(rows.getInt("IsUnion") == 1);
                    entryInfo.setSrcOrg(srcUnit);
                }
                if (rows.getString("mergeSolutionId") != null) {
                    FastMergeSoluInfo mergeSoluInfo = new FastMergeSoluInfo();
                    mergeSoluInfo.setId(BOSUuid.read((String)rows.getString("mergeSolutionId")));
                    mergeSoluInfo.setName(rows.getString("mergeSolutionName"));
                    mergeSoluInfo.setNumber(rows.getString("mergeSolutionNum"));
                    entryInfo.setMergeSolution(mergeSoluInfo);
                }
                collection.add(entryInfo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get org mapping data error", (Throwable)e);
        }
        return collection;
    }
}

