/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.util;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SheetColumMergeHelper {
    private int start_col;
    private int start_row;
    private int end_col;
    private int end_row;
    private Sheet sheet;
    private List<Range> allMergeList = null;
    private List<Range> colMergeList = null;

    public SheetColumMergeHelper(Sheet sheet, int start_col, int start_row, int end_col, int end_row) {
        this.sheet = sheet;
        this.start_col = start_col;
        this.start_row = start_row;
        this.end_col = end_col;
        this.end_row = end_row;
        this.allMergeList = new ArrayList<Range>();
    }

    public void merge(boolean isMerge) {
        if (this.end_row - this.start_row == 0) {
            return;
        }
        MergeBlocks merger = this.sheet.getMerger(false);
        if (!isMerge && merger == null) {
            return;
        }
        this.colMergeList = this.scanColumMerge(this.start_row, this.end_row, this.start_col);
        this.recursionScanColumMerge(this.colMergeList);
        Collections.sort(this.allMergeList, new RangeSortComparator());
        if (merger != null && isMerge) {
            for (Range range : this.allMergeList) {
                merger.remove((SortedCellBlockArray)range);
            }
        } else if (!isMerge && merger != null) {
            this.allMergeList.clear();
            for (int i = 0; i < merger.size(); ++i) {
                CellBlock block = merger.getBlock(i);
                if (block.getRow() < this.start_row || block.getRow2() > this.end_row) continue;
                this.allMergeList.add(this.sheet.getRange(block.getRow(), block.getCol(), block.getRow2(), block.getCol2()));
            }
        }
        this.mergeRange();
    }

    private void mergeRange() {
        for (Range range : this.allMergeList) {
            if (range == null) continue;
            range.setIgnoreProtected(true);
            range.merge();
        }
    }

    private void recursionScanColumMerge(List<Range> colMergeList) {
        for (Range range : colMergeList) {
            if (range == null) continue;
            int col_index = range.getBlock(range.size() - 1).getCol();
            int start_row = range.getBlock(0).getRow();
            int end_row = range.getBlock(range.size() - 1).getRow2();
            if (col_index == this.end_col) break;
            this.recursionScanColumMerge(this.scanColumMerge(start_row, end_row + 1, col_index + 1));
        }
    }

    private List<Range> scanColumMerge(int start_row, int end_row, int colIndex) {
        Cell preCell = null;
        Cell currCell = null;
        Variant preValue = null;
        Variant currValue = null;
        int merge_start_row = 0;
        int merg_end_row = 0;
        boolean isMergeBlock = false;
        ArrayList<Range> colMergeList = new ArrayList<Range>();
        for (int i = start_row; i < end_row; ++i) {
            currCell = this.sheet.getCell(i, colIndex, false);
            if (currCell != null) {
                currValue = currCell.getValue();
            }
            if (preCell == null) {
                preCell = currCell;
                preValue = currValue;
                continue;
            }
            if (currValue != null && currValue.equals(preValue)) {
                if (!isMergeBlock) {
                    merge_start_row = i - 1;
                    isMergeBlock = true;
                }
                merg_end_row = i;
                if (i != end_row - 1 || !isMergeBlock) continue;
                colMergeList.add(this.sheet.getRange(merge_start_row, colIndex, merg_end_row, colIndex));
                this.allMergeList.add(this.sheet.getRange(merge_start_row, colIndex, merg_end_row, colIndex));
                continue;
            }
            if (isMergeBlock) {
                merg_end_row = i - 1;
                colMergeList.add(this.sheet.getRange(merge_start_row, colIndex, merg_end_row, colIndex));
                this.allMergeList.add(this.sheet.getRange(merge_start_row, colIndex, merg_end_row, colIndex));
            }
            isMergeBlock = false;
            preCell = currCell;
            preValue = currValue;
        }
        return colMergeList;
    }

    private class RangeSortComparator
    implements Comparator<Range> {
        private RangeSortComparator() {
        }

        @Override
        public int compare(Range o1, Range o2) {
            int end_row_o1 = o1.getBlock(o1.size() - 1).getRow2();
            int col_index_o1 = o1.getBlock(o1.size() - 1).getCol2();
            int end_row_o2 = o2.getBlock(o2.size() - 1).getRow2();
            int col_index_o2 = o2.getBlock(o2.size() - 1).getCol2();
            return end_row_o2 == end_row_o1 ? col_index_o2 - col_index_o1 : end_row_o2 - end_row_o1;
        }
    }
}

