/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.newrpt.web.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.service.job.JobServiceFactory;
import com.kingdee.bos.service.job.core.IJobHandler;
import com.kingdee.bos.service.job.core.Job;
import com.kingdee.bos.service.job.core.JobState;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.CslRptUtil;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogFactory;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveLogInfo;
import com.kingdee.eas.fi.gr.weaverpt.RptAutoWeaveUtil;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveExecParams;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLinkEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveLogSuccEnum;
import com.kingdee.eas.fi.gr.weaverpt.RptWeaveParams;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.newrpt.web.IReportTask;
import com.kingdee.eas.fi.newrpt.web.LogNodeTypeEnum;
import com.kingdee.eas.fi.newrpt.web.ReportOperateEnum;
import com.kingdee.eas.fi.newrpt.web.ReportTaskEntryCollection;
import com.kingdee.eas.fi.newrpt.web.ReportTaskEntryInfo;
import com.kingdee.eas.fi.newrpt.web.ReportTaskFactory;
import com.kingdee.eas.fi.newrpt.web.ReportTaskInfo;
import com.kingdee.eas.fi.newrpt.web.RptTaskExecutedTaskCollection;
import com.kingdee.eas.fi.newrpt.web.RptTaskExecutedTaskFactory;
import com.kingdee.eas.fi.newrpt.web.RptTaskExecutedTaskInfo;
import com.kingdee.eas.fi.newrpt.web.SchemeOperate;
import com.kingdee.eas.fi.newrpt.web.TaskExecuteException;
import com.kingdee.eas.fi.newrpt.web.app.AbstractReportTaskExecuteFacadeControllerBean;
import com.kingdee.eas.fi.newrpt.web.app.RptTaskExecuteHandle;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportTaskExecuteFacadeControllerBean
extends AbstractReportTaskExecuteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.newrpt.web.app.ReportTaskExecuteFacadeControllerBean");

    @Override
    protected void _handExecuteRptTask(Context ctx, String taskid, String userid, Map params) throws BOSException, EASBizException {
        if (this.isRunningScheme(ctx, taskid)) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"844_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()) + taskid));
            throw new TaskExecuteException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE", (Locale)ctx.getOriginLocale()));
        }
        this.updateExcutingStatus(ctx, taskid);
        this.rptTaskExecuteByHand(ctx, taskid, userid, params);
    }

    private void updateExcutingStatus(Context ctx, String taskid) throws EASBizException, BOSException {
        String sql = "update T_CSL_ReportTask set FExcuteStatus = 1 where Fid = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(taskid);
        DbUtil.execute(ctx, sql, params.toArray());
    }

    private void rptTaskExecuteByHand(Context ctx, String taskid, String userid, Map params) throws EASBizException, BOSException {
        ReportTaskInfo task = this.getReportTaskInfo(ctx, taskid);
        ReportTaskEntryCollection coll = task.getEntries();
        if (coll == null || coll.size() == 0) {
            return;
        }
        FullOrgUnitCollection orgUnitColl = null;
        boolean isFromTask = false;
        if (!params.containsKey("isFromSchedule") && params.containsKey("FullOrgUnitCollection")) {
            orgUnitColl = (FullOrgUnitCollection)params.get("FullOrgUnitCollection");
            isFromTask = true;
        } else {
            orgUnitColl = this.getFullOrgUnitCollection(coll);
            if (orgUnitColl == null || orgUnitColl.size() == 0) {
                return;
            }
        }
        Map templateMap = this.getTemplateCollection(coll, orgUnitColl);
        if (templateMap == null || templateMap.size() == 0) {
            return;
        }
        int year = -1;
        int period = -1;
        int periodType = -1;
        Date date = null;
        CurrencyInfo currency = null;
        boolean isAddNew = false;
        boolean isCalc = false;
        boolean isCheck = false;
        boolean isAudit = false;
        if (params.containsKey("isFromSchedule")) {
            String jobProcessDefid = task.getJobProcessDef();
            if (StringUtils.isEmpty((String)jobProcessDefid) || task.getIsForbidden() == 1) {
                return;
            }
            currency = task.getCurrency();
            int cycle = task.getDispatchPeriod();
            periodType = task.getPeriodType().getValue();
            Calendar calendar = Calendar.getInstance();
            List times = RPTDateUtil.getRptPeriod((Date)calendar.getTime(), (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)periodType));
            Integer taskYear = (Integer)times.get(0);
            Integer taskPeriod = (Integer)times.get(1);
            times = cycle == 0 ? RPTDateUtil.getRptYearAndPeriodAndDate((int)taskYear, (int)taskPeriod, (int)periodType, (int)0, (int)-1) : RPTDateUtil.getRptYearAndPeriodAndDate((int)taskYear, (int)taskPeriod, (int)periodType, (int)0, (int)0);
            year = (Integer)times.get(0);
            period = (Integer)times.get(1);
            date = (Date)times.get(2);
            int operation = task.getReportOperate().getValue();
            if (operation == 1) {
                isAddNew = true;
                isCalc = true;
                isCheck = true;
            } else if (operation == 2) {
                isCheck = true;
                isAudit = true;
            }
        } else {
            year = Integer.valueOf(params.get("year").toString());
            period = Integer.valueOf(params.get("period").toString());
            periodType = Integer.valueOf(params.get("periodType").toString());
            date = (Date)params.get("date");
            currency = (CurrencyInfo)params.get("currency");
            isAddNew = Boolean.valueOf(params.get("isAddNew").toString());
            isCalc = Boolean.valueOf(params.get("isCalc").toString());
            isCheck = Boolean.valueOf(params.get("isCheck").toString());
            isAudit = Boolean.valueOf(params.get("isAudit").toString());
        }
        String bizCode = this.getBizCode(isAddNew, isCalc, isCheck, isAudit);
        ArrayList<String> jobList = new ArrayList<String>();
        ArrayList<String> companyList = new ArrayList<String>();
        boolean isQueueWeave = RptAutoWeaveUtil.isQueueRptAutoWeave((Context)ctx);
        String mutex = "RptTaskExecute";
        int mutexFlag = 0;
        Object dbtype = ctx.get((Object)"dbType");
        this.deleteTaskExecuteLog(ctx, taskid, params);
        String currencyid = currency.getId().toString();
        RptAutoWeaveLogInfo taskLog = this.addTaskExecuteLog(ctx, taskid, userid, year, period, periodType, currencyid);
        for (int i = 0; i < orgUnitColl.size(); ++i) {
            String companyid = orgUnitColl.get(i).getId().toString();
            RptAutoWeaveLogInfo companyLog = this.addCompanyExecuteLog(ctx, taskid, userid, companyid, year, period, periodType, currencyid, bizCode);
            RptWeaveParams param = new RptWeaveParams();
            param.setInt("Year", year);
            param.setInt("Period", period);
            param.setObject("Day", (Object)date);
            param.setObject("rpt_web_rptExecObj", (Object)task);
            param.setObject("rpt_web_templateCol", (Object)templateMap);
            param.setObject("currency", (Object)currency);
            param.setBoolean("isAddNew", isAddNew);
            param.setBoolean("isCalc", isCalc);
            param.setBoolean("isCheck", isCheck);
            param.setBoolean("isAudit", isAudit);
            param.setBoolean("isCommit", isAudit);
            param.setBoolean("rpt_web_isRptExec", true);
            param.setInt("rpt_web_companyCount", orgUnitColl.size());
            param.setBoolean("rpt_web_isFromTask", isFromTask);
            param.setObject("rpt_web_taskLog", (Object)taskLog);
            param.setObject("rpt_web_companyLog", (Object)companyLog);
            RptWeaveExecParams execParam = new RptWeaveExecParams();
            if (task.getLastUpdateUser() != null) {
                userid = task.getLastUpdateUser().getId().toString();
            }
            execParam.setUserId(userid);
            param.setObject("rpt_weave_execparams", (Object)execParam);
            param.setObject("KEY_COMPANY", (Object)orgUnitColl.get(i));
            param.setObject("dbType", dbtype);
            param.setObject("ControlUnit", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx));
            mutex = "RptTaskExecute";
            mutexFlag = i % 2;
            mutex = mutex + mutexFlag;
            if (isQueueWeave) {
                String msg = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"rptTaskExecuteQueueTitle", (Locale)ctx.getOriginLocale());
                String title = MessageFormat.format(msg, i, task.getNumber(), orgUnitColl.get(i).getName(), orgUnitColl.get(i).getNumber());
                Job job = RptAutoWeaveUtil.createWeaveRptJob((Context)ctx, (RptWeaveParams)param, (String)title, (String)mutex, (IJobHandler)new RptTaskExecuteHandle());
                jobList.add(job.getId());
                companyList.add(orgUnitColl.get(i).getId().toString());
                continue;
            }
            RptTaskExecuteHandle jobHandler = new RptTaskExecuteHandle();
            Job job = new Job(ctx, (IJobHandler)jobHandler, (Object)param);
            try {
                jobHandler.execute(job);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"RptWeaveSolution", (Throwable)e);
                throw new BOSException(e.getMessage(), e.getCause());
            }
        }
        this.saveTaskExecTask(ctx, jobList, companyList, year, period, RptPeriodTypeEnum.getEnum((int)periodType), taskid);
    }

    protected String getBizCode(boolean isAddNew, boolean isCalc, boolean isCheck, boolean isAudit) {
        StringBuffer bizCode = new StringBuffer();
        if (isAddNew) {
            bizCode.append(1);
        }
        if (isCalc) {
            if (isAddNew) {
                bizCode.append(",");
            }
            bizCode.append(2);
        }
        if (isCheck) {
            if (isAddNew || isCalc) {
                bizCode.append(",");
            }
            bizCode.append(6);
        }
        if (isAudit) {
            if (isAddNew || isCalc || isCheck) {
                bizCode.append(",");
            }
            bizCode.append(3);
        }
        return bizCode.toString();
    }

    private void saveTaskExecTask(Context ctx, List jobList, List companyList, int year, int period, RptPeriodTypeEnum periodType, String taskId) throws BOSException, EASBizException {
        if (jobList.size() == 0) {
            return;
        }
        ReportTaskExecuteFacadeControllerBean.deleteOldTask(ctx, taskId);
        RptTaskExecutedTaskInfo taskInfo = null;
        CoreBaseCollection baseColl = new CoreBaseCollection();
        for (int i = 0; i < jobList.size(); ++i) {
            taskInfo = new RptTaskExecutedTaskInfo();
            taskInfo.setJobinstid((String)jobList.get(i));
            taskInfo.setTaskid(taskId);
            taskInfo.setPeriodType(periodType);
            taskInfo.setYear(year);
            taskInfo.setPeriod(period);
            Calendar d = Calendar.getInstance();
            taskInfo.setCreateTime(new Timestamp(d.getTime().getTime()));
            taskInfo.setIsUsage(true);
            taskInfo.setCompanyId((String)companyList.get(i));
            baseColl.add((CoreBaseInfo)taskInfo);
        }
        RptTaskExecutedTaskFactory.getLocalInstance(ctx).addnew(baseColl);
    }

    private static void deleteOldTask(Context ctx, String taskId) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        buffer.append(" delete  T_CSL_RptTaskExecutedTask where FTaskId=? \n");
        params.add(taskId);
        DbUtil.execute(ctx, buffer.toString(), params.toArray());
    }

    private void deleteTaskExecuteLog(Context ctx, String schmId, Map paramMap) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append(" Delete From T_CSL_RptAutoWeaveLog where FrptWeaveSchmId = ?");
        if (!paramMap.containsKey("isFromSchedule") && paramMap.containsKey("FullOrgUnitCollection")) {
            FullOrgUnitCollection orgUnitColl = (FullOrgUnitCollection)paramMap.get("FullOrgUnitCollection");
            Iterator it = orgUnitColl.iterator();
            ArrayList<String> list = new ArrayList<String>();
            while (it.hasNext()) {
                FullOrgUnitInfo info = (FullOrgUnitInfo)it.next();
                list.add(info.getId().toString());
            }
            sql.append(" and Fcompanyid in (").append(CslRptUtil.list2String(list, (String)",", (boolean)true)).append(")");
        }
        params.add(schmId);
        DbUtil.execute(ctx, sql.toString(), params.toArray());
    }

    private RptAutoWeaveLogInfo addTaskExecuteLog(Context ctx, String schmId, String userId, int year, int period, int periodType, String currencyid) throws EASBizException, BOSException {
        RptAutoWeaveLogInfo log = new RptAutoWeaveLogInfo();
        log.setCompanyID(null);
        log.setTemplateId(null);
        log.setRptWeaveSchmId(schmId);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        log.setCreator(userInfo);
        log.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        log.setYear(year);
        log.setPeriod(period);
        log.setResultType(RptWeaveLogSuccEnum.EXCEUTING);
        log.setNodeType(LogNodeTypeEnum.TASKLOG);
        log.setProgress(0);
        Timestamp time = new Timestamp(System.currentTimeMillis());
        log.setStartTime(time);
        log.setEndTime(null);
        log.setError(null);
        log.setCurrencyId(currencyid);
        IObjectPK pk = RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).addnew(log);
        log.setId(BOSUuid.read((String)pk.toString()));
        return log;
    }

    private RptAutoWeaveLogInfo addCompanyExecuteLog(Context ctx, String schmId, String userId, String companyid, int year, int period, int periodType, String currencyid, String bizCode) throws EASBizException, BOSException {
        RptAutoWeaveLogInfo log = new RptAutoWeaveLogInfo();
        log.setCompanyID(companyid);
        log.setTemplateId(null);
        log.setRptWeaveSchmId(schmId);
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)userId));
        log.setCreator(userInfo);
        log.setPeriodType(RptPeriodTypeEnum.getEnum((int)periodType));
        log.setYear(year);
        log.setPeriod(period);
        log.setResultType(RptWeaveLogSuccEnum.NOSTART);
        log.setNodeType(LogNodeTypeEnum.COMPANYLOG);
        log.setStartTime(null);
        log.setEndTime(null);
        log.setError(null);
        log.setCurrencyId(currencyid);
        log.setBizCode(bizCode);
        IObjectPK pk = RptAutoWeaveLogFactory.getLocalInstance((Context)ctx).addnew(log);
        log.setId(BOSUuid.read((String)pk.toString()));
        return log;
    }

    private FullOrgUnitCollection getFullOrgUnitCollection(ReportTaskEntryCollection coll) {
        FullOrgUnitCollection orgUnitColl = new FullOrgUnitCollection();
        for (int i = 0; i < coll.size(); ++i) {
            ReportTaskEntryInfo entry = coll.get(i);
            orgUnitColl.add(entry.getUnitid());
        }
        return orgUnitColl;
    }

    private Map getTemplateCollection(ReportTaskEntryCollection coll, FullOrgUnitCollection orgUnitColl) {
        HashMap<String, TemplateCollection> tmplMap = new HashMap<String, TemplateCollection>();
        for (int j = 0; j < orgUnitColl.size(); ++j) {
            FullOrgUnitInfo fullOrgUnitInfo = orgUnitColl.get(j);
            String orgUnitId = fullOrgUnitInfo.getId().toString();
            TemplateCollection templateColl = new TemplateCollection();
            for (int i = 0; i < coll.size(); ++i) {
                ReportTaskEntryInfo entry = coll.get(i);
                String orgid = entry.getUnitid().getId().toString();
                if (!orgUnitId.equals(orgid)) continue;
                templateColl.add(entry.getTemplateid());
            }
            tmplMap.put(orgUnitId, templateColl);
        }
        return tmplMap;
    }

    private ReportTaskInfo getReportTaskInfo(Context ctx, String taskid) throws BOSException, EASBizException {
        IReportTask iReportTask = ReportTaskFactory.getLocalInstance(ctx);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo seq = new SorterItemInfo("entries.seq");
        seq.setSortType(SortType.ASCEND);
        sorter.add(seq);
        ReportTaskInfo task = (ReportTaskInfo)iReportTask.getValue((IObjectPK)new ObjectUuidPK(taskid), this.getReportTaskSelector(), sorter);
        return task;
    }

    private SelectorItemCollection getReportTaskSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("periodtype"));
        sic.add(new SelectorItemInfo("reportOperate"));
        sic.add(new SelectorItemInfo("orgType"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("dispatchPeriod"));
        sic.add(new SelectorItemInfo("currency"));
        sic.add(new SelectorItemInfo("jobProcessDef"));
        sic.add(new SelectorItemInfo("entries.unitid.id"));
        sic.add(new SelectorItemInfo("entries.unitid.number"));
        sic.add(new SelectorItemInfo("entries.unitid.name"));
        sic.add(new SelectorItemInfo("entries.unitid.LongNumber"));
        sic.add(new SelectorItemInfo("entries.unitid.CU.*"));
        sic.add(new SelectorItemInfo("entries.unitid.CU.IsCU"));
        sic.add(new SelectorItemInfo("entries.unitid.CU.isBizUnit"));
        sic.add(new SelectorItemInfo("entries.templateid.id"));
        sic.add(new SelectorItemInfo("entries.templateid.number"));
        sic.add(new SelectorItemInfo("entries.templateid.templateType"));
        return sic;
    }

    private boolean isRunningScheme(Context ctx, String schemeId) throws BOSException {
        StringBuffer sql = new StringBuffer("select top 1 fid from T_CSL_RptTaskExecutedTask task");
        sql.append(" inner join T_JOB_INST  job on task.FJobinstid=job.fjobinstid ");
        sql.append(" where task.ftaskid=? and  fstate= ?");
        Object[] params = new Object[]{schemeId, JobState.Running.toString()};
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    @Override
    protected void _rptTaskExecute(Context ctx, String taskid, String userid) throws BOSException, EASBizException {
        if (this.isRunningScheme(ctx, taskid)) {
            logger.info((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"844_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()) + taskid));
            throw new TaskExecuteException(ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource.EXECUTE_WARNING_CANNOT_DUP_EXECUTE", (Locale)ctx.getOriginLocale()));
        }
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("isFromSchedule", true);
        this.rptTaskExecuteByHand(ctx, taskid, userid, params);
    }

    @Override
    protected Map _abortTaskExecuteTask(Context ctx, String taskId) throws BOSException, EASBizException {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        RptTaskExecutedTaskCollection taskColl = this.getExecuteTaskColl(ctx, taskId);
        if (taskColl == null || taskColl.size() == 0) {
            returnMap.put("IsSuccess", "IsNoExceute");
            return returnMap;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < taskColl.size(); ++i) {
            sb.append(taskColl.get(i).getJobinstid()).append(",");
        }
        if (taskColl.size() > 0) {
            sb.delete(sb.length() - 1, sb.length());
        }
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select fjobinstid,fstate from T_JOB_INST WITH(READPAST)  \n");
        if (sb.toString().contains(",")) {
            String[] arrays = sb.toString().split(",");
            sql.append(" where fjobinstid in ( \n");
            int length = arrays.length;
            for (int i = 0; i < length; ++i) {
                sql.append("?");
                if (i < length - 1) {
                    sql.append(",");
                }
                params.add(arrays[i]);
            }
            sql.append(" ) \n");
        } else {
            sql.append(" where fjobinstid = ? \n");
            params.add(sb.toString());
        }
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        ArrayList<String> cannotAbortJobList = new ArrayList<String>();
        ArrayList<String> canAbortJobList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                String fjobinstid = rowSet.getString("fjobinstid");
                String fstate = rowSet.getString("fstate");
                if (JobState.valueOf((String)fstate).equals((Object)JobState.Running) || JobState.valueOf((String)fstate).equals((Object)JobState.Complete) || JobState.valueOf((String)fstate).equals((Object)JobState.Failed)) {
                    cannotAbortJobList.add(fjobinstid);
                    continue;
                }
                canAbortJobList.add(fjobinstid);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        int result = 0;
        if (canAbortJobList.size() > 0) {
            try {
                String[] strings = new String[canAbortJobList.size()];
                result += JobServiceFactory.getLocalInstance((Context)ctx).abort(canAbortJobList.toArray(strings));
            }
            catch (Exception e) {
                logger.warn((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.gr.cslrpt.CSLRPTAutoGenerateResource", (String)"845_RptAutoWeaveSchmRptControllerBean", (Locale)ctx.getOriginLocale()), (Throwable)e);
                returnMap.put("IsSuccess", "ExceuteError");
                return returnMap;
            }
        }
        returnMap.put("cannotAbortJobList", cannotAbortJobList);
        returnMap.put("canAbortJobList", canAbortJobList);
        if (cannotAbortJobList.size() > 0) {
            returnMap.put("IsSuccess", "false");
        } else if (canAbortJobList.size() > 0) {
            returnMap.put("IsSuccess", "true");
        } else {
            returnMap.put("IsSuccess", "IsNoExceute");
        }
        return returnMap;
    }

    private RptTaskExecutedTaskCollection getExecuteTaskColl(Context ctx, String taskId) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("jobinstid"));
        sic.add(new SelectorItemInfo("companyId"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taskid", (Object)taskId));
        filter.getFilterItems().add(new FilterItemInfo("isUsage", (Object)Boolean.TRUE));
        view.setFilter(filter);
        RptTaskExecutedTaskCollection coll = RptTaskExecutedTaskFactory.getLocalInstance(ctx).getRptTaskExecutedTaskCollection(view);
        return coll;
    }

    @Override
    protected Map _getTaskLogs(Context ctx, String taskid) throws BOSException, EASBizException {
        String locale = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT log.Fid id,case when task.Fname_" + locale + " is null then task.Fname_l2 else task.Fname_" + locale + " end taskName,log.Fcompanyid companyId,case when unit.Fname_" + locale + " is null then unit.Fname_l2 else unit.Fname_" + locale + " end companyName,tmpl.fid tmplid,tmpl.Fname tmplName,case when curr.Fname_" + locale + " is null then curr.Fname_l2 else curr.Fname_" + locale + " end currName,");
        sql.append(" log.Fyear year,log.Fperiod period,log.FresultType resultType,log.FlinkType linkType,log.Fnodetype nodeType,log.Fprogress progress,");
        sql.append(" log.FstartTime startTime,log.FendTime endTime,log.Fdetails details,log.Ferror error \n");
        sql.append(" FROM T_CSL_RptAutoWeaveLog log \n");
        sql.append(" LEFT JOIN t_csl_reporttask task ON task.Fid = log.FrptWeaveSchmId \n");
        sql.append(" LEFT JOIN t_org_baseunit unit ON unit.Fid = log.Fcompanyid \n");
        sql.append(" LEFT JOIN t_rpt_template tmpl ON tmpl.Fid = log.Ftemplateid \n");
        sql.append(" LEFT JOIN t_bd_currency curr ON curr.Fid = log.Fcurrencyid \n");
        sql.append(" WHERE log.FrptWeaveSchmId = ? \n");
        sql.append(" ORDER BY unit.fnumber,tmpl.fnumber \n");
        Object[] params = new Object[]{taskid};
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params);
        ArrayList<Map> companyList = new ArrayList<Map>();
        ArrayList<Map> templateList = new ArrayList<Map>();
        Map<String, Map> result = new HashMap();
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (rowSet.next()) {
                String companyId;
                int nodeType = rowSet.getInt("nodeType");
                Timestamp time = rowSet.getTimestamp("startTime");
                String startTime = null;
                if (time != null) {
                    startTime = simpleDateFormat.format(time);
                }
                time = rowSet.getTimestamp("endTime");
                String endTime = null;
                if (time != null) {
                    endTime = simpleDateFormat.format(time);
                }
                if (nodeType == 0) {
                    String taskName = rowSet.getString("taskName");
                    int progress = rowSet.getInt("progress");
                    int year = rowSet.getInt("year");
                    int period = rowSet.getInt("period");
                    String currency = rowSet.getString("currName");
                    Map taskMap = this.getTaskLogMap(ctx, startTime, endTime, taskName, progress, year, period, currency);
                    result.put("taskLog", taskMap);
                    continue;
                }
                if (nodeType == 1) {
                    companyId = rowSet.getString("companyId");
                    String companyName = rowSet.getString("companyName");
                    int resultType = rowSet.getInt("resultType");
                    Map companyMap = this.getCompanyLog(ctx, nodeType, startTime, endTime, companyId, companyName, resultType);
                    companyList.add(companyMap);
                    continue;
                }
                companyId = rowSet.getString("companyId");
                String tmplid = rowSet.getString("tmplid");
                String tmplName = rowSet.getString("tmplName");
                int LinkType = rowSet.getInt("linkType");
                int resultType = rowSet.getInt("resultType");
                String details = rowSet.getString("details");
                String error = rowSet.getString("error");
                Map templateMap = this.getTemplateLog(ctx, nodeType, startTime, endTime, companyId, tmplName, LinkType, resultType, details, error, taskid, tmplid);
                templateList.add(templateMap);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getTaskLogs", (Throwable)e);
        }
        result = this.getResultlog(ctx, companyList, templateList, result);
        return result;
    }

    private Map getResultlog(Context ctx, List companyList, List templateList, Map result) {
        ArrayList comboList = new ArrayList();
        for (int i = 0; i < companyList.size(); ++i) {
            Map companyMap = (Map)companyList.get(i);
            String companyid = (String)companyMap.get("companyid");
            int succeseeSize = 0;
            int failSize = 0;
            int executeSize = 0;
            int state = -1;
            ArrayList<Map> tmplList = new ArrayList<Map>();
            for (int j = 0; j < templateList.size(); ++j) {
                Map tmplMap = (Map)templateList.get(j);
                String companyid1 = (String)tmplMap.get("companyid");
                if (!companyid.equals(companyid1)) continue;
                String status = (String)tmplMap.get("status");
                if (status.equals("1")) {
                    ++succeseeSize;
                } else if (status.equals("0")) {
                    ++failSize;
                } else {
                    ++executeSize;
                }
                tmplList.add(tmplMap);
            }
            String lbSuccess = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbSuccess", (Locale)ctx.getOriginLocale());
            String lbFail = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbFail", (Locale)ctx.getOriginLocale());
            String details = lbSuccess + succeseeSize + "," + lbFail + failSize;
            companyMap.put("details", details);
            if (succeseeSize == 0) {
                state = 0;
            } else if (failSize == 0) {
                state = 1;
            } else if (succeseeSize > 0 && failSize > 0) {
                state = 2;
            } else if (executeSize > 0) {
                state = -1;
            }
            companyMap.put("status", String.valueOf(state));
            comboList.add(companyMap);
            comboList.addAll(tmplList);
        }
        result.put("queryGrid", comboList);
        return result;
    }

    private Map getTemplateLog(Context ctx, int nodeType, String startTime, String endTime, String companyId, String tmplName, int linkType, int resultType, String details, String error, String taskid, String tmplid) {
        HashMap<String, String> templateMap = new HashMap<String, String>();
        String status = null;
        String executing = RptWeaveLogSuccEnum.EXCEUTING.getAlias();
        String success = RptWeaveLogSuccEnum.SUCCESS.getAlias();
        String fail = RptWeaveLogSuccEnum.FAILED.getAlias();
        int state = -1;
        if (resultType == 1) {
            status = success;
            state = 1;
        } else if (resultType == 2) {
            status = executing;
        } else if (resultType == 0) {
            status = fail;
            state = 0;
        }
        String description = null;
        String lbSataus = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbSataus", (Locale)ctx.getOriginLocale());
        String lbStartTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbStartTime", (Locale)ctx.getOriginLocale());
        String lbEndTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbEndTime", (Locale)ctx.getOriginLocale());
        if (startTime != null && endTime == null) {
            description = lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + executing;
        } else if (resultType == 0 && linkType > 0) {
            String lbLinkType = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbLinkType", (Locale)ctx.getOriginLocale());
            description = lbSataus + status + "," + lbLinkType + RptWeaveLinkEnum.getEnum((int)linkType).getAlias() + "," + lbStartTime + startTime + "," + lbEndTime + endTime;
        } else {
            description = lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + endTime;
        }
        templateMap.put("status", String.valueOf(state));
        templateMap.put("nodeType", String.valueOf(nodeType));
        templateMap.put("node", "    " + tmplName);
        templateMap.put("companyid", companyId);
        templateMap.put("taskid", taskid);
        templateMap.put("tmplid", tmplid);
        templateMap.put("description", description);
        if (details != null) {
            templateMap.put("details", details);
        }
        if (error != null) {
            error = "<p><b>" + error + "</b></p>";
            templateMap.put("detail", error);
        }
        templateMap.put("isShow", String.valueOf("0"));
        return templateMap;
    }

    private Map getCompanyLog(Context ctx, int nodeType, String startTime, String endTime, String companyId, String companyName, int resultType) {
        HashMap<String, String> companyMap = new HashMap<String, String>();
        String status = null;
        String noStart = RptWeaveLogSuccEnum.NOSTART.getAlias();
        String executing = RptWeaveLogSuccEnum.EXCEUTING.getAlias();
        status = resultType == 1 || resultType == 0 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"log.reportStatus.is.end", (Locale)ctx.getOriginLocale()) : (resultType == 2 ? executing : noStart);
        String description = null;
        String lbSataus = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbSataus", (Locale)ctx.getOriginLocale());
        String lbStartTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbStartTime", (Locale)ctx.getOriginLocale());
        String lbEndTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbEndTime", (Locale)ctx.getOriginLocale());
        description = startTime == null ? lbSataus + status + "," + lbStartTime + noStart + "," + lbEndTime + noStart : (startTime != null && endTime == null ? lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + executing : lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + endTime);
        companyMap.put("nodeType", String.valueOf(nodeType));
        companyMap.put("companyid", companyId);
        companyMap.put("node", companyName);
        companyMap.put("description", description);
        companyMap.put("details", null);
        return companyMap;
    }

    private Map getTaskLogMap(Context ctx, String startTime, String endTime, String taskName, int progress, int year, int period, String currency) {
        String status = null;
        status = progress == 100 ? ResourceBase.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"log.reportStatus.is.end", (Locale)ctx.getOriginLocale()) : ResourceBase.getString((String)"com.kingdee.eas.fi.gr.fast.FastMergeResource", (String)"log.reportStatus.is.running", (Locale)ctx.getOriginLocale());
        String lbYear = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbYear", (Locale)ctx.getOriginLocale());
        String lbPeriod = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbPeriod", (Locale)ctx.getOriginLocale());
        String lbCurrency = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbCurrency", (Locale)ctx.getOriginLocale());
        String lbSataus = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbSataus", (Locale)ctx.getOriginLocale());
        String lbStartTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbStartTime", (Locale)ctx.getOriginLocale());
        String lbEndTime = ResourceBase.getString((String)"com.kingdee.eas.fi.newrpt.web.RptWebResource", (String)"lbEndTime", (Locale)ctx.getOriginLocale());
        String lbTitle = taskName + "(" + lbYear + year + "," + lbPeriod + period + "," + lbCurrency + currency + ")";
        String lbDes = null;
        if (endTime == null) {
            String executing = RptWeaveLogSuccEnum.EXCEUTING.getAlias();
            lbDes = lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + executing;
        } else {
            lbDes = lbSataus + status + "," + lbStartTime + startTime + "," + lbEndTime + endTime;
        }
        HashMap<String, String> taskMap = new HashMap<String, String>();
        taskMap.put("lbTitle", lbTitle);
        taskMap.put("progress", String.valueOf(progress));
        taskMap.put("lbDes", lbDes);
        return taskMap;
    }

    @Override
    protected List _getExecuteLogs(Context ctx, Map params) throws BOSException, EASBizException {
        String companyids;
        int i;
        int length;
        String schemeids;
        ArrayList<Object> param = new ArrayList<Object>();
        List result = new ArrayList();
        String locale = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT task.Fid schemeid,task.Fnumber schemeNumber,case when task.Fname_" + locale + " is null then task.Fname_l2 else task.Fname_" + locale + " end schemeName,task.freportoperate typeNumber,log.FBizCode schemeOp,log.Fcompanyid companyid,case when unit.Fname_" + locale + " is null then unit.Fname_l2 else unit.Fname_" + locale + " end companyName,");
        sql.append(" log.FresultType resultType,log.FstartTime startTime,log.FendTime endTime,log.Fnodetype nodeType,u.FName_" + locale + " excutor \n");
        sql.append(" FROM T_CSL_RptAutoWeaveLog log \n");
        sql.append(" INNER JOIN t_csl_reporttask task ON task.Fid = log.FrptWeaveSchmId \n");
        sql.append(" INNER JOIN t_org_baseunit unit ON unit.Fid = log.Fcompanyid \n");
        sql.append(" INNER JOIN T_PM_User u ON u.Fid = log.FLastUpdateUserId \n");
        sql.append(" WHERE task.FCreateOrgUnitId= ? and task.freportoperate in (?,?) And log.Fnodetype in (1,2) \n");
        String currentOrgUnitid = ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString();
        param.add(currentOrgUnitid);
        param.add(1);
        param.add(2);
        if (params.containsKey("schemeids") && !StringUtils.isEmpty((String)(schemeids = (String)params.get("schemeids")))) {
            if (schemeids.contains(",")) {
                sql.append(" And task.Fid in ( ");
                String[] schemeArray = schemeids.split(",");
                length = schemeArray.length;
                for (i = 0; i < length; ++i) {
                    if (StringUtils.isEmpty((String)schemeArray[i])) continue;
                    sql.append("?");
                    if (i < length - 1) {
                        sql.append(",");
                    }
                    param.add(schemeArray[i]);
                }
                sql.append(" ) \n");
            } else {
                sql.append(" And task.Fid = ? \n");
                param.add(schemeids);
            }
        }
        if (params.containsKey("companyids") && !StringUtils.isEmpty((String)(companyids = (String)params.get("companyids")))) {
            if (companyids.contains(",")) {
                sql.append(" And log.Fcompanyid in ( ");
                String[] companyArray = companyids.split(",");
                length = companyArray.length;
                for (i = 0; i < length; ++i) {
                    if (StringUtils.isEmpty((String)companyArray[i])) continue;
                    sql.append("?");
                    if (i < length - 1) {
                        sql.append(",");
                    }
                    param.add(companyArray[i]);
                }
                sql.append(" ) \n");
            } else {
                sql.append(" And log.Fcompanyid = ? \n");
                param.add(companyids);
            }
        }
        sql.append(" ORDER BY task.Fnumber,unit.fnumber \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), param.toArray());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            ArrayList<Map> companys = new ArrayList<Map>();
            ArrayList<Map> templates = new ArrayList<Map>();
            while (rowSet.next()) {
                int nodeType = rowSet.getInt("nodeType");
                if (nodeType == 1) {
                    companys.add(this.getCompanyMap(rowSet, simpleDateFormat));
                    continue;
                }
                if (nodeType != 2) continue;
                templates.add(this.getTemplateMap(rowSet));
            }
            result = this.getShowResult(companys, templates);
        }
        catch (SQLException e) {
            logger.error((Object)"_getExecuteLogs: ", (Throwable)e);
        }
        return result;
    }

    private List getShowResult(List<Map> companys, List<Map> templates) {
        if (companys != null && companys.size() > 0) {
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                Map comMap = companys.get(i);
                String companyid = (String)comMap.get("companyid");
                String schemeid = (String)comMap.get("schemeid");
                int success = 0;
                int fail = 0;
                int length = templates.size();
                for (int j = 0; j < length; ++j) {
                    Map tmplMap = templates.get(j);
                    String comid = (String)tmplMap.get("companyid");
                    String schmid = (String)tmplMap.get("schemeid");
                    if (!companyid.equals(comid) || !schemeid.equals(schmid)) continue;
                    int resultType = Integer.valueOf(tmplMap.get("resultType").toString());
                    if (resultType == 1) {
                        ++success;
                        continue;
                    }
                    if (resultType != 0) continue;
                    ++fail;
                }
                String status = success + "," + fail;
                comMap.put("status", status);
            }
        }
        return companys;
    }

    private Map getTemplateMap(IRowSet rowSet) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemeid", rowSet.getString("schemeid"));
        map.put("companyid", rowSet.getString("companyid"));
        map.put("resultType", rowSet.getInt("resultType"));
        return map;
    }

    private Map getCompanyMap(IRowSet rowSet, SimpleDateFormat simpleDateFormat) throws SQLException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("schemeid", rowSet.getString("schemeid"));
        map.put("schemeNumber", rowSet.getString("schemeNumber"));
        map.put("schemeName", rowSet.getString("schemeName"));
        map.put("typeNumber", rowSet.getInt("typeNumber"));
        map.put("schemeType", ReportOperateEnum.getEnum(rowSet.getInt("typeNumber")).getAlias());
        map.put("companyid", rowSet.getString("companyid"));
        map.put("companyName", rowSet.getString("companyName"));
        Timestamp time = rowSet.getTimestamp("startTime");
        String startTime = null;
        if (time != null) {
            startTime = simpleDateFormat.format(time);
        }
        map.put("startTime", startTime);
        time = rowSet.getTimestamp("endTime");
        String endTime = null;
        if (time != null) {
            endTime = simpleDateFormat.format(time);
        }
        map.put("endTime", endTime);
        if (!StringUtils.isEmpty((String)rowSet.getString("schemeOp"))) {
            String schemeOp = rowSet.getString("schemeOp");
            if (schemeOp.indexOf(",") != -1) {
                String[] strs = schemeOp.split(",");
                StringBuffer ops = new StringBuffer();
                for (int i = 0; i < strs.length; ++i) {
                    int value = Integer.valueOf(strs[i]);
                    String operate = SchemeOperate.getEnum(value).getAlias();
                    ops.append(operate);
                    if (i != strs.length - 1) {
                        ops.append("\uff0c");
                    }
                    map.put("schemeOp", ops.toString());
                }
            } else {
                map.put("schemeOp", SchemeOperate.getEnum(Integer.valueOf(schemeOp)).getAlias());
            }
        } else {
            map.put("schemeOp", rowSet.getString("schemeOp"));
        }
        map.put("excutor", rowSet.getString("excutor"));
        return map;
    }

    @Override
    protected List _getExcuteTemplateLog(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<Object> param = new ArrayList<Object>();
        ArrayList result = new ArrayList();
        String locale = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        try {
            String templateids;
            String resultType;
            sql.append(" SELECT task.Fid schemeid,case when task.Fname_" + locale + " is null then task.Fname_l2 else task.Fname_" + locale + " end schemeName,unit.Fid companyid,case when unit.Fname_" + locale + " is null then unit.Fname_l2 else unit.Fname_" + locale + " end companyName,");
            sql.append(" log.FresultType resultType,log.FstartTime startTime,log.FendTime endTime,tmpl.Fid tmplid,tmpl.FNumber tmplNumber,tmpl.FName tmplName,log.FDetails details,log.FError error \n");
            sql.append(" FROM T_CSL_RptAutoWeaveLog log \n");
            sql.append(" INNER JOIN t_csl_reporttask task ON task.Fid = log.FrptWeaveSchmId \n");
            sql.append(" Inner Join T_Rpt_Template tmpl On log.FTemplateId = tmpl.Fid \n");
            sql.append(" INNER JOIN t_org_baseunit unit ON unit.Fid = log.Fcompanyid \n");
            sql.append(" WHERE log.FRptWeaveSchmId = ? And log.FcompanyID = ? And log.Fnodetype = ? \n");
            String schemeid = (String)params.get("schemeid");
            String companyid = (String)params.get("companyid");
            param.add(schemeid);
            param.add(companyid);
            param.add(2);
            if (params.containsKey("status") && !StringUtils.isEmpty((String)(resultType = (String)params.get("status")))) {
                sql.append(" And log.FresultType = ? \n");
                param.add(Integer.valueOf(resultType));
            }
            if (params.containsKey("templateids") && !StringUtils.isEmpty((String)(templateids = (String)params.get("templateids")))) {
                if (templateids.contains(",")) {
                    sql.append(" And log.FTemplateId in ( ");
                    String[] tmplArray = templateids.split(",");
                    int length = tmplArray.length;
                    for (int i = 0; i < length; ++i) {
                        if (StringUtils.isEmpty((String)tmplArray[i])) continue;
                        sql.append("?");
                        if (i < length - 1) {
                            sql.append(",");
                        }
                        param.add(tmplArray[i]);
                    }
                    sql.append(" ) \n");
                } else {
                    sql.append(" And log.FTemplateId = ? \n");
                    param.add(templateids);
                }
            }
            sql.append(" Order By  tmpl.FNumber \n");
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), param.toArray());
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            while (rowSet.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("schemeid", rowSet.getString("schemeid"));
                map.put("schemeName", rowSet.getString("schemeName"));
                map.put("companyid", rowSet.getString("companyid"));
                map.put("companyName", rowSet.getString("companyName"));
                map.put("tmplid", rowSet.getString("tmplid"));
                map.put("tmplNumber", rowSet.getString("tmplNumber"));
                map.put("tmplName", rowSet.getString("tmplName"));
                String error = rowSet.getString("error");
                if (error != null) {
                    error = "<p><b>" + error + "</b></p>";
                    map.put("error", error);
                }
                Timestamp time = rowSet.getTimestamp("startTime");
                String startTime = null;
                if (time != null) {
                    startTime = simpleDateFormat.format(time);
                }
                map.put("startTime", startTime);
                time = rowSet.getTimestamp("endTime");
                String endTime = null;
                if (time != null) {
                    endTime = simpleDateFormat.format(time);
                }
                map.put("endTime", endTime);
                int resultType2 = rowSet.getInt("resultType");
                String details = rowSet.getString("details");
                String logResult = null;
                if (resultType2 == 1) {
                    logResult = RptWeaveLogSuccEnum.SUCCESS.getAlias(ctx.getLocale());
                } else if (resultType2 == 0) {
                    logResult = RptWeaveLogSuccEnum.FAILED.getAlias(ctx.getLocale());
                } else if (resultType2 == 2) {
                    logResult = RptWeaveLogSuccEnum.EXCEUTING.getAlias(ctx.getLocale());
                }
                if (!StringUtils.isEmpty((String)details)) {
                    logResult = logResult + "\uff1a" + details;
                }
                map.put("details", logResult);
                result.add(map);
            }
        }
        catch (Exception e) {
            logger.error((Object)"_getExcuteTemplateLog: ", (Throwable)e);
        }
        return result;
    }

    @Override
    protected List _getTemplateByExcuteLogs(Context ctx, Map params) throws BOSException, EASBizException {
        ArrayList<String> param = new ArrayList<String>();
        ArrayList result = new ArrayList();
        String locale = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        String schemeid = (String)params.get("schemeid");
        String companyid = (String)params.get("companyid");
        sql.append("Select tmpl.Fid tmplid,tmpl.FNumber tmplNumber,tmpl.FName tmplName \n");
        sql.append(" FROM T_CSL_RptAutoWeaveLog log \n");
        sql.append(" Inner Join T_Rpt_Template tmpl On log.FTemplateId = tmpl.Fid \n");
        sql.append(" WHERE log.FRptWeaveSchmId = ? And log.FcompanyID = ?");
        param.add(schemeid);
        param.add(companyid);
        sql.append(" Order By tmpl.FNumber \n");
        try {
            IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), param.toArray());
            while (rowSet.next()) {
                String id = rowSet.getString("tmplid");
                String number = rowSet.getString("tmplNumber");
                String name = rowSet.getString("tmplName");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", id);
                map.put("number", number);
                map.put("name", name);
                result.add(map);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getTemplateByExcuteLogs: ", (Throwable)e);
        }
        return result;
    }

    @Override
    protected String _getDetail(Context ctx, Map param) throws BOSException, EASBizException {
        ArrayList<String> params = new ArrayList<String>();
        String schemeid = (String)param.get("schemeid");
        String companyid = (String)param.get("companyid");
        String tmplid = (String)param.get("tmplid");
        StringBuffer sql = new StringBuffer();
        sql.append(" Select FError error \n");
        sql.append(" From T_CSL_RptAutoWeaveLog \n");
        sql.append(" Where FRptWeaveSchmId = ? And FcompanyID = ? And FTemplateId = ?");
        params.add(schemeid);
        params.add(companyid);
        params.add(tmplid);
        IRowSet rowSet = DbUtil.executeQuery(ctx, sql.toString(), params.toArray());
        String error = null;
        try {
            while (rowSet.next()) {
                error = "<p><b>" + rowSet.getString("error") + "</b></p>";
            }
        }
        catch (SQLException e) {
            logger.error((Object)"_getDetail: ", (Throwable)e);
        }
        return error;
    }
}

