/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.app.XmlTrans;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCardException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportBatchCalculatorImpl;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.nlm.FlContrastSolutionCollection;
import com.kingdee.eas.fi.nlm.FlContrastSolutionFactory;
import com.kingdee.eas.fi.nlm.FlContrastSolutionInfo;
import com.kingdee.eas.fi.nlm.IFlContrastSolution;
import com.kingdee.eas.fi.nlm.app.AbstractFlContrastCaclControllerBean;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FlContrastCaclControllerBean
extends AbstractFlContrastCaclControllerBean {
    private static final long serialVersionUID = 8534534964948759690L;
    BigDecimal zeroValue = new BigDecimal("0");
    private static Logger logger = Logger.getLogger(FlContrastCaclControllerBean.class);
    private static String sumBegin = "sumBegin";
    private static String sumDebit = "sumDebit";
    private static String sumCredit = "sumCredit";
    private static String sumEnd = "sumEnd";
    private static String sumRealBeginBalance = "sumRealBeginBalance";
    private static String sumRealDebit = "sumRealDebit";
    private static String sumRealCredit = "sumRealCredit";
    private static String sumRealEndBalance = "sumRealEndBalance";
    private static String sumDepreBeginBalanceFor = sumBegin + "_DEPRE_ASSET";
    private static String sumDepreDebitFor = sumDebit + "_DEPRE_ASSET";
    private static String sumDepreCreditFor = sumCredit + "_DEPRE_ASSET";
    private static String sumDepreEndBalanceFor = sumEnd + "_DEPRE_ASSET";
    private static String sumDecValueBeginBalanceFor = sumBegin + "_DECVALUE_ASSET";
    private static String sumDecValueDebitFor = sumDebit + "_DECVALUE_ASSET";
    private static String sumDecValueCreditFor = sumCredit + "_DECVALUE_ASSET";
    private static String sumDecValueEndBalanceFor = sumEnd + "_DECVALUE_ASSET";
    private HashMap topAccountMap = null;
    private boolean isGetLastPeriodData = false;

    private boolean isAssetAccountDebit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap assetAccount = (HashMap)accountMap.get("ASSET");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (assetAccount != null && (items = assetAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == 1;
        }
        return true;
    }

    private boolean isDecAccountCredit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap decAccount = (HashMap)accountMap.get("DECVALUE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (decAccount != null && (items = decAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == -1;
        }
        return true;
    }

    private boolean isDepreAccountCredit(Context ctx, HashMap accountMap) throws BOSException, EASBizException {
        Iterator items;
        HashMap depreAccount = (HashMap)accountMap.get("DEPRE");
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        if (depreAccount != null && (items = depreAccount.values().iterator()).hasNext()) {
            AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()));
            return account.getDC().getValue() == -1;
        }
        return true;
    }

    @Override
    protected boolean _isAcctEquals(Context ctx, String companyID, PeriodInfo periodInfo) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)new ObjectUuidPK(companyID));
        if (startPeriod == null) {
            String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.rpt.FaRptResource.notConfigStartPeriod", (Locale)ctx.getOriginLocale());
            throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
        }
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(ctx, companyID));
        if (parameter != null) {
            boolean isIncludeUnposted = parameter.get("isIncludeUnposted") != null ? Boolean.valueOf((String)parameter.get("isIncludeUnposted")) : false;
            PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)new ObjectUuidPK(companyID));
            if (periodInfo != null && periodInfo.getNumber() > currentPeriodInfo.getNumber()) {
                String strMsg = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"57_FlContrastCaclControllerBean", (Locale)ctx.getLocale());
                throw new EASBizException(new NumericExceptionSubItem("001", strMsg));
            }
            PeriodInfo period = periodInfo == null ? currentPeriodInfo : periodInfo;
            HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
            HashMap searcHashMap = this._faAcctDetail(ctx, companyID, accountMap, isIncludeUnposted, period.getPeriodYear(), period.getPeriodNumber());
            ArrayList accountArrayList = (ArrayList)searcHashMap.get("AccountMap");
            for (int i = 0; i < accountArrayList.size(); ++i) {
                List accountList = (List)accountArrayList.get(i);
                int size = accountList.size();
                for (int j = 0; j < size; ++j) {
                    String PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
                    AccountViewInfo accountInfo = (AccountViewInfo)accountList.get(j);
                    String[] colNamePrefix = new String[]{"sumEnd"};
                    int colSize = colNamePrefix.length;
                    for (int k = 0; k < colSize; ++k) {
                        BigDecimal valueAsset = (BigDecimal)searcHashMap.get(PREFIX + colNamePrefix[k] + "_ASSET_" + accountInfo.getNumber());
                        BigDecimal valueGl = (BigDecimal)searcHashMap.get(PREFIX + colNamePrefix[k] + "_GL_" + accountInfo.getNumber());
                        if (valueGl == null || valueAsset == null || valueGl.compareTo(valueAsset) == 0) continue;
                        return false;
                    }
                }
            }
        } else {
            throw new FaCardException(FaCardException.NO_DEFAULT_SOLUTION);
        }
        return true;
    }

    private PeriodInfo getPrePeriod(Context ctx, String companyID) throws BOSException, EASBizException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (IObjectPK)new ObjectUuidPK(companyID));
        return startPeriod == null ? new PeriodInfo() : startPeriod;
    }

    private HashMap getDefaultSolution(QuerySolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            QuerySolutionInfo querySolutionInfo = collection.get(i);
            QueryPanelCollection queryPanelCollection = querySolutionInfo.getQueryPanelInfo();
            for (int j = 0; j < queryPanelCollection.size(); ++j) {
                QueryPanelInfo queryPanelInfo = queryPanelCollection.get(j);
                String params = queryPanelInfo.getCustomerParams();
                if (params == null) continue;
                try {
                    boolean isDefaultSolution;
                    HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                    boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                    if (!isDefaultSolution) continue;
                    return loadInfo;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return null;
    }

    private FlContrastSolutionCollection getContrastSolutions(Context ctx, String companyID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IFlContrastSolution isolution = FlContrastSolutionFactory.getLocalInstance(ctx);
        return isolution.getFlContrastSolutionCollection(entityViewInfo);
    }

    private HashMap getDefaultContrastSolution(FlContrastSolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            FlContrastSolutionInfo solutionInfo = collection.get(i);
            String params = solutionInfo.getParams();
            if (params == null) continue;
            try {
                boolean isDefaultSolution;
                HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                if (!isDefaultSolution) continue;
                return loadInfo;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public static Object getObject(byte[] bytes) {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
        }
        return object;
    }

    protected String parseAccountString(String account) {
        return account + "";
    }

    protected HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, HashMap accountMap, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        GlUtils.updateBalance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        BigDecimal c_value = this.zeroValue;
        BigDecimal y_value = this.zeroValue;
        BigDecimal jf_value = this.zeroValue;
        BigDecimal df_value = this.zeroValue;
        Set accountMapSet = accountMap.keySet();
        IAccountView accountView = AccountViewFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        for (int setCount = 0; setCount < accountMapSet.size(); ++setCount) {
            HashMap accountList = (HashMap)accountMap.get(accountMapSet.toArray()[setCount]);
            if (accountList == null) continue;
            c_value = this.zeroValue;
            y_value = this.zeroValue;
            jf_value = this.zeroValue;
            df_value = this.zeroValue;
            Iterator items = accountList.values().iterator();
            while (items.hasNext()) {
                AccountViewInfo account = accountView.getAccountViewInfo((IObjectPK)new ObjectUuidPK((String)items.next()), sic);
                HashMap sum = this.searchGLBalance(ctx, companyOrg, account, periodYear, periodNumber, isIncludeUnposted);
                c_value = c_value.add(sum.get(sumBegin + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumBegin + "_GL_" + account.getNumber()) : this.zeroValue);
                y_value = y_value.add(sum.get(sumEnd + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumEnd + "_GL_" + account.getNumber()) : this.zeroValue);
                jf_value = jf_value.add(sum.get(sumDebit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumDebit + "_GL_" + account.getNumber()) : this.zeroValue);
                df_value = df_value.add(sum.get(sumCredit + "_GL_" + account.getNumber()) != null ? (BigDecimal)sum.get(sumCredit + "_GL_" + account.getNumber()) : this.zeroValue);
            }
            result.put(sumBegin + "_" + accountMapSet.toArray()[setCount] + "_GL", c_value);
            result.put(sumDebit + "_" + accountMapSet.toArray()[setCount] + "_GL", jf_value);
            result.put(sumCredit + "_" + accountMapSet.toArray()[setCount] + "_GL", df_value);
            result.put(sumEnd + "_" + accountMapSet.toArray()[setCount] + "_GL", y_value);
        }
        return result;
    }

    private HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, AccountViewInfo account, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        String foreignCurrencySU;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (this.isGetLastPeriodData) {
            return result;
        }
        String currency = "GLC";
        HashMap hmResult = FaManageUtils.getFAParameter((Context)ctx, (String[])new String[]{"GL_008"}, (String)companyOrg.getId().toString());
        String string = foreignCurrencySU = hmResult != null && hmResult.get("GL_008") != null ? (String)hmResult.get("GL_008") : "false";
        if ("true".equalsIgnoreCase(foreignCurrencySU)) {
            CompanyOrgUnitInfo curCompanyInfo = FaManageUtils.getCurrentCompany((Context)ctx, (String)companyOrg.getId().toString());
            currency = curCompanyInfo.getBaseCurrency().getNumber();
        }
        result.put(sumBegin + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.C, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumEnd + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.Y, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumDebit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.JF, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        result.put(sumCredit + "_GL_" + account.getNumber(), reportCacl.acct(companyOrg.getNumber(), this.parseAccountString(account.getNumber()), BalanceTypeEnum.DF, periodYear, periodNumber, periodYear, periodNumber, currency, false, isIncludeUnposted, false));
        return result;
    }

    private HashMap searchGLBalance(Context ctx, CompanyOrgUnitInfo companyOrg, AccountViewCollection accounts, int periodYear, int periodNumber, boolean isIncludeUnposted) throws BOSException, EASBizException {
        String foreignCurrencySU;
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        SortedParameterArray acctParams = new SortedParameterArray();
        HashMap<String, Parameter> calcResult = new HashMap<String, Parameter>();
        String currency = "GLC";
        HashMap hmResult = FaManageUtils.getFAParameter((Context)ctx, (String[])new String[]{"GL_008"}, (String)companyOrg.getId().toString());
        String string = foreignCurrencySU = hmResult != null && hmResult.get("GL_008") != null ? (String)hmResult.get("GL_008") : "false";
        if ("true".equalsIgnoreCase(foreignCurrencySU)) {
            CompanyOrgUnitInfo curCompanyInfo = FaManageUtils.getCurrentCompany((Context)ctx, (String)companyOrg.getId().toString());
            currency = curCompanyInfo.getBaseCurrency().getNumber();
        }
        for (int i = 0; i < accounts.size(); ++i) {
            AccountViewInfo account = accounts.get(i);
            ArrayList<Variant> params = new ArrayList<Variant>();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.C));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            Parameter parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumBegin + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.Y));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumEnd + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.JF));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumDebit + "_GL_" + account.getNumber(), parameter);
            params = new ArrayList();
            params.add(new Variant((Object)companyOrg.getNumber()));
            params.add(new Variant((Object)this.parseAccountString(account.getNumber())));
            params.add(new Variant((Object)BalanceTypeEnum.DF));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant(periodYear));
            params.add(new Variant(periodNumber));
            params.add(new Variant((Object)currency));
            parameter = new Parameter(params.toArray(), "sheet1", false);
            acctParams.insert((Object)parameter);
            calcResult.put(sumCredit + "_GL_" + account.getNumber(), parameter);
        }
        ReportBatchCalculatorImpl calculater = new ReportBatchCalculatorImpl();
        ReportCalculateContext rptCalculater = new ReportCalculateContext(ctx);
        rptCalculater.setReportAdapter(new IReportPropertyAdapter(){
            private static final long serialVersionUID = 4036444267715695636L;

            public Object getReportProperty(String name) {
                return null;
            }

            public void initReportProperties(IObjectValue vo, Context ctx) {
            }
        });
        ReportVariables variables = new ReportVariables();
        if (isIncludeUnposted) {
            variables.add(VariablesHelper.createReservedEntry((String)"IncludePosted", (String)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"75_FaContrastCaclControllerBean", (Locale)ctx.getOriginLocale()), (String)"sheet1", (String)"Y", (int)1));
        } else {
            variables.add(VariablesHelper.createReservedEntry((String)"IncludePosted", (String)ResourceBase.getString((String)"com.kingdee.eas.fi.fa.manage.MANAGEAutoGenerateResource", (String)"75_FaContrastCaclControllerBean", (Locale)ctx.getOriginLocale()), (String)"sheet1", (String)"N", (int)1));
        }
        rptCalculater.setReportVariables(variables);
        rptCalculater.setErrorProvider(new IErrorProvider(){

            public Variant getProperValue(Exception e) {
                return new Variant((Object)e);
            }
        });
        calculater.batchMethodQuery((ICalculateContextProvider)rptCalculater, "acct", acctParams);
        for (String key : calcResult.keySet()) {
            Parameter parameter = (Parameter)calcResult.get(key);
            Object val = parameter.getValue();
            if (val instanceof Exception) {
                throw new BOSException((Throwable)((Exception)val));
            }
            BigDecimal v = null;
            try {
                v = new BigDecimal(val.toString());
            }
            catch (Exception ex) {
                v = new BigDecimal(0.0);
            }
            result.put(key, v);
        }
        return result;
    }

    @Override
    protected HashMap _faAcctDetail(Context ctx, String companyId, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber) throws BOSException, EASBizException {
        if (this.topAccountMap == null) {
            this.topAccountMap = new HashMap(accountMap);
        }
        HashMap result = this.faAcctDetailData(ctx, companyId, accountMap, isIncludeUnposted, periodYear, periodNumber);
        PeriodInfo startPeriodInfo = this.getPrePeriod(ctx, companyId);
        int startYear = startPeriodInfo.getPeriodYear();
        int startNumber = startPeriodInfo.getPeriodNumber();
        if (startYear != periodYear || startNumber != periodNumber) {
            PeriodTypeInfo periodTypeInfo = startPeriodInfo.getPeriodType();
            IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
            PeriodInfo curPeriodInfo = iPeriod.getPeriodInfo(periodYear, periodNumber, periodTypeInfo);
            PeriodInfo lastPeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)curPeriodInfo);
            if (lastPeriodInfo != null) {
                int lastYear = lastPeriodInfo.getPeriodYear();
                int lastNumber = lastPeriodInfo.getPeriodNumber();
                HashMap accountHashMap = new HashMap(this.topAccountMap);
                HashMap lastResult = this.faAcctDetailData(ctx, companyId, accountHashMap, isIncludeUnposted, lastYear, lastNumber);
                result = this.replaceBegin(result, lastResult);
            }
        }
        return result;
    }

    protected HashMap faAcctDetailData(Context ctx, String companyId, HashMap accountMap, boolean isIncludeUnposted, int periodYear, int periodNumber) throws BOSException, EASBizException {
        int number;
        Set s;
        List accountList;
        String PREFIX;
        int i;
        GlUtils.updateBalance((Context)ctx);
        LinkedHashMap<String, Serializable> result = new LinkedHashMap<String, Serializable>();
        CompanyOrgUnitInfo companyOrg = FaManageUtils.getCurrentCompany((Context)ctx, (String)companyId);
        CurrencyInfo currency = companyOrg.getBaseCurrency();
        int currencyScale = currency == null ? 2 : currency.getPrecision();
        HashMap sumGL = new HashMap();
        HashMap sumFA = new HashMap();
        boolean isAssetDebit = this.isAssetAccountDebit(ctx, accountMap);
        boolean isDecCredit = this.isDecAccountCredit(ctx, accountMap);
        boolean isDepreCredit = this.isDepreAccountCredit(ctx, accountMap);
        this.getAllChildAccount(ctx, accountMap, companyOrg);
        ArrayList list = new ArrayList();
        list.add(accountMap.get("ASSET"));
        list.add(accountMap.get("DEPRE"));
        list.add(accountMap.get("DECVALUE"));
        for (i = 0; i < list.size(); ++i) {
            PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
            accountList = (List)list.get(i);
            Iterator items = accountList.iterator();
            AccountViewCollection accounts = new AccountViewCollection();
            while (items.hasNext()) {
                accounts.add((AccountViewInfo)items.next());
            }
            sumGL = this.searchGLBalance(ctx, companyOrg, accounts, periodYear, periodNumber, isIncludeUnposted);
            s = sumGL.keySet();
            for (number = 0; number < s.size(); ++number) {
                result.put(PREFIX + s.toArray()[number], ((BigDecimal)sumGL.get(s.toArray()[number])).setScale(currencyScale, 4));
            }
        }
        for (i = 0; i < list.size(); ++i) {
            PREFIX = i == 0 ? "ASSET_" : (i == 1 ? "DECVALUE_" : "DEPRE_");
            accountList = (List)list.get(i);
            for (AccountViewInfo account : accountList) {
                sumFA = this.searchAssetBalance(ctx, currency.getId().toString(), companyOrg.getId().toString(), periodYear, periodNumber, account, i);
                s = sumFA.keySet();
                for (number = 0; number < s.size(); ++number) {
                    BigDecimal v;
                    String key = (String)s.toArray()[number];
                    BigDecimal value = (BigDecimal)sumFA.get(s.toArray()[number]);
                    if ((key.equalsIgnoreCase("sumBegin_ASSET_ASSET") || key.equalsIgnoreCase("sumEnd_ASSET_ASSET")) && !isAssetDebit || (key.equalsIgnoreCase("sumBegin_DEPRE_ASSET") || key.equalsIgnoreCase("sumEnd_DEPRE_ASSET")) && !isDepreCredit || (key.equalsIgnoreCase("sumBegin_DECVALUE_ASSET") || key.equalsIgnoreCase("sumEnd_DECVALUE_ASSET")) && !isDecCredit) {
                        if (result.containsKey(PREFIX + key)) {
                            v = (BigDecimal)((HashMap)result).get(PREFIX + key);
                            result.put(PREFIX + key, v.add(value.negate().setScale(currencyScale, 4)));
                            continue;
                        }
                        result.put(PREFIX + key, value.negate().setScale(currencyScale, 4));
                        continue;
                    }
                    if (result.containsKey(PREFIX + key)) {
                        v = (BigDecimal)((HashMap)result).get(PREFIX + key);
                        result.put(PREFIX + key, v.add(value.setScale(currencyScale, 4)));
                        continue;
                    }
                    result.put(PREFIX + key, value.setScale(currencyScale, 4));
                }
            }
        }
        result.put("AccountMap", list);
        return result;
    }

    private void getAllChildAccount(Context ctx, HashMap accountMap, CompanyOrgUnitInfo companyOrg) throws BOSException, EASBizException {
        AccountViewInfo _acct;
        String id;
        Comparator comparator = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                AccountViewInfo v1 = (AccountViewInfo)arg0;
                AccountViewInfo v2 = (AccountViewInfo)arg1;
                return v1.getLongNumber().compareTo(v2.getLongNumber());
            }
        };
        HashMap assetAccount = (HashMap)accountMap.get("ASSET");
        HashMap decAccount = (HashMap)accountMap.get("DECVALUE");
        HashMap depreAccount = (HashMap)accountMap.get("DEPRE");
        String fi = companyOrg.getId().toString();
        String accountTable = companyOrg.getAccountTable().getId().toString();
        IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewCollection accts = new AccountViewCollection();
        for (Map.Entry entry : assetAccount.entrySet()) {
            String id2 = (String)entry.getValue();
            AccountViewInfo _acct2 = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id2));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "' and accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct2.getLongNumber() + "' or longNumber like '" + _acct2.getLongNumber() + "!%')"));
        }
        List<Object> list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("ASSET", list);
        accts = new AccountViewCollection();
        for (Map.Entry entry : decAccount.entrySet()) {
            id = (String)entry.getValue();
            _acct = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "'  and accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct.getLongNumber() + "' or longNumber like '" + _acct.getLongNumber() + "!%')"));
        }
        list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("DECVALUE", list);
        accts = new AccountViewCollection();
        for (Map.Entry entry : depreAccount.entrySet()) {
            id = (String)entry.getValue();
            _acct = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(id));
            accts.addCollection(iAcct.getAccountViewCollection("select id,number,name,longnumber,longName where companyID.id='" + fi + "' and  accountTableID.id = '" + accountTable + "' and (longNumber like '" + _acct.getLongNumber() + "' or longNumber like '" + _acct.getLongNumber() + "!%')"));
        }
        list = Arrays.asList(accts.toArray());
        Collections.sort(list, comparator);
        accountMap.put("DEPRE", list);
    }

    private HashMap searchAssetBalance(Context ctx, String currencyId, String companyId, int periodYear, int periodNumber, AccountViewInfo acct, int acctIndex) throws BOSException, EASBizException {
        StringBuffer s = new StringBuffer();
        s.append("select SUM(NLM.FOpeningBalanceForAsset) sumRealBeginBalance,        ");
        s.append("       SUM(NLM.FCurrentBorrowingForAsset) sumRealDebit,    ");
        s.append("       SUM(NLM.FCurrentLoanForAsset) sumRealCredit,                      ");
        s.append("       SUM(NLM.FEndingBalanceForAsset) sumRealEndBalance,                  ");
        s.append("       SUM(NLM.FOpeningBalanceForDep) sumBegin_DEPRE_ASSET,                    ");
        s.append("       SUM(NLM.FCurrentBorrowingForDep) sumDebit_DEPRE_ASSET,                ");
        s.append("       SUM(NLM.FCurrentLoanForDep) sumCredit_DEPRE_ASSET,            ");
        s.append("       SUM(NLM.FEndingBalanceForDep) sumEnd_DEPRE_ASSET,        ");
        s.append("       SUM(NLM.FOpeningBalanceForDec) sumBegin_DECVALUE_ASSET,              ");
        s.append("       SUM(NLM.FCurrentBorrowingForDec) sumDebit_DECVALUE_ASSET,           ");
        s.append("       SUM(NLM.FCurrentLoanForDec) sumCredit_DECVALUE_ASSET,          ");
        s.append("       SUM(NLM.FEndingBalanceForDec) sumEnd_DECVALUE_ASSET ");
        s.append("  from T_NLM_NLMAccountBalance NLM,                                ");
        s.append("       T_Bd_Period           Pd,                                ");
        s.append("       t_fa_faleaseinbillnew        leaseBill,                              ");
        s.append("       T_FA_FACONTRACTCat     Cat,                              ");
        s.append("       t_Bd_Accountview      Acct                               ");
        s.append(" where NLM.FPeriodID = Pd.FID                                    ");
        s.append("   and Pd.FPeriodYear = ?                                       ");
        s.append("   and Pd.FPeriodNumber = ?                                     ");
        s.append("   and NLM.FCompanyID = ?                                 ");
        s.append("   and NLM.FCurrencyID = ?                                       ");
        s.append("   and NLM.FLeaseInBillID = leaseBill.FID                               ");
        s.append("   and leaseBill.FCONTRACTCatID=Cat.FID                               ");
        if (acctIndex == 0) {
            s.append("   and Cat.FUSUFRUCTASSETACCTID = Acct.Fid                          ");
        } else if (acctIndex == 1) {
            s.append("   and Cat.FUSUFRUCTASSETACCTACMID = Acct.Fid                       ");
        } else {
            s.append("   and Cat.FUSUFRUCTASSETACCTDECID = Acct.fid                       ");
        }
        s.append("   and (Acct.Flongnumber = ? or Acct.Flongnumber like ?)        ");
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        try {
            ArrayList<Object> para = new ArrayList<Object>();
            para.add(new Integer(periodYear));
            para.add(new Integer(periodNumber));
            para.add(companyId);
            para.add(currencyId);
            para.add(acct.getLongNumber());
            para.add(acct.getLongNumber() + "!%");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)s.toString(), (Object[])para.toArray());
            String[] field = new String[]{sumRealBeginBalance, sumRealDebit, sumRealCredit, sumRealEndBalance, sumDepreBeginBalanceFor, sumDepreDebitFor, sumDepreCreditFor, sumDepreEndBalanceFor, sumDecValueBeginBalanceFor, sumDecValueDebitFor, sumDecValueCreditFor, sumDecValueEndBalanceFor};
            while (rowSet.next()) {
                for (int j = 0; j < field.length; ++j) {
                    result.put(field[j], rowSet.getBigDecimal(j + 1) != null ? rowSet.getBigDecimal(j + 1) : this.zeroValue);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (acctIndex == 0) {
            BigDecimal realBegin = (BigDecimal)result.get(sumRealBeginBalance);
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), realBegin);
            BigDecimal debit = (BigDecimal)result.get(sumRealDebit);
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), debit);
            BigDecimal credit = (BigDecimal)result.get(sumRealCredit);
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), credit);
            BigDecimal end = (BigDecimal)result.get(sumRealEndBalance);
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), end);
        } else if (acctIndex == 1) {
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreBeginBalanceFor));
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreDebitFor));
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreCreditFor));
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDepreEndBalanceFor));
        } else {
            result.put(sumBegin + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueBeginBalanceFor));
            result.put(sumDebit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueDebitFor));
            result.put(sumCredit + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueCreditFor));
            result.put(sumEnd + "_ASSET_" + acct.getNumber(), (BigDecimal)result.get(sumDecValueEndBalanceFor));
        }
        return result;
    }

    private boolean isCurrentPeriod(Context ctx, String companyId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        PeriodInfo periodInfo = FaLocalUtils.getFLCurrentPeriod((Context)ctx, (String)companyId);
        return periodInfo.getPeriodYear() == periodYear && periodInfo.getPeriodNumber() == periodNumber;
    }

    private HashMap replaceBegin(HashMap currentResult, HashMap lastResult) {
        HashMap newResult = currentResult;
        Set curResultKeySet = currentResult.keySet();
        Set lastResultKeySet = lastResult.keySet();
        for (int setCount = curResultKeySet.size() - 1; setCount >= 0; --setCount) {
            BigDecimal newCredit;
            BigDecimal oldCredit;
            String creditKey;
            String creditKey_0;
            BigDecimal newDebit;
            BigDecimal oldDebit;
            String debitKey;
            String debitKey_0;
            String curKey = curResultKeySet.toArray()[setCount].toString();
            if (curKey.indexOf("Begin") == -1 || curKey.indexOf("GL") != -1) continue;
            BigDecimal curValue = new BigDecimal(currentResult.get(curKey).toString());
            String lastKey = curKey.replaceAll("Begin", "End");
            BigDecimal lastValue = new BigDecimal(lastResult.get(lastKey).toString());
            newResult.put(curKey, lastValue);
            BigDecimal dif = lastValue.subtract(curValue);
            if (curKey.indexOf("DEPRE") != -1 || curKey.indexOf("DECVALUE") != -1) {
                if (dif.intValue() > 0) {
                    debitKey_0 = curKey.replaceAll("Begin", "Debit");
                    debitKey = debitKey_0.replaceAll("Balance", "");
                    oldDebit = new BigDecimal(currentResult.get(debitKey).toString());
                    newDebit = oldDebit.add(dif);
                    newResult.put(debitKey, newDebit);
                    continue;
                }
                creditKey_0 = curKey.replaceAll("Begin", "Credit");
                creditKey = creditKey_0.replaceAll("Balance", "");
                oldCredit = new BigDecimal(currentResult.get(creditKey).toString());
                newCredit = oldCredit.add(dif.negate());
                newResult.put(creditKey, newCredit);
                continue;
            }
            if (dif.intValue() < 0) {
                debitKey_0 = curKey.replaceAll("Begin", "Debit");
                debitKey = debitKey_0.replaceAll("Balance", "");
                oldDebit = new BigDecimal(currentResult.get(debitKey).toString());
                newDebit = oldDebit.add(dif.negate());
                newResult.put(debitKey, newDebit);
                continue;
            }
            creditKey_0 = curKey.replaceAll("Begin", "Credit");
            creditKey = creditKey_0.replaceAll("Balance", "");
            oldCredit = new BigDecimal(currentResult.get(creditKey).toString());
            newCredit = oldCredit.add(dif);
            newResult.put(creditKey, newCredit);
        }
        return newResult;
    }
}

