/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.AbstractNLMAccountBalanceInfo;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaTerminateBillEntryCollection;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.fi.nlm.FaleaseDecValueFactory;
import com.kingdee.eas.fi.nlm.FaleaseDecValueInfo;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceCollection;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailFactory;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceException;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceFactory;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceInfo;
import com.kingdee.eas.fi.nlm.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.nlm.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.nlm.NLMLevelEnum;
import com.kingdee.eas.fi.nlm.NLMLogRecordFactory;
import com.kingdee.eas.fi.nlm.NLMLogRecordInfo;
import com.kingdee.eas.fi.nlm.NLMUsingFeatures;
import com.kingdee.eas.fi.nlm.app.AbstractNLMAccountBalanceControllerBean;
import com.kingdee.eas.fi.nlm.app.fleventlistener.listener.strategy.UpdateBalanceTableForDECBillEnum;
import com.kingdee.eas.fi.nlm.app.fleventlistener.listener.strategy.UpdateBalanceTableForDepreAndAmortEnum;
import com.kingdee.eas.fi.nlm.app.fleventlistener.listener.strategy.UpdateBalanceTableForLeaseBillEnum;
import com.kingdee.eas.fi.nlm.app.fleventlistener.listener.strategy.UpdateBalanceTableForTerminateBillEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class NLMAccountBalanceControllerBean
extends AbstractNLMAccountBalanceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.nlm.app.NLMAccountBalanceControllerBean");
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    protected void _recalculateBalance(Context ctx, String recalculateType, CompanyOrgUnitInfo currentCompany, String leaseBillID, PeriodInfo initPeriod, PeriodInfo currentPeriod, PeriodInfo latestPeriod, Map otherMessage) throws BOSException, EASBizException {
        try {
            if ("0".equals(recalculateType)) {
                this.calcAllBalance(ctx, currentCompany, initPeriod, latestPeriod, otherMessage);
            }
            if ("1".equals(recalculateType)) {
                this.calcCurrentPeriodBalance(ctx, currentCompany, currentPeriod);
            }
            if ("2".equals(recalculateType)) {
                this.calcLeaseBillBalance(ctx, currentCompany, currentPeriod, latestPeriod);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void calcAllBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo initPeriod, PeriodInfo latestPeriod, Map otherMessage) throws BOSException, EASBizException, SQLException {
        String uniqueIDForLog = new Date().getTime() + NLMUsingFeatures.CALC_ALL_BALANCE.getName() + ctx.getUserName();
        if (otherMessage != null && otherMessage.containsKey("uniqueIDForLog")) {
            uniqueIDForLog = (String)otherMessage.get("uniqueIDForLog");
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"230_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        String deleteTable = " DELETE FROM T_NLM_NLMAccountBalance WHERE FCompanyID = '" + currentCompany.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteTable);
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"231_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"232_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        deleteTable = " DELETE FROM T_NLM_NLMAccountBalanceDetail WHERE FCompanyID = '" + currentCompany.getId().toString() + "'";
        DbUtil.execute((Context)ctx, (String)deleteTable);
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"233_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        PeriodInfo currentPeriod = initPeriod;
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"234_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        while (currentPeriod.getNumber() <= latestPeriod.getNumber()) {
            NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"236_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
            this.handleLeaseBill(ctx, currentCompany, currentPeriod, uniqueIDForLog);
            this.handleTerminateBill(ctx, currentCompany, currentPeriod, uniqueIDForLog);
            this.handleLeaseDecBill(ctx, currentCompany, currentPeriod, uniqueIDForLog);
            this.handleLeaseDepBill(ctx, currentCompany, currentPeriod, uniqueIDForLog);
            if (currentPeriod.getNumber() != latestPeriod.getNumber()) {
                this.closingBalance(ctx, currentCompany, currentPeriod, uniqueIDForLog);
            }
            NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"237_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
            currentPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"238_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private void calcCurrentPeriodBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod) {
    }

    private void calcLeaseBillBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, PeriodInfo latestPeriod) {
    }

    private void handleLeaseBill(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, String uniqueIDForLog) throws BOSException, SQLException, EASBizException {
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"239_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        StringBuilder selectLeaseBillSql = new StringBuilder();
        selectLeaseBillSql.append(" select FID leaseBillID \n");
        selectLeaseBillSql.append(" FROM T_FA_FaLeaseInBillNew \n");
        selectLeaseBillSql.append(" where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectLeaseBillSql.toString(), (Object[])new Object[]{currentCompany.getId().toString(), currentPeriod.getId().toString()});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("contractCat.id");
        sic.add("contractCat.name");
        sic.add("contractCat.depreciationPolicy");
        sic.add("contractCat.depreciationPolicy.*");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.baseCurrency.precision");
        sic.add("exchangeRate.*");
        sic.add("exchangeRate.exchangeAux.*");
        while (rs.next()) {
            UpdateBalanceTableForLeaseBillEnum updateBalanceTableForLeaseBillEnum;
            String leaseBillID = rs.getString("leaseBillID");
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(leaseBillID), sic);
            if (faLeaseInBillNewInfo.getLeaseType() == null) {
                faLeaseInBillNewInfo.setLeaseType(FaLeaseTypeEnum.OPERATING_LEASE);
            }
            if ((updateBalanceTableForLeaseBillEnum = UpdateBalanceTableForLeaseBillEnum.getEnumAccordingToBillType(faLeaseInBillNewInfo.getSourceType().getName())) == null) {
                updateBalanceTableForLeaseBillEnum = UpdateBalanceTableForLeaseBillEnum.getEnumAccordingToBillType(faLeaseInBillNewInfo.getLeaseType().getName());
            }
            NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = updateBalanceTableForLeaseBillEnum.getDetailInfo(ctx, faLeaseInBillNewInfo, currentPeriod);
            int j = nlmAccountBalanceDetailCollection.size();
            for (int i = 0; i < j; ++i) {
                NLMAccountBalanceDetailFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceDetailCollection.get(i));
            }
            NLMBillSourceTypeEnum nlmBillSourceTypeEnum = updateBalanceTableForLeaseBillEnum.getNlmBillSourceTypeEnum();
            NLMAccountBalanceInfo nlmAccountBalanceInfo = this.getNLMAccountBalanceInfoForLeaseBill(ctx, nlmBillSourceTypeEnum, faLeaseInBillNewInfo, nlmAccountBalanceDetailCollection, currentPeriod);
            NLMAccountBalanceFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceInfo);
            NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + faLeaseInBillNewInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"240_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"241_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private void handleTerminateBill(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, String uniqueIDForLog) throws BOSException, SQLException, EASBizException {
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"242_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        StringBuilder selectTerminateBillSql = new StringBuilder();
        selectTerminateBillSql.append(" select FID terminateBillID \n");
        selectTerminateBillSql.append(" FROM T_FA_FaTerminateBill \n");
        selectTerminateBillSql.append(" where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectTerminateBillSql.toString(), (Object[])new Object[]{currentCompany.getId().toString(), currentPeriod.getId().toString()});
        while (rs.next()) {
            String terminateBillID = rs.getString("terminateBillID");
            FaTerminateBillInfo faTerminateBillInfo = FaTerminateBillFactory.getLocalInstance(ctx).getFaTerminateBillInfo((IObjectPK)new ObjectUuidPK(terminateBillID));
            UpdateBalanceTableForTerminateBillEnum updateBalanceTableForTerminateBillEnum = UpdateBalanceTableForTerminateBillEnum.getEnumAccordingToBillType(faTerminateBillInfo.getTerminateMode().getName());
            NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = updateBalanceTableForTerminateBillEnum.getDetailInfo(ctx, faTerminateBillInfo, currentPeriod);
            int j = nlmAccountBalanceDetailCollection.size();
            for (int i = 0; i < j; ++i) {
                NLMAccountBalanceDetailFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceDetailCollection.get(i));
            }
            NLMBillSourceTypeEnum nlmBillSourceTypeEnum = updateBalanceTableForTerminateBillEnum.getNlmBillSourceTypeEnum();
            this.updateNLMAccountBalanceInfoForTerminateBill(ctx, nlmBillSourceTypeEnum, faTerminateBillInfo, nlmAccountBalanceDetailCollection, currentPeriod);
            NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + faTerminateBillInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"240_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"243_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private void handleLeaseDecBill(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, String uniqueIDForLog) throws BOSException, SQLException, EASBizException {
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"244_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        StringBuilder selectLeaseDecBillSql = new StringBuilder();
        selectLeaseDecBillSql.append(" select FID leaseDecBillID \n");
        selectLeaseDecBillSql.append(" FROM T_FA_FaleaseDecValue \n");
        selectLeaseDecBillSql.append(" where FCompanyID = ? and FPeriodID = ? and FCheckedStatus = 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectLeaseDecBillSql.toString(), (Object[])new Object[]{currentCompany.getId().toString(), currentPeriod.getId().toString()});
        while (rs.next()) {
            int i;
            String leaseDecBillID = rs.getString("leaseDecBillID");
            FaleaseDecValueInfo faleaseDecValueInfo = FaleaseDecValueFactory.getLocalInstance(ctx).getFaleaseDecValueInfo((IObjectPK)new ObjectUuidPK(leaseDecBillID));
            NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = UpdateBalanceTableForDECBillEnum.DEC_BILL.getDetailInfo(ctx, faleaseDecValueInfo, currentPeriod);
            int j = nlmAccountBalanceDetailCollection.size();
            for (i = 0; i < j; ++i) {
                NLMAccountBalanceDetailFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceDetailCollection.get(i));
            }
            j = nlmAccountBalanceDetailCollection.size();
            for (i = 0; i < j; ++i) {
                NLMAccountBalanceDetailInfo nlmAccountBalanceDetailInfo = nlmAccountBalanceDetailCollection.get(i);
                if (!NLMAccountBalanceFactory.getLocalInstance(ctx).exists("where leaseInBill.id = '" + nlmAccountBalanceDetailInfo.getNlmLeaseBillID() + "' and period.id = '" + currentPeriod.getId().toString() + "'")) {
                    throw new NLMAccountBalanceException(NLMAccountBalanceException.NOT_ACCOUNT_VALUE, new Object[]{nlmAccountBalanceDetailInfo.getNlmBillNumber()});
                }
                NLMAccountBalanceInfo nlmAccountBalanceInfo = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceInfo("where leaseInBill.id = '" + nlmAccountBalanceDetailInfo.getNlmLeaseBillID() + "' and period.id = '" + currentPeriod.getId().toString() + "'");
                String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForDec = ?, FEndingBalanceForDec = ? WHERE FID = ?";
                BigDecimal currentLoanForDec = nlmAccountBalanceInfo.getCurrentLoanForDec().add(nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue());
                BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(nlmAccountBalanceInfo.getCurrentBorrowingForDec()).add(currentLoanForDec);
                DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{currentLoanForDec, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
            }
            NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + faleaseDecValueInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"240_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"245_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private void handleLeaseDepBill(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, String uniqueIDForLog) throws BOSException, SQLException, EASBizException {
        int i;
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"246_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("select FID from T_FA_FaDepreAndAmort where FPeriodId = '" + currentPeriod.getId().toString() + "' and FCompanyId = '" + currentCompany.getId().toString() + "'"));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add("*");
        selectorItemCollection.add("period.*");
        selectorItemCollection.add("leaseInBill.id");
        selectorItemCollection.add("leaseInBill.number");
        selectorItemCollection.add("leaseInBill.period.*");
        FaDepreAndAmortCollection faDepreAndAmortCollection = new FaDepreAndAmortCollection();
        while (rs.next()) {
            FaDepreAndAmortInfo faDepreAndAmortInfo = FaDepreAndAmortFactory.getLocalInstance(ctx).getFaDepreAndAmortInfo((IObjectPK)new ObjectUuidPK(rs.getString("FID")), selectorItemCollection);
            if (faDepreAndAmortInfo.getLeaseInBill().getPeriod().getNumber() > faDepreAndAmortInfo.getPeriod().getNumber()) continue;
            faDepreAndAmortCollection.add(faDepreAndAmortInfo);
        }
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = UpdateBalanceTableForDepreAndAmortEnum.DEPRE_AND_AMORT.getDetailInfo(ctx, faDepreAndAmortCollection, currentPeriod);
        int j = nlmAccountBalanceDetailCollection.size();
        for (i = 0; i < j; ++i) {
            NLMAccountBalanceDetailFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceDetailCollection.get(i));
        }
        j = nlmAccountBalanceDetailCollection.size();
        for (i = 0; i < j; ++i) {
            NLMAccountBalanceDetailInfo nlmAccountBalanceDetailInfo = nlmAccountBalanceDetailCollection.get(i);
            if (!NLMAccountBalanceFactory.getLocalInstance(ctx).exists("where leaseInBill.id = '" + nlmAccountBalanceDetailInfo.getNlmLeaseBillID() + "' and period.id = '" + currentPeriod.getId().toString() + "'")) {
                throw new NLMAccountBalanceException(NLMAccountBalanceException.NOT_ACCOUNT_VALUE, new Object[]{nlmAccountBalanceDetailInfo.getNlmBillNumber()});
            }
            NLMAccountBalanceInfo nlmAccountBalanceInfo = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceInfo("where leaseInBill.id = '" + nlmAccountBalanceDetailInfo.getNlmLeaseBillID() + "' and period.id = '" + currentPeriod.getId().toString() + "'");
            BigDecimal currentLoanForDep = nlmAccountBalanceInfo.getCurrentLoanForDep().add(nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue() == null ? BigDecimal.ZERO : nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue());
            BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(nlmAccountBalanceInfo.getCurrentBorrowingForDep()).add(currentLoanForDep);
            String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForDep = ?, FEndingBalanceForDep = ? WHERE FID = ?";
            DbUtil.execute((Context)ctx, (String)updateSql, (Object[])new Object[]{currentLoanForDep, endingBalanceForDep, nlmAccountBalanceInfo.getId().toString()});
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"247_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private void closingBalance(Context ctx, CompanyOrgUnitInfo currentCompany, PeriodInfo currentPeriod, String uniqueIDForLog) throws EASBizException, BOSException {
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"248_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
        PeriodInfo nextPeriod = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        NLMAccountBalanceCollection nlmAccountBalanceCollection = NLMAccountBalanceFactory.getLocalInstance(ctx).getNLMAccountBalanceCollection("where period.id = '" + currentPeriod.getId().toString() + "' and company.id = '" + currentCompany.getId().toString() + "'");
        int j = nlmAccountBalanceCollection.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceInfo old = nlmAccountBalanceCollection.get(i);
            NLMAccountBalanceInfo nlmAccountBalanceInfoNew = new NLMAccountBalanceInfo();
            nlmAccountBalanceInfoNew.setId(BOSUuid.create((BOSObjectType)nlmAccountBalanceInfoNew.getBOSType()));
            nlmAccountBalanceInfoNew.setLeaseInBill(old.getLeaseInBill());
            nlmAccountBalanceInfoNew.setCompany(old.getCompany());
            nlmAccountBalanceInfoNew.setCurrency(old.getCurrency());
            nlmAccountBalanceInfoNew.setPeriod(nextPeriod);
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForAsset(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForAsset(old.getEndingBalanceForAsset());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDep(old.getEndingBalanceForDep());
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(old.getEndingBalanceForDec());
            nlmAccountBalanceInfoNew.setCurrentBorrowingForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(new BigDecimal("0"));
            nlmAccountBalanceInfoNew.setEndingBalanceForDec(old.getEndingBalanceForDec());
            NLMAccountBalanceFactory.getLocalInstance(ctx).addnew(nlmAccountBalanceInfoNew);
        }
        NLMAccountBalanceControllerBean.nlmLog(ctx, uniqueIDForLog, NLMLevelEnum.INFO, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"235_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()) + currentPeriod.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"249_NLMAccountBalanceControllerBean", (Locale)ctx.getLocale()), NLMUsingFeatures.CALC_ALL_BALANCE, false, currentCompany, new Date());
    }

    private NLMAccountBalanceInfo getNLMAccountBalanceInfoForLeaseBill(Context context, NLMBillSourceTypeEnum nlmBillSourceTypeEnum, FaLeaseInBillNewInfo detailMessage, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection, PeriodInfo curPeriod) throws EASBizException, BOSException {
        NLMAccountBalanceInfo nlmAccountBalanceInfoNew = new NLMAccountBalanceInfo();
        nlmAccountBalanceInfoNew.setId(BOSUuid.create((BOSObjectType)nlmAccountBalanceInfoNew.getBOSType()));
        nlmAccountBalanceInfoNew.setLeaseInBill(detailMessage);
        nlmAccountBalanceInfoNew.setCompany(detailMessage.getCompany());
        nlmAccountBalanceInfoNew.setCurrency(detailMessage.getCurrency());
        nlmAccountBalanceInfoNew.setPeriod(curPeriod);
        nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForAsset(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setOpeningBalanceForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForDep(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setOpeningBalanceForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentBorrowingForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setCurrentLoanForDec(new BigDecimal("0"));
        nlmAccountBalanceInfoNew.setEndingBalanceForDec(new BigDecimal("0"));
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_GL_BALANCE_ENTRY) {
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_FINANCE_LEASE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_OPERATING_LEASE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_INIT_ASSET, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_INIT_ACC_DEP, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_ADJUST) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
            nlmAccountBalanceInfoNew.setCurrentLoanForDec(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_DEC_ADJUST, nlmAccountBalanceDetailCollection));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_RETR_ADJUST) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
            nlmAccountBalanceInfoNew.setCurrentLoanForDep(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_ADJUST_RETR, nlmAccountBalanceDetailCollection).add(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ACC_DEP_RECORD, nlmAccountBalanceDetailCollection)));
        }
        if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.LEASE_BILL_TERMINATE) {
            nlmAccountBalanceInfoNew.setCurrentBorrowingForAsset(this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.LEASE_BILL_ASSET_ADJUST, nlmAccountBalanceDetailCollection));
        }
        PeriodInfo perPeriod = PeriodUtils.getPrePeriodInfo((Context)context, (PeriodInfo)curPeriod);
        AbstractNLMAccountBalanceInfo nlmAccountBalanceInfoOld = null;
        if (perPeriod != null && NLMAccountBalanceFactory.getLocalInstance(context).exists("where leaseInBill.id = '" + detailMessage.getId().toString() + "' and period.id = '" + perPeriod.getId().toString() + "'")) {
            nlmAccountBalanceInfoOld = NLMAccountBalanceFactory.getLocalInstance(context).getNLMAccountBalanceInfo("where leaseInBill.id = '" + detailMessage.getId().toString() + "' and period.id = '" + perPeriod.getId().toString() + "'");
        }
        if (nlmAccountBalanceInfoOld != null) {
            nlmAccountBalanceInfoNew.setOpeningBalanceForAsset(nlmAccountBalanceInfoNew.getOpeningBalanceForAsset().add(nlmAccountBalanceInfoOld.getEndingBalanceForAsset()));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDep(nlmAccountBalanceInfoNew.getOpeningBalanceForDep().add(nlmAccountBalanceInfoOld.getEndingBalanceForDep()));
            nlmAccountBalanceInfoNew.setOpeningBalanceForDec(nlmAccountBalanceInfoNew.getOpeningBalanceForDec().add(nlmAccountBalanceInfoOld.getEndingBalanceForDec()));
        }
        nlmAccountBalanceInfoNew.setEndingBalanceForAsset(nlmAccountBalanceInfoNew.getOpeningBalanceForAsset().add(nlmAccountBalanceInfoNew.getCurrentBorrowingForAsset()).subtract(nlmAccountBalanceInfoNew.getCurrentLoanForAsset()));
        nlmAccountBalanceInfoNew.setEndingBalanceForDep(nlmAccountBalanceInfoNew.getOpeningBalanceForDep().subtract(nlmAccountBalanceInfoNew.getCurrentBorrowingForDep()).add(nlmAccountBalanceInfoNew.getCurrentLoanForDep()));
        nlmAccountBalanceInfoNew.setEndingBalanceForDec(nlmAccountBalanceInfoNew.getOpeningBalanceForDec().subtract(nlmAccountBalanceInfoNew.getCurrentBorrowingForDec()).add(nlmAccountBalanceInfoNew.getCurrentLoanForDec()));
        return nlmAccountBalanceInfoNew;
    }

    private void updateNLMAccountBalanceInfoForTerminateBill(Context context, NLMBillSourceTypeEnum nlmBillSourceTypeEnum, FaTerminateBillInfo detailMessage, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection, PeriodInfo periodInfo) throws EASBizException, BOSException {
        HashMap nlmAccountBalanceDetailMap = new HashMap();
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            List<NLMAccountBalanceDetailInfo> list;
            NLMAccountBalanceDetailInfo detailInfo = nlmAccountBalanceDetailCollection.get(i);
            if (!nlmAccountBalanceDetailMap.containsKey(detailInfo.getNlmBillNumber())) {
                list = new ArrayList<NLMAccountBalanceDetailInfo>();
                list.add(detailInfo);
                nlmAccountBalanceDetailMap.put(detailInfo.getNlmBillNumber(), list);
                continue;
            }
            list = (List)nlmAccountBalanceDetailMap.get(detailInfo.getNlmBillNumber());
            list.add(detailInfo);
        }
        FaTerminateBillEntryCollection faTerminateBillEntryCollection = detailMessage.getEntry();
        int j2 = faTerminateBillEntryCollection.size();
        for (int i = 0; i < j2; ++i) {
            String leaseInBillNumber = faTerminateBillEntryCollection.get(i).getLeaseInBillNumber();
            List detailInfos = (List)nlmAccountBalanceDetailMap.get(leaseInBillNumber);
            if (!NLMAccountBalanceFactory.getLocalInstance(context).exists("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'")) {
                throw new NLMAccountBalanceException(NLMAccountBalanceException.NOT_ACCOUNT_VALUE, new Object[]{leaseInBillNumber});
            }
            NLMAccountBalanceInfo nlmAccountBalanceInfo = NLMAccountBalanceFactory.getLocalInstance(context).getNLMAccountBalanceInfo("where leaseInBill.id = '" + ((NLMAccountBalanceDetailInfo)detailInfos.get(0)).getNlmLeaseBillID() + "' and period.id = '" + periodInfo.getId().toString() + "'");
            BigDecimal currentLoanForAsset = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_INIT_ASSET, detailInfos);
            BigDecimal currentBorrowingForDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_ACC_DEP, detailInfos);
            BigDecimal currentBorrowingForDec = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_DEC_VALUE, detailInfos);
            if (nlmBillSourceTypeEnum == NLMBillSourceTypeEnum.TER_RETROSPECT_TERMINATION) {
                BigDecimal retrAccDep = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_ACC_DEP, detailInfos);
                BigDecimal retrDecValue = this.getValueForNLMBillFieldName(NLMBillFieldNameEnum.TERMINATE_BILL_TER_RETR_DEC_VALUE, detailInfos);
                currentLoanForAsset = currentLoanForAsset.add(nlmAccountBalanceInfo.getCurrentLoanForAsset());
                currentBorrowingForDep = currentBorrowingForDep.add(nlmAccountBalanceInfo.getCurrentBorrowingForDep()).add(retrAccDep);
                currentBorrowingForDec = currentBorrowingForDec.add(nlmAccountBalanceInfo.getCurrentBorrowingForDec()).add(retrDecValue);
                BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
                BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
                BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
                String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
                DbUtil.execute((Context)context, (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
                continue;
            }
            currentLoanForAsset = currentLoanForAsset.add(nlmAccountBalanceInfo.getCurrentLoanForAsset());
            currentBorrowingForDep = currentBorrowingForDep.add(nlmAccountBalanceInfo.getCurrentBorrowingForDep());
            currentBorrowingForDec = currentBorrowingForDec.add(nlmAccountBalanceInfo.getCurrentBorrowingForDec());
            BigDecimal endingBalanceForAsset = nlmAccountBalanceInfo.getOpeningBalanceForAsset().add(nlmAccountBalanceInfo.getCurrentBorrowingForAsset()).subtract(currentLoanForAsset);
            BigDecimal endingBalanceForDep = nlmAccountBalanceInfo.getOpeningBalanceForDep().subtract(currentBorrowingForDep).add(nlmAccountBalanceInfo.getCurrentLoanForDep());
            BigDecimal endingBalanceForDec = nlmAccountBalanceInfo.getOpeningBalanceForDec().subtract(currentBorrowingForDec).add(nlmAccountBalanceInfo.getCurrentLoanForDec());
            String updateSql = "UPDATE T_NLM_NLMAccountBalance SET FCurrentLoanForAsset = ?, FCurrentBorrowingForDep = ?, FCurrentBorrowingForDec = ?, FEndingBalanceForAsset = ?, FEndingBalanceForDep = ?, FEndingBalanceForDec = ? WHERE FID = ?";
            DbUtil.execute((Context)context, (String)updateSql, (Object[])new Object[]{currentLoanForAsset, currentBorrowingForDep, currentBorrowingForDec, endingBalanceForAsset, endingBalanceForDep, endingBalanceForDec, nlmAccountBalanceInfo.getId().toString()});
        }
    }

    private BigDecimal getValueForNLMBillFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum, NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection) {
        int j = nlmAccountBalanceDetailCollection.size();
        for (int i = 0; i < j; ++i) {
            if (nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldName() != nlmBillFieldNameEnum) continue;
            return nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldValue() == null ? new BigDecimal("0") : nlmAccountBalanceDetailCollection.get(i).getNlmBillGetFieldValue();
        }
        return new BigDecimal("0");
    }

    private BigDecimal getValueForNLMBillFieldName(NLMBillFieldNameEnum nlmBillFieldNameEnum, List<NLMAccountBalanceDetailInfo> nlmAccountBalanceDetailCollection) {
        for (NLMAccountBalanceDetailInfo nlmAccountBalanceDetailInfo : nlmAccountBalanceDetailCollection) {
            if (nlmAccountBalanceDetailInfo.getNlmBillGetFieldName() != nlmBillFieldNameEnum) continue;
            return nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue() == null ? new BigDecimal("0") : nlmAccountBalanceDetailInfo.getNlmBillGetFieldValue();
        }
        return new BigDecimal("0");
    }

    private static void nlmLog(Context ctx, String uniqueIDForLog, NLMLevelEnum level, String content, NLMUsingFeatures usingFeatures, boolean isTemporaryLog, CompanyOrgUnitInfo company, Date date) throws BOSException, EASBizException {
        NLMLogRecordInfo nlmLogRecordInfo = new NLMLogRecordInfo();
        nlmLogRecordInfo.setId(BOSUuid.create((String)"B949B9EF"));
        nlmLogRecordInfo.setUniqueIDForLog(uniqueIDForLog);
        nlmLogRecordInfo.setLevel(level);
        nlmLogRecordInfo.setUsingFeatures(usingFeatures);
        nlmLogRecordInfo.setContent(formatter.format(date) + ": " + content);
        nlmLogRecordInfo.setIsTemporaryLog(isTemporaryLog);
        nlmLogRecordInfo.setCompany(company);
        nlmLogRecordInfo.setIncrSeq(NLMLogRecordFactory.getLocalInstance(ctx).getPKList("where uniqueIDForLog = '" + uniqueIDForLog + "'").length);
        NLMLogRecordFactory.getLocalInstance(ctx).addnew(nlmLogRecordInfo);
    }
}

