/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaAssetCalculationListDao
extends FaShowNotAuditDao {
    private static final Logger logger = Logger.getLogger(FaAssetCalculationListDao.class);
    private String selectTmp;
    private String company;
    private Date startDateField;
    private Date endDateField;
    private String leaseBillNumber;
    private CurrencyInfo currencyInfo;

    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        this.ctx = ctx;
        FaRptLocalUtils.chgNumberKeyWord((EntityViewInfo)ev);
        this.fName = "FName_" + ctx.getLocale().toString();
        this.fDisplayName = "FDisplayName_" + ctx.getLocale().toString();
        this.currCompanyInfo = this.getRptCompany(ctx, ev);
        this.isVirCompany = !this.currCompanyInfo.isIsBizUnit();
        this.setProperCurPeriod(ctx);
        this.initEvVar(ev);
        if (this.isCreateTempTable()) {
            this.tempTable = this.getProperTempTable(ctx);
        }
        this.filter = this.buildFilterSql(ev);
        this.sorter = this.buildSorterSql(ev);
        if (this.isCreateTempTable()) {
            this.sorter = this.sorter == null || this.sorter.equals("") ? "FID" : this.sorter + "FID";
        }
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.initConditionField(m);
    }

    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.dropTable(this.acctAsstTableName);
        this.acctAsstTableName = null;
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("sumColumnName", null);
        this.clearInnerTempTable();
        return this.result;
    }

    protected void buildSql() throws BOSException {
        this.selectTmp = this.getSelectTmpSql();
        this.buildResultSql();
    }

    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryCardSQL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDataTempTable(String sql) throws BOSException {
        sql = "select * into " + this.tempTable + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), (SqlParams)this.params, (Connection)con, (FaDBUtilConfig)this.cf);
            this.tempTable = result.getTempTable();
        }
        catch (Exception exc) {
            try {
                throw new BOSException("Sql execute exception : " + this.params.getSqlWithParams(sql), (Throwable)exc);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return this.tempTable;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer(ev.getFilter().toString());
        return strBuf.toString();
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        sorterSql.append("isBeforeImplDate desc, ");
        if (ev != null && ev.getSorter() != null) {
            SorterItemCollection sorterItemCollection = ev.getSorter();
            int j = sorterItemCollection.size();
            for (int i = 0; i < j; ++i) {
                String tmpSortName = this.exchangeSortName(sorterItemCollection.get(i).getPropertyName());
                sorterSql.append(tmpSortName).append(" ").append(sorterItemCollection.get(i).getSortType()).append(",");
            }
        }
        return sorterSql.toString();
    }

    private String exchangeSortName(String propertyName) {
        if ("lease.FIsBeforeImplDate".equals(propertyName)) {
            return "isBeforeImplDate";
        }
        if ("lease.FNumber".equals(propertyName)) {
            return "billNumber";
        }
        if ("lease.FiAccountDate".equals(propertyName)) {
            return "fiAccountDate";
        }
        if ("lease.FEndDate".equals(propertyName)) {
            return "endDate";
        }
        if ("lease.FInitialAsset".equals(propertyName)) {
            return "initialAsset";
        }
        if ("lease.FCurrencyID".equals(propertyName)) {
            return "currency";
        }
        if ("lease.FExchangeRateValue".equals(propertyName)) {
            return "exchangeRate";
        }
        if ("lease.FDiscountRate".equals(propertyName)) {
            return "discountRate";
        }
        if ("lease.FTaxRate".equals(propertyName)) {
            return "taxRate";
        }
        if ("lease.FRentWithTax".equals(propertyName)) {
            return "rentWithTax";
        }
        if ("lease.FRentWithoutTax".equals(propertyName)) {
            return "rentWithoutTax";
        }
        if ("lease.FPayFrequency".equals(propertyName)) {
            return "payFrequency";
        }
        if ("lease.FIsDeductible".equals(propertyName)) {
            return "isDeductible";
        }
        return "";
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(2001);
        String inSql = FaDBUtil.getSplitInSql((String)selectedIds, (String)"company.FID");
        sql.append(" AND company.FID ").append(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    private String getSelectTmpSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("FID, ");
        sql.append("isBeforeImplDate, ");
        sql.append("assetCalculationType, ");
        sql.append("dpInitCfmDate, ");
        sql.append("billNumber, ");
        sql.append("fiAccountDate, ");
        sql.append("beginDate, ");
        sql.append("endDate, ");
        sql.append("contractDiscountDate, ");
        sql.append("initialAsset, ");
        sql.append("currency, ");
        sql.append("exchangeRate, ");
        sql.append("discountRate, ");
        sql.append("dayDiscountRate, ");
        sql.append("isDeductible, ");
        sql.append("taxRate, ");
        sql.append("rentWithTax, ");
        sql.append("rentWithoutTax, ");
        sql.append("payFrequency, ");
        sql.append("calculationDetail ");
        return sql.toString();
    }

    private void buildResultSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.selectTmp);
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setOrder(this.sorter);
    }

    private String buildQueryCardSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(this.selectTmp);
        sql.append(" FROM (").append(this.getLeaseBillTableSql()).append(") t \n");
        sql.append(" WHERE ").append(this.getCondSql());
        return sql.toString();
    }

    private String getLeaseBillTableSql() {
        String discount2ImplDateString = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"0_FaAssetCalculationListDao", (Locale)this.ctx.getLocale());
        boolean isDiscount2ImplDate = false;
        try {
            boolean bl = isDiscount2ImplDate = FaManageUtils.getIntFaParamValue((Context)this.ctx, (String)"NLM_303", (String)this.company) == 0;
            if (isDiscount2ImplDate) {
                discount2ImplDateString = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"1_FaAssetCalculationListDao", (Locale)this.ctx.getLocale());
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("lease.FID AS FID, ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"2_FaAssetCalculationListDao", (Locale)this.ctx.getLocale()));
        sql.append("CASE WHEN lease.FIsBeforeImplDate = 0 THEN null ELSE '" + discount2ImplDateString + "' END AS assetCalculationType, ");
        sql.append("CASE WHEN lease.FIsBeforeImplDate = 0 THEN null ELSE lease.FDpInitCfmDate END AS dpInitCfmDate, ");
        sql.append("lease.FNumber AS billNumber, ");
        sql.append("lease.FiAccountDate AS fiAccountDate, ");
        sql.append("lease.FBeginDate AS beginDate, ");
        sql.append("lease.FEndDate AS endDate, ");
        sql.append("CASE WHEN lease.FIsBeforeImplDate = 0 THEN lease.FBeginDate ELSE (CASE WHEN '" + isDiscount2ImplDate + "' = 'true' THEN lease.FDpInitCfmDate ELSE lease.FBeginDate END) END AS contractDiscountDate, ");
        sql.append("lease.FInitialAsset AS initialAsset, ");
        sql.append("currency.FNAME_" + this.ctx.getLocale().toString() + " AS currency, ");
        sql.append("lease.FExchangeRateValue AS exchangeRate, ");
        sql.append("lease.FDiscountRate AS discountRate, ");
        sql.append("lease.FDiscountRate AS dayDiscountRate, ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"3_FaAssetCalculationListDao", (Locale)this.ctx.getLocale()));
        sql.append("lease.FTaxRate AS taxRate, ");
        sql.append("lease.FRentWithTax AS rentWithTax, ");
        sql.append("lease.FRentWithoutTax AS rentWithoutTax, ");
        sql.append("lease.FPayFrequency AS payFrequency, ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"4_FaAssetCalculationListDao", (Locale)this.ctx.getLocale()));
        sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
        sql.append(" LEFT JOIN ").append("T_ORG_Company company ON lease.FCompanyID = company.FID \n");
        sql.append(" LEFT JOIN ").append("T_BD_Currency currency ON lease.FCurrencyID = currency.FID \n");
        sql.append(" WHERE ").append(" lease.FCheckedStatus = 2 \n");
        sql.append(" AND ").append(" (lease.FLeaseType != '0'").append(" OR ").append("lease.FLeaseType is null) \n");
        if (this.isVirCompany) {
            sql.append(" AND ").append("lease.FCompanyID in (" + this.strCompanyInclude + ")");
        } else {
            sql.append(" AND ").append("lease.FCompanyID = '" + this.company + "'");
        }
        if (this.startDateField != null) {
            sql.append(" AND ").append("lease.FiAccountDate >= {d '" + new Timestamp(this.startDateField.getTime()) + "'}");
        }
        if (this.endDateField != null) {
            sql.append(" AND ").append("lease.FiAccountDate <= {d '" + new Timestamp(this.endDateField.getTime()) + "'}");
        }
        if (this.leaseBillNumber != null && !"".equals(this.leaseBillNumber)) {
            sql.append(" AND ").append("lease.FNumber like '%" + this.leaseBillNumber + "%'");
        }
        if (this.currencyInfo != null) {
            sql.append(" AND ").append("lease.FCurrencyID = '" + this.currencyInfo.getId().toString() + "'");
        }
        return sql.toString();
    }

    private String getCondSql() {
        StringBuilder condSql = new StringBuilder();
        condSql.append(" 1 = 1");
        return condSql.toString();
    }

    private void initConditionField(Map conditionMap) {
        this.company = (String)conditionMap.get("def_company_id");
        this.startDateField = (Date)conditionMap.get("startDate");
        this.endDateField = (Date)conditionMap.get("endDate");
        this.leaseBillNumber = (String)conditionMap.get("leaseBillNumber");
        this.currencyInfo = (CurrencyInfo)conditionMap.get("currencyID");
    }
}

