/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dao;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.rpt.FaCreateTempTableResult;
import com.kingdee.eas.fi.fa.rpt.FaDBUtil;
import com.kingdee.eas.fi.fa.rpt.FaDBUtilConfig;
import com.kingdee.eas.fi.fa.rpt.app.FaRptLocalUtils;
import com.kingdee.eas.fi.fa.rpt.app.dao.FaShowNotAuditDao;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaLeaseAmountDisplayTypeEnum;
import com.kingdee.eas.fi.nlm.FaLeaseRptDataTypeEnum;
import com.kingdee.eas.fi.nlm.util.FaLeaseLiabilitiesRptUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FaLeaseLiabilitiesListDao
extends FaShowNotAuditDao {
    private static final Logger logger = Logger.getLogger(FaLeaseLiabilitiesListDao.class);
    private String selectTmp;
    private String selectLeaseBill;
    private String selectRpt;
    private String company;
    private Date startDate;
    private Date endDate;
    private FaContractCatInfo contractType;
    private String leaseBillNumber;
    private String contractNumber;
    private FaLeaseRptDataTypeEnum rptDataType;
    private FaLeaseAmountDisplayTypeEnum amountDisplayType;
    private boolean isByCompany;
    private boolean isByCurrency;
    private boolean isByPersonType;
    private boolean isByPerson;
    private String[] dateColumnArray;
    private int tempTableTotal;
    private boolean includeTerminateBill;
    private boolean includeChangeBill;
    private int beginDateFrom;
    private int beginDateTo;
    private boolean exempted;
    private boolean exemptNG;
    private boolean exemptALL;

    public void init(Context ctx, EntityViewInfo ev) throws EASBizException, BOSException {
        this.ctx = ctx;
        FaRptLocalUtils.chgNumberKeyWord((EntityViewInfo)ev);
        this.fName = "FName_" + ctx.getLocale().toString();
        this.fDisplayName = "FDisplayName_" + ctx.getLocale().toString();
        this.currCompanyInfo = this.getRptCompany(ctx, ev);
        this.isVirCompany = !this.currCompanyInfo.isIsBizUnit();
        this.setProperCurPeriod(ctx);
        this.initEvVar(ev);
        if (this.isCreateTempTable()) {
            this.tempTable = this.getProperTempTable(ctx);
        }
        this.filter = this.buildFilterSql(ev);
        this.sorter = this.buildSorterSql(ev);
        if (this.isCreateTempTable()) {
            this.sorter = this.sorter == null || this.sorter.equals("") ? "FID" : this.sorter + "FID";
        }
    }

    protected void initEvVar(EntityViewInfo ev) throws EASBizException, BOSException {
        super.initEvVar(ev);
        Map m = (Map)ev.get("customcond");
        this.initConditionField(m);
        this.initDateColumnArray();
    }

    public Map getResult() throws BOSException {
        this.buildSql();
        this.buildData();
        this.resultSql.setFrom(this.tempTable);
        this.resultSql.setSecondTable(this.scTempTable);
        this.dropTable(this.acctAsstTableName);
        this.acctAsstTableName = null;
        this.result.put("sumOption", this.sumOption);
        this.result.put("resultSql", this.resultSql);
        this.result.put("tempTableName", this.tempTable);
        this.result.put("sumColumnName", null);
        this.result.put("tempTableTotal", this.tempTableTotal);
        this.clearInnerTempTable();
        return this.result;
    }

    protected void buildSql() throws BOSException {
        this.selectTmp = this.getSelectTmpSql();
        this.selectLeaseBill = this.getSelectLeaseBillSql();
        this.selectRpt = this.getSelectRptSql();
        this.buildResultSql();
    }

    protected void buildData() throws BOSException {
        this.addDataTempTable(FaLocalUtils.transformLocal((Context)this.ctx, (String)this.buildQueryCardSQL()));
        this.removeDataTempTable();
    }

    private void removeDataTempTable() throws BOSException {
        try {
            IRowSet rs;
            HashSet<String> removeID = new HashSet<String>();
            if (!this.includeTerminateBill) {
                StringBuilder terminateBillSql = new StringBuilder();
                terminateBillSql.append(" select tmp.FID billID from ").append(this.tempTable).append(" tmp \n");
                terminateBillSql.append(" left join T_FA_FaTerminateBillEntry terEntry on tmp.FID = terEntry.FLeaseInBillID \n");
                terminateBillSql.append(" left join T_FA_FaTerminateBill ter on ter.FID = terEntry.FBillID \n");
                terminateBillSql.append(" left join T_BD_Period period on ter.FPeriodID = period.FID \n");
                terminateBillSql.append(" where tmp.bizStatus = '5' and period.FNumber <= ").append(this.beginDateTo).append(" \n");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)terminateBillSql.toString());
                while (rs.next()) {
                    removeID.add(rs.getString("billID"));
                }
            }
            if (!this.includeChangeBill) {
                StringBuilder changeBillSql = new StringBuilder();
                changeBillSql.append(" select tmp.FID billID from ").append(this.tempTable).append(" tmp \n");
                changeBillSql.append(" left join T_FA_FaNLMChangeAssetItem nlmChange on tmp.FID = nlmChange.FLeaseInBillOldID \n");
                changeBillSql.append(" left join T_FA_FaLeaseInBillNew newBill on newBill.FID = nlmChange.FLeaseInBillNewID \n");
                changeBillSql.append(" left join T_BD_Period period on newBill.FPeriodID = period.FID \n");
                changeBillSql.append(" where tmp.bizStatus = '7' and period.FNumber <= ").append(this.beginDateTo).append(" \n");
                rs = DbUtil.executeQuery((Context)this.ctx, (String)changeBillSql.toString());
                while (rs.next()) {
                    removeID.add(rs.getString("billID"));
                }
            }
            if (removeID.size() > 0) {
                StringBuilder removeSql = new StringBuilder();
                removeSql.append(" delete from ").append(this.tempTable).append(" \n");
                removeSql.append(" where FID in ( ");
                for (String billID : removeID) {
                    removeSql.append("'").append(billID).append("',");
                }
                removeSql.deleteCharAt(removeSql.length() - 1);
                removeSql.append(" )");
                this.tempTableTotal -= removeID.size();
                DbUtil.execute((Context)this.ctx, (String)removeSql.toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String addDataTempTable(String sql) throws BOSException {
        sql = "select * into " + this.tempTable + " from (" + sql + ") as tempTable ";
        Connection con = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            FaCreateTempTableResult result = FaDBUtil.executeSelectInto((Context)this.ctx, (String)FaLocalUtils.transformLocal((Context)this.ctx, (String)sql), (SqlParams)this.params, (Connection)con, (FaDBUtilConfig)this.cf);
            this.tempTableTotal = result.getSuccessNum();
            this.tempTable = result.getTempTable();
        }
        catch (Exception exc) {
            try {
                throw new BOSException("Sql execute exception : " + this.params.getSqlWithParams(sql), (Throwable)exc);
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
        return this.tempTable;
    }

    protected String buildFilterSql(EntityViewInfo ev) {
        FilterInfo filterInfo = ev.getFilter();
        if (filterInfo == null || filterInfo.getFilterItems() == null || filterInfo.getFilterItems().isEmpty()) {
            return null;
        }
        return ev.getFilter().toString();
    }

    protected String buildSorterSql(EntityViewInfo ev) {
        StringBuffer sorterSql = new StringBuffer();
        if (this.isByCompany) {
            sorterSql.append("company, ");
        }
        if (this.isByCurrency) {
            sorterSql.append("currency, ");
        }
        if (this.isByPerson) {
            sorterSql.append("lessorName, ");
        }
        if (this.isByPersonType) {
            sorterSql.append("lessorType, ");
        }
        if (ev != null && ev.getSorter() != null) {
            SorterItemCollection sorterItemCollection = ev.getSorter();
            int j = sorterItemCollection.size();
            for (int i = 0; i < j; ++i) {
                String tmpSortName = this.exchangeSortName(sorterItemCollection.get(i).getPropertyName());
                sorterSql.append(tmpSortName).append(" ").append(sorterItemCollection.get(i).getSortType()).append(",");
            }
        }
        return sorterSql.toString();
    }

    private String exchangeSortName(String propertyName) {
        if ("lease.FNumber".equals(propertyName)) {
            return "leaseNumber";
        }
        if ("lease.FCurrencyID".equals(propertyName)) {
            return "currency";
        }
        if ("lease.FLessorType".equals(propertyName)) {
            return "lessorType";
        }
        if ("lease.FBeginDate".equals(propertyName)) {
            return "beginDate";
        }
        if ("lease.FBizStatus".equals(propertyName)) {
            return "bizStatus";
        }
        return "";
    }

    protected void setProperCurPeriod(Context ctx) throws BOSException, EASBizException {
        this.currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.currCompanyInfo);
    }

    protected String getCompanysInPeriod(String selectedIds, int startYear, int startNumber, int endYear, int endNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT company.FID AS COMPANYID FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period currPeriod ON ssc.FCurrentPeriodID = currPeriod.FID");
        sql.append(" INNER JOIN T_BD_Period startPeriod ON ssc.FStartPeriodID = startPeriod.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(2001);
        String inSql = FaDBUtil.getSplitInSql((String)selectedIds, (String)"company.FID");
        sql.append(" AND company.FID ").append(inSql);
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        StringBuffer companyIds = new StringBuffer();
        try {
            while (rs.next()) {
                companyIds.append(",").append("'").append(rs.getString("COMPANYID")).append("'");
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql execute exception : " + sql, (Throwable)e);
        }
        if (companyIds.length() == 0) {
            return "''";
        }
        return companyIds.substring(1);
    }

    private String getSelectTmpSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("t1.FID, ");
        sql.append("company, ");
        sql.append("currency, ");
        sql.append("lessorType, ");
        sql.append("lessorName, ");
        sql.append("leaseNumber, ");
        sql.append("contractNumber, ");
        sql.append("contractName, ");
        sql.append("contractCat, ");
        sql.append("initialMoney, ");
        sql.append("beginDate, ");
        sql.append("bizStatus, ");
        for (int i = 0; i < this.dateColumnArray.length; ++i) {
            if (i == this.dateColumnArray.length - 1) {
                sql.append("\"a" + this.dateColumnArray[i].replace('-', 'a') + "\" ");
                break;
            }
            sql.append("\"a" + this.dateColumnArray[i].replace('-', 'a') + "\", ");
        }
        return sql.toString();
    }

    private String getSelectLeaseBillSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("lease.FID AS FID, ");
        sql.append("company.FNAME_L2 AS company, ");
        sql.append("currency.FNAME_" + this.ctx.getLocale().toString() + " AS currency, ");
        sql.append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"6_FaLeaseLiabilitiesListDao", (Locale)this.ctx.getLocale()));
        sql.append("((CASE WHEN (supplierlessor.FName_l2 IS NULL) THEN N'' ELSE supplierlessor.FName_l2 END || CASE  WHEN (innercompanylessor.FName_l2 IS NULL) THEN N'' ELSE innercompanylessor.FName_l2 END) || CASE  WHEN (customerlessor.FName_l2 IS NULL) THEN N'' ELSE customerlessor.FName_l2 END) AS lessorName, ");
        sql.append("lease.FNumber AS leaseNumber, ");
        sql.append("lease.FContractNumber AS contractNumber, ");
        sql.append("lease.FContractName AS contractName, ");
        sql.append("contractcat.FNAME_L2 AS contractCat, ");
        sql.append("lease.FBeginDate AS beginDate, ");
        sql.append("lease.FBizStatus AS bizStatus ");
        return sql.toString();
    }

    private String getSelectRptSql() {
        StringBuilder sql = new StringBuilder();
        String dataType = "rptEntry.FEndLiabilityBalance";
        String initDataType = "rptEntry.FInitLiabilityBalance";
        if (FaLeaseRptDataTypeEnum.LIABILITY_BALANCE == this.rptDataType) {
            dataType = "rptEntry.FEndLiabilityBalance";
            initDataType = "rptEntry.FInitLiabilityBalance";
        }
        if (FaLeaseRptDataTypeEnum.UNCFM_FNC_COST == this.rptDataType) {
            dataType = "rptEntry.FEndUnCfmFncCost";
            initDataType = "rptEntry.FInitUnCfmFncCost";
        }
        if (FaLeaseRptDataTypeEnum.LIABILITY_PRINCIPAL == this.rptDataType) {
            dataType = "rptEntry.FEndLiabilityPrincipal";
            initDataType = "rptEntry.FInitLiabilityPrincipal";
        }
        if (FaLeaseRptDataTypeEnum.END_RIGHT_OF_USE_ASSET == this.rptDataType) {
            dataType = "rptEntry.FEndRightOfUseAsset";
            initDataType = "rptEntry.FInitRightOfUseAsset";
        }
        sql.append("lease.FID AS FID, ");
        sql.append("min(rptEntry.FDate) AS FLinkDate, ");
        for (int i = 0; i < this.dateColumnArray.length; ++i) {
            if (i == this.dateColumnArray.length - 1) {
                sql.append("max(case when rptEntry.FDate = {d '" + this.dateColumnArray[i] + "'} then " + dataType + " else 0 end) AS \"a" + this.dateColumnArray[i].replace('-', 'a') + "\" ");
                break;
            }
            sql.append("max(case when rptEntry.FDate = {d '" + this.dateColumnArray[i] + "'} then " + dataType + " else 0 end) AS \"a" + this.dateColumnArray[i].replace('-', 'a') + "\", ");
        }
        return sql.toString();
    }

    private void buildResultSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(this.selectTmp.replaceAll("t1\\.", ""));
        this.resultSql.setSelect(sql.toString());
        this.resultSql.setOrder(this.sorter);
    }

    private String buildQueryCardSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(this.selectTmp);
        sql.append(" FROM (").append(this.getLeaseBillTableSql()).append(") t1 \n");
        sql.append(" INNER JOIN (").append(this.getRptTableSql()).append(") t2 ON t1.FID = t2.FID \n");
        sql.append(" INNER JOIN (").append(this.getInitialMoneyTableSql()).append(") t3 ON t2.FID = t3.FID AND t2.FLinkDate = t3.FLinkDate \n");
        sql.append(" WHERE ").append(this.getCondSql());
        return sql.toString();
    }

    private String getLeaseBillTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(this.selectLeaseBill);
        sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
        sql.append(" LEFT JOIN ").append("T_ORG_Company company ON lease.FCompanyID = company.FID \n");
        sql.append(" LEFT JOIN ").append("T_BD_Currency currency ON lease.FCurrencyID = currency.FID \n");
        sql.append(" LEFT JOIN ").append("T_BD_Supplier supplierlessor ON lease.FSupplierLessorID = supplierlessor.FID \n");
        sql.append(" LEFT JOIN ").append("T_ORG_Company innercompanylessor ON lease.FInnerCompanyLessorID = innercompanylessor.FID \n");
        sql.append(" LEFT JOIN ").append("T_BD_Customer customerlessor ON lease.FCustomerLessorID = customerlessor.FID \n");
        sql.append(" LEFT JOIN ").append("T_FA_FAContractCat contractcat ON lease.FContractCatID = contractcat.FID \n");
        sql.append(" LEFT JOIN ").append("T_BD_Period AS period ON lease.FPeriodID = period.FID");
        sql.append(" WHERE ").append(" lease.FCheckedStatus = 2 \n");
        sql.append(" AND period.FNumber >= ").append(this.beginDateFrom);
        sql.append(" AND period.FNumber <= ").append(this.beginDateTo);
        if (this.contractType != null && !"".equals(this.contractType.getId().toString())) {
            sql.append(" AND ").append("contractcat.FNumber = '" + this.contractType.getNumber() + "'");
        }
        if (this.leaseBillNumber != null && !"".equals(this.leaseBillNumber)) {
            sql.append(" AND ").append("lease.FNumber like '%" + this.leaseBillNumber + "%'");
        }
        if (this.contractNumber != null && !"".equals(this.contractNumber)) {
            sql.append(" AND ").append("lease.FContractNumber = '" + this.contractNumber + "'");
        }
        if (this.exempted) {
            sql.append(" AND lease.FIsExempt='1'");
        } else if (this.exemptNG) {
            sql.append(" AND lease.FIsExempt='0'");
        }
        if (this.filter != null) {
            sql.append(" AND ").append(this.filter);
        }
        return sql.toString();
    }

    private String getRptTableSql() {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append(this.selectRpt);
        sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
        sql.append(" LEFT JOIN ").append("T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \n");
        sql.append(" LEFT JOIN ").append("T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \n");
        if (this.isVirCompany) {
            sql.append(" WHERE ").append("lease.FCompanyID in (" + this.strCompanyInclude + ")");
        } else {
            sql.append(" WHERE ").append("lease.FCompanyID = '" + this.company + "'");
        }
        sql.append(" GROUP BY ").append("lease.FID \n");
        return sql.toString();
    }

    private String getInitialMoneyTableSql() {
        String initDataType = "rptEntry.FInitLiabilityBalance";
        if (FaLeaseRptDataTypeEnum.LIABILITY_BALANCE == this.rptDataType) {
            initDataType = "rptEntry.FInitLiabilityBalance";
        }
        if (FaLeaseRptDataTypeEnum.UNCFM_FNC_COST == this.rptDataType) {
            initDataType = "rptEntry.FInitUnCfmFncCost";
        }
        if (FaLeaseRptDataTypeEnum.LIABILITY_PRINCIPAL == this.rptDataType) {
            initDataType = "rptEntry.FInitLiabilityPrincipal";
        }
        if (FaLeaseRptDataTypeEnum.END_RIGHT_OF_USE_ASSET == this.rptDataType) {
            initDataType = "rptEntry.FInitRightOfUseAsset";
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT ");
        sql.append("lease.FID AS FID, ");
        sql.append("rptEntry.FDate AS FLinkDate, ");
        sql.append(initDataType + " AS initialMoney ");
        sql.append(" FROM ").append("T_FA_FALEASEINBILLNEW lease \n");
        sql.append(" LEFT JOIN ").append("T_FA_FAAMORTIZEDCOSTRPT rpt ON lease.FID = rpt.FLeaseInBillID \n");
        sql.append(" LEFT JOIN ").append("T_FA_FAAMORTIZEDCOSTRPTENTRY rptEntry ON rptEntry.FAmortizedCostRptID = rpt.FID \n");
        if (this.isVirCompany) {
            sql.append(" WHERE ").append("lease.FCompanyID in (" + this.strCompanyInclude + ")");
        } else {
            sql.append(" WHERE ").append("lease.FCompanyID = '" + this.company + "'");
        }
        return sql.toString();
    }

    private String getCondSql() {
        StringBuilder condSql = new StringBuilder();
        condSql.append(" 1 = 1");
        return condSql.toString();
    }

    private void initConditionField(Map conditionMap) {
        this.company = (String)conditionMap.get("def_company_id");
        this.startDate = (Date)conditionMap.get("startDate");
        this.endDate = (Date)conditionMap.get("endDate");
        this.contractType = (FaContractCatInfo)conditionMap.get("contractType");
        this.leaseBillNumber = (String)conditionMap.get("leaseBillNumber");
        this.contractNumber = (String)conditionMap.get("contractNumber");
        this.rptDataType = (FaLeaseRptDataTypeEnum)((Object)conditionMap.get("rptDataType"));
        this.amountDisplayType = (FaLeaseAmountDisplayTypeEnum)((Object)conditionMap.get("amountDisplayType"));
        this.isByCompany = (Boolean)conditionMap.get("isByCompany");
        this.isByCurrency = (Boolean)conditionMap.get("isByCurrency");
        this.isByPersonType = (Boolean)conditionMap.get("isByPersonType");
        this.isByPerson = (Boolean)conditionMap.get("isByPerson");
        this.includeTerminateBill = (Boolean)conditionMap.get("includeTerminateBill");
        this.includeChangeBill = (Boolean)conditionMap.get("includeChangeBill");
        this.beginDateFrom = (Integer)conditionMap.get("beginDateFrom");
        this.beginDateTo = (Integer)conditionMap.get("beginDateTo");
        this.exempted = (Boolean)conditionMap.get("exempted");
        this.exemptNG = (Boolean)conditionMap.get("exemptNG");
        this.exemptALL = (Boolean)conditionMap.get("exemptALL");
    }

    private void initDateColumnArray() {
        Date currentDate = this.startDate;
        Date endDate = this.endDate;
        FaLeaseAmountDisplayTypeEnum amountDisplayType = this.amountDisplayType;
        if (amountDisplayType == FaLeaseAmountDisplayTypeEnum.BY_MONTH) {
            int subMonths = FaLeaseLiabilitiesRptUtil.subMonth(endDate, currentDate);
            this.dateColumnArray = new String[subMonths + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(FaLeaseLiabilitiesRptUtil.getMaxMonthDate(currentDate));
            for (int i = 1; i < subMonths + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextEndMonth(currentDate);
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        } else if (amountDisplayType == FaLeaseAmountDisplayTypeEnum.BY_SPRING) {
            int subSprings = FaLeaseLiabilitiesRptUtil.subSpring(endDate, currentDate);
            this.dateColumnArray = new String[subSprings + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(FaLeaseLiabilitiesRptUtil.getCurEndSpring(currentDate));
            for (int i = 1; i < subSprings + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextEndSpring(FaLeaseLiabilitiesRptUtil.getCurEndSpring(currentDate));
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        } else {
            int subYears = FaLeaseLiabilitiesRptUtil.subYear(endDate, currentDate);
            this.dateColumnArray = new String[subYears + 1];
            this.dateColumnArray[0] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            for (int i = 1; i < subYears + 1; ++i) {
                currentDate = FaLeaseLiabilitiesRptUtil.getNextYear(currentDate);
                this.dateColumnArray[i] = FaLeaseLiabilitiesRptUtil.changeDateToString(currentDate);
            }
        }
    }
}

