/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dataimp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLeaseTypeEnum;
import com.kingdee.eas.fi.nlm.FaLessorTypeEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPayFrequencyEnum;
import com.kingdee.eas.fi.nlm.FaRentTime;
import com.kingdee.eas.fi.nlm.app.dataimp.nlm.AbstractNLMBatchDataImport;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.record.IRecord;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FaLeaseInNewDataImport
extends AbstractNLMBatchDataImport {
    private static final Logger logger = Logger.getLogger(FaLeaseInNewDataImport.class);
    private static final HashSet<String> verifyFieldForNull = new HashSet();
    private Date dpInitCfmDate;

    public FaLeaseInNewDataImport() throws EASBizException, BOSException {
        super(verifyFieldForNull);
    }

    @Override
    protected void doBeforeProcessData(Context ctx) throws Exception {
        super.doBeforeProcessData(ctx);
        this.dpInitCfmDate = new Date(FaManageUtils.getFirstImplDateServer((Context)ctx, (CompanyOrgUnitInfo)this.company).getTime());
    }

    @Override
    protected void doProcessBlockData(Context ctx, RecordCollection coll) throws Exception {
        this.setAutoNumberCacheCount(coll.size() - 1);
        PreparedStatement pstmtInsert = null;
        Connection conn = null;
        StringBuilder sqlInsert = new StringBuilder();
        sqlInsert.append("INSERT INTO ").append(this.tempTable).append(" ( \n").append(this.getSelectTableField()).append(" ) values (newbosid('562AC667'),").append(this.getQuestionMarkMappingField()).append(")");
        FaNewLeasePolicyInfo newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(this.companyId);
        if (newLeasePolicy == null) {
            throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaNewLeasePolicyResource", (String)"Can_Not_Audit_Policy_Not_Set", (Locale)ctx.getOriginLocale())));
        }
        if (newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
            verifyFieldForNull.add("FDepEndDate");
            verifyFieldForNull.remove("FTimeCycle");
        } else {
            verifyFieldForNull.add("FTimeCycle");
            verifyFieldForNull.remove("FDepEndDate");
        }
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmtInsert = conn.prepareStatement(sqlInsert.toString());
            for (int rowIndex = 0; rowIndex < coll.size(); ++rowIndex) {
                boolean isInitEnd;
                ++this.index;
                IRecord rowData = coll.get(rowIndex);
                if (rowData == null) continue;
                this.rowNum = rowData.getRowNum();
                String FLeaseType = this.getData((SimpleRecord)rowData, "FLeaseType");
                if (!(FLeaseType.equals("0") || FLeaseType.equals("1") || FLeaseType.equals("2"))) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"298_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if (FLeaseType.equals("0") || FLeaseType.equals("2")) {
                    verifyFieldForNull.remove("FRentWithTax");
                    verifyFieldForNull.remove("FDepEndDate");
                    verifyFieldForNull.add("FFinanceInitialAsset");
                    verifyFieldForNull.add("FFinanceInitAccDepreciation");
                    verifyFieldForNull.add("FRemainingDepreciationPeriod");
                    verifyFieldForNull.add("FFinanceReLiabilityWithTax");
                    verifyFieldForNull.add("FFinanceReUnrFinExpenses");
                }
                String FNumber = this.getData((SimpleRecord)rowData, "FNumber");
                String FContractCat_number = this.getData((SimpleRecord)rowData, "FContractCat_number");
                String FContractName = this.getData((SimpleRecord)rowData, "FContractName");
                String FContractNumber = this.getData((SimpleRecord)rowData, "FContractNumber");
                String FiAccountDate = this.getData((SimpleRecord)rowData, "FFiAccountDate");
                String FDescription = this.getData((SimpleRecord)rowData, "FDescription");
                String FIsExistsFreePeriod = this.getData((SimpleRecord)rowData, "FIsExistsFreePeriod");
                String FBeginFreePeriodDate = this.getData((SimpleRecord)rowData, "FBeginFreePeriodDate");
                String FEndFreePeriodDate = this.getData((SimpleRecord)rowData, "FEndFreePeriodDate");
                String FBeginRentDate = this.getData((SimpleRecord)rowData, "FBeginRentDate");
                String FBeginDate = this.getData((SimpleRecord)rowData, "FBeginDate");
                String FEndDate = this.getData((SimpleRecord)rowData, "FEndDate");
                String FTimeCycle = this.getData((SimpleRecord)rowData, "FTimeCycle") == null ? "0" : this.getData((SimpleRecord)rowData, "FTimeCycle");
                String FirstPayTime = this.getData((SimpleRecord)rowData, "FFirstPayTime");
                String FTotalPayPeriod = this.getData((SimpleRecord)rowData, "FTotalPayPeriod");
                String FRentWithTax = this.getData((SimpleRecord)rowData, "FRentWithTax") == null ? "0" : this.getData((SimpleRecord)rowData, "FRentWithTax");
                String FRentTime = this.getData((SimpleRecord)rowData, "FRentTime");
                String FPayFrequency = this.getData((SimpleRecord)rowData, "FPayFrequency");
                String FCurrency_number = this.getData((SimpleRecord)rowData, "FCurrency_number");
                String FDiscountRate = this.getData((SimpleRecord)rowData, "FDiscountRate");
                String FInvoiceType = this.getData((SimpleRecord)rowData, "FInvoiceType");
                String FIsDeductible = this.getData((SimpleRecord)rowData, "FIsDeductible");
                String FTaxRate = this.getData((SimpleRecord)rowData, "FTaxRate");
                String FUseDepartment_number = this.getData((SimpleRecord)rowData, "FUseDepartment_number");
                String FCostCenter_number = this.getData((SimpleRecord)rowData, "FCostCenter_number");
                String FIsExempt = this.getData((SimpleRecord)rowData, "FIsExempt");
                String FIsExpire = this.getData((SimpleRecord)rowData, "FIsExpire");
                String FIsHistory = this.getData((SimpleRecord)rowData, "FIsHistory");
                String FLessorType = this.getData((SimpleRecord)rowData, "FLessorType");
                String FSupplierLessor_number = this.getData((SimpleRecord)rowData, "FSupplierLessor_number");
                String FCustomerLessor_number = this.getData((SimpleRecord)rowData, "FCustomerLessor_number");
                String FInnerCompanyLessor_number = this.getData((SimpleRecord)rowData, "FInnerCompanyLessor_number");
                String FStampTaxStM = this.getData((SimpleRecord)rowData, "FStampTaxStM");
                String FDepEndDate = this.getData((SimpleRecord)rowData, "FDepEndDate");
                String FinanceInitialAsset = this.getData((SimpleRecord)rowData, "FFinanceInitialAsset");
                String FinanceInitAccDepreciation = this.getData((SimpleRecord)rowData, "FFinanceInitAccDepreciation");
                String FRemainingDepreciationPeriod = this.getData((SimpleRecord)rowData, "FRemainingDepreciationPeriod");
                String FinanceReLiabilityWithTax = this.getData((SimpleRecord)rowData, "FFinanceReLiabilityWithTax");
                String FinanceReUnrFinExpenses = this.getData((SimpleRecord)rowData, "FFinanceReUnrFinExpenses");
                this.doIdFromIdNumberCache(ctx, "select 'FSup:" + FSupplierLessor_number + "' number, fid from T_BD_Supplier where FNumber = '" + FSupplierLessor_number + "'", "FSup:" + FSupplierLessor_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FCus:" + FCustomerLessor_number + "' number, fid from T_BD_Customer where FNumber = '" + FCustomerLessor_number + "'", "FCus:" + FCustomerLessor_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FInn:" + FInnerCompanyLessor_number + "' number, fid from T_ORG_Company where FNumber = '" + FInnerCompanyLessor_number + "'", "FInn:" + FInnerCompanyLessor_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FUse:" + FUseDepartment_number + "' number, fid from T_ORG_Admin where FNumber = '" + FUseDepartment_number + "'", "FUse:" + FUseDepartment_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FCos:" + FCostCenter_number + "' number, fid from T_ORG_CostCenter where FNumber = '" + FCostCenter_number + "'", "FCos:" + FCostCenter_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FCon:" + FContractCat_number + "' number, fid from T_FA_FAContractCat where FNumber = '" + FContractCat_number + "' and FCompanyID = '" + ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString() + "'", "FCon:" + FContractCat_number, false);
                this.doIdFromIdNumberCache(ctx, "select 'FCur:" + FCurrency_number + "' number, fid from T_BD_Currency where FNumber = '" + FCurrency_number + "'", "FCur:" + FCurrency_number, true);
                String supplierLessor_id = (String)this.idNumberCache.get("FSup:" + FSupplierLessor_number);
                String customerLessor_id = (String)this.idNumberCache.get("FCus:" + FCustomerLessor_number);
                String innerCompanyLessor_id = (String)this.idNumberCache.get("FInn:" + FInnerCompanyLessor_number);
                if (1 == Integer.parseInt(FLessorType) && supplierLessor_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"11_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FSupplierLessor_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"12_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if (2 == Integer.parseInt(FLessorType) && customerLessor_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"13_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FCustomerLessor_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"14_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if (3 == Integer.parseInt(FLessorType) && innerCompanyLessor_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"15_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FInnerCompanyLessor_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"16_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                String useDepartment_id = (String)this.idNumberCache.get("FUse:" + FUseDepartment_number);
                String costCenter_id = (String)this.idNumberCache.get("FCos:" + FCostCenter_number);
                if (FUseDepartment_number != null && useDepartment_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"17_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FUseDepartment_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"18_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if (FCostCenter_number != null && costCenter_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"19_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FCostCenter_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"20_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                String contractCat_id = (String)this.idNumberCache.get("FCon:" + FContractCat_number);
                String currency_id = (String)this.idNumberCache.get("FCur:" + FCurrency_number);
                if (contractCat_id != null && contractCat_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"21_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FContractCat_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"22_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if (currency_id != null && currency_id.length() == 0) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"23_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FCurrency_number + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"24_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                BigDecimal onePlusTaxRate = new BigDecimal(FTaxRate).divide(new BigDecimal("100")).add(new BigDecimal("1"));
                BigDecimal rentWithoutTaxValue = new BigDecimal(FRentWithTax).divide(onePlusTaxRate, this.currencyPrecision, 4);
                BigDecimal FTaxAmount = new BigDecimal(FRentWithTax).subtract(rentWithoutTaxValue);
                BigDecimal FRentPerPeriod = BigDecimal.ZERO;
                if (FaPayFrequencyEnum.getEnum(Integer.parseInt(FPayFrequency)) != FaPayFrequencyEnum.PAY_IN_ADVANCE) {
                    FRentPerPeriod = new BigDecimal(FRentWithTax).divide(new BigDecimal(FTotalPayPeriod), this.currencyPrecision, 4);
                }
                int FLeaseCycle = this.getLeaseCycle(this.handleDateValue("FBeginDate", FBeginDate), this.handleDateValue("FEndDate", FEndDate));
                BigDecimal FExchangeRateValue = this.getRecentExChangeRate(ctx, this.handleDateValue("FBeginDate", FBeginDate), currency_id);
                if (FExchangeRateValue == null) {
                    this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"25_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"26_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                }
                if ((isInitEnd = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)this.company)) && Boolean.parseBoolean(FIsHistory)) {
                    this.onDataError(this.rowNum, FNumber + ":" + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.FaLeaseNewResource", (String)"Init_End", (Locale)ctx.getLocale()));
                }
                if (!this.isSltImportUpdate()) {
                    try {
                        if (this.isCodingRule && this.isViewCodeRule) {
                            FNumber = this.getAutoNumber(ctx);
                        }
                    }
                    catch (Exception ex) {
                        this.onDataError(this.rowNum, ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"25_FaLeaseInNewDataImport", (Locale)ctx.getLocale()) + FNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"27_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                    }
                }
                pstmtInsert.setInt(1, 1);
                pstmtInsert.setInt(2, 1);
                pstmtInsert.setString(3, this.cuId);
                pstmtInsert.setDate(4, this.importDate);
                pstmtInsert.setString(5, this.userId);
                pstmtInsert.setDate(6, this.importDate);
                pstmtInsert.setString(7, this.userId);
                pstmtInsert.setDate(8, this.importDate);
                pstmtInsert.setString(9, this.companyId);
                pstmtInsert.setString(10, this.currentPeriod.getId().toString());
                pstmtInsert.setString(11, FNumber);
                pstmtInsert.setString(12, contractCat_id);
                pstmtInsert.setString(13, FContractName);
                pstmtInsert.setString(14, FContractNumber);
                pstmtInsert.setDate(15, this.handleDateValue("FiAccountDate", FiAccountDate));
                pstmtInsert.setString(16, FDescription);
                pstmtInsert.setBoolean(17, Boolean.parseBoolean(FIsExistsFreePeriod));
                pstmtInsert.setDate(18, this.handleDateValue("FBeginFreePeriodDate", FBeginFreePeriodDate));
                pstmtInsert.setDate(19, this.handleDateValue("FEndFreePeriodDate", FEndFreePeriodDate));
                pstmtInsert.setDate(20, this.handleDateValue("FBeginRentDate", FBeginRentDate));
                pstmtInsert.setDate(21, this.handleDateValue("FBeginDate", FBeginDate));
                pstmtInsert.setDate(22, this.handleDateValue("FEndDate", FEndDate));
                pstmtInsert.setInt(23, Integer.parseInt(FTimeCycle));
                pstmtInsert.setDate(24, this.handleDateValue("FirstPayTime", FirstPayTime));
                pstmtInsert.setInt(25, Integer.parseInt(FTotalPayPeriod));
                pstmtInsert.setBigDecimal(26, new BigDecimal(FRentWithTax));
                pstmtInsert.setInt(27, Integer.parseInt(FRentTime));
                pstmtInsert.setInt(28, Integer.parseInt(FPayFrequency));
                pstmtInsert.setString(29, currency_id);
                pstmtInsert.setBigDecimal(30, new BigDecimal(FDiscountRate));
                pstmtInsert.setInt(31, Integer.parseInt(FInvoiceType));
                pstmtInsert.setBoolean(32, Boolean.parseBoolean(FIsDeductible));
                pstmtInsert.setBigDecimal(33, new BigDecimal(FTaxRate));
                pstmtInsert.setString(34, useDepartment_id);
                pstmtInsert.setString(35, costCenter_id);
                pstmtInsert.setBoolean(36, Boolean.parseBoolean(FIsExempt));
                pstmtInsert.setBoolean(37, Boolean.parseBoolean(FIsExpire));
                pstmtInsert.setBoolean(38, Boolean.parseBoolean(FIsHistory));
                pstmtInsert.setInt(39, Integer.parseInt(FLessorType));
                pstmtInsert.setString(40, supplierLessor_id);
                pstmtInsert.setString(41, customerLessor_id);
                pstmtInsert.setString(42, innerCompanyLessor_id);
                pstmtInsert.setBigDecimal(43, new BigDecimal(FStampTaxStM == null ? "0" : FStampTaxStM));
                pstmtInsert.setString(44, FLeaseType);
                pstmtInsert.setBigDecimal(45, FTaxAmount);
                pstmtInsert.setBigDecimal(46, FRentPerPeriod);
                pstmtInsert.setInt(47, FLeaseCycle);
                pstmtInsert.setBigDecimal(48, FExchangeRateValue);
                pstmtInsert.setBigDecimal(49, BigDecimal.ZERO);
                pstmtInsert.setDate(50, this.dpInitCfmDate);
                pstmtInsert.setDate(51, this.handleDateValue("FDepEndDate", FDepEndDate));
                pstmtInsert.setBigDecimal(52, new BigDecimal(FinanceInitialAsset == null ? "0" : FinanceInitialAsset));
                pstmtInsert.setBigDecimal(53, new BigDecimal(FinanceInitAccDepreciation == null ? "0" : FinanceInitAccDepreciation));
                pstmtInsert.setInt(54, Integer.parseInt(FRemainingDepreciationPeriod == null ? "0" : FRemainingDepreciationPeriod));
                pstmtInsert.setBigDecimal(55, new BigDecimal(FinanceReLiabilityWithTax == null ? "0" : FinanceReLiabilityWithTax));
                pstmtInsert.setBigDecimal(56, new BigDecimal(FinanceReUnrFinExpenses == null ? "0" : FinanceReUnrFinExpenses));
                pstmtInsert.addBatch();
            }
            pstmtInsert.executeBatch();
        }
        catch (SQLException e1) {
            try {
                throw new TaskExternalException(e1.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtInsert, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtInsert, (Connection)conn);
    }

    @Override
    protected boolean batchVerifyData(Context ctx) throws Exception {
        this.batchVerifyNumber(ctx);
        return true;
    }

    @Override
    protected int submitData(Context ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        if (this.isSltImportUpdate()) {
            sql.append("delete from T_FA_FaLeaseInBillNew where fid in ( \n");
            sql.append("    select lease.FID fid from T_FA_FaLeaseInBillNew lease ");
            sql.append("    inner join ").append(this.tempTable).append(" t ON lease.FNumber = t.FNumber AND lease.FCompanyID = t.FCompanyID); \n");
        }
        sql.append("insert into T_FA_FaLeaseInBillNew ( \n");
        sql.append(this.getSelectTableField());
        sql.append(") \n");
        sql.append("select  \n");
        sql.append(this.getSelectTableField());
        sql.append("from ").append(this.tempTable).append(";\n");
        FaLeaseInNewDataImport.BatchSqlExecute(ctx, sql.toString(), ";");
        sql.setLength(0);
        sql.append("select count(*) from ").append(this.tempTable).append(" \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    @Override
    protected String typeResolution(String key, String value, SimpleRecord record) {
        String FPayFrequency;
        String result = null;
        if ("FTimeCycle".equals(key) && "0".equals(value)) {
            result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"28_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
        }
        if ("FRentTime".equals(key)) {
            try {
                FaRentTime.getEnum(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
                result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"29_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
            }
        }
        if ("FPayFrequency".equals(key)) {
            try {
                FaPayFrequencyEnum.getEnum(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
                result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"30_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
            }
        }
        if ("FLessorType".equals(key)) {
            try {
                FaLessorTypeEnum.getEnum(Integer.parseInt(value));
            }
            catch (Exception e) {
                logger.error((Object)e);
                result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"31_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
            }
        }
        if ("FFirstPayTime".equals(key) && (FPayFrequency = this.getDataTmp(record, "FPayFrequency")) != null && !"6".equals(FPayFrequency) && (value == null || value.length() == 0)) {
            result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"32_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
        }
        if ("FLeaseType".equals(key)) {
            try {
                FaLeaseTypeEnum.getEnum(value);
            }
            catch (Exception e) {
                logger.error((Object)e);
                result = ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"33_FaLeaseInNewDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
            }
        }
        return result;
    }

    @Override
    protected IObjectValue setNullBillInfo() {
        FaLeaseInBillNewInfo faLeaseInBillNewInfo = new FaLeaseInBillNewInfo();
        faLeaseInBillNewInfo.setCompany(this.company);
        return faLeaseInBillNewInfo;
    }

    @Override
    protected void verifyNumberAndRemove(Context ctx, String numbers) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FNumber FROM T_FA_FALEASEINBILLNEW WHERE FNUMBER in (").append(numbers).append(")");
        sql.append(" AND FCOMPANYID = '").append(this.company.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rowSet.next()) {
            this.numberContainerCache.remove(rowSet.getString("FNumber"));
        }
    }

    @Override
    protected String getCreateTmpTableField() {
        StringBuilder sql = new StringBuilder();
        sql.append("     FID VARCHAR(44), \n");
        sql.append("     FEffectedStatus INT, \n");
        sql.append("     FCheckedStatus INT, \n");
        sql.append("     FControlUnitID VARCHAR(44), \n");
        sql.append("     FLastUpdateTime DATETIME, \n");
        sql.append("     FLastUpdateUserID VARCHAR(44), \n");
        sql.append("     FCreateTime DATETIME, \n");
        sql.append("     FCreatorID VARCHAR(44), \n");
        sql.append("     FBizDate DATETIME, \n");
        sql.append("     FCompanyID VARCHAR(44), \n");
        sql.append("     FPeriodID VARCHAR(44), \n");
        sql.append("     FNumber NVARCHAR(44), \n");
        sql.append("     FContractCatID VARCHAR(44), \n");
        sql.append("     FContractName VARCHAR(200), \n");
        sql.append("     FContractNumber VARCHAR(200), \n");
        sql.append("     FiAccountDate DATETIME, \n");
        sql.append("     FDescription VARCHAR(44), \n");
        sql.append("     FIsExistsFreePeriod INT, \n");
        sql.append("     FBeginFreePeriodDate DATETIME, \n");
        sql.append("     FEndFreePeriodDate DATETIME, \n");
        sql.append("     FBeginRentDate DATETIME, \n");
        sql.append("     FBeginDate DATETIME, \n");
        sql.append("     FEndDate DATETIME, \n");
        sql.append("     FTimeCycle INT, \n");
        sql.append("     FirstPayTime DATETIME, \n");
        sql.append("     FTotalPayPeriod INT, \n");
        sql.append("     FRentWithTax NUMERIC(19, 8), \n");
        sql.append("     FRentTime INT, \n");
        sql.append("     FPayFrequency INT,  \n");
        sql.append("     FCurrencyID VARCHAR(44), \n");
        sql.append("     FDiscountRate NUMERIC(19, 8), \n");
        sql.append("     FInvoiceType INT, \n");
        sql.append("     FIsDeductible INT, \n");
        sql.append("     FTaxRate NUMERIC(19, 8), \n");
        sql.append("     FUseDepartmentID VARCHAR(44), \n");
        sql.append("     FCostCenterID VARCHAR(44), \n");
        sql.append("     FIsExempt INT, \n");
        sql.append("     FIsExpire INT, \n");
        sql.append("     FIsHistory INT, \n");
        sql.append("     FLessorType INT, \n");
        sql.append("     FSupplierLessorID VARCHAR(44), \n");
        sql.append("     FCustomerLessorID VARCHAR(44), \n");
        sql.append("     FInnerCompanyLessorID VARCHAR(44), \n");
        sql.append("     FStampTaxStM NUMERIC(19, 8), \n");
        sql.append("     FLeaseType VARCHAR(44), \n");
        sql.append("     FTaxAmount NUMERIC(19, 8), \n");
        sql.append("     FRentPerPeriod NUMERIC(19, 8), \n");
        sql.append("     FLeaseCycle INT, \n");
        sql.append("     FExchangeRateValue NUMERIC(19, 8), \n");
        sql.append("     FHasPayedRent NUMERIC(19, 8), \n");
        sql.append("     FDpInitCfmDate DATETIME, \n");
        sql.append("     FDepEndDate DATETIME, \n");
        sql.append("     FinanceInitialAsset NUMERIC(19, 8), \n");
        sql.append("     FinanceInitAccDepreciation NUMERIC(19, 8), \n");
        sql.append("     FRemainingDepreciationPeriod INT, \n");
        sql.append("     FinanceReLiabilityWithTax NUMERIC(19, 8), \n");
        sql.append("     FinanceReUnrFinExpenses NUMERIC(19, 8)  \n");
        return sql.toString();
    }

    @Override
    protected String getSelectTableField() {
        StringBuilder sql = new StringBuilder();
        sql.append("     FID, \n");
        sql.append("     FEffectedStatus, \n");
        sql.append("     FCheckedStatus, \n");
        sql.append("     FControlUnitID, \n");
        sql.append("     FLastUpdateTime, \n");
        sql.append("     FLastUpdateUserID, \n");
        sql.append("     FCreateTime, \n");
        sql.append("     FCreatorID, \n");
        sql.append("     FBizDate, \n");
        sql.append("     FCompanyID, \n");
        sql.append("     FPeriodID, \n");
        sql.append("     FNumber, \n");
        sql.append("     FContractCatID, \n");
        sql.append("     FContractName, \n");
        sql.append("     FContractNumber, \n");
        sql.append("     FiAccountDate, \n");
        sql.append("     FDescription, \n");
        sql.append("     FIsExistsFreePeriod, \n");
        sql.append("     FBeginFreePeriodDate, \n");
        sql.append("     FEndFreePeriodDate, \n");
        sql.append("     FBeginRentDate, \n");
        sql.append("     FBeginDate, \n");
        sql.append("     FEndDate, \n");
        sql.append("     FTimeCycle, \n");
        sql.append("     FirstPayTime, \n");
        sql.append("     FTotalPayPeriod, \n");
        sql.append("     FRentWithTax, \n");
        sql.append("     FRentTime, \n");
        sql.append("     FPayFrequency,  \n");
        sql.append("     FCurrencyID, \n");
        sql.append("     FDiscountRate, \n");
        sql.append("     FInvoiceType, \n");
        sql.append("     FIsDeductible, \n");
        sql.append("     FTaxRate, \n");
        sql.append("     FUseDepartmentID, \n");
        sql.append("     FCostCenterID, \n");
        sql.append("     FIsExempt, \n");
        sql.append("     FIsExpire, \n");
        sql.append("     FIsHistory, \n");
        sql.append("     FLessorType, \n");
        sql.append("     FSupplierLessorID, \n");
        sql.append("     FCustomerLessorID, \n");
        sql.append("     FInnerCompanyLessorID, \n");
        sql.append("     FStampTaxStM, \n");
        sql.append("     FLeaseType, \n");
        sql.append("     FTaxAmount, \n");
        sql.append("     FRentPerPeriod, \n");
        sql.append("     FLeaseCycle, \n");
        sql.append("     FExchangeRateValue, \n");
        sql.append("     FHasPayedRent, \n");
        sql.append("     FDpInitCfmDate, \n");
        sql.append("     FDepEndDate, \n");
        sql.append("     FinanceInitialAsset, \n");
        sql.append("     FinanceInitAccDepreciation, \n");
        sql.append("     FRemainingDepreciationPeriod, \n");
        sql.append("     FinanceReLiabilityWithTax, \n");
        sql.append("     FinanceReUnrFinExpenses  \n");
        return sql.toString();
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.fa.manage.FaLeaseInNewExportQuery";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", this.getNotBlankString(rs.getString("number")));
            result.put("FContractCat_number", this.getNotBlankString(rs.getString("contractCat.number")));
            result.put("FContractName", this.getNotBlankString(rs.getString("contractName")));
            result.put("FContractNumber", this.getNotBlankString(rs.getString("contractNumber")));
            result.put("FFiAccountDate", this.getNotBlankString(rs.getString("fiAccountDate")));
            result.put("FDescription", this.getNotBlankString(rs.getString("description")));
            result.put("FIsExistsFreePeriod", this.getNotBlankString(rs.getString("isExistsFreePeriod")));
            result.put("FBeginFreePeriodDate", this.getNotBlankString(rs.getString("beginFreePeriodDate")));
            result.put("FEndFreePeriodDate", this.getNotBlankString(rs.getString("endFreePeriodDate")));
            result.put("FBeginRentDate", this.getNotBlankString(rs.getString("beginRentDate")));
            result.put("FBeginDate", this.getNotBlankString(rs.getString("beginDate")));
            result.put("FEndDate", this.getNotBlankString(rs.getString("endDate")));
            result.put("FTimeCycle", this.getNotBlankString(rs.getString("timeCycle")));
            result.put("FFirstPayTime", this.getNotBlankString(rs.getString("firstPayTime")));
            result.put("FTotalPayPeriod", this.getNotBlankString(rs.getString("totalPayPeriod")));
            result.put("FRentWithTax", this.getNotBlankString(rs.getString("rentWithTax")));
            result.put("FRentTime", this.getNotBlankString(rs.getString("rentTime")));
            result.put("FPayFrequency", this.getNotBlankString(rs.getString("payFrequency")));
            result.put("FCurrency_number", this.getNotBlankString(rs.getString("currency.number")));
            result.put("FDiscountRate", this.getNotBlankString(rs.getString("discountRate")));
            result.put("FInvoiceType", this.getNotBlankString(rs.getString("invoiceType")));
            result.put("FIsDeductible", this.getNotBlankString(rs.getString("isDeductible")));
            result.put("FTaxRate", this.getNotBlankString(rs.getString("taxRate")));
            result.put("FUseDepartment_number", this.getNotBlankString(rs.getString("useDepartment.number")));
            result.put("FCostCenter_number", this.getNotBlankString(rs.getString("costCenter.number")));
            result.put("FIsExempt", this.getNotBlankString(rs.getString("isExempt")));
            result.put("FIsExpire", this.getNotBlankString(rs.getString("isExpire")));
            result.put("FIsHistory", this.getNotBlankString(rs.getString("isHistory")));
            result.put("FLessorType", this.getNotBlankString(rs.getString("lessorType")));
            result.put("FSupplierLessor_number", this.getNotBlankString(rs.getString("supplierLessor.number")));
            result.put("FCustomerLessor_number", this.getNotBlankString(rs.getString("customerLessor.number")));
            result.put("FInnerCompanyLessor_number", this.getNotBlankString(rs.getString("innerCompanyLessor.number")));
            result.put("FStampTaxStM", this.getNotBlankString(rs.getString("stampTaxStM")));
            result.put("FLeaseType", this.getNotBlankString(rs.getString("leaseType")));
            result.put("FDepEndDate", this.getNotBlankString(rs.getString("depEndDate")));
            result.put("FFinanceInitialAsset", this.getNotBlankString(rs.getString("financeInitialAsset")));
            result.put("FFinanceInitAccDepreciation", this.getNotBlankString(rs.getString("financeInitAccDepreciation")));
            result.put("FRemainingDepreciationPeriod", this.getNotBlankString(rs.getString("remainingDepreciationPeriod")));
            result.put("FFinanceReLiabilityWithTax", this.getNotBlankString(rs.getString("financeReLiabilityWithTax")));
            result.put("FFinanceReUnrFinExpenses", this.getNotBlankString(rs.getString("financeReUnrFinExpenses")));
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private void batchVerifyNumber(Context ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append(" select tmp.FNumber number, lease.FID leaseID from ").append(this.tempTable).append(" tmp \n");
        sql.append(" left join T_FA_FaLeaseInBillNew lease on tmp.FNumber = lease.FNumber AND lease.FCompanyID = tmp.FCompanyID \n");
        StringBuilder errorMessage = new StringBuilder();
        if (this.isSltImportUpdate()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + " where lease.FID is null \n"));
            while (rs.next()) {
                errorMessage.append(rs.getString("number")).append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"34_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                if (errorMessage.length() <= 100) continue;
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)(sql.toString() + " where lease.FID is not null and lease.FCheckedStatus = 2 and lease.FIsHistory = 0 \n"));
            while (rs.next()) {
                errorMessage.append(rs.getString("number")).append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"35_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                if (errorMessage.length() <= 100) continue;
                break;
            }
        } else {
            sql.append(" where lease.FID is not null \n");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                errorMessage.append(rs.getString("number")).append(ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"36_FaLeaseInNewDataImport", (Locale)ctx.getLocale()));
                if (errorMessage.length() <= 100) continue;
            }
        }
        if (errorMessage.length() != 0) {
            this.onDataError(0, errorMessage.toString());
        }
    }

    private int getLeaseCycle(java.util.Date beginDate, java.util.Date endDate) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(beginDate);
        c2.setTime(endDate);
        int monthCount = c2.get(2) - c1.get(2);
        int yearCount = (c2.get(1) - c1.get(1)) * 12;
        int dayCount = c2.get(5) - c1.get(5);
        int leaseCycleValue = monthCount + yearCount;
        if (dayCount >= 0) {
            ++leaseCycleValue;
        }
        return leaseCycleValue;
    }

    private BigDecimal getRecentExChangeRate(Context ctx, java.util.Date beginDate, String currencyID) throws TaskExternalException {
        if (beginDate == null || currencyID == null || currencyID.length() == 0) {
            return null;
        }
        String bseCurrencyID = this.company.getBaseCurrency().getId().toString();
        if (bseCurrencyID.equals(currencyID)) {
            return new BigDecimal("1");
        }
        try {
            IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("number");
            selector.add("convertRate");
            selector.add("availTime");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("exChangeAux.sourceCurrency.id", (Object)currencyID));
            filter.getFilterItems().add(new FilterItemInfo("exChangeAux.targetCurrency.id", (Object)bseCurrencyID));
            filter.getFilterItems().add(new FilterItemInfo("exChangeAux.exchangeTable.id", (Object)this.company.getBaseExchangeTable().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)beginDate, CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invalidTime", (Object)beginDate, CompareType.GREATER));
            SorterItemCollection sorter = new SorterItemCollection();
            SorterItemInfo sorterItemInfo = new SorterItemInfo("availTime");
            sorterItemInfo.setSortType(SortType.DESCEND);
            sorter.add(sorterItemInfo);
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(selector);
            view.setFilter(filter);
            view.setSorter(sorter);
            view.setTopCount(1);
            ExchangeRateCollection rateCol = iExchangeRate.getExchangeRateCollection(view);
            if (rateCol != null && rateCol.size() > 0) {
                return rateCol.get(0).getConvertRate();
            }
        }
        catch (BOSException ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
        return new BigDecimal("1");
    }

    static {
        verifyFieldForNull.add("FNumber");
        verifyFieldForNull.add("FLeaseType");
        verifyFieldForNull.add("FContractCat_number");
        verifyFieldForNull.add("FContractName");
        verifyFieldForNull.add("FiAccountDate");
        verifyFieldForNull.add("FIsExistsFreePeriod");
        verifyFieldForNull.add("FBeginRentDate");
        verifyFieldForNull.add("FBeginDate");
        verifyFieldForNull.add("FEndDate");
        verifyFieldForNull.add("FTotalPayPeriod");
        verifyFieldForNull.add("FRentWithTax");
        verifyFieldForNull.add("FRentTime");
        verifyFieldForNull.add("FCurrency_number");
        verifyFieldForNull.add("FDiscountRate");
        verifyFieldForNull.add("FInvoiceType");
        verifyFieldForNull.add("FIsDeductible");
        verifyFieldForNull.add("FTaxRate");
    }
}

