/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.dataimp.nlm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.app.dataimp.nlm.NLMTaskBlockDataRunner;
import com.kingdee.eas.fi.nlm.app.utils.FlLocalUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.BlockDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.log.ILog;
import com.kingdee.eas.tools.datatask.log.SysLog;
import com.kingdee.eas.tools.datatask.record.RecordCollection;
import com.kingdee.eas.tools.datatask.record.SimpleRecord;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.tools.datatask.task.TaskExternalCode;
import com.kingdee.eas.tools.datatask.task.util.TaskRunnerException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class AbstractNLMBatchDataImport
extends BlockDataTransmission {
    private static final Logger logger = SysLog.getLogger(AbstractNLMBatchDataImport.class);
    public static final String ConnectionKey = "ConnectionKey";
    protected final HashSet<String> verifyFieldForNull;
    protected final HashMap<String, String> idNumberCache = new HashMap();
    private final StringBuilder idSqlQueryString = new StringBuilder();
    private int idSqlCount = 0;
    private NLMTaskBlockDataRunner runner = null;
    protected CompanyOrgUnitInfo company = null;
    protected String companyId = null;
    protected String userId = null;
    protected String cuId = null;
    protected String personId = null;
    protected PeriodInfo currentPeriod = null;
    protected Date importDate = new Date(new java.util.Date().getTime());
    protected IObjectValue nullBillInfo;
    protected boolean isCodingRule;
    protected boolean isViewCodeRule;
    protected ICodingRuleManager iCodingRuleManager;
    protected List<String> numberContainerCache = new ArrayList<String>();
    protected int autoNumberCacheCount = 1;
    protected int currencyPrecision = 2;
    protected String tempTable = null;
    protected int index = -1;
    protected int rowNum;

    public AbstractNLMBatchDataImport(HashSet<String> verifyFieldForNull) {
        this.verifyFieldForNull = verifyFieldForNull;
    }

    public void importFile(Context ctx, TaskExternalCode task) throws TaskExternalException {
        try {
            this.runner = new NLMTaskBlockDataRunner(task, this, ctx);
            this.index = this.runner.getBeginIndex();
            this.importTask = task;
            this.setLog((ILog)this.runner.getTaskLog());
            this.runner.run();
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    protected void doBeforeProcessData(Context ctx) throws Exception {
        this.company = ContextUtil.getCurrentFIUnit((Context)ctx);
        this.companyId = this.company.getId().toString();
        this.userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        if (ContextUtil.getCurrentUserInfo((Context)ctx).getPerson() != null) {
            this.personId = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson().getId().toString();
        }
        this.cuId = ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString();
        this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)ContextUtil.getCurrentFIUnit((Context)ctx));
        CurrencyInfo baseCurrency = this.company.getBaseCurrency();
        this.currencyPrecision = FlLocalUtils.getCurrencyScale(baseCurrency.getId(), ctx);
        this.nullBillInfo = this.setNullBillInfo();
        this.iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        this.isCodingRule = this.iCodingRuleManager.isExist(this.nullBillInfo, this.company.getId().toString());
        this.isViewCodeRule = this.iCodingRuleManager.isAddView(this.nullBillInfo, this.company.getId().toString());
        this.autoNumberCacheCount = this.getAutoNumberCacheCount();
        String sql = this.buildTempTableSQL();
        if (sql != null && sql.length() > 0) {
            this.tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql);
        }
    }

    protected String buildTempTableSQL() {
        StringBuffer sql = new StringBuffer();
        sql.append("create table NLM_LEASE_TMP ( \n");
        sql.append(this.getCreateTmpTableField());
        sql.append(" ) \n");
        return sql.toString();
    }

    protected abstract String getCreateTmpTableField();

    protected abstract String getSelectTableField();

    protected abstract void doProcessBlockData(Context var1, RecordCollection var2) throws Exception;

    protected int doProcessData(Context ctx) throws Exception {
        if (this.batchVerifyData(ctx)) {
            return this.submitData(ctx);
        }
        return 0;
    }

    protected boolean batchVerifyData(Context ctx) throws Exception {
        return true;
    }

    protected abstract int submitData(Context var1) throws Exception;

    protected void doAfterProcessData(Context ctx) {
        if (this.tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(this.tempTable);
        }
    }

    public String getDataTmp(SimpleRecord record, String key) {
        Object value;
        String result = null;
        DataToken token = record.get(key);
        if (token != null && (value = token.data) != null && (result = value.toString().trim()).length() == 0) {
            result = null;
        }
        return result;
    }

    public String getData(SimpleRecord record, String key) throws TaskRunnerException {
        String tmpMessage;
        Object value;
        String result = null;
        DataToken token = record.get(key);
        if (token != null && (value = token.data) != null && (result = value.toString().trim()).length() == 0) {
            result = null;
        }
        if ((tmpMessage = this.verifyFieldForNull(key, record.get((String)key).desc, result)) != null) {
            this.onDataError(this.rowNum, tmpMessage);
        }
        if ((tmpMessage = this.verifyFieldForTypeResolution(key, result, record)) != null) {
            this.onDataError(this.rowNum, tmpMessage);
        }
        return result;
    }

    private String verifyFieldForNull(String key, String keyName, String result) {
        if ((result == null || result.length() == 0) && this.verifyFieldForNull.contains(key)) {
            return keyName + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"286_AbstractNLMBatchDataImport", (Locale)ContextUtils.getContextFromSession().getLocale());
        }
        return null;
    }

    private String verifyFieldForTypeResolution(String key, String value, SimpleRecord record) {
        return this.typeResolution(key, value, record);
    }

    protected abstract String typeResolution(String var1, String var2, SimpleRecord var3);

    protected void doIdFromIdNumberCache(Context ctx, String sql, String number, boolean isQueryData) throws BOSException, TaskRunnerException, SQLException {
        if (number == null || number.length() == 0) {
            return;
        }
        if (!isQueryData && this.idNumberCache.containsKey(number)) {
            return;
        }
        if (isQueryData && this.idNumberCache.containsKey(number) && this.idSqlQueryString.length() == 0) {
            return;
        }
        this.idNumberCache.put(number, null);
        ++this.idSqlCount;
        if (isQueryData) {
            this.idSqlQueryString.append(sql);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.idSqlQueryString.toString());
            if (rs.size() > this.idSqlCount) {
                this.onDataError(0, this.idSqlQueryString.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"287_AbstractNLMBatchDataImport", (Locale)ctx.getLocale()));
            }
            while (rs.next()) {
                this.idNumberCache.put(rs.getString("number"), rs.getString("FID") == null ? "" : rs.getString("FID"));
            }
            this.idSqlCount = 0;
            this.idSqlQueryString.setLength(0);
        } else {
            this.idSqlQueryString.append(sql).append("\n").append("union all").append("\n");
        }
    }

    protected String getQuestionMarkMappingField() {
        StringBuilder sql = new StringBuilder();
        String[] tmp = this.getSelectTableField().split(",");
        int j = tmp.length;
        for (int i = 1; i < j; ++i) {
            if (i == tmp.length - 1) {
                sql.append("?");
                continue;
            }
            sql.append("?,");
        }
        return sql.toString();
    }

    protected Date handleDateValue(String name, String value) throws TaskExternalException {
        if (value == null) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            java.util.Date date = sdf.parse(value);
            String dateString = sdf.format(date);
            return new Date(sdf.parse(dateString).getTime());
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(name + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"288_AbstractNLMBatchDataImport", (Locale)ContextUtils.getContextFromSession().getLocale()) + value + ResourceBase.getString((String)"com.kingdee.eas.fi.nlm.NLMAutoGenerateResource", (String)"289_AbstractNLMBatchDataImport", (Locale)ContextUtils.getContextFromSession().getLocale()));
        }
    }

    protected String getAutoNumber(Context ctx) throws EASBizException, BOSException, SQLException {
        if (!this.numberContainerCache.isEmpty()) {
            String result = this.numberContainerCache.iterator().next();
            this.numberContainerCache.remove(result);
            return result;
        }
        String[] numbers = this.iCodingRuleManager.getBatchNumber(this.nullBillInfo, this.company.getId().toString(), this.autoNumberCacheCount);
        StringBuilder numbersString = new StringBuilder();
        int j = numbers.length;
        for (int i = 0; i < j; ++i) {
            if (i == j - 1) {
                numbersString.append("'").append(numbers[i]).append("'");
            } else {
                numbersString.append("'").append(numbers[i]).append("', ");
            }
            this.numberContainerCache.add(numbers[i]);
        }
        this.verifyNumberAndRemove(ctx, numbersString.toString());
        String result = this.numberContainerCache.iterator().next();
        this.numberContainerCache.remove(result);
        return result;
    }

    protected abstract IObjectValue setNullBillInfo();

    protected int getAutoNumberCacheCount() {
        return this.autoNumberCacheCount;
    }

    protected void setAutoNumberCacheCount(int autoNumberCacheCount) {
        this.autoNumberCacheCount = autoNumberCacheCount;
    }

    protected abstract void verifyNumberAndRemove(Context var1, String var2) throws BOSException, SQLException;

    protected void onDataError(int nCurCount, Object error) throws TaskRunnerException {
        this.runner.onDataError(nCurCount, error);
    }

    protected void onDataErrorForWeb(int nCurCount, Object error) {
    }

    protected String getNotBlankString(String str) {
        return str == null ? "" : str;
    }

    protected String getTempTable() {
        return this.tempTable;
    }

    protected String getCompanyId() {
        return this.companyId;
    }

    protected String getCUId() {
        return this.cuId;
    }

    public static void BatchSqlExecute(Context ctx, String sql, String separator) throws BOSException {
        String[] list = sql.split(separator);
        AbstractNLMBatchDataImport.BatchSqlExecute(ctx, list);
    }

    public static void BatchSqlExecute(Context ctx, String[] sqlList) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuilder sb = new StringBuilder();
        boolean isNewGetConnection = false;
        int i = 0;
        try {
            conn = (Connection)ctx.get((Object)ConnectionKey);
            if (conn == null) {
                isNewGetConnection = true;
                conn = EJBFactory.getConnection((Context)ctx);
            }
            statement = conn.createStatement();
            while (i < sqlList.length) {
                if (sqlList[i].trim().length() > 0) {
                    statement.addBatch(sqlList[i]);
                    sb.append(sqlList[i]).append(" ; ");
                }
                ++i;
            }
            long timeFrom = System.currentTimeMillis();
            int[] rowNum = statement.executeBatch();
            long l = System.currentTimeMillis();
        }
        catch (SQLException exc) {
            try {
                logger.error((Object)AbstractNLMBatchDataImport.buildLogString(sqlList), (Throwable)exc);
                throw new BOSException("\r\nSQL is: " + Arrays.toString(sqlList), (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                if (isNewGetConnection) {
                    SQLUtils.cleanup((Connection)conn);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        if (isNewGetConnection) {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private static String buildLogString(String[] sql) {
        StringBuilder log = new StringBuilder();
        log.append("\r\n----NLM Exception Start----");
        log.append("\r\nThread ID:" + Thread.currentThread().toString());
        for (int i = 0; i < sql.length && i <= 20; ++i) {
            if (sql[i].trim().length() <= 0) continue;
            log.append("\r\nSQL" + i + " is:" + sql[i]);
        }
        if (sql.length > 20) {
            log.append("\r\nSQL is too mutch. All sql qty: ").append(sql.length);
        }
        log.append("\r\n----NLM Exception End----");
        return log.toString();
    }

    public Object transform(Context ctx, RecordCollection coll) throws TaskExternalException {
        try {
            this.doBeforeProcessData(ctx);
            this.doProcessBlockData(ctx, coll);
            this.doProcessData(ctx);
            this.doAfterProcessData(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void submitBlock(Context ctx, Object o) throws TaskExternalException {
    }
}

