/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.faleasestrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyFactory;
import com.kingdee.eas.fi.nlm.FaNewLeasePolicyInfo;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.FaAmortizedCostRptStrategy;
import com.kingdee.eas.fi.nlm.app.prc.PrcFaLeaseInNewStrategy;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.poi.ss.formula.functions.FinanceLib;

public abstract class AbstractFaAmortizedCostRptStrategy
implements FaAmortizedCostRptStrategy {
    protected int originScale;
    protected int amountScale;
    protected CompanyOrgUnitInfo curCompany;
    protected final String RES_PATH = "com.kingdee.eas.fi.fa.rpt.FaRptResource";
    protected final String YEAR_DATES = "365";
    protected final long DATE_TIME_MILLIS = 86400000L;
    FaNewLeasePolicyInfo newLeasePolicy;
    List<Date> payDateList;
    List<Double> cfPayArr;
    Date advPayDate;
    double advCf;
    double discountRate;
    boolean isInitBill;

    @Override
    public FaAmortizedCostRptInfo calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        return curACRpt;
    }

    protected abstract void initPayDateAndPayArr(Context var1, FaLeaseInBillNewInfo var2) throws EASBizException, BOSException;

    protected abstract void calcStartEntriesMethod(Context var1, FaLeaseInBillNewInfo var2, FaAmortizedCostRptInfo var3, FaAmortizedCostRptEntryCollection var4) throws EASBizException, BOSException;

    protected abstract double[][] calcAfterStartEntriesUseArray(Context var1, FaLeaseInBillNewInfo var2, FaAmortizedCostRptInfo var3, FaAmortizedCostRptEntryCollection var4) throws EASBizException, BOSException;

    protected FaAmortizedCostRptEntryCollection setEntries(Context ctx, FaLeaseInBillNewInfo billInfo, double[][] entries, List<Date> payDateList, FaLiabilitiesCvMethodEnum cvMethod, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.formatBD4Save(curACRpt.getNPV(), this.originScale);
        Calendar cld = Calendar.getInstance();
        for (int i = 1; i < entries.length; ++i) {
            FaAmortizedCostRptEntryInfo entry = new FaAmortizedCostRptEntryInfo();
            entry.setDate(payDateList.get(i));
            if (cvMethod == FaLiabilitiesCvMethodEnum.PERIOD) {
                cld.setTime(payDateList.get(i));
                entry.setMonth(cld.get(1) * 100 + cld.get(2) + 1);
            }
            entry.setCashflow(this.formatBD4Save(this.db2BD(entries[i][0]), this.originScale));
            entry.setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(entries[i][1]), this.amountScale));
            entry.setInitLiabilityPrincipal(this.formatBD4Save(this.db2BD(entries[i][2]), this.originScale));
            entry.setInitUnCfmFncCost(this.formatBD4Save(this.db2BD(entries[i][3]), this.originScale));
            entry.setInitLiabilityBalance(this.formatBD4Save(this.db2BD(entries[i][4]), this.originScale));
            entry.setCurDepreciation(this.formatBD4Save(this.db2BD(entries[i][5]), this.amountScale));
            entry.setCurAccDepreciation(this.formatBD4Save(this.db2BD(entries[i][6]), this.amountScale));
            entry.setCurInterestPayment(this.formatBD4Save(this.db2BD(entries[i][7]), this.originScale));
            entry.setCurAccInterestPayment(this.formatBD4Save(this.db2BD(entries[i][8]), this.originScale));
            entry.setEndRightOfUseAsset(this.formatBD4Save(this.db2BD(entries[i][9]), this.amountScale));
            entry.setEndLiabilityPrincipal(this.formatBD4Save(this.db2BD(entries[i][10]), this.originScale));
            entry.setEndUnCfmFncCost(this.formatBD4Save(this.db2BD(entries[i][11]), this.originScale));
            entry.setEndLiabilityBalance(this.formatBD4Save(this.db2BD(entries[i][12]), this.originScale));
            curACERptCol.add(entry);
        }
        return null;
    }

    protected void initField(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        this.newLeasePolicy = FaNewLeasePolicyFactory.getLocalInstance(ctx).getEnabledNewLeasePolicy(billInfo.getCompany().getId().toString());
        this.originScale = this.getCurrencyScale(billInfo.getCurrency().getId().toString(), ctx);
        this.amountScale = this.getCurrentCompany(ctx).getBaseCurrency().getPrecision();
        this.curCompany = this.getCurrentCompany(ctx);
        this.payDateList = new ArrayList<Date>();
        this.cfPayArr = new ArrayList<Double>();
        this.advPayDate = null;
        this.advCf = new Double("0");
        this.discountRate = this.calcDiscountRate(billInfo, this.newLeasePolicy);
        this.isInitBill = PrcFaLeaseInNewStrategy.isInitBill(ctx, billInfo, null);
    }

    protected int getFirstImpDateIndex(FaPaymentPlanNewCollection ppCol, FaLeaseInBillNewInfo billInfo) {
        int index = -1;
        for (int i = 0; i < ppCol.size(); ++i) {
            if (ppCol.get(i).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) continue;
            index = i;
            break;
        }
        return index;
    }

    protected double calcDiscountRate(FaLeaseInBillNewInfo billInfo, FaNewLeasePolicyInfo newLeasePolicy) {
        double discountRate;
        int interestCalcMethod = newLeasePolicy.getInterestCalculationMethod().getValue();
        if (newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY) {
            discountRate = interestCalcMethod == 1 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), new Double("1") / new Double("365")) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") / new Double("365");
        } else {
            Double N;
            switch (billInfo.getPayFrequency().getValue()) {
                case 0: {
                    N = new Double("1");
                    break;
                }
                case 1: {
                    N = new Double("1") / new Double("2");
                    break;
                }
                case 2: {
                    N = new Double("1") / new Double("4");
                    break;
                }
                case 3: {
                    N = new Double("1") / new Double("12");
                    break;
                }
                case 5: {
                    N = new Double("1");
                    break;
                }
                default: {
                    N = new Double("1");
                }
            }
            discountRate = interestCalcMethod == 3 ? Math.pow(this.BD2db(billInfo.getDiscountRate()) / new Double("100") + new Double("1"), N) - new Double("1") : this.BD2db(billInfo.getDiscountRate()) / new Double("100") * N;
        }
        return discountRate;
    }

    protected void calcBillNPV(double advCf, List<Double> cfPayArr, double discountRate, FaAmortizedCostRptInfo curACRpt) {
        double npv = this.calcNPV(discountRate, cfPayArr);
        curACRpt.setNPV(new BigDecimal(npv += advCf).setScale(this.amountScale, 4));
    }

    protected double calcAdvPaymentNPV(FaLeaseInBillNewInfo billInfo, double dayRate) {
        if (billInfo.getCostDate1() == null || billInfo.getCostPmWithTax1() == null) {
            return new Double("0");
        }
        if (billInfo.getCostDate1().compareTo(billInfo.getBeginDate()) <= 0) {
            return this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax1() : billInfo.getCostPmWithTax1());
        }
        int advDates = this.subDate(billInfo.getCostDate1(), billInfo.getBeginDate()) + 1;
        double advPaymentNPV = this.BD2db(billInfo.isIsDeductible() ? billInfo.getCostPmWithoutTax1() : billInfo.getCostPmWithTax1()) / Math.pow(new Double("1") + dayRate, advDates);
        return advPaymentNPV;
    }

    protected double calcPWOT(double pwt, double taxRate) {
        return pwt / (new Double("1") + taxRate / new Double("100"));
    }

    protected double calcNPV(double discountRate, List<Double> cfPayArr) {
        double[] cfArr = new double[cfPayArr.size()];
        for (int i = 0; i < cfPayArr.size(); ++i) {
            cfArr[i] = cfPayArr.get(i);
        }
        return FinanceLib.npv((double)discountRate, (double[])cfArr);
    }

    protected CompanyOrgUnitInfo getCurrentCompany(Context ctx) throws BOSException, EASBizException {
        if (this.curCompany == null) {
            String companyID = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
            this.curCompany = this.getCompanyById(companyID, ctx);
        }
        return this.curCompany;
    }

    protected CompanyOrgUnitInfo getCompanyById(String companyID, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("basecurrency.precision"));
        sic.add(new SelectorItemInfo("isbizunit"));
        sic.add(new SelectorItemInfo("accountTable"));
        return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID), sic);
    }

    protected int getCurrencyScale(String Id, Context ctx) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getValue("select precision where id='" + Id + "'").getInt("precision");
    }

    protected double BD2db(BigDecimal bd) {
        return bd == null ? new Double("0").doubleValue() : bd.doubleValue();
    }

    protected BigDecimal db2BD(double d) {
        return new BigDecimal(String.valueOf(d));
    }

    protected BigDecimal formatBD4Save(BigDecimal bd, int saveScale) {
        if (bd != null) {
            bd = bd.setScale(saveScale, 4);
        }
        return bd;
    }

    protected Date nextDate(Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.setTimeInMillis(curCld.getTimeInMillis() + 86400000L);
        return nxtCld.getTime();
    }

    protected int subDate(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        return (int)((cld1.getTimeInMillis() - cld2.getTimeInMillis()) / 86400000L);
    }

    protected boolean compareYearMonth(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        return cld1.get(1) < cld2.get(1) || cld1.get(1) == cld2.get(1) && cld1.get(2) < cld2.get(2);
    }

    protected double calcCostNPV(double cost, double periodDiscountRate, int timeCycle) {
        return cost / Math.pow(new Double("1") + periodDiscountRate, timeCycle);
    }

    protected int subMonth(Date date1, Date date2) {
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        return (cld1.get(1) - cld2.get(1)) * 12 + cld1.get(2) - cld2.get(2);
    }

    protected boolean compareDateIfDay(Date date1, Date date2) {
        long DATE_TIME_MILLIS = 86400000L;
        Calendar cld1 = Calendar.getInstance();
        Calendar cld2 = Calendar.getInstance();
        cld1.setTime(date1);
        cld2.setTime(date2);
        cld1.set(cld1.get(1), cld1.get(2), cld1.get(5), 0, 0, 0);
        cld2.set(cld2.get(1), cld2.get(2), cld2.get(5), 0, 0, 0);
        int subDay = (int)((cld2.getTimeInMillis() - cld1.getTimeInMillis()) / 86400000L);
        return subDay == 0;
    }

    protected Date getNewEndDate(Date date, int month) {
        Calendar cld = Calendar.getInstance();
        cld.setTime(date);
        cld.add(5, -1);
        cld.add(2, month);
        return cld.getTime();
    }

    protected static Date getMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    protected static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    protected static Date nextMonth(Date curDate) {
        Calendar curCld = Calendar.getInstance();
        Calendar nxtCld = Calendar.getInstance();
        curCld.setTime(curDate);
        nxtCld.set(curCld.get(1), curCld.get(2) + 1, 1, 0, 0, 0);
        return nxtCld.getTime();
    }

    protected int getLeaseCycle(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            return 0;
        }
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(beginDate);
        c2.setTime(endDate);
        int monthCount = c2.get(2) - c1.get(2);
        int yearCount = (c2.get(1) - c1.get(1)) * 12;
        int dayCount = c2.get(5) - c1.get(5);
        int leaseCycle = monthCount + yearCount;
        if (dayCount >= 0) {
            ++leaseCycle;
        }
        return leaseCycle;
    }

    protected int getDepDayCount(Date beginDate, Date depEndDate) {
        return this.subDate(depEndDate, beginDate) + 1;
    }
}

