/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.faleasestrategy.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.nlm.DepreciationMethodEnum;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryCollection;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptEntryInfo;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptFactory;
import com.kingdee.eas.fi.nlm.FaAmortizedCostRptInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaLiabilitiesCvMethodEnum;
import com.kingdee.eas.fi.nlm.FaPaymentPlanNewCollection;
import com.kingdee.eas.fi.nlm.app.faleasestrategy.impl.AbstractFaAmortizedCostRptStrategy;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Locale;

public class TerminateAmortizedCostRptStrategy
extends AbstractFaAmortizedCostRptStrategy {
    public static final String FALEASENEWRESOURCE = "com.kingdee.eas.fi.nlm.FaLeaseNewResource";
    private java.util.Date endPayDate;

    @Override
    public FaAmortizedCostRptInfo calcACRData(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        this.initField(ctx, billInfo);
        this.initPayDateAndPayArr(ctx, billInfo);
        this.calcBillNPV(this.advCf, this.cfPayArr, this.discountRate, curACRpt);
        this.calcStartEntriesMethod(ctx, billInfo, curACRpt, curACERptCol);
        double[][] entries = this.calcAfterStartEntriesUseArray(ctx, billInfo, curACRpt, curACERptCol);
        this.setEntries(ctx, billInfo, entries, this.payDateList, this.newLeasePolicy.getTranslationMethod(), curACRpt, curACERptCol);
        curACRpt.put("entry", (Object)curACERptCol);
        return curACRpt;
    }

    @Override
    protected void initPayDateAndPayArr(Context ctx, FaLeaseInBillNewInfo billInfo) throws EASBizException, BOSException {
        int i;
        java.util.Date curDate;
        FaPaymentPlanNewCollection ppCol = billInfo.getPaymentEntry();
        if (ppCol.size() < 0) {
            String paymentEntryIsNull = FaLocalUtils.getResource((Context)ctx, (String)"com.kingdee.eas.fi.fa.rpt.FaRptResource", (String)"paymentEntryIsNull");
            throw new EASBizException(new NumericExceptionSubItem("1", paymentEntryIsNull));
        }
        ppCol.sort("payDate");
        ppCol.removeObject(0);
        java.util.Date beginDate = billInfo.getBeginDate();
        java.util.Date endDate = billInfo.getEndDate();
        java.util.Date firstPayDate = billInfo.getFirstPayTime();
        this.endPayDate = ppCol.get(ppCol.size() - 1).getPayDate();
        java.util.Date endAmortizedCostDate = endDate.compareTo(this.endPayDate) > 0 ? endDate : this.endPayDate;
        int ppIdx = 0;
        if (this.isInitBill) {
            if (beginDate.compareTo(billInfo.getDpInitCfmDate()) < 0) {
                curDate = billInfo.getDpInitCfmDate();
                if (ppCol.get(0).getPayDate().compareTo(billInfo.getDpInitCfmDate()) < 0) {
                    ppIdx = this.getFirstImpDateIndex(ppCol, billInfo);
                }
            } else {
                curDate = beginDate;
            }
        } else {
            curDate = beginDate;
            if (firstPayDate.compareTo(beginDate) < 0) {
                Calendar cld = Calendar.getInstance();
                cld.setTimeInMillis(beginDate.getTime() - 86400000L);
                this.advPayDate = cld.getTime();
                for (i = 0; i < ppCol.size() && ppCol.get(i).getPayDate().compareTo(beginDate) < 0; ++i) {
                    this.advCf += billInfo.isIsDeductible() ? this.calcPWOT(this.BD2db(ppCol.get(0).getPaymentWithTax()), this.BD2db(ppCol.get(0).getTaxRate())) : this.BD2db(ppCol.get(0).getPaymentWithTax());
                    ++ppIdx;
                }
            }
        }
        int subDates = this.subDate(endAmortizedCostDate, curDate);
        for (i = 0; i < subDates + 1; ++i) {
            this.payDateList.add(curDate);
            if (ppIdx >= 0 && ppIdx < ppCol.size() && curDate.compareTo(ppCol.get(ppIdx).getPayDate()) == 0) {
                this.cfPayArr.add(billInfo.isIsDeductible() ? this.BD2db(ppCol.get(ppIdx).getPaymentWithoutTax()) : this.BD2db(ppCol.get(ppIdx).getPaymentWithTax()));
                ++ppIdx;
            } else {
                this.cfPayArr.add(new Double("0"));
            }
            curDate = this.nextDate(curDate);
        }
    }

    @Override
    protected void calcStartEntriesMethod(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws EASBizException, BOSException {
        BigDecimal cDpr;
        FaLeaseInBillNewInfo originBillInfo;
        BigDecimal ratio;
        Date terminateDate;
        if (this.payDateList == null || this.payDateList.size() <= 0) {
            return;
        }
        java.util.Date beginDate = billInfo.getBeginDate();
        java.util.Date endDate = this.getNewEndDate(beginDate, billInfo.getTimeCycle());
        if (this.advPayDate != null) {
            FaAmortizedCostRptEntryInfo advEntry = new FaAmortizedCostRptEntryInfo();
            advEntry.setDate(this.advPayDate);
            advEntry.setCashflow(new BigDecimal(String.valueOf(this.advCf)));
            advEntry.setInitRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setInitLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setInitUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setInitLiabilityBalance(BigDecimal.ZERO);
            advEntry.setCurDepreciation(BigDecimal.ZERO);
            advEntry.setCurAccDepreciation(BigDecimal.ZERO);
            advEntry.setCurInterestPayment(BigDecimal.ZERO);
            advEntry.setCurAccInterestPayment(BigDecimal.ZERO);
            advEntry.setEndRightOfUseAsset(BigDecimal.ZERO);
            advEntry.setEndLiabilityPrincipal(BigDecimal.ZERO);
            advEntry.setEndUnCfmFncCost(BigDecimal.ZERO);
            advEntry.setEndLiabilityBalance(BigDecimal.ZERO);
            curACERptCol.add(advEntry);
        }
        FaAmortizedCostRptEntryInfo firstBizEntry = new FaAmortizedCostRptEntryInfo();
        firstBizEntry.setDate((java.util.Date)this.payDateList.get(0));
        firstBizEntry.setCashflow(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(0)), this.originScale));
        firstBizEntry.setInitialAssetDecValue(billInfo.getInitialAssetDecValue());
        BigDecimal totalCf = new BigDecimal("0");
        for (Double cf : this.cfPayArr) {
            totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(cf), this.originScale));
        }
        totalCf = totalCf.add(this.formatBD4Save(new BigDecimal(this.advCf), this.originScale));
        if (billInfo.isIsDeductible()) {
            billInfo.setRentWithoutTax(totalCf);
        } else {
            billInfo.setRentWithTax(totalCf);
        }
        double rcvNPV = new Double("0");
        Double exchangeRateInfo = new Double(billInfo.getExchangeRateValue().toString());
        if (billInfo.getExchangeRate() != null && billInfo.getExchangeRate().getExchangeAux().getConvertMode() == ConvertModeEnum.INDIRECTEXCHANGERATE) {
            exchangeRateInfo = 1.0 / exchangeRateInfo;
        }
        if (billInfo.getCostPmWithTaxOC6() != null) {
            int subDates = this.subDate(billInfo.getCostDate6(), billInfo.getBeginDate()) + 1;
            rcvNPV = exchangeRateInfo * this.BD2db(billInfo.getCostPmWithTaxOC6());
            rcvNPV = this.calcCostNPV(rcvNPV, this.discountRate, subDates);
        }
        String updateSQL = " UPDATE T_FA_FaLeaseInBillNew SET FRECOVERYCOSTNPV = ? WHERE FID = ?";
        Object[] params = new Object[]{rcvNPV, billInfo.getId().toString()};
        DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])params);
        StringBuilder tmSql = new StringBuilder();
        tmSql.append("SELECT bill.FTerminateDate terminateDate, entry.FRatio ratio, entry.FLeaseInBillID billId \n");
        tmSql.append("FROM T_FA_FaTerminateBill bill \n");
        tmSql.append("LEFT JOIN T_FA_FaTerminateBillEntry entry ON bill.FID = entry.FBillID \n");
        tmSql.append("WHERE entry.FCreatedLeaseInBillID = ? \n");
        IRowSet tmRs = DbUtil.executeQuery((Context)ctx, (String)tmSql.toString(), (Object[])new String[]{billInfo.getId().toString()});
        try {
            if (!tmRs.next()) {
                throw new EASBizException(new NumericExceptionSubItem("001", ResourceBase.getString((String)FALEASENEWRESOURCE, (String)"Association_TerminateBill_Not_Exist", (Locale)ctx.getOriginLocale())));
            }
            terminateDate = tmRs.getDate("terminateDate");
            ratio = tmRs.getBigDecimal("ratio");
            originBillInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(tmRs.getString("billId")));
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        FaAmortizedCostRptInfo originACRptInfo = FaAmortizedCostRptFactory.getLocalInstance(ctx).getFaAmortizedCostRptInfo("where leaseInBill.id = '" + originBillInfo.getId().toString() + "' order by entry.date, id");
        FaAmortizedCostRptEntryCollection costRptEntryCollection = originACRptInfo.getEntry();
        BigDecimal tmpOneOld = new BigDecimal("0");
        BigDecimal tmpInitAsset = new BigDecimal("0");
        java.util.Date terminateDateTmp = terminateDate;
        if (billInfo.getDepreciationMethod() == DepreciationMethodEnum.Second) {
            terminateDateTmp = TerminateAmortizedCostRptStrategy.getMinMonthDate(terminateDateTmp);
        }
        int m = costRptEntryCollection.size();
        for (int n = 0; n < m; ++n) {
            if (!this.compareDateIfDay(costRptEntryCollection.get(n).getDate(), terminateDateTmp)) continue;
            tmpOneOld = costRptEntryCollection.get(n).getInitLiabilityBalance();
            tmpOneOld = tmpOneOld.multiply(BigDecimal.valueOf(exchangeRateInfo));
            tmpInitAsset = costRptEntryCollection.get(n).getInitRightOfUseAsset();
            break;
        }
        ratio = new BigDecimal("100").subtract(ratio).divide(new BigDecimal("100"), 16, 4);
        BigDecimal one = billInfo.getInitialAsset().subtract(tmpOneOld.multiply(ratio)).setScale(this.amountScale, 4);
        double iROUA = this.BD2db(tmpInitAsset.multiply(ratio).add(one));
        double initialAssetDecValue = this.BD2db(billInfo.getInitialAssetDecValue());
        iROUA -= initialAssetDecValue;
        if (this.isInitBill) {
            int remainDprTimes = this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First ? this.subDate(endDate, billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) <= 0 ? billInfo.getDpInitCfmDate() : billInfo.getBeginDate()) + 1 : (billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? billInfo.getTimeCycle() - this.subMonth(billInfo.getDpInitCfmDate(), billInfo.getBeginDate()) : billInfo.getTimeCycle());
            cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(remainDprTimes))), this.amountScale);
            firstBizEntry.put("remainTimeCycle", new Double(String.valueOf(remainDprTimes)));
        } else if (this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First) {
            double dprDateAmt = this.getDepDayCount(beginDate, billInfo.getDepEndDate());
            cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(dprDateAmt), this.amountScale);
        } else {
            cDpr = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).divide(this.db2BD(new Double(String.valueOf(billInfo.getTimeCycle()))), this.amountScale);
        }
        BigDecimal iLP = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(this.db2BD(this.advCf), this.originScale));
        BigDecimal iUCFC = this.formatBD4Save(billInfo.isIsDeductible() ? billInfo.getRentWithoutTax() : billInfo.getRentWithTax(), this.originScale).subtract(this.formatBD4Save(curACRpt.getNPV(), this.originScale));
        BigDecimal iLB = iLP.subtract(iUCFC);
        firstBizEntry.setInitRightOfUseAsset(this.formatBD4Save(this.db2BD(iROUA), this.amountScale));
        firstBizEntry.setInitLiabilityPrincipal(iLP);
        firstBizEntry.setInitUnCfmFncCost(iUCFC);
        firstBizEntry.setInitLiabilityBalance(iLB);
        BigDecimal cIP = this.formatBD4Save(iLB.multiply(this.db2BD(this.discountRate)), this.originScale);
        firstBizEntry.setCurDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurAccDepreciation(this.formatBD4Save(cDpr, this.amountScale));
        firstBizEntry.setCurInterestPayment(cIP);
        firstBizEntry.setCurAccInterestPayment(cIP);
        BigDecimal eROUA = this.formatBD4Save(this.db2BD(iROUA), this.amountScale).subtract(this.formatBD4Save(cDpr, this.amountScale));
        BigDecimal eLP = iLP.subtract(firstBizEntry.getCashflow());
        BigDecimal eUCFC = iUCFC.subtract(cIP);
        BigDecimal eLB = eLP.subtract(eUCFC);
        firstBizEntry.setEndRightOfUseAsset(eROUA);
        firstBizEntry.setEndLiabilityPrincipal(eLP);
        firstBizEntry.setEndUnCfmFncCost(eUCFC);
        firstBizEntry.setEndLiabilityBalance(eLB);
        curACERptCol.add(firstBizEntry);
    }

    @Override
    protected double[][] calcAfterStartEntriesUseArray(Context ctx, FaLeaseInBillNewInfo billInfo, FaAmortizedCostRptInfo curACRpt, FaAmortizedCostRptEntryCollection curACERptCol) throws BOSException, EASBizException {
        boolean isDepLessThanOrEqualToLease;
        double[][] entries = new double[this.payDateList.size()][13];
        if (this.payDateList.size() <= 1) {
            return entries;
        }
        FaAmortizedCostRptEntryInfo firstEntry = curACERptCol.get(curACERptCol.size() - 1);
        boolean isDayCvMethod = this.newLeasePolicy.getTranslationMethod() == FaLiabilitiesCvMethodEnum.DAY;
        int depTimeCycle = billInfo.getTimeCycle();
        int leaseTimeCycle = this.getLeaseCycle(billInfo.getBeginDate(), billInfo.getEndDate());
        boolean bl = isDepLessThanOrEqualToLease = depTimeCycle <= leaseTimeCycle;
        int endDateIndex = isDayCvMethod && this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.First ? (this.isInitBill && billInfo.getBeginDate().compareTo(billInfo.getDpInitCfmDate()) < 0 ? this.getDepDayCount(billInfo.getDpInitCfmDate(), billInfo.getDepEndDate()) - 1 : this.getDepDayCount(billInfo.getBeginDate(), billInfo.getDepEndDate()) - 1) : (firstEntry.get("remainTimeCycle") == null ? (depTimeCycle < leaseTimeCycle ? billInfo.getTimeCycle() - 1 : leaseTimeCycle - 1) : firstEntry.getInt("remainTimeCycle") - 1);
        int monthCount = 0;
        java.util.Date lastDate = null;
        entries[0][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(1)), this.originScale));
        entries[0][1] = this.BD2db(firstEntry.getInitRightOfUseAsset());
        entries[0][2] = this.BD2db(firstEntry.getInitLiabilityPrincipal());
        entries[0][3] = this.BD2db(firstEntry.getInitUnCfmFncCost());
        entries[0][4] = this.BD2db(firstEntry.getInitLiabilityBalance());
        entries[0][5] = this.BD2db(firstEntry.getCurDepreciation());
        entries[0][6] = this.BD2db(firstEntry.getCurAccDepreciation());
        entries[0][7] = this.BD2db(firstEntry.getCurInterestPayment());
        entries[0][8] = this.BD2db(firstEntry.getCurAccInterestPayment());
        entries[0][9] = this.BD2db(firstEntry.getEndRightOfUseAsset());
        entries[0][10] = this.BD2db(firstEntry.getEndLiabilityPrincipal());
        entries[0][11] = this.BD2db(firstEntry.getEndUnCfmFncCost());
        entries[0][12] = this.BD2db(firstEntry.getEndLiabilityBalance());
        for (int i = 1; i < this.payDateList.size(); ++i) {
            entries[i][0] = this.BD2db(this.formatBD4Save(this.db2BD((Double)this.cfPayArr.get(i)), this.originScale));
            entries[i][1] = entries[i - 1][9];
            entries[i][2] = entries[i - 1][10];
            entries[i][3] = entries[i - 1][11];
            entries[i][4] = entries[i - 1][12];
            double cIP = i == this.payDateList.size() - 1 ? this.BD2db(firstEntry.getInitUnCfmFncCost()) - entries[i - 1][8] : (isDayCvMethod ? this.BD2db(this.formatBD4Save(this.db2BD(entries[i][4] * this.discountRate), this.originScale)) : entries[i][4] * firstEntry.getDouble("interestRate"));
            double cAIP = new Double("0");
            for (double[] entry : entries) {
                cAIP += entry[7];
            }
            cAIP += cIP;
            if (isDayCvMethod && this.newLeasePolicy.getDepreciationMethod() == DepreciationMethodEnum.Second) {
                if (lastDate == null) {
                    lastDate = (java.util.Date)this.payDateList.get(0);
                }
                if (this.compareYearMonth(lastDate, (java.util.Date)this.payDateList.get(i))) {
                    lastDate = (java.util.Date)this.payDateList.get(i);
                    if (++monthCount <= endDateIndex) {
                        entries[i][5] = this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(monthCount + 1));
                        if (monthCount == endDateIndex && isDepLessThanOrEqualToLease) {
                            entries[i][5] = entries[i][1];
                            entries[i][6] = entries[0][1];
                        }
                    } else if (!isDepLessThanOrEqualToLease) {
                        entries[i][5] = this.BD2db(firstEntry.getCurDepreciation());
                        entries[i][6] = entries[i][5] * new Double(String.valueOf(monthCount + 1));
                    } else {
                        entries[i][5] = new Double("0");
                        entries[i][6] = entries[i - 1][6];
                    }
                } else {
                    entries[i][5] = new Double("0");
                    entries[i][6] = entries[i - 1][6];
                }
            } else if (i <= endDateIndex) {
                entries[i][5] = entries[i - 1][5];
                entries[i][6] = entries[i - 1][5] * new Double(String.valueOf(i + 1));
                if (i == endDateIndex && isDepLessThanOrEqualToLease) {
                    entries[i][5] = entries[i][1];
                    entries[i][6] = entries[0][1];
                }
            } else {
                entries[i][5] = new Double("0");
                entries[i][6] = entries[0][1];
            }
            entries[i][7] = cIP;
            entries[i][8] = cAIP;
            if (((java.util.Date)this.payDateList.get(i)).getTime() == this.endPayDate.getTime()) {
                entries[i][7] = entries[0][3] - entries[i - 1][8];
                entries[i][8] = entries[0][3];
            } else if (((java.util.Date)this.payDateList.get(i)).getTime() > this.endPayDate.getTime()) {
                entries[i][7] = new Double("0");
                entries[i][8] = entries[0][3];
            }
            entries[i][9] = entries[i][1] - entries[i][5];
            entries[i][10] = entries[i][2] - entries[i][0];
            entries[i][11] = entries[i][3] - entries[i][7];
            entries[i][12] = entries[i][10] - entries[i][11];
        }
        return entries;
    }
}

