/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.fleventlistener.listener.strategy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.AccessTypeEnum;
import com.kingdee.eas.fi.nlm.FaContractCatFactory;
import com.kingdee.eas.fi.nlm.FaContractCatInfo;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.LendingDirectionEnum;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailCollection;
import com.kingdee.eas.fi.nlm.NLMAccountBalanceDetailInfo;
import com.kingdee.eas.fi.nlm.NLMBillContractCatFieldNameEnum;
import com.kingdee.eas.fi.nlm.NLMBillFieldNameEnum;
import com.kingdee.eas.fi.nlm.NLMBillSourceTypeEnum;
import com.kingdee.eas.fi.nlm.NLMBillTypeEnum;
import com.kingdee.eas.fi.nlm.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.framework.SystemEnum;

public enum UpdateBalanceTableForDepreAndAmortEnum {
    DEPRE_AND_AMORT(null, new NLMBillFieldNameEnum[]{NLMBillFieldNameEnum.DEP_BILL_MONTH_DEP_AMT}, new NLMBillContractCatFieldNameEnum[]{NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP});

    private final NLMBillSourceTypeEnum nlmBillSourceTypeEnum;
    private final NLMBillFieldNameEnum[] nlmBillFieldNameEnums;
    private final NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums;

    private UpdateBalanceTableForDepreAndAmortEnum(NLMBillSourceTypeEnum nlmBillSourceTypeEnum, NLMBillFieldNameEnum[] nlmBillFieldNameEnums, NLMBillContractCatFieldNameEnum[] nlmBillContractCatFieldNameEnums) {
        this.nlmBillSourceTypeEnum = nlmBillSourceTypeEnum;
        this.nlmBillFieldNameEnums = nlmBillFieldNameEnums;
        this.nlmBillContractCatFieldNameEnums = nlmBillContractCatFieldNameEnums;
    }

    public NLMAccountBalanceDetailCollection getNLMAccountBalanceDetailCollection(RPCMethodEvent<FaDepreAndAmortCollection> rpcMethodEvent) throws EASBizException, BOSException {
        return this.getDetailInfo(rpcMethodEvent.getContext(), rpcMethodEvent.getDetailMessage(), SystemStatusCtrolUtils.getCurrentPeriod((Context)rpcMethodEvent.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)rpcMethodEvent.getDetailMessage().get(0).getCompany()));
    }

    public NLMAccountBalanceDetailCollection getDetailInfo(Context ctx, FaDepreAndAmortCollection billInfo, PeriodInfo curPeriod) throws EASBizException, BOSException {
        NLMAccountBalanceDetailCollection nlmAccountBalanceDetailCollection = new NLMAccountBalanceDetailCollection();
        int j = billInfo.size();
        for (int i = 0; i < j; ++i) {
            NLMAccountBalanceDetailInfo detailInfo = new NLMAccountBalanceDetailInfo();
            FaDepreAndAmortInfo faDepreAndAmortInfo = billInfo.get(i);
            FaLeaseInBillNewInfo faLeaseInBillNewInfo = faDepreAndAmortInfo.getLeaseInBill();
            faLeaseInBillNewInfo = FaLeaseInBillNewFactory.getLocalInstance(ctx).getFaLeaseInBillNewInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getId().toString()));
            detailInfo.setId(BOSUuid.create((BOSObjectType)detailInfo.getBOSType()));
            detailInfo.setCompany(faDepreAndAmortInfo.getCompany());
            detailInfo.setCurrency(faLeaseInBillNewInfo.getCurrency());
            detailInfo.setPeriod(curPeriod);
            detailInfo.setNlmLeaseBillID(faLeaseInBillNewInfo.getId().toString());
            detailInfo.setNlmBillNumber(faLeaseInBillNewInfo.getNumber());
            detailInfo.setNlmBillContractCat(faLeaseInBillNewInfo.getContractCat());
            detailInfo.setNlmBillID(faDepreAndAmortInfo.getId().toString());
            detailInfo.setNlmBillType(NLMBillTypeEnum.DEP_BILL);
            detailInfo.setNlmBillSourceType(this.nlmBillSourceTypeEnum);
            detailInfo.setContractCatFieldName(this.nlmBillContractCatFieldNameEnums[0]);
            FaContractCatInfo faContractCatInfo = FaContractCatFactory.getLocalInstance(ctx).getFaContractCatInfo((IObjectPK)new ObjectUuidPK(faLeaseInBillNewInfo.getContractCat().getId().toString()));
            detailInfo.setContractCatFieldValue((AccountViewInfo)faContractCatInfo.get(this.getContractCatFieldName(this.nlmBillContractCatFieldNameEnums[0])));
            detailInfo.setNlmBillGetFieldName(this.nlmBillFieldNameEnums[0]);
            detailInfo.setNlmBillGetFieldValue(faDepreAndAmortInfo.getMonthlyDepreAmt());
            detailInfo.setLendingDirection(LendingDirectionEnum.LOAN);
            detailInfo.setAccessType(AccessTypeEnum.AMOUNT_INCURRED);
            nlmAccountBalanceDetailCollection.add(detailInfo);
        }
        return nlmAccountBalanceDetailCollection;
    }

    protected String getContractCatFieldName(NLMBillContractCatFieldNameEnum nlmBillContractCatFieldNameEnum) {
        String result = "";
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACT) {
            result = "usufructAssetAcct";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_ACC_DEP) {
            result = "usufructAssetAcctACM";
        }
        if (nlmBillContractCatFieldNameEnum == NLMBillContractCatFieldNameEnum.USUFRUCT_ASSET_DEC_VALUE) {
            result = "usufructAssetAcctDEC";
        }
        return result;
    }
}

