/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.nlm.app.fleventlistener.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortCollection;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortFactory;
import com.kingdee.eas.fi.nlm.FaDepreAndAmortInfo;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewFactory;
import com.kingdee.eas.fi.nlm.FaLeaseInBillNewInfo;
import com.kingdee.eas.fi.nlm.FaTerminateBillFactory;
import com.kingdee.eas.fi.nlm.FaTerminateBillInfo;
import com.kingdee.eas.fi.nlm.FaleaseDecValueFactory;
import com.kingdee.eas.fi.nlm.FaleaseDecValueInfo;
import com.kingdee.eas.fi.nlm.RPCMethodMappingCollection;
import com.kingdee.eas.fi.nlm.RPCMethodMappingFactory;
import com.kingdee.eas.fi.nlm.RPCMethodMappingInfo;
import com.kingdee.eas.fi.nlm.app.fleventlistener.RPCMethodEventFactory;
import com.kingdee.eas.fi.nlm.app.fleventlistener.RPCMethodEventPublish;
import com.kingdee.eas.fi.nlm.app.fleventlistener.event.RPCMethodEvent;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RPCMethodMappingUtils {
    private RPCMethodMappingUtils() {
    }

    public static <T> void invokeRPCMethodEventListener(ServiceContext svcCtx, T eventParams) throws BOSException {
        try {
            ArrayList<String> listenerType = new ArrayList<String>();
            if (RPCMethodMappingUtils.getRPCMethodListenerStatus(svcCtx, svcCtx.getOperationPK().toString(), listenerType)) {
                T params = RPCMethodMappingUtils.getEventParams(svcCtx, eventParams);
                List<RPCMethodEvent<T>> rpcMethodEvents = RPCMethodEventFactory.getRPCMethodEvents(svcCtx.getContext(), listenerType, params);
                RPCMethodEventPublish.rpcMethodEventPublish(rpcMethodEvents);
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean getRPCMethodListenerStatus(ServiceContext svcCtx, String innerID, List<String> listenerType) throws BOSException {
        RPCMethodMappingCollection rpcMethodMappingCollection = RPCMethodMappingFactory.getLocalInstance(svcCtx.getContext()).getRPCMethodMappingCollection("where innerID = '" + innerID + "'");
        if (rpcMethodMappingCollection.size() == 0) {
            return false;
        }
        RPCMethodMappingInfo rpcMethodMappingInfo = rpcMethodMappingCollection.get(0);
        if (rpcMethodMappingInfo.getListenerType() == null) {
            return false;
        }
        String[] types = rpcMethodMappingInfo.getListenerType().split(",");
        Collections.addAll(listenerType, types);
        return rpcMethodMappingInfo.isListenerStatus();
    }

    public static <T> T getEventParams(ServiceContext svcCtx, T eventParams) throws BOSException, EASBizException, SQLException {
        Object[] params = svcCtx.getOperationParameters();
        IObjectPK iObjectPK = null;
        for (Object param : params) {
            if (!(param instanceof IObjectPK)) continue;
            iObjectPK = (IObjectPK)param;
            break;
        }
        if (iObjectPK != null) {
            if (eventParams instanceof FaLeaseInBillNewInfo) {
                eventParams = FaLeaseInBillNewFactory.getLocalInstance(svcCtx.getContext()).getFaLeaseInBillNewInfo(iObjectPK);
            }
            if (eventParams instanceof FaTerminateBillInfo) {
                eventParams = FaTerminateBillFactory.getLocalInstance(svcCtx.getContext()).getFaTerminateBillInfo(iObjectPK);
            }
            if (eventParams instanceof FaleaseDecValueInfo) {
                eventParams = FaleaseDecValueFactory.getLocalInstance(svcCtx.getContext()).getFaleaseDecValueInfo(iObjectPK);
            }
        } else if (eventParams instanceof FaDepreAndAmortCollection) {
            CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)svcCtx.getContext());
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)svcCtx.getContext(), (SystemEnum)SystemEnum.FINANCE_LEASE, (CompanyOrgUnitInfo)company);
            IRowSet rs = DbUtil.executeQuery((Context)svcCtx.getContext(), (String)("select FID from T_FA_FaDepreAndAmort where FPeriodId = '" + periodInfo.getId().toString() + "' and FCompanyId = '" + company.getId().toString() + "'"));
            SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
            selectorItemCollection.add("*");
            selectorItemCollection.add("period.*");
            selectorItemCollection.add("leaseInBill.id");
            selectorItemCollection.add("leaseInBill.number");
            selectorItemCollection.add("leaseInBill.period.*");
            while (rs.next()) {
                FaDepreAndAmortInfo faDepreAndAmortInfo = FaDepreAndAmortFactory.getLocalInstance(svcCtx.getContext()).getFaDepreAndAmortInfo((IObjectPK)new ObjectUuidPK(rs.getString("FID")), selectorItemCollection);
                if (faDepreAndAmortInfo.getLeaseInBill().getPeriod().getNumber() > faDepreAndAmortInfo.getPeriod().getNumber()) continue;
                ((FaDepreAndAmortCollection)((Object)eventParams)).add(faDepreAndAmortInfo);
            }
        }
        return eventParams;
    }

    public static void updateRPCMethodMappingValues(Context ctx) throws ClassNotFoundException, BOSException, EASBizException {
        String[] shouldUpdateClass;
        for (String updateClass : shouldUpdateClass = new String[]{"com.kingdee.eas.fi.fa.manage.app.FaLeaseInBillNewController", "com.kingdee.eas.fi.fa.manage.app.FaTerminateBillController", "com.kingdee.eas.fi.fa.manage.app.FaleaseDecValueController", "com.kingdee.eas.fi.fa.manage.app.FaDepreAndAmortController"}) {
            Method[] rpcClassMethods;
            Class<?> rpcClass = Class.forName(updateClass);
            for (Method rpcClassMethod : rpcClassMethods = rpcClass.getMethods()) {
                RPCMethodMappingInfo rpcMethodMappingInfo = new RPCMethodMappingInfo();
                rpcMethodMappingInfo.setId(BOSUuid.create((BOSObjectType)rpcMethodMappingInfo.getBOSType()));
                rpcMethodMappingInfo.setRpcClass(rpcClassMethod.getDeclaringClass().getName());
                Class<?> methodClass = Class.forName(rpcClassMethod.getDeclaringClass().getName());
                if (methodClass.getInterfaces().length != 0) {
                    rpcMethodMappingInfo.setRpcClassParent(methodClass.getInterfaces()[0].getName());
                }
                rpcMethodMappingInfo.setInnerID("");
                rpcMethodMappingInfo.setRpcMethodName(rpcClassMethod.getName());
                StringBuilder stringBuilder = new StringBuilder();
                int m = rpcClassMethod.getParameterTypes().length;
                for (int n = 0; n < m; ++n) {
                    stringBuilder.append(rpcClassMethod.getParameterTypes()[n].getName()).append(",");
                }
                String rpcFiledName = stringBuilder.substring(0, stringBuilder.length() - 1);
                rpcMethodMappingInfo.setRpcFiledName(rpcFiledName);
                rpcMethodMappingInfo.setListenerStatus(false);
                rpcMethodMappingInfo.setListenerType("");
                if (RPCMethodMappingFactory.getLocalInstance(ctx).exists("where rpcClass = '" + rpcMethodMappingInfo.getRpcClass() + "' and rpcMethodName = '" + rpcMethodMappingInfo.getRpcMethodName() + "' and rpcFiledName = '" + rpcMethodMappingInfo.getRpcFiledName() + "'")) continue;
                RPCMethodMappingFactory.getLocalInstance(ctx).addnew(rpcMethodMappingInfo);
            }
        }
    }
}

