/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.pcc.SchedulePlanDateEnum;
import com.kingdee.eas.fi.pcc.StageStatusEnum;
import com.kingdee.eas.fi.pcc.TaskStatusEnum;
import com.kingdee.eas.fi.pcc.app.AbstractFIClosingCenterFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FIClosingCenterFacadeControllerBean
extends AbstractFIClosingCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.pcc.app.FIClosingCenterFacadeControllerBean");
    private static final String RESOURCE_FI_CC = "com.kingdee.eas.fi.pcc.FIClosingCenterResource";

    @Override
    protected void _taskExecutionRecord(Context ctx, String orgId, String taskId, String periodId, boolean isReverse) throws BOSException {
        int periodNumber = this.getPeriodNumber(ctx, periodId);
        if (periodNumber == 0) {
            return;
        }
        if (!this.hasPreExecRecord(ctx, orgId, periodNumber)) {
            this.insertPreExeRecord(ctx, orgId, periodNumber);
        }
        if (!this.isTaskExecuted(ctx, orgId, taskId, periodNumber)) {
            this.insertTaskRecord(ctx, orgId, taskId, periodNumber, isReverse);
        } else if (this.isTaskExecExists(ctx, orgId, taskId, periodNumber)) {
            this.updateTaskRecord(ctx, orgId, taskId, periodNumber, isReverse);
        } else {
            this.insertTaskRecord(ctx, orgId, taskId, periodNumber, isReverse);
        }
    }

    private int getPeriodNumber(Context ctx, String periodId) throws BOSException {
        String sql = "select FNumber from t_bd_period where fid='" + periodId + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        int periodNumber = 0;
        try {
            if (rs.next()) {
                periodNumber = rs.getInt("FNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return periodNumber;
    }

    private boolean hasPreExecRecord(Context ctx, String orgId, int periodNumber) throws BOSException {
        boolean hasPreExecRecord = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fid from T_PCC_TaskExecution where FCompanyId=? and Fperiod=? \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, periodNumber});
        try {
            if (rs.next()) {
                hasPreExecRecord = true;
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        return hasPreExecRecord;
    }

    private boolean isTaskExecuted(Context ctx, String orgId, String taskId, int periodNumber) throws BOSException {
        boolean isTaskExecuted = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 fid from T_PCC_TaskExecution \n");
        sql.append("where FCompanyId=? and FTaskId=? and FPeriod=? and FCreatorId is not null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, taskId, periodNumber});
        try {
            if (rs.next()) {
                isTaskExecuted = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isTaskExecuted;
    }

    private boolean isTaskExecExists(Context ctx, String orgId, String taskId, int periodNumber) throws BOSException {
        boolean isTaskExecExists = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_PCC_TaskExecution where FCompanyId=? and FTaskId=? and FPeriod=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, taskId, periodNumber});
        try {
            if (rs.next()) {
                isTaskExecExists = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return isTaskExecExists;
    }

    private void updateTaskRecord(Context ctx, String orgId, String taskId, int periodNumber, boolean isReverse) throws BOSException {
        String userId = ctx.getCaller().toString();
        Timestamp time = new Timestamp(new Date().getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("update T_PCC_TaskExecution set FCreatorId=?, FCreateTime=?, FLastUpdateTime=? \n");
        sql.append("where FCompanyId=? and FTaskId=? and Fperiod=? and FCreatorId is not null");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{userId, time, time, orgId, taskId, periodNumber});
        sql.setLength(0);
        sql.append("select Fid from T_PCC_TaskExecution where FCompanyId=? and FTaskId=? and Fperiod=? and FCreatorId is not null");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgId, taskId, periodNumber});
        try {
            if (rs.next()) {
                this.updateAfterExecRecord(ctx, orgId, taskId, periodNumber, isReverse, rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void insertPreExeRecord(Context ctx, String orgId, int periodNumber) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_PCC_TaskExecution(FID, FCompanyId,  FTaskId, \n");
        sql.append(" FPeriod, FDescription_l1, FDescription_l2, FDescription_l3, \n");
        sql.append(" FStatus, FStageStatus, FScheduleStatus) \n");
        sql.append("select newbosid('698AD5A2') FID, '").append(orgId).append("' FCompanyId, \n");
        sql.append("  t.FTaskId FTaskId, ").append(periodNumber).append(" FPeriod, \n");
        sql.append(this.getDesc(ctx, false)).append(", 3, '2', '2' \n");
        sql.append("from T_PCC_TaskSchedule t \n");
        sql.append("  inner join t_pcc_task t1 on t1.Fid=t.FTaskId \n");
        if (this.isOrgSetting(ctx, orgId)) {
            sql.append(" and t.FCompanyId='").append(orgId).append("' \n");
        } else {
            sql.append(" and t.FCompanyId is null \n");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertTaskRecord(Context ctx, String orgId, String taskId, int periodNumber, boolean isReverse) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_PCC_TaskExecution(FID, FCompanyId, FTaskId, \n");
        sql.append(" FCreatorId, FPeriod, FDescription_l1, FDescription_l2,");
        sql.append(" FDescription_l3, FLeadDay, FStatus,  \n");
        sql.append(" FCreateTime, FLastUpdateTime) \n");
        sql.append("select ? FID, ? FCompanyId, ? FTaskId, ? FCreatorId, ? FPeriod, ");
        sql.append(this.getDesc(ctx, isReverse));
        sql.append(", 0 FLeadDay, 3 FStatus, ? FCreateTime, ? FLastUpdateTime \n");
        sql.append("from t_pcc_task t1 where t1.FID=? ");
        String id = BOSUuid.create((BOSObjectType)BOSObjectType.create((String)"698AD5A2")).toString();
        String userId = ctx.getCaller().toString();
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        Object[] objs = new Object[]{id, orgId, taskId, userId, periodNumber, time, time, taskId};
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])objs);
        try {
            this.updateAfterExecRecord(ctx, orgId, taskId, periodNumber, isReverse, id);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateAfterExecRecord(Context ctx, String orgId, String taskId, int periodNumber, boolean isReverse, String id) throws BOSException, SQLException {
        boolean isOrgSetting = this.isOrgSetting(ctx, orgId);
        Calendar calendar = Calendar.getInstance();
        int leadDay = 0;
        Object[] param = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select ts.FPlanDateTime, ts.FStageId, te.FLastUpdateTime from T_PCC_TaskSchedule ts left join T_PCC_TaskExecution te on ts.FTASKID = te.FTASKID and ts.FCOMPANYID = te.FCOMPANYID \n");
        if (isOrgSetting) {
            sql.append("where ts.FTaskId=? and ts.FCompanyId=? and te.Fperiod=? and te.FCreatorId is not null");
            param = new Object[]{taskId, orgId, periodNumber};
        } else {
            sql.append("where ts.FTaskId=? and ts.FCompanyId is null and te.Fperiod=? and te.FCreatorId is not null");
            param = new Object[]{taskId, periodNumber};
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rs.next()) {
            String planDateTime = rs.getString("FPlanDateTime");
            String stageId = rs.getString("FStageId");
            Timestamp accomplishedTime = rs.getTimestamp("FLastUpdateTime");
            SchedulePlanDateEnum planDateEnum = SchedulePlanDateEnum.getEnum(planDateTime);
            if (planDateEnum != null && !isReverse) {
                leadDay = planDateEnum.intervalByPeriod(String.valueOf(periodNumber), planDateTime, accomplishedTime);
            }
            TaskStatusEnum status = this.getStatus(isReverse, leadDay);
            StringBuffer update = new StringBuffer();
            update.append("update T_PCC_TaskExecution set FLastUpdateTime = null, FStatus=? \n");
            update.append("where FPeriod=? and FCompanyId=? and FTaskId=? and FID<>? ");
            DbUtil.execute((Context)ctx, (String)update.toString(), (Object[])new Object[]{status.getValue(), periodNumber, orgId, taskId, id});
            update.setLength(0);
            update.append("update T_PCC_TaskExecution set  FStatus=?,FLeadDay=? where FID=? ");
            DbUtil.execute((Context)ctx, (String)update.toString(), (Object[])new Object[]{status.getValue(), leadDay, id});
            StageStatusEnum stageStatus = this.getStageStatus(ctx, status, orgId, stageId, periodNumber);
            StageStatusEnum scheduleStatus = this.getScheduleStatus(ctx, status, orgId, periodNumber);
            update.setLength(0);
            update.append("update T_PCC_TaskExecution t set FStageStatus = ? \n");
            update.append("where t.FPeriod=? and t.FCompanyId=? and t.FTaskId in \n");
            update.append(" (select s.FTaskId from t_pcc_taskSchedule s  where s.FStageId = ? \n");
            if (isOrgSetting) {
                update.append(" and s.FCompanyID ='").append(orgId).append("' ");
            } else {
                update.append(" and s.FCompanyID is null ");
            }
            update.append(" ) \n");
            DbUtil.execute((Context)ctx, (String)update.toString(), (Object[])new Object[]{stageStatus.getValue(), periodNumber, orgId, stageId});
            update.setLength(0);
            update.append("update T_PCC_TaskExecution set FScheduleStatus = ?,FCompanyLeadDay=? \n");
            update.append("where FPeriod=? and FCompanyId=? ");
            int companyLeadDays = 0;
            if (scheduleStatus.getValue() == 4) {
                String maxPlanDate;
                sql.setLength(0);
                sql.append("select Max(FPlanDateTime) maxPlanDate from T_PCC_TaskSchedule \n");
                if (isOrgSetting) {
                    sql.append("where FCompanyId=? ");
                    param = new Object[]{orgId};
                } else {
                    sql.append("where  FCompanyId is null ");
                    param = new Object[]{};
                }
                IRowSet rsC = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
                if (rsC.next() && (maxPlanDate = rsC.getString("maxPlanDate")) != null) {
                    SchedulePlanDateEnum maxPlanDateEnum = SchedulePlanDateEnum.getEnum(maxPlanDate);
                    companyLeadDays = maxPlanDateEnum.intervalByPeriod(String.valueOf(periodNumber), maxPlanDate, calendar.getTime());
                }
            }
            DbUtil.execute((Context)ctx, (String)update.toString(), (Object[])new Object[]{scheduleStatus.getValue(), companyLeadDays, periodNumber, orgId});
        }
    }

    private boolean isOrgSetting(Context ctx, String orgId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_PCC_TaskSchedule where FCompanyId='").append(orgId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs != null && rs.size() > 0;
    }

    private TaskStatusEnum getStatus(boolean isReverse, int leadDay) {
        TaskStatusEnum status = null;
        status = isReverse ? (leadDay < 0 ? TaskStatusEnum.UNDERWAY_DELAY : TaskStatusEnum.UNDERWAY) : (leadDay < 0 ? TaskStatusEnum.ACCOMPLISHED_DELAY : TaskStatusEnum.ACCOMPLISHED);
        return status;
    }

    private StageStatusEnum getStageStatus(Context ctx, TaskStatusEnum status, String orgId, String stageId, int period) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FStatus from T_PCC_TaskExecution t \n");
        sql.append("  inner join t_pcc_taskSchedule s on s.FTaskId=t.FTaskId \n");
        if (this.isOrgSetting(ctx, orgId)) {
            sql.append(" and s.FCompanyId = t.FCompanyId \n");
        } else {
            sql.append(" and s.FCompanyId is null ");
        }
        sql.append("  where t.FCompanyId=? and s.FStageId=? and t.FPeriod=? ");
        return this.checkStageStatus(ctx, status, sql.toString(), new Object[]{orgId, stageId, period});
    }

    private StageStatusEnum getScheduleStatus(Context ctx, TaskStatusEnum status, String orgId, int period) throws BOSException, SQLException {
        String sql = "select FStatus from T_PCC_TaskExecution where FCompanyId=? and FPeriod=? ";
        return this.checkStageStatus(ctx, status, sql.toString(), new Object[]{orgId, period});
    }

    private StageStatusEnum checkStageStatus(Context ctx, TaskStatusEnum status, String sql, Object[] sqlParam) throws BOSException, SQLException {
        boolean isTaskExecuted = false;
        boolean isNotTaskExecuted = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlParam);
        while (rs.next()) {
            if (rs.getInt("FStatus") == 1 || rs.getInt("FStatus") == 2) {
                isTaskExecuted = true;
                continue;
            }
            if (rs.getInt("FStatus") != 3 && rs.getInt("FStatus") != 4) continue;
            isNotTaskExecuted = true;
        }
        if (isTaskExecuted && isNotTaskExecuted) {
            return StageStatusEnum.UNDERWAY;
        }
        if (isTaskExecuted && !isNotTaskExecuted) {
            return StageStatusEnum.ACCOMPLISHED;
        }
        return StageStatusEnum.UNTREATED;
    }

    private String getDesc(Context ctx, boolean isReverse) {
        String desc = "t1.FName_l1 FDescription_l1 ,t1.FName_l2 FDescription_l2 ,t1.FName_l3 FDescription_l3 ";
        if (isReverse) {
            String reverseOpt_l1 = ResourceBase.getString((String)RESOURCE_FI_CC, (String)"REVERSE_OPT", (Locale)LocaleUtils.locale_l1);
            String reverseOpt_l2 = ResourceBase.getString((String)RESOURCE_FI_CC, (String)"REVERSE_OPT", (Locale)LocaleUtils.locale_l2);
            String reverseOpt_l3 = ResourceBase.getString((String)RESOURCE_FI_CC, (String)"REVERSE_OPT", (Locale)LocaleUtils.locale_l3);
            desc = "concat(t1.Fname_l1, '" + reverseOpt_l1 + "') FDescription_l1 \n,concat(t1.Fname_l2, '" + reverseOpt_l2 + "') FDescription_l2 \n,concat(t1.Fname_l3, '" + reverseOpt_l3 + "') FDescription_l3 ";
        }
        return desc;
    }

    @Override
    protected void _markTask(Context ctx, String orgId, String taskId, int periodNumber, boolean isReverse) throws BOSException {
        if (!this.hasPreExecRecord(ctx, orgId, periodNumber)) {
            this.insertPreExeRecord(ctx, orgId, periodNumber);
        }
        String userId = ctx.getCaller().toString();
        Timestamp time = new Timestamp(new Date().getTime());
        Object[] param = new Object[]{userId, time, time, orgId, taskId, periodNumber};
        if (isReverse) {
            param = new Object[]{null, null, null, orgId, taskId, periodNumber};
        }
        if (this.isTaskExecExists(ctx, orgId, taskId, periodNumber)) {
            this.updateTaskRecord(ctx, orgId, taskId, periodNumber, isReverse);
        } else {
            this.insertTaskRecord(ctx, orgId, taskId, periodNumber, isReverse);
        }
    }

    @Override
    protected void _updateByTaskExecChange(Context ctx, String orgId, String taskId, int periodNumber, String taskExecId) throws BOSException {
        boolean isReverse = false;
        String reverseOpt = ResourceBase.getString((String)RESOURCE_FI_CC, (String)"REVERSE_OPT", (Locale)ctx.getLocale());
        StringBuffer sql = new StringBuffer();
        String descColName = "FDescription_" + ctx.getLocale();
        sql.append("select ").append(descColName).append(" from T_PCC_TaskExecution \n");
        sql.append(" where FID=? ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{taskExecId});
        try {
            String desc;
            if (rs.next() && (desc = rs.getString(descColName)) != null && desc.indexOf(reverseOpt) != -1) {
                isReverse = true;
            }
            this.updateAfterExecRecord(ctx, orgId, taskId, periodNumber, isReverse, taskExecId);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

