/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.pcc.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.fi.pcc.IStage;
import com.kingdee.eas.fi.pcc.IStageTask;
import com.kingdee.eas.fi.pcc.ITaskExecution;
import com.kingdee.eas.fi.pcc.PCCException;
import com.kingdee.eas.fi.pcc.StageFactory;
import com.kingdee.eas.fi.pcc.StageInfo;
import com.kingdee.eas.fi.pcc.StageStatusEnum;
import com.kingdee.eas.fi.pcc.StageTaskFactory;
import com.kingdee.eas.fi.pcc.StageTaskInfo;
import com.kingdee.eas.fi.pcc.TaskExecutionFactory;
import com.kingdee.eas.fi.pcc.TaskExecutionInfo;
import com.kingdee.eas.fi.pcc.TaskScheduleInfo;
import com.kingdee.eas.fi.pcc.app.AbstractTaskScheduleControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.log4j.Logger;

public class TaskScheduleControllerBean
extends AbstractTaskScheduleControllerBean {
    private static final long serialVersionUID = -462993602585845828L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.pcc.app.TaskScheduleControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaskScheduleInfo newInfo = (TaskScheduleInfo)model;
        this.checkScheduleInfo(ctx, newInfo);
        IObjectPK pk = super._addnew(ctx, model);
        String companyId = newInfo.getCompany().getId().toString();
        String stageId = newInfo.getStage().getId().toString();
        int period = this.getCurrentPeriod(newInfo.getCompany().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_PCC_TaskSchedule ").append("where fcompanyid = ? and fstageid = ? order by FSeq ");
        Object[] params = new Object[]{companyId, stageId};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            int i = 1;
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            while (rs != null && rs.next()) {
                paramList.add(new Object[]{new Integer(i * 10), rs.getString("FID")});
                ++i;
            }
            String updateSql = "update T_PCC_TaskSchedule set FSeq = ? where FID = ? ";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
            sql.setLength(0);
            sql.append("select count(*) exeCount from T_PCC_TaskExecution ").append("where fcompanyid = ? and fperiod = ? ");
            params = new Object[]{companyId, new Integer(period)};
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rs.next() && rs.getInt("exeCount") > 0) {
                sql.setLength(0);
                sql.append("select count(*) exeCount from T_PCC_TaskExecution ").append("where fcompanyid = ? ").append("and fperiod = ? ").append("and ftaskid in (select ftaskid ").append("from T_PCC_TaskSchedule ").append("where fcompanyid = ? ").append("and fstageid = ?)");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{companyId, new Integer(period), companyId, stageId});
                StageStatusEnum stageStaus = StageStatusEnum.UNTREATED;
                if (rs.next() && rs.getInt("exeCount") > 0) {
                    stageStaus = StageStatusEnum.UNDERWAY;
                }
                TaskExecutionInfo teInfo = new TaskExecutionInfo();
                teInfo.setId(BOSUuid.create((BOSObjectType)teInfo.getBOSType()));
                teInfo.setCompany(newInfo.getCompany());
                teInfo.setTask(newInfo.getTask());
                teInfo.setPeriod(period);
                teInfo.setStageStatus(stageStaus);
                teInfo.setScheduleStatus(StageStatusEnum.UNDERWAY);
                ITaskExecution taskExeCtrl = TaskExecutionFactory.getLocalInstance(ctx);
                taskExeCtrl.addnew((CoreBaseInfo)teInfo);
                sql.setLength(0);
                sql.append("update T_PCC_TaskExecution ").append("set FStageStatus = ? ").append("where fcompanyid = ? ").append("and fperiod = ? ").append("and ftaskid in (select ftaskid ").append("from T_PCC_TaskSchedule ").append("where fcompanyid = ? ").append("and fstageid = ?)");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(stageStaus.getValue()), companyId, new Integer(period), companyId, stageId});
                sql.setLength(0);
                sql.append("update T_PCC_TaskExecution ").append("set FScheduleStatus = ? ").append("where fcompanyid = ? and fperiod = ? ");
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(3), companyId, new Integer(period)});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaskScheduleInfo newInfo = (TaskScheduleInfo)model;
        this.checkScheduleInfo(ctx, newInfo);
        TaskScheduleInfo oldInfo = (TaskScheduleInfo)this.getValue(ctx, pk);
        if (oldInfo == null) {
            throw new BOSException("PK" + pk + " isn't existed");
        }
        super._update(ctx, pk, model);
        this.updateExecuteInfo(ctx, newInfo, oldInfo);
    }

    private void updateExecuteInfo(Context ctx, TaskScheduleInfo newInfo, TaskScheduleInfo oldInfo) throws EASBizException, BOSException {
        String companyId = newInfo.getCompany().getId().toString();
        String taskId = newInfo.getTask().getId().toString();
        int period = this.getCurrentPeriod(newInfo.getCompany().getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_PCC_TaskExecution ").append("where fcompanyid = ?  ").append("and ftaskid = ? and fperiod = ? and FLastUpdateTime is not null ");
        Object[] params = new Object[]{companyId, taskId, new Integer(period)};
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            if (rs != null && rs.next()) {
                FIClosingCenterFacadeFactory.getLocalInstance(ctx).updateByTaskExecChange(companyId, taskId, period, rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private void checkScheduleInfo(Context ctx, TaskScheduleInfo info) throws EASBizException, BOSException {
        String sql = "select count(*) tCount from T_PCC_TaskSchedule where fcompanyid = ? and ftaskid = ? and fid <> ? ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{info.getCompany().getId().toString(), info.getTask().getId().toString(), info.getId().toString()});
        try {
            if (rs != null && rs.next() && rs.getInt("tCount") > 0) {
                throw new PCCException(PCCException.COMPANYTASKDUP);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private int getCurrentPeriod(String companyId) {
        int year = Calendar.getInstance().get(1);
        int month = Calendar.getInstance().get(2) + 1;
        return year * 100 + month;
    }

    @Override
    protected void _initCompanyData(Context ctx, String companyId) throws BOSException, EASBizException {
        IStage stageCtrl = StageFactory.getLocalInstance(ctx);
        boolean bExisted = stageCtrl.exists("select id where company.id = '" + companyId + "'");
        if (bExisted) {
            return;
        }
        CoreBaseCollection cols = stageCtrl.getCollection("select * where company.id is null order by seq asc");
        if (cols.size() > 0) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            CoreBaseCollection companyStageCol = new CoreBaseCollection();
            CoreBaseCollection taskScheduleCol = new CoreBaseCollection();
            Timestamp ts = new Timestamp(Calendar.getInstance().getTimeInMillis());
            IStageTask stageTaskCtrl = StageTaskFactory.getLocalInstance(ctx);
            for (int index = 0; index < cols.size(); ++index) {
                StageInfo cStage = (StageInfo)cols.get(index);
                StageInfo stageInfo = new StageInfo();
                stageInfo.setId(BOSUuid.create((String)"F4DC3C8D"));
                stageInfo.setCompany(company);
                stageInfo.setNumber(cStage.getNumber());
                stageInfo.setName(cStage.getName());
                stageInfo.setSeq(cStage.getSeq());
                stageInfo.setCreateTime(ts);
                companyStageCol.add((CoreBaseInfo)stageInfo);
                CoreBaseCollection stCol = stageTaskCtrl.getCollection("select * where stage.id = '" + cStage.getId().toString() + "' order by seq asc ");
                if (stCol.size() <= 0) continue;
                for (int j = 0; j < stCol.size(); ++j) {
                    StageTaskInfo stInfo = (StageTaskInfo)stCol.get(j);
                    TaskScheduleInfo tsInfo = new TaskScheduleInfo();
                    tsInfo.setSeq((j + 1) * 10);
                    tsInfo.setId(BOSUuid.create((String)"708C4ECD"));
                    tsInfo.setCompany(company);
                    tsInfo.setStage(stageInfo);
                    tsInfo.setTask(stInfo.getTask());
                    tsInfo.setPlanDateTime("105 23:59");
                    taskScheduleCol.add((CoreBaseInfo)tsInfo);
                }
            }
            if (companyStageCol.size() > 0) {
                stageCtrl.addnewBatchData(companyStageCol);
            }
            if (taskScheduleCol.size() > 0) {
                this.addnewBatchData(ctx, taskScheduleCol);
            }
        }
    }
}

