/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.BizFormulaMover;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.StringExpr;
import java.util.List;

public class AcctFormulaMover
extends BizFormulaMover {
    public String[] getFormulaNames() {
        String[] FormulaNames = new String[]{"Acct", "AcctExt"};
        return FormulaNames;
    }

    private String increamentAccountNumber(String str) {
        return this.AccountNumberRange(str, true);
    }

    private String decrementAccountNumber(String str) {
        return this.AccountNumberRange(str, false);
    }

    private String AccountNumberRange(String string, boolean isIncreament) {
        String rightPart = null;
        String accountNumberPart = null;
        AccountNumber leftNumber = null;
        AccountNumber rightNumber = null;
        int projectSplitIndex = string.indexOf(124);
        if (projectSplitIndex != -1) {
            rightPart = string.substring(projectSplitIndex);
            accountNumberPart = string.substring(0, projectSplitIndex);
        } else {
            accountNumberPart = string;
        }
        int accountSplitIndex = accountNumberPart.indexOf(58);
        if (accountSplitIndex != -1) {
            leftNumber = new AccountNumber(accountNumberPart.substring(0, accountSplitIndex));
            rightNumber = new AccountNumber(accountNumberPart.substring(accountSplitIndex + 1));
        } else {
            leftNumber = new AccountNumber(accountNumberPart);
        }
        if (isIncreament) {
            if (leftNumber != null) {
                leftNumber.increment();
            }
            if (rightNumber != null) {
                rightNumber.increment();
            }
        } else {
            if (leftNumber != null) {
                leftNumber.decrement();
            }
            if (rightNumber != null) {
                rightNumber.decrement();
            }
        }
        StringBuffer buf = new StringBuffer();
        if (leftNumber != null) {
            buf.append(leftNumber.getString());
        }
        if (rightNumber != null) {
            buf.append(":");
            buf.append(rightNumber.getString());
        }
        if (rightPart != null) {
            buf.append(rightPart);
        }
        return buf.toString();
    }

    public void move(int moveTo, String fuctionName, List params) {
        String str = params.get(1).toString();
        params.set(1, this.increamentAccountNumber(str));
    }

    public void move(int derection, FunctionExpr expression) {
        StringExpr str = (StringExpr)expression.parameters.get(1);
        str.value = derection == 4 || derection == 1 ? this.decrementAccountNumber(str.value) : this.increamentAccountNumber(str.value);
    }

    public int[] getModifiedParasIndexs() {
        return new int[]{1};
    }

    private class AccountNumber {
        String beforePointPart = null;
        String afterPointPart = null;

        public AccountNumber(String number) {
            if (number.indexOf(46) == -1) {
                this.afterPointPart = number;
            } else {
                int point;
                for (point = number.length() - 1; point >= 0 && number.charAt(point) != '.'; --point) {
                }
                this.beforePointPart = number.substring(0, ++point);
                this.afterPointPart = number.substring(point);
            }
        }

        public void increment() {
            if (this.afterPointPart != null && this.afterPointPart.trim().length() > 0) {
                try {
                    String oldString = this.afterPointPart;
                    int temp = Integer.parseInt(this.afterPointPart) + 1;
                    this.afterPointPart = Integer.toString(temp);
                    if (this.afterPointPart.length() > oldString.length()) {
                        this.afterPointPart = oldString;
                    } else if (this.afterPointPart.length() < oldString.length()) {
                        StringBuffer buf = new StringBuffer();
                        int z = oldString.length() - this.afterPointPart.length();
                        for (int i = 0; i < z; ++i) {
                            buf.append("0");
                        }
                        this.afterPointPart = buf.toString() + this.afterPointPart;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void decrement() {
            if (this.afterPointPart != null && this.afterPointPart.trim().length() > 0) {
                try {
                    int temp = Integer.parseInt(this.afterPointPart);
                    if (temp > 1) {
                        --temp;
                    }
                    this.afterPointPart = Integer.toString(temp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public String getString() {
            StringBuffer buf = new StringBuffer();
            if (this.beforePointPart != null) {
                buf.append(this.beforePointPart);
            }
            if (this.afterPointPart != null) {
                buf.append(this.afterPointPart);
            }
            return buf.toString();
        }
    }
}

