/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.PeriodHandler;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptRefractor;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.batch.BatchHelper;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AcctStruct
implements Serializable {
    private static final long serialVersionUID = -3974634043622563L;
    private static Logger logger = Logger.getLogger(AcctStruct.class);
    private static final int NOT_NUMBER_VALUE = -9999;
    private boolean checkDataRight = false;
    private BalanceTypeEnum balanceType = null;
    private boolean includeVoucher = false;
    private String companyNumber = null;
    private String fiOrgUnitNum = null;
    private OrgType orgType = OrgType.Company;
    private boolean useRptOrgType = false;
    private String accountItem = null;
    private int startYear = 0;
    private int startPeriod = 0;
    private int endYear = 0;
    private int endPeriod = 0;
    private String currencyNumber = null;
    private Context serverCtx = null;
    private boolean isIncludeSubAccount = false;
    private boolean isIncludeLeafAccount = false;
    private boolean isIncludeSubAsstItem;
    private boolean isIncludeLeafAsstItem;
    private String accountTable;
    private boolean isInitRacct;
    private PeriodCollection fiscalPeriods = null;
    private boolean isMergeByFiscalPeriod = false;
    private boolean isProfitCenter = false;
    private boolean IncludeDetailAccountAsstItem = false;
    protected boolean isCalcByPriorityAccount;
    private IBackfillHandler backFiller = null;

    public boolean isCalcByPriorityAccount() {
        return this.isCalcByPriorityAccount;
    }

    public PeriodCollection getFiscalPeriods() {
        return this.fiscalPeriods;
    }

    public void setFiscalPeriods(PeriodCollection fiscalPeriods) {
        this.fiscalPeriods = fiscalPeriods;
    }

    public boolean isMergeByFiscalPeriod() {
        return this.isMergeByFiscalPeriod;
    }

    public void setMergeByFiscalPeriod(boolean isMergeByFiscalPeriod) {
        this.isMergeByFiscalPeriod = isMergeByFiscalPeriod;
    }

    public static AcctStruct getInstance(Object[] params, RptSheetParamInfo sheetParam, RptRefractor rptRefractor) throws BOSException, EASBizException {
        AcctStruct acct = new AcctStruct(params);
        return acct;
    }

    public static AcctStruct getInstance(Object[] params) throws BOSException, EASBizException {
        return AcctStruct.getInstance(params, false);
    }

    public static AcctStruct getInstance(Object[] params, boolean isInitRacct) throws BOSException, EASBizException {
        if (isInitRacct) {
            return new AcctStruct(params, isInitRacct);
        }
        return new AcctStruct(params);
    }

    public boolean check() throws Exception {
        if (this.currencyNumber == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_calc_nocurrency", (Locale)this.serverCtx.getOriginLocale()) + " \"" + this.currencyNumber + "\""});
        }
        if (this.companyNumber == null) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        if (this.balanceType == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        return true;
    }

    public AcctStruct(Object[] params) {
        if (params[0] instanceof Object[]) {
            params = (Object[])params[0];
        }
        if (params.length != 8 && params.length != 9) {
            throw new IllegalArgumentException("ACCT" + RptUtil.getResourceSince51("FormulaMust") + "8" + RptUtil.getResourceSince51("Parameter"));
        }
        this.companyNumber = ((Variant)params[0]).getValue().toString().trim();
        this.accountItem = ((Variant)params[1]).getValue().toString().trim();
        Object param = ((Variant)params[2]).getValue();
        this.balanceType = param instanceof BalanceTypeEnum ? (BalanceTypeEnum)((Object)param) : BalanceTypeEnum.getEnum(((Variant)params[2]).getValue().toString().toUpperCase().trim());
        this.startYear = this.initNumberParam((Variant)params[3]);
        this.startPeriod = this.initNumberParam((Variant)params[4]);
        this.endYear = this.initNumberParam((Variant)params[5]);
        this.endPeriod = this.initNumberParam((Variant)params[6]);
        this.currencyNumber = ((Variant)params[7]).getValue().toString().trim();
        if (params.length > 8) {
            String orgTypeStr = ((Variant)params[8]).getValue().toString().trim();
            this.orgType = OrgType.getEnum((String)orgTypeStr);
            if (this.orgType == null) {
                this.orgType = OrgType.Company;
                this.useRptOrgType = true;
            }
        } else {
            this.orgType = OrgType.Company;
            this.useRptOrgType = true;
        }
    }

    private int initNumberParam(Variant variant) {
        if (variant.getValue() instanceof Number) {
            return ((Number)variant.getValue()).intValue();
        }
        try {
            return Integer.valueOf(variant.getValue().toString());
        }
        catch (Exception ex) {
            return -9999;
        }
    }

    public AcctStruct(Object[] params, boolean isInitRacct) {
        if (params[0] instanceof Object[]) {
            params = (Object[])params[0];
        }
        if (params.length != 9) {
            throw new IllegalArgumentException("RACCT" + RptUtil.getResourceSince51("FormulaMust") + "9" + RptUtil.getResourceSince51("Parameter"));
        }
        this.isInitRacct = isInitRacct;
        this.companyNumber = ((Variant)params[0]).getValue().toString();
        this.accountTable = ((Variant)params[1]).getValue().toString();
        this.accountItem = ((Variant)params[2]).getValue().toString();
        Object param = ((Variant)params[3]).getValue();
        this.balanceType = param instanceof BalanceTypeEnum ? (BalanceTypeEnum)((Object)param) : BalanceTypeEnum.getEnum(((Variant)params[3]).getValue().toString().toUpperCase());
        this.startYear = this.initNumberParam((Variant)params[4]);
        this.startPeriod = this.initNumberParam((Variant)params[5]);
        this.endYear = this.initNumberParam((Variant)params[6]);
        this.endPeriod = this.initNumberParam((Variant)params[7]);
        this.currencyNumber = ((Variant)params[8]).getValue().toString();
    }

    private AcctStruct() {
    }

    public AcctStruct(String companyNumber, String accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currencyNumber, OrgType orgType) {
        this.companyNumber = companyNumber;
        this.accountItem = accountItem;
        this.balanceType = balanceType;
        this.startYear = startYear;
        this.startPeriod = startPeriod;
        this.endYear = endYear;
        this.endPeriod = endPeriod;
        this.currencyNumber = currencyNumber;
        this.orgType = orgType;
        this.isProfitCenter = true;
    }

    public AcctStruct(String companyNumber, String accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currencyNumber) {
        this.companyNumber = companyNumber;
        this.accountItem = accountItem;
        this.balanceType = balanceType;
        this.startYear = startYear;
        this.startPeriod = startPeriod;
        this.endYear = endYear;
        this.endPeriod = endPeriod;
        this.currencyNumber = currencyNumber;
    }

    public AcctStruct reviseParameters(RptSheetParamInfo sheetParam, RptRefractor rptRefractor) throws ReportException, BOSException, EASBizException {
        if (sheetParam == null || rptRefractor == null) {
            return this;
        }
        ReportBaseInfo report = rptRefractor.getReportBaseInfo();
        return this.reviseParameters(sheetParam, report);
    }

    public AcctStruct reviseParameters(RptSheetParamInfo sheetParam, ReportBaseInfo report) throws ReportException, BOSException, EASBizException {
        if (this.balanceType == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        if (sheetParam == null) {
            return this;
        }
        if (report != null) {
            if ((this.companyNumber == null || this.companyNumber.length() <= 0) && report.getCompany() != null) {
                this.companyNumber = report.getCompany().getNumber();
            }
            if (this.startYear <= 0) {
                this.startYear = (sheetParam == null || sheetParam.getStartYear() == 0 ? report.getYear() : sheetParam.getStartYear()) + this.startYear;
            }
            if (this.startPeriod <= 0) {
                this.startPeriod = (sheetParam == null || sheetParam.getStartPeriod() == 0 ? report.getPeriod() : sheetParam.getStartPeriod()) + this.startPeriod;
                if (this.startPeriod <= 0) {
                    --this.startYear;
                    this.startPeriod += PeriodUtils.getMaxPeriodNumber((Context)this.serverCtx, (int)this.startYear, (String)report.getCompany().getId().toString());
                }
                if (report.getPeriodType() != null && !report.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.startYear, (int)this.startPeriod, (RptPeriodTypeEnum)report.getPeriodType());
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(periodLastDate);
                    this.startYear = calendar.get(1);
                    this.startPeriod = calendar.get(2) + 1;
                }
            }
            if (this.endYear <= 0) {
                this.endYear = (sheetParam == null || sheetParam.getEndYear() == 0 ? report.getYear() : sheetParam.getEndYear()) + this.endYear;
            }
            if (this.endPeriod <= 0) {
                this.endPeriod = (sheetParam == null || sheetParam.getEndPeriod() == 0 ? report.getPeriod() : sheetParam.getEndPeriod()) + this.endPeriod;
                if (this.endPeriod <= 0) {
                    --this.endYear;
                    this.endPeriod += PeriodUtils.getMaxPeriodNumber((Context)this.serverCtx, (int)this.startYear, (String)report.getCompany().getId().toString());
                }
                if (report.getPeriodType() != null && !report.getPeriodType().equals((Object)RptPeriodTypeEnum.MONTHLY)) {
                    Calendar calendar = Calendar.getInstance();
                    Date periodLastDate = RPTDateUtil.getPeriodLastDate((int)this.endYear, (int)this.endPeriod, (RptPeriodTypeEnum)report.getPeriodType());
                    calendar.setTime(periodLastDate);
                    this.endYear = calendar.get(1);
                    this.endPeriod = calendar.get(2) + 1;
                }
            }
            if (this.currencyNumber == null || this.currencyNumber.length() <= 0) {
                if (sheetParam != null && sheetParam.getCurrency() != null) {
                    this.currencyNumber = sheetParam.getCurrency().getNumber().toString();
                } else if (report.getCurrency() != null) {
                    this.currencyNumber = report.getCurrency().getNumber().toString();
                }
            }
        }
        this.currencyNumber = this.currencyNumber.toUpperCase(Locale.ENGLISH);
        if ((this.currencyNumber.equals("GLC") || this.currencyNumber.equals("GRC")) && this.balanceType != null && (this.balanceType.getName().charAt(0) == 'T' || this.balanceType.getName().charAt(0) == 'R')) {
            throw new BOSException(RptUtil.getResourceSince51("NoSupportFetch"));
        }
        if (sheetParam != null) {
            this.includeVoucher = sheetParam.isIsIncludingUnposted();
        }
        return this;
    }

    public String getAccountItem() {
        return this.accountItem;
    }

    public void setAccountItem(String accountItem) {
        this.accountItem = accountItem;
    }

    public BalanceTypeEnum getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceTypeEnum balanceType) {
        this.balanceType = balanceType;
    }

    public boolean isCheckDataRight() {
        return this.checkDataRight;
    }

    public void setCheckDataRight(boolean checkDataRight) {
        this.checkDataRight = checkDataRight;
    }

    public String getCurrencyNumber() {
        return this.currencyNumber;
    }

    public void setCurrencyNumber(String currencyNumber) {
        this.currencyNumber = currencyNumber;
    }

    public int getEndPeriod() {
        return this.endPeriod;
    }

    public void setEndPeriod(int endPeriod) {
        this.endPeriod = endPeriod;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public boolean isIncludeVoucher() {
        return this.includeVoucher;
    }

    public void setIncludeVoucher(boolean includeVoucher) {
        this.includeVoucher = includeVoucher;
    }

    public int getStartPeriod() {
        return this.startPeriod;
    }

    public void setStartPeriod(int startPeriod) {
        this.startPeriod = startPeriod;
    }

    public int getStartYear() {
        return this.startYear;
    }

    public void setStartYear(int startYear) {
        this.startYear = startYear;
    }

    public Context getServerCtx() {
        return this.serverCtx;
    }

    public void setServerCtx(Context serverCtx) {
        this.serverCtx = serverCtx;
    }

    public AcctStruct copy() {
        AcctStruct r = new AcctStruct();
        r.companyNumber = this.companyNumber;
        r.accountItem = this.accountItem;
        r.balanceType = this.balanceType;
        r.startYear = this.startYear;
        r.startPeriod = this.startPeriod;
        r.endYear = this.endYear;
        r.endPeriod = this.endPeriod;
        r.currencyNumber = this.currencyNumber;
        r.checkDataRight = this.checkDataRight;
        r.includeVoucher = this.includeVoucher;
        r.serverCtx = this.serverCtx;
        r.isIncludeLeafAccount = this.isIncludeLeafAccount;
        r.isIncludeLeafAsstItem = this.isIncludeLeafAsstItem;
        r.isIncludeSubAccount = this.isIncludeSubAccount;
        r.isIncludeSubAsstItem = this.isIncludeSubAsstItem;
        r.IncludeDetailAccountAsstItem = this.IncludeDetailAccountAsstItem;
        r.orgType = this.orgType;
        r.setBackFiller(this.getBackFiller());
        r.isCalcByPriorityAccount = this.isCalcByPriorityAccount;
        return r;
    }

    public IBackfillHandler getBackFiller() {
        return this.backFiller;
    }

    public void setBackFiller(IBackfillHandler backFiller) {
        this.backFiller = backFiller;
    }

    public void reviseParameters(String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        boolean offsetPeriod = false;
        String Company_Number = (String)adapter.getReportProperty("Company.Number");
        String Company_ID = (String)adapter.getReportProperty("Company.ID");
        Integer Period_Type = AcctStruct.getInt(adapter.getReportProperty("PeriodType"), 3);
        Integer SourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        this.isIncludeSubAccount = reportVariables.getBoolValue("IncludeSubAccount", sheetName, false);
        this.isIncludeLeafAccount = reportVariables.getBoolValue("IncludeLeafAccount", sheetName, false);
        this.isIncludeSubAsstItem = reportVariables.getBoolValue("IncludeSub", sheetName, false);
        this.isIncludeLeafAsstItem = reportVariables.getBoolValue("IncludeLeaf", sheetName, false);
        this.isCalcByPriorityAccount = reportVariables.getBoolValue("isCalcByPriorityAccount", sheetName, false);
        if (reportVariables != null) {
            this.IncludeDetailAccountAsstItem = reportVariables.getBoolValue("IncludeAllAssistItems", sheetName, false);
        }
        boolean isSupportAdjustData = false;
        Integer b = (Integer)adapter.getReportProperty("SupportAdjustPeriodData");
        if (b != null && b == 1) {
            isSupportAdjustData = true;
        }
        if (this.balanceType == null) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
        }
        if (sheetName == null) {
            return;
        }
        if (adapter != null) {
            if (StringUtils.isEmpty((String)this.companyNumber) && Company_Number != null) {
                if (SourceType == null) {
                    this.companyNumber = Company_Number;
                } else {
                    switch (SourceType) {
                        case 2: 
                        case 3: 
                        case 8: 
                        case 11: 
                        case 12: {
                            throw new ReportException(ReportException.CURRENT_ORG_IS_GROUP);
                        }
                    }
                    this.companyNumber = Company_Number;
                }
            }
            if (this.startYear == -9999 || this.startPeriod == -9999 || this.endYear == -9999 || this.endPeriod == -9999) {
                throw new ReportException(ReportException.COMMON_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"0_AcctStruct", (Locale)this.serverCtx.getOriginLocale())});
            }
            if (this.startYear <= 0 || this.startPeriod <= 0 || this.endYear <= 0 || this.endPeriod <= 0) {
                int[] yearAndPeriod;
                PeriodHandler periodHandler = new PeriodHandler();
                int variableStartYear = 0;
                int variableStartPeriod = 0;
                int variableEndYear = 0;
                int variableEndPeriod = 0;
                if (reportVariables != null) {
                    variableStartYear = reportVariables.getIntValue("StartYear", sheetName, 0);
                    variableStartPeriod = reportVariables.getIntValue("StartPeriod", sheetName, 0);
                    variableEndYear = reportVariables.getIntValue("EndYear", sheetName, 0);
                    variableEndPeriod = reportVariables.getIntValue("EndPeriod", sheetName, 0);
                }
                int baseStartYear = AcctStruct.getInt(adapter.getReportProperty("Report.Year"), variableStartYear);
                int baseStartPeriod = AcctStruct.getInt(adapter.getReportProperty("Report.Period"), variableStartPeriod);
                int baseEndYear = AcctStruct.getInt(adapter.getReportProperty("Report.Year"), variableEndYear);
                int baseEndPeriod = AcctStruct.getInt(adapter.getReportProperty("Report.Period"), variableEndPeriod);
                if (variableStartYear > 0) {
                    baseStartYear = variableStartYear;
                } else if (variableStartYear < 0) {
                    this.startYear = variableStartYear + this.startYear;
                }
                if (variableEndYear > 0) {
                    baseEndYear = variableEndYear;
                } else if (variableEndYear < 0) {
                    this.endYear = variableEndYear + this.endYear;
                }
                if (variableStartPeriod > 0) {
                    baseStartPeriod = variableStartPeriod;
                } else if (variableStartPeriod < 0) {
                    this.startPeriod = variableStartPeriod + this.startPeriod;
                }
                if (variableEndPeriod > 0) {
                    baseEndPeriod = variableEndPeriod;
                } else if (variableEndPeriod < 0) {
                    this.endPeriod = variableEndPeriod + this.endPeriod;
                }
                if (this.startYear <= 0) {
                    this.startYear += baseStartYear;
                }
                if (this.startPeriod <= 0) {
                    yearAndPeriod = periodHandler.action(this.startYear, this.startPeriod, baseStartYear, baseStartPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), this.fiscalPeriods, this.isMergeByFiscalPeriod);
                    this.startYear = yearAndPeriod[0];
                    this.startPeriod = yearAndPeriod[1];
                    if (Period_Type != null && Period_Type != 3) {
                        yearAndPeriod = FiscalPeriodHelper.getYearAndFirstPeriodNumber((PeriodCollection)this.fiscalPeriods, (int)this.startYear, (int)this.startPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type), (boolean)this.isMergeByFiscalPeriod);
                        this.startYear = yearAndPeriod[0];
                        this.startPeriod = yearAndPeriod[1];
                    }
                }
                if (this.endYear <= 0) {
                    this.endYear += baseEndYear;
                }
                if (this.endPeriod <= 0) {
                    yearAndPeriod = periodHandler.action(this.endYear, this.endPeriod, baseEndYear, baseEndPeriod, RptPeriodTypeEnum.getEnum((int)Period_Type), this.fiscalPeriods, this.isMergeByFiscalPeriod);
                    this.endYear = yearAndPeriod[0];
                    this.endPeriod = yearAndPeriod[1];
                    if (Period_Type != null && Period_Type != 3) {
                        yearAndPeriod = FiscalPeriodHelper.getYearAndLastPeriodNumber((PeriodCollection)this.fiscalPeriods, (int)this.endYear, (int)this.endPeriod, (RptPeriodTypeEnum)RptPeriodTypeEnum.getEnum((int)Period_Type), (boolean)this.isMergeByFiscalPeriod);
                        this.endYear = yearAndPeriod[0];
                        this.endPeriod = yearAndPeriod[1];
                    }
                }
            }
            if (StringUtils.isEmpty((String)this.currencyNumber)) {
                if (reportVariables != null) {
                    this.currencyNumber = reportVariables.getStringValue("Currency", sheetName);
                }
                if (StringUtils.isEmpty((String)this.currencyNumber) && adapter.getReportProperty("Currency.Number") != null) {
                    this.currencyNumber = (String)adapter.getReportProperty("Currency.Number");
                }
            }
        }
        if (isSupportAdjustData && this.endPeriod == 12) {
            int maxPeriod = 0;
            maxPeriod = this.fiscalPeriods != null && this.fiscalPeriods.size() > 0 ? FiscalPeriodHelper.getMaxPeriodNumber((PeriodCollection)this.fiscalPeriods, (int)this.endYear) : PeriodUtils.getMaxPeriodNumber((Context)this.serverCtx, (int)this.endYear, (String)Company_ID);
            this.endPeriod = maxPeriod;
        }
        this.currencyNumber = this.currencyNumber.toUpperCase(Locale.ENGLISH);
        if ((this.currencyNumber.equals("GLC") || this.currencyNumber.equals("GRC")) && this.balanceType != null && (this.balanceType.getName().charAt(0) == 'T' || this.balanceType.getName().charAt(0) == 'R')) {
            throw new BOSException(RptUtil.getResourceSince51("NoSupportFetch"));
        }
        if (reportVariables != null) {
            this.includeVoucher = reportVariables.getBoolValue("IncludePosted", sheetName, false);
        }
    }

    private static int getInt(Object value, int defaultValue) {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return defaultValue;
    }

    public boolean getIsIncludeSubAccount() {
        return this.isIncludeSubAccount;
    }

    public boolean getIsIncludeLeafAccount() {
        return this.isIncludeLeafAccount;
    }

    public boolean isIncludeSubAsstItem() {
        return this.isIncludeSubAsstItem;
    }

    public boolean isIncludeLeafAsstItem() {
        return this.isIncludeLeafAsstItem;
    }

    public boolean isIncludeDetailAccountAsstItem() {
        return this.IncludeDetailAccountAsstItem;
    }

    public String getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(String accountTable) {
        this.accountTable = accountTable;
    }

    public boolean isInitRacct() {
        return this.isInitRacct;
    }

    public void setInitRacct(boolean isInitRacct) {
        this.isInitRacct = isInitRacct;
    }

    public void setFiOrgUnitNum(String fiOrgUnitNum) {
        this.fiOrgUnitNum = fiOrgUnitNum;
    }

    public String getFiOrgUnitNum() {
        if (this.fiOrgUnitNum == null) {
            return this.companyNumber;
        }
        return this.fiOrgUnitNum;
    }

    public void initFiOrgUnitNum(BatchHelper batchHelper) throws EASBizException, BOSException {
        this.setFiOrgUnitNum(batchHelper.convertFIOrgUnit(this.companyNumber));
    }

    public String getCompanyNumber() {
        return this.companyNumber;
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public void setOrgType(OrgType orgType) {
        this.orgType = orgType;
    }

    public boolean isUseRptOrgType() {
        return this.useRptOrgType;
    }

    public boolean isProfitCenter() {
        return this.isProfitCenter;
    }
}

