/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.fi.gr.cslrpt.CSLReportGroupEnum;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.gr.cslrpt.RPTDateUtil;
import com.kingdee.eas.fi.newrpt.report.VariablesHelper;
import com.kingdee.eas.fi.rpt.IContextHandler;
import com.kingdee.eas.fi.rpt.InitDataFacadaFactory;
import com.kingdee.eas.fi.rpt.ReportInfo;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fi.rpt.util.VariableEntry;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class DefaultContextHandler
implements IContextHandler {
    public static final String YEAR = "IContextHandler_year";
    public static final String PERIOD_TYPE = "IContextHandler_period_type";
    public static final String PERIOD = "IContextHandler_period";
    public static final String COMPANY = "IContextHandler_company";
    public static final String ORGTREE = "IContextHandler_orgtree";
    public static final String CURRENCY = "IContextHandler_currency";
    public static final String CREATOR = "IContextHandler_CREATOR";
    public static final String BEGIN_YEAR = "IContextHandler_begin_year";
    public static final String END_YEAR = "IContextHandler_end_year";
    public static final String BEGIN_DATE = "IContextHandler_begin_date";
    public static final String END_DATE = "IContextHandler_end_date";
    public static final String BEGIN_PERIOD = "IContextHandler_begin_period";
    public static final String END_PERIOD = "IContextHandler_end_period";
    public static final String INCLUDE_POSTED = "IContextHandler_INCLUDE_POSTED";
    public static final String INCLUDE_LEAF = "IContextHandler_INCLUDE_LEAF";
    public static final String INCLUDE_SUB = "IContextHandler_INCLUDE_SUB";
    public static final String SHEET_TYPE = "IContextHandler_SHEET_TYPE";
    private static final Logger log = Logger.getLogger((String)DefaultContextHandler.class.getName());

    @Override
    public void handlerContext(Context ctx, ReportInfo report, ReportVariables iv) {
        Object object = ctx.get((Object)PERIOD_TYPE);
        if (object != null && object instanceof RptPeriodTypeEnum) {
            report.setPeriodType((RptPeriodTypeEnum)object);
        } else {
            report.setPeriodType(RptPeriodTypeEnum.MONTHLY);
        }
        object = ctx.get((Object)YEAR);
        if (object != null && object instanceof Integer) {
            report.setYear((Integer)object);
        } else {
            report.setYear(2008);
        }
        object = ctx.get((Object)PERIOD);
        if (object != null && object instanceof Short) {
            report.setPeriod((Short)object);
        } else {
            report.setPeriod((short)1);
        }
        boolean isMergeByFiscalPeriod = FiscalPeriodHelper.isMergeByFiscalPeriod((Context)ctx);
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)isMergeByFiscalPeriod, (RptPeriodTypeEnum)report.getPeriodType())) {
            Date periodfirstDate = null;
            Date periodLastDate = null;
            try {
                PeriodCollection periods = InitDataFacadaFactory.getLocalInstance(ctx).getFiscal();
                periodfirstDate = FiscalPeriodHelper.getPeriodFirstDate((int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType(), (PeriodCollection)periods, (boolean)true);
                periodLastDate = FiscalPeriodHelper.getPeriodLastDate((PeriodCollection)periods, (int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType(), (boolean)true);
            }
            catch (Exception e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Exception e1) {
                    log.debug((Object)e1.getMessage());
                }
            }
            report.setStartDate(periodfirstDate);
            report.setEndDate(periodLastDate);
        } else if (report.getPeriodType() == RptPeriodTypeEnum.MONTHLY && report.getPeriod() == 13) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, report.getYear());
            calendar.set(2, 11);
            calendar.set(5, 31);
            Date date = new Date(calendar.getTimeInMillis());
            report.setStartDate(date);
            report.setEndDate(date);
        } else {
            report.setStartDate(RPTDateUtil.getPeriodFirstDate((int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType()));
            report.setEndDate(RPTDateUtil.getPeriodLastDate((int)report.getYear(), (int)report.getPeriod(), (RptPeriodTypeEnum)report.getPeriodType()));
        }
        object = ctx.get((Object)COMPANY);
        if (object != null && object instanceof CompanyOrgUnitInfo) {
            report.setCompany((CompanyOrgUnitInfo)object);
        }
        if (object != null && object instanceof FullOrgUnitInfo) {
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            companyInfo.setId(((FullOrgUnitInfo)object).getId());
            companyInfo.setNumber(((FullOrgUnitInfo)object).getNumber());
            companyInfo.setName(((FullOrgUnitInfo)object).getName());
            report.setCompany(companyInfo);
        }
        if ((object = ctx.get((Object)ORGTREE)) != null && object instanceof OrgTreeInfo) {
            report.setOrgTree((OrgTreeInfo)object);
        }
        if ((object = ctx.get((Object)CURRENCY)) != null && object instanceof CurrencyInfo) {
            report.setCurrency((CurrencyInfo)object);
        }
        if ((object = ctx.get((Object)CREATOR)) != null && object instanceof UserInfo) {
            report.setCreator((UserInfo)object);
        } else {
            report.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        iv.addAll(DefaultContextHandler.initSheetReservedVariables(ctx, "sheet1", report.getPeriodType()), false);
    }

    public static ReportVariables initSheetReservedVariables(Context ctx, String sheetName, RptPeriodTypeEnum periodType) {
        ReportVariables variables = new ReportVariables();
        String beginYear = (String)ctx.get((Object)BEGIN_YEAR);
        if (beginYear == null) {
            beginYear = "0";
        }
        variables.add(DefaultContextHandler.createReservedEntry("StartYear", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"240_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, beginYear, 3));
        String endYear = (String)ctx.get((Object)END_YEAR);
        if (endYear == null) {
            endYear = "0";
        }
        variables.add(DefaultContextHandler.createReservedEntry("EndYear", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"241_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, endYear, 3));
        String beginDate = (String)ctx.get((Object)BEGIN_DATE);
        String endDate = (String)ctx.get((Object)END_DATE);
        if (beginDate != null && endDate != null) {
            variables.add(DefaultContextHandler.createReservedEntry("StartDate", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"242_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, beginDate, 2));
            variables.add(DefaultContextHandler.createReservedEntry("EndDate", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"243_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, endDate, 2));
        }
        int t = periodType.getValue();
        switch (t) {
            case 1: {
                if (beginDate == null) {
                    beginDate = "";
                }
                variables.add(DefaultContextHandler.createReservedEntry("StartDate", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"242_DefaultContextHandler", (Locale)ctx.getLocale()), sheetName, beginDate, 2));
                if (endDate == null) {
                    endDate = "";
                }
                variables.add(DefaultContextHandler.createReservedEntry("EndDate", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"243_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, endDate, 2));
                break;
            }
            case 6: {
                break;
            }
            default: {
                String beginPeriod = (String)ctx.get((Object)BEGIN_PERIOD);
                if (beginPeriod == null) {
                    beginPeriod = "0";
                }
                variables.add(DefaultContextHandler.createReservedEntry("StartPeriod", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"244_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, beginPeriod, 3));
                String endPeriod = (String)ctx.get((Object)END_PERIOD);
                if (endPeriod == null) {
                    endPeriod = "0";
                }
                variables.add(DefaultContextHandler.createReservedEntry("EndPeriod", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"245_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, endPeriod, 3));
            }
        }
        String currencyNumber = "";
        Object object = ctx.get((Object)CURRENCY);
        if (object != null && object instanceof CurrencyInfo) {
            currencyNumber = ((CurrencyInfo)object).getNumber();
        }
        VariableEntry v = VariablesHelper.createReservedEntry((String)CURRENCY, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"246_DefaultContextHandler", (Locale)ctx.getOriginLocale()), (String)sheetName, (String)currencyNumber);
        v.setQuery("com.kingdee.eas.basedata.assistant.app.CurrencyAllQuery");
        variables.add(v);
        String includePosted = (String)ctx.get((Object)INCLUDE_POSTED);
        if (includePosted == null) {
            includePosted = "N";
        }
        variables.add(DefaultContextHandler.createReservedEntry("IncludePosted", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"247_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, includePosted, 1));
        String includeLeaf = (String)ctx.get((Object)INCLUDE_LEAF);
        if (includeLeaf == null) {
            includeLeaf = "N";
        }
        variables.addWithoutDup(DefaultContextHandler.createReservedEntry("IncludeLeaf", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"248_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, includeLeaf, 1));
        String includeSub = (String)ctx.get((Object)INCLUDE_SUB);
        if (includeSub == null) {
            includeSub = "N";
        }
        variables.addWithoutDup(DefaultContextHandler.createReservedEntry("IncludeSub", ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"249_DefaultContextHandler", (Locale)ctx.getOriginLocale()), sheetName, includeSub, 1));
        CSLReportGroupEnum cSLReportGroupEnum = (CSLReportGroupEnum)ctx.get((Object)SHEET_TYPE);
        if (cSLReportGroupEnum == null) {
            cSLReportGroupEnum = CSLReportGroupEnum.COMMON;
        }
        VariableEntry sheetType = VariablesHelper.createReservedEntry((String)"SheetClass", (String)ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"250_DefaultContextHandler", (Locale)ctx.getOriginLocale()), (String)sheetName, (String)String.valueOf(cSLReportGroupEnum.getValue()));
        sheetType.setVisible(false);
        variables.add(sheetType);
        return variables;
    }

    private static VariableEntry createReservedEntry(String name, String desc, String sheetName, String value, int type) {
        return VariablesHelper.createReservedEntry((String)name, (String)desc, (String)sheetName, (String)value, (int)type);
    }
}

