/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.fi.gr.cslrpt.FiscalPeriodHelper;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PeriodHandler {
    private static final Logger log = Logger.getLogger(PeriodHandler.class);

    public int[] action(int currYear, int currPeriod, int baseYear, int basePeriod, RptPeriodTypeEnum periodType, PeriodCollection companyPeriods, boolean isMergeByFiscalPeriod) {
        int[] yearAndPeriod = new int[2];
        if (baseYear <= 0 || basePeriod <= 0) {
            return new int[]{currYear, currPeriod};
        }
        if (currYear > 0 && currPeriod > 0) {
            return new int[]{currYear, currPeriod};
        }
        if (FiscalPeriodHelper.isMergeByFiscalPeriod((boolean)isMergeByFiscalPeriod, (RptPeriodTypeEnum)periodType) && (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType) || RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) && companyPeriods != null) {
            if (currYear <= 0 && (currYear = baseYear + currYear) <= 0) {
                log.error((Object)("assert currYear > 0: currYear=" + currYear + ",baseYear=" + baseYear), (Throwable)new Exception());
            }
            if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
                if (currPeriod <= 0) {
                    try {
                        Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo((PeriodCollection)companyPeriods);
                        Map yearMap = (Map)periodInfo.get("yearMap");
                        List periodsForYear = null;
                        currPeriod = basePeriod + currPeriod;
                        while (currPeriod <= 0) {
                            periodsForYear = (List)yearMap.get(--currYear);
                            currPeriod = periodsForYear.size() + currPeriod;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                        return null;
                    }
                }
                return this.checkResult(new int[]{currYear, currPeriod});
            }
            if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
                if (currPeriod <= 0) {
                    try {
                        Map periodInfo = FiscalPeriodHelper.getFiscalPeriodInfo((PeriodCollection)companyPeriods);
                        Map yearMap = (Map)periodInfo.get("year_quarterMap");
                        List quarterForYear = null;
                        currPeriod = basePeriod + currPeriod;
                        while (currPeriod <= 0) {
                            quarterForYear = (List)yearMap.get(--currYear);
                            currPeriod = (Integer)quarterForYear.get(quarterForYear.size() - 1) + currPeriod;
                        }
                    }
                    catch (Exception e) {
                        log.error((Object)"", (Throwable)e);
                        return null;
                    }
                }
                return this.checkResult(new int[]{currYear, currPeriod});
            }
        }
        if (RptPeriodTypeEnum.DAILY.equals((Object)periodType)) {
            Calendar currDate = Calendar.getInstance();
            currDate.set(1, baseYear);
            currDate.set(6, basePeriod);
            if (currYear < 0) {
                currDate.add(1, currYear);
            }
            if (currPeriod < 0) {
                currDate.add(6, currPeriod);
            }
            return this.checkResult(new int[]{currDate.get(1), currDate.get(6)});
        }
        if (RptPeriodTypeEnum.WEEKLY.equals((Object)periodType)) {
            Calendar currDate = Calendar.getInstance();
            currDate.set(1, baseYear);
            currDate.set(3, basePeriod);
            if (currYear < 0) {
                currDate.add(1, currYear);
            }
            if (currPeriod < 0) {
                currDate.add(3, currPeriod);
            }
            return this.checkResult(new int[]{currDate.get(1), currDate.get(3)});
        }
        if (RptPeriodTypeEnum.YEARLY.equals((Object)periodType) || RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodType) || RptPeriodTypeEnum.MONTHLY.equals((Object)periodType) || RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
            if (currYear <= 0 && (currYear = baseYear + currYear) <= 0) {
                log.error((Object)("assert currYear > 0: currYear=" + currYear + ",baseYear=" + baseYear), (Throwable)new Exception());
            }
            if (currPeriod > 0) {
                return this.checkResult(new int[]{currYear, currPeriod});
            }
            int maxPeriod = 1;
            if (RptPeriodTypeEnum.YEARLY.equals((Object)periodType)) {
                maxPeriod = 1;
            } else if (RptPeriodTypeEnum.SEMIYEARLY.equals((Object)periodType)) {
                maxPeriod = 2;
            } else if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
                maxPeriod = 12;
            } else if (RptPeriodTypeEnum.QUARTERLY.equals((Object)periodType)) {
                maxPeriod = 4;
            }
            currPeriod = basePeriod + currPeriod;
            while (currPeriod <= 0) {
                --currYear;
                currPeriod = maxPeriod + currPeriod;
            }
            return this.checkResult(new int[]{currYear, currPeriod});
        }
        return this.checkResult(yearAndPeriod);
    }

    public int[] convertMonthRange(int[] yearAndPeriod, RptPeriodTypeEnum periodType, boolean isMerge) {
        if (RptPeriodTypeEnum.MONTHLY.equals((Object)periodType)) {
            return yearAndPeriod;
        }
        return null;
    }

    private int[] checkResult(int[] yearAndPeriod) {
        if (yearAndPeriod[0] <= 0) {
            log.error((Object)("assert currYear > 0: currYear=" + yearAndPeriod[0]), (Throwable)new Exception());
        }
        if (yearAndPeriod[1] <= 0) {
            log.error((Object)("assert currPeriod > 0: currPeriod=" + yearAndPeriod[1]), (Throwable)new Exception());
        }
        return yearAndPeriod;
    }
}

