/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.Rect;
import com.kingdee.eas.fi.rpt.RptComment;
import com.kingdee.eas.fi.rpt.TableToolkit;
import java.awt.Point;

public class RptCellComment
extends RptComment {
    public Point position = new Point();

    @Override
    public RptComment getCommentCopy() {
        this.initialize();
        RptCellComment res = new RptCellComment(this.position.x, this.position.y);
        res.mirror = this;
        res.source = this.source == null ? null : (PostilInfo)this.source.clone();
        res.author = this.author;
        res.date = this.date;
        res.status = this.status;
        res.isInited = true;
        res.content = this.content == null ? "" : new String(this.content);
        return res;
    }

    public RptCellComment(int x, int y) {
        this.position.x = x;
        this.position.y = y;
    }

    @Override
    protected void initialize(PostilInfo info) {
        super.initialize(info);
        info.setPostilType(PostilTypeEnum.CELL);
        info.setCellName(TableToolkit.xy2range(this.position.x, this.position.y));
    }

    public RptCellComment(PostilInfo source) throws Exception {
        super(source);
        Rect rect = TableToolkit.range2xy(source.getCellName());
        if (rect == null || rect.x1 == -1 || rect.y1 == -1) {
            throw new Exception();
        }
        this.position.x = rect.x1;
        this.position.y = rect.y1;
    }

    public Point getPosition() {
        return this.position;
    }
}

