/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.util.IObjectIterator;
import com.kingdee.eas.fi.rpt.util.UserObjectTrans;
import com.kingdee.eas.util.ResourceBase;
import java.io.Serializable;
import java.util.Locale;

public class RptCheckExpression
implements Serializable {
    private static final long serialVersionUID = 20041129105322L;
    private static final int MAX_NAMELENGTH = 100;
    public static final int EDITABLE = 1;
    public static final int DELETEABLE = 2;
    public static final int NORMAL = 3;
    private String name = null;
    private String sheetName = null;
    private String line = null;
    private String desc = null;
    private int status = 3;
    private int checkResultState = 1;
    private String createOrgNum = null;
    private boolean isCreByGroup = false;

    public RptCheckExpression() {
    }

    public RptCheckExpression(String name) {
        this();
        this.name = name;
    }

    public RptCheckExpression(String name, String line) {
        this();
        this.name = name;
        this.line = line;
    }

    public RptCheckExpression(RptCheckExpression mirror) {
        this();
        if (mirror == null) {
            return;
        }
        this.name = mirror.name == null ? null : new String(mirror.name);
        this.sheetName = mirror.sheetName == null ? null : new String(mirror.sheetName);
        this.line = mirror.line == null ? null : new String(mirror.line);
        this.desc = mirror.desc == null ? null : new String(mirror.desc);
        this.status = mirror.status;
        this.checkResultState = mirror.checkResultState;
        this.createOrgNum = mirror.createOrgNum;
        this.isCreByGroup = mirror.isCreByGroup;
    }

    public Object clone() {
        return new RptCheckExpression(this);
    }

    public String toString() {
        if (this.name == null) {
            this.setName(this.line);
        }
        return this.name + this.getCheckResultStateString();
    }

    private String getCheckResultStateString() {
        StringBuffer crs = new StringBuffer("(");
        if (this.getCheckResultState() == 3) {
            crs.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"postil", (Locale)SysContext.getSysContext().getLocale()));
        } else if (this.getCheckResultState() == 2) {
            crs.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"showerror", (Locale)SysContext.getSysContext().getLocale()));
        } else {
            crs.append(ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"forbidsubmit", (Locale)SysContext.getSysContext().getLocale()));
        }
        return crs.append(")").toString();
    }

    public void setName(String newName) {
        int count;
        String tmp = newName;
        if (tmp == null) {
            tmp = this.line;
        }
        if ((count = tmp.length()) > 100) {
            count = 100;
        } else if (count == 0) {
            tmp = " ";
        }
        this.name = new String(tmp.substring(0, count));
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String name) {
        this.sheetName = name;
    }

    public String getContent() {
        return this.line;
    }

    public void setContent(String exp) {
        this.line = exp;
    }

    public String getCreateOrgNum() {
        return this.createOrgNum;
    }

    public void setCreateOrgNum(String createOrgNum) {
        this.createOrgNum = createOrgNum;
    }

    public void setDescription(String text) {
        this.desc = text;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCreByGroup() {
        return this.isCreByGroup;
    }

    public void setCreByGroup(boolean isCreByGroup) {
        this.isCreByGroup = isCreByGroup;
    }

    public boolean isEditable() {
        return (this.status & 1) == 1;
    }

    public boolean isDeleteable() {
        return (this.status & 2) == 2;
    }

    public void setStatus(int s) {
        this.status = s;
    }

    public void setEditable(boolean b) {
        this.status = b ? (this.status |= 1) : (this.status ^= 1);
    }

    private void initStatus() {
        if (this.status == 0) {
            this.status = 3;
        }
    }

    public void setDeleteable(boolean b) {
        this.status = b ? (this.status |= 2) : (this.status ^= 2);
    }

    public void copyFrom(RptCheckExpression aExpression) {
        if (aExpression == null) {
            return;
        }
        this.name = aExpression.name == null ? null : new String(aExpression.name);
        this.sheetName = aExpression.sheetName == null ? null : new String(aExpression.sheetName);
        this.line = aExpression.line == null ? null : new String(aExpression.line);
        this.desc = aExpression.desc == null ? null : new String(aExpression.desc);
        this.status = aExpression.status;
        this.checkResultState = aExpression.checkResultState;
        this.createOrgNum = aExpression.createOrgNum;
        this.isCreByGroup = aExpression.isCreByGroup;
    }

    public void fromSerialString(String s) throws Exception {
        IObjectIterator it = UserObjectTrans.createObjectIterator((String)s);
        if (it.hasNext()) {
            this.name = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.sheetName = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.line = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.desc = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.status = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.checkResultState = (Integer)it.nextObject();
        }
        if (it.hasNext()) {
            this.createOrgNum = (String)it.nextObject();
        }
        if (it.hasNext()) {
            this.isCreByGroup = (Boolean)it.nextObject();
        }
    }

    public String toSerialString() throws Exception {
        StringBuffer sb = new StringBuffer();
        UserObjectTrans.toString((String)this.name, (StringBuffer)sb);
        UserObjectTrans.toString((String)this.sheetName, (StringBuffer)sb);
        UserObjectTrans.toString((String)this.line, (StringBuffer)sb);
        UserObjectTrans.toString((String)this.desc, (StringBuffer)sb);
        UserObjectTrans.toString((Integer)new Integer(this.status), (StringBuffer)sb);
        UserObjectTrans.toString((Integer)new Integer(this.checkResultState), (StringBuffer)sb);
        UserObjectTrans.toString((String)this.createOrgNum, (StringBuffer)sb);
        UserObjectTrans.toString((Boolean)this.isCreByGroup, (StringBuffer)sb);
        return sb.toString();
    }

    public int getCheckResultState() {
        return this.checkResultState;
    }

    public void setCheckResultState(int checkResultState) {
        this.checkResultState = checkResultState;
    }
}

