/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Comment;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.fi.rpt.PostilCollection;
import com.kingdee.eas.fi.rpt.PostilInfo;
import com.kingdee.eas.fi.rpt.RptComment;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;

public class RptCommentTank
extends Comment
implements Cloneable {
    private boolean isModify = false;
    private transient ArrayList backchain;
    private transient ArrayList entrys = new ArrayList(1);
    private transient RptComment newBird = null;
    private transient KDTable table;

    public boolean isModify() {
        return this.isModify;
    }

    public void setModify(boolean isModify) {
        this.isModify = isModify;
    }

    public String getAuthor() {
        for (int i = 0; this.entrys != null && i < this.entrys.size(); ++i) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            if (cmt.author == null) continue;
            return cmt.author.getName();
        }
        return super.getAuthor();
    }

    public String getText() {
        for (int i = 0; this.entrys != null && i < this.entrys.size(); ++i) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            if (cmt.getContent() == null) continue;
            return cmt.getContent();
        }
        return super.getText();
    }

    public void setText(String text) {
        int i = 0;
        if (this.entrys != null && i < this.entrys.size()) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            cmt.setContent(text);
            return;
        }
        super.setText(text);
    }

    public void setAuthor(String author) {
        int i = 0;
        if (this.entrys != null && i < this.entrys.size()) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            if (cmt.author == null) {
                cmt.author = new UserInfo();
            }
            cmt.author.setName(author);
            return;
        }
        super.setAuthor(author);
    }

    public Object clone() {
        RptComment cmt;
        int i;
        RptCommentTank res = new RptCommentTank();
        for (i = 0; i < this.entrys.size(); ++i) {
            cmt = (RptComment)this.entrys.get(i);
            cmt = cmt.getCommentCopy();
            cmt.setNewly();
            res.entrys.add(cmt);
            res.newBird = cmt;
        }
        for (i = 0; i < this.backchain.size(); ++i) {
            cmt = (RptComment)this.backchain.get(i);
            cmt = cmt.getCommentCopy();
            cmt.setDead();
            res.backchain.add(cmt);
        }
        res.table = this.table;
        return res;
    }

    public RptComment getEntry(int i) {
        return (RptComment)this.entrys.get(i);
    }

    public void setTable(KDTable tab) {
        this.table = tab;
    }

    public RptCommentTank() {
        this.backchain = new ArrayList(1);
    }

    public void addEntry(RptComment entry) {
        if (!this.addInitEntry(entry)) {
            return;
        }
        this.newBird = entry;
        this.fireIntervalAdded(this.entrys.size() - 1);
    }

    private void fireIntervalAdded(int index) {
        if (this.table != null && index >= 0) {
            this.loadComment(this.table.addRow(index), this.entrys.get(index));
        }
    }

    public boolean deletEntry(int index) {
        if (index < 0 || index > this.entrys.size() - 1) {
            return false;
        }
        RptComment entry = (RptComment)this.entrys.get(index);
        if (!this.delInitEntry(entry)) {
            return false;
        }
        if (this.newBird == entry) {
            this.newBird = null;
        }
        this.fireIntervalRemoved(index);
        return true;
    }

    private void fireIntervalRemoved(int index) {
        if (this.table != null) {
            this.table.removeRow(index);
        }
    }

    public boolean addInitEntry(RptComment entry) {
        if (entry == null) {
            return false;
        }
        return this.entrys.add(entry);
    }

    public boolean delInitEntry(RptComment entry) {
        if (entry == null) {
            return false;
        }
        if (!entry.isFresh()) {
            entry.setDead();
            this.backchain.add(entry);
        }
        if (this.newBird == entry) {
            this.newBird = null;
        }
        return this.entrys.remove(entry);
    }

    public void dump(PostilCollection comments) {
        this.dump(comments, null);
    }

    public void dump(PostilCollection comments, Object item) {
        int i;
        if (this.entrys == null) {
            return;
        }
        int size = this.entrys.size();
        for (i = 0; i < size; ++i) {
            PostilInfo pi = ((RptComment)this.entrys.get(i)).getSource();
            if (pi == null) continue;
            if (item != null) {
                pi.setItemNumber(item.toString());
            }
            comments.add(pi);
        }
        size = this.backchain.size();
        for (i = 0; i < size; ++i) {
            comments.add(((RptComment)this.backchain.get(i)).getSource());
        }
    }

    public boolean copyFrom(RptCommentTank cmtTank) {
        return this.fetchFrom(cmtTank, false);
    }

    public boolean updateFrom(RptCommentTank cmtTank) {
        return this.fetchFrom(cmtTank, true);
    }

    private boolean fetchFrom(RptCommentTank cmtTank, boolean isUpdate) {
        RptComment cmt;
        int i;
        if (cmtTank == null) {
            return false;
        }
        this.entrys.clear();
        this.backchain.clear();
        int size = cmtTank.entrys.size();
        for (i = 0; i < size; ++i) {
            cmt = (RptComment)cmtTank.entrys.get(i);
            RptComment rptComment = cmt = isUpdate ? cmt.getSmartCopy() : cmt.getCommentCopy();
            if (cmt == null) continue;
            this.entrys.add(cmt);
            if (!cmt.isFresh()) continue;
            this.newBird = cmt;
        }
        size = cmtTank.backchain.size();
        for (i = 0; i < size; ++i) {
            cmt = (RptComment)cmtTank.backchain.get(i);
            RptComment rptComment = cmt = isUpdate ? cmt.getSmartCopy() : cmt.getCommentCopy();
            if (cmt == null) continue;
            this.backchain.add(cmt);
        }
        return true;
    }

    public void sort(int key) {
        int size = this.entrys.size();
        if (size < 1) {
            return;
        }
        switch (key) {
            case 0: {
                key = 0;
                break;
            }
            case 1: {
                key = 1;
                break;
            }
            case 2: {
                key = 2;
                break;
            }
            default: {
                key = 0;
            }
        }
        Collections.sort(this.entrys, RptComment.getComparator(key));
        this.fireContentsChanged();
    }

    private void fireContentsChanged() {
        if (this.table == null) {
            return;
        }
        this.table.removeRows();
        for (int i = 0; i < this.entrys.size(); ++i) {
            this.loadComment(this.table.addRow(), this.entrys.get(i));
        }
    }

    private void loadComment(IRow row, Object comment) {
        if (row == null || !(comment instanceof RptComment)) {
            return;
        }
        RptComment cmt = (RptComment)comment;
        ICell cell = row.getCell(0);
        if (cell != null) {
            cell.setValue((Object)cmt.getUser());
        }
        if ((cell = row.getCell(1)) != null) {
            cell.setValue((Object)cmt.getContent());
        }
        if ((cell = row.getCell(2)) != null) {
            cell.setValue((Object)cmt.getCreatetime());
        }
        if ((cell = row.getCell(3)) != null) {
            cell.setValue((Object)cmt.getUpdateUser());
        }
        if ((cell = row.getCell(4)) != null) {
            cell.setValue((Object)cmt.getDate());
        }
    }

    public RptComment getFreshEntry() {
        return this.newBird;
    }

    public int indexOf(RptComment cmt) {
        return this.entrys.indexOf(cmt);
    }

    public String getContent(int index) {
        if (index < 0 || index > this.entrys.size() - 1) {
            return null;
        }
        RptComment cmt = (RptComment)this.entrys.get(index);
        if (cmt == null) {
            return null;
        }
        return cmt.getContent();
    }

    public String getContent() {
        return super.getText();
    }

    public boolean isValid() {
        int size = this.entrys.size();
        for (int i = 0; i < size; ++i) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            if (cmt == null || !cmt.isValid()) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.fireContentsChanged();
    }

    public void setContent(int index, String content, UserInfo updateUser) {
        if (index < 0 || index > this.entrys.size() - 1) {
            return;
        }
        RptComment entry = (RptComment)this.entrys.get(index);
        if (entry != null) {
            if (!entry.getContent().equals(content)) {
                this.isModify = true;
                entry.setContent(content);
                entry.setdate(new Timestamp(System.currentTimeMillis()));
                if (updateUser != null) {
                    entry.setUpdateUser(updateUser);
                    PostilInfo postilInfo = entry.getSource();
                    if (postilInfo != null) {
                        postilInfo.setLastUpdateUser(updateUser);
                    }
                }
            }
            this.fireContentsChanged(index, entry);
        }
    }

    public void setContent(int index, String content) {
        this.setContent(index, content, null);
    }

    private void fireContentsChanged(int index, RptComment comment) {
        this.table.getRow(index).getCell(1).setValue((Object)comment.getContent());
        this.table.getRow(index).getCell(3).setValue((Object)comment.getUpdateUser());
        this.table.getRow(index).getCell(4).setValue((Object)comment.getDate());
    }

    public String toString() {
        if (this.entrys == null) {
            return null;
        }
        int size = this.entrys.size();
        if (size < 1) {
            return null;
        }
        String res = "";
        for (int i = 0; i < size; ++i) {
            RptComment cmt = (RptComment)this.entrys.get(i);
            String txt = cmt.getFullString();
            if (txt == null) continue;
            res = res + txt + '\n';
        }
        return res;
    }

    public int getSize() {
        return this.entrys.size();
    }

    public Object getElementAt(int index) {
        return this.entrys.get(index);
    }

    public Comment getCopy() {
        return (Comment)this.clone();
    }
}

