/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.ReportCaclProxy;
import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.fi.rpt.TemplateInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.api.IReportCaclProxy;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.RptSheet;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;

public class RptContextManager
extends HashMap
implements IRptContextManager {
    public static final String SELE = "%Selection%";
    public static final String USER = "%User%";
    public static final String COMP = "%Company%";
    public static final String ABBR = "%Currency%";
    public static final String STYR = "%StartYear%";
    public static final String STMH = "%StartMonth%";
    public static final String STDY = "%StartDate%";
    public static final String EDYR = "%EndYear%";
    public static final String EDMH = "%EndMonth%";
    public static final String EDDY = "%EndDate%";
    public static final String CRYR = "%CurYear%";
    public static final String CRMH = "%CurMonth%";
    public static final String CRDY = "%CurDate%";
    private transient ReportCaclProxy data;
    private transient KDTable table;
    private transient VirtualSheetParamInfo reportInfo = null;
    protected IReportPropertyAdapter propertyAdapter;

    public static RptContextManager getInstance() {
        return new RptContextManager(null);
    }

    public static RptContextManager getInstance(ReportCaclProxy rptDatabase) {
        return new RptContextManager(rptDatabase);
    }

    public RptContextManager() {
    }

    private RptContextManager(ReportCaclProxy rptDatabase) {
        super(1);
        this.data = rptDatabase;
        this.table = null;
    }

    public ReportCaclProxy setData(ReportCaclProxy rptDatabase) {
        ReportCaclProxy res = this.data;
        this.data = rptDatabase;
        return this.data;
    }

    public IReportCaclProxy getData() {
        return this.data;
    }

    public Calendar getRptDate() {
        int period;
        int year;
        RptSheetParamInfo param = this.getRptSheetParamInfo();
        if (this.reportInfo instanceof BgFormInfo) {
            BgFormInfo bgform = (BgFormInfo)this.reportInfo;
            BgPeriodInfo period2 = bgform.getBgPeriod();
            year = period2.getYear();
            int halfYear = period2.getHalfYear();
            int month = period2.getMonth();
            int quart = period2.getQuarter();
            bgform.setYear(year);
            param.setStartYear(year);
            param.setEndYear(year);
            if (bgform.getBgPeriod().getPeriodType().getValue() == 1) {
                bgform.setPeriodType(RptPeriodTypeEnum.YEARLY);
                bgform.setPeriod((short)1);
                param.setStartPeriod(1);
                param.setEndPeriod(1);
            } else if (bgform.getBgPeriod().getPeriodType().getValue() == 4) {
                bgform.setPeriodType(RptPeriodTypeEnum.MONTHLY);
                bgform.setPeriod((short)month);
                param.setStartPeriod(month);
                param.setEndPeriod(month);
            } else if (bgform.getBgPeriod().getPeriodType().getValue() == 3) {
                bgform.setPeriodType(RptPeriodTypeEnum.QUARTERLY);
                bgform.setPeriod((short)quart);
                param.setStartPeriod(quart);
                param.setEndPeriod(quart);
            } else if (bgform.getBgPeriod().getPeriodType().getValue() == 2) {
                bgform.setPeriodType(RptPeriodTypeEnum.SEMIYEARLY);
                bgform.setPeriod((short)halfYear);
                param.setStartPeriod(halfYear);
                param.setEndPeriod(halfYear);
            }
        } else if (this.reportInfo instanceof BgTemplateInfo) {
            return null;
        }
        boolean notReport = false;
        int periodType = -1;
        year = -1;
        Calendar cal = Calendar.getInstance();
        if (this.reportInfo instanceof ReportBaseInfo) {
            ReportBaseInfo report = (ReportBaseInfo)this.reportInfo;
            if (report.getPeriodType().getValue() == 1) {
                cal.setTime(report.getEndDate());
                return cal;
            }
            periodType = report.getPeriodType().getValue();
        } else {
            notReport = true;
            if (this.reportInfo instanceof TemplateInfo) {
                periodType = ((TemplateInfo)this.reportInfo).getPeriodType().getValue();
            } else {
                return null;
            }
        }
        if (param == null) {
            return null;
        }
        year = param.getEndYear();
        if (year <= 0) {
            if (notReport) {
                return null;
            }
            ReportBaseInfo report = (ReportBaseInfo)this.reportInfo;
            year = report.getYear();
        }
        if ((period = param.getEndPeriod()) <= 0) {
            if (notReport) {
                return null;
            }
            ReportBaseInfo report = (ReportBaseInfo)this.reportInfo;
            period = report.getPeriod();
        }
        cal.set(1, year);
        switch (periodType) {
            case 6: {
                cal.set(2, 0);
                break;
            }
            case 5: {
                cal.set(2, period < 1 ? 0 : 6);
                break;
            }
            case 3: {
                cal.set(2, period - 1);
                break;
            }
            case 4: {
                cal.set(2, period * 3 - 2 - 1);
                break;
            }
            case 2: {
                cal.set(3, period);
                break;
            }
            default: {
                cal.set(2, 0);
            }
        }
        cal.set(5, 1);
        return cal;
    }

    public String getInfo(String initValue, int index) {
        Object res = this.getCommonInfo(initValue, index);
        if (res == null) {
            res = this.get(initValue);
        }
        return res == null ? null : res.toString();
    }

    private Object getCommonInfo(String initValue, int index) {
        if (this.data == null) {
            return null;
        }
        String res = null;
        String patternY = "YYYY";
        String patternM = "MM";
        String patternA = "YYYY-MM-DD";
        try {
            if (CRYR.equalsIgnoreCase(initValue)) {
                res = this.data.rptDate("YYYY");
            } else if (CRMH.equalsIgnoreCase(initValue)) {
                res = this.data.rptDate("MM");
            } else if (CRDY.equalsIgnoreCase(initValue)) {
                res = this.data.rptDate("YYYY-MM-DD");
            } else if (ABBR.equalsIgnoreCase(initValue)) {
                res = this.data.getCurrency();
            } else if (SELE.equalsIgnoreCase(initValue)) {
                res = this.getTableSelection(index);
            } else if (COMP.equalsIgnoreCase(initValue)) {
                res = this.data.getCompany();
            } else if (USER.equalsIgnoreCase(initValue)) {
                res = this.data.getCurrentUser();
            } else if (STYR.equalsIgnoreCase(initValue)) {
                res = this.data.getStartDate("YYYY");
            } else if (STMH.equalsIgnoreCase(initValue)) {
                res = this.data.getStartDate("MM");
            } else if (STDY.equalsIgnoreCase(initValue)) {
                res = this.data.getStartDate("YYYY-MM-DD");
            } else if (EDYR.equalsIgnoreCase(initValue)) {
                res = this.data.getEndDate("YYYY");
            } else if (EDMH.equalsIgnoreCase(initValue)) {
                res = this.data.getEndDate("MM");
            } else if (EDDY.equalsIgnoreCase(initValue)) {
                res = this.data.getEndDate("YYYY-MM-DD");
            }
        }
        catch (Exception e) {
            res = null;
        }
        return res;
    }

    private String getTableSelection(int index) {
        if (this.table == null) {
            return null;
        }
        ArrayList sbs = this.table.getSelectManager().getBlocks();
        if (sbs.size() > 1) {
            ++index;
        }
        if (sbs == null || sbs.size() < index + 1) {
            return null;
        }
        return TableToolkit.blockToRange((KDTSelectBlock)sbs.get(index));
    }

    public void setTable(KDTable tbl) {
        this.table = tbl;
    }

    public Object getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(VirtualSheetParamInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public RptSheetParamInfo getRptSheetParamInfo() {
        return RptSheet.getRptSheet((KDTable)this.table).getParams();
    }

    public KDTable getTable() {
        return this.table;
    }

    public void setPropertyAdapter(IReportPropertyAdapter propertyAdapter) {
        this.propertyAdapter = propertyAdapter;
    }

    public IReportPropertyAdapter getPropertyAdapter() {
        return this.propertyAdapter;
    }
}

