/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt;

import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.rpt.AbstractTemplateInfo;
import com.kingdee.eas.fi.rpt.RptTmpTypeEnum;
import com.kingdee.eas.fi.rpt.TemplateReportSavePointCollection;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import java.io.IOException;
import java.io.Serializable;

public class TemplateInfo
extends AbstractTemplateInfo
implements Serializable {
    private boolean isFromTemplate = false;

    public TemplateInfo() {
    }

    protected TemplateInfo(String pkField) {
        super(pkField);
    }

    public void setCompany(CompanyOrgUnitInfo companyOrgUnitInfo) {
        super.setCompany(companyOrgUnitInfo.castToFullOrgUnitInfo());
    }

    @Override
    public byte[] getZipData() {
        return super.getData();
    }

    public void setReportSavePoint(TemplateReportSavePointCollection c) {
        this.put("reportSavePoint", (Object)c);
    }

    @Override
    public void setZipData(byte[] zipData) {
        super.setData(zipData);
    }

    @Override
    public KDF getKDF() throws IOException, KDFException {
        if (super.getData() == null) {
            return null;
        }
        return ZipKDF.unpack((byte[])super.getData());
    }

    @Override
    public Book getBook() throws Exception {
        byte[] bs = this.getData();
        if (bs == null || bs.length <= 1) {
            return null;
        }
        return IOHelper.unpackBook(bs, "rpt_trans");
    }

    @Override
    public void setBook(Book book) throws IOException {
        super.setData(IOHelper.packBook(book));
    }

    public boolean isChangeByTemplate() {
        return this.getBoolean("isChangeByTemplate");
    }

    public void setIsChangeByTemplate(boolean b) {
        this.setBoolean("isChangeByTemplate", b);
    }

    @Override
    public void setKDF(KDF kdf) throws IOException {
        super.setData(ZipKDF.pack((KDF)kdf));
    }

    @Override
    public String getLogInfo() {
        String retValue = this.getTemplateType().getAlias() + " " + this.getNumber() + " " + this.getName();
        return retValue;
    }

    public TemplateInfo getEditCopy() {
        TemplateInfo copy = new TemplateInfo();
        copy.setId(this.getId());
        copy.setCompany(this.getCompany());
        copy.setGroupCompany(this.getGroupCompany());
        copy.setNumber(this.getNumber());
        copy.setName(this.getName());
        copy.setTemplateType(this.getTemplateType());
        copy.setPeriodType(this.getPeriodType());
        copy.getSavePoint().addCollection(this.getSavePoint());
        copy.setReportSavePoint(this.getReportSavePoint());
        copy.setIsGroup(this.getIsGroup());
        copy.setCurrency(this.getCurrency());
        copy.setIsAllowSubCompanyModify(this.isIsAllowSubCompanyModify());
        return copy;
    }

    public void restoreEditCopy(TemplateInfo copy) {
        this.setCompany(copy.getCompany());
        this.setNumber(copy.getNumber());
        this.setName(copy.getName());
        this.setPeriodType(copy.getPeriodType());
        this.getSavePoint().clear();
        this.getSavePoint().addCollection(copy.getSavePoint());
        this.setReportSavePoint(copy.getReportSavePoint());
        this.setIsGroup(copy.getIsGroup());
        this.setCurrency(copy.getCurrency());
        if (RptTmpTypeEnum.COMMONREPORT == this.getTemplateType() || RptTmpTypeEnum.COMMONPUBLICTEMPLATE == this.getTemplateType()) {
            this.setTemplateType(copy.getTemplateType());
        }
        this.setIsAllowSubCompanyModify(copy.isIsAllowSubCompanyModify());
    }

    public boolean isFromTemplate() {
        return this.isFromTemplate;
    }

    public void setFromTemplate(boolean isFromTemplate) {
        this.isFromTemplate = isFromTemplate;
    }
}

