/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AcctSubQuery;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.ResourceMaping;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import java.util.ArrayList;

public class AcctCASubQuery
extends AcctSubQuery {
    private StringBuffer dynFromPart = new StringBuffer();
    private String[] itemNumbers = null;
    private StringBuffer dynGroupBy = new StringBuffer();
    private StringBuffer dynSelectField = new StringBuffer();
    private String BalTableName = null;
    private String FOrgUnitID = null;
    private String FCurrencyID = null;
    private String FPeriodID = null;
    private int FBalType = 0;
    private boolean flag = true;
    private String FCurrencyNumber = null;
    private int iStartYear = 0;
    private int iStartPeriod = 0;
    private int iEndYear = 0;
    private int iEndPeriod = 0;

    public AcctCASubQuery(QueryCommand qc) {
        super(qc);
    }

    @Override
    protected void initSolutionConfig() {
        this.resultHolderSetConfig.setResourceMaping(ResourceMaping.createDetailModeMap());
        if (this.itemNumbers != null) {
            String[] groupConditionField = new String[1 + this.itemNumbers.length];
            groupConditionField[0] = "FAccountID";
            for (int i = 0; i < this.itemNumbers.length; ++i) {
                groupConditionField[i + 1] = "FAsstNumber" + i;
            }
            this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
            String period = RptUtil.getYearPeriod(this.iStartYear, this.iStartPeriod, this.iEndYear, this.iEndPeriod);
            this.queryParamer.setStaticFromPart(this.BalTableName + " A_Bal  inner join T_BD_AssistantHG A_Hg on A_Bal.FAssistGrpID = A_HG.FID " + this.dynFromPart.toString());
            this.queryParamer.setStaticSelectField("A_Bal.FAccountID" + this.dynSelectField.toString());
            if ("GRC".equalsIgnoreCase(this.FCurrencyNumber) || "GLC".equalsIgnoreCase(this.FCurrencyNumber)) {
                this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and A_Bal.FPeriod='" + period + "'");
            } else {
                this.queryParamer.setStaticWherePart("A_Bal.FOrgUnitID='" + this.FOrgUnitID + "' and A_Bal.FCurrencyID='" + this.FCurrencyID + "' and A_Bal.FPeriod='" + period + "'");
            }
            this.queryParamer.setGroupbyPart("A_Bal.FAccountID" + this.dynGroupBy);
        }
    }

    @Override
    public void add(AcctCalculaterExt _acct) {
        if (this.flag) {
            this.flag = false;
            this.BalTableName = _acct.getBalTableName();
            this.FOrgUnitID = _acct.getCompany().getId().toString();
            this.FCurrencyID = _acct.getCurrency().getId().toString();
            this.FCurrencyNumber = _acct.getCurrency().getNumber();
            this.iStartYear = _acct.getIStartYear();
            this.iStartPeriod = _acct.getIStartPeriod();
            this.iEndYear = _acct.getIEndYear();
            this.iEndPeriod = _acct.getIEndPeriod();
            this.FBalType = _acct.getIBalType();
            ArrayList itemNubmerList = _acct.getAccountItem().getItemNumbers();
            this.itemNumbers = new String[itemNubmerList.size()];
            for (int i = 0; i < itemNubmerList.size(); ++i) {
                this.itemNumbers[i] = (String)itemNubmerList.get(i);
                AssistantItem ai = _acct.getAccountItem().getItem(this.itemNumbers[i]);
                this.dynFromPart.append("inner join " + ai.itemType.realtionDataObject + " A_AsstType" + i + "  on A_Hg." + ai.itemType.mappingFieldName + "=A_AsstType" + i + ".FID  ");
                this.dynGroupBy.append(",A_AsstType" + i + ".FNumber");
                this.dynSelectField.append(", A_AsstType" + i + ".FNumber FAsstNumber" + i);
            }
            this.defaultValue = _acct.getCurrency().get("_DPV");
        }
        _acct.setDefaultACCTValue(this.defaultValue);
        ResultHolder rh = ResultHolder.createSingleAndNoShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(_acct));
        StringBuffer key = new StringBuffer();
        key.append(_acct.getAccountItem().startAccount.account.id);
        for (int i = 0; i < this.itemNumbers.length; ++i) {
            key.append("|");
            key.append(_acct.getAccountItem().getItem((String)this.itemNumbers[i]).startItem.number);
        }
        this.resultHolderSetConfig.addResultHolder(key.toString(), rh);
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        private AcctCalculaterExt acct;

        public ResultHolderListener(AcctCalculaterExt _acct) {
            this.acct = _acct;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{this.acct.getBalanceType().getName()};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            this.acct.setACCTValue(value[0]);
            return null;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem whereItem = WhereItem.createModeOneWhereItem();
            whereItem.addItem("A_Bal.FAccountID", this.acct.getAccountItem().startAccount.account.id);
            for (int i = 0; i < AcctCASubQuery.this.itemNumbers.length; ++i) {
                whereItem.addItem("A_AsstType" + i + ".FNumber", this.acct.getAccountItem().getItem((String)((AcctCASubQuery)AcctCASubQuery.this).itemNumbers[i]).startItem.number);
            }
            return whereItem;
        }

        @Override
        public Object getHouderObject() {
            return this.acct;
        }
    }
}

