/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.Account;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

public class AcctCalculater {
    private boolean isIncludeSubAccount = false;
    private boolean isIncludeLeafAccount = false;
    private Context context;
    private AccountItem accountItem;
    private BalanceTypeEnum balanceType;
    private int iStartYear = 0;
    private int iStartPeriod = 0;
    private int iEndYear = 0;
    private int iEndPeriod = 0;
    private CurrencyInfo currency;
    private boolean isInternalCompany;
    private boolean checkDataRight;
    private boolean isSinglePeriod = false;
    private String strPeriodID = null;
    private CompanyOrgUnitInfo company = null;
    private RptCalculaterDAO calcDAO = null;
    private int iBalType = 1;
    private boolean isSyned = false;
    private boolean isDetailItem = true;
    private boolean isGroupByAccount;

    public AcctCalculater(Context ctx, AcctStruct struct) throws EASBizException, BOSException {
        this(ctx, struct.getFiOrgUnitNum(), struct.getAccountItem(), struct.getBalanceType(), struct.getStartYear(), struct.getStartPeriod(), struct.getEndYear(), struct.getEndPeriod(), struct.getCurrencyNumber(), false, struct.isIncludeVoucher(), struct.isCheckDataRight());
        this.isIncludeSubAccount = struct.getIsIncludeSubAccount();
        this.isIncludeLeafAccount = struct.getIsIncludeLeafAccount();
    }

    public void setIsIncludeSubAccount(boolean b) {
        this.isIncludeSubAccount = b;
    }

    public void setIsIncludeLeafAccount(boolean b) {
        this.isIncludeLeafAccount = b;
    }

    public AcctCalculater(Context ctx, CompanyOrgUnitInfo company, AccountItem accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, CurrencyInfo currencyInfo, boolean isInternalCompany, boolean isincludingUnPosted, boolean checkDataRight) throws EASBizException, BOSException {
        this(ctx, company, accountItem, balanceType, startYear, startPeriod, endYear, endPeriod, currencyInfo, isInternalCompany, isincludingUnPosted, checkDataRight, true);
    }

    public AcctCalculater(Context ctx, CompanyOrgUnitInfo company, AccountItem accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, CurrencyInfo currencyInfo, boolean isInternalCompany, boolean isincludingUnPosted, boolean checkDataRight, boolean isItemDetail) throws EASBizException, BOSException {
        this.context = ctx;
        this.company = company;
        this.balanceType = balanceType;
        this.revisePeroid(startYear, startPeriod, endYear, endPeriod, company);
        this.currency = currencyInfo;
        this.isInternalCompany = isInternalCompany;
        this.checkDataRight = checkDataRight;
        this.iBalType = isincludingUnPosted ? 1 : 5;
        this.accountItem = accountItem;
        this.calcDAO = new RptCalculaterDAO(ctx);
        if (company.isIsOnlyUnion() && this.calcDAO.getAccountTableCount(company.getCU().getId().toString()) > 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this.context.getLocale())});
        }
        this.isDetailItem = isItemDetail;
    }

    public AcctCalculater(Context ctx, CompanyOrgUnitInfo company, AccountItem accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, CurrencyInfo currencyInfo, boolean isInternalCompany, int _iBalType, boolean checkDataRight) {
        this(ctx, company, accountItem, balanceType, startYear, startPeriod, endYear, endPeriod, currencyInfo, isInternalCompany, _iBalType, checkDataRight, true);
    }

    public AcctCalculater(Context ctx, CompanyOrgUnitInfo company, AccountItem accountItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, CurrencyInfo currencyInfo, boolean isInternalCompany, int _iBalType, boolean checkDataRight, boolean isItemDetail) {
        this.context = ctx;
        this.company = company;
        this.balanceType = balanceType;
        this.iStartYear = startYear;
        this.iStartPeriod = startPeriod;
        this.iEndYear = endYear;
        this.iEndPeriod = endPeriod;
        this.currency = currencyInfo;
        this.isInternalCompany = isInternalCompany;
        this.iBalType = _iBalType;
        this.accountItem = accountItem;
        this.isDetailItem = isItemDetail;
    }

    public AcctCalculater(Context ctx, String fiOrgUnit, String acctItem, BalanceTypeEnum balanceType, int startYear, int startPeriod, int endYear, int endPeriod, String currencyNumber, boolean isInternalCompany, boolean isincludingUnPosted, boolean checkDataRight) throws EASBizException, BOSException {
        this.context = ctx;
        this.balanceType = balanceType;
        this.isInternalCompany = isInternalCompany;
        this.checkDataRight = checkDataRight;
        try {
            this.company = RptUtilForServer.getCompanyOrgUnitInfoByNumber(this.context, fiOrgUnit);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR, (Throwable)e);
        }
        if (this.company == null) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        this.calcDAO = new RptCalculaterDAO(ctx);
        if (this.company.isIsOnlyUnion() && this.calcDAO.getAccountTableCount(this.company.getCU().getId().toString()) > 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this.context.getLocale())});
        }
        this.currency = this.calcDAO.getCurrencyByNumber(currencyNumber);
        this.accountItem = new AccountItem(ctx, acctItem.toUpperCase(), this.company);
        if (this.accountItem.endAccount == null && this.accountItem.startAccount == null) {
            throw new ReportException(ReportException.NOT_FOUND_ACCOUNT);
        }
        this.revisePeroid(startYear, startPeriod, endYear, endPeriod, this.company);
        this.iBalType = isincludingUnPosted ? 1 : 5;
        if (!this.accountItem.isSameLevel()) {
            throw new ReportException(ReportException.ACCTEXT_FORMULA_ERROR);
        }
    }

    protected BigDecimal calculate(int type) throws BOSException, EASBizException {
        if (this.currency == null) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("NeedCurrency")});
        }
        StringBuffer filterStr = new StringBuffer();
        StringBuffer filterPeriod = new StringBuffer();
        StringBuffer strSql = new StringBuffer();
        strSql.append("SELECT ");
        StringBuffer sqlFromCluster = new StringBuffer();
        StringBuffer sqlWhereCluster = new StringBuffer();
        StringBuffer sqlGroupCluster = new StringBuffer();
        String balTableName = null;
        boolean bIsBeginOrEnd = false;
        boolean bIncludeItem = false;
        ArrayList<Object> alParams = new ArrayList<Object>();
        String balType = this.balanceType.getName();
        boolean isSingleDetailAccount = this.accountItem.isSingleAccount() && this.accountItem.startAccount.isLeaf;
        bIncludeItem = this.accountItem.hasItem();
        if (type != 0) {
            HashSet<String> leafTypeSet = new HashSet<String>();
            leafTypeSet = new HashSet();
            leafTypeSet.add("JC");
            leafTypeSet.add("DC");
            leafTypeSet.add("JY");
            leafTypeSet.add("DY");
            leafTypeSet.add("TJC");
            leafTypeSet.add("TDC");
            leafTypeSet.add("TJY");
            leafTypeSet.add("TDY");
            leafTypeSet.add("RJC");
            leafTypeSet.add("RDC");
            leafTypeSet.add("RJY");
            leafTypeSet.add("RDY");
            balTableName = leafTypeSet.contains(this.balanceType.getName()) ? this.getBalTableName(this.accountItem.hasItem() && this.isIncludeLeafAccount, this.company.isIsOnlyUnion(), balType) : this.getBalTableName(false, this.company.isIsOnlyUnion(), balType);
        } else {
            balTableName = this.getBalTableName(bIncludeItem, this.company.isIsOnlyUnion(), balType);
        }
        sqlFromCluster.append(" from " + balTableName + " A_Bal ");
        sqlWhereCluster.append(" where ");
        if (this.company.isIsOnlyUnion() || !isSingleDetailAccount) {
            sqlFromCluster.append(" inner join T_BD_AccountView A_Acct on A_Bal.FAccountID=A_Acct.FID");
        } else {
            sqlWhereCluster.append(" A_Bal.FAccountID = ? ");
            alParams.add(this.accountItem.startAccount.id);
        }
        if (this.company.isIsOnlyUnion()) {
            sqlFromCluster.append(" inner join T_ORG_Company company on A_Bal.FOrgUnitID = company.FID ");
        }
        StringBuffer[] itemFilters = null;
        StringBuffer[] itemFromCluster = null;
        ArrayList[] itemParams = null;
        if (bIncludeItem) {
            itemFilters = new StringBuffer[this.accountItem.itemSize()];
            itemFromCluster = new StringBuffer[this.accountItem.itemSize()];
            itemParams = new ArrayList[this.accountItem.itemSize()];
            sqlFromCluster.append(" inner join T_BD_AssistantHG A_Hg on A_Bal.FAssistGrpID = A_HG.FID ");
            Set set = this.accountItem.itemSet();
            int iRow = 0;
            Iterator iter = set.iterator();
            while (iter.hasNext()) {
                AssistantItem item;
                itemFilters[iRow] = new StringBuffer();
                itemFromCluster[iRow] = new StringBuffer();
                itemParams[iRow] = new ArrayList(2);
                String strItemType = (String)iter.next();
                String strTableName = this.accountItem.getItemType((String)strItemType).realtionDataObject;
                String strTableAlias = "A_AsstType" + iRow;
                String strFieldName = this.accountItem.getItemType((String)strItemType).mappingFieldName;
                String strNumber = this.accountItem.getItemType((String)strItemType).number;
                if (this.accountItem.hasItem() && !this.isDetailItem) {
                    if ("T_BD_GeneralAsstActType".equalsIgnoreCase(this.accountItem.getItemType((String)strItemType).realtionDataObject)) {
                        sqlGroupCluster.append(strTableAlias).append(".FLongNumber,");
                    } else {
                        sqlGroupCluster.append(strTableAlias).append(".Fnumber,");
                    }
                }
                if (this.isGroupByAccount()) {
                    if (this.accountItem.endAccount != null && this.accountItem.startAccount != null && this.accountItem.endAccount.number != null && this.accountItem.startAccount.number != null && !isSingleDetailAccount && sqlGroupCluster.indexOf("A_Acct.FNumber,") == -1 && this.accountItem.hasItem() && !this.isSyned) {
                        sqlGroupCluster.append("A_Acct.FNumber,");
                    }
                } else if (!(this.accountItem.endAccount == null || this.accountItem.startAccount == null || this.accountItem.endAccount.number == null || this.accountItem.startAccount.number == null || this.accountItem.endAccount.number.equalsIgnoreCase(this.accountItem.startAccount.number) || this.accountItem.hasItem() && !this.isDetailItem && RptUtil.findString(balType, ",JY,DY,JC,DC,TJY,TDY,TJC,TDC,RJY,RDY,RJC,RDC,"))) {
                    sqlGroupCluster.append("A_Acct.FNumber,");
                }
                if ((item = this.accountItem.getItem(strNumber)) == null) {
                    item = this.accountItem.getItem(strNumber.toUpperCase());
                }
                itemFromCluster[iRow].append(" inner join " + strTableName + " " + strTableAlias);
                itemFromCluster[iRow].append(" on A_Hg." + strFieldName + "=" + strTableAlias + ".FID ");
                String groupTable = this.accountItem.getItemType((String)strItemType).groupTableName;
                if (item.groups != null && item.groups.length > 0) {
                    if ("T_BD_CUSTOMER".equalsIgnoreCase(item.itemType.realtionDataObject) || "T_BD_SUPPLIER".equalsIgnoreCase(item.itemType.realtionDataObject)) {
                        int gi;
                        String group = null;
                        group = "T_BD_CUSTOMER".equalsIgnoreCase(item.itemType.realtionDataObject) ? "Customer" : "Supplier";
                        itemFilters[iRow].append(" and " + strTableAlias + ".FID in (");
                        AssistantGroup[] groups = item.groups;
                        for (gi = 0; gi < groups.length; ++gi) {
                            AssistantGroup g = groups[gi];
                            itemFilters[iRow].append("select c.FID from T_BD_" + group + " c inner join T_BD_" + group + "GroupDetail groupDtl on groupDtl.F" + group + "ID = c.fid inner join T_BD_CSSPGroup gp on groupDtl.F" + group + "GroupID = gp.fid ");
                            if (g.startGroup.longNumber == null) {
                                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("GroupNoExists") + "\"" + g.startGroup.number + "\""});
                            }
                            if (groups[gi].isSingleGroup()) {
                                itemFilters[iRow].append("where (gp.FLongNumber = ? or gp.FLongNumber like ?)");
                                itemParams[iRow].add(g.startGroup.longNumber);
                                itemParams[iRow].add(g.startGroup.longNumber + "!%");
                            } else {
                                itemFilters[iRow].append("where (gp.FLongNumber >= ? and gp.FLongNumber <= ?)");
                                itemParams[iRow].add(g.startGroup.longNumber);
                                itemParams[iRow].add(g.endGroup.longNumber + "z");
                            }
                            itemFilters[iRow].append(" AND gp.FCSSPGroupStandardID = ? ");
                            itemParams[iRow].add(g.standardID);
                            if (gi >= groups.length - 1) continue;
                            itemFilters[iRow].append(" and c.FID in(");
                        }
                        for (gi = 0; gi < groups.length; ++gi) {
                            itemFilters[iRow].append(')');
                        }
                    } else if ("T_BD_Material".equalsIgnoreCase(item.itemType.realtionDataObject)) {
                        int gi;
                        itemFilters[iRow].append(" and " + strTableAlias + ".FID in (");
                        AssistantGroup[] groups = item.groups;
                        for (gi = 0; gi < groups.length; ++gi) {
                            AssistantGroup g = groups[gi];
                            itemFilters[iRow].append("select c.FID from T_BD_Material c inner join T_BD_MaterialGroupDetial groupDtl on groupDtl.FMaterialID = c.fid inner join T_BD_MaterialGroup gp on groupDtl.FMaterialGroupID = gp.fid ");
                            if (g.startGroup.longNumber == null) {
                                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getResourceSince51("GroupNoExists") + "\"" + g.startGroup.number + "\""});
                            }
                            if (groups[gi].isSingleGroup()) {
                                itemFilters[iRow].append("where (gp.FLongNumber = ? or gp.FLongNumber like ?)");
                                itemParams[iRow].add(g.startGroup.longNumber);
                                itemParams[iRow].add(g.startGroup.longNumber + "!%");
                            } else {
                                itemFilters[iRow].append("where (gp.FLongNumber >= ? and gp.FLongNumber <= ?)");
                                itemParams[iRow].add(g.startGroup.longNumber);
                                itemParams[iRow].add(g.endGroup.longNumber + "z");
                            }
                            itemFilters[iRow].append(" AND gp.FGroupStandard = ? ");
                            itemParams[iRow].add(g.standardID);
                            if (gi >= groups.length - 1) continue;
                            itemFilters[iRow].append(" and c.FID in(");
                        }
                        for (gi = 0; gi < groups.length; ++gi) {
                            itemFilters[iRow].append(')');
                        }
                    } else {
                        String groupTableAlias = "Group" + iRow;
                        itemFromCluster[iRow].append(" inner join " + groupTable + " " + groupTableAlias).append(" on " + strTableAlias + "." + this.accountItem.getItemType((String)strItemType).groupMappingFieldName + "=" + groupTableAlias + ".FID ");
                        AssistantGroup g = item.groups[0];
                        if (g.isSingleGroup()) {
                            itemFilters[iRow].append(" and (" + groupTableAlias + ".FLongNumber = ? ");
                            itemParams[iRow].add(g.startGroup.longNumber);
                            itemFilters[iRow].append(" or " + groupTableAlias + ".FLongNumber like ?) ");
                            itemParams[iRow].add(g.startGroup.longNumber + "!%");
                        } else {
                            if (g.startGroup.longNumber.length() > 0) {
                                itemFilters[iRow].append(" and (" + groupTableAlias + ".FLongNumber >= ? ");
                                itemParams[iRow].add(g.startGroup.longNumber);
                            }
                            if (g.endGroup != null && g.endGroup.longNumber.length() > 0) {
                                itemFilters[iRow].append(" and " + groupTableAlias + ".FLongNumber <= ?) ");
                                itemParams[iRow].add(g.endGroup.longNumber + "z");
                            }
                        }
                    }
                }
                if (this.isInternalCompany) {
                    itemFilters[iRow].append(" and ").append(strTableAlias).append(".FIsinternalcompany = 1");
                }
                if (strNumber != null) {
                    strNumber = strNumber.toUpperCase();
                }
                if (item != null) {
                    if (item.itemType.useLongNumber || strTableName.equalsIgnoreCase("T_BD_GeneralAsstActType") || strTableName.equalsIgnoreCase("T_ORG_Admin") || strTableName.equalsIgnoreCase("T_BD_CashFlowItem") || strTableName.equalsIgnoreCase("T_ORG_CostCenter")) {
                        if (strTableName.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                            itemFilters[iRow].append(" and " + strTableAlias + ".FGroupID=? ");
                            itemParams[iRow].add(this.accountItem.getItemType((String)strItemType).glAsstActTypeGrpID);
                        }
                        if (item.startItem != null && item.endItem != null && !item.isEmpty()) {
                            if (item.startItem.longNumber == null) {
                                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"272_AcctCalculater", (Locale)this.context.getLocale()) + item.startItem.number + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"273_AcctCalculater", (Locale)this.context.getLocale())});
                            }
                            if (item.endItem.longNumber == null) {
                                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"274_AcctCalculater", (Locale)this.context.getLocale()) + item.endItem.number + ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"273_AcctCalculater", (Locale)this.context.getLocale())});
                            }
                            if (item.startItem.longNumber.equals(item.endItem.longNumber) && item.startItem.longNumber.length() > 0) {
                                itemFilters[iRow].append(" and (" + strTableAlias + ".FLongNumber = ? ");
                                itemParams[iRow].add(item.startItem.longNumber);
                                itemFilters[iRow].append(" or " + strTableAlias + ".FLongNumber like ?) ");
                                itemParams[iRow].add(item.startItem.longNumber + "!%");
                            } else {
                                if (item.startItem.longNumber.length() > 0) {
                                    itemFilters[iRow].append(" and (" + strTableAlias + ".FLongNumber >= ? ");
                                    itemParams[iRow].add(item.startItem.longNumber);
                                }
                                if (item.endItem.longNumber != null && item.endItem.longNumber.length() > 0) {
                                    itemFilters[iRow].append(" and " + strTableAlias + ".FLongNumber <= ?) ");
                                    itemParams[iRow].add(item.endItem.longNumber + "z");
                                }
                            }
                        }
                    } else if (item.startItem != null && item.startItem.number != null && item.startItem.number.equals(item.endItem.number) && item.startItem.number.length() > 0) {
                        itemFilters[iRow].append(" and " + strTableAlias + ".FNumber = ? ");
                        itemParams[iRow].add(item.startItem.number);
                    } else {
                        if (item.startItem != null && item.startItem.number != null && item.startItem.number.length() > 0) {
                            itemFilters[iRow].append(" and (" + strTableAlias + ".FNumber >= ? ");
                            itemParams[iRow].add(item.startItem.number);
                        }
                        if (item.endItem != null && item.endItem.number != null && item.endItem.number.length() > 0) {
                            itemFilters[iRow].append(" and " + strTableAlias + ".FNumber <= ?) ");
                            itemParams[iRow].add(item.endItem.number);
                        }
                    }
                }
                ++iRow;
            }
            if (iRow == 0) {
                throw new ReportException(ReportException.ACCTITEMTYPE_NOT_FOUND);
            }
        }
        if (!this.company.isIsOnlyUnion() && isSingleDetailAccount) {
            filterPeriod = filterPeriod.append(" and ");
        }
        filterPeriod = filterPeriod.append(" A_Bal.FPeriod in (").append(RptUtil.getYearPeriod(this.iStartYear, this.iStartPeriod, this.iEndYear, this.iEndPeriod)).append(") ");
        if (RptUtil.findString(balType, ",AC,C,AY,Y,TC,TY,RC,RY,SY,SL,TSY,TSL,RSY,RSL,QC,QY,QJL,QDL")) {
            bIsBeginOrEnd = true;
        }
        if (isSingleDetailAccount && this.company.isIsOnlyUnion()) {
            filterStr.append(" and A_Acct.FNumber = ? ");
            alParams.add(this.accountItem.startAccount.number);
        } else if (!isSingleDetailAccount) {
            if (bIsBeginOrEnd) {
                if (this.accountItem.isSingleAccount()) {
                    filterStr.append(" and (A_Acct.FNumber like ? ");
                    alParams.add(this.accountItem.startAccount.number + "%");
                } else {
                    if (this.accountItem.startAccount.number.length() > 0) {
                        filterStr.append(" and (A_Acct.FNumber>= ? ");
                        alParams.add(this.accountItem.startAccount.number);
                    }
                    if (this.accountItem.endAccount.number != null && this.accountItem.endAccount.number.length() > 0) {
                        filterStr.append(" and A_Acct.FNumber<= ? ");
                        alParams.add(this.accountItem.endAccount.number);
                    }
                }
                if (bIncludeItem) {
                    filterStr.append(" or A_Acct.FNumber like ?) ");
                    alParams.add(this.accountItem.endAccount.number + "%");
                    filterStr.append(" and A_Acct.FIsLeaf=1 ");
                } else {
                    filterStr.append(") and A_Acct.FLevel= ? ");
                    alParams.add(new Integer(this.accountItem.startAccount.level));
                }
            } else {
                filterStr.append(" and ((");
                if (this.accountItem.startAccount.number.equals(this.accountItem.endAccount.number)) {
                    filterStr.append(" A_Acct.FNumber = ? ");
                    alParams.add(this.accountItem.startAccount.number);
                } else {
                    if (this.accountItem.startAccount.number.length() > 0) {
                        filterStr.append(" A_Acct.FNumber>= ? ");
                        alParams.add(this.accountItem.startAccount.number);
                    }
                    if (this.accountItem.endAccount.number != null && this.accountItem.endAccount.number.length() > 0) {
                        filterStr.append(" and A_Acct.FNumber<= ? ");
                        alParams.add(this.accountItem.endAccount.number);
                    }
                }
                filterStr.append(")");
                if (this.accountItem.endAccount.number != null && this.accountItem.endAccount.number.length() > 0) {
                    filterStr.append(" or A_Acct.FNumber like ? ");
                    alParams.add(this.accountItem.endAccount.number + "%");
                }
                if (RptUtil.findString(balType, ",JC,DC,TJC,TDC,RJC,RDC,JY,DY,TJY,TDY,RJY,RDY,")) {
                    if (!this.accountItem.hasItem()) {
                        if (RptUtil.findString(balType, ",JC,DC,TJC,TDC,RJC,RDC,JY,DY,TJY,TDY,RJY,RDY,")) {
                            if (type == 0) {
                                filterStr.append(") and ((A_Acct.FLevel = " + this.accountItem.startAccount.level + " and A_Acct.FIsLeaf=1)or(A_Acct.FLevel = " + (this.accountItem.startAccount.level + 1) + ")) ");
                            } else if (type == 1) {
                                filterStr.append(")  and((A_Acct.FLevel = " + this.accountItem.startAccount.level + " and A_Acct.FIsLeaf=1)or(A_Acct.FLevel = " + (this.accountItem.startAccount.level + 1) + ")) ");
                            } else if (type == 2) {
                                filterStr.append(")    and (A_Acct.FIsLeaf=1) ");
                            }
                        } else {
                            filterStr.append(") and (A_Acct.FIsLeaf=1) ");
                        }
                    } else {
                        filterStr.append(") and A_Acct.FIsLeaf=1 ");
                    }
                } else {
                    filterStr.append(") and A_Acct.FIsLeaf=1 ");
                }
            }
        }
        String currencyNumber = this.currency.getNumber();
        if (!"GLC".equals(currencyNumber) && !"GRC".equals(currencyNumber)) {
            filterStr.append(" and A_Bal.FCurrencyID = ? ");
            alParams.add(this.currency.getId().toString());
        }
        if (!this.company.isIsOnlyUnion()) {
            filterStr.append(" and A_Bal.FOrgUnitID = ? ");
            alParams.add(this.company.getId().toString());
        } else {
            filterStr.append(" and company.FLongNumber like ? and company.FIsbizunit = 1 ");
            alParams.add(this.company.getLongNumber() + "!%");
        }
        if (!isSingleDetailAccount) {
            filterStr.append(" and A_Acct.faccounttableid=? ");
            alParams.add(this.company.getAccountTable().getId().toString());
        }
        if (!isSingleDetailAccount && this.company != null) {
            if (this.company.isIsOnlyUnion()) {
                filterStr.append(" and A_Acct.FCompanyID = company.FID ");
            } else {
                filterStr.append(" and A_Acct.FCompanyID=? ");
                alParams.add(this.company.getId().toString());
            }
        }
        this.getSelectItem(balType, strSql, sqlWhereCluster, bIsBeginOrEnd, isSingleDetailAccount, this.accountItem.startAccount.dc);
        if (this.accountItem.hasItem() && !this.isDetailItem && sqlGroupCluster.length() > 0) {
            sqlGroupCluster.deleteCharAt(sqlGroupCluster.length() - 1);
            strSql.append(", ").append(sqlGroupCluster);
        }
        strSql.append(sqlFromCluster);
        sqlWhereCluster.append(filterPeriod).append(filterStr);
        StringBuffer sqlLast = new StringBuffer();
        ArrayList<Object> paramsLast = new ArrayList<Object>();
        paramsLast.addAll(alParams);
        sqlLast.append(strSql);
        if (bIncludeItem) {
            int y = this.accountItem.itemSize();
            for (int x = 0; x < y; ++x) {
                sqlLast.append(itemFromCluster[x]);
                sqlWhereCluster.append(itemFilters[x]);
                paramsLast.addAll(itemParams[x]);
            }
        }
        sqlLast.append(sqlWhereCluster);
        if (this.accountItem.hasItem() && !this.isDetailItem && sqlGroupCluster.length() > 0) {
            sqlLast.append(" Group By ").append(sqlGroupCluster);
        }
        BigDecimal returnValue = null;
        try {
            returnValue = RptCalculaterDAO.executeSUMQuery(this.context, sqlLast.toString(), "Fvalue", paramsLast.toArray());
        }
        catch (Exception e) {
            throw new ReportException(ReportException.CALC_ERROR, (Throwable)e);
        }
        if (this.balanceType != null && (this.balanceType.getValue() == 35 || this.balanceType.getValue() == 36 || this.balanceType.getValue() == 38 || this.balanceType.getValue() == 40 || this.balanceType.getValue() == 37 || this.balanceType.getValue() == 39)) {
            return returnValue;
        }
        return returnValue.setScale(this.currency.getPrecision(), 4);
    }

    protected BigDecimal calculate() throws BOSException, EASBizException {
        if (!this.accountItem.hasItem() && this.isIncludeSubAccount && RptUtil.findString(this.balanceType.getName(), ",JC,DC,JY,DY,")) {
            return this.calculate(1);
        }
        if (!this.accountItem.hasItem() && this.isIncludeLeafAccount) {
            return this.calculate(2);
        }
        return this.calculate(0);
    }

    public int getPeriodType(String balType) {
        int periodType = RptUtil.findString(balType, ",C,JC,DC,AC,TC,TJC,TDC,TAC,RC,RJC,RDC,RAC,QC,") ? 2 : (RptUtil.findString(balType, ",Y,JY,DY,AY,TY,TJY,TDY,TAY,RY,RJY,RDY,RAY,OY,JL,DL,TJL,TDL,RJL,RDL,SL,TSL,RSL,") ? 3 : 1);
        return periodType;
    }

    void revisePeroid(int startYear, int startPeriod, int endYear, int endPeriod, CompanyOrgUnitInfo comp) throws EASBizException, BOSException {
        this.iStartYear = startYear;
        this.iStartPeriod = startPeriod;
        this.iEndYear = endYear;
        this.iEndPeriod = endPeriod;
    }

    private String getBalTableName(boolean bIncludeItem, boolean bIsVirtualOrg, String balType) {
        String currencyNumber = this.currency.getNumber();
        if (bIncludeItem) {
            if (this.iBalType == 5) {
                if ("GLC".equals(currencyNumber)) {
                    if (RptUtil.findString(balType, ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                        return "T_GL_AssistBalance_5R";
                    }
                    return "T_GL_AssistBalance_5L";
                }
                if ("GRC".equals(currencyNumber)) {
                    if (RptUtil.findString(balType, ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                        return "T_GL_AssistBalance_5L";
                    }
                    return "T_GL_AssistBalance_5R";
                }
                return "T_GL_AssistBalance_5F";
            }
            if ("GLC".equals(currencyNumber)) {
                if (RptUtil.findString(balType, ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AssistBalance_1R";
                }
                return "T_GL_AssistBalance_1L";
            }
            if ("GRC".equals(currencyNumber)) {
                if (RptUtil.findString(balType, ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AssistBalance_1L";
                }
                return "T_GL_AssistBalance_1R";
            }
            return "T_GL_AssistBalance_1F";
        }
        if (this.iBalType == 5) {
            if ("GLC".equals(currencyNumber)) {
                if (RptUtil.findString(balType, ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AccountBalance_5R";
                }
                return "T_GL_AccountBalance_5L";
            }
            if ("GRC".equals(currencyNumber)) {
                if (RptUtil.findString(balType, ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AccountBalance_5L";
                }
                return "T_GL_AccountBalance_5R";
            }
            return "T_GL_AccountBalance_5F";
        }
        if ("GLC".equals(currencyNumber)) {
            if (RptUtil.findString(balType, ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                return "T_GL_AccountBalance_1R";
            }
            return "T_GL_AccountBalance_1L";
        }
        if ("GRC".equals(currencyNumber)) {
            if (RptUtil.findString(balType, ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                return "T_GL_AccountBalance_1L";
            }
            return "T_GL_AccountBalance_1R";
        }
        return "T_GL_AccountBalance_1F";
    }

    private void getSelectItem(String balType, StringBuffer strSql, StringBuffer sqlWhereCluster, boolean bIsBeginOrEnd, boolean isSingleDetailAccount, int iAccountDc) throws BOSException, EASBizException {
        switch (balType.hashCode()) {
            case 67: {
                strSql.append(" SUM(A_Bal.FBeginBalanceFor*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2361: {
                if (this.accountItem.hasItem() && !this.isDetailItem) {
                    strSql.append(" (case when SUM(A_Bal.FBeginBalanceFor) >0 then SUM(A_Bal.FBeginBalanceFor) else 0 end ) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" SUM(case when (A_Bal.FBeginBalanceFor) >0 then (A_Bal.FBeginBalanceFor) else 0 end ) FValue");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(A_Bal.FBeginBalanceFor) FValue");
                    sqlWhereCluster.append(" and A_Bal.FBeginBalanceFor>= 0 ");
                    break;
                }
                strSql.append(" SUM(case when (A_Bal.FBeginBalanceFor) >0 then (A_Bal.FBeginBalanceFor) else 0 end ) FValue");
                break;
            }
            case 2175: {
                if (this.accountItem.hasItem() && !this.isDetailItem) {
                    strSql.append(" ABS((case when SUM(A_Bal.FBeginBalanceFor) <0 then SUM(A_Bal.FBeginBalanceFor) else 0 end )) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ABS(SUM(case when (A_Bal.FBeginBalanceFor) <0 then (A_Bal.FBeginBalanceFor) else 0 end )) FValue");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" ABS(SUM(A_Bal.FBeginBalanceFor)) FValue");
                    sqlWhereCluster.append(" and A_Bal.FBeginBalanceFor<= 0 ");
                    break;
                }
                strSql.append("ABS( SUM(case when (A_Bal.FBeginBalanceFor) <0 then (A_Bal.FBeginBalanceFor) else 0 end )) FValue");
                break;
            }
            case 2082: {
                strSql.append(" SUM(A_Bal.FBeginBalanceFor) FValue");
                break;
            }
            case 89: {
                strSql.append(" SUM(A_Bal.FEndBalanceFor*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2383: {
                if (this.accountItem.hasItem() && !this.isDetailItem) {
                    strSql.append(" (case when SUM(A_Bal.FEndBalanceFor) >0 then SUM(A_Bal.FEndBalanceFor) else 0 end ) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" SUM(case when (A_Bal.FEndBalanceFor) >0 then (A_Bal.FEndBalanceFor) else 0 end ) FValue");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(A_Bal.FEndBalanceFor) FValue");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceFor >= 0 ");
                    break;
                }
                strSql.append(" SUM(case when (A_Bal.FEndBalanceFor) >0 then (A_Bal.FEndBalanceFor) else 0 end ) FValue");
                break;
            }
            case 2197: {
                if (this.accountItem.hasItem() && !this.isDetailItem) {
                    strSql.append(" ABS((case when SUM(A_Bal.FEndBalanceFor) <0 then SUM(A_Bal.FEndBalanceFor) else 0 end )) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ABS(SUM(case when (A_Bal.FEndBalanceFor) <0 then (A_Bal.FEndBalanceFor) else 0 end )) FValue");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" ABS(SUM(A_Bal.FEndBalanceFor)) FValue");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceFor<= 0 ");
                    break;
                }
                strSql.append("ABS( SUM(case when (A_Bal.FEndBalanceFor) <0 then (A_Bal.FEndBalanceFor) else 0 end )) FValue");
                break;
            }
            case 2104: {
                strSql.append(" SUM(A_Bal.FEndBalanceFor) FValue ");
                break;
            }
            case 2364: {
                strSql.append(" SUM(A_Bal.FDebitFor) FValue");
                break;
            }
            case 2178: {
                strSql.append(" SUM(A_Bal.FCreditFor) FValue ");
                break;
            }
            case 2370: {
                strSql.append(" SUM(A_Bal.FYearDebitFor) FValue ");
                break;
            }
            case 2184: {
                strSql.append(" SUM(A_Bal.FYearCreditFor) FValue ");
                break;
            }
            case 2662: {
                strSql.append(" SUM(A_Bal.FMonthPnLFor*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2649: {
                strSql.append(" SUM(A_Bal.FYearPnLFor*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2671: {
                strSql.append(" SUM(A_Bal.FBeginBalanceLocal*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 83085: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" SUM(case when (A_Bal.FBeginBalanceLocal) >0 then (A_Bal.FBeginBalanceLocal) else 0 end ) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FBeginBalanceLocal)>0 then  SUM(A_Bal.FBeginBalanceLocal) else 0 end) FValue ");
                    break;
                }
                strSql.append(" SUM(A_Bal.FBeginBalanceLocal) FValue ");
                sqlWhereCluster.append(" and A_Bal.FBeginBalanceLocal >= 0 ");
                break;
            }
            case 82899: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ABS(SUM(case when (A_Bal.FBeginBalanceLocal) <0 then (A_Bal.FBeginBalanceLocal) else 0 end )) FValue ");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FBeginBalanceFor)<0 then  abs(SUM(A_Bal.FBeginBalanceFor)) else 0 end) FValue ");
                    break;
                }
                strSql.append(" SUM(ABS(A_Bal.FBeginBalanceLocal)) FValue");
                sqlWhereCluster.append(" and A_Bal.FBeginBalanceLocal <= 0 ");
                break;
            }
            case 82806: {
                strSql.append(" SUM(A_Bal.FBeginBalanceLocal) FValue");
                break;
            }
            case 2693: {
                strSql.append(" SUM(A_Bal.FEndBalanceLocal*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 83107: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" SUM(case when (A_Bal.FEndBalanceLocal) >0 then (A_Bal.FEndBalanceLocal) else 0 end ) FValue");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(A_Bal.FEndBalanceLocal) FValue");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceLocal >= 0 ");
                    break;
                }
                strSql.append(" SUM(case when (A_Bal.FEndBalanceLocal) >0 then (A_Bal.FEndBalanceLocal) else 0 end ) FValue");
                break;
            }
            case 82921: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ABS(SUM(case when (A_Bal.FEndBalanceLocal) <0 then (A_Bal.FEndBalanceLocal) else 0 end )) FValue ");
                    break;
                }
                if (isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(ABS(A_Bal.FEndBalanceLocal)) FValue ");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceLocal <= 0 ");
                    break;
                }
                strSql.append(" ABS(SUM(case when (A_Bal.FEndBalanceLocal) <0 then (A_Bal.FEndBalanceLocal) else 0 end )) FValue ");
                break;
            }
            case 82828: {
                strSql.append(" SUM(A_Bal.FEndBalanceLocal) FValue");
                break;
            }
            case 83088: {
                strSql.append(" SUM(A_Bal.FDebitLocal) FValue");
                break;
            }
            case 82902: {
                strSql.append(" SUM(A_Bal.FCreditLocal) FValue");
                break;
            }
            case 83094: {
                strSql.append(" SUM(A_Bal.FYearDebitLocal) FValue");
                break;
            }
            case 82908: {
                strSql.append(" SUM(A_Bal.FYearCreditLocal) FValue");
                break;
            }
            case 83386: {
                strSql.append(" SUM(A_Bal.FMonthPnLLocal*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 83373: {
                strSql.append(" SUM(A_Bal.FYearPnLLocal*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2609: {
                strSql.append(" SUM(A_Bal.FBeginBalanceRpt*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 81163: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" SUM(case when (A_Bal.FBeginBalanceRpt) >0 then (A_Bal.FBeginBalanceRpt) else 0 end ) FValue");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FBeginBalanceRpt)>0 then  SUM(A_Bal.FBeginBalanceRpt) else 0 end) FValue ");
                    break;
                }
                strSql.append(" SUM(A_Bal.FBeginBalanceRpt) FValue ");
                sqlWhereCluster.append(" and A_Bal.FBeginBalanceRpt >= 0 ");
                break;
            }
            case 80977: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ABS(SUM(case when (A_Bal.FBeginBalanceRpt) <0 then (A_Bal.FBeginBalanceRpt) else 0 end )) FValue ");
                    break;
                }
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FBeginBalanceRpt)<0 then  abs(SUM(A_Bal.FBeginBalanceRpt)) else 0 end) FValue ");
                    break;
                }
                strSql.append(" SUM(ABS(A_Bal.FBeginBalanceRpt)) FValue");
                sqlWhereCluster.append(" and A_Bal.FBeginBalanceRpt <= 0 ");
                break;
            }
            case 80884: {
                strSql.append(" SUM(A_Bal.FBeginBalanceRpt) FValue");
                break;
            }
            case 2631: {
                strSql.append(" SUM(A_Bal.FEndBalanceRpt*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 81185: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FEndBalanceRpt)>0 then  SUM(A_Bal.FEndBalanceRpt) else 0 end) FValue ");
                    break;
                }
                if (this.accountItem.isSingleAccount() || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(A_Bal.FEndBalanceRpt) FValue");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceRpt >= 0 ");
                    break;
                }
                strSql.append(" (case when SUM(A_Bal.FEndBalanceRpt) >0 then SUM(A_Bal.FEndBalanceRpt) else 0 end ) FValue");
                break;
            }
            case 80999: {
                if ((isSingleDetailAccount || this.accountItem.isDetailAccount() || bIsBeginOrEnd) && this.accountItem.hasItem()) {
                    strSql.append(" ( case when SUM(A_Bal.FEndBalanceRpt)<0 then  abs(SUM(A_Bal.FEndBalanceRpt)) else 0 end) FValue ");
                    break;
                }
                if (this.accountItem.isSingleAccount() || this.accountItem.isDetailAccount() || bIsBeginOrEnd) {
                    strSql.append(" SUM(ABS(A_Bal.FEndBalanceRpt)) FValue ");
                    sqlWhereCluster.append(" and A_Bal.FEndBalanceRpt <= 0 ");
                    break;
                }
                strSql.append(" ABS((case when SUM(A_Bal.FEndBalanceRpt) <0 then SUM(A_Bal.FEndBalanceRpt) else 0 end )) FValue ");
                break;
            }
            case 80906: {
                strSql.append(" SUM(A_Bal.FEndBalanceRpt) FValue");
                break;
            }
            case 81166: {
                strSql.append(" SUM(A_Bal.FDebitRpt) FValue");
                break;
            }
            case 80980: {
                strSql.append(" SUM(A_Bal.FCreditRpt) FValue");
                break;
            }
            case 81172: {
                strSql.append(" SUM(A_Bal.FYearDebitRpt) FValue");
                break;
            }
            case 80986: {
                strSql.append(" SUM(A_Bal.FYearCreditRpt) FValue");
                break;
            }
            case 81464: {
                strSql.append(" SUM(A_Bal.FMonthPnLRpt*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 81451: {
                strSql.append(" SUM(A_Bal.FYearPnLRpt*");
                if (isSingleDetailAccount) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 80205: {
                String fdc = isSingleDetailAccount ? String.valueOf(iAccountDc) : "A_Acct.FDc";
                strSql.append(" SUM(A_Bal.FDebitQty*((" + fdc + "+1)/2) + A_Bal.FCreditQty*((" + fdc + "-1)/-2)) FValue");
                break;
            }
            case 80019: {
                String fdc = isSingleDetailAccount ? String.valueOf(iAccountDc) : "A_Acct.FDc";
                strSql.append(" SUM(A_Bal.FDebitQty*((" + fdc + "-1)/-2) + A_Bal.FCreditQty*((" + fdc + "+1)/2)) FValue");
                break;
            }
            case 80211: {
                String fdc = isSingleDetailAccount ? String.valueOf(iAccountDc) : "A_Acct.FDc";
                strSql.append(" SUM(A_Bal.FYearDebitQty*((" + fdc + "+1)/2) + A_Bal.FYearCreditQty*((" + fdc + "-1)/-2)) FValue");
                break;
            }
            case 80025: {
                String fdc = isSingleDetailAccount ? String.valueOf(iAccountDc) : "A_Acct.FDc";
                strSql.append(" SUM(A_Bal.FYearDebitQty*((" + fdc + "-1)/-2) + A_Bal.FYearCreditQty*((" + fdc + "+1)/2)) FValue");
                break;
            }
            case 2578: {
                strSql.append(" SUM(A_Bal.FBeginQty*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            case 2600: {
                strSql.append(" SUM(A_Bal.FEndQty*");
                if (isSingleDetailAccount || this.accountItem.hasItem() && this.accountItem.isSingleAccount()) {
                    strSql.append(iAccountDc);
                } else {
                    strSql.append("A_Acct.FDc");
                }
                strSql.append(") FValue");
                break;
            }
            default: {
                throw new ReportException(ReportException.EXECP_ACCTEXT_VOUTYPE_INVALID);
            }
        }
    }

    public AccountItem getAccountItem() {
        return this.accountItem;
    }

    public void setAccountItem(AccountItem accountItem) {
        this.accountItem = accountItem;
    }

    public BalanceTypeEnum getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceTypeEnum balanceType) {
        this.balanceType = balanceType;
    }

    public RptCalculaterDAO getCalcDAO() {
        return this.calcDAO;
    }

    public void setCalcDAO(RptCalculaterDAO calcDAO) {
        this.calcDAO = calcDAO;
    }

    public boolean isCheckDataRight() {
        return this.checkDataRight;
    }

    public void setCheckDataRight(boolean checkDataRight) {
        this.checkDataRight = checkDataRight;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public StringBuffer buildFromCluster() {
        StringBuffer fromCluster = new StringBuffer();
        fromCluster.append(" from " + this.getBalTableName(this.accountItem.hasItem() && this.isIncludeLeafAccount, this.company.isIsOnlyUnion(), this.balanceType.getName()) + " A_Bal ").append(" inner join T_BD_AccountView A_Acct on A_Bal.FAccountID = A_Acct.FID ").append(" inner join T_Bd_Period A_Pd on A_Bal.FPeriodID = A_Pd.FID ");
        if (this.accountItem.hasItem()) {
            fromCluster.append(" inner join T_BD_AssistantHG A_Hg on A_Bal.FAssistGrpID = A_HG.FID ");
            Set set = this.accountItem.itemSet();
            int i = 0;
            for (String strItemType : set) {
                fromCluster.append(" inner join ").append(this.accountItem.getItemType((String)strItemType).realtionDataObject).append(" A_AsstType" + i).append(" on A_Hg.").append(this.accountItem.getItemType((String)strItemType).mappingFieldName).append(" = A_AsstType" + i + ".FID ");
                ++i;
            }
        }
        return fromCluster;
    }

    public StringBuffer buildWhereCluster() {
        StringBuffer whereCluster = new StringBuffer();
        ArrayList<Integer> paramList = new ArrayList<Integer>();
        whereCluster.append(" where A_Bal.FBalType= ? ");
        paramList.add(new Integer(this.iBalType));
        switch (this.getPeriodType(this.balanceType.getName())) {
            case 1: {
                if (this.iStartYear == this.iEndYear) {
                    whereCluster.append(" and (A_Pd.FPeriodYear= ? ");
                    paramList.add(new Integer(this.iStartYear));
                    if (this.iStartPeriod == this.iEndPeriod) {
                        whereCluster.append(" and A_Pd.FPeriodNumber=?)");
                        paramList.add(new Integer(this.iStartPeriod));
                        break;
                    }
                    whereCluster.append(" and A_Pd.FPeriodNumber>=? and A_Pd.FPeriodNumber<= ?)");
                    paramList.add(new Integer(this.iStartPeriod));
                    paramList.add(new Integer(this.iEndPeriod));
                    break;
                }
                whereCluster.append(" and ((A_Pd.FPeriodYear=? and A_Pd.FPeriodNumber>= ?) or (A_Pd.FPeriodYear =  ? and A_Pd.FPeriodNumber < ?\t)or(A_Pd.FPeriodYear < ? and A_Pd.FPeriodYear >= ?)) ");
                paramList.add(new Integer(this.iStartYear));
                paramList.add(new Integer(this.iStartPeriod));
                paramList.add(new Integer(this.iEndYear));
                paramList.add(new Integer(this.iEndPeriod));
                paramList.add(new Integer(this.iEndYear));
                paramList.add(new Integer(this.iStartYear));
                break;
            }
            case 2: {
                whereCluster.append(" and A_Pd.FPeriodYear = ? and A_Pd.FPeriodNumber = ? ");
                paramList.add(new Integer(this.iStartYear));
                paramList.add(new Integer(this.iStartPeriod));
                break;
            }
            case 3: {
                whereCluster.append(" and A_Pd.FPeriodYear = ? and A_Pd.FPeriodNumber = ? ");
                paramList.add(new Integer(this.iEndYear));
                paramList.add(new Integer(this.iEndPeriod));
            }
        }
        return null;
    }

    public boolean isSyned() {
        return this.isSyned;
    }

    public void setSyned(boolean isSyned) {
        this.isSyned = isSyned;
    }

    public static boolean isGroupByAccount(Context context, String key) throws BOSException {
        String sql = "select FValue From T_CSL_CSLParam where FKey = ? ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)sql, (Object[])new Object[]{key});
            if (rowSet.next()) {
                String stringSize = rowSet.getString("FValue");
                return RptUtil.isTrue(stringSize);
            }
            return false;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public boolean isGroupByAccount() {
        return this.isGroupByAccount;
    }

    public void setGroupByAccount(boolean isGroupByAccount) {
        this.isGroupByAccount = isGroupByAccount;
    }

    public boolean isSinglePeriod() {
        return this.isSinglePeriod;
    }

    public void setSinglePeriod(boolean isSinglePeriod) {
        this.isSinglePeriod = isSinglePeriod;
    }

    public String getStrPeriodID() {
        return this.strPeriodID;
    }

    public void setStrPeriodID(String strPeriodID) {
        this.strPeriodID = strPeriodID;
    }

    public static void getRangeAccount(Context context, CompanyOrgUnitInfo company, AccountItemExt accountItem) throws BOSException {
        StringBuffer kqlBuffer = new StringBuffer();
        kqlBuffer.append(" Select FID, FDc, FIsLeaf, FLevel, FNumber, FControlunitID From T_Bd_AccountView                         \n").append(" Where FCompanyID = ? and FAccountTableID = ? and FNumber >= ? and FNumber <= ? and FLevel = ? order by FNumber   \n");
        IRowSet rowSet = DbUtil.executeQuery((Context)context, (String)kqlBuffer.toString(), (Object[])new Object[]{company.getId().toString(), company.getAccountTable().getId().toString(), accountItem.startAccount.getAccountNumber(), accountItem.endAccount.getAccountNumber(), new Integer(accountItem.startAccount.account.level)});
        ArrayList<Account> accountList = new ArrayList<Account>();
        try {
            while (rowSet.next()) {
                Account account = new Account();
                account.id = rowSet.getString("FID");
                account.dc = rowSet.getInt("FDc");
                account.isLeaf = rowSet.getInt("FIsLeaf") == 1;
                account.level = rowSet.getInt("FLevel");
                account.number = rowSet.getString("FNumber");
                accountList.add(account);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (accountList.size() > 1) {
            accountItem.startAccount.account = (Account)accountList.get(0);
            accountItem.endAccount.account = (Account)accountList.get(accountList.size() - 1);
        } else if (accountList.size() == 1) {
            accountItem.startAccount.account = (Account)accountList.get(0);
            accountItem.endAccount.account = (Account)accountList.get(0);
        }
    }
}

