/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountException;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.rpt.AcctStruct;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AccountItemExt;
import com.kingdee.eas.fi.rpt.app.AcctBatchQueryServiceNew;
import com.kingdee.eas.fi.rpt.app.AcctCalculater;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.IContainCompany;
import com.kingdee.eas.fi.rpt.batch.IFormulaCalculator;
import com.kingdee.eas.fi.rpt.batch.IParamBackFill;
import com.kingdee.eas.fi.rpt.batch.acct.AcctUtils;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class AcctCalculaterExt
implements IFormulaCalculator,
IContainCompany {
    private Context serverCtx;
    private CurrencyInfo currency = null;
    private CompanyOrgUnitInfo company = null;
    private boolean isIncludeSubAccount = false;
    private boolean isIncludeLeafAccount = false;
    private boolean isIncludeSubAsstItem = false;
    private boolean isIncludeLeafAsstItem = false;
    private boolean IncludeDetailAccountAsstItem = false;
    private AccountItemExt accountItem;
    private BalanceTypeEnum balanceType;
    private int iStartYear = 0;
    private int iStartPeriod = 0;
    private int iEndYear = 0;
    private int iEndPeriod = 0;
    private boolean isInternalCompany;
    private boolean isincludingUnPosted;
    private boolean checkDataRight;
    private boolean isSinglePeriod = false;
    private String strPeriodID = null;
    private int nextCurrentPeriodYear;
    private int nextCurrentPeriodNumber;
    private int iBalType = 1;
    private static final Logger log = Logger.getLogger((String)AcctCalculaterExt.class.getName());
    private AcctBatchQueryServiceNew acctBatchQueryService;
    private IBackfillHandler param;
    private AcctStruct struct;
    private boolean isGroupByAccount;
    private boolean accountHasWildcar = false;
    private boolean itemHasWildcar = false;
    private PeriodInfo currentPeriod;
    private AccountTableInfo accountTable;
    private boolean isCorrectAccountTable;
    private OrgType orgType = OrgType.Company;
    private boolean isProfitCenter = false;
    private String periodKey = "";

    public void setContext(Context _serverCtx) {
        this.serverCtx = _serverCtx;
    }

    public Context getContext() {
        return this.serverCtx;
    }

    public AcctCalculaterExt(AcctStruct _struct, IBackfillHandler _param) {
        this.struct = _struct;
        this.param = _param;
        try {
            this.accountItem = new AccountItemExt(this.struct.getAccountItem());
        }
        catch (ReportException rptEx) {
            this.param.setException((Throwable)rptEx);
        }
        catch (ParseException parseEx) {
            this.param.setException((Throwable)new ReportException(ReportException.ACCOUNT_PARSE_ERROR));
        }
        this.balanceType = this.struct.getBalanceType();
        this.isInternalCompany = false;
        this.isincludingUnPosted = this.struct.isIncludeVoucher();
        this.checkDataRight = this.struct.isCheckDataRight();
        this.isIncludeSubAccount = _struct.getIsIncludeSubAccount();
        this.isIncludeLeafAccount = _struct.getIsIncludeLeafAccount();
        this.isIncludeLeafAsstItem = _struct.isIncludeLeafAsstItem();
        this.isIncludeSubAsstItem = _struct.isIncludeSubAsstItem();
        this.IncludeDetailAccountAsstItem = _struct.isIncludeDetailAccountAsstItem();
        this.iBalType = this.isincludingUnPosted ? 1 : 5;
        this.orgType = _struct.getOrgType();
        this.isProfitCenter = _struct.isProfitCenter();
    }

    public boolean getIsInternalCompany() {
        return this.isInternalCompany;
    }

    public boolean getCheckDataRight() {
        return this.checkDataRight;
    }

    public boolean check() {
        try {
            this.checkBaseInfo();
            for (AssistantItem itm : this.accountItem.itemValues()) {
                if (!StringUtils.isEmpty((String)itm.itemType.realtionDataObject)) continue;
                this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantTypeNoExists", (Locale)this.serverCtx.getOriginLocale()) + "\"" + itm.itemType.number + "\""}));
                return false;
            }
            this.revisePeroid(this.struct.getStartYear(), this.struct.getStartPeriod(), this.struct.getEndYear(), this.struct.getEndPeriod());
            if (this.iStartYear == this.iEndYear && this.iStartPeriod == this.iEndPeriod) {
                this.isSinglePeriod = true;
                this.submitRequirestrPeriodIDBatchQueryService();
            }
            if (!this.accountItem.isSameLevel()) {
                this.param.setException((Throwable)new ReportException(ReportException.ACCTEXT_FORMULA_ERROR));
                return false;
            }
        }
        catch (Exception e) {
            this.param.setException((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean checkBaseInfo() throws BOSException {
        if (!(this.param instanceof IParamBackFill)) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{"System error,please implement com.kingdee.eas.fi.rpt.batch.framework.IParamBackFill "}));
            return false;
        }
        if (this.company == null) {
            this.param.setException((Throwable)new ReportException(ReportException.FIND_COMPANY_ERROR));
            return false;
        }
        if (this.currency == null) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_calc_nocurrency", (Locale)this.serverCtx.getOriginLocale())}));
            return false;
        }
        if (this.company.getAccountTable() == null) {
            this.param.setException((Throwable)new AccountException(AccountException.CURRENTCOMPANYHASNOSTARTACCOUNTTABLE));
            return false;
        }
        if (this.company.isIsOnlyUnion() && this.company.get("_TableCount") != null && Integer.parseInt(this.company.get("_TableCount").toString()) > 1) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this.serverCtx.getOriginLocale())}));
            return false;
        }
        if (this.accountItem == null) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"ParameterNoIntegrated", (Locale)this.serverCtx.getOriginLocale())}));
            return false;
        }
        if (this.accountItem.endAccount == null || this.accountItem.startAccount == null) {
            this.param.setException((Throwable)new ReportException(ReportException.NOT_FOUND_ACCOUNT));
            return false;
        }
        if (this.accountItem.startAccount.account == null) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AccountNumberNoExists", (Locale)this.serverCtx.getOriginLocale()) + "\"" + this.accountItem.startAccount.getAccountNumber() + "\""}));
            return false;
        }
        if (!this.accountItem.isSingleAccount() && this.accountItem.endAccount.account == null) {
            AcctCalculater.getRangeAccount(this.serverCtx, this.company, this.accountItem);
        }
        if (this.accountItem.endAccount.account == null) {
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AccountNumberNoExists", (Locale)this.serverCtx.getOriginLocale()) + "\"" + this.accountItem.endAccount.getAccountNumber() + "\""}));
            return false;
        }
        return true;
    }

    private void submitRequirestrPeriodIDBatchQueryService() {
        this.acctBatchQueryService.submitRequireBatchFitchPeriodIDService(this);
    }

    public void submitRequireCompanyInfoBatchQueryService() {
        this.acctBatchQueryService.submitRequireBatchFitchCompanyInfoService(this.struct.getFiOrgUnitNum(), this);
    }

    public void submitRequireCurrencyInfoBatchQueryService() {
        this.acctBatchQueryService.submitRequireBatchFitchCurrencyInfoService(this.struct.getCurrencyNumber(), this);
    }

    public void submitRequireAccountAndItemInfoBatchQueryService() throws Exception {
        this.acctBatchQueryService.submitRequireBatchFitchAccountInfoService(this.accountItem.startAccount);
        this.acctBatchQueryService.submitRequireBatchFitchAccountInfoService(this.accountItem.endAccount);
    }

    public void submitRequireAssistantItem() throws Exception {
        this.acctBatchQueryService.submitAssistantItemQuery(this);
    }

    public void submitRequireStandard() throws Exception {
        this.acctBatchQueryService.submitAssistantStandardQuery(this);
    }

    public int getPeriodType(String balType) {
        int periodType = RptUtil.findString(balType, ",C,JC,DC,AC,TC,TJC,TDC,TAC,RC,RJC,RDC,RAC,QC,") ? 2 : (RptUtil.findString(balType, ",Y,JY,DY,AY,TY,TJY,TDY,TAY,RY,RJY,RDY,RAY,OY") ? 3 : 1);
        return periodType;
    }

    private String getBalTableName(boolean bIncludeItem, boolean bIsVirtualOrg) {
        if (bIncludeItem && bIsVirtualOrg) {
            return "V_RPT_VIRTUALASSISTBALANCE";
        }
        if (bIncludeItem) {
            return this.getAssistBalanceTableName();
        }
        if (bIsVirtualOrg) {
            return "v_gl_VirtualBalance";
        }
        return this.getAccountBalanceTableName();
    }

    private String getAssistBalanceTableName() {
        if (this.iBalType == 5) {
            if ("GLC".equals(this.currency.getNumber())) {
                if (RptUtil.findString(this.balanceType.getName(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AssistBalance_5R";
                }
                return "T_GL_AssistBalance_5L";
            }
            if ("GRC".equals(this.currency.getNumber())) {
                if (RptUtil.findString(this.balanceType.getName(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AssistBalance_5L";
                }
                return "T_GL_AssistBalance_5R";
            }
            return "T_GL_AssistBalance_5F";
        }
        if ("GLC".equals(this.currency.getNumber())) {
            if (RptUtil.findString(this.balanceType.getName(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                return "T_GL_AssistBalance_1R";
            }
            return "T_GL_AssistBalance_1L";
        }
        if ("GRC".equals(this.currency.getNumber())) {
            if (RptUtil.findString(this.balanceType.getName(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                return "T_GL_AssistBalance_1L";
            }
            return "T_GL_AssistBalance_1R";
        }
        return "T_GL_AssistBalance_1F";
    }

    private String getAccountBalanceTableName() {
        if (this.iBalType == 5) {
            if ("GLC".equals(this.currency.getNumber())) {
                if (RptUtil.findString(this.balanceType.getName(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                    return "T_GL_AccountBalance_5R";
                }
                return "T_GL_AccountBalance_5L";
            }
            if ("GRC".equals(this.currency.getNumber())) {
                if (RptUtil.findString(this.balanceType.getName(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                    return "T_GL_AccountBalance_5L";
                }
                return "T_GL_AccountBalance_5R";
            }
            return "T_GL_AccountBalance_5F";
        }
        if ("GLC".equals(this.currency.getNumber())) {
            if (RptUtil.findString(this.balanceType.getName(), ",RB,RC,RJC,RDC,RAC,RY,RJY,RDY,RAY,RJF,RDF,RJL,RDL,RSY,RSL,")) {
                return "T_GL_AccountBalance_1R";
            }
            return "T_GL_AccountBalance_1L";
        }
        if ("GRC".equals(this.currency.getNumber())) {
            if (RptUtil.findString(this.balanceType.getName(), ",TB,TC,TJC,TDC,TAC,TY,TJY,TDY,TAY,TJF,TDF,TJL,TDL,TSY,TSL,")) {
                return "T_GL_AccountBalance_1L";
            }
            return "T_GL_AccountBalance_1R";
        }
        return "T_GL_AccountBalance_1F";
    }

    public String getBalTableName() {
        return this.getBalTableName(this.accountItem.hasItem(), this.company.isIsOnlyUnion());
    }

    public String getBalTableNameWithAsst() {
        return this.getBalTableName(true, this.company.isIsOnlyUnion());
    }

    public String getBalTableNameWithNoAsst() {
        return this.getBalTableName(false, this.company.isIsOnlyUnion());
    }

    public AccountItemExt getAccountItem() {
        return this.accountItem;
    }

    public void setAccountItem(AccountItemExt accountItem) {
        this.accountItem = accountItem;
    }

    public BalanceTypeEnum getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceTypeEnum balanceType) {
        this.balanceType = balanceType;
    }

    public boolean isCheckDataRight() {
        return this.checkDataRight;
    }

    public void setCheckDataRight(boolean checkDataRight) {
        this.checkDataRight = checkDataRight;
    }

    @Override
    public void setCompany(CompanyOrgUnitInfo _company) {
        this.company = _company;
        if (this.accountItem != null) {
            this.accountItem.setCompany(this.company);
        }
    }

    @Override
    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCurrency(CurrencyInfo _currency) {
        this.currency = _currency;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public PeriodInfo getCurrentPeriod() {
        return this.currentPeriod;
    }

    public void setCurrentPeriod(PeriodInfo currentPeriod) {
        this.currentPeriod = currentPeriod;
    }

    public boolean isIsincludingUnPosted() {
        return this.isincludingUnPosted;
    }

    public void setIsincludingUnPosted(boolean isincludingUnPosted) {
        this.isincludingUnPosted = isincludingUnPosted;
    }

    void revisePeroid(int startYear, int startPeriod, int endYear, int endPeriod) throws Exception {
        this.iStartYear = startYear;
        this.iStartPeriod = startPeriod;
        this.iEndYear = endYear;
        this.iEndPeriod = endPeriod;
        int periodType = AcctUtils.getPeriodType(this.balanceType.getName());
        switch (periodType) {
            case 2: {
                this.iEndYear = this.iStartYear;
                this.iEndPeriod = this.iStartPeriod;
                break;
            }
            case 3: {
                this.iStartYear = this.iEndYear;
                this.iStartPeriod = this.iEndPeriod;
            }
        }
    }

    public int getIEndYear() {
        return this.iEndYear;
    }

    public int getIEndPeriod() {
        return this.iEndPeriod;
    }

    public int getIStartYear() {
        return this.iStartYear;
    }

    public int getIStartPeriod() {
        return this.iStartPeriod;
    }

    public void setiStartYear(int iStartYear) {
        this.iStartYear = iStartYear;
    }

    public void setiStartPeriod(int iStartPeriod) {
        this.iStartPeriod = iStartPeriod;
    }

    public void setStrPeriodID(String str) {
        this.strPeriodID = str;
    }

    public String getStrPeriodID() {
        return this.strPeriodID;
    }

    public boolean getIsSinglePeriod() {
        return this.isSinglePeriod;
    }

    public int getIBalType() {
        return this.iBalType;
    }

    public void setDefaultACCTValue(Object obj) {
        this.param.setValue(obj);
    }

    public void setACCTValue(Object obj) {
        if (obj instanceof BigDecimal) {
            BigDecimal dcm = (BigDecimal)obj;
            if (this.balanceType != null && (this.balanceType.getValue() == 35 || this.balanceType.getValue() == 36 || this.balanceType.getValue() == 38 || this.balanceType.getValue() == 40 || this.balanceType.getValue() == 37 || this.balanceType.getValue() == 39)) {
                this.param.setValue((Object)dcm);
            } else {
                this.param.setValue((Object)dcm.setScale(this.currency.getPrecision(), 4));
            }
        } else if (obj instanceof Throwable) {
            this.param.setException((Throwable)obj);
        } else {
            this.param.setValue(obj);
        }
    }

    public IBackfillHandler getBackfillHandler() {
        return this.param;
    }

    public boolean getIsIncludeSubAccount() {
        return this.isIncludeSubAccount;
    }

    public void setIsIncludeSubAccount(boolean isIncludeSubAccount) {
        this.isIncludeSubAccount = isIncludeSubAccount;
    }

    public boolean getIsIncludeLeafAccount() {
        return this.isIncludeLeafAccount;
    }

    public void setIsIncludeLeafAccount(boolean isIncludeLeafAccount) {
        this.isIncludeLeafAccount = isIncludeLeafAccount;
    }

    public void calculate(Context ctx) {
        AcctCalculater acctOrg = new AcctCalculater(ctx, this.company, this.accountItem.toAccountItem(), this.balanceType, this.iStartYear, this.iStartPeriod, this.iEndYear, this.iEndPeriod, this.currency, this.isInternalCompany, this.iBalType, this.checkDataRight, this.accountItem.isDetailItem());
        acctOrg.setIsIncludeSubAccount(this.isIncludeSubAccount);
        acctOrg.setIsIncludeLeafAccount(this.isIncludeLeafAccount);
        acctOrg.setSyned(this.accountItem.isSyned());
        acctOrg.setGroupByAccount(this.isGroupByAccount());
        acctOrg.setSinglePeriod(this.iStartYear == this.iEndYear && this.iStartPeriod == this.iEndPeriod);
        acctOrg.setStrPeriodID(this.getStrPeriodID());
        try {
            if (this.accountItem.hasItem()) {
                for (AssistantItemExt ai : this.accountItem.itemValues()) {
                    if (ai.itemType == null) {
                        this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExistsItem", (Locale)this.serverCtx.getOriginLocale()) + "\"" + ai.getItemTypeNumber() + "\""}));
                        return;
                    }
                    try {
                        ai.check();
                    }
                    catch (ReportException e) {
                        this.param.setException((Throwable)e);
                        return;
                    }
                }
            }
            this.param.setValue((Object)acctOrg.calculate());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
        }
    }

    public boolean checkItem() {
        for (AssistantItemExt ai : this.accountItem.itemValues()) {
            if (ai.itemType != null) continue;
            this.param.setException((Throwable)new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"NoExistsItem", (Locale)this.serverCtx.getOriginLocale()) + "\"" + ai.getItemTypeNumber() + "\""}));
            return false;
        }
        return true;
    }

    public String getPeriodKey() {
        return this.periodKey;
    }

    public void setPeriodKey(String _periodKey) {
        this.periodKey = _periodKey;
    }

    public AcctBatchQueryServiceNew getAcctBatchQueryService() {
        return this.acctBatchQueryService;
    }

    public void setAcctBatchQueryService(AcctBatchQueryServiceNew acctBatchQueryService) {
        this.acctBatchQueryService = acctBatchQueryService;
    }

    public AcctStruct getStruct() {
        return this.struct;
    }

    public void setStruct(AcctStruct struct) {
        this.struct = struct;
    }

    public boolean isGroupByAccount() {
        return this.isGroupByAccount;
    }

    public void setGroupByAccount(boolean isGroupByAccount) {
        this.isGroupByAccount = isGroupByAccount;
    }

    @Override
    public Parameter getParameter() {
        return ((IParamBackFill)this.param).getParameter();
    }

    @Override
    public String getSheetName() {
        return ((IParamBackFill)this.param).getParameter().getSheetName();
    }

    public boolean isIncludeDetailAccountAsstItem() {
        return this.IncludeDetailAccountAsstItem;
    }

    public boolean getIsIncludeSubAsstItem() {
        return this.isIncludeSubAsstItem;
    }

    public boolean getIsIncludeLeafAsstItem() {
        return this.isIncludeLeafAsstItem;
    }

    public int getNextCurrentPeriodYear() {
        return this.nextCurrentPeriodYear;
    }

    public void setNextCurrentPeriodYear(int currentPeriodYear) {
        this.nextCurrentPeriodYear = currentPeriodYear;
    }

    public int getNextCurrentPeriodNumber() {
        return this.nextCurrentPeriodNumber;
    }

    public void setNextCurrentPeriodNumber(int currentPeriodNumber) {
        this.nextCurrentPeriodNumber = currentPeriodNumber;
    }

    public void setIEndYear(int endYear) {
        this.iEndYear = endYear;
    }

    public void setIEndPeriod(int endPeriod) {
        this.iEndPeriod = endPeriod;
    }

    @Override
    public Exception getException() {
        return (Exception)this.param.getException();
    }

    @Override
    public boolean isException() {
        return this.param.getException() != null;
    }

    public boolean isSelectSheetParam() {
        return this.isIncludeLeafAccount || this.isIncludeSubAccount || this.isIncludeLeafAsstItem || this.isIncludeSubAsstItem;
    }

    public boolean isAccountHasWildcar() {
        return this.accountHasWildcar;
    }

    public void setAccountHasWildcar(boolean accountHasWildcar) {
        this.accountHasWildcar = accountHasWildcar;
    }

    public boolean isItemHasWildcar() {
        return this.itemHasWildcar;
    }

    public void setItemHasWildcar(boolean itemHasWildcar) {
        this.itemHasWildcar = itemHasWildcar;
    }

    public AccountTableInfo getAccountTable() {
        return this.accountTable;
    }

    public void setAccountTable(AccountTableInfo accountTable) {
        this.accountTable = accountTable;
        this.accountItem.startAccount.setAccountTable(accountTable);
        this.accountItem.endAccount.setAccountTable(accountTable);
    }

    public boolean isCorrectAccountTable() {
        return this.isCorrectAccountTable;
    }

    public void setCorrectAccountTable(boolean isCorrectAccountTable) {
        this.isCorrectAccountTable = isCorrectAccountTable;
    }

    @Override
    public Object getExtendProps(String key) {
        if ("STRUCT".equalsIgnoreCase(key)) {
            return this.getStruct();
        }
        return null;
    }

    public OrgType getOrgType() {
        return this.orgType;
    }

    public boolean isProfitCenter() {
        return this.isProfitCenter;
    }
}

