/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.app.AbstractAcctCashQueryFacadeControllerBean;
import com.kingdee.eas.fi.rpt.app.AssistantGroup;
import com.kingdee.eas.fi.rpt.app.AssistantItemExt;
import com.kingdee.eas.fi.rpt.app.AsstActType;
import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantBasicStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.AssistantItemStandardQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupQuerySolution;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.MaterialGroupStandardQuery;
import com.kingdee.eas.fi.rpt.batch.AcctFormula.comm.TreeNodeBatchQuerySolution;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctCashQueryFacadeControllerBean
extends AbstractAcctCashQueryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.rpt.app.AcctCashQueryFacadeControllerBean");
    private AssistantBasicStandardQuerySolution basicStandardProcesser;
    private AssistantItemStandardQuerySolution standardProcesser;
    private MaterialGroupStandardQuery materialGroupStandardQuery;
    private MaterialGroupQuerySolution materialGroupQuery;
    private AssistantGroupQuerySolution groupProcesser;
    private Map asstItemProcesser;
    private Connection conn = null;
    private Context context;
    private AcctountAsstItemParser.AccountAsstItem acctitem;
    private Set asstActTypeNumberSet;
    private Map acctItemMap;

    @Override
    protected FilterInfo _submitAssistantQuery(Context ctx, String assistantItemString, String oppAccount) throws BOSException, EASBizException {
        this.context = ctx;
        String filterString = null;
        FilterInfo filterParam = new FilterInfo();
        try {
            AcctountAsstItemParser.AsstItem[] asstItems;
            this.conn = EJBFactory.getConnection((Context)ctx);
            this.parseAccountAsstItem(assistantItemString);
            if (this.acctitem != null && this.acctitem.asstItems != null && (asstItems = this.acctitem.asstItems) != null) {
                int formulaIndex = 0;
                StringBuffer sbFormula = new StringBuffer();
                if (!StringUtils.isEmpty((String)oppAccount)) {
                    filterString = "voucher.entries.account.number";
                    filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)oppAccount));
                    sbFormula.append("#" + formulaIndex++);
                }
                for (int i = 0; i < asstItems.length; ++i) {
                    AssistantGroup[] groups;
                    String asstTypeNumber = this.acctitem.asstItems[i].asstTypeNumber;
                    if (this.acctItemMap == null || this.acctItemMap.size() <= 0 || !this.acctItemMap.containsKey(asstTypeNumber)) continue;
                    AssistantItemExt assistantItem = (AssistantItemExt)this.acctItemMap.get(asstTypeNumber);
                    AsstActType actType = assistantItem.itemType;
                    String asst = actType.asstHGAttribute;
                    if (actType.realtionDataObject != null && (actType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") || actType.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter") || actType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype"))) {
                        filterString = "voucher.entries.cashflowRecords.assGrp." + asst + ".longNumber";
                        String startLongNumber = assistantItem.startItem.longNumber;
                        String endLongNumber = assistantItem.endItem.longNumber;
                        if (startLongNumber != null && endLongNumber != null) {
                            if (startLongNumber.equals(endLongNumber)) {
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startLongNumber));
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)(startLongNumber + "!%"), CompareType.LIKE));
                                if (!StringUtils.isEmpty((String)oppAccount)) {
                                    sbFormula.append(" and (#" + formulaIndex++);
                                } else {
                                    sbFormula.append("(#" + formulaIndex++);
                                }
                                sbFormula.append(" or #" + formulaIndex++).append(")");
                            } else {
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startLongNumber, CompareType.GREATER_EQUALS));
                                if (!StringUtils.isEmpty((String)oppAccount)) {
                                    sbFormula.append(" and #" + formulaIndex++);
                                } else {
                                    sbFormula.append("#" + formulaIndex++);
                                }
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)endLongNumber, CompareType.LESS_EQUALS));
                                sbFormula.append(" and #" + formulaIndex++);
                            }
                        }
                    } else {
                        filterString = "voucher.entries.cashflowRecords.assGrp." + asst + ".number";
                        String startNumber = assistantItem.startItem.number;
                        String endNumber = assistantItem.endItem.number;
                        if (!StringUtils.isEmpty((String)startNumber) && !StringUtils.isEmpty((String)endNumber)) {
                            if (startNumber.equals(endNumber)) {
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startNumber));
                                if (!StringUtils.isEmpty((String)oppAccount)) {
                                    sbFormula.append(" and #" + formulaIndex++);
                                } else {
                                    sbFormula.append("#" + formulaIndex++);
                                }
                            } else {
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startNumber, CompareType.GREATER_EQUALS));
                                if (!StringUtils.isEmpty((String)oppAccount)) {
                                    sbFormula.append(" and #" + formulaIndex++);
                                } else {
                                    sbFormula.append("#" + formulaIndex++);
                                }
                                filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)endNumber, CompareType.LESS_EQUALS));
                                sbFormula.append(" and #" + formulaIndex++);
                            }
                        }
                    }
                    if (!asst.equals("customer") && !asst.equals("material") && !asst.equals("provider") || (groups = assistantItem.getGroups()) == null) continue;
                    filterString = asst.equals("material") ? "voucher.entries.cashflowRecords.assGrp." + asst + ".materialGroupDetails.materialGroup.longNumber" : (asst.equals("customer") ? "voucher.entries.cashflowRecords.assGrp." + asst + ".customerGroupDetails.customerGroup.longNumber" : "voucher.entries.cashflowRecords.assGrp." + asst + ".supplierGroupDetails.supplierGroup.longNumber");
                    for (int gi = 0; gi < groups.length; ++gi) {
                        AssistantGroup group = groups[gi];
                        String startGroup = group.getStartGroup().longNumber;
                        String endGroup = group.getEndGroup().longNumber;
                        String standardID = group.standardID;
                        if (sbFormula.length() > 0) {
                            sbFormula.append(" and ");
                        }
                        if (groups[gi].isSingleGroup()) {
                            filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startGroup));
                            sbFormula.append(" ( #" + formulaIndex++);
                            filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)(startGroup + "!%"), CompareType.LIKE));
                            sbFormula.append(" or #" + formulaIndex++ + " )");
                        } else {
                            filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)startGroup, CompareType.GREATER_EQUALS));
                            sbFormula.append(" and #" + formulaIndex++);
                            filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)endGroup, CompareType.LESS_EQUALS));
                        }
                        filterString = asst.equals("material") ? "voucher.entries.cashflowRecords.assGrp." + asst + ".materialGroupDetails.materialGroupStandard.id" : (asst.equals("customer") ? "voucher.entries.cashflowRecords.assGrp." + asst + ".customerGroupDetails.customerGroupStandard.id" : "voucher.entries.cashflowRecords.assGrp." + asst + ".supplierGroupDetails.supplierGroupStandard.id");
                        sbFormula.append(" and #" + formulaIndex++);
                        filterParam.getFilterItems().add(new FilterItemInfo(filterString, (Object)standardID));
                    }
                }
                filterParam.setMaskString(sbFormula.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
        return filterParam;
    }

    private void parseAccountAsstItem(String accountAndItem) throws Exception {
        AcctountAsstItemParser.AsstItem[] asstItems;
        this.acctitem = AcctountAsstItemParser.parse(accountAndItem);
        this.acctItemMap = new HashMap();
        this.asstActTypeNumberSet = new HashSet();
        if (this.acctitem.asstItems != null && (asstItems = this.acctitem.asstItems) != null) {
            for (int i = 0; i < asstItems.length; ++i) {
                String asstTypeNumber = asstItems[i].asstTypeNumber;
                AssistantItemExt item = new AssistantItemExt(asstTypeNumber);
                this.asstActTypeNumberSet.add(asstTypeNumber);
                Map map = this.getAsstActTypeMap(asstTypeNumber);
                item.itemType = (AsstActType)map.get(asstTypeNumber);
                if (item.startItem == null) {
                    item.startItem = new GroupTreeNode();
                }
                if (item.endItem == null) {
                    item.endItem = new GroupTreeNode();
                }
                this.acctItemMap.put(item.itemType.number, item);
                item.startItem.number = asstItems[i].startNumber;
                item.endItem.number = asstItems[i].endNumber;
                if (!StringUtils.isEmpty((String)asstItems[i].startNumber)) {
                    item.startItem = new GroupTreeNode();
                    item.startItem.number = asstItems[i].startNumber;
                    if (!StringUtils.isEmpty((String)asstItems[i].endNumber)) {
                        if (!asstItems[i].startNumber.equals(asstItems[i].endNumber)) {
                            item.endItem = new GroupTreeNode();
                            item.endItem.number = asstItems[i].endNumber;
                        } else {
                            item.endItem = item.startItem;
                        }
                    }
                }
                if (asstItems[i].group != null) {
                    item.groups = new AssistantGroup[asstItems[i].group.length];
                    for (int groupCount = 0; groupCount < asstItems[i].group.length; ++groupCount) {
                        AcctountAsstItemParser.Group groupParser = asstItems[i].group[groupCount];
                        AssistantGroup group = new AssistantGroup();
                        if (groupParser.startNumber.equals(groupParser.endNumber)) {
                            if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                group.startGroup = group.endGroup = new GroupTreeNode();
                                group.startGroup.number = groupParser.startNumber;
                            }
                        } else {
                            if (!StringUtils.isEmpty((String)groupParser.startNumber)) {
                                group.startGroup = new GroupTreeNode();
                                group.startGroup.number = groupParser.startNumber;
                            }
                            if (!StringUtils.isEmpty((String)groupParser.endNumber)) {
                                group.endGroup = new GroupTreeNode();
                                group.endGroup.number = groupParser.endNumber;
                            }
                        }
                        group.standardNumber = groupParser.standardNumber;
                        item.groups[groupCount] = group;
                    }
                    item.setGroups(item.groups);
                }
                if (item.itemType.realtionDataObject != null && item.itemType.realtionDataObject.equalsIgnoreCase("t_bd_generalasstacttype")) {
                    item.startItem.number = item.startItem.number == null ? null : item.startItem.number.replaceAll("\\.", "\\!");
                    item.startItem.longNumber = item.startItem.number;
                    item.endItem.number = item.endItem.number == null ? null : item.endItem.number.replaceAll("\\.", "\\!");
                    item.endItem.longNumber = item.endItem.number;
                    if (item.startItem.number == null || item.endItem.number == null || item.startItem.number == item.endItem.number || item.startItem.number.split("\\!").length == item.endItem.number.split("\\!").length) continue;
                    throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel")});
                }
                if (item.itemType.realtionDataObject == null || !item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") && !item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_CostCenter")) continue;
                GroupTreeNode node = null;
                Map otherMap = null;
                otherMap = item.itemType.realtionDataObject.equalsIgnoreCase("T_ORG_Admin") ? this.getAdminMap(item.startItem.number, item.endItem.number) : this.getCostCenterMap(item.startItem.number, item.endItem.number);
                if (otherMap != null && otherMap.size() > 0) {
                    node = (GroupTreeNode)otherMap.get(item.startItem.number);
                    if (node == null) {
                        item.startItem.longNumber = item.startItem.number;
                    }
                    item.startItem.longNumber = node.longNumber;
                    item.startItem.level = node.level;
                    node = (GroupTreeNode)otherMap.get(item.endItem.number);
                    if (node == null) {
                        item.endItem.longNumber = item.endItem.number;
                    }
                    item.endItem.longNumber = node.longNumber;
                    item.endItem.level = node.level;
                }
                if (item.isSameLevel()) continue;
                throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResourceSince51", (String)"AssistantItemMustbeTheSameLevel")});
            }
        }
        this.initAssGrp();
    }

    private Map getAsstActTypeMap(String asstActTypeNumber) throws BOSException {
        Iterator it4;
        AsstActTypeInfo info = null;
        HashMap<String, AsstActType> map = new HashMap<String, AsstActType>();
        IAsstActType iAsst = AsstActTypeFactory.getLocalInstance((Context)this.context);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("realtionDataObject"));
        view.getSelector().add(new SelectorItemInfo("mappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("useLongNumber"));
        view.getSelector().add(new SelectorItemInfo("glAsstActTypeGrp.id"));
        view.getSelector().add(new SelectorItemInfo("groupTableName"));
        view.getSelector().add(new SelectorItemInfo("groupMappingFieldName"));
        view.getSelector().add(new SelectorItemInfo("asstHGAttribute"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)asstActTypeNumber));
        AsstActTypeCollection c = iAsst.getAsstActTypeCollection(view);
        if (c != null && c.size() != 0 && (it4 = c.iterator()).hasNext()) {
            info = (AsstActTypeInfo)it4.next();
            AsstActType type = new AsstActType();
            type.realtionDataObject = info.getRealtionDataObject();
            type.mappingFieldName = info.getMappingFieldName();
            type.number = info.getNumber();
            type.glAsstActTypeGrpID = info.getGlAsstActTypeGrp() == null ? null : info.getGlAsstActTypeGrp().getId().toString();
            type.groupTableName = info.getGroupTableName();
            type.useLongNumber = info.isUseLongNumber();
            type.groupMappingFieldName = info.getGroupMappingFieldName();
            type.asstHGAttribute = info.getAsstHGAttribute();
            map.put(type.number, type);
        }
        return map;
    }

    private Map getAdminMap(String startNumber, String endNumber) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(startNumber).append(",").append(endNumber);
        HashMap<String, GroupTreeNode> map = new HashMap<String, GroupTreeNode>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("level"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)sb.toString(), CompareType.INCLUDE));
        AdminOrgUnitCollection adminCol = AdminOrgUnitFactory.getLocalInstance((Context)this.context).getAdminOrgUnitCollection(view);
        if (adminCol != null && adminCol.size() > 0) {
            for (int i = 0; i < adminCol.size(); ++i) {
                AdminOrgUnitInfo info = adminCol.get(i);
                GroupTreeNode item = new GroupTreeNode();
                item.longNumber = info.getLongNumber();
                item.number = info.getNumber();
                item.level = info.getLevel();
                if (map.containsKey(item.number)) continue;
                map.put(item.number, item);
            }
        }
        return map;
    }

    private Map getCostCenterMap(String startNumber, String endNumber) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(startNumber).append(",").append(endNumber);
        HashMap<String, GroupTreeNode> map = new HashMap<String, GroupTreeNode>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("level"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)sb.toString(), CompareType.INCLUDE));
        CostCenterOrgUnitCollection costCol = CostCenterOrgUnitFactory.getLocalInstance((Context)this.context).getCostCenterOrgUnitCollection(view);
        if (costCol != null && costCol.size() > 0) {
            for (int i = 0; i < costCol.size(); ++i) {
                CostCenterOrgUnitInfo info = costCol.get(i);
                GroupTreeNode item = new GroupTreeNode();
                item.longNumber = info.getLongNumber();
                item.number = info.getNumber();
                item.level = info.getLevel();
                if (map.containsKey(item.number)) continue;
                map.put(item.number, item);
            }
        }
        return map;
    }

    private void initAssGrp() throws Exception {
        AcctountAsstItemParser.AsstItem[] asstItems;
        if (this.acctitem != null && this.acctitem.asstItems != null && (asstItems = this.acctitem.asstItems) != null) {
            for (int i = 0; i < asstItems.length; ++i) {
                String asstTypeNumber = this.acctitem.asstItems[i].asstTypeNumber;
                if (this.acctItemMap == null || this.acctItemMap.size() <= 0 || !this.acctItemMap.containsKey(asstTypeNumber)) continue;
                AssistantItemExt assistantItem = (AssistantItemExt)this.acctItemMap.get(asstTypeNumber);
                assistantItem = this.submitAssistantStandardQuery(assistantItem);
                assistantItem = this.submitAssistantItemQuery(assistantItem);
                this.acctItemMap.put(asstTypeNumber, assistantItem);
            }
        }
    }

    private AssistantItemExt submitAssistantStandardQuery(AssistantItemExt assistantItem) throws Exception {
        if (assistantItem != null) {
            this.processGroupStandard(assistantItem);
            this.execAssistantStandardQuery();
        }
        return assistantItem;
    }

    private AssistantItemExt submitAssistantItemQuery(AssistantItemExt assistantItem) throws Exception {
        if (assistantItem != null) {
            this.processAssistantItem(assistantItem);
            this.execAssistantItemQuery();
        }
        return assistantItem;
    }

    public void execAssistantItemQuery() throws Exception {
        if (this.groupProcesser != null) {
            this.groupProcesser.exec();
        }
        if (this.asstItemProcesser != null) {
            Iterator it = this.asstItemProcesser.entrySet().iterator();
            while (it.hasNext()) {
                ((TreeNodeBatchQuerySolution)it.next().getValue()).exec();
            }
        }
        if (this.materialGroupQuery != null) {
            this.materialGroupQuery.exec();
        }
    }

    private void processGroupStandard(AssistantItemExt assistItem) {
        AssistantGroup[] groups = assistItem.getGroups();
        for (int i = 0; groups != null && i < groups.length; ++i) {
            AssistantGroup group = groups[i];
            int type = -1;
            type = "T_BD_CUSTOMER".equalsIgnoreCase(assistItem.itemType.realtionDataObject) ? 1 : ("T_BD_SUPPLIER".equalsIgnoreCase(assistItem.itemType.realtionDataObject) ? 2 : 3);
            group.standardType = type;
            if (type == 1 || type == 2) {
                if (!(!StringUtils.isEmpty((String)group.getStandardNumber()) || StringUtils.isEmpty((String)group.getStartGroup().getNumber()) && StringUtils.isEmpty((String)group.getEndGroup().getNumber()))) {
                    this.submitBasicStandardQuery(assistItem, group);
                    continue;
                }
                this.submitStandardQuery(group);
                continue;
            }
            if (type != 3) continue;
            if (!(!StringUtils.isEmpty((String)group.getStandardNumber()) || StringUtils.isEmpty((String)group.getStartGroup().getNumber()) && StringUtils.isEmpty((String)group.getEndGroup().getNumber()))) {
                group.standardType = 1;
                this.submitMaterialStandardQuery(group);
                continue;
            }
            group.standardType = 0;
            this.submitMaterialStandardQuery(group);
        }
    }

    private void processAssistantItem(AssistantItemExt assistItem) {
        AssistantGroup[] groups = assistItem.getGroups();
        for (int i = 0; groups != null && i < groups.length; ++i) {
            AssistantGroup group = groups[i];
            int type = -1;
            if ("T_BD_CUSTOMER".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) {
                type = 1;
            } else if ("T_BD_SUPPLIER".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) {
                type = 2;
            }
            if (type > 0) {
                if (StringUtils.isEmpty((String)group.standardID)) continue;
                this.submitGroupQuery(group.startGroup, type, group.standardID);
                if (group.startGroup == group.endGroup) continue;
                this.submitGroupQuery(group.endGroup, type, group.standardID);
                continue;
            }
            if (StringUtils.isEmpty((String)group.standardID)) continue;
            this.submitMaterialGroupQuery(group.startGroup, group.standardID);
            if (group.startGroup == group.endGroup) continue;
            this.submitMaterialGroupQuery(group.endGroup, group.standardID);
        }
        if (assistItem.itemType != null && (assistItem.itemType.useLongNumber || "T_BD_GeneralAsstActType".equalsIgnoreCase(assistItem.itemType.realtionDataObject))) {
            if (assistItem.startItem != null && assistItem.startItem.number != null) {
                assistItem.startItem.longNumber = assistItem.startItem.number = assistItem.startItem.number.replaceAll("\\.", "\\!");
            }
            if (assistItem.endItem != null && assistItem.endItem.number != null) {
                assistItem.endItem.longNumber = assistItem.endItem.number = assistItem.endItem.number.replaceAll("\\.", "\\!");
            }
        } else if (assistItem.itemType != null && ("T_ORG_Admin".equalsIgnoreCase(assistItem.itemType.realtionDataObject) || "T_BD_CashFlowItem".equalsIgnoreCase(assistItem.itemType.realtionDataObject) || "T_ORG_CostCenter".equalsIgnoreCase(assistItem.itemType.realtionDataObject)) && assistItem.startItem != null && assistItem.startItem.number != null) {
            this.submitAsstItemQuery(assistItem.itemType.realtionDataObject, assistItem.startItem);
            if (assistItem.startItem != assistItem.endItem && assistItem.endItem != null && assistItem.endItem.number != null) {
                this.submitAsstItemQuery(assistItem.itemType.realtionDataObject, assistItem.endItem);
            }
        }
    }

    private void submitGroupQuery(GroupTreeNode node, int type, String stdid) {
        if (this.groupProcesser == null) {
            this.groupProcesser = new AssistantGroupQuerySolution(this.conn);
        }
        try {
            this.groupProcesser.add(node, type, stdid);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitMaterialGroupQuery(GroupTreeNode group, String standard) {
        if (this.materialGroupQuery == null) {
            this.materialGroupQuery = new MaterialGroupQuerySolution(this.conn);
        }
        this.materialGroupQuery.add(group, standard);
    }

    public void submitAsstItemQuery(String tableName, GroupTreeNode node) {
        if (this.asstItemProcesser == null) {
            this.asstItemProcesser = new HashMap(1);
        }
        TreeNodeBatchQuerySolution query = null;
        if (this.asstItemProcesser.containsKey(tableName)) {
            query = (TreeNodeBatchQuerySolution)this.asstItemProcesser.get(tableName);
        } else {
            query = new TreeNodeBatchQuerySolution(this.conn, tableName);
            this.asstItemProcesser.put(tableName, query);
        }
        try {
            query.add(node);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void execAssistantStandardQuery() throws Exception {
        if (this.standardProcesser != null) {
            this.standardProcesser.exec();
        }
        if (this.basicStandardProcesser != null) {
            this.basicStandardProcesser.exec();
        }
        if (this.materialGroupStandardQuery != null) {
            this.materialGroupStandardQuery.exec();
        }
    }

    private void submitBasicStandardQuery(AssistantItemExt item, AssistantGroup group) {
        if (this.basicStandardProcesser == null) {
            this.basicStandardProcesser = new AssistantBasicStandardQuerySolution(this.conn);
        }
        try {
            this.basicStandardProcesser.add(item, group);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitStandardQuery(AssistantGroup group) {
        if (this.standardProcesser == null) {
            this.standardProcesser = new AssistantItemStandardQuerySolution(this.conn);
        }
        try {
            this.standardProcesser.add(group);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
    }

    private void submitMaterialStandardQuery(AssistantGroup g) {
        if (this.materialGroupStandardQuery == null) {
            this.materialGroupStandardQuery = new MaterialGroupStandardQuery(this.conn);
        }
        this.materialGroupStandardQuery.setContext(this.context);
        this.materialGroupStandardQuery.add(g);
    }

    protected Map _queryAssGrpIDAndType(Context ctx, String cashItemId, Map groupMap, List asstActType) throws BOSException {
        return null;
    }
}

