/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateUtils;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.app.DbUtil;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.ReportCalculateErrorProvider;
import com.kingdee.eas.fi.rpt.ReportException;
import com.kingdee.eas.fi.rpt.VoucherGetTypeEnum;
import com.kingdee.eas.fi.rpt.app.AccountItem;
import com.kingdee.eas.fi.rpt.app.AcctCalculater;
import com.kingdee.eas.fi.rpt.app.AssistantItem;
import com.kingdee.eas.fi.rpt.app.RptCalculaterDAO;
import com.kingdee.eas.fi.rpt.util.AcctountAsstItemParser;
import com.kingdee.eas.fi.rpt.util.DebugLogger;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.fi.rpt.util.RptUtilForServer;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class AcctExtCalculater {
    private static final Logger log = Logger.getLogger((String)AcctExtCalculater.class.getName());
    private static final int DEBIT_DC = 1;
    private static final int CREDIT_DC = 0;
    private Context _context;
    private AccountItem _accountItem;
    private AccountItem _oppAccountItem = null;
    private String _userDefineFilter;
    private VoucherGetTypeEnum _vchGetType;
    private CurrencyInfo _currency;
    private CompanyOrgUnitInfo _company;
    private GregorianCalendar _endDate = new GregorianCalendar();
    private GregorianCalendar _startDate = new GregorianCalendar();
    private PeriodInfo _startPeriod = null;
    private PeriodInfo _endPeriod = null;
    private boolean _isincludingUnPosted = false;
    private boolean _checkDataRight = false;
    private RptCalculaterDAO calcDAO = null;
    private List sqlParams = new ArrayList();
    StringBuffer[] itemFromCluster = null;
    StringBuffer[] itemWhereCluster = null;
    private Map company2AcctExtCompanyConditionMap;
    private static final int START_DIR = 0;
    private static final int END_DIR = 1;

    public AcctExtCalculater(Context ctx, CompanyOrgUnitInfo company, AccountItem accountItem, AccountItem oppAccountItem, String userDefineFiter, VoucherGetTypeEnum vchGetType, CurrencyInfo currencyInfo, GregorianCalendar startDate, GregorianCalendar endDate, boolean isincludingUnPosted, boolean checkDataRight, PeriodInfo startPeriod, PeriodInfo endPeriod) throws EASBizException, BOSException {
        this._company = company;
        this._context = ctx;
        this._accountItem = accountItem;
        this._oppAccountItem = oppAccountItem;
        this._userDefineFilter = userDefineFiter;
        this._vchGetType = vchGetType;
        this._currency = currencyInfo;
        this._startDate = (GregorianCalendar)startDate.clone();
        this._endDate = (GregorianCalendar)endDate.clone();
        this._startPeriod = startPeriod;
        this._endPeriod = endPeriod;
        this._isincludingUnPosted = isincludingUnPosted;
        this._checkDataRight = checkDataRight;
        this.calcDAO = new RptCalculaterDAO(this._context);
        if (company.isIsOnlyUnion() && this.calcDAO.getAccountTableCount(this._company.getCU().getId().toString()) > 1) {
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this._context.getLocale())});
        }
    }

    public AcctExtCalculater(Context ctx, String fiOrgUnit, String account, String opposingAccount, String userDefineFiter, VoucherGetTypeEnum vchGetType, String currencyNumber, String sStartDate, String sEndDate, boolean isincludingUnPosted, boolean checkDataRight) throws EASBizException, BOSException {
        this._context = ctx;
        if (StringUtils.isEmpty((String)account)) {
            throw new ReportException(ReportException.NOT_FOUND_ACCOUNT);
        }
        if (StringUtils.isEmpty((String)sStartDate) || StringUtils.isEmpty((String)sEndDate)) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR);
        }
        this._vchGetType = vchGetType;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Calendar calendar = Calendar.getInstance();
            Date date = dateFormat.parse(sStartDate);
            calendar.setTime(date);
            Date startDate = calendar.getTime();
            Calendar Endcalendar = Calendar.getInstance();
            Date Enddate = dateFormat.parse(sEndDate);
            Endcalendar.setTime(Enddate);
            Date EndDate = Endcalendar.getTime();
            if (this.isGetInitialAmount()) {
                calendar.add(5, -1);
                EndDate = startDate = calendar.getTime();
            }
            this._startDate.setTime(startDate);
            this._endDate.setTime(EndDate);
        }
        catch (ParseException e) {
            throw new ReportException(ReportException.EXECP_ACCTEXT_DATEERROR, (Throwable)e);
        }
        this.initCompanyDependencyParams(fiOrgUnit, account, opposingAccount, currencyNumber);
        this._userDefineFilter = userDefineFiter;
        this._isincludingUnPosted = isincludingUnPosted;
        this._checkDataRight = checkDataRight;
    }

    private void initCompanyDependencyParams(String fiOrgUnit, String account, String opposingAccount, String currencyNumber) throws ReportException, BOSException, EASBizException {
        this.calcDAO = new RptCalculaterDAO(this._context);
        try {
            this._currency = this.calcDAO.getCurrencyByNumber(currencyNumber);
        }
        catch (BOSException e) {
            throw new ReportException(ReportException.ACCTEXT_FORMULA_ERROR, (Throwable)e);
        }
        this.company2AcctExtCompanyConditionMap = this.initCompanies(fiOrgUnit, currencyNumber);
        for (AcctExtCompanyCondition condition : this.company2AcctExtCompanyConditionMap.values()) {
            condition._accountItem = new AccountItem(this._context, account, condition._company);
            if (StringUtils.isEmpty((String)opposingAccount)) continue;
            condition._oppAccountItem = new AccountItem(this._context, opposingAccount, condition._company);
        }
    }

    private Map initCompanies(String fiOrgUnit, String currencyNumber) throws BOSException, EASBizException {
        List list;
        int i;
        CompanyOrgUnitCollection companyOrgUnitCollection = this.getCompanyOrgUnitCollection(fiOrgUnit);
        if (companyOrgUnitCollection == null || companyOrgUnitCollection.size() == 0) {
            throw new ReportException(ReportException.FIND_COMPANY_ERROR);
        }
        this.verifyAccountTable(companyOrgUnitCollection);
        HashMap<String, AcctExtCompanyCondition> result = new HashMap<String, AcctExtCompanyCondition>();
        HashMap periodType2ConditionMap = new HashMap();
        for (CompanyOrgUnitInfo company : companyOrgUnitCollection) {
            AcctExtCompanyCondition condition = new AcctExtCompanyCondition();
            condition._company = company;
            result.put(company.getNumber(), condition);
            if (periodType2ConditionMap.get(company.getAccountPeriodType().getId().toString()) == null) {
                ArrayList<AcctExtCompanyCondition> list2 = new ArrayList<AcctExtCompanyCondition>();
                list2.add(condition);
                periodType2ConditionMap.put(company.getAccountPeriodType().getId().toString(), list2);
                continue;
            }
            ((List)periodType2ConditionMap.get(company.getAccountPeriodType().getId().toString())).add(condition);
        }
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)this._context);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)this._startDate.getTime()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)this._startDate.getTime()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", periodType2ConditionMap.keySet(), CompareType.INCLUDE));
        evi.setFilter(filter);
        PeriodCollection startPeriodc = iPeriod.getPeriodCollection(evi);
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("beginDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)this._endDate.getTime()), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("endDate", (Object)ExchangeRateUtils.covertToSimpleDate((Date)this._endDate.getTime()), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", periodType2ConditionMap.keySet(), CompareType.INCLUDE));
        PeriodCollection endPeriodc = iPeriod.getPeriodCollection(evi);
        for (i = 0; i < startPeriodc.size(); ++i) {
            PeriodInfo startPeriodInfo = startPeriodc.get(i);
            if (startPeriodInfo.isIsAdjustPeriod()) continue;
            list = (List)periodType2ConditionMap.get(startPeriodInfo.getPeriodType().getId().toString());
            for (AcctExtCompanyCondition condition : list) {
                condition._startPeriod = startPeriodInfo;
            }
        }
        for (i = 0; i < endPeriodc.size(); ++i) {
            PeriodInfo endPeriodInfo = endPeriodc.get(i);
            if (endPeriodInfo.isIsAdjustPeriod()) continue;
            list = (List)periodType2ConditionMap.get(endPeriodInfo.getPeriodType().getId().toString());
            for (AcctExtCompanyCondition condition : list) {
                condition._endPeriod = endPeriodInfo;
            }
        }
        if (currencyNumber.equals("GLC") || currencyNumber.equals("GRC")) {
            this._currency.setPrecision(companyOrgUnitCollection.get(0).getBaseCurrency().getPrecision());
        }
        return result;
    }

    private void verifyAccountTable(CompanyOrgUnitCollection companyOrgUnitCollection) throws BOSException, ReportException {
        LinkedHashSet<String> cuIDSet = new LinkedHashSet<String>();
        HashMap cu2CompanyMap = new HashMap();
        for (CompanyOrgUnitInfo company : companyOrgUnitCollection) {
            if (company.isIsOnlyUnion()) {
                cuIDSet.add(company.getId().toString());
            }
            if (cu2CompanyMap.get(company.getId().toString()) == null) {
                ArrayList<CompanyOrgUnitInfo> list = new ArrayList<CompanyOrgUnitInfo>();
                list.add(company);
                cu2CompanyMap.put(company.getId().toString(), list);
                continue;
            }
            ((List)cu2CompanyMap.get(company.getId().toString())).add(company);
        }
        if (cuIDSet.size() > 0) {
            String sql = "SELECT count(FID) ct,FDestCompanyID FROM T_BD_ACCT_CONTORL WHERE FDestCompanyID in " + this.createInCondition(cuIDSet.iterator()) + " AND FISDEFAULTFORREFER = 1 group by FDestCompanyID having count(FID) > 1";
            IRowSet rowSet = DbUtil.executeQuery((Context)this._context, (String)sql);
            try {
                if (rowSet.next()) {
                    throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.rpt.ReportResource", (String)"report_cacl_existmuiltaccount", (Locale)this._context.getLocale())});
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
        }
        StringBuffer oql = new StringBuffer();
        oql.append("select *,enabledAcctTable.*,disabledAcctTable.*,enabledPeriod.* where company.id in ");
        oql.append(this.createInCondition(cu2CompanyMap.keySet().iterator()));
        oql.append("and isEnabled = 1 and enabledPeriod is not null ");
        oql.append("order by enabledPeriod.periodYear desc,enabledPeriod.periodNumber desc");
        AccountRefContrastCollection lastRefCollection = AccountRefContrastFactory.getLocalInstance((Context)this._context).getAccountRefContrastCollection(oql.toString());
        HashMap cu2LastRefMap = new HashMap();
        for (AccountRefContrastInfo lastRef : lastRefCollection) {
            if (cu2LastRefMap.get(lastRef.getCompany().getId().toString()) == null) {
                ArrayList<AccountRefContrastInfo> list = new ArrayList<AccountRefContrastInfo>();
                list.add(lastRef);
                cu2LastRefMap.put(lastRef.getCompany().getId().toString(), list);
                continue;
            }
            ((List)cu2LastRefMap.get(lastRef.getCompany().getId().toString())).add(lastRef);
        }
        int periodYear = this._endDate.get(1);
        int periodNumber = this._endDate.get(2) + 1;
        for (Map.Entry entry : cu2LastRefMap.entrySet()) {
            String cuID = (String)entry.getKey();
            List lastRefCol = (List)entry.getValue();
            if (lastRefCollection == null || lastRefCollection.size() <= 0) continue;
            List companies = (List)cu2CompanyMap.get(cuID);
            block5: for (CompanyOrgUnitInfo company : companies) {
                String enabledAcctTableID = company.getAccountTable().getId().toString();
                for (int i = 0; i < lastRefCol.size(); ++i) {
                    AccountRefContrastInfo info = (AccountRefContrastInfo)lastRefCol.get(i);
                    if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString()) && (periodYear > info.getEnabledPeriod().getPeriodYear() || periodYear == info.getEnabledPeriod().getPeriodYear() && periodNumber > info.getEnabledPeriod().getPeriodNumber())) {
                        company.getAccountTable().setId(info.getEnabledAcctTable().getId());
                        continue block5;
                    }
                    if (enabledAcctTableID.equals(info.getEnabledAcctTable().getId().toString())) {
                        enabledAcctTableID = info.getDisabledAcctTable().getId().toString();
                    }
                    if (i != lastRefCol.size() - 1) continue;
                    company.getAccountTable().setId(BOSUuid.read((String)enabledAcctTableID));
                    continue block5;
                }
            }
        }
    }

    private CompanyOrgUnitCollection getCompanyOrgUnitCollection(String fiOrgUnit) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("cu.id"));
        view.getSelector().add(new SelectorItemInfo("isOnlyUnion"));
        view.getSelector().add(new SelectorItemInfo("accountTable.id"));
        view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longnumber"));
        view.getSelector().add(new SelectorItemInfo("accountPeriodType.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.getAnalyzedCompanyNumberList(fiOrgUnit), CompareType.INCLUDE));
        view.setFilter(filter);
        return CompanyOrgUnitFactory.getLocalInstance((Context)this._context).getCompanyOrgUnitCollection(view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BigDecimal calculate() throws BOSException, EASBizException {
        BigDecimal result = new BigDecimal("0");
        try {
            for (Map.Entry entry : this.company2AcctExtCompanyConditionMap.entrySet()) {
                AcctExtCompanyCondition condition = (AcctExtCompanyCondition)entry.getValue();
                AccountItem _accountItem = condition._accountItem;
                AccountItem _oppAccountItem = condition._oppAccountItem;
                CompanyOrgUnitInfo _company = condition._company;
                PeriodInfo _startPeriod = condition._startPeriod;
                PeriodInfo _endPeriod = condition._endPeriod;
                for (int i = 0; i < _accountItem.discreteAccount.length; ++i) {
                    _accountItem.startAccount = _accountItem.discreteAccount[i][0];
                    _accountItem.endAccount = _accountItem.discreteAccount[i][1];
                    AcctExtCalculater c = new AcctExtCalculater(this._context, _company, _accountItem, _oppAccountItem, this._userDefineFilter, this._vchGetType, this._currency, this._startDate, this._endDate, this._isincludingUnPosted, this._checkDataRight, _startPeriod, _endPeriod);
                    BigDecimal calculateOne = new BigDecimal("0");
                    try {
                        if (_accountItem.startAccount == null || _accountItem.endAccount == null) {
                            AcctountAsstItemParser.Range range = _accountItem.getAccountAsstItem().accounts[i];
                            String none = range.startNumber == null ? range.startNumber : range.endNumber;
                            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this._context.getLocale()) + " \"" + none + "\""});
                        }
                        calculateOne = c.calculateOne();
                    }
                    catch (EASBizException e) {
                        IErrorProvider errorProvider = ReportCalculateErrorProvider.getErrorProvider(EASBizException.class);
                        if (errorProvider != null) {
                            Variant properValue = errorProvider.getProperValue((Exception)((Object)e));
                            try {
                                Object obj = properValue.getValue();
                                calculateOne = new BigDecimal(obj.toString());
                            }
                            catch (Exception e1) {
                                throw e;
                            }
                        }
                        throw e;
                    }
                    result = result.add(calculateOne);
                }
            }
        }
        finally {
            RptCalculaterDAO.clearServerCache(this._context);
        }
        return result;
    }

    public BigDecimal calculateOne() throws BOSException, EASBizException {
        IRowSet rowSetFirst;
        if (this._accountItem.startAccount == null || this._accountItem.endAccount == null) {
            String none = this._accountItem.startAccount == null ? this._accountItem.getAccountAsstItem().startNumber : this._accountItem.getAccountAsstItem().endNumber;
            throw new ReportException(ReportException.COMMON_EXCEPTION, (Object[])new String[]{RptUtil.getReportResource("report_calc_noaccount", this._context.getLocale()) + " \"" + none + "\""});
        }
        if (!this._accountItem.isSameLevel()) {
            throw new ReportException(ReportException.ACCTEXT_FORMULA_ERROR);
        }
        if (this._accountItem.hasItem() && this._oppAccountItem != null && this._oppAccountItem.endAccount != null) {
            throw new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER);
        }
        if (this._oppAccountItem != null && this._oppAccountItem.hasItem()) {
            throw new ReportException(ReportException.NOT_SUPPORT_FORMULA_PARAMETER);
        }
        BigDecimal bdRetBalance = new BigDecimal("0");
        if (this.isGetAssistQuantity() && !this._accountItem.hasItem()) {
            return bdRetBalance;
        }
        if (this.isGetInitialAmount() || this.isGetAverageBalance() || this.isGetBalance()) {
            PeriodInfo periodInfo = null;
            periodInfo = this.isGetAverageBalance() ? this._startPeriod : this._endPeriod;
            if (periodInfo == null) {
                throw new ReportException(ReportException.NOT_FOUND_PERIOD);
            }
            BigDecimal bTemp = new BigDecimal("0");
            int prePeriod = periodInfo.getPeriodNumber();
            int preYear = periodInfo.getPeriodYear();
            if (this.isGetInitialAmount()) {
                PeriodInfo compStartPeriod = RptUtilForServer.getStartPeriodByCompany(this._context, this._company.getId().toString());
                if (compStartPeriod == null) {
                    throw new ReportException(ReportException.NOT_FOUND_PERIOD);
                }
                int compStartPeriodNumber = compStartPeriod.getPeriodNumber();
                int compStartYear = compStartPeriod.getPeriodYear();
                int startYear = 0;
                int startPeriod = 0;
                if (this._startPeriod == null || this._startPeriod.getPeriodYear() < compStartYear || this._startPeriod.getPeriodYear() == compStartYear && this._startPeriod.getPeriodNumber() < compStartPeriodNumber) {
                    startYear = compStartYear;
                    startPeriod = compStartPeriodNumber;
                } else {
                    startYear = this._startPeriod.getPeriodYear();
                    startPeriod = this._startPeriod.getPeriodNumber();
                }
                int endYear = preYear;
                int endPeriod = prePeriod;
                if (preYear < compStartYear || preYear == compStartYear && prePeriod < compStartPeriodNumber) {
                    endYear = compStartYear;
                    endPeriod = compStartPeriodNumber;
                    startYear = compStartYear;
                    startPeriod = compStartPeriodNumber;
                }
                bTemp = this.getBalanceByAcct(startYear, startPeriod, endYear, endPeriod);
            } else {
                bTemp = this.isGetAverageBalance() && periodInfo.getBeginDate().before(this._startDate.getTime()) ? (this._vchGetType.getValue() == 9 ? new AcctExtCalculater(this._context, this._company, this._accountItem, null, null, VoucherGetTypeEnum.C, this._currency, this._startDate, this._startDate, this._isincludingUnPosted, this._checkDataRight, this._startPeriod, this._endPeriod).calculateOne() : (this._vchGetType.getValue() == 16 ? new AcctExtCalculater(this._context, this._company, this._accountItem, null, null, VoucherGetTypeEnum.TC, this._currency, this._startDate, this._startDate, this._isincludingUnPosted, this._checkDataRight, this._startPeriod, this._endPeriod).calculateOne() : new AcctExtCalculater(this._context, this._company, this._accountItem, null, null, VoucherGetTypeEnum.ZTC, this._currency, this._startDate, this._startDate, this._isincludingUnPosted, this._checkDataRight, this._startPeriod, this._endPeriod).calculateOne())) : this.getBalanceByAcct(periodInfo.getPeriodYear(), prePeriod, periodInfo.getPeriodYear(), prePeriod);
            }
            bdRetBalance = bdRetBalance.add(bTemp);
        }
        StringBuffer sqllast = new StringBuffer();
        ArrayList paramLast = new ArrayList();
        StringBuffer sqlselect = this.constructSelect();
        StringBuffer sqlfrom = this.constructFrom();
        if (!StringUtils.isEmpty((String)this._userDefineFilter) && this._userDefineFilter.indexOf("VoucherType") > -1 && this.isGetAccrualAmount()) {
            sqlfrom.append(", T_BD_VoucherTypes VoucherType");
        }
        StringBuffer sqlWhere = this.constructWhere();
        StringBuffer sqlOtherWhere = this.constructOtherWhere(sqlfrom, sqlWhere);
        if (!this.isGetAccrualAmount()) {
            sqlOtherWhere.append(" and Out_Account.flevel =? ");
            this.sqlParams.add(new Integer(this._accountItem.startAccount.level));
        }
        paramLast.addAll(this.sqlParams);
        if (!this._accountItem.hasItem()) {
            sqllast.append(sqlselect);
            sqllast.append(sqlfrom);
            sqllast.append(sqlWhere);
            sqllast.append(sqlOtherWhere);
        } else {
            StringBuffer itemFrom = new StringBuffer();
            StringBuffer itemWhere = new StringBuffer();
            sqllast.append(sqlselect).append(sqlfrom);
            for (int i = 0; i < this._accountItem.itemSize(); ++i) {
                itemFrom.append(this.itemFromCluster[i]);
                if (this.isGetAccrualAmount()) {
                    itemWhere.append(this.itemWhereCluster[i]);
                    continue;
                }
                itemWhere.append(this.itemWhereCluster[i]);
            }
            sqllast.append(itemFrom);
            sqllast.append(sqlWhere);
            if (this.isGetAccrualAmount()) {
                sqllast.append(itemWhere).append(sqlOtherWhere);
            } else {
                sqllast.append(itemWhere).append(sqlOtherWhere);
            }
        }
        if (this.isGetAverageBalance()) {
            try {
                rowSetFirst = DbUtil.executeQuery((Context)this._context, (String)sqllast.toString(), (Object[])paramLast.toArray());
                DebugLogger.info(log, "acctext average execute kql", sqllast.toString());
                DebugLogger.info(log, "acctext average params", paramLast.toArray());
                BigDecimal bdDayBalance = new BigDecimal("0");
                while (rowSetFirst.next()) {
                    BigDecimal bdRetVal = rowSetFirst.getBigDecimal("Value");
                    if (bdRetVal == null) continue;
                    bdDayBalance = bdDayBalance.add(bdRetVal);
                }
                long dayNums = DateTimeUtils.dateDiff((String)"d", (Date)this._startDate.getTime(), (Date)this._endDate.getTime());
                bdDayBalance = bdDayBalance.divide(new BigDecimal(Long.toString(dayNums + 1L)), this._currency.getPrecision(), 4);
                bdRetBalance = bdRetBalance.add(bdDayBalance);
            }
            catch (SQLException avgExec) {
                throw new ReportException(ReportException.CALC_ERROR, (Throwable)avgExec);
            }
        }
        if (this.isGetBalance() || this.isGetAccrualAmount() || this.isGetInitialAmount()) {
            try {
                rowSetFirst = DbUtil.executeQuery((Context)this._context, (String)sqllast.toString(), (Object[])paramLast.toArray());
                DebugLogger.info(log, "acctext Balance execute kql", sqllast.toString());
                DebugLogger.info(log, "acctext Balance params", paramLast.toArray());
                BigDecimal bdRetVal = null;
                BigDecimal bdSumVal = new BigDecimal("0");
                while (rowSetFirst.next()) {
                    bdRetVal = rowSetFirst.getBigDecimal(1);
                    if (bdRetVal == null) continue;
                    bdSumVal = bdSumVal.add(bdRetVal);
                }
                bdRetBalance = this.isGetInitialAmount() || this.isGetBalance() ? bdRetBalance.add(bdSumVal) : bdSumVal;
            }
            catch (Exception balExec) {
                throw new ReportException(ReportException.CALC_ERROR, (Throwable)balExec);
            }
        }
        Map paramsMap = RptUtil.getCslParams(this._context, new String[]{"AcctExt_Value_RoundingByPrecision"});
        boolean isRoundingByPrecision = RptUtil.isTrue(paramsMap.get("AcctExt_Value_RoundingByPrecision"));
        if (isRoundingByPrecision) {
            bdRetBalance = bdRetBalance.setScale(this._currency.getPrecision(), 4);
        }
        return bdRetBalance;
    }

    private BigDecimal getBalanceByAcct(int startYear, int startPeriod, int endYear, int endPeriod) throws BOSException, EASBizException {
        BalanceTypeEnum balanceType = BalanceTypeEnum.C;
        String vchGetTypeName = this._vchGetType.getName();
        if (RptUtil.findString(vchGetTypeName, ",C,Y,AY,")) {
            balanceType = BalanceTypeEnum.C;
        } else if (RptUtil.findString(vchGetTypeName, ",TC,TY,TAY,")) {
            balanceType = BalanceTypeEnum.TC;
        } else if (RptUtil.findString(vchGetTypeName, ",ZTC,ZTY,ZAY,")) {
            balanceType = BalanceTypeEnum.RC;
        }
        Set set = this._accountItem.itemSet();
        for (String strItemType : set) {
            AssistantItem asstItem = this._accountItem.getItem(strItemType);
            if (!asstItem.itemType.useLongNumber) continue;
            asstItem.startItem.longNumber = asstItem.startItem.number = asstItem.startItem.number.replaceAll("\\.", "!");
            asstItem.endItem.longNumber = asstItem.endItem.number = asstItem.endItem.number.replaceAll("\\.", "!");
        }
        AcctCalculater acct = new AcctCalculater(this._context, this._company, this._accountItem, balanceType, startYear, startPeriod, endYear, endPeriod, this._currency, false, this._isincludingUnPosted, this._checkDataRight);
        return acct.calculate();
    }

    private StringBuffer constructSelect() throws EASBizException {
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        boolean isHaseAcctType = this._accountItem.hasItem();
        if (this._oppAccountItem != null && this._oppAccountItem.hasItem()) {
            isHaseAcctType = true;
        }
        StringBuffer sqlSelInit = null;
        sqlSelInit = this.isGetAccrualAmount() ? new StringBuffer("Select ") : new StringBuffer("Select Out_Account.FDc*(Select ");
        if (this.isGetQuantity()) {
            if (this.isDouble()) {
                if (isHaseAcctType) {
                    sqlSelInit.append(" sum(A_Record.FStandardQuantity) value");
                } else {
                    sqlSelInit.append(" sum(case when voucherEntry.FOriginalAmount <= veB.FOriginalAmount");
                    sqlSelInit.append(" then voucherEntry.FStandardQuantity");
                    sqlSelInit.append(" else veB.FOriginalAmount/voucherEntry.FOriginalAmount*voucherEntry.FStandardQuantity");
                    sqlSelInit.append(" end ) value");
                }
            } else if (isHaseAcctType) {
                sqlSelInit.append("sum(A_Record.FStandardQuantity) value ");
            } else {
                sqlSelInit.append("sum(voucherEntry.FStandardQuantity) value ");
            }
            return sqlSelInit;
        }
        if (this.isGetAssistQuantity()) {
            sqlSelInit.append("sum(A_Record.FAssistQty) value ");
        }
        if (this.isGetJDAmount()) {
            sqlSelInit.append("count(voucherEntry.FEntryDC) value ");
        }
        if (RptUtil.findString(this._currency.getNumber(), ",GLC,GRC,")) {
            int[] accountCount;
            if (this._currency.getNumber().equals("GLC")) {
                if (this.isDouble()) {
                    if (this.isGetAccountAccrual()) {
                        accountCount = this.getSameAcountCountIgnoreAsstItems();
                        if (accountCount != null) {
                            sqlSelInit.append("( case when sum(voucherEntry.FLocalAmount)/" + accountCount[1] + " < sum(veB.FLocalAmount)/" + accountCount[0] + " then sum(voucherEntry.FLocalAmount)/" + accountCount[1] + " else sum(veB.FLocalAmount)/" + accountCount[0] + " end  ");
                        } else {
                            sqlSelInit.append("sum((case when voucherEntry.FLocalAmount < veB.FLocalAmount then voucherEntry.FLocalAmount else veB.FLocalAmount end ) ");
                        }
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FLocalAmount < veB.FLocalAmount then voucherEntry.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) else veB.FLocalAmount*(veB.FEntryDC * 2 -1) end ) ");
                    }
                } else if (isHaseAcctType) {
                    if (this.isGetAccountAccrual()) {
                        sqlSelInit.append("sum(A_Record.FLocalAmount ");
                    } else {
                        sqlSelInit.append("sum(A_Record.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) ");
                    }
                } else if (this.isGetAccountAccrual()) {
                    sqlSelInit.append("sum(voucherEntry.FLocalAmount ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FLocalAmount*(voucherEntry.FEntryDC * 2 -1) ");
                }
            }
            if (this._currency.getNumber().equals("GRC")) {
                if (this.isDouble()) {
                    if (this.isGetAccountAccrual()) {
                        accountCount = this.getSameAcountCountIgnoreAsstItems();
                        if (accountCount != null) {
                            sqlSelInit.append("(case when sum(voucherEntry.FReportingAmount)/" + accountCount[1] + " < sum(veB.FReportingAmount)/" + accountCount[0] + " then sum(voucherEntry.FReportingAmount)/" + accountCount[1] + " else sum(veB.FReportingAmount)/" + accountCount[0] + " end  ");
                        } else {
                            sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount else veB.FReportingAmount end ) ");
                        }
                    } else {
                        sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) else veB.FReportingAmount*(veB.FEntryDC * 2 -1) end ) ");
                    }
                } else if (isHaseAcctType) {
                    if (this.isGetAccountAccrual()) {
                        sqlSelInit.append("sum(A_Record.FReportingAmount ");
                    } else {
                        sqlSelInit.append("sum(A_Record.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) ");
                    }
                } else if (this.isGetAccountAccrual()) {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount*(voucherEntry.FEntryDC * 2 -1) ");
                }
            }
            if (this.isGetAverageBalance()) {
                if (isHaseAcctType) {
                    sqlSelInit.append(" * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(this._endDate.getTime()) + "}))) value ");
                } else {
                    sqlSelInit.append(" * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(this._endDate.getTime()) + "}))) value ");
                }
            } else {
                sqlSelInit.append(" ) value ");
            }
        } else {
            if (RptUtil.findString(this._vchGetType.getName(), ",C,Y,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FOriginalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            } else if (RptUtil.findString(this._vchGetType.getName(), ",TC,TY,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FlocalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FlocalAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            } else if (RptUtil.findString(this._vchGetType.getName(), ",ZTC,ZTY,")) {
                if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount * (voucherEntry.FEntryDC * 2 -1)) value ");
                }
            }
            if (this.isGetAverageBalance()) {
                if (this._vchGetType.getValue() == 9) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FOriginalAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FOriginalAmount ");
                    }
                } else if (this._vchGetType.getValue() == 16) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FlocalAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FlocalAmount ");
                    }
                } else if (this._vchGetType.getValue() == 17) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum(A_Record.FReportingAmount ");
                    } else {
                        sqlSelInit.append("sum(voucherEntry.FReportingAmount ");
                    }
                }
                if (isHaseAcctType) {
                    sqlSelInit.append("*( voucherEntry.FEntryDC * 2 -1) * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(this._endDate.getTime()) + "}))) value ");
                } else {
                    sqlSelInit.append("*( voucherEntry.FEntryDC * 2 -1) * (1 + Datediff(dd,voucher.FBookedDate,{" + sDateFormat.format(this._endDate.getTime()) + "}))) value ");
                }
            }
            if (this._vchGetType.getValue() == 10 || this._vchGetType.getValue() == 11) {
                if (this.isDouble()) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FOriginalAmount < veB.FOriginalAmount then voucherEntry.FOriginalAmount*A_Record.FOriginalAmount/veB.FOriginalAmount  else veB.FOriginalAmount end )) value ");
                    } else {
                        int[] accountCount = this.getSameAcountCountIgnoreAsstItems();
                        if (accountCount == null) {
                            sqlSelInit.append("sum((case when voucherEntry.FOriginalAmount < veB.FOriginalAmount then voucherEntry.FOriginalAmount else veB.FOriginalAmount end )) value ");
                        } else {
                            sqlSelInit.append("case when sum(voucherEntry.FOriginalAmount)/" + accountCount[1] + " < sum(veB.FOriginalAmount)/" + accountCount[0] + " then sum(voucherEntry.FOriginalAmount)/" + accountCount[1] + " else sum(veB.FOriginalAmount)/" + accountCount[0] + " end  value ");
                        }
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FOriginalAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FOriginalAmount) value ");
                }
            } else if (this._vchGetType.getValue() == 12 || this._vchGetType.getValue() == 13) {
                if (this.isDouble()) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FlocalAmount < veB.FlocalAmount then voucherEntry.FlocalAmount*A_Record.FlocalAmount/veB.FlocalAmount else veB.FlocalAmount end )) value ");
                    } else {
                        int[] accountCount = this.getSameAcountCountIgnoreAsstItems();
                        if (accountCount != null) {
                            sqlSelInit.append("case when sum(voucherEntry.FlocalAmount)/" + accountCount[1] + " < sum(veB.FlocalAmount)/" + accountCount[0] + " then sum(voucherEntry.FlocalAmount)/" + accountCount[1] + " else sum(veB.FlocalAmount)/" + accountCount[0] + " end  value ");
                        } else {
                            sqlSelInit.append("sum((case when voucherEntry.FlocalAmount < veB.FlocalAmount then voucherEntry.FlocalAmount else veB.FlocalAmount end )) value ");
                        }
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FlocalAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FlocalAmount) value ");
                }
            } else if (this._vchGetType.getValue() == 14 || this._vchGetType.getValue() == 15) {
                if (this.isDouble()) {
                    if (isHaseAcctType) {
                        sqlSelInit.append("sum((case when A_Record.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount*A_Record.FReportingAmount/veB.FReportingAmount else veB.FReportingAmount end )) value ");
                    } else {
                        int[] accountCount = this.getSameAcountCountIgnoreAsstItems();
                        if (accountCount != null) {
                            sqlSelInit.append("case when sum(voucherEntry.FReportingAmount)/" + accountCount[1] + " < sum(veB.FReportingAmount)/" + accountCount[0] + " then sum(voucherEntry.FReportingAmount)/" + accountCount[1] + " else sum(veB.FReportingAmount)/" + accountCount[0] + " end  value ");
                        } else {
                            sqlSelInit.append("sum((case when voucherEntry.FReportingAmount < veB.FReportingAmount then voucherEntry.FReportingAmount else veB.FReportingAmount end )) value ");
                        }
                    }
                } else if (isHaseAcctType) {
                    sqlSelInit.append("sum(A_Record.FReportingAmount) value ");
                } else {
                    sqlSelInit.append("sum(voucherEntry.FReportingAmount) value ");
                }
            }
        }
        return sqlSelInit;
    }

    private int[] getSameAcountCountIgnoreAsstItems() {
        if (this._accountItem == null || this._accountItem.getAccountAsstItem() == null) {
            return null;
        }
        String accountNumber = this._accountItem.getAccountAsstItem().startNumber != null ? this._accountItem.getAccountAsstItem().startNumber : this._accountItem.getAccountAsstItem().endNumber;
        String accountEndNumber = null;
        if (this._accountItem.getAccountAsstItem().endNumber != null && !this._accountItem.getAccountAsstItem().endNumber.equals(this._accountItem.getAccountAsstItem().startNumber)) {
            accountEndNumber = this._accountItem.getAccountAsstItem().endNumber;
        }
        if (accountNumber == null) {
            return null;
        }
        if (this._oppAccountItem == null || this._oppAccountItem.getAccountAsstItem() == null) {
            return null;
        }
        String oppAccountNumber = this._oppAccountItem.getAccountAsstItem().startNumber != null ? this._oppAccountItem.getAccountAsstItem().startNumber : this._oppAccountItem.getAccountAsstItem().endNumber;
        String oppAccountEndNumber = null;
        if (this._oppAccountItem.getAccountAsstItem().endNumber != null && !this._oppAccountItem.getAccountAsstItem().endNumber.equals(this._oppAccountItem.getAccountAsstItem().startNumber)) {
            oppAccountEndNumber = this._oppAccountItem.getAccountAsstItem().endNumber;
        }
        if (oppAccountNumber == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        ArrayList<String> params = new ArrayList<String>();
        sql.append("select count(voucherEntry.fid) value,voucherEntry.FEntryDC dc, TempNumber.number number,voucherEntry.FBillID voucherID from T_GL_VoucherEntry voucherEntry\t \n");
        sql.append("inner join T_GL_Voucher voucher on \tvoucherEntry.FBillID = voucher.fid \n");
        sql.append("inner join T_BD_AccountView account on voucherEntry.FAccountID = account.Fid  \n");
        sql.append("inner join T_BD_Currency Currency on voucherEntry.FCurrencyID = Currency.FID  \n");
        sql.append("inner join (select '").append(accountNumber).append("' as number ,0 as dir\t\n");
        if (accountEndNumber != null) {
            sql.append("  union select '").append(accountEndNumber).append("' as number,1 as dir \n");
        }
        if (oppAccountEndNumber != null) {
            sql.append("  union select '").append(oppAccountEndNumber).append("' as number,3 as dir \n");
        }
        sql.append("  union select '").append(oppAccountNumber).append("' as number,2 as dir )\t\n");
        sql.append("TempNumber on charindex(TempNumber.number,account.Fnumber)=1 ");
        if (accountEndNumber != null) {
            sql.append(" or ((TempNumber.number <= account.Fnumber and TempNumber.dir = 0 ) ");
            sql.append(" and (TempNumber.number >= account.Fnumber and TempNumber.dir = 1 )) ");
        }
        if (oppAccountEndNumber != null) {
            sql.append(" or ((TempNumber.number <= account.Fnumber and TempNumber.dir = 2 ) ");
            sql.append(" and (TempNumber.number >= account.Fnumber and TempNumber.dir = 3 )) ");
        }
        if (!StringUtils.isEmpty((String)this._userDefineFilter) && this._userDefineFilter.indexOf("VoucherType") > -1 && this.isGetAccrualAmount()) {
            sql.append("inner join T_BD_VoucherTypes VoucherType on VoucherType.FID = voucher.FVoucherTypeID \t\n");
        }
        sql.append("where voucher.FCompanyID = ?\t\t\n");
        params.add(this._company.getId().toString());
        sql.append("and account.FAccountTableID=? \t\t\n");
        params.add(this._company.getAccountTable().getId().toString());
        if (this._currency != null && !RptUtil.findString(this._currency.getNumber(), ",GLC,GRC,")) {
            sql.append("and voucherEntry.FCurrencyID=? \t\t\n");
            params.add(this._currency.getId().toString());
        }
        if (!StringUtils.isEmpty((String)this._userDefineFilter)) {
            sql.append(" and (" + this.reviseFilter(this._userDefineFilter) + ") \t\t\n");
        }
        Date startDate1 = this._startDate.getTime();
        Date endDate1 = this._endDate.getTime();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        sql.append("and voucher.FBookedDate>= {" + sDateFormat.format(startDate1) + "}  \t\t\n");
        sql.append("and voucher.FBookedDate <= {" + sDateFormat.format(endDate1) + "}  \t\t\n");
        sql.append("and voucher.FBizStatus <>0 and voucher.FBizStatus <>2 and account.FIsLeaf = 1 ");
        if (!this._isincludingUnPosted) {
            sql.append(" and voucher.FBizStatus=5 ");
        }
        sql.append("group by voucherEntry.FEntryDC,TempNumber.number,voucherEntry.FBillID");
        try {
            IRowSet row = DbUtil.executeQuery((Context)this._context, (String)sql.toString(), (Object[])params.toArray());
            Set voucherID = this.getvoucherID(row, accountNumber, accountEndNumber, oppAccountNumber, oppAccountEndNumber);
            if (voucherID == null) {
                return null;
            }
            boolean isDebit = this.isDebit();
            int baseAccountCount = 0;
            int oppAccountCount = 0;
            while (row.next()) {
                if (!voucherID.contains(row.getString("voucherID"))) continue;
                if (isDebit) {
                    if (row.getInt("dc") == 1 && (accountNumber.equals(row.getString("number")) || row.getString("number").equals(accountEndNumber))) {
                        baseAccountCount += row.getInt("value");
                        continue;
                    }
                    if (row.getInt("dc") != 0 || !oppAccountNumber.equals(row.getString("number")) && !row.getString("number").equals(oppAccountEndNumber)) continue;
                    oppAccountCount += row.getInt("value");
                    continue;
                }
                if (row.getInt("dc") == 0 && (accountNumber.equals(row.getString("number")) || row.getString("number").equals(accountEndNumber))) {
                    baseAccountCount += row.getInt("value");
                    continue;
                }
                if (row.getInt("dc") != 1 || !oppAccountNumber.equals(row.getString("number")) && !row.getString("number").equals(oppAccountEndNumber)) continue;
                oppAccountCount += row.getInt("value");
            }
            int[] result = new int[]{baseAccountCount, oppAccountCount};
            if (baseAccountCount == 0 || oppAccountCount == 0) {
                return null;
            }
            return result;
        }
        catch (BOSException e) {
            log.debug((Object)e.getMessage());
            return null;
        }
        catch (SQLException e) {
            log.debug((Object)e.getMessage());
            return null;
        }
    }

    private Set getvoucherID(IRowSet row, String accountNumber, String accountEndNumber, String oppAccountNumber, String oppAccountEndNumber) throws SQLDataException {
        try {
            HashSet<String> creditSet = new HashSet<String>();
            HashSet<String> debitSet = new HashSet<String>();
            boolean isDebit = this.isDebit();
            while (row.next()) {
                if (isDebit) {
                    if (row.getInt("dc") == 1 && (accountNumber.equals(row.getString("number")) || row.getString("number").equals(accountEndNumber))) {
                        creditSet.add(row.getString("voucherID"));
                        continue;
                    }
                    if (row.getInt("dc") != 0 || !oppAccountNumber.equals(row.getString("number")) && !row.getString("number").equals(oppAccountEndNumber)) continue;
                    debitSet.add(row.getString("voucherID"));
                    continue;
                }
                if (row.getInt("dc") == 0 && (accountNumber.equals(row.getString("number")) || row.getString("number").equals(accountEndNumber))) {
                    creditSet.add(row.getString("voucherID"));
                    continue;
                }
                if (row.getInt("dc") != 1 || !oppAccountNumber.equals(row.getString("number")) && !row.getString("number").equals(oppAccountEndNumber)) continue;
                debitSet.add(row.getString("voucherID"));
            }
            row.beforeFirst();
            creditSet.retainAll(debitSet);
            if (creditSet.isEmpty()) {
                return null;
            }
            return creditSet;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    private boolean isDebit() {
        if (!this.isGetAccrualAmount()) {
            return false;
        }
        return 10 == this._vchGetType.getValue() || 12 == this._vchGetType.getValue() || 14 == this._vchGetType.getValue();
    }

    private boolean isCredit() {
        if (!this.isGetAccrualAmount()) {
            return false;
        }
        return 11 == this._vchGetType.getValue() || 13 == this._vchGetType.getValue() || 15 == this._vchGetType.getValue();
    }

    private StringBuffer constructFrom() throws EASBizException {
        StringBuffer sqlFrom = new StringBuffer(" From T_GL_Voucher voucher, T_GL_VoucherEntry voucherEntry, T_BD_Currency Currency, T_BD_AccountView A_Account ");
        if (this.isGetAccrualAmount() && this.isDouble()) {
            sqlFrom.append(" ,T_GL_VoucherEntry veB ,T_BD_AccountView B_Account ");
        }
        return sqlFrom;
    }

    private StringBuffer constructWhere() throws EASBizException {
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" where voucher.FID = voucherEntry.FBillID                                           \n").append(" and voucherEntry.FCurrencyID = Currency.FID and voucherEntry.FAccountID = A_Account.Fid    \n").append(" and voucher.FCompanyID = ? and A_Account.FAccountTableID = ?                               \n").append(" and voucher.FBizStatus <> 0 and voucher.FBizStatus <> 2                                    \n");
        this.sqlParams.add(this._company.getId().toString());
        this.sqlParams.add(this._company.getAccountTable().getId().toString());
        if (this._currency != null && !RptUtil.findString(this._currency.getNumber(), ",GLC,GRC,")) {
            sqlWhere.append(" and voucherEntry.FCurrencyID = ?   \n");
            this.sqlParams.add(this._currency.getId().toString());
        }
        if (this.isGetAccrualAmount()) {
            if (!StringUtils.isEmpty((String)this._userDefineFilter)) {
                if (this._userDefineFilter.indexOf("VoucherType") > -1) {
                    sqlWhere.append(" and VoucherType.FID = voucher.FVoucherTypeID    \n");
                }
                sqlWhere.append(" and (" + this.reviseFilter(this._userDefineFilter) + ")       \n");
            }
            if (RptUtil.findString(this._vchGetType.getName(), ",JF,TJF,ZJF,FQJF,JA,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC = ?                       \n");
                this.sqlParams.add(new Integer(1));
            }
            if (RptUtil.findString(this._vchGetType.getName(), ",DF,TDF,ZDF,FQDF,DA,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC = ?                       \n");
                this.sqlParams.add(new Integer(0));
            }
            if (RptUtil.findString(this._vchGetType.getName(), ",QJF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC*2-1 = A_Account.fdc       \n");
            }
            if (RptUtil.findString(this._vchGetType.getName(), ",QDF,")) {
                sqlWhere.append(" and voucherEntry.FEntryDC*2-1 != A_Account.fdc      \n");
            }
            if (this.isDouble()) {
                sqlWhere.append(" and veB.FAccountID = B_Account.FID                  \n").append(" and veB.FBillId = voucherEntry.FBillId                      \n").append(" and veB.FCurrencyID = Currency.FID                          \n").append(" and veB.FEntryDc <> voucherEntry.FEntryDc                   \n");
            }
        }
        return sqlWhere;
    }

    private String reviseFilter(String filter) {
        filter = filter.replaceAll("VoucherNumber", "voucher.FNumber").replaceAll("AttachementNumber", "voucher.FAttachments").replaceAll("CountAmount", "voucher.FLocalDebitAmount").replaceAll("RecNum", "voucher.FEntryCount").replaceAll("RecSrcNumber", "voucherEntry.FOriginalAmount").replaceAll("VoucherType", "VoucherType.FNumber").replaceAll("RefInformation", "voucher.FDescription").replaceAll("Summary", "voucherEntry.FDescription");
        return filter;
    }

    private StringBuffer constructOtherWhere(StringBuffer sqlFrom, StringBuffer sqlWhere) throws BOSException, EASBizException {
        StringBuffer sqlWhereOther = new StringBuffer();
        Date startDate1 = this._startDate.getTime();
        Date endDate1 = this._endDate.getTime();
        SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (this._endDate != null && this._startDate != null) {
            try {
                if (this.isGetAccrualAmount()) {
                    sqlWhereOther.append(" and voucher.FBookedDate>= {" + sDateFormat.format(startDate1) + "} ");
                }
                if (RptUtil.findString(this._vchGetType.getName(), ",C,Y,TC,TY,ZTC,ZTY,")) {
                    if (this._endPeriod != null) {
                        sqlWhereOther.append(" and voucher.FBookedDate >= {" + this._endPeriod.getBeginDate().toString() + "}");
                    } else {
                        throw new ReportException(ReportException.ACCTEXT_NULL_PERIOD);
                    }
                }
                if (this.isGetAverageBalance()) {
                    sqlWhereOther.append(" and voucher.FBookedDate >= {" + sDateFormat.format(startDate1) + "}");
                }
                sqlWhereOther.append(" and voucher.FBookedDate <= {" + sDateFormat.format(endDate1) + "}");
            }
            catch (Exception exc) {
                throw new ReportException(ReportException.EXECP_ACCTEXT_NOPERIOD, (Throwable)exc);
            }
        }
        if (this.isGetAccrualAmount()) {
            this.retItemCodeSqlNew("A_Account.Fnumber", this._accountItem, true, sqlFrom, sqlWhere, sqlWhere, false);
        } else {
            sqlWhereOther.append(" and charIndex(Out_Account.Fnumber,A_Account.Fnumber)=1 ");
        }
        if (this.isGetAccrualAmount() && this.isDouble() && this._oppAccountItem != null) {
            this.constructOppItemSql("B_Account.Fnumber", this._oppAccountItem, true, sqlFrom, sqlWhere, sqlWhere);
        }
        if (!this._isincludingUnPosted) {
            sqlWhereOther.append(" and voucher.FBizStatus=5 ");
        }
        sqlWhereOther.append(" and A_Account.FIsLeaf = 1");
        if (this.isGetAccrualAmount() && this.isDouble()) {
            sqlWhereOther.append(" and B_Account.FIsLeaf = 1");
        }
        if (!this.isGetAccrualAmount()) {
            sqlWhereOther.append(") value From T_Bd_AccountView Out_Account ");
            StringBuffer tempWhere = new StringBuffer(" Where Out_Account.FCompanyID = ? ");
            this.sqlParams.add(this._company.getId().toString());
            tempWhere.append(" AND Out_Account.FAccountTableID = ? ");
            this.sqlParams.add(this._company.getAccountTable().getId().toString());
            this.retItemCodeSqlNew("Out_Account.Fnumber", this._accountItem, false, sqlFrom, sqlWhere, tempWhere, false);
            sqlWhereOther.append(tempWhere);
        }
        return sqlWhereOther;
    }

    private void retItemCodeSqlNew(String strColName, AccountItem accountItem, boolean isLike, StringBuffer sqlfrom, StringBuffer sqlWhere, StringBuffer sqlItemFilter, boolean isOtherAccount) throws BOSException, EASBizException {
        if (accountItem.isSingleAccount()) {
            if (isLike) {
                sqlItemFilter.append(" and " + strColName + " like ?");
                this.sqlParams.add(accountItem.startAccount.number + "%");
            } else {
                sqlItemFilter.append(" and " + strColName + " = ? ");
                this.sqlParams.add(accountItem.startAccount.number);
            }
        } else {
            if (accountItem.startAccount.number.length() > 0) {
                sqlItemFilter.append(" and " + strColName + " >= ? ");
                this.sqlParams.add(accountItem.startAccount.number);
            }
            if (accountItem.endAccount.number != null && accountItem.endAccount.number.length() > 0) {
                sqlItemFilter.append(" and " + strColName + " <= ? ");
                this.sqlParams.add(this._accountItem.endAccount.number + "z");
            }
        }
        if (accountItem.hasItem()) {
            if (!this.isGetAccrualAmount()) {
                this.constructAcctItem(sqlfrom, sqlWhere, sqlWhere, isOtherAccount);
            } else {
                this.constructAcctItem(sqlfrom, sqlWhere, sqlItemFilter, isOtherAccount);
            }
        }
    }

    private void constructAcctItem(StringBuffer strSqlFromWhere, StringBuffer sqlWhere, StringBuffer strItemFilter, boolean isOtherAccount) throws BOSException, EASBizException {
        strSqlFromWhere.append(",T_BD_AssistantHG A_Hg,T_GL_VoucherAssistRecord A_Record ");
        if (isOtherAccount) {
            sqlWhere.append(" and veB.fid = A_Record.FEntryID ");
        } else {
            sqlWhere.append(" and voucherEntry.fid = A_Record.FEntryID ");
        }
        strItemFilter.append(" and A_Record.FAssGrpID = A_Hg.fid ");
        int iRow = 0;
        this.itemFromCluster = new StringBuffer[this._accountItem.itemSize()];
        this.itemWhereCluster = new StringBuffer[this._accountItem.itemSize()];
        Set set = this._accountItem.itemSet();
        for (String strItemType : set) {
            AssistantItem asstItem = this._accountItem.getItem(strItemType);
            String strTableName = asstItem.itemType.realtionDataObject;
            String strTableAlias = "A_AsstType" + ++iRow;
            String strFieldName = asstItem.itemType.mappingFieldName;
            String strNumber = asstItem.itemType.number;
            this.itemFromCluster[iRow - 1] = new StringBuffer();
            this.itemFromCluster[iRow - 1].append("," + strTableName + " " + strTableAlias);
            this.itemWhereCluster[iRow - 1] = new StringBuffer();
            this.itemWhereCluster[iRow - 1].append(" and A_Hg." + strFieldName + "=" + strTableAlias + ".FID ");
            String itemNumberName = "FNumber";
            if (asstItem.itemType.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                this.itemWhereCluster[iRow - 1].append(" and " + strTableAlias + ".FGroupID= '" + asstItem.itemType.glAsstActTypeGrpID + "'");
                itemNumberName = "FLongNumber";
            } else if (asstItem.itemType.useLongNumber) {
                itemNumberName = "FLongNumber";
                asstItem.startItem.longNumber = asstItem.startItem.number = asstItem.startItem.number.replaceAll("\\.", "!");
                asstItem.endItem.longNumber = asstItem.endItem.number = asstItem.endItem.number.replaceAll("\\.", "!");
            }
            if (asstItem.startItem != null && asstItem.startItem.number != null && asstItem.endItem != null && asstItem.startItem.number.equals(asstItem.endItem.number) && asstItem.startItem.number.length() > 0) {
                this.itemWhereCluster[iRow - 1].append(" and (" + strTableAlias + "." + itemNumberName + " = '" + asstItem.startItem.number + "' ").append(" or " + strTableAlias + "." + itemNumberName + " like '" + asstItem.startItem.number + "!%')");
                continue;
            }
            if (asstItem.startItem != null && asstItem.startItem.number != null && asstItem.startItem.number.length() > 0) {
                this.itemWhereCluster[iRow - 1].append(" and " + strTableAlias + "." + itemNumberName + " >= '" + asstItem.startItem.number + "' ");
            }
            if (asstItem.endItem == null || asstItem.endItem.number == null || asstItem.endItem.number.length() <= 0) continue;
            this.itemWhereCluster[iRow - 1].append(" and (" + strTableAlias + "." + itemNumberName + " <= '" + asstItem.endItem.number + "' ").append(" or " + strTableAlias + "." + itemNumberName + " like '" + asstItem.startItem.number + "!%')");
        }
        if (iRow == 0) {
            throw new ReportException(ReportException.ACCTITEMTYPE_NOT_FOUND);
        }
    }

    private void constructOppItemSql(String strColName, AccountItem accountItem, boolean isLike, StringBuffer sqlfrom, StringBuffer sqlWhere, StringBuffer sqlItemFilter) throws BOSException, EASBizException {
        if (accountItem.isSingleAccount()) {
            if (isLike) {
                sqlItemFilter.append(" and " + strColName + " like ?");
                this.sqlParams.add(accountItem.startAccount.number + "%");
            } else {
                sqlItemFilter.append(" and " + strColName + " = ? ");
                this.sqlParams.add(accountItem.startAccount.number);
            }
        } else {
            if (accountItem.startAccount.number.length() > 0) {
                sqlItemFilter.append(" and " + strColName + " >= ? ");
                this.sqlParams.add(accountItem.startAccount.number);
            }
            if (accountItem.endAccount.number != null && accountItem.endAccount.number.length() > 0) {
                sqlItemFilter.append(" and " + strColName + " <= ? ");
                this.sqlParams.add(accountItem.endAccount.number + "%");
            }
        }
        if (accountItem.hasItem()) {
            if (!this.isGetAccrualAmount()) {
                this.constructOppItem(sqlfrom, sqlWhere, sqlWhere);
            } else {
                this.constructOppItem(sqlfrom, sqlWhere, sqlItemFilter);
            }
        }
    }

    private void constructOppItem(StringBuffer strSqlFromWhere, StringBuffer sqlWhere, StringBuffer strItemFilter) throws BOSException, EASBizException {
        strSqlFromWhere = strSqlFromWhere.append(",T_BD_AssistantHG A_Hg,T_GL_VoucherAssistRecord A_Record ");
        sqlWhere.append(" and veB.fid = A_Record.FEntryID ");
        strItemFilter.append(" and A_Record.FAssGrpID = A_Hg.fid ");
        int iRow = 0;
        Set set = this._accountItem.itemSet();
        for (String strItemType : set) {
            AssistantItem asstItem = this._accountItem.getItem(strItemType);
            String strTableName = asstItem.itemType.realtionDataObject;
            String strTableAlias = "A_AsstType" + ++iRow;
            String strFieldName = asstItem.itemType.mappingFieldName;
            String strNumber = asstItem.itemType.number;
            strSqlFromWhere = strSqlFromWhere.append("," + strTableName + " " + strTableAlias);
            strItemFilter = strItemFilter.append(" and A_Hg." + strFieldName + "=" + strTableAlias + ".FID ");
            String itemNumberName = "FNumber";
            if (asstItem.itemType.realtionDataObject.equalsIgnoreCase("T_BD_GeneralAsstActType")) {
                this.itemWhereCluster[iRow - 1].append(" and " + strTableAlias + ".FGroupID= '" + asstItem.itemType.glAsstActTypeGrpID + "'");
                itemNumberName = "FLongNumber";
            } else if (asstItem.itemType.useLongNumber) {
                itemNumberName = "FLongNumber";
                asstItem.startItem.longNumber = asstItem.startItem.number = asstItem.startItem.number.replaceAll("\\.", "!");
                asstItem.endItem.longNumber = asstItem.endItem.number = asstItem.endItem.number.replaceAll("\\.", "!");
            }
            if (asstItem.startItem != null && asstItem.startItem.number.equals(asstItem.endItem.number)) {
                strItemFilter = strItemFilter.append(" and " + strTableAlias + "." + itemNumberName + " = '" + asstItem.startItem.number + "' ");
                continue;
            }
            if (asstItem.startItem != null && asstItem.startItem.number.length() > 0) {
                strItemFilter = strItemFilter.append(" and " + strTableAlias + "." + itemNumberName + " >= '" + asstItem.startItem.number + "' ");
            }
            if (asstItem.endItem == null || asstItem.endItem.number == null || asstItem.endItem.number.length() <= 0) continue;
            strItemFilter = strItemFilter.append(" and " + strTableAlias + "." + itemNumberName + " <= '" + asstItem.endItem.number + "' ");
        }
        if (iRow == 0) {
            throw new ReportException(ReportException.ACCTITEMTYPE_NOT_FOUND);
        }
    }

    private boolean isDouble() {
        if (this.isGetAccrualAmount()) {
            return this._oppAccountItem != null;
        }
        return false;
    }

    private boolean isGetAccrualAmount() {
        return this.isGetAccountAccrual() || this.isGetQuantity() || this.isGetAssistQuantity() || this.isGetJDAmount();
    }

    private boolean isGetJDAmount() {
        switch (this._vchGetType.getValue()) {
            case 20: {
                return true;
            }
            case 21: {
                return true;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetQuantity() {
        switch (this._vchGetType.getValue()) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetAssistQuantity() {
        switch (this._vchGetType.getValue()) {
            case 18: {
                return true;
            }
            case 19: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetAccountAccrual() {
        switch (this._vchGetType.getValue()) {
            case 10: {
                return true;
            }
            case 11: {
                return true;
            }
            case 12: {
                return true;
            }
            case 13: {
                return true;
            }
            case 14: {
                return true;
            }
            case 15: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetInitialAmount() {
        switch (this._vchGetType.getValue()) {
            case 1: {
                return true;
            }
            case 5: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetAverageBalance() {
        switch (this._vchGetType.getValue()) {
            case 9: {
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                return true;
            }
        }
        return false;
    }

    private boolean isGetBalance() {
        switch (this._vchGetType.getValue()) {
            case 2: {
                return true;
            }
            case 6: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    private PeriodInfo getPeriodByDate(Calendar date, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        PeriodCollection coll = RptUtilForServer.getPeriodByDateAtServer(this._context, date.getTime(), date.getTime(), company);
        if (coll == null) {
            return null;
        }
        Iterator itPeriod = coll.iterator();
        if (itPeriod.hasNext()) {
            return (PeriodInfo)itPeriod.next();
        }
        return null;
    }

    private Set getAnalyzedCompanyNumberList(String companyNumbers) throws BOSException {
        String[] companyNumber = companyNumbers.split(";\\s*");
        StringBuffer sql = new StringBuffer();
        sql.append("Select FLongNumber from T_ORG_Company where FNumber in ").append(this.createInCompanySQL(companyNumber));
        IRowSet rowSet = DbUtil.executeQuery((Context)this._context, (String)sql.toString());
        ArrayList<String> longNumberList = new ArrayList<String>();
        try {
            while (rowSet.next()) {
                longNumberList.add(rowSet.getString("FLongNumber"));
            }
        }
        catch (SQLException e1) {
            throw new SQLDataException(e1);
        }
        sql.setLength(0);
        sql.append("Select FNumber from T_ORG_Company where \t\n");
        sql.append(this.createLikeCompanySQL(longNumberList));
        sql.append("and FIsLeaf = 1 \n");
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        IRowSet rs = DbUtil.executeQuery((Context)this._context, (String)sql.toString());
        try {
            while (rs.next()) {
                result.add(rs.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return result;
    }

    private String createInCondition(Iterator iterator) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        while (iterator.hasNext()) {
            if (first) {
                sql.append(" '").append(iterator.next()).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(iterator.next()).append("' ");
        }
        sql.append(") ");
        return sql.toString();
    }

    private String createInCompanySQL(String[] companyNumber) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        for (int i = 0; i < companyNumber.length; ++i) {
            if (first) {
                sql.append(" '").append(companyNumber[i]).append("' ");
                first = false;
                continue;
            }
            sql.append(" ,'").append(companyNumber[i]).append("' ");
        }
        sql.append(") \n");
        return sql.toString();
    }

    private String createLikeCompanySQL(List companyLongNumber) {
        boolean first = true;
        StringBuffer sql = new StringBuffer("(");
        for (int i = 0; i < companyLongNumber.size(); ++i) {
            String longNumber = (String)companyLongNumber.get(i);
            if (first) {
                sql.append(" ( FLongNumber = '").append(longNumber).append("' or FLongNumber like '").append(companyLongNumber.get(i)).append("!%' )");
                first = false;
                continue;
            }
            sql.append(" OR ( FLongNumber = '").append(longNumber).append("'  or FLongNumber like '").append(companyLongNumber.get(i)).append("!%' )");
        }
        sql.append(")\t\n");
        return sql.toString();
    }

    private class AcctExtCompanyCondition {
        CompanyOrgUnitInfo _company;
        private PeriodInfo _startPeriod;
        private PeriodInfo _endPeriod;
        private AccountItem _accountItem;
        private AccountItem _oppAccountItem;

        private AcctExtCompanyCondition() {
        }
    }
}

