/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.AcctAASubQuery;
import com.kingdee.eas.fi.rpt.app.AcctBASubQuery;
import com.kingdee.eas.fi.rpt.app.AcctBBSubQuery;
import com.kingdee.eas.fi.rpt.app.AcctBCSubQuery;
import com.kingdee.eas.fi.rpt.app.AcctCASubQuery;
import com.kingdee.eas.fi.rpt.app.AcctCalculaterExt;
import com.kingdee.eas.fi.rpt.app.AcctDASubQuery;
import com.kingdee.eas.fi.rpt.app.AcctSubQuery;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.QuerySolution;
import com.kingdee.eas.fi.rpt.app.Sorter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class AcctQuery
extends Sorter {
    protected static final HashMap[] subQueryBSorter = new HashMap[]{new HashMap(1), new HashMap(1), new HashMap(1)};
    private int subQuerySortTypeIndex = 0;
    private String subQuerySortKey;
    private int itemSortKeyIndex = 0;
    private ArrayList array = new ArrayList();
    private int currentItemSortKey;

    public AcctQuery(QueryCommand qc) {
        super(qc);
        for (int i = 0; i < 10; ++i) {
            this.array.add(null);
        }
    }

    @Override
    protected QuerySolution createQuerySolution() {
        switch (this.subQuerySortTypeIndex) {
            case 1: {
                return new AcctAASubQuery(this.queryCommand);
            }
            case 2: {
                return new AcctBASubQuery(this.queryCommand);
            }
            case 3: {
                return new AcctBBSubQuery(this.queryCommand);
            }
            case 4: {
                return new AcctBCSubQuery(this.queryCommand);
            }
            case 5: {
                return new AcctCASubQuery(this.queryCommand);
            }
            case 6: {
                return new AcctDASubQuery(this.queryCommand);
            }
        }
        return null;
    }

    private void generateSubQuerySortKey(AcctCalculaterExt acct) {
        if (!acct.getAccountItem().hasItem()) {
            if (acct.getAccountItem().isDetailAccount()) {
                this.subQuerySortTypeIndex = 1;
                this.subQuerySortKey = "AA";
            } else {
                for (int i = 0; i < 3; ++i) {
                    if (subQueryBSorter[i].get(acct.getBalanceType().getName()) == null) continue;
                    switch (i) {
                        case 0: {
                            this.subQuerySortTypeIndex = 2;
                            this.subQuerySortKey = "BA";
                            break;
                        }
                        case 1: {
                            this.subQuerySortTypeIndex = 3;
                            this.subQuerySortKey = "BB";
                            break;
                        }
                        case 2: {
                            this.subQuerySortTypeIndex = 4;
                            this.subQuerySortKey = "BC";
                        }
                    }
                    break;
                }
            }
        } else if (acct.getAccountItem().isDetailAccount()) {
            this.subQuerySortTypeIndex = 5;
            this.subQuerySortKey = "CA";
        } else {
            this.subQuerySortTypeIndex = 6;
            this.subQuerySortKey = "DA";
        }
    }

    private void generateItemSetSortKey(AcctCalculaterExt _acct) {
        this.currentItemSortKey = -1;
        ArrayList itemNubmerList = _acct.getAccountItem().getItemNumbers();
        ArrayList<Items> subTypeGroup = (ArrayList<Items>)this.array.get(itemNubmerList.size());
        if (subTypeGroup == null) {
            subTypeGroup = new ArrayList<Items>();
            this.array.set(itemNubmerList.size(), subTypeGroup);
        }
        for (Items items : subTypeGroup) {
            this.currentItemSortKey = items.isBelongThis(itemNubmerList);
            if (this.currentItemSortKey == -1) continue;
            break;
        }
        if (this.currentItemSortKey == -1) {
            Items items;
            this.currentItemSortKey = this.itemSortKeyIndex++;
            items = new Items(itemNubmerList, this.currentItemSortKey);
            subTypeGroup.add(items);
        }
    }

    public void add(AcctCalculaterExt _acct) {
        this.generateSubQuerySortKey(_acct);
        if (!(this.subQuerySortTypeIndex != 5 && this.subQuerySortTypeIndex != 6 || _acct.checkItem())) {
            return;
        }
        StringBuffer key = new StringBuffer();
        key.append(this.subQuerySortKey);
        key.append("|");
        key.append("(");
        key.append(_acct.getCompany().getId().toString());
        key.append("|");
        key.append(_acct.getCurrency().getId().toString());
        key.append("|");
        key.append(_acct.getStrPeriodID());
        key.append("|");
        key.append(_acct.getIBalType());
        key.append(")");
        if (this.subQuerySortTypeIndex == 5 || this.subQuerySortTypeIndex == 6) {
            this.generateItemSetSortKey(_acct);
            key.append(this.currentItemSortKey);
        }
        if (this.subQuerySortTypeIndex == 1 || this.subQuerySortTypeIndex == 5) {
            key.append("|");
            key.append(_acct.getAccountItem().startAccount.account.dc);
        }
        AcctSubQuery acctSubQuery = (AcctSubQuery)this.getQuerySoulation(key.toString());
        acctSubQuery.add(_acct);
    }

    static {
        subQueryBSorter[0].put("C", "C");
        subQueryBSorter[0].put("AC", "AC");
        subQueryBSorter[0].put("Y", "Y");
        subQueryBSorter[0].put("AY", "AY");
        subQueryBSorter[0].put("SY", "SY");
        subQueryBSorter[0].put("SL", "SL");
        subQueryBSorter[0].put("TC", "TC");
        subQueryBSorter[0].put("TY", "TY");
        subQueryBSorter[0].put("TSY", "TSY");
        subQueryBSorter[0].put("TSL", "TSL");
        subQueryBSorter[0].put("RC", "RC");
        subQueryBSorter[0].put("RY", "RY");
        subQueryBSorter[0].put("RSY", "RSY");
        subQueryBSorter[0].put("RSL", "RSL");
        subQueryBSorter[0].put("QC", "QC");
        subQueryBSorter[0].put("QY", "QY");
        subQueryBSorter[0].put("QJL", "QJL");
        subQueryBSorter[1].put("JF", "JF");
        subQueryBSorter[1].put("DF", "DF");
        subQueryBSorter[1].put("JL", "JL");
        subQueryBSorter[1].put("DL", "DL");
        subQueryBSorter[1].put("TAC", "TAC");
        subQueryBSorter[1].put("TAY", "TAY");
        subQueryBSorter[1].put("TJF", "TJF");
        subQueryBSorter[1].put("TDF", "TDF");
        subQueryBSorter[1].put("TJL", "TJL");
        subQueryBSorter[1].put("TDL", "TDL");
        subQueryBSorter[1].put("RAC", "RAC");
        subQueryBSorter[1].put("RAY", "RAY");
        subQueryBSorter[1].put("RJF", "RJF");
        subQueryBSorter[1].put("RDF", "RDF");
        subQueryBSorter[1].put("RJL", "RJL");
        subQueryBSorter[1].put("RDL", "RDL");
        subQueryBSorter[1].put("QJF", "QJF");
        subQueryBSorter[1].put("QDF", "QDF");
        subQueryBSorter[1].put("QDL", "QDL");
        subQueryBSorter[2].put("JC", "JC");
        subQueryBSorter[2].put("DC", "DC");
        subQueryBSorter[2].put("JY", "JY");
        subQueryBSorter[2].put("DY", "DY");
        subQueryBSorter[2].put("TJY", "TJY");
        subQueryBSorter[2].put("TDY", "TDY");
        subQueryBSorter[2].put("RJC", "RJC");
        subQueryBSorter[2].put("RDC", "RDC");
        subQueryBSorter[2].put("RJY", "RJY");
        subQueryBSorter[2].put("RDY", "RDY");
        subQueryBSorter[2].put("TJC", "TJC");
        subQueryBSorter[2].put("TDC", "TDC");
    }

    private static class Items {
        private ArrayList array;
        private int key;

        public Items(ArrayList _array, int _key) {
            this.array = _array;
            this.key = _key;
        }

        public int isBelongThis(ArrayList _array) {
            Iterator it = _array.iterator();
            while (it.hasNext()) {
                if (this.array.contains(it.next())) continue;
                return -1;
            }
            return this.key;
        }
    }
}

