/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.eas.fi.rpt.app.GroupTreeNode;
import com.kingdee.eas.fi.rpt.app.IResultHolderListener;
import com.kingdee.eas.fi.rpt.app.QueryCommand;
import com.kingdee.eas.fi.rpt.app.QuerySolution;
import com.kingdee.eas.fi.rpt.app.ResultHolder;
import com.kingdee.eas.fi.rpt.app.WhereItem;

public class AssistantGroupQuery
extends QuerySolution {
    public AssistantGroupQuery(QueryCommand qc) {
        super(qc);
    }

    public void add(GroupTreeNode item, int type, String stdid) {
        ResultHolder rh = ResultHolder.createCommonAndShareModeResultHolder();
        rh.addIResultHolderListener(new ResultHolderListener(item, type, stdid));
        this.resultHolderSetConfig.addResultHolder(item.number + '|' + stdid, rh);
    }

    @Override
    protected void initSolutionConfig() {
        String[] groupConditionField = new String[]{"FNumber", "SFID"};
        this.resultHolderSetConfig.setGroupConditionField(groupConditionField);
        this.queryParamer.setStaticFromPart("T_BD_CSSPGroup G, T_BD_CSSPGroupStandard S");
        this.queryParamer.setStaticWherePart("G.FCSSPGroupStandardID = S.FID");
        this.queryParamer.setStaticSelectField("G.FID FID, G.FNumber FNumber, G.FLongNumber FLongNumber, G.FLevel FLevel, S.FID SFID");
    }

    private class ResultHolderListener
    extends IResultHolderListener {
        GroupTreeNode _group = null;
        int _type;
        String _standardID = null;

        public ResultHolderListener(GroupTreeNode group, int type, String stdid) {
            this._group = group;
            this._type = type;
            this._standardID = stdid;
        }

        @Override
        public String[] getResultHolderOrderedSelectFields() {
            return new String[]{"FID", "FNumber", "FLongNumber", "FLevel", "SFID"};
        }

        @Override
        public Object setResultHolderOrderedSelectFieldsValueObjects(Object[] value) {
            this._group.number = value[1].toString();
            this._group.longNumber = value[2].toString();
            this._group.level = ((Number)value[3]).intValue();
            return this._group;
        }

        @Override
        public void setResultHolderOrderedSharedObject(Object obj) {
            GroupTreeNode n = (GroupTreeNode)obj;
            this._group.level = n.level;
            this._group.longNumber = n.longNumber;
            this._group.number = n.number;
        }

        @Override
        public WhereItem generateWhereItem() {
            WhereItem where = WhereItem.createModeOneWhereItem();
            where.addItem("G.FNumber", this._group.number);
            where.addItem("S.FID", this._standardID);
            where.addItem("S.FType=0 or S.FType", new Integer(this._type));
            return where;
        }
    }
}

