/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fi.rpt.app.AbstractBizAcctActualDataProviderControllerBean;
import com.kingdee.eas.ma.bg.BgCtrlData;
import com.kingdee.eas.ma.bg.BgCtrlParam;
import com.kingdee.eas.ma.bg.BgDimensionEnum;
import com.kingdee.eas.ma.bg.BgElementEnum;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizAcctActualDataProviderControllerBean
extends AbstractBizAcctActualDataProviderControllerBean {
    private static Logger logger = Logger.getLogger(BizAcctActualDataProviderControllerBean.class);

    protected BgCtrlParam _getBizActualTotal(Context ctx, BgCtrlParam param) throws BOSException, EASBizException {
        Hashtable table;
        IReportCacl reportCacl = ReportCaclFactory.getLocalInstance(ctx);
        String fiOrgUnit = param.getString("companyNumber");
        IObjectValue accVO = param.getDimension(BgDimensionEnum.ACCOUNT);
        if (accVO == null) {
            return null;
        }
        String acc = accVO.getString("number");
        if (acc == null) {
            return param;
        }
        BgCtrlData data = param.getData(BgElementEnum.AMT);
        OrgType orgType = (OrgType)param.get("bizOrgUnitType");
        if (orgType == null) {
            orgType = OrgType.Company;
        }
        if (data == null) {
            return param;
        }
        StringBuffer acctItem = new StringBuffer(256);
        acctItem.append(acc);
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        BOSUuid bizOrgId = param.getBizOrgUnitId();
        IFullOrgUnit org = FullOrgUnitFactory.getLocalInstance((Context)ctx);
        FullOrgUnitInfo bizOrgUnitInfo = null;
        if (ctx.get((Object)"BG_ACCT_BIZORG") == null) {
            table = new Hashtable();
            bizOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(bizOrgId));
            table.put(bizOrgId.toString(), bizOrgUnitInfo);
            ctx.put((Object)"BG_ACCT_BIZORG", (Object)table);
        } else {
            table = (Hashtable)ctx.get((Object)"BG_ACCT_BIZORG");
            if (table.get(bizOrgId.toString()) == null) {
                bizOrgUnitInfo = org.getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(bizOrgId));
                table.put(bizOrgId.toString(), bizOrgUnitInfo);
            } else {
                bizOrgUnitInfo = (FullOrgUnitInfo)table.get(bizOrgId.toString());
            }
        }
        AsstActTypeInfo asstAct = null;
        if (!bizOrgUnitInfo.isIsCompanyOrgUnit() && bizOrgUnitInfo.isIsCostOrgUnit() && !bizOrgUnitInfo.isIsCompanyOrgUnit() && (asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.COSTORG)) != null && asstAct.getNumber() != null) {
            acctItem.append("|");
            acctItem.append(asstAct.getNumber());
            acctItem.append("|");
            acctItem.append(param.getString("bizOrgUnitNumber"));
        }
        Map dim = param.getDimensions();
        for (BgDimensionEnum bgDim : dim.keySet()) {
            if (bgDim == BgDimensionEnum.ACCOUNT) continue;
            acctItem.append("|");
            if (bgDim != BgDimensionEnum.ACCOUNT) {
                if (bgDim == BgDimensionEnum.ORGANIZES_COSTCENTER && OrgType.Company.equals((Object)orgType)) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.COSTORG).getNumber());
                } else if (bgDim == BgDimensionEnum.MATERIAL) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.MATERIAL).getNumber());
                } else if (bgDim == BgDimensionEnum.PRODUCT) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.MATERIAL).getNumber());
                } else if (bgDim == BgDimensionEnum.BANKACCOUNT) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT).getNumber());
                } else if (bgDim == BgDimensionEnum.CASHFLOWITEM) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.CASHFLOW).getNumber());
                } else if (bgDim == BgDimensionEnum.CUSTOMER) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.CUSTOMER).getNumber());
                } else if (bgDim == BgDimensionEnum.FIXASSERT) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.MATERIAL).getNumber());
                } else if (bgDim == BgDimensionEnum.INDUSTRY) {
                    acctItem.append(asstActType.getAsstActType(AsstActTypeSysEnum.INDUSTRY).getNumber());
                } else {
                    throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{bgDim});
                }
            }
            acctItem.append("|");
            acctItem.append(param.getDimension(bgDim).getString("number"));
        }
        int startYear = param.getInt("beginyear");
        int startPeriod = param.getInt("beginnumber");
        int endYear = param.getInt("endyear");
        int endPeriod = param.getInt("endnumber");
        String currency = param.getString("currencyNumber");
        boolean includeVoucher = true;
        boolean checkDataRight = false;
        BigDecimal result = new BigDecimal("0");
        try {
            result = reportCacl.acct(fiOrgUnit, acctItem.toString(), BalanceTypeEnum.JF, startYear, startPeriod, endYear, endPeriod, currency, false, includeVoucher, checkDataRight).subtract(reportCacl.acct(fiOrgUnit, acctItem.toString(), BalanceTypeEnum.DF, startYear, startPeriod, endYear, endPeriod, currency, false, includeVoucher, checkDataRight));
        }
        catch (Exception exp) {
            logger.warn((Object)exp.toString());
        }
        param.getData(BgElementEnum.AMT).setValue(result);
        return param;
    }
}

